/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class FloatingNote
extends AbstractTextBlock
implements Stencil,
TextBlock {
    private final Opale opale;

    public FloatingNote(Display note, ISkinParam skinParam) {
        double shadowing;
        HColor borderColor;
        HColor noteBackgroundColor;
        FontConfiguration fc;
        LineBreakStrategy wrapWidth;
        Rose rose = new Rose();
        UStroke stroke = new UStroke();
        if (UseStyle.useBetaStyle()) {
            Style style = StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.note).getMergedStyle(skinParam.getCurrentStyleBuilder());
            wrapWidth = style.wrapWidth();
            fc = new FontConfiguration(skinParam, style);
            noteBackgroundColor = style.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
            borderColor = style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
            stroke = style.getStroke();
            shadowing = style.value(PName.Shadowing).asDouble();
        } else {
            shadowing = skinParam.shadowing(null) ? 4.0 : 0.0;
            noteBackgroundColor = rose.getHtmlColor(skinParam, ColorParam.noteBackground);
            borderColor = rose.getHtmlColor(skinParam, ColorParam.noteBorder);
            fc = new FontConfiguration(skinParam, FontParam.NOTE, null);
            wrapWidth = skinParam.wrapWidth();
        }
        Sheet sheet = Parser.build(fc, skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), skinParam, CreoleMode.FULL).createSheet(note);
        SheetBlock2 sheetBlock2 = new SheetBlock2(new SheetBlock1(sheet, wrapWidth, skinParam.getPadding()), this, stroke);
        this.opale = new Opale(shadowing, borderColor, noteBackgroundColor, sheetBlock2, false, stroke);
    }

    @Override
    public void drawU(UGraphic ug) {
        this.opale.drawU(ug);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.opale.calculateDimension(stringBounder);
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return -this.opale.getMarginX1();
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.opale.calculateDimension(stringBounder).getWidth() - (double)this.opale.getMarginX1();
    }
}

