/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.CanIgnoreReturnValue;
import ai.h2o.com.google.protobuf.CheckReturnValue;
import ai.h2o.com.google.protobuf.ExtensionRegistryLite;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.ManifestSchemaFactory;
import ai.h2o.com.google.protobuf.MessageSchema;
import ai.h2o.com.google.protobuf.Reader;
import ai.h2o.com.google.protobuf.Schema;
import ai.h2o.com.google.protobuf.SchemaFactory;
import ai.h2o.com.google.protobuf.Writer;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@CheckReturnValue
final class Protobuf {
    private static final Protobuf INSTANCE = new Protobuf();
    private final SchemaFactory schemaFactory;
    private final ConcurrentMap<Class<?>, Schema<?>> schemaCache = new ConcurrentHashMap();

    public static Protobuf getInstance() {
        return INSTANCE;
    }

    public final <T> void writeTo(T message, Writer writer) throws IOException {
        this.schemaFor(message).writeTo(message, writer);
    }

    public final <T> void mergeFrom(T message, Reader reader) throws IOException {
        this.mergeFrom(message, reader, ExtensionRegistryLite.getEmptyRegistry());
    }

    public final <T> void mergeFrom(T message, Reader reader, ExtensionRegistryLite extensionRegistry) throws IOException {
        this.schemaFor(message).mergeFrom(message, reader, extensionRegistry);
    }

    public final <T> void makeImmutable(T message) {
        this.schemaFor(message).makeImmutable(message);
    }

    final <T> boolean isInitialized(T message) {
        return this.schemaFor(message).isInitialized(message);
    }

    public final <T> Schema<T> schemaFor(Class<T> messageType) {
        Schema<?> schema;
        Internal.checkNotNull(messageType, "messageType");
        Schema<Object> schema2 = (Schema<T>)this.schemaCache.get(messageType);
        if (schema2 == null && (schema = this.registerSchema(messageType, schema2 = this.schemaFactory.createSchema(messageType))) != null) {
            schema2 = schema;
        }
        return schema2;
    }

    public final <T> Schema<T> schemaFor(T message) {
        return this.schemaFor((T)message.getClass());
    }

    public final Schema<?> registerSchema(Class<?> messageType, Schema<?> schema) {
        Internal.checkNotNull(messageType, "messageType");
        Internal.checkNotNull(schema, "schema");
        return this.schemaCache.putIfAbsent(messageType, schema);
    }

    @CanIgnoreReturnValue
    public final Schema<?> registerSchemaOverride(Class<?> messageType, Schema<?> schema) {
        Internal.checkNotNull(messageType, "messageType");
        Internal.checkNotNull(schema, "schema");
        return this.schemaCache.put(messageType, schema);
    }

    private Protobuf() {
        this.schemaFactory = new ManifestSchemaFactory();
    }

    final int getTotalSchemaSize() {
        int n2 = 0;
        for (Schema schema : this.schemaCache.values()) {
            if (!(schema instanceof MessageSchema)) continue;
            n2 += ((MessageSchema)schema).getSchemaSize();
        }
        return n2;
    }
}

