# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetApplicationResult',
    'AwaitableGetApplicationResult',
    'get_application',
    'get_application_output',
]

@pulumi.output_type
class GetApplicationResult:
    def __init__(__self__, application_code=None, application_description=None, id=None, inputs=None):
        if application_code and not isinstance(application_code, str):
            raise TypeError("Expected argument 'application_code' to be a str")
        pulumi.set(__self__, "application_code", application_code)
        if application_description and not isinstance(application_description, str):
            raise TypeError("Expected argument 'application_description' to be a str")
        pulumi.set(__self__, "application_description", application_description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inputs and not isinstance(inputs, list):
            raise TypeError("Expected argument 'inputs' to be a list")
        pulumi.set(__self__, "inputs", inputs)

    @property
    @pulumi.getter(name="applicationCode")
    def application_code(self) -> Optional[str]:
        return pulumi.get(self, "application_code")

    @property
    @pulumi.getter(name="applicationDescription")
    def application_description(self) -> Optional[str]:
        return pulumi.get(self, "application_description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def inputs(self) -> Optional[Sequence['outputs.ApplicationInput']]:
        return pulumi.get(self, "inputs")


class AwaitableGetApplicationResult(GetApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationResult(
            application_code=self.application_code,
            application_description=self.application_description,
            id=self.id,
            inputs=self.inputs)


def get_application(id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationResult:
    """
    Resource Type definition for AWS::KinesisAnalytics::Application
    """
    __args__ = dict()
    __args__['id'] = id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:kinesisanalytics:getApplication', __args__, opts=opts, typ=GetApplicationResult).value

    return AwaitableGetApplicationResult(
        application_code=__ret__.application_code,
        application_description=__ret__.application_description,
        id=__ret__.id,
        inputs=__ret__.inputs)


@_utilities.lift_output_func(get_application)
def get_application_output(id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetApplicationResult]:
    """
    Resource Type definition for AWS::KinesisAnalytics::Application
    """
    ...
