# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ConnectorApacheKafkaCluster',
    'ConnectorAutoScaling',
    'ConnectorCapacity',
    'ConnectorCloudWatchLogsLogDelivery',
    'ConnectorCustomPlugin',
    'ConnectorFirehoseLogDelivery',
    'ConnectorKafkaCluster',
    'ConnectorKafkaClusterClientAuthentication',
    'ConnectorKafkaClusterEncryptionInTransit',
    'ConnectorLogDelivery',
    'ConnectorPlugin',
    'ConnectorProvisionedCapacity',
    'ConnectorS3LogDelivery',
    'ConnectorScaleInPolicy',
    'ConnectorScaleOutPolicy',
    'ConnectorVpc',
    'ConnectorWorkerConfiguration',
    'ConnectorWorkerLogDelivery',
]

@pulumi.output_type
class ConnectorApacheKafkaCluster(dict):
    """
    Details of how to connect to an Apache Kafka cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootstrapServers":
            suggest = "bootstrap_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorApacheKafkaCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorApacheKafkaCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorApacheKafkaCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bootstrap_servers: str,
                 vpc: 'outputs.ConnectorVpc'):
        """
        Details of how to connect to an Apache Kafka cluster.
        :param str bootstrap_servers: The bootstrap servers string of the Apache Kafka cluster.
        """
        pulumi.set(__self__, "bootstrap_servers", bootstrap_servers)
        pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter(name="bootstrapServers")
    def bootstrap_servers(self) -> str:
        """
        The bootstrap servers string of the Apache Kafka cluster.
        """
        return pulumi.get(self, "bootstrap_servers")

    @property
    @pulumi.getter
    def vpc(self) -> 'outputs.ConnectorVpc':
        return pulumi.get(self, "vpc")


@pulumi.output_type
class ConnectorAutoScaling(dict):
    """
    Details about auto scaling of a connector. 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxWorkerCount":
            suggest = "max_worker_count"
        elif key == "mcuCount":
            suggest = "mcu_count"
        elif key == "minWorkerCount":
            suggest = "min_worker_count"
        elif key == "scaleInPolicy":
            suggest = "scale_in_policy"
        elif key == "scaleOutPolicy":
            suggest = "scale_out_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorAutoScaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorAutoScaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorAutoScaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_worker_count: int,
                 mcu_count: int,
                 min_worker_count: int,
                 scale_in_policy: 'outputs.ConnectorScaleInPolicy',
                 scale_out_policy: 'outputs.ConnectorScaleOutPolicy'):
        """
        Details about auto scaling of a connector. 
        :param int max_worker_count: The maximum number of workers for a connector.
        :param int mcu_count: Specifies how many MSK Connect Units (MCU) as the minimum scaling unit.
        :param int min_worker_count: The minimum number of workers for a connector.
        """
        pulumi.set(__self__, "max_worker_count", max_worker_count)
        pulumi.set(__self__, "mcu_count", mcu_count)
        pulumi.set(__self__, "min_worker_count", min_worker_count)
        pulumi.set(__self__, "scale_in_policy", scale_in_policy)
        pulumi.set(__self__, "scale_out_policy", scale_out_policy)

    @property
    @pulumi.getter(name="maxWorkerCount")
    def max_worker_count(self) -> int:
        """
        The maximum number of workers for a connector.
        """
        return pulumi.get(self, "max_worker_count")

    @property
    @pulumi.getter(name="mcuCount")
    def mcu_count(self) -> int:
        """
        Specifies how many MSK Connect Units (MCU) as the minimum scaling unit.
        """
        return pulumi.get(self, "mcu_count")

    @property
    @pulumi.getter(name="minWorkerCount")
    def min_worker_count(self) -> int:
        """
        The minimum number of workers for a connector.
        """
        return pulumi.get(self, "min_worker_count")

    @property
    @pulumi.getter(name="scaleInPolicy")
    def scale_in_policy(self) -> 'outputs.ConnectorScaleInPolicy':
        return pulumi.get(self, "scale_in_policy")

    @property
    @pulumi.getter(name="scaleOutPolicy")
    def scale_out_policy(self) -> 'outputs.ConnectorScaleOutPolicy':
        return pulumi.get(self, "scale_out_policy")


@pulumi.output_type
class ConnectorCapacity(dict):
    """
    Information about the capacity allocated to the connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoScaling":
            suggest = "auto_scaling"
        elif key == "provisionedCapacity":
            suggest = "provisioned_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorCapacity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorCapacity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorCapacity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_scaling: Optional['outputs.ConnectorAutoScaling'] = None,
                 provisioned_capacity: Optional['outputs.ConnectorProvisionedCapacity'] = None):
        """
        Information about the capacity allocated to the connector.
        """
        if auto_scaling is not None:
            pulumi.set(__self__, "auto_scaling", auto_scaling)
        if provisioned_capacity is not None:
            pulumi.set(__self__, "provisioned_capacity", provisioned_capacity)

    @property
    @pulumi.getter(name="autoScaling")
    def auto_scaling(self) -> Optional['outputs.ConnectorAutoScaling']:
        return pulumi.get(self, "auto_scaling")

    @property
    @pulumi.getter(name="provisionedCapacity")
    def provisioned_capacity(self) -> Optional['outputs.ConnectorProvisionedCapacity']:
        return pulumi.get(self, "provisioned_capacity")


@pulumi.output_type
class ConnectorCloudWatchLogsLogDelivery(dict):
    """
    Details about delivering logs to Amazon CloudWatch Logs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroup":
            suggest = "log_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorCloudWatchLogsLogDelivery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorCloudWatchLogsLogDelivery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorCloudWatchLogsLogDelivery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 log_group: Optional[str] = None):
        """
        Details about delivering logs to Amazon CloudWatch Logs.
        :param bool enabled: Specifies whether the logs get sent to the specified CloudWatch Logs destination.
        :param str log_group: The CloudWatch log group that is the destination for log delivery.
        """
        pulumi.set(__self__, "enabled", enabled)
        if log_group is not None:
            pulumi.set(__self__, "log_group", log_group)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Specifies whether the logs get sent to the specified CloudWatch Logs destination.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> Optional[str]:
        """
        The CloudWatch log group that is the destination for log delivery.
        """
        return pulumi.get(self, "log_group")


@pulumi.output_type
class ConnectorCustomPlugin(dict):
    """
    Details about a custom plugin.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customPluginArn":
            suggest = "custom_plugin_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorCustomPlugin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorCustomPlugin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorCustomPlugin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_plugin_arn: str,
                 revision: int):
        """
        Details about a custom plugin.
        :param str custom_plugin_arn: The Amazon Resource Name (ARN) of the custom plugin to use.
        :param int revision: The revision of the custom plugin to use.
        """
        pulumi.set(__self__, "custom_plugin_arn", custom_plugin_arn)
        pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter(name="customPluginArn")
    def custom_plugin_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the custom plugin to use.
        """
        return pulumi.get(self, "custom_plugin_arn")

    @property
    @pulumi.getter
    def revision(self) -> int:
        """
        The revision of the custom plugin to use.
        """
        return pulumi.get(self, "revision")


@pulumi.output_type
class ConnectorFirehoseLogDelivery(dict):
    """
    Details about delivering logs to Amazon Kinesis Data Firehose.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deliveryStream":
            suggest = "delivery_stream"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorFirehoseLogDelivery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorFirehoseLogDelivery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorFirehoseLogDelivery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 delivery_stream: Optional[str] = None):
        """
        Details about delivering logs to Amazon Kinesis Data Firehose.
        :param bool enabled: Specifies whether the logs get sent to the specified Kinesis Data Firehose delivery stream.
        :param str delivery_stream: The Kinesis Data Firehose delivery stream that is the destination for log delivery.
        """
        pulumi.set(__self__, "enabled", enabled)
        if delivery_stream is not None:
            pulumi.set(__self__, "delivery_stream", delivery_stream)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Specifies whether the logs get sent to the specified Kinesis Data Firehose delivery stream.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="deliveryStream")
    def delivery_stream(self) -> Optional[str]:
        """
        The Kinesis Data Firehose delivery stream that is the destination for log delivery.
        """
        return pulumi.get(self, "delivery_stream")


@pulumi.output_type
class ConnectorKafkaCluster(dict):
    """
    Details of how to connect to the Kafka cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apacheKafkaCluster":
            suggest = "apache_kafka_cluster"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorKafkaCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorKafkaCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorKafkaCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apache_kafka_cluster: 'outputs.ConnectorApacheKafkaCluster'):
        """
        Details of how to connect to the Kafka cluster.
        """
        pulumi.set(__self__, "apache_kafka_cluster", apache_kafka_cluster)

    @property
    @pulumi.getter(name="apacheKafkaCluster")
    def apache_kafka_cluster(self) -> 'outputs.ConnectorApacheKafkaCluster':
        return pulumi.get(self, "apache_kafka_cluster")


@pulumi.output_type
class ConnectorKafkaClusterClientAuthentication(dict):
    """
    Details of the client authentication used by the Kafka cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorKafkaClusterClientAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorKafkaClusterClientAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorKafkaClusterClientAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_type: 'ConnectorKafkaClusterClientAuthenticationType'):
        """
        Details of the client authentication used by the Kafka cluster.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> 'ConnectorKafkaClusterClientAuthenticationType':
        return pulumi.get(self, "authentication_type")


@pulumi.output_type
class ConnectorKafkaClusterEncryptionInTransit(dict):
    """
    Details of encryption in transit to the Kafka cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionType":
            suggest = "encryption_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorKafkaClusterEncryptionInTransit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorKafkaClusterEncryptionInTransit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorKafkaClusterEncryptionInTransit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_type: 'ConnectorKafkaClusterEncryptionInTransitType'):
        """
        Details of encryption in transit to the Kafka cluster.
        """
        pulumi.set(__self__, "encryption_type", encryption_type)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> 'ConnectorKafkaClusterEncryptionInTransitType':
        return pulumi.get(self, "encryption_type")


@pulumi.output_type
class ConnectorLogDelivery(dict):
    """
    Details of what logs are delivered and where they are delivered.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workerLogDelivery":
            suggest = "worker_log_delivery"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorLogDelivery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorLogDelivery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorLogDelivery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 worker_log_delivery: 'outputs.ConnectorWorkerLogDelivery'):
        """
        Details of what logs are delivered and where they are delivered.
        """
        pulumi.set(__self__, "worker_log_delivery", worker_log_delivery)

    @property
    @pulumi.getter(name="workerLogDelivery")
    def worker_log_delivery(self) -> 'outputs.ConnectorWorkerLogDelivery':
        return pulumi.get(self, "worker_log_delivery")


@pulumi.output_type
class ConnectorPlugin(dict):
    """
    Details about a Kafka Connect plugin which will be used with the connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customPlugin":
            suggest = "custom_plugin"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorPlugin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorPlugin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorPlugin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_plugin: 'outputs.ConnectorCustomPlugin'):
        """
        Details about a Kafka Connect plugin which will be used with the connector.
        """
        pulumi.set(__self__, "custom_plugin", custom_plugin)

    @property
    @pulumi.getter(name="customPlugin")
    def custom_plugin(self) -> 'outputs.ConnectorCustomPlugin':
        return pulumi.get(self, "custom_plugin")


@pulumi.output_type
class ConnectorProvisionedCapacity(dict):
    """
    Details about a fixed capacity allocated to a connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workerCount":
            suggest = "worker_count"
        elif key == "mcuCount":
            suggest = "mcu_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProvisionedCapacity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProvisionedCapacity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProvisionedCapacity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 worker_count: int,
                 mcu_count: Optional[int] = None):
        """
        Details about a fixed capacity allocated to a connector.
        :param int worker_count: Number of workers for a connector.
        :param int mcu_count: Specifies how many MSK Connect Units (MCU) are allocated to the connector.
        """
        pulumi.set(__self__, "worker_count", worker_count)
        if mcu_count is not None:
            pulumi.set(__self__, "mcu_count", mcu_count)

    @property
    @pulumi.getter(name="workerCount")
    def worker_count(self) -> int:
        """
        Number of workers for a connector.
        """
        return pulumi.get(self, "worker_count")

    @property
    @pulumi.getter(name="mcuCount")
    def mcu_count(self) -> Optional[int]:
        """
        Specifies how many MSK Connect Units (MCU) are allocated to the connector.
        """
        return pulumi.get(self, "mcu_count")


@pulumi.output_type
class ConnectorS3LogDelivery(dict):
    """
    Details about delivering logs to Amazon S3.
    """
    def __init__(__self__, *,
                 enabled: bool,
                 bucket: Optional[str] = None,
                 prefix: Optional[str] = None):
        """
        Details about delivering logs to Amazon S3.
        :param bool enabled: Specifies whether the logs get sent to the specified Amazon S3 destination.
        :param str bucket: The name of the S3 bucket that is the destination for log delivery.
        :param str prefix: The S3 prefix that is the destination for log delivery.
        """
        pulumi.set(__self__, "enabled", enabled)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Specifies whether the logs get sent to the specified Amazon S3 destination.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        The name of the S3 bucket that is the destination for log delivery.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        The S3 prefix that is the destination for log delivery.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class ConnectorScaleInPolicy(dict):
    """
    Information about the scale in policy of the connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuUtilizationPercentage":
            suggest = "cpu_utilization_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorScaleInPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorScaleInPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorScaleInPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_utilization_percentage: int):
        """
        Information about the scale in policy of the connector.
        :param int cpu_utilization_percentage: Specifies the CPU utilization percentage threshold at which connector scale in should trigger.
        """
        pulumi.set(__self__, "cpu_utilization_percentage", cpu_utilization_percentage)

    @property
    @pulumi.getter(name="cpuUtilizationPercentage")
    def cpu_utilization_percentage(self) -> int:
        """
        Specifies the CPU utilization percentage threshold at which connector scale in should trigger.
        """
        return pulumi.get(self, "cpu_utilization_percentage")


@pulumi.output_type
class ConnectorScaleOutPolicy(dict):
    """
    Information about the scale out policy of the connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuUtilizationPercentage":
            suggest = "cpu_utilization_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorScaleOutPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorScaleOutPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorScaleOutPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_utilization_percentage: int):
        """
        Information about the scale out policy of the connector.
        :param int cpu_utilization_percentage: Specifies the CPU utilization percentage threshold at which connector scale out should trigger.
        """
        pulumi.set(__self__, "cpu_utilization_percentage", cpu_utilization_percentage)

    @property
    @pulumi.getter(name="cpuUtilizationPercentage")
    def cpu_utilization_percentage(self) -> int:
        """
        Specifies the CPU utilization percentage threshold at which connector scale out should trigger.
        """
        return pulumi.get(self, "cpu_utilization_percentage")


@pulumi.output_type
class ConnectorVpc(dict):
    """
    Information about a VPC used with the connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroups":
            suggest = "security_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorVpc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorVpc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorVpc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_groups: Sequence[str],
                 subnets: Sequence[str]):
        """
        Information about a VPC used with the connector.
        :param Sequence[str] security_groups: The AWS security groups to associate with the elastic network interfaces in order to specify what the connector has access to.
        :param Sequence[str] subnets: The list of subnets to connect to in the virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets.
        """
        pulumi.set(__self__, "security_groups", security_groups)
        pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Sequence[str]:
        """
        The AWS security groups to associate with the elastic network interfaces in order to specify what the connector has access to.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        """
        The list of subnets to connect to in the virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets.
        """
        return pulumi.get(self, "subnets")


@pulumi.output_type
class ConnectorWorkerConfiguration(dict):
    """
    Specifies the worker configuration to use with the connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workerConfigurationArn":
            suggest = "worker_configuration_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorWorkerConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorWorkerConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorWorkerConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 revision: int,
                 worker_configuration_arn: str):
        """
        Specifies the worker configuration to use with the connector.
        :param int revision: The revision of the worker configuration to use.
        :param str worker_configuration_arn: The Amazon Resource Name (ARN) of the worker configuration to use.
        """
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "worker_configuration_arn", worker_configuration_arn)

    @property
    @pulumi.getter
    def revision(self) -> int:
        """
        The revision of the worker configuration to use.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter(name="workerConfigurationArn")
    def worker_configuration_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the worker configuration to use.
        """
        return pulumi.get(self, "worker_configuration_arn")


@pulumi.output_type
class ConnectorWorkerLogDelivery(dict):
    """
    Specifies where worker logs are delivered.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatchLogs":
            suggest = "cloud_watch_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorWorkerLogDelivery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorWorkerLogDelivery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorWorkerLogDelivery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch_logs: Optional['outputs.ConnectorCloudWatchLogsLogDelivery'] = None,
                 firehose: Optional['outputs.ConnectorFirehoseLogDelivery'] = None,
                 s3: Optional['outputs.ConnectorS3LogDelivery'] = None):
        """
        Specifies where worker logs are delivered.
        """
        if cloud_watch_logs is not None:
            pulumi.set(__self__, "cloud_watch_logs", cloud_watch_logs)
        if firehose is not None:
            pulumi.set(__self__, "firehose", firehose)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter(name="cloudWatchLogs")
    def cloud_watch_logs(self) -> Optional['outputs.ConnectorCloudWatchLogsLogDelivery']:
        return pulumi.get(self, "cloud_watch_logs")

    @property
    @pulumi.getter
    def firehose(self) -> Optional['outputs.ConnectorFirehoseLogDelivery']:
        return pulumi.get(self, "firehose")

    @property
    @pulumi.getter
    def s3(self) -> Optional['outputs.ConnectorS3LogDelivery']:
        return pulumi.get(self, "s3")


