# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['WirelessDeviceArgs', 'WirelessDevice']

@pulumi.input_type
class WirelessDeviceArgs:
    def __init__(__self__, *,
                 destination_name: pulumi.Input[str],
                 type: pulumi.Input['WirelessDeviceType'],
                 description: Optional[pulumi.Input[str]] = None,
                 last_uplink_received_at: Optional[pulumi.Input[str]] = None,
                 lo_ra_wan: Optional[pulumi.Input['WirelessDeviceLoRaWANDeviceArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessDeviceTagArgs']]]] = None,
                 thing_arn: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a WirelessDevice resource.
        :param pulumi.Input[str] destination_name: Wireless device destination name
        :param pulumi.Input['WirelessDeviceType'] type: Wireless device type, currently only Sidewalk and LoRa
        :param pulumi.Input[str] description: Wireless device description
        :param pulumi.Input[str] last_uplink_received_at: The date and time when the most recent uplink was received.
        :param pulumi.Input['WirelessDeviceLoRaWANDeviceArgs'] lo_ra_wan: The combination of Package, Station and Model which represents the version of the LoRaWAN Wireless Device.
        :param pulumi.Input[str] name: Wireless device name
        :param pulumi.Input[Sequence[pulumi.Input['WirelessDeviceTagArgs']]] tags: A list of key-value pairs that contain metadata for the device. Currently not supported, will not create if tags are passed.
        :param pulumi.Input[str] thing_arn: Thing arn. Passed into update to associate Thing with Wireless device.
        """
        pulumi.set(__self__, "destination_name", destination_name)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if last_uplink_received_at is not None:
            pulumi.set(__self__, "last_uplink_received_at", last_uplink_received_at)
        if lo_ra_wan is not None:
            pulumi.set(__self__, "lo_ra_wan", lo_ra_wan)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if thing_arn is not None:
            pulumi.set(__self__, "thing_arn", thing_arn)

    @property
    @pulumi.getter(name="destinationName")
    def destination_name(self) -> pulumi.Input[str]:
        """
        Wireless device destination name
        """
        return pulumi.get(self, "destination_name")

    @destination_name.setter
    def destination_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['WirelessDeviceType']:
        """
        Wireless device type, currently only Sidewalk and LoRa
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['WirelessDeviceType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Wireless device description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="lastUplinkReceivedAt")
    def last_uplink_received_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time when the most recent uplink was received.
        """
        return pulumi.get(self, "last_uplink_received_at")

    @last_uplink_received_at.setter
    def last_uplink_received_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_uplink_received_at", value)

    @property
    @pulumi.getter(name="loRaWAN")
    def lo_ra_wan(self) -> Optional[pulumi.Input['WirelessDeviceLoRaWANDeviceArgs']]:
        """
        The combination of Package, Station and Model which represents the version of the LoRaWAN Wireless Device.
        """
        return pulumi.get(self, "lo_ra_wan")

    @lo_ra_wan.setter
    def lo_ra_wan(self, value: Optional[pulumi.Input['WirelessDeviceLoRaWANDeviceArgs']]):
        pulumi.set(self, "lo_ra_wan", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Wireless device name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WirelessDeviceTagArgs']]]]:
        """
        A list of key-value pairs that contain metadata for the device. Currently not supported, will not create if tags are passed.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessDeviceTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="thingArn")
    def thing_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Thing arn. Passed into update to associate Thing with Wireless device.
        """
        return pulumi.get(self, "thing_arn")

    @thing_arn.setter
    def thing_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "thing_arn", value)


class WirelessDevice(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_name: Optional[pulumi.Input[str]] = None,
                 last_uplink_received_at: Optional[pulumi.Input[str]] = None,
                 lo_ra_wan: Optional[pulumi.Input[pulumi.InputType['WirelessDeviceLoRaWANDeviceArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WirelessDeviceTagArgs']]]]] = None,
                 thing_arn: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input['WirelessDeviceType']] = None,
                 __props__=None):
        """
        Create and manage wireless gateways, including LoRa gateways.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Wireless device description
        :param pulumi.Input[str] destination_name: Wireless device destination name
        :param pulumi.Input[str] last_uplink_received_at: The date and time when the most recent uplink was received.
        :param pulumi.Input[pulumi.InputType['WirelessDeviceLoRaWANDeviceArgs']] lo_ra_wan: The combination of Package, Station and Model which represents the version of the LoRaWAN Wireless Device.
        :param pulumi.Input[str] name: Wireless device name
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WirelessDeviceTagArgs']]]] tags: A list of key-value pairs that contain metadata for the device. Currently not supported, will not create if tags are passed.
        :param pulumi.Input[str] thing_arn: Thing arn. Passed into update to associate Thing with Wireless device.
        :param pulumi.Input['WirelessDeviceType'] type: Wireless device type, currently only Sidewalk and LoRa
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WirelessDeviceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create and manage wireless gateways, including LoRa gateways.

        :param str resource_name: The name of the resource.
        :param WirelessDeviceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WirelessDeviceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_name: Optional[pulumi.Input[str]] = None,
                 last_uplink_received_at: Optional[pulumi.Input[str]] = None,
                 lo_ra_wan: Optional[pulumi.Input[pulumi.InputType['WirelessDeviceLoRaWANDeviceArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WirelessDeviceTagArgs']]]]] = None,
                 thing_arn: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input['WirelessDeviceType']] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WirelessDeviceArgs.__new__(WirelessDeviceArgs)

            __props__.__dict__["description"] = description
            if destination_name is None and not opts.urn:
                raise TypeError("Missing required property 'destination_name'")
            __props__.__dict__["destination_name"] = destination_name
            __props__.__dict__["last_uplink_received_at"] = last_uplink_received_at
            __props__.__dict__["lo_ra_wan"] = lo_ra_wan
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["thing_arn"] = thing_arn
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["arn"] = None
            __props__.__dict__["thing_name"] = None
        super(WirelessDevice, __self__).__init__(
            'aws-native:iotwireless:WirelessDevice',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'WirelessDevice':
        """
        Get an existing WirelessDevice resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = WirelessDeviceArgs.__new__(WirelessDeviceArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["destination_name"] = None
        __props__.__dict__["last_uplink_received_at"] = None
        __props__.__dict__["lo_ra_wan"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["thing_arn"] = None
        __props__.__dict__["thing_name"] = None
        __props__.__dict__["type"] = None
        return WirelessDevice(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Wireless device arn. Returned after successful create.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Wireless device description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationName")
    def destination_name(self) -> pulumi.Output[str]:
        """
        Wireless device destination name
        """
        return pulumi.get(self, "destination_name")

    @property
    @pulumi.getter(name="lastUplinkReceivedAt")
    def last_uplink_received_at(self) -> pulumi.Output[Optional[str]]:
        """
        The date and time when the most recent uplink was received.
        """
        return pulumi.get(self, "last_uplink_received_at")

    @property
    @pulumi.getter(name="loRaWAN")
    def lo_ra_wan(self) -> pulumi.Output[Optional['outputs.WirelessDeviceLoRaWANDevice']]:
        """
        The combination of Package, Station and Model which represents the version of the LoRaWAN Wireless Device.
        """
        return pulumi.get(self, "lo_ra_wan")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        Wireless device name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.WirelessDeviceTag']]]:
        """
        A list of key-value pairs that contain metadata for the device. Currently not supported, will not create if tags are passed.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="thingArn")
    def thing_arn(self) -> pulumi.Output[Optional[str]]:
        """
        Thing arn. Passed into update to associate Thing with Wireless device.
        """
        return pulumi.get(self, "thing_arn")

    @property
    @pulumi.getter(name="thingName")
    def thing_name(self) -> pulumi.Output[str]:
        """
        Thing Arn. If there is a Thing created, this can be returned with a Get call.
        """
        return pulumi.get(self, "thing_name")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output['WirelessDeviceType']:
        """
        Wireless device type, currently only Sidewalk and LoRa
        """
        return pulumi.get(self, "type")

