# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'FileSystemAuditLogConfiguration',
    'FileSystemClientConfigurations',
    'FileSystemDiskIopsConfiguration',
    'FileSystemLustreConfiguration',
    'FileSystemNfsExports',
    'FileSystemOntapConfiguration',
    'FileSystemOpenZFSConfiguration',
    'FileSystemRootVolumeConfiguration',
    'FileSystemSelfManagedActiveDirectoryConfiguration',
    'FileSystemTag',
    'FileSystemUserAndGroupQuotas',
    'FileSystemWindowsConfiguration',
    'SnapshotTag',
    'StorageVirtualMachineActiveDirectoryConfiguration',
    'StorageVirtualMachineSelfManagedActiveDirectoryConfiguration',
    'StorageVirtualMachineTag',
    'VolumeClientConfigurations',
    'VolumeNfsExports',
    'VolumeOntapConfiguration',
    'VolumeOpenZFSConfiguration',
    'VolumeOriginSnapshot',
    'VolumeTag',
    'VolumeTieringPolicy',
    'VolumeUserAndGroupQuotas',
]

@pulumi.output_type
class FileSystemAuditLogConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileAccessAuditLogLevel":
            suggest = "file_access_audit_log_level"
        elif key == "fileShareAccessAuditLogLevel":
            suggest = "file_share_access_audit_log_level"
        elif key == "auditLogDestination":
            suggest = "audit_log_destination"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSystemAuditLogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSystemAuditLogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSystemAuditLogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_access_audit_log_level: str,
                 file_share_access_audit_log_level: str,
                 audit_log_destination: Optional[str] = None):
        pulumi.set(__self__, "file_access_audit_log_level", file_access_audit_log_level)
        pulumi.set(__self__, "file_share_access_audit_log_level", file_share_access_audit_log_level)
        if audit_log_destination is not None:
            pulumi.set(__self__, "audit_log_destination", audit_log_destination)

    @property
    @pulumi.getter(name="fileAccessAuditLogLevel")
    def file_access_audit_log_level(self) -> str:
        return pulumi.get(self, "file_access_audit_log_level")

    @property
    @pulumi.getter(name="fileShareAccessAuditLogLevel")
    def file_share_access_audit_log_level(self) -> str:
        return pulumi.get(self, "file_share_access_audit_log_level")

    @property
    @pulumi.getter(name="auditLogDestination")
    def audit_log_destination(self) -> Optional[str]:
        return pulumi.get(self, "audit_log_destination")


@pulumi.output_type
class FileSystemClientConfigurations(dict):
    def __init__(__self__, *,
                 clients: Optional[str] = None,
                 options: Optional[Sequence[str]] = None):
        if clients is not None:
            pulumi.set(__self__, "clients", clients)
        if options is not None:
            pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def clients(self) -> Optional[str]:
        return pulumi.get(self, "clients")

    @property
    @pulumi.getter
    def options(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "options")


@pulumi.output_type
class FileSystemDiskIopsConfiguration(dict):
    def __init__(__self__, *,
                 iops: Optional[int] = None,
                 mode: Optional[str] = None):
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        return pulumi.get(self, "mode")


@pulumi.output_type
class FileSystemLustreConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoImportPolicy":
            suggest = "auto_import_policy"
        elif key == "automaticBackupRetentionDays":
            suggest = "automatic_backup_retention_days"
        elif key == "copyTagsToBackups":
            suggest = "copy_tags_to_backups"
        elif key == "dailyAutomaticBackupStartTime":
            suggest = "daily_automatic_backup_start_time"
        elif key == "dataCompressionType":
            suggest = "data_compression_type"
        elif key == "deploymentType":
            suggest = "deployment_type"
        elif key == "driveCacheType":
            suggest = "drive_cache_type"
        elif key == "exportPath":
            suggest = "export_path"
        elif key == "importPath":
            suggest = "import_path"
        elif key == "importedFileChunkSize":
            suggest = "imported_file_chunk_size"
        elif key == "perUnitStorageThroughput":
            suggest = "per_unit_storage_throughput"
        elif key == "weeklyMaintenanceStartTime":
            suggest = "weekly_maintenance_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSystemLustreConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSystemLustreConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSystemLustreConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_import_policy: Optional[str] = None,
                 automatic_backup_retention_days: Optional[int] = None,
                 copy_tags_to_backups: Optional[bool] = None,
                 daily_automatic_backup_start_time: Optional[str] = None,
                 data_compression_type: Optional[str] = None,
                 deployment_type: Optional[str] = None,
                 drive_cache_type: Optional[str] = None,
                 export_path: Optional[str] = None,
                 import_path: Optional[str] = None,
                 imported_file_chunk_size: Optional[int] = None,
                 per_unit_storage_throughput: Optional[int] = None,
                 weekly_maintenance_start_time: Optional[str] = None):
        if auto_import_policy is not None:
            pulumi.set(__self__, "auto_import_policy", auto_import_policy)
        if automatic_backup_retention_days is not None:
            pulumi.set(__self__, "automatic_backup_retention_days", automatic_backup_retention_days)
        if copy_tags_to_backups is not None:
            pulumi.set(__self__, "copy_tags_to_backups", copy_tags_to_backups)
        if daily_automatic_backup_start_time is not None:
            pulumi.set(__self__, "daily_automatic_backup_start_time", daily_automatic_backup_start_time)
        if data_compression_type is not None:
            pulumi.set(__self__, "data_compression_type", data_compression_type)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if drive_cache_type is not None:
            pulumi.set(__self__, "drive_cache_type", drive_cache_type)
        if export_path is not None:
            pulumi.set(__self__, "export_path", export_path)
        if import_path is not None:
            pulumi.set(__self__, "import_path", import_path)
        if imported_file_chunk_size is not None:
            pulumi.set(__self__, "imported_file_chunk_size", imported_file_chunk_size)
        if per_unit_storage_throughput is not None:
            pulumi.set(__self__, "per_unit_storage_throughput", per_unit_storage_throughput)
        if weekly_maintenance_start_time is not None:
            pulumi.set(__self__, "weekly_maintenance_start_time", weekly_maintenance_start_time)

    @property
    @pulumi.getter(name="autoImportPolicy")
    def auto_import_policy(self) -> Optional[str]:
        return pulumi.get(self, "auto_import_policy")

    @property
    @pulumi.getter(name="automaticBackupRetentionDays")
    def automatic_backup_retention_days(self) -> Optional[int]:
        return pulumi.get(self, "automatic_backup_retention_days")

    @property
    @pulumi.getter(name="copyTagsToBackups")
    def copy_tags_to_backups(self) -> Optional[bool]:
        return pulumi.get(self, "copy_tags_to_backups")

    @property
    @pulumi.getter(name="dailyAutomaticBackupStartTime")
    def daily_automatic_backup_start_time(self) -> Optional[str]:
        return pulumi.get(self, "daily_automatic_backup_start_time")

    @property
    @pulumi.getter(name="dataCompressionType")
    def data_compression_type(self) -> Optional[str]:
        return pulumi.get(self, "data_compression_type")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[str]:
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="driveCacheType")
    def drive_cache_type(self) -> Optional[str]:
        return pulumi.get(self, "drive_cache_type")

    @property
    @pulumi.getter(name="exportPath")
    def export_path(self) -> Optional[str]:
        return pulumi.get(self, "export_path")

    @property
    @pulumi.getter(name="importPath")
    def import_path(self) -> Optional[str]:
        return pulumi.get(self, "import_path")

    @property
    @pulumi.getter(name="importedFileChunkSize")
    def imported_file_chunk_size(self) -> Optional[int]:
        return pulumi.get(self, "imported_file_chunk_size")

    @property
    @pulumi.getter(name="perUnitStorageThroughput")
    def per_unit_storage_throughput(self) -> Optional[int]:
        return pulumi.get(self, "per_unit_storage_throughput")

    @property
    @pulumi.getter(name="weeklyMaintenanceStartTime")
    def weekly_maintenance_start_time(self) -> Optional[str]:
        return pulumi.get(self, "weekly_maintenance_start_time")


@pulumi.output_type
class FileSystemNfsExports(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientConfigurations":
            suggest = "client_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSystemNfsExports. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSystemNfsExports.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSystemNfsExports.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_configurations: Optional[Sequence['outputs.FileSystemClientConfigurations']] = None):
        if client_configurations is not None:
            pulumi.set(__self__, "client_configurations", client_configurations)

    @property
    @pulumi.getter(name="clientConfigurations")
    def client_configurations(self) -> Optional[Sequence['outputs.FileSystemClientConfigurations']]:
        return pulumi.get(self, "client_configurations")


@pulumi.output_type
class FileSystemOntapConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentType":
            suggest = "deployment_type"
        elif key == "automaticBackupRetentionDays":
            suggest = "automatic_backup_retention_days"
        elif key == "dailyAutomaticBackupStartTime":
            suggest = "daily_automatic_backup_start_time"
        elif key == "diskIopsConfiguration":
            suggest = "disk_iops_configuration"
        elif key == "endpointIpAddressRange":
            suggest = "endpoint_ip_address_range"
        elif key == "fsxAdminPassword":
            suggest = "fsx_admin_password"
        elif key == "preferredSubnetId":
            suggest = "preferred_subnet_id"
        elif key == "routeTableIds":
            suggest = "route_table_ids"
        elif key == "throughputCapacity":
            suggest = "throughput_capacity"
        elif key == "weeklyMaintenanceStartTime":
            suggest = "weekly_maintenance_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSystemOntapConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSystemOntapConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSystemOntapConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployment_type: str,
                 automatic_backup_retention_days: Optional[int] = None,
                 daily_automatic_backup_start_time: Optional[str] = None,
                 disk_iops_configuration: Optional['outputs.FileSystemDiskIopsConfiguration'] = None,
                 endpoint_ip_address_range: Optional[str] = None,
                 fsx_admin_password: Optional[str] = None,
                 preferred_subnet_id: Optional[str] = None,
                 route_table_ids: Optional[Sequence[str]] = None,
                 throughput_capacity: Optional[int] = None,
                 weekly_maintenance_start_time: Optional[str] = None):
        pulumi.set(__self__, "deployment_type", deployment_type)
        if automatic_backup_retention_days is not None:
            pulumi.set(__self__, "automatic_backup_retention_days", automatic_backup_retention_days)
        if daily_automatic_backup_start_time is not None:
            pulumi.set(__self__, "daily_automatic_backup_start_time", daily_automatic_backup_start_time)
        if disk_iops_configuration is not None:
            pulumi.set(__self__, "disk_iops_configuration", disk_iops_configuration)
        if endpoint_ip_address_range is not None:
            pulumi.set(__self__, "endpoint_ip_address_range", endpoint_ip_address_range)
        if fsx_admin_password is not None:
            pulumi.set(__self__, "fsx_admin_password", fsx_admin_password)
        if preferred_subnet_id is not None:
            pulumi.set(__self__, "preferred_subnet_id", preferred_subnet_id)
        if route_table_ids is not None:
            pulumi.set(__self__, "route_table_ids", route_table_ids)
        if throughput_capacity is not None:
            pulumi.set(__self__, "throughput_capacity", throughput_capacity)
        if weekly_maintenance_start_time is not None:
            pulumi.set(__self__, "weekly_maintenance_start_time", weekly_maintenance_start_time)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="automaticBackupRetentionDays")
    def automatic_backup_retention_days(self) -> Optional[int]:
        return pulumi.get(self, "automatic_backup_retention_days")

    @property
    @pulumi.getter(name="dailyAutomaticBackupStartTime")
    def daily_automatic_backup_start_time(self) -> Optional[str]:
        return pulumi.get(self, "daily_automatic_backup_start_time")

    @property
    @pulumi.getter(name="diskIopsConfiguration")
    def disk_iops_configuration(self) -> Optional['outputs.FileSystemDiskIopsConfiguration']:
        return pulumi.get(self, "disk_iops_configuration")

    @property
    @pulumi.getter(name="endpointIpAddressRange")
    def endpoint_ip_address_range(self) -> Optional[str]:
        return pulumi.get(self, "endpoint_ip_address_range")

    @property
    @pulumi.getter(name="fsxAdminPassword")
    def fsx_admin_password(self) -> Optional[str]:
        return pulumi.get(self, "fsx_admin_password")

    @property
    @pulumi.getter(name="preferredSubnetId")
    def preferred_subnet_id(self) -> Optional[str]:
        return pulumi.get(self, "preferred_subnet_id")

    @property
    @pulumi.getter(name="routeTableIds")
    def route_table_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "route_table_ids")

    @property
    @pulumi.getter(name="throughputCapacity")
    def throughput_capacity(self) -> Optional[int]:
        return pulumi.get(self, "throughput_capacity")

    @property
    @pulumi.getter(name="weeklyMaintenanceStartTime")
    def weekly_maintenance_start_time(self) -> Optional[str]:
        return pulumi.get(self, "weekly_maintenance_start_time")


@pulumi.output_type
class FileSystemOpenZFSConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentType":
            suggest = "deployment_type"
        elif key == "automaticBackupRetentionDays":
            suggest = "automatic_backup_retention_days"
        elif key == "copyTagsToBackups":
            suggest = "copy_tags_to_backups"
        elif key == "copyTagsToVolumes":
            suggest = "copy_tags_to_volumes"
        elif key == "dailyAutomaticBackupStartTime":
            suggest = "daily_automatic_backup_start_time"
        elif key == "diskIopsConfiguration":
            suggest = "disk_iops_configuration"
        elif key == "rootVolumeConfiguration":
            suggest = "root_volume_configuration"
        elif key == "throughputCapacity":
            suggest = "throughput_capacity"
        elif key == "weeklyMaintenanceStartTime":
            suggest = "weekly_maintenance_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSystemOpenZFSConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSystemOpenZFSConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSystemOpenZFSConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployment_type: str,
                 automatic_backup_retention_days: Optional[int] = None,
                 copy_tags_to_backups: Optional[bool] = None,
                 copy_tags_to_volumes: Optional[bool] = None,
                 daily_automatic_backup_start_time: Optional[str] = None,
                 disk_iops_configuration: Optional['outputs.FileSystemDiskIopsConfiguration'] = None,
                 options: Optional[Sequence[str]] = None,
                 root_volume_configuration: Optional['outputs.FileSystemRootVolumeConfiguration'] = None,
                 throughput_capacity: Optional[int] = None,
                 weekly_maintenance_start_time: Optional[str] = None):
        pulumi.set(__self__, "deployment_type", deployment_type)
        if automatic_backup_retention_days is not None:
            pulumi.set(__self__, "automatic_backup_retention_days", automatic_backup_retention_days)
        if copy_tags_to_backups is not None:
            pulumi.set(__self__, "copy_tags_to_backups", copy_tags_to_backups)
        if copy_tags_to_volumes is not None:
            pulumi.set(__self__, "copy_tags_to_volumes", copy_tags_to_volumes)
        if daily_automatic_backup_start_time is not None:
            pulumi.set(__self__, "daily_automatic_backup_start_time", daily_automatic_backup_start_time)
        if disk_iops_configuration is not None:
            pulumi.set(__self__, "disk_iops_configuration", disk_iops_configuration)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if root_volume_configuration is not None:
            pulumi.set(__self__, "root_volume_configuration", root_volume_configuration)
        if throughput_capacity is not None:
            pulumi.set(__self__, "throughput_capacity", throughput_capacity)
        if weekly_maintenance_start_time is not None:
            pulumi.set(__self__, "weekly_maintenance_start_time", weekly_maintenance_start_time)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="automaticBackupRetentionDays")
    def automatic_backup_retention_days(self) -> Optional[int]:
        return pulumi.get(self, "automatic_backup_retention_days")

    @property
    @pulumi.getter(name="copyTagsToBackups")
    def copy_tags_to_backups(self) -> Optional[bool]:
        return pulumi.get(self, "copy_tags_to_backups")

    @property
    @pulumi.getter(name="copyTagsToVolumes")
    def copy_tags_to_volumes(self) -> Optional[bool]:
        return pulumi.get(self, "copy_tags_to_volumes")

    @property
    @pulumi.getter(name="dailyAutomaticBackupStartTime")
    def daily_automatic_backup_start_time(self) -> Optional[str]:
        return pulumi.get(self, "daily_automatic_backup_start_time")

    @property
    @pulumi.getter(name="diskIopsConfiguration")
    def disk_iops_configuration(self) -> Optional['outputs.FileSystemDiskIopsConfiguration']:
        return pulumi.get(self, "disk_iops_configuration")

    @property
    @pulumi.getter
    def options(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="rootVolumeConfiguration")
    def root_volume_configuration(self) -> Optional['outputs.FileSystemRootVolumeConfiguration']:
        return pulumi.get(self, "root_volume_configuration")

    @property
    @pulumi.getter(name="throughputCapacity")
    def throughput_capacity(self) -> Optional[int]:
        return pulumi.get(self, "throughput_capacity")

    @property
    @pulumi.getter(name="weeklyMaintenanceStartTime")
    def weekly_maintenance_start_time(self) -> Optional[str]:
        return pulumi.get(self, "weekly_maintenance_start_time")


@pulumi.output_type
class FileSystemRootVolumeConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "copyTagsToSnapshots":
            suggest = "copy_tags_to_snapshots"
        elif key == "dataCompressionType":
            suggest = "data_compression_type"
        elif key == "nfsExports":
            suggest = "nfs_exports"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "recordSizeKiB":
            suggest = "record_size_ki_b"
        elif key == "userAndGroupQuotas":
            suggest = "user_and_group_quotas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSystemRootVolumeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSystemRootVolumeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSystemRootVolumeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 copy_tags_to_snapshots: Optional[bool] = None,
                 data_compression_type: Optional[str] = None,
                 nfs_exports: Optional[Sequence['outputs.FileSystemNfsExports']] = None,
                 read_only: Optional[bool] = None,
                 record_size_ki_b: Optional[int] = None,
                 user_and_group_quotas: Optional[Sequence['outputs.FileSystemUserAndGroupQuotas']] = None):
        if copy_tags_to_snapshots is not None:
            pulumi.set(__self__, "copy_tags_to_snapshots", copy_tags_to_snapshots)
        if data_compression_type is not None:
            pulumi.set(__self__, "data_compression_type", data_compression_type)
        if nfs_exports is not None:
            pulumi.set(__self__, "nfs_exports", nfs_exports)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if record_size_ki_b is not None:
            pulumi.set(__self__, "record_size_ki_b", record_size_ki_b)
        if user_and_group_quotas is not None:
            pulumi.set(__self__, "user_and_group_quotas", user_and_group_quotas)

    @property
    @pulumi.getter(name="copyTagsToSnapshots")
    def copy_tags_to_snapshots(self) -> Optional[bool]:
        return pulumi.get(self, "copy_tags_to_snapshots")

    @property
    @pulumi.getter(name="dataCompressionType")
    def data_compression_type(self) -> Optional[str]:
        return pulumi.get(self, "data_compression_type")

    @property
    @pulumi.getter(name="nfsExports")
    def nfs_exports(self) -> Optional[Sequence['outputs.FileSystemNfsExports']]:
        return pulumi.get(self, "nfs_exports")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[bool]:
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="recordSizeKiB")
    def record_size_ki_b(self) -> Optional[int]:
        return pulumi.get(self, "record_size_ki_b")

    @property
    @pulumi.getter(name="userAndGroupQuotas")
    def user_and_group_quotas(self) -> Optional[Sequence['outputs.FileSystemUserAndGroupQuotas']]:
        return pulumi.get(self, "user_and_group_quotas")


@pulumi.output_type
class FileSystemSelfManagedActiveDirectoryConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsIps":
            suggest = "dns_ips"
        elif key == "domainName":
            suggest = "domain_name"
        elif key == "fileSystemAdministratorsGroup":
            suggest = "file_system_administrators_group"
        elif key == "organizationalUnitDistinguishedName":
            suggest = "organizational_unit_distinguished_name"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSystemSelfManagedActiveDirectoryConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSystemSelfManagedActiveDirectoryConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSystemSelfManagedActiveDirectoryConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_ips: Optional[Sequence[str]] = None,
                 domain_name: Optional[str] = None,
                 file_system_administrators_group: Optional[str] = None,
                 organizational_unit_distinguished_name: Optional[str] = None,
                 password: Optional[str] = None,
                 user_name: Optional[str] = None):
        if dns_ips is not None:
            pulumi.set(__self__, "dns_ips", dns_ips)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if file_system_administrators_group is not None:
            pulumi.set(__self__, "file_system_administrators_group", file_system_administrators_group)
        if organizational_unit_distinguished_name is not None:
            pulumi.set(__self__, "organizational_unit_distinguished_name", organizational_unit_distinguished_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="dnsIps")
    def dns_ips(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "dns_ips")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[str]:
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="fileSystemAdministratorsGroup")
    def file_system_administrators_group(self) -> Optional[str]:
        return pulumi.get(self, "file_system_administrators_group")

    @property
    @pulumi.getter(name="organizationalUnitDistinguishedName")
    def organizational_unit_distinguished_name(self) -> Optional[str]:
        return pulumi.get(self, "organizational_unit_distinguished_name")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[str]:
        return pulumi.get(self, "user_name")


@pulumi.output_type
class FileSystemTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class FileSystemUserAndGroupQuotas(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageCapacityQuotaGiB":
            suggest = "storage_capacity_quota_gi_b"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSystemUserAndGroupQuotas. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSystemUserAndGroupQuotas.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSystemUserAndGroupQuotas.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[int] = None,
                 storage_capacity_quota_gi_b: Optional[int] = None,
                 type: Optional[str] = None):
        if id is not None:
            pulumi.set(__self__, "id", id)
        if storage_capacity_quota_gi_b is not None:
            pulumi.set(__self__, "storage_capacity_quota_gi_b", storage_capacity_quota_gi_b)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[int]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="storageCapacityQuotaGiB")
    def storage_capacity_quota_gi_b(self) -> Optional[int]:
        return pulumi.get(self, "storage_capacity_quota_gi_b")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class FileSystemWindowsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "throughputCapacity":
            suggest = "throughput_capacity"
        elif key == "activeDirectoryId":
            suggest = "active_directory_id"
        elif key == "auditLogConfiguration":
            suggest = "audit_log_configuration"
        elif key == "automaticBackupRetentionDays":
            suggest = "automatic_backup_retention_days"
        elif key == "copyTagsToBackups":
            suggest = "copy_tags_to_backups"
        elif key == "dailyAutomaticBackupStartTime":
            suggest = "daily_automatic_backup_start_time"
        elif key == "deploymentType":
            suggest = "deployment_type"
        elif key == "preferredSubnetId":
            suggest = "preferred_subnet_id"
        elif key == "selfManagedActiveDirectoryConfiguration":
            suggest = "self_managed_active_directory_configuration"
        elif key == "weeklyMaintenanceStartTime":
            suggest = "weekly_maintenance_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSystemWindowsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSystemWindowsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSystemWindowsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 throughput_capacity: int,
                 active_directory_id: Optional[str] = None,
                 aliases: Optional[Sequence[str]] = None,
                 audit_log_configuration: Optional['outputs.FileSystemAuditLogConfiguration'] = None,
                 automatic_backup_retention_days: Optional[int] = None,
                 copy_tags_to_backups: Optional[bool] = None,
                 daily_automatic_backup_start_time: Optional[str] = None,
                 deployment_type: Optional[str] = None,
                 preferred_subnet_id: Optional[str] = None,
                 self_managed_active_directory_configuration: Optional['outputs.FileSystemSelfManagedActiveDirectoryConfiguration'] = None,
                 weekly_maintenance_start_time: Optional[str] = None):
        pulumi.set(__self__, "throughput_capacity", throughput_capacity)
        if active_directory_id is not None:
            pulumi.set(__self__, "active_directory_id", active_directory_id)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if audit_log_configuration is not None:
            pulumi.set(__self__, "audit_log_configuration", audit_log_configuration)
        if automatic_backup_retention_days is not None:
            pulumi.set(__self__, "automatic_backup_retention_days", automatic_backup_retention_days)
        if copy_tags_to_backups is not None:
            pulumi.set(__self__, "copy_tags_to_backups", copy_tags_to_backups)
        if daily_automatic_backup_start_time is not None:
            pulumi.set(__self__, "daily_automatic_backup_start_time", daily_automatic_backup_start_time)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if preferred_subnet_id is not None:
            pulumi.set(__self__, "preferred_subnet_id", preferred_subnet_id)
        if self_managed_active_directory_configuration is not None:
            pulumi.set(__self__, "self_managed_active_directory_configuration", self_managed_active_directory_configuration)
        if weekly_maintenance_start_time is not None:
            pulumi.set(__self__, "weekly_maintenance_start_time", weekly_maintenance_start_time)

    @property
    @pulumi.getter(name="throughputCapacity")
    def throughput_capacity(self) -> int:
        return pulumi.get(self, "throughput_capacity")

    @property
    @pulumi.getter(name="activeDirectoryId")
    def active_directory_id(self) -> Optional[str]:
        return pulumi.get(self, "active_directory_id")

    @property
    @pulumi.getter
    def aliases(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "aliases")

    @property
    @pulumi.getter(name="auditLogConfiguration")
    def audit_log_configuration(self) -> Optional['outputs.FileSystemAuditLogConfiguration']:
        return pulumi.get(self, "audit_log_configuration")

    @property
    @pulumi.getter(name="automaticBackupRetentionDays")
    def automatic_backup_retention_days(self) -> Optional[int]:
        return pulumi.get(self, "automatic_backup_retention_days")

    @property
    @pulumi.getter(name="copyTagsToBackups")
    def copy_tags_to_backups(self) -> Optional[bool]:
        return pulumi.get(self, "copy_tags_to_backups")

    @property
    @pulumi.getter(name="dailyAutomaticBackupStartTime")
    def daily_automatic_backup_start_time(self) -> Optional[str]:
        return pulumi.get(self, "daily_automatic_backup_start_time")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[str]:
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="preferredSubnetId")
    def preferred_subnet_id(self) -> Optional[str]:
        return pulumi.get(self, "preferred_subnet_id")

    @property
    @pulumi.getter(name="selfManagedActiveDirectoryConfiguration")
    def self_managed_active_directory_configuration(self) -> Optional['outputs.FileSystemSelfManagedActiveDirectoryConfiguration']:
        return pulumi.get(self, "self_managed_active_directory_configuration")

    @property
    @pulumi.getter(name="weeklyMaintenanceStartTime")
    def weekly_maintenance_start_time(self) -> Optional[str]:
        return pulumi.get(self, "weekly_maintenance_start_time")


@pulumi.output_type
class SnapshotTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class StorageVirtualMachineActiveDirectoryConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "netBiosName":
            suggest = "net_bios_name"
        elif key == "selfManagedActiveDirectoryConfiguration":
            suggest = "self_managed_active_directory_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageVirtualMachineActiveDirectoryConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageVirtualMachineActiveDirectoryConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageVirtualMachineActiveDirectoryConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 net_bios_name: Optional[str] = None,
                 self_managed_active_directory_configuration: Optional['outputs.StorageVirtualMachineSelfManagedActiveDirectoryConfiguration'] = None):
        if net_bios_name is not None:
            pulumi.set(__self__, "net_bios_name", net_bios_name)
        if self_managed_active_directory_configuration is not None:
            pulumi.set(__self__, "self_managed_active_directory_configuration", self_managed_active_directory_configuration)

    @property
    @pulumi.getter(name="netBiosName")
    def net_bios_name(self) -> Optional[str]:
        return pulumi.get(self, "net_bios_name")

    @property
    @pulumi.getter(name="selfManagedActiveDirectoryConfiguration")
    def self_managed_active_directory_configuration(self) -> Optional['outputs.StorageVirtualMachineSelfManagedActiveDirectoryConfiguration']:
        return pulumi.get(self, "self_managed_active_directory_configuration")


@pulumi.output_type
class StorageVirtualMachineSelfManagedActiveDirectoryConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsIps":
            suggest = "dns_ips"
        elif key == "domainName":
            suggest = "domain_name"
        elif key == "fileSystemAdministratorsGroup":
            suggest = "file_system_administrators_group"
        elif key == "organizationalUnitDistinguishedName":
            suggest = "organizational_unit_distinguished_name"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageVirtualMachineSelfManagedActiveDirectoryConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageVirtualMachineSelfManagedActiveDirectoryConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageVirtualMachineSelfManagedActiveDirectoryConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_ips: Optional[Sequence[str]] = None,
                 domain_name: Optional[str] = None,
                 file_system_administrators_group: Optional[str] = None,
                 organizational_unit_distinguished_name: Optional[str] = None,
                 password: Optional[str] = None,
                 user_name: Optional[str] = None):
        if dns_ips is not None:
            pulumi.set(__self__, "dns_ips", dns_ips)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if file_system_administrators_group is not None:
            pulumi.set(__self__, "file_system_administrators_group", file_system_administrators_group)
        if organizational_unit_distinguished_name is not None:
            pulumi.set(__self__, "organizational_unit_distinguished_name", organizational_unit_distinguished_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="dnsIps")
    def dns_ips(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "dns_ips")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[str]:
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="fileSystemAdministratorsGroup")
    def file_system_administrators_group(self) -> Optional[str]:
        return pulumi.get(self, "file_system_administrators_group")

    @property
    @pulumi.getter(name="organizationalUnitDistinguishedName")
    def organizational_unit_distinguished_name(self) -> Optional[str]:
        return pulumi.get(self, "organizational_unit_distinguished_name")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[str]:
        return pulumi.get(self, "user_name")


@pulumi.output_type
class StorageVirtualMachineTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class VolumeClientConfigurations(dict):
    def __init__(__self__, *,
                 clients: str,
                 options: Sequence[str]):
        pulumi.set(__self__, "clients", clients)
        pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def clients(self) -> str:
        return pulumi.get(self, "clients")

    @property
    @pulumi.getter
    def options(self) -> Sequence[str]:
        return pulumi.get(self, "options")


@pulumi.output_type
class VolumeNfsExports(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientConfigurations":
            suggest = "client_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeNfsExports. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeNfsExports.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeNfsExports.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_configurations: Sequence['outputs.VolumeClientConfigurations']):
        pulumi.set(__self__, "client_configurations", client_configurations)

    @property
    @pulumi.getter(name="clientConfigurations")
    def client_configurations(self) -> Sequence['outputs.VolumeClientConfigurations']:
        return pulumi.get(self, "client_configurations")


@pulumi.output_type
class VolumeOntapConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "junctionPath":
            suggest = "junction_path"
        elif key == "sizeInMegabytes":
            suggest = "size_in_megabytes"
        elif key == "storageEfficiencyEnabled":
            suggest = "storage_efficiency_enabled"
        elif key == "storageVirtualMachineId":
            suggest = "storage_virtual_machine_id"
        elif key == "securityStyle":
            suggest = "security_style"
        elif key == "tieringPolicy":
            suggest = "tiering_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeOntapConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeOntapConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeOntapConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 junction_path: str,
                 size_in_megabytes: str,
                 storage_efficiency_enabled: str,
                 storage_virtual_machine_id: str,
                 security_style: Optional[str] = None,
                 tiering_policy: Optional['outputs.VolumeTieringPolicy'] = None):
        pulumi.set(__self__, "junction_path", junction_path)
        pulumi.set(__self__, "size_in_megabytes", size_in_megabytes)
        pulumi.set(__self__, "storage_efficiency_enabled", storage_efficiency_enabled)
        pulumi.set(__self__, "storage_virtual_machine_id", storage_virtual_machine_id)
        if security_style is not None:
            pulumi.set(__self__, "security_style", security_style)
        if tiering_policy is not None:
            pulumi.set(__self__, "tiering_policy", tiering_policy)

    @property
    @pulumi.getter(name="junctionPath")
    def junction_path(self) -> str:
        return pulumi.get(self, "junction_path")

    @property
    @pulumi.getter(name="sizeInMegabytes")
    def size_in_megabytes(self) -> str:
        return pulumi.get(self, "size_in_megabytes")

    @property
    @pulumi.getter(name="storageEfficiencyEnabled")
    def storage_efficiency_enabled(self) -> str:
        return pulumi.get(self, "storage_efficiency_enabled")

    @property
    @pulumi.getter(name="storageVirtualMachineId")
    def storage_virtual_machine_id(self) -> str:
        return pulumi.get(self, "storage_virtual_machine_id")

    @property
    @pulumi.getter(name="securityStyle")
    def security_style(self) -> Optional[str]:
        return pulumi.get(self, "security_style")

    @property
    @pulumi.getter(name="tieringPolicy")
    def tiering_policy(self) -> Optional['outputs.VolumeTieringPolicy']:
        return pulumi.get(self, "tiering_policy")


@pulumi.output_type
class VolumeOpenZFSConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parentVolumeId":
            suggest = "parent_volume_id"
        elif key == "copyTagsToSnapshots":
            suggest = "copy_tags_to_snapshots"
        elif key == "dataCompressionType":
            suggest = "data_compression_type"
        elif key == "nfsExports":
            suggest = "nfs_exports"
        elif key == "originSnapshot":
            suggest = "origin_snapshot"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "recordSizeKiB":
            suggest = "record_size_ki_b"
        elif key == "storageCapacityQuotaGiB":
            suggest = "storage_capacity_quota_gi_b"
        elif key == "storageCapacityReservationGiB":
            suggest = "storage_capacity_reservation_gi_b"
        elif key == "userAndGroupQuotas":
            suggest = "user_and_group_quotas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeOpenZFSConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeOpenZFSConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeOpenZFSConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parent_volume_id: str,
                 copy_tags_to_snapshots: Optional[bool] = None,
                 data_compression_type: Optional[str] = None,
                 nfs_exports: Optional[Sequence['outputs.VolumeNfsExports']] = None,
                 options: Optional[Sequence[str]] = None,
                 origin_snapshot: Optional['outputs.VolumeOriginSnapshot'] = None,
                 read_only: Optional[bool] = None,
                 record_size_ki_b: Optional[int] = None,
                 storage_capacity_quota_gi_b: Optional[int] = None,
                 storage_capacity_reservation_gi_b: Optional[int] = None,
                 user_and_group_quotas: Optional[Sequence['outputs.VolumeUserAndGroupQuotas']] = None):
        pulumi.set(__self__, "parent_volume_id", parent_volume_id)
        if copy_tags_to_snapshots is not None:
            pulumi.set(__self__, "copy_tags_to_snapshots", copy_tags_to_snapshots)
        if data_compression_type is not None:
            pulumi.set(__self__, "data_compression_type", data_compression_type)
        if nfs_exports is not None:
            pulumi.set(__self__, "nfs_exports", nfs_exports)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if origin_snapshot is not None:
            pulumi.set(__self__, "origin_snapshot", origin_snapshot)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if record_size_ki_b is not None:
            pulumi.set(__self__, "record_size_ki_b", record_size_ki_b)
        if storage_capacity_quota_gi_b is not None:
            pulumi.set(__self__, "storage_capacity_quota_gi_b", storage_capacity_quota_gi_b)
        if storage_capacity_reservation_gi_b is not None:
            pulumi.set(__self__, "storage_capacity_reservation_gi_b", storage_capacity_reservation_gi_b)
        if user_and_group_quotas is not None:
            pulumi.set(__self__, "user_and_group_quotas", user_and_group_quotas)

    @property
    @pulumi.getter(name="parentVolumeId")
    def parent_volume_id(self) -> str:
        return pulumi.get(self, "parent_volume_id")

    @property
    @pulumi.getter(name="copyTagsToSnapshots")
    def copy_tags_to_snapshots(self) -> Optional[bool]:
        return pulumi.get(self, "copy_tags_to_snapshots")

    @property
    @pulumi.getter(name="dataCompressionType")
    def data_compression_type(self) -> Optional[str]:
        return pulumi.get(self, "data_compression_type")

    @property
    @pulumi.getter(name="nfsExports")
    def nfs_exports(self) -> Optional[Sequence['outputs.VolumeNfsExports']]:
        return pulumi.get(self, "nfs_exports")

    @property
    @pulumi.getter
    def options(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="originSnapshot")
    def origin_snapshot(self) -> Optional['outputs.VolumeOriginSnapshot']:
        return pulumi.get(self, "origin_snapshot")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[bool]:
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="recordSizeKiB")
    def record_size_ki_b(self) -> Optional[int]:
        return pulumi.get(self, "record_size_ki_b")

    @property
    @pulumi.getter(name="storageCapacityQuotaGiB")
    def storage_capacity_quota_gi_b(self) -> Optional[int]:
        return pulumi.get(self, "storage_capacity_quota_gi_b")

    @property
    @pulumi.getter(name="storageCapacityReservationGiB")
    def storage_capacity_reservation_gi_b(self) -> Optional[int]:
        return pulumi.get(self, "storage_capacity_reservation_gi_b")

    @property
    @pulumi.getter(name="userAndGroupQuotas")
    def user_and_group_quotas(self) -> Optional[Sequence['outputs.VolumeUserAndGroupQuotas']]:
        return pulumi.get(self, "user_and_group_quotas")


@pulumi.output_type
class VolumeOriginSnapshot(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "copyStrategy":
            suggest = "copy_strategy"
        elif key == "snapshotARN":
            suggest = "snapshot_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeOriginSnapshot. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeOriginSnapshot.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeOriginSnapshot.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 copy_strategy: str,
                 snapshot_arn: str):
        pulumi.set(__self__, "copy_strategy", copy_strategy)
        pulumi.set(__self__, "snapshot_arn", snapshot_arn)

    @property
    @pulumi.getter(name="copyStrategy")
    def copy_strategy(self) -> str:
        return pulumi.get(self, "copy_strategy")

    @property
    @pulumi.getter(name="snapshotARN")
    def snapshot_arn(self) -> str:
        return pulumi.get(self, "snapshot_arn")


@pulumi.output_type
class VolumeTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class VolumeTieringPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coolingPeriod":
            suggest = "cooling_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeTieringPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeTieringPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeTieringPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cooling_period: Optional[int] = None,
                 name: Optional[str] = None):
        if cooling_period is not None:
            pulumi.set(__self__, "cooling_period", cooling_period)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="coolingPeriod")
    def cooling_period(self) -> Optional[int]:
        return pulumi.get(self, "cooling_period")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class VolumeUserAndGroupQuotas(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageCapacityQuotaGiB":
            suggest = "storage_capacity_quota_gi_b"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeUserAndGroupQuotas. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeUserAndGroupQuotas.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeUserAndGroupQuotas.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: int,
                 storage_capacity_quota_gi_b: int,
                 type: str):
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "storage_capacity_quota_gi_b", storage_capacity_quota_gi_b)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> int:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="storageCapacityQuotaGiB")
    def storage_capacity_quota_gi_b(self) -> int:
        return pulumi.get(self, "storage_capacity_quota_gi_b")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


