"use strict";(self.webpackChunkjupyterlab_tabular_data_viewer_extension=self.webpackChunkjupyterlab_tabular_data_viewer_extension||[]).push([[129],{129:(t,e,s)=>{s.r(e),s.d(e,{default:()=>_});var a=s(561),i=s(560),n=s(256),o=s(297),r=s(860);async function l(t="",e={}){const s=r.ServerConnection.makeSettings(),a=o.URLExt.join(s.baseUrl,"jupyterlab-tabular-data-viewer-extension",t);let i;try{i=await r.ServerConnection.makeRequest(a,e,s)}catch(t){throw new r.ServerConnection.NetworkError(t)}let n=await i.text();if(n.length>0)try{n=JSON.parse(n)}catch(t){console.log("Not a JSON response body.",i)}if(!i.ok)throw new r.ServerConnection.ResponseError(i,n.message||n);return n}class c extends n.Widget{constructor(t){super(),this._stats=t,this.addClass("jp-ColumnStatsModal"),this._render(),this._setupEventListeners()}_render(){const t=document.createElement("div");t.className="jp-ColumnStatsModal-content";const e=document.createElement("div");e.className="jp-ColumnStatsModal-header";const s=document.createElement("h3");s.textContent=`Column: ${this._stats.column_name}`;const a=document.createElement("button");a.className="jp-ColumnStatsModal-close",a.textContent="×",a.onclick=()=>this.close(),e.appendChild(s),e.appendChild(a),t.appendChild(e);const i=document.createElement("div");i.className="jp-ColumnStatsModal-copy";const n=document.createElement("button");n.className="jp-ColumnStatsModal-copyButton",n.textContent="Copy Stats as JSON",n.onclick=()=>this._copyStatsAsJson(),i.appendChild(n),t.appendChild(i);const o=document.createElement("div");o.className="jp-ColumnStatsModal-type",o.textContent=`Type: ${this._stats.data_type}`,t.appendChild(o);const r=document.createElement("div");r.className="jp-ColumnStatsModal-section";const l=document.createElement("h4");l.textContent="Data Summary",r.appendChild(l);const c=document.createElement("ul");if(c.innerHTML=`\n      <li>Total rows: ${this._formatNumber(this._stats.total_rows)}</li>\n      <li>Non-null: ${this._formatNumber(this._stats.non_null_count)} (${this._stats.non_null_percentage}%)</li>\n      <li>Null: ${this._formatNumber(this._stats.null_count)} (${this._stats.null_percentage}%)</li>\n      <li>Unique values: ${this._formatNumber(this._stats.unique_count)} (${this._stats.unique_percentage}%)</li>\n    `,r.appendChild(c),t.appendChild(r),"int"===this._stats.data_type||"float"===this._stats.data_type){const e=document.createElement("div");e.className="jp-ColumnStatsModal-section";const s=document.createElement("h4");s.textContent="Numeric Statistics",e.appendChild(s);const a=document.createElement("ul"),i=[];void 0!==this._stats.min_value&&i.push(`Min: ${this._formatNumber(this._stats.min_value)}`),void 0!==this._stats.max_value&&i.push(`Max: ${this._formatNumber(this._stats.max_value)}`),void 0!==this._stats.mean&&i.push(`Mean: ${this._formatNumber(this._stats.mean)}`),void 0!==this._stats.median&&i.push(`Median: ${this._formatNumber(this._stats.median)}`),void 0!==this._stats.std_dev&&i.push(`Std Dev: ${this._formatNumber(this._stats.std_dev)}`),void 0!==this._stats.outlier_count&&i.push(`Outliers (IQR×1.5): ${this._formatNumber(this._stats.outlier_count)} (${this._stats.outlier_percentage}%)`),a.innerHTML=i.map(t=>`<li>${t}</li>`).join(""),e.appendChild(a),t.appendChild(e)}if("string"===this._stats.data_type){const e=[];if(void 0!==this._stats.most_common_value&&e.push(`Most common: "${this._stats.most_common_value}" (${this._stats.most_common_count})`),void 0!==this._stats.min_length&&e.push(`Min length: ${this._stats.min_length} characters`),void 0!==this._stats.max_length&&e.push(`Max length: ${this._stats.max_length} characters`),void 0!==this._stats.avg_length&&e.push(`Avg length: ${this._formatNumber(this._stats.avg_length)} characters`),e.length>0){const s=document.createElement("div");s.className="jp-ColumnStatsModal-section";const a=document.createElement("h4");a.textContent="String Statistics",s.appendChild(a);const i=document.createElement("ul");i.innerHTML=e.map(t=>`<li>${t}</li>`).join(""),s.appendChild(i),t.appendChild(s)}}if("date"===this._stats.data_type||"datetime"===this._stats.data_type){const e=document.createElement("div");e.className="jp-ColumnStatsModal-section";const s=document.createElement("h4");s.textContent="Date Range",e.appendChild(s);const a=document.createElement("ul"),i=[];this._stats.earliest_date&&i.push(`Earliest: ${this._stats.earliest_date}`),this._stats.latest_date&&i.push(`Latest: ${this._stats.latest_date}`),void 0!==this._stats.date_range_days&&i.push(`Span: ${this._formatNumber(this._stats.date_range_days)} days`),a.innerHTML=i.map(t=>`<li>${t}</li>`).join(""),e.appendChild(a),t.appendChild(e)}this.node.appendChild(t)}_formatNumber(t){return t.toLocaleString(void 0,{maximumFractionDigits:2})}async _copyStatsAsJson(){try{const t=JSON.stringify(this._stats,null,2);await navigator.clipboard.writeText(t);const e=this.node.querySelector(".jp-ColumnStatsModal-copyButton");if(e){const t=e.textContent;e.textContent="Copied!",setTimeout(()=>{e.textContent=t},2e3)}}catch(t){console.error("Failed to copy stats to clipboard:",t)}}_setupEventListeners(){const t=t=>{"Escape"===t.key&&this.close()};document.addEventListener("keydown",t),this.disposed.connect(()=>{document.removeEventListener("keydown",t)}),this.node.addEventListener("click",t=>{t.target===this.node&&this.close()})}show(){n.Widget.attach(this,document.body),this.node.focus()}close(){this.dispose()}}class d extends n.Widget{constructor(t,e){super(),this._columns=[],this._data=[],this._totalRows=0,this._unfilteredTotalRows=0,this._currentOffset=0,this._limit=500,this._loading=!1,this._hasMore=!0,this._filters={},this._sortBy=null,this._sortOrder="asc",this._fileSize=0,this._caseInsensitive=!1,this._useRegex=!1,this._contextMenuOpen=!1,this._columnWidths=new Map,this._resizing=null,this._cleanupHighlight=null,this._menuObserver=null,this._doResize=t=>{if(!this._resizing)return;const e=t.clientX-this._resizing.startX,s=Math.max(80,this._resizing.startWidth+e);this._columnWidths.set(this._resizing.columnName,s);const a=this._columns.findIndex(t=>t.name===this._resizing.columnName);if(-1!==a){const t=this._headerRow.children[a],e=this._filterRow.children[a];t&&(t.style.width=`${s}px`),e&&(e.style.width=`${s}px`);const i=Array.from(this._columnWidths.values()).reduce((t,e)=>t+e,0);this._table.style.width=`${i}px`}},this._stopResize=()=>{this._resizing&&(this._resizing=null,document.removeEventListener("mousemove",this._doResize),document.removeEventListener("mouseup",this._stopResize),document.body.style.userSelect="",document.body.style.cursor="")},this._filePath=t,this._setLastContextMenuRow=e,this.addClass("jp-TabularDataViewer"),this._tableContainer=document.createElement("div"),this._tableContainer.className="jp-TabularDataViewer-container",this._table=document.createElement("table"),this._table.className="jp-TabularDataViewer-table",this._thead=document.createElement("thead"),this._thead.className="jp-TabularDataViewer-thead",this._tbody=document.createElement("tbody"),this._tbody.className="jp-TabularDataViewer-tbody",this._filterRow=document.createElement("tr"),this._filterRow.className="jp-TabularDataViewer-filterRow",this._headerRow=document.createElement("tr"),this._headerRow.className="jp-TabularDataViewer-headerRow",this._thead.appendChild(this._filterRow),this._thead.appendChild(this._headerRow),this._table.appendChild(this._thead),this._table.appendChild(this._tbody),this._tableContainer.appendChild(this._table),this._statusBar=document.createElement("div"),this._statusBar.className="jp-TabularDataViewer-statusBar",this._statusLeft=document.createElement("div"),this._statusLeft.className="jp-TabularDataViewer-statusLeft";const s=document.createElement("div");s.className="jp-TabularDataViewer-statusMiddle";const a=document.createElement("label");a.className="jp-TabularDataViewer-caseInsensitiveLabel",this._caseInsensitiveCheckbox=document.createElement("input"),this._caseInsensitiveCheckbox.type="checkbox",this._caseInsensitiveCheckbox.className="jp-TabularDataViewer-caseInsensitiveCheckbox",this._caseInsensitiveCheckbox.checked=this._caseInsensitive,this._caseInsensitiveCheckbox.addEventListener("change",()=>{this._caseInsensitive=this._caseInsensitiveCheckbox.checked,this._loadData(!0)});const i=document.createElement("span");i.textContent=" Case insensitive",a.appendChild(this._caseInsensitiveCheckbox),a.appendChild(i),s.appendChild(a);const n=document.createElement("label");n.className="jp-TabularDataViewer-regexLabel",this._regexCheckbox=document.createElement("input"),this._regexCheckbox.type="checkbox",this._regexCheckbox.className="jp-TabularDataViewer-regexCheckbox",this._regexCheckbox.checked=this._useRegex,this._regexCheckbox.addEventListener("change",()=>{this._useRegex=this._regexCheckbox.checked,this._loadData(!0)});const o=document.createElement("span");o.textContent=" Use regex",n.appendChild(this._regexCheckbox),n.appendChild(o),s.appendChild(n),this._statusRight=document.createElement("div"),this._statusRight.className="jp-TabularDataViewer-statusRight",this._statusBar.appendChild(this._statusLeft),this._statusBar.appendChild(s),this._statusBar.appendChild(this._statusRight),this.node.appendChild(this._tableContainer),this.node.appendChild(this._statusBar),this._tableContainer.addEventListener("scroll",()=>{this._onScroll()}),this._cleanupHighlight=()=>{this._contextMenuOpen=!1,this._tbody.classList.remove("jp-TabularDataViewer-context-menu-open"),this._tbody.querySelectorAll("tr").forEach(t=>{t.classList.remove("jp-TabularDataViewer-row-context-active")}),this._menuObserver&&(this._menuObserver.disconnect(),this._menuObserver=null)},this._initialize()}_startMenuObserver(){this._menuObserver&&this._menuObserver.disconnect(),this._menuObserver=new MutationObserver(t=>{for(const e of t)if("childList"===e.type&&e.removedNodes.length>0)for(const t of Array.from(e.removedNodes))if(t instanceof HTMLElement&&(t.classList.contains("lm-Menu")||t.classList.contains("p-Menu")))return void(this._cleanupHighlight&&this._cleanupHighlight())}),this._menuObserver.observe(document.body,{childList:!0,subtree:!1})}getCleanupHighlight(){return this._cleanupHighlight||(()=>{})}async _initialize(){try{await this._loadMetadata(),await this._loadData(!0)}catch(t){this._showError(`Failed to load file: ${t}`)}}async _loadMetadata(){const t=await l("metadata",{method:"POST",body:JSON.stringify({path:this._filePath})});this._columns=t.columns,this._totalRows=t.totalRows,this._unfilteredTotalRows=t.totalRows,this._fileSize=t.fileSize||0,this._renderHeaders(),this._updateStatusBar()}async _loadData(t=!1){if(!this._loading){this._loading=!0,this._updateStatusBar("Loading...");try{t&&(this._currentOffset=0,this._data=[],this._tbody.innerHTML="");const e=await l("data",{method:"POST",body:JSON.stringify({path:this._filePath,offset:this._currentOffset,limit:this._limit,filters:this._filters,sortBy:this._sortBy,sortOrder:this._sortOrder,caseInsensitive:this._caseInsensitive,useRegex:this._useRegex})});this._data=this._data.concat(e.data),this._hasMore=e.hasMore,this._currentOffset+=e.data.length,t&&(this._totalRows=e.totalRows),this._renderData(e.data),this._updateStatusBar()}catch(t){this._showError(`Failed to load data: ${t}`)}finally{this._loading=!1}}}_renderHeaders(){this._filterRow.innerHTML="",this._headerRow.innerHTML="",this._columns.forEach(t=>{const e=document.createElement("th");e.className="jp-TabularDataViewer-filterCell";const s=document.createElement("input");s.type="text",s.className="jp-TabularDataViewer-filterInput",s.placeholder=this._getFilterPlaceholder(t.type),s.dataset.columnName=t.name,s.dataset.columnType=t.type,s.addEventListener("keyup",e=>{"Enter"===e.key&&this._applyFilter(t.name,s.value,t.type)}),e.appendChild(s),this._filterRow.appendChild(e);const a=document.createElement("th");a.className="jp-TabularDataViewer-headerCell",a.style.cursor="pointer",a.dataset.columnName=t.name,a.addEventListener("click",()=>{this._toggleSort(t.name)});const i=document.createElement("div");i.className="jp-TabularDataViewer-headerContent";const n=document.createElement("div");n.className="jp-TabularDataViewer-columnName",n.textContent=t.name;const o=document.createElement("span");o.className="jp-TabularDataViewer-infoIcon",o.textContent="🛈",o.title="Show column statistics",o.addEventListener("click",async e=>{e.preventDefault(),e.stopPropagation(),await this._showColumnStats(t.name)}),n.appendChild(o);const r=document.createElement("div");r.className="jp-TabularDataViewer-columnType",r.textContent=this._simplifyType(t.type);const l=document.createElement("span");l.className="jp-TabularDataViewer-sortIndicator",l.textContent="",i.appendChild(n),i.appendChild(r),a.appendChild(i),a.appendChild(l);const c=document.createElement("div");c.className="jp-TabularDataViewer-resizeHandle",c.addEventListener("mousedown",e=>{e.preventDefault(),e.stopPropagation(),this._startResize(t.name,e.clientX,a)}),c.addEventListener("click",t=>{t.preventDefault(),t.stopPropagation()}),a.appendChild(c);const d=this._columnWidths.get(t.name)||200;this._columnWidths.has(t.name)||this._columnWidths.set(t.name,d),a.style.width=`${d}px`,e.style.width=`${d}px`,this._headerRow.appendChild(a)});const t=Array.from(this._columnWidths.values()).reduce((t,e)=>t+e,0);this._table.style.width=`${t}px`}_renderData(t){t.forEach(t=>{const e=document.createElement("tr");e.className="jp-TabularDataViewer-row",this._columns.forEach(s=>{const a=document.createElement("td");a.className="jp-TabularDataViewer-cell";const i=t[s.name];a.textContent=null!=i?String(i):"",e.appendChild(a)}),e.addEventListener("mouseenter",()=>{this._contextMenuOpen||this._tbody.querySelectorAll("tr").forEach(t=>{t.classList.remove("jp-TabularDataViewer-row-context-active")})}),e.addEventListener("contextmenu",s=>{this._contextMenuOpen=!0,this._tbody.classList.add("jp-TabularDataViewer-context-menu-open"),this._tbody.querySelectorAll("tr").forEach(t=>{t.classList.remove("jp-TabularDataViewer-row-context-active")}),e.classList.add("jp-TabularDataViewer-row-context-active"),this._setLastContextMenuRow(t),this._startMenuObserver()}),this._tbody.appendChild(e)})}_startResize(t,e,s){this._resizing={columnName:t,startX:e,startWidth:s.offsetWidth},document.addEventListener("mousemove",this._doResize),document.addEventListener("mouseup",this._stopResize),document.body.style.userSelect="none",document.body.style.cursor="col-resize"}_applyFilter(t,e,s){if(e.trim())if(this._isNumericType(s)){const s=e.match(/^([><=]+)?\s*(.+)$/);if(s){const e=s[1]||"=",a=s[2].trim();this._filters[t]={type:"number",value:a,operator:e}}}else this._filters[t]={type:"text",value:e};else delete this._filters[t];this._loadData(!0)}_simplifyType(t){const e=t.toLowerCase();return e.includes("date32")||e.includes("date64")?"date":e.includes("timestamp")?"datetime":e.match(/^u?int(8|16|32|64)$/)?"int":e.match(/^(float|double)(16|32|64)?$/)?"float":e.includes("decimal")?"decimal":"bool"===e?"boolean":"string"===e||"utf8"===e||"large_string"===e||"large_utf8"===e?"string":"binary"===e||"large_binary"===e?"binary":e.startsWith("list")?"list":e.startsWith("struct")?"struct":t}_isNumericType(t){return["int","float","double","decimal","int8","int16","int32","int64","uint8","uint16","uint32","uint64"].some(e=>t.toLowerCase().includes(e))}_getFilterPlaceholder(t){return this._isNumericType(t)?"=, >, <, >=, <=":"text or regex..."}_onScroll(){const t=this._tableContainer;t.scrollTop+t.clientHeight>=t.scrollHeight-200&&this._hasMore&&!this._loading&&this._loadData(!1)}_toggleSort(t){this._sortBy===t?"asc"===this._sortOrder?this._sortOrder="desc":"desc"===this._sortOrder&&(this._sortBy=null,this._sortOrder="asc"):(this._sortBy=t,this._sortOrder="asc"),this._updateSortIndicators(),this._loadData(!0)}async _showColumnStats(t){try{const e=await async function(t,e){return l("column-stats",{method:"POST",body:JSON.stringify({path:t,columnName:e})})}(this._filePath,t);new c(e).show()}catch(e){console.error("Failed to load column statistics:",e),alert(`Failed to load statistics for column "${t}": ${e}`)}}_updateSortIndicators(){this._headerRow.querySelectorAll("th").forEach(t=>{const e=t.dataset.columnName,s=t.querySelector(".jp-TabularDataViewer-sortIndicator");e===this._sortBy?s.textContent="asc"===this._sortOrder?" ▲":" ▼":s.textContent=""})}_clearFilters(){this._filters={},this._filterRow.querySelectorAll("input").forEach(t=>{t.value=""}),this._loadData(!0)}_formatFileSize(t){if(0===t)return"0 B";const e=Math.floor(Math.log(t)/Math.log(1024));return parseFloat((t/Math.pow(1024,e)).toFixed(2))+" "+["B","KB","MB","GB","TB"][e]}_updateStatusBar(t){if(t)this._statusLeft.textContent="",this._statusRight.textContent=t;else{const t=this._columns.length,e=this._formatFileSize(this._fileSize);this._statusLeft.textContent=`${t} columns • ${this._unfilteredTotalRows} rows • ${e}`;const s=Object.keys(this._filters).length;let a=`Showing ${this._data.length} of ${this._totalRows} rows`;if(s>0&&(a+=` (${s} filter${s>1?"s":""} active)`),this._statusRight.innerHTML=a,s>0){const t=document.createElement("a");t.href="#",t.className="jp-TabularDataViewer-clearFilters",t.textContent="Clear filters",t.addEventListener("click",t=>{t.preventDefault(),this._clearFilters()}),this._statusRight.appendChild(document.createTextNode(" • ")),this._statusRight.appendChild(t)}}}_showError(t){this._tbody.innerHTML="";const e=document.createElement("tr"),s=document.createElement("td");s.colSpan=this._columns.length||1,s.className="jp-TabularDataViewer-error",s.textContent=t,e.appendChild(s),this._tbody.appendChild(e)}dispose(){this._tableContainer.removeEventListener("scroll",this._onScroll),this._menuObserver&&(this._menuObserver.disconnect(),this._menuObserver=null),this._resizing&&(document.removeEventListener("mousemove",this._doResize),document.removeEventListener("mouseup",this._stopResize),document.body.style.userSelect="",document.body.style.cursor=""),super.dispose()}}class h extends a.DocumentWidget{constructor(t){super(t)}}class u extends a.ABCWidgetFactory{constructor(t,e,s){super(t),this._setLastContextMenuRow=e,this._setActiveWidget=s}createNewWidget(t){const e=new d(t.path,this._setLastContextMenuRow),s=new h({content:e,context:t});return s.title.label=t.path.split("/").pop()||"Tabular Data File",this._setActiveWidget(e),s}}const m={id:"jupyterlab_tabular_data_viewer_extension:plugin",description:"Jupyterlab extension to allow simple browsing of tabular data files (Parquet, Excel) with filtering and sorting capabilities",autoStart:!0,requires:[i.ISettingRegistry],activate:async(t,e)=>{console.log("JupyterLab extension jupyterlab_tabular_data_viewer_extension is activated!");const{docRegistry:s,commands:a,contextMenu:i}=t;let n=null,o=null,r={enableParquet:!0,enableExcel:!0,enableCSV:!0,enableTSV:!0};try{const t=await e.load(m.id);r=t.composite,t.changed.connect(()=>{r=t.composite})}catch(t){console.error("[Tabular Data Viewer] Failed to load settings:",t)}const l="tabular-data-viewer:copy-row-json";a.addCommand(l,{label:"Copy Row as JSON",caption:"Copy the row data as JSON to clipboard",isEnabled:()=>null!==n,execute:async()=>{if(n){const t=JSON.stringify(n,null,2);await navigator.clipboard.writeText(t),o&&o.getCleanupHighlight()()}}}),i.addItem({command:l,selector:".jp-TabularDataViewer-row",rank:10});const c=[],d=[];if(r.enableParquet)try{s.addFileType({name:"parquet",displayName:"Parquet",extensions:[".parquet"],mimeTypes:["application/x-parquet"],iconClass:"jp-MaterialIcon jp-SpreadsheetIcon",contentType:"file",fileFormat:"base64"}),c.push("parquet")}catch(t){console.warn("[Tabular Data Viewer] Parquet file type already registered",t)}if(r.enableExcel)try{s.addFileType({name:"xlsx-parquet-viewer",displayName:"Excel (Parquet Viewer)",extensions:[".xlsx"],mimeTypes:["application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"],iconClass:"jp-MaterialIcon jp-SpreadsheetIcon",contentType:"file",fileFormat:"base64"}),c.push("xlsx-parquet-viewer")}catch(t){console.warn("[Tabular Data Viewer] Excel file type already registered",t)}if(r.enableCSV)try{s.addFileType({name:"csv-tabular-viewer",displayName:"CSV (Tabular Viewer)",extensions:[".csv"],mimeTypes:["text/csv"],iconClass:"jp-MaterialIcon jp-SpreadsheetIcon",contentType:"file",fileFormat:"text"}),d.push("csv-tabular-viewer")}catch(t){console.warn("[Tabular Data Viewer] CSV file type already registered",t)}if(r.enableTSV)try{s.addFileType({name:"tsv-tabular-viewer",displayName:"TSV (Tabular Viewer)",extensions:[".tsv"],mimeTypes:["text/tab-separated-values"],iconClass:"jp-MaterialIcon jp-SpreadsheetIcon",contentType:"file",fileFormat:"text"}),d.push("tsv-tabular-viewer")}catch(t){console.warn("[Tabular Data Viewer] TSV file type already registered",t)}if(c.length>0){const t=new u({name:"Tabular Data Viewer (Binary)",modelName:"base64",fileTypes:c,defaultFor:c,defaultRendered:c,readOnly:!0},t=>{n=t},t=>{o=t});s.addWidgetFactory(t)}if(d.length>0){const t=new u({name:"Tabular Data Viewer (Text)",modelName:"text",fileTypes:d,defaultFor:d,defaultRendered:d,readOnly:!0},t=>{n=t},t=>{o=t});s.addWidgetFactory(t)}0===c.length&&0===d.length&&console.warn("[Tabular Data Viewer] No file types enabled in settings")}},_=m}}]);