"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Deployment = void 0;
const kplus = require("cdk8s-plus-22");
const constructs_1 = require("constructs");
class Deployment extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.namespace = props.namespaceName || 'default';
        this.deployment = new kplus.Deployment(this, 'deployment', {
            metadata: {
                namespace: this.namespace,
            },
            replicas: props.replicas || 1,
            containers: [props.container],
            initContainers: props.initContainer ? [props.initContainer] : undefined,
            serviceAccount: props.serviceAccount,
        });
        if (props.envVars) {
            this.addEnvironmentVariables('container-env', this.deployment.containers[0], props.envVars);
        }
        if (props.initContainer && props.envVars) {
            this.addEnvironmentVariables('init-container-env', this.deployment.initContainers[0], props.envVars);
        }
    }
    addEnvironmentVariables(id, container, envVar) {
        const configMap = new kplus.ConfigMap(this, id, {
            metadata: {
                name: id,
                namespace: this.namespace,
            },
            data: envVar,
        });
        for (const key in envVar) {
            container.env.addVariable(key, kplus.EnvValue.fromConfigMap(configMap, key));
        }
    }
}
exports.Deployment = Deployment;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVwbG95bWVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9jb25zdHJ1Y3RzL2RlcGxveW1lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsdUNBQXVDO0FBQ3ZDLDJDQUF1QztBQXlDdkMsTUFBYSxVQUFXLFNBQVEsc0JBQVM7SUFJdkMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUF3QjtRQUNoRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLGFBQWEsSUFBSSxTQUFTLENBQUM7UUFFbEQsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLEtBQUssQ0FBQyxVQUFVLENBQUMsSUFBSSxFQUFFLFlBQVksRUFBRTtZQUN6RCxRQUFRLEVBQUU7Z0JBQ1IsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO2FBQzFCO1lBQ0QsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRLElBQUksQ0FBQztZQUM3QixVQUFVLEVBQUUsQ0FBQyxLQUFLLENBQUMsU0FBUyxDQUFDO1lBQzdCLGNBQWMsRUFBRSxLQUFLLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUztZQUN2RSxjQUFjLEVBQUUsS0FBSyxDQUFDLGNBQWM7U0FDckMsQ0FBQyxDQUFDO1FBRUgsSUFBSSxLQUFLLENBQUMsT0FBTyxFQUFFO1lBQ2pCLElBQUksQ0FBQyx1QkFBdUIsQ0FBQyxlQUFlLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLEVBQUUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1NBQzdGO1FBQ0QsSUFBSSxLQUFLLENBQUMsYUFBYSxJQUFJLEtBQUssQ0FBQyxPQUFPLEVBQUU7WUFDeEMsSUFBSSxDQUFDLHVCQUF1QixDQUFDLG9CQUFvQixFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxFQUFFLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztTQUN0RztJQUNILENBQUM7SUFFRCx1QkFBdUIsQ0FBQyxFQUFVLEVBQUUsU0FBMEIsRUFBRSxNQUE4QjtRQUM1RixNQUFNLFNBQVMsR0FBRyxJQUFJLEtBQUssQ0FBQyxTQUFTLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRTtZQUM5QyxRQUFRLEVBQUU7Z0JBQ1IsSUFBSSxFQUFFLEVBQUU7Z0JBQ1IsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO2FBQzFCO1lBQ0QsSUFBSSxFQUFFLE1BQU07U0FDYixDQUFDLENBQUM7UUFFSCxLQUFLLE1BQU0sR0FBRyxJQUFJLE1BQU0sRUFBRTtZQUN4QixTQUFTLENBQUMsR0FBRyxDQUFDLFdBQVcsQ0FBQyxHQUFHLEVBQUUsS0FBSyxDQUFDLFFBQVEsQ0FBQyxhQUFhLENBQUMsU0FBUyxFQUFFLEdBQUcsQ0FBQyxDQUFDLENBQUM7U0FDOUU7SUFDSCxDQUFDO0NBQ0Y7QUF4Q0QsZ0NBd0NDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMga3BsdXMgZnJvbSAnY2RrOHMtcGx1cy0yMic7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuZXhwb3J0IGludGVyZmFjZSBEZXBsb3ltZW50T3B0aW9ucyB7XG4gIC8qKlxuICAgKiBOYW1lc3BhY2UgdG8gZGVwbG95IHJlc291cmNlcyB0b1xuICAgKlxuICAgKiBAZGVmYXVsdCAtIGRlZmF1bHRcbiAgICovXG4gIHJlYWRvbmx5IG5hbWVzcGFjZU5hbWU6IHN0cmluZztcblxuICAvKipcbiAgICogTmFtZSBvZiB0aGUgc2VydmljZUFjY291bnQgdXNlZCBmb3IgdGhpcyBkZXBsb3ltZW50XG4gICAqXG4gICAqIEBkZWZhdWx0IC0gZGVmYXVsdFxuICAgKi9cbiAgcmVhZG9ubHkgc2VydmljZUFjY291bnQ6IGtwbHVzLlNlcnZpY2VBY2NvdW50O1xuXG4gIC8qKlxuICAgKiBOdW1iZXIgb2YgdGhlIHJlcGxpY2FzXG4gICAqXG4gICAqIEBkZWZhdWx0IDFcbiAgICovXG4gIHJlYWRvbmx5IHJlcGxpY2FzPzogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiBDb250YWluZXIgcHJvcHNcbiAgICovXG4gIHJlYWRvbmx5IGNvbnRhaW5lcjoga3BsdXMuQ29udGFpbmVyUHJvcHM7XG5cbiAgLyoqXG4gICAqIEluaXQgQ29udGFpbmVyIHByb3BzXG4gICAqL1xuICByZWFkb25seSBpbml0Q29udGFpbmVyPzoga3BsdXMuQ29udGFpbmVyUHJvcHM7XG5cbiAgLyoqXG4gICAqIEVudmlyb25tZW50IFZhcmlhYmxlc1xuICAgKlxuICAgKi9cbiAgcmVhZG9ubHkgZW52VmFycz86IFJlY29yZDxzdHJpbmcsIHN0cmluZz47XG59XG5cbmV4cG9ydCBjbGFzcyBEZXBsb3ltZW50IGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgZGVwbG95bWVudDoga3BsdXMuRGVwbG95bWVudDtcbiAgbmFtZXNwYWNlOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IERlcGxveW1lbnRPcHRpb25zKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIHRoaXMubmFtZXNwYWNlID0gcHJvcHMubmFtZXNwYWNlTmFtZSB8fCAnZGVmYXVsdCc7XG5cbiAgICB0aGlzLmRlcGxveW1lbnQgPSBuZXcga3BsdXMuRGVwbG95bWVudCh0aGlzLCAnZGVwbG95bWVudCcsIHtcbiAgICAgIG1ldGFkYXRhOiB7XG4gICAgICAgIG5hbWVzcGFjZTogdGhpcy5uYW1lc3BhY2UsXG4gICAgICB9LFxuICAgICAgcmVwbGljYXM6IHByb3BzLnJlcGxpY2FzIHx8IDEsXG4gICAgICBjb250YWluZXJzOiBbcHJvcHMuY29udGFpbmVyXSxcbiAgICAgIGluaXRDb250YWluZXJzOiBwcm9wcy5pbml0Q29udGFpbmVyID8gW3Byb3BzLmluaXRDb250YWluZXJdIDogdW5kZWZpbmVkLFxuICAgICAgc2VydmljZUFjY291bnQ6IHByb3BzLnNlcnZpY2VBY2NvdW50LFxuICAgIH0pO1xuXG4gICAgaWYgKHByb3BzLmVudlZhcnMpIHtcbiAgICAgIHRoaXMuYWRkRW52aXJvbm1lbnRWYXJpYWJsZXMoJ2NvbnRhaW5lci1lbnYnLCB0aGlzLmRlcGxveW1lbnQuY29udGFpbmVyc1swXSwgcHJvcHMuZW52VmFycyk7XG4gICAgfVxuICAgIGlmIChwcm9wcy5pbml0Q29udGFpbmVyICYmIHByb3BzLmVudlZhcnMpIHtcbiAgICAgIHRoaXMuYWRkRW52aXJvbm1lbnRWYXJpYWJsZXMoJ2luaXQtY29udGFpbmVyLWVudicsIHRoaXMuZGVwbG95bWVudC5pbml0Q29udGFpbmVyc1swXSwgcHJvcHMuZW52VmFycyk7XG4gICAgfVxuICB9XG5cbiAgYWRkRW52aXJvbm1lbnRWYXJpYWJsZXMoaWQ6IHN0cmluZywgY29udGFpbmVyOiBrcGx1cy5Db250YWluZXIsIGVudlZhcjogUmVjb3JkPHN0cmluZywgc3RyaW5nPikge1xuICAgIGNvbnN0IGNvbmZpZ01hcCA9IG5ldyBrcGx1cy5Db25maWdNYXAodGhpcywgaWQsIHtcbiAgICAgIG1ldGFkYXRhOiB7XG4gICAgICAgIG5hbWU6IGlkLFxuICAgICAgICBuYW1lc3BhY2U6IHRoaXMubmFtZXNwYWNlLFxuICAgICAgfSxcbiAgICAgIGRhdGE6IGVudlZhcixcbiAgICB9KTtcblxuICAgIGZvciAoY29uc3Qga2V5IGluIGVudlZhcikge1xuICAgICAgY29udGFpbmVyLmVudi5hZGRWYXJpYWJsZShrZXksIGtwbHVzLkVudlZhbHVlLmZyb21Db25maWdNYXAoY29uZmlnTWFwLCBrZXkpKTtcbiAgICB9XG4gIH1cbn1cbiJdfQ==