import * as kplus from 'cdk8s-plus-22';
import { Construct } from 'constructs';
export interface DeploymentOptions {
    /**
     * Namespace to deploy resources to
     *
     * @default - default
     */
    readonly namespaceName: string;
    /**
     * Name of the serviceAccount used for this deployment
     *
     * @default - default
     */
    readonly serviceAccount: kplus.ServiceAccount;
    /**
     * Number of the replicas
     *
     * @default 1
     */
    readonly replicas?: number;
    /**
     * Container props
     */
    readonly container: kplus.ContainerProps;
    /**
     * Init Container props
     */
    readonly initContainer?: kplus.ContainerProps;
    /**
     * Environment Variables
     *
     */
    readonly envVars?: Record<string, string>;
}
export declare class Deployment extends Construct {
    deployment: kplus.Deployment;
    namespace: string;
    constructor(scope: Construct, id: string, props: DeploymentOptions);
    addEnvironmentVariables(id: string, container: kplus.Container, envVar: Record<string, string>): void;
}
