"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetaflowUIStaticChart = exports.MetaflowUIChart = exports.MetaflowServiceChart = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const cdk8s_plus_22_1 = require("cdk8s-plus-22");
const deployment_1 = require("./deployment");
class MetaflowServiceChart extends cdk8s_1.Chart {
    constructor(scope, name, props) {
        super(scope, name);
        const namespace = props.namespace || 'default';
        const envVars = props.envVars || {
            MF_METADATA_DB_NAME: 'metaflow',
            MF_METADATA_DB_PORT: '5432',
            MF_METADATA_DB_PSWD: 'metaflow',
            MF_METADATA_DB_USER: 'metaflow',
            MF_METADATA_DB_HOST: 'release-name-postgresql',
        };
        const deployment = new deployment_1.Deployment(this, 'metaflow-service', {
            namespaceName: namespace,
            serviceAccount: props.serviceAccount,
            initContainer: {
                image: `${props.initImage}:${props.initImageTag}`,
                command: ['/opt/latest/bin/python3', '/root/run_goose.py', '--only-if-empty-db'],
                imagePullPolicy: cdk8s_plus_22_1.ImagePullPolicy.IF_NOT_PRESENT,
            },
            container: {
                name: 'metaflow-service',
                image: `${props.image}:${props.imageTag}`,
                command: ['/opt/latest/bin/python3', '-m', 'services.metadata_service.server'],
                imagePullPolicy: cdk8s_plus_22_1.ImagePullPolicy.IF_NOT_PRESENT,
                port: 8080,
                liveness: cdk8s_plus_22_1.Probe.fromHttpGet('/ping', {
                    initialDelaySeconds: cdk8s_1.Duration.seconds(30),
                    periodSeconds: cdk8s_1.Duration.seconds(15),
                }),
                readiness: cdk8s_plus_22_1.Probe.fromHttpGet('/ping', {
                    initialDelaySeconds: cdk8s_1.Duration.seconds(30),
                    periodSeconds: cdk8s_1.Duration.seconds(15),
                }),
            },
            envVars: envVars,
        });
        this.deployment = deployment.deployment;
        this.service = this.deployment.exposeViaService({
            serviceType: props.serviceType,
            ports: [
                {
                    port: 8080,
                    name: 'http',
                    protocol: cdk8s_plus_22_1.Protocol.TCP,
                },
                {
                    port: 8082,
                    name: 'upgrades',
                    protocol: cdk8s_plus_22_1.Protocol.TCP,
                },
            ],
        });
    }
}
exports.MetaflowServiceChart = MetaflowServiceChart;
_a = JSII_RTTI_SYMBOL_1;
MetaflowServiceChart[_a] = { fqn: "cdk8s-metaflow.MetaflowServiceChart", version: "0.0.9" };
class MetaflowUIChart extends cdk8s_1.Chart {
    constructor(scope, name, props) {
        super(scope, name);
        const namespace = props.namespace || 'default';
        const envVars = props.envVars || {
            UI_ENABLED: '1',
            PATH_PREFIX: '/api',
            MF_DATASTORE_ROOT: 's3://metaflow-kube-tooling/data/',
            METAFLOW_DATASTORE_SYSROOT_S3: 's3://metaflow-kube-tooling/metaflow/',
            LOGLEVEL: 'DEBUG',
            METAFLOW_SERVICE_URL: 'http://localhost:8083/api/metadata',
            METAFLOW_DEFAULT_DATASTORE: 's3',
            METAFLOW_DEFAULT_METADATA: 'service',
            MF_METADATA_DB_NAME: 'metaflow',
            MF_METADATA_DB_PORT: '5432',
            MF_METADATA_DB_PSWD: 'metaflow',
            MF_METADATA_DB_USER: 'metaflow',
            MF_METADATA_DB_HOST: 'release-name-postgresql',
        };
        const deployment = new deployment_1.Deployment(this, 'metaflow-service', {
            namespaceName: namespace,
            serviceAccount: props.serviceAccount,
            container: {
                name: 'metaflow-ui',
                image: `${props.image}:${props.imageTag}`,
                command: ['/opt/latest/bin/python3', '-m', 'services.ui_backend_service.ui_server'],
                imagePullPolicy: cdk8s_plus_22_1.ImagePullPolicy.IF_NOT_PRESENT,
                port: 8083,
                liveness: cdk8s_plus_22_1.Probe.fromHttpGet('/api/ping', {
                    initialDelaySeconds: cdk8s_1.Duration.seconds(30),
                    periodSeconds: cdk8s_1.Duration.seconds(15),
                }),
                readiness: cdk8s_plus_22_1.Probe.fromHttpGet('/api/ping', {
                    initialDelaySeconds: cdk8s_1.Duration.seconds(30),
                    periodSeconds: cdk8s_1.Duration.seconds(15),
                }),
            },
            envVars: envVars,
        });
        this.deployment = deployment.deployment;
        this.service = this.deployment.exposeViaService({
            serviceType: props.serviceType,
            ports: [
                {
                    port: 8083,
                    name: 'http',
                    protocol: cdk8s_plus_22_1.Protocol.TCP,
                },
            ],
        });
    }
}
exports.MetaflowUIChart = MetaflowUIChart;
_b = JSII_RTTI_SYMBOL_1;
MetaflowUIChart[_b] = { fqn: "cdk8s-metaflow.MetaflowUIChart", version: "0.0.9" };
class MetaflowUIStaticChart extends cdk8s_1.Chart {
    constructor(scope, name, props) {
        super(scope, name);
        const namespace = props.namespace || 'default';
        const deployment = new deployment_1.Deployment(this, 'metaflow-service', {
            namespaceName: namespace,
            serviceAccount: props.serviceAccount,
            container: {
                image: `${props.image}:${props.imageTag}`,
                imagePullPolicy: cdk8s_plus_22_1.ImagePullPolicy.IF_NOT_PRESENT,
                port: 3000,
                liveness: cdk8s_plus_22_1.Probe.fromHttpGet('/', {
                    initialDelaySeconds: cdk8s_1.Duration.seconds(30),
                    periodSeconds: cdk8s_1.Duration.seconds(15),
                }),
                readiness: cdk8s_plus_22_1.Probe.fromHttpGet('/', {
                    initialDelaySeconds: cdk8s_1.Duration.seconds(30),
                    periodSeconds: cdk8s_1.Duration.seconds(15),
                }),
            },
        });
        this.deployment = deployment.deployment;
        this.service = this.deployment.exposeViaService({
            serviceType: props.serviceType,
            ports: [
                {
                    port: 3000,
                    name: 'http',
                    protocol: cdk8s_plus_22_1.Protocol.TCP,
                },
            ],
        });
    }
}
exports.MetaflowUIStaticChart = MetaflowUIStaticChart;
_c = JSII_RTTI_SYMBOL_1;
MetaflowUIStaticChart[_c] = { fqn: "cdk8s-metaflow.MetaflowUIStaticChart", version: "0.0.9" };
//# sourceMappingURL=data:application/json;base64,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