import { Chart, ChartProps } from 'cdk8s';
import { Deployment as kplusDeployment, Service, ServiceAccount, ServiceType } from 'cdk8s-plus-22';
import { Construct } from 'constructs';
export interface MetaflowChartProps extends ChartProps {
    readonly serviceAccount: ServiceAccount;
    readonly serviceType: ServiceType;
    readonly image: string;
    readonly imageTag: string;
    readonly initImage?: string;
    readonly initImageTag?: string;
    readonly envVars?: Record<string, string>;
}
export declare class MetaflowServiceChart extends Chart {
    readonly deployment: kplusDeployment;
    readonly service: Service;
    constructor(scope: Construct, name: string, props: MetaflowChartProps);
}
export declare class MetaflowUIChart extends Chart {
    readonly deployment: kplusDeployment;
    readonly service: Service;
    constructor(scope: Construct, name: string, props: MetaflowChartProps);
}
export declare class MetaflowUIStaticChart extends Chart {
    readonly deployment: kplusDeployment;
    readonly service: Service;
    constructor(scope: Construct, name: string, props: MetaflowChartProps);
}
