"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PostgresAddon = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
class PostgresAddon {
    constructor(props) {
        this.props = props;
    }
    get name() {
        return PostgresAddon.NAME;
    }
    install(scope) {
        const chartValues = this.props.chartValues ?? {
            auth: {
                database: 'metaflow',
                password: 'metaflow',
                username: 'metaflow',
            },
        };
        const chart = new cdk8s_1.Helm(scope, 'postgres', {
            chart: 'bitnami/postgresql',
            releaseName: 'release-name-postgresql',
            helmFlags: ['--version', this.props.chartVersion, '-n', this.props.namespaceName],
            values: chartValues,
        });
        return chart;
    }
}
exports.PostgresAddon = PostgresAddon;
_a = JSII_RTTI_SYMBOL_1;
PostgresAddon[_a] = { fqn: "cdk8s-metaflow.PostgresAddon", version: "0.0.9" };
PostgresAddon.NAME = 'postgres';
//# sourceMappingURL=data:application/json;base64,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