import { Helm } from 'cdk8s';
import { Construct } from 'constructs';
import { IAddon } from '../addon';
export interface DatabaseAuthOptions {
    readonly database?: string;
    readonly password?: string;
    readonly username?: string;
    readonly postgresPassword?: string;
    readonly enablePostgresUser?: boolean;
    readonly replicationPassword?: string;
    readonly replicationUsername?: string;
}
export interface DatabaseMetricsOptions {
    readonly enabled?: boolean;
}
export interface DatabaseResourceRequestOptions {
    readonly memory?: string;
    readonly cpu?: string;
}
export interface DatabaseResourcesOptions {
    readonly requests?: DatabaseResourceRequestOptions;
}
export interface DatabaseReplicationOptions {
    readonly enabled?: boolean;
    readonly readReplicas?: number;
}
export interface DatabaseVolumePermissionsOptions {
    readonly enabled?: boolean;
}
export interface MetadataDatabaseOptions {
    readonly auth?: DatabaseAuthOptions;
    readonly metrics?: DatabaseMetricsOptions;
    readonly resources?: DatabaseResourcesOptions;
    readonly replication?: DatabaseReplicationOptions;
    readonly architecture?: string;
    readonly volumePermissions?: DatabaseVolumePermissionsOptions;
}
export interface PostgresAddonProps {
    readonly chartVersion: string;
    readonly chartValues?: MetadataDatabaseOptions;
    readonly namespaceName: string;
}
export declare class PostgresAddon implements IAddon {
    private readonly props;
    static readonly NAME = "postgres";
    constructor(props: PostgresAddonProps);
    get name(): string;
    install(scope: Construct): Helm;
}
