#!/usr/bin/env python3

import argparse


def load_file(input, output_folder, prefix):
    o_d = open("{}/{}.input0".format(output_folder, prefix), "w")
    o_l = open("{}/{}.label0".format(output_folder, prefix), "w")

    sep = " "

    with open(input) as fp:
        line = fp.readline()
        inp = None
        lab = None
        while line:
            if inp is not None:
                o_d.writelines("{}\n".format(" ".join(inp)))
            if lab is not None:
                o_l.writelines("{}\n".format(sep.join(lab)))
            inp = []
            lab = []
            while line and line != "\n":
                line = line.strip().split()
                if len(line):
                    inp.append(line[0])
                    lab.append(line[1])
                line = fp.readline()
            line = fp.readline()

    o_d.close()
    o_l.close()


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--input")
    parser.add_argument("--output_folder")
    parser.add_argument("--prefix")
    args = parser.parse_args()

    load_file(args.input, args.output_folder, args.prefix, args.sep)


if __name__ == "__main__":
    main()
