"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
    UnrecognizedStr,
)
from gr4vy.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Literal, Union
from typing_extensions import Annotated, NotRequired, TypedDict


RedirectPaymentMethodCreateMethod = Union[
    Literal[
        "abitab",
        "affirm",
        "afterpay",
        "alipay",
        "alipayhk",
        "arcuspaynetwork",
        "bacs",
        "bancontact",
        "banked",
        "bcp",
        "becs",
        "bitpay",
        "boleto",
        "boost",
        "cashapp",
        "clearpay",
        "dana",
        "dcb",
        "dlocal",
        "ebanx",
        "efecty",
        "eps",
        "everydaypay",
        "gcash",
        "gem",
        "gemds",
        "giropay",
        "givingblock",
        "gocardless",
        "gopay",
        "grabpay",
        "ideal",
        "kakaopay",
        "kcp",
        "khipu",
        "klarna",
        "latitude",
        "latitudeds",
        "laybuy",
        "linepay",
        "linkaja",
        "maybankqrpay",
        "mercadopago",
        "multibanco",
        "multipago",
        "netbanking",
        "nupay",
        "nequi",
        "oney_10x",
        "oney_12x",
        "oney_3x",
        "oney_4x",
        "oney_6x",
        "ovo",
        "oxxo",
        "pagoefectivo",
        "payid",
        "paymaya",
        "paypal",
        "paypalpaylater",
        "payto",
        "payvalida",
        "picpay",
        "pix",
        "pse",
        "rabbitlinepay",
        "rapipago",
        "razorpay",
        "redpagos",
        "scalapay",
        "sepa",
        "servipag",
        "shopeepay",
        "singteldash",
        "smartpay",
        "sofort",
        "spei",
        "stitch",
        "stripedd",
        "thaiqr",
        "touchngo",
        "truemoney",
        "trustly",
        "trustlyeurope",
        "upi",
        "venmo",
        "vipps",
        "waave",
        "webpay",
        "wechat",
        "yape",
        "zippay",
    ],
    UnrecognizedStr,
]
r"""The method to use, this can be any of the methods that support redirect requests."""


class RedirectPaymentMethodCreateTypedDict(TypedDict):
    r"""Create a transaction for an APM/LPM that requires a redirect."""

    method: RedirectPaymentMethodCreateMethod
    r"""The method to use, this can be any of the methods that support redirect requests."""
    country: str
    r"""The 2-letter ISO code of the country to use this payment method for. This is used to select the payment service to use."""
    currency: str
    r"""The ISO-4217 currency code to use this payment method for. This is used to select the payment service to use."""
    redirect_url: str
    r"""The redirect URL to redirect a buyer to after they have authorized the payment method."""
    buyer_id: NotRequired[Nullable[str]]
    r"""The `id` of a stored buyer to use Use this instead of the `buyer_external_identifier`."""
    buyer_external_identifier: NotRequired[Nullable[str]]
    r"""The `external_identifier` of a stored buyer to use. Use this instead of the `buyer_id`."""
    external_identifier: NotRequired[Nullable[str]]
    r"""The merchant identifier for this payment method."""


class RedirectPaymentMethodCreate(BaseModel):
    r"""Create a transaction for an APM/LPM that requires a redirect."""

    method: Annotated[
        RedirectPaymentMethodCreateMethod, PlainValidator(validate_open_enum(False))
    ]
    r"""The method to use, this can be any of the methods that support redirect requests."""

    country: str
    r"""The 2-letter ISO code of the country to use this payment method for. This is used to select the payment service to use."""

    currency: str
    r"""The ISO-4217 currency code to use this payment method for. This is used to select the payment service to use."""

    redirect_url: str
    r"""The redirect URL to redirect a buyer to after they have authorized the payment method."""

    buyer_id: OptionalNullable[str] = UNSET
    r"""The `id` of a stored buyer to use Use this instead of the `buyer_external_identifier`."""

    buyer_external_identifier: OptionalNullable[str] = UNSET
    r"""The `external_identifier` of a stored buyer to use. Use this instead of the `buyer_id`."""

    external_identifier: OptionalNullable[str] = UNSET
    r"""The merchant identifier for this payment method."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "buyer_id",
            "buyer_external_identifier",
            "external_identifier",
        ]
        nullable_fields = [
            "buyer_id",
            "buyer_external_identifier",
            "external_identifier",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
