"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .field import FieldT, FieldTTypedDict
from .merchantprofileschemesummary import (
    MerchantProfileSchemeSummary,
    MerchantProfileSchemeSummaryTypedDict,
)
from .method import Method
from .paymentservicestatus import PaymentServiceStatus
from datetime import datetime
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Dict, List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PaymentServiceTypedDict(TypedDict):
    merchant_account_id: str
    r"""The ID of the merchant account this job belongs to."""
    payment_service_definition_id: str
    r"""The definition ID of the service that has been configured."""
    method: Method
    display_name: str
    r"""The display name for the payment service."""
    position: int
    r"""Deprecated field used to define the order in which to process payment services"""
    accepted_currencies: List[str]
    r"""A list of currencies for which this service is enabled, in ISO 4217 three-letter code format."""
    accepted_countries: List[str]
    r"""A list of countries for which this service is enabled, in ISO two-letter code format."""
    payment_method_tokenization_enabled: bool
    r"""Defines if this payment service support payment method tokenization."""
    network_tokens_enabled: bool
    r"""Defines if this payment service supports network tokens."""
    open_loop: bool
    r"""Defines if this payment service is open loop."""
    settlement_reporting_enabled: bool
    r"""Defines if this payment service has settlement reporting enabled."""
    created_at: datetime
    r"""The date and time when this payment service was first created in our system."""
    updated_at: datetime
    r"""The date and time when this payment service was last updated in our system."""
    type: Literal["payment-service"]
    r"""Always `payment-service`"""
    id: NotRequired[str]
    active: NotRequired[bool]
    r"""Defines if this payment service is currently active."""
    status: NotRequired[PaymentServiceStatus]
    three_d_secure_enabled: NotRequired[Nullable[bool]]
    r"""Defines if this payment service has 3DS enabled."""
    merchant_profile: NotRequired[
        Nullable[Dict[str, Nullable[MerchantProfileSchemeSummaryTypedDict]]]
    ]
    r"""An object containing a key for each supported card schemes, and for each key an object with the 3DS profile for this service for that scheme."""
    webhook_url: NotRequired[Nullable[str]]
    r"""The URL that needs to be configured with this payment service as the receiving endpoint for webhooks from the service to our system. Currently, we dp not yet automatically register webhooks on setup, and therefore webhooks need to be registered manually by the merchant."""
    fields: NotRequired[Nullable[List[FieldTTypedDict]]]
    r"""The non-secret credential fields that have been configured for this payment service. Any secret fields are omitted."""
    reporting_fields: NotRequired[Nullable[List[FieldTTypedDict]]]
    r"""The non-secret reporting fields that have been configured for this payment service. Any secret fields are omitted."""
    is_deleted: NotRequired[bool]
    r"""Defines if this payment service has been deleted"""


class PaymentService(BaseModel):
    merchant_account_id: str
    r"""The ID of the merchant account this job belongs to."""

    payment_service_definition_id: str
    r"""The definition ID of the service that has been configured."""

    method: Annotated[Method, PlainValidator(validate_open_enum(False))]

    display_name: str
    r"""The display name for the payment service."""

    position: int
    r"""Deprecated field used to define the order in which to process payment services"""

    accepted_currencies: List[str]
    r"""A list of currencies for which this service is enabled, in ISO 4217 three-letter code format."""

    accepted_countries: List[str]
    r"""A list of countries for which this service is enabled, in ISO two-letter code format."""

    payment_method_tokenization_enabled: bool
    r"""Defines if this payment service support payment method tokenization."""

    network_tokens_enabled: bool
    r"""Defines if this payment service supports network tokens."""

    open_loop: bool
    r"""Defines if this payment service is open loop."""

    settlement_reporting_enabled: bool
    r"""Defines if this payment service has settlement reporting enabled."""

    created_at: datetime
    r"""The date and time when this payment service was first created in our system."""

    updated_at: datetime
    r"""The date and time when this payment service was last updated in our system."""

    TYPE: Annotated[
        Annotated[
            Optional[Literal["payment-service"]],
            AfterValidator(validate_const("payment-service")),
        ],
        pydantic.Field(alias="type"),
    ] = "payment-service"
    r"""Always `payment-service`"""

    id: Optional[str] = "The ID of the payment service"

    active: Optional[bool] = True
    r"""Defines if this payment service is currently active."""

    status: Annotated[
        Optional[PaymentServiceStatus], PlainValidator(validate_open_enum(False))
    ] = None

    three_d_secure_enabled: OptionalNullable[bool] = UNSET
    r"""Defines if this payment service has 3DS enabled."""

    merchant_profile: OptionalNullable[
        Dict[str, Nullable[MerchantProfileSchemeSummary]]
    ] = UNSET
    r"""An object containing a key for each supported card schemes, and for each key an object with the 3DS profile for this service for that scheme."""

    webhook_url: OptionalNullable[str] = UNSET
    r"""The URL that needs to be configured with this payment service as the receiving endpoint for webhooks from the service to our system. Currently, we dp not yet automatically register webhooks on setup, and therefore webhooks need to be registered manually by the merchant."""

    fields: OptionalNullable[List[FieldT]] = UNSET
    r"""The non-secret credential fields that have been configured for this payment service. Any secret fields are omitted."""

    reporting_fields: OptionalNullable[List[FieldT]] = UNSET
    r"""The non-secret reporting fields that have been configured for this payment service. Any secret fields are omitted."""

    is_deleted: Optional[bool] = False
    r"""Defines if this payment service has been deleted"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "type",
            "id",
            "active",
            "status",
            "three_d_secure_enabled",
            "merchant_profile",
            "webhook_url",
            "fields",
            "reporting_fields",
            "is_deleted",
        ]
        nullable_fields = [
            "three_d_secure_enabled",
            "merchant_profile",
            "webhook_url",
            "fields",
            "reporting_fields",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
