"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .collection_paymentservice_ import (
    CollectionPaymentService,
    CollectionPaymentServiceTypedDict,
)
from .method import Method
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import (
    FieldMetadata,
    HeaderMetadata,
    QueryParamMetadata,
    validate_open_enum,
)
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Callable, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListPaymentServicesGlobalsTypedDict(TypedDict):
    merchant_account_id: NotRequired[str]
    r"""The ID of the merchant account to use for this request."""


class ListPaymentServicesGlobals(BaseModel):
    merchant_account_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-gr4vy-merchant-account-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""The ID of the merchant account to use for this request."""


class ListPaymentServicesRequestTypedDict(TypedDict):
    method: NotRequired[Nullable[Method]]
    r"""Return any payment service for this method."""
    cursor: NotRequired[Nullable[str]]
    r"""A pointer to the page of results to return."""
    limit: NotRequired[int]
    r"""The maximum number of items that are at returned."""
    deleted: NotRequired[Nullable[bool]]
    r"""Return any deleted payment service."""
    merchant_account_id: NotRequired[str]
    r"""The ID of the merchant account to use for this request."""


class ListPaymentServicesRequest(BaseModel):
    method: Annotated[
        Annotated[OptionalNullable[Method], PlainValidator(validate_open_enum(False))],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Return any payment service for this method."""

    cursor: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""A pointer to the page of results to return."""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 20
    r"""The maximum number of items that are at returned."""

    deleted: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Return any deleted payment service."""

    merchant_account_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-gr4vy-merchant-account-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""The ID of the merchant account to use for this request."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "method",
            "cursor",
            "limit",
            "deleted",
            "merchant_account_id",
        ]
        nullable_fields = ["method", "cursor", "deleted"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListPaymentServicesResponseTypedDict(TypedDict):
    result: CollectionPaymentServiceTypedDict


class ListPaymentServicesResponse(BaseModel):
    next: Callable[[], Optional[ListPaymentServicesResponse]]

    result: CollectionPaymentService
