"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .collection_merchantaccount_ import (
    CollectionMerchantAccount,
    CollectionMerchantAccountTypedDict,
)
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import FieldMetadata, QueryParamMetadata
from pydantic import model_serializer
from typing import Callable, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListMerchantAccountsRequestTypedDict(TypedDict):
    cursor: NotRequired[Nullable[str]]
    r"""A pointer to the page of results to return."""
    limit: NotRequired[int]
    r"""The maximum number of items that are at returned."""
    search: NotRequired[Nullable[str]]
    r"""The search term to filter merchant accounts by."""


class ListMerchantAccountsRequest(BaseModel):
    cursor: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""A pointer to the page of results to return."""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 20
    r"""The maximum number of items that are at returned."""

    search: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The search term to filter merchant accounts by."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["cursor", "limit", "search"]
        nullable_fields = ["cursor", "search"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListMerchantAccountsResponseTypedDict(TypedDict):
    result: CollectionMerchantAccountTypedDict


class ListMerchantAccountsResponse(BaseModel):
    next: Callable[[], Optional[ListMerchantAccountsResponse]]

    result: CollectionMerchantAccount
