"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .refund import Refund, RefundTypedDict
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class CollectionRefundTypedDict(TypedDict):
    items: List[RefundTypedDict]
    r"""A list of items returned for this request."""
    limit: NotRequired[int]
    r"""The number of items for this page."""
    next_cursor: NotRequired[Nullable[str]]
    r"""The cursor pointing at the next page of items."""
    previous_cursor: NotRequired[Nullable[str]]
    r"""The cursor pointing at the previous page of items."""


class CollectionRefund(BaseModel):
    items: List[Refund]
    r"""A list of items returned for this request."""

    limit: Optional[int] = 20
    r"""The number of items for this page."""

    next_cursor: OptionalNullable[str] = UNSET
    r"""The cursor pointing at the next page of items."""

    previous_cursor: OptionalNullable[str] = UNSET
    r"""The cursor pointing at the previous page of items."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["limit", "next_cursor", "previous_cursor"]
        nullable_fields = ["next_cursor", "previous_cursor"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
