"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from .sdkconfiguration import SDKConfiguration
from gr4vy import errors, models, utils
from gr4vy._hooks import HookContext
from gr4vy.balances import Balances
from gr4vy.types import OptionalNullable, UNSET
from gr4vy.utils import get_security_from_env
from jsonpath import JSONPath
from typing import Any, Dict, List, Mapping, Optional, Union


class GiftCards(BaseSDK):
    balances: Balances

    def __init__(self, sdk_config: SDKConfiguration) -> None:
        BaseSDK.__init__(self, sdk_config)
        self.sdk_configuration = sdk_config
        self._init_sdks()

    def _init_sdks(self):
        self.balances = Balances(self.sdk_configuration)

    def get(
        self,
        *,
        gift_card_id: str,
        merchant_account_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GiftCard:
        r"""Get gift card

        Fetch details about a gift card.

        :param gift_card_id: The ID of the gift card.
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetGiftCardRequest(
            gift_card_id=gift_card_id,
            merchant_account_id=merchant_account_id,
        )

        req = self._build_request(
            method="GET",
            path="/gift-cards/{gift_card_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.GetGiftCardGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(200, 200, 1, 1000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5XX"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_gift_card",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, models.GiftCard)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error400Data)
            raise errors.Error400(data=response_data)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error401Data)
            raise errors.Error401(data=response_data)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error403Data)
            raise errors.Error403(data=response_data)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error404Data)
            raise errors.Error404(data=response_data)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error405Data)
            raise errors.Error405(data=response_data)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error409Data)
            raise errors.Error409(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, errors.HTTPValidationErrorData
            )
            raise errors.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error425Data)
            raise errors.Error425(data=response_data)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error429Data)
            raise errors.Error429(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error500Data)
            raise errors.Error500(data=response_data)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error502Data)
            raise errors.Error502(data=response_data)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error504Data)
            raise errors.Error504(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def get_async(
        self,
        *,
        gift_card_id: str,
        merchant_account_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GiftCard:
        r"""Get gift card

        Fetch details about a gift card.

        :param gift_card_id: The ID of the gift card.
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetGiftCardRequest(
            gift_card_id=gift_card_id,
            merchant_account_id=merchant_account_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/gift-cards/{gift_card_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.GetGiftCardGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(200, 200, 1, 1000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5XX"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_gift_card",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, models.GiftCard)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error400Data)
            raise errors.Error400(data=response_data)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error401Data)
            raise errors.Error401(data=response_data)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error403Data)
            raise errors.Error403(data=response_data)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error404Data)
            raise errors.Error404(data=response_data)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error405Data)
            raise errors.Error405(data=response_data)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error409Data)
            raise errors.Error409(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, errors.HTTPValidationErrorData
            )
            raise errors.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error425Data)
            raise errors.Error425(data=response_data)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error429Data)
            raise errors.Error429(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error500Data)
            raise errors.Error500(data=response_data)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error502Data)
            raise errors.Error502(data=response_data)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error504Data)
            raise errors.Error504(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def delete(
        self,
        *,
        gift_card_id: str,
        merchant_account_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Any:
        r"""Delete a gift card

        Removes a gift card from our system.

        :param gift_card_id: The ID of the gift card.
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeleteGiftCardRequest(
            gift_card_id=gift_card_id,
            merchant_account_id=merchant_account_id,
        )

        req = self._build_request(
            method="DELETE",
            path="/gift-cards/{gift_card_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.DeleteGiftCardGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="delete_gift_card",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, Any)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error400Data)
            raise errors.Error400(data=response_data)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error401Data)
            raise errors.Error401(data=response_data)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error403Data)
            raise errors.Error403(data=response_data)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error404Data)
            raise errors.Error404(data=response_data)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error405Data)
            raise errors.Error405(data=response_data)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error409Data)
            raise errors.Error409(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, errors.HTTPValidationErrorData
            )
            raise errors.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error425Data)
            raise errors.Error425(data=response_data)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error429Data)
            raise errors.Error429(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error500Data)
            raise errors.Error500(data=response_data)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error502Data)
            raise errors.Error502(data=response_data)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error504Data)
            raise errors.Error504(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def delete_async(
        self,
        *,
        gift_card_id: str,
        merchant_account_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Any:
        r"""Delete a gift card

        Removes a gift card from our system.

        :param gift_card_id: The ID of the gift card.
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeleteGiftCardRequest(
            gift_card_id=gift_card_id,
            merchant_account_id=merchant_account_id,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/gift-cards/{gift_card_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.DeleteGiftCardGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="delete_gift_card",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, Any)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error400Data)
            raise errors.Error400(data=response_data)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error401Data)
            raise errors.Error401(data=response_data)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error403Data)
            raise errors.Error403(data=response_data)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error404Data)
            raise errors.Error404(data=response_data)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error405Data)
            raise errors.Error405(data=response_data)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error409Data)
            raise errors.Error409(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, errors.HTTPValidationErrorData
            )
            raise errors.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error425Data)
            raise errors.Error425(data=response_data)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error429Data)
            raise errors.Error429(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error500Data)
            raise errors.Error500(data=response_data)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error502Data)
            raise errors.Error502(data=response_data)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error504Data)
            raise errors.Error504(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def create(
        self,
        *,
        number: str,
        pin: str,
        merchant_account_id: Optional[str] = None,
        buyer_id: OptionalNullable[str] = UNSET,
        buyer_external_identifier: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GiftCard:
        r"""Create gift card

        Store a new gift card in the vault.

        :param number: The 16-19 digit number for the gift card.
        :param pin: The PIN for this gift card.
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param buyer_id: The ID of the buyer to associate this gift card to. If this field is provided then the `buyer_external_identifier` field needs to be unset.
        :param buyer_external_identifier: The `external_identifier` of the buyer to associate this gift card to. If this field is provided then the `buyer_id` field needs to be unset.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateGiftCardRequest(
            merchant_account_id=merchant_account_id,
            gift_card_create=models.GiftCardCreate(
                number=number,
                pin=pin,
                buyer_id=buyer_id,
                buyer_external_identifier=buyer_external_identifier,
            ),
        )

        req = self._build_request(
            method="POST",
            path="/gift-cards",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.CreateGiftCardGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.gift_card_create, False, False, "json", models.GiftCardCreate
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="create_gift_card",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return utils.unmarshal_json(http_res.text, models.GiftCard)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error400Data)
            raise errors.Error400(data=response_data)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error401Data)
            raise errors.Error401(data=response_data)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error403Data)
            raise errors.Error403(data=response_data)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error404Data)
            raise errors.Error404(data=response_data)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error405Data)
            raise errors.Error405(data=response_data)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error409Data)
            raise errors.Error409(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, errors.HTTPValidationErrorData
            )
            raise errors.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error425Data)
            raise errors.Error425(data=response_data)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error429Data)
            raise errors.Error429(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error500Data)
            raise errors.Error500(data=response_data)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error502Data)
            raise errors.Error502(data=response_data)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error504Data)
            raise errors.Error504(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def create_async(
        self,
        *,
        number: str,
        pin: str,
        merchant_account_id: Optional[str] = None,
        buyer_id: OptionalNullable[str] = UNSET,
        buyer_external_identifier: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GiftCard:
        r"""Create gift card

        Store a new gift card in the vault.

        :param number: The 16-19 digit number for the gift card.
        :param pin: The PIN for this gift card.
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param buyer_id: The ID of the buyer to associate this gift card to. If this field is provided then the `buyer_external_identifier` field needs to be unset.
        :param buyer_external_identifier: The `external_identifier` of the buyer to associate this gift card to. If this field is provided then the `buyer_id` field needs to be unset.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateGiftCardRequest(
            merchant_account_id=merchant_account_id,
            gift_card_create=models.GiftCardCreate(
                number=number,
                pin=pin,
                buyer_id=buyer_id,
                buyer_external_identifier=buyer_external_identifier,
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/gift-cards",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.CreateGiftCardGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.gift_card_create, False, False, "json", models.GiftCardCreate
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="create_gift_card",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return utils.unmarshal_json(http_res.text, models.GiftCard)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error400Data)
            raise errors.Error400(data=response_data)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error401Data)
            raise errors.Error401(data=response_data)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error403Data)
            raise errors.Error403(data=response_data)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error404Data)
            raise errors.Error404(data=response_data)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error405Data)
            raise errors.Error405(data=response_data)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error409Data)
            raise errors.Error409(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, errors.HTTPValidationErrorData
            )
            raise errors.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error425Data)
            raise errors.Error425(data=response_data)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error429Data)
            raise errors.Error429(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error500Data)
            raise errors.Error500(data=response_data)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error502Data)
            raise errors.Error502(data=response_data)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error504Data)
            raise errors.Error504(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def list(
        self,
        *,
        buyer_external_identifier: OptionalNullable[str] = UNSET,
        buyer_id: OptionalNullable[str] = UNSET,
        cursor: OptionalNullable[str] = UNSET,
        limit: Optional[int] = 20,
        merchant_account_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ListGiftCardsResponse]:
        r"""List gift cards

        Browser all gift cards.

        :param buyer_external_identifier:
        :param buyer_id:
        :param cursor:
        :param limit:
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListGiftCardsRequest(
            buyer_external_identifier=buyer_external_identifier,
            buyer_id=buyer_id,
            cursor=cursor,
            limit=limit,
            merchant_account_id=merchant_account_id,
        )

        req = self._build_request(
            method="GET",
            path="/gift-cards",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.ListGiftCardsGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(200, 200, 1, 1000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5XX"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list_gift_cards",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.ListGiftCardsResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            next_cursor = JSONPath("$.next_cursor").parse(body)

            if len(next_cursor) == 0:
                return None

            next_cursor = next_cursor[0]
            if next_cursor is None:
                return None

            return self.list(
                buyer_external_identifier=buyer_external_identifier,
                buyer_id=buyer_id,
                cursor=next_cursor,
                limit=limit,
                merchant_account_id=merchant_account_id,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.ListGiftCardsResponse(
                result=utils.unmarshal_json(http_res.text, models.CollectionGiftCard),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error400Data)
            raise errors.Error400(data=response_data)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error401Data)
            raise errors.Error401(data=response_data)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error403Data)
            raise errors.Error403(data=response_data)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error404Data)
            raise errors.Error404(data=response_data)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error405Data)
            raise errors.Error405(data=response_data)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error409Data)
            raise errors.Error409(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, errors.HTTPValidationErrorData
            )
            raise errors.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error425Data)
            raise errors.Error425(data=response_data)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error429Data)
            raise errors.Error429(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error500Data)
            raise errors.Error500(data=response_data)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error502Data)
            raise errors.Error502(data=response_data)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error504Data)
            raise errors.Error504(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def list_async(
        self,
        *,
        buyer_external_identifier: OptionalNullable[str] = UNSET,
        buyer_id: OptionalNullable[str] = UNSET,
        cursor: OptionalNullable[str] = UNSET,
        limit: Optional[int] = 20,
        merchant_account_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ListGiftCardsResponse]:
        r"""List gift cards

        Browser all gift cards.

        :param buyer_external_identifier:
        :param buyer_id:
        :param cursor:
        :param limit:
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListGiftCardsRequest(
            buyer_external_identifier=buyer_external_identifier,
            buyer_id=buyer_id,
            cursor=cursor,
            limit=limit,
            merchant_account_id=merchant_account_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/gift-cards",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.ListGiftCardsGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(200, 200, 1, 1000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5XX"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list_gift_cards",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.ListGiftCardsResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            next_cursor = JSONPath("$.next_cursor").parse(body)

            if len(next_cursor) == 0:
                return None

            next_cursor = next_cursor[0]
            if next_cursor is None:
                return None

            return self.list(
                buyer_external_identifier=buyer_external_identifier,
                buyer_id=buyer_id,
                cursor=next_cursor,
                limit=limit,
                merchant_account_id=merchant_account_id,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.ListGiftCardsResponse(
                result=utils.unmarshal_json(http_res.text, models.CollectionGiftCard),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error400Data)
            raise errors.Error400(data=response_data)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error401Data)
            raise errors.Error401(data=response_data)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error403Data)
            raise errors.Error403(data=response_data)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error404Data)
            raise errors.Error404(data=response_data)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error405Data)
            raise errors.Error405(data=response_data)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error409Data)
            raise errors.Error409(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, errors.HTTPValidationErrorData
            )
            raise errors.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error425Data)
            raise errors.Error425(data=response_data)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error429Data)
            raise errors.Error429(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error500Data)
            raise errors.Error500(data=response_data)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error502Data)
            raise errors.Error502(data=response_data)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error504Data)
            raise errors.Error504(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )
