"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy import utils
from gr4vy.models import errordetail as models_errordetail
from gr4vy.types import BaseModel
from gr4vy.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import List, Literal, Optional
from typing_extensions import Annotated


class Error502Data(BaseModel):
    TYPE: Annotated[
        Annotated[Optional[Literal["error"]], AfterValidator(validate_const("error"))],
        pydantic.Field(alias="type"),
    ] = "error"
    r"""Always `error`."""

    code: Optional[str] = "bad_gateway"
    r"""Always `bad_gateway`"""

    status: Optional[int] = 502
    r"""Always `502`."""

    message: Optional[str] = "Request could not be processed"
    r"""A human readable message that provides more context to the error."""

    details: Optional[List[models_errordetail.ErrorDetail]] = None
    r"""A list of details that further ellaborate on the error."""


class Error502(Exception):
    data: Error502Data

    def __init__(self, data: Error502Data):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, Error502Data)
