# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class GetVolumeResult:
    """
    A collection of values returned by getVolume.
    """
    def __init__(__self__, billing_cycle=None, created=None, description=None, device_ids=None, facility=None, id=None, locked=None, name=None, plan=None, project_id=None, size=None, snapshot_policies=None, state=None, updated=None, volume_id=None):
        if billing_cycle and not isinstance(billing_cycle, str):
            raise TypeError("Expected argument 'billing_cycle' to be a str")
        __self__.billing_cycle = billing_cycle
        """
        The billing cycle, defaults to hourly
        """
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        __self__.created = created
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        __self__.description = description
        if device_ids and not isinstance(device_ids, list):
            raise TypeError("Expected argument 'device_ids' to be a list")
        __self__.device_ids = device_ids
        """
        UUIDs of devices to which this volume is attached
        """
        if facility and not isinstance(facility, str):
            raise TypeError("Expected argument 'facility' to be a str")
        __self__.facility = facility
        """
        The facility slug the volume resides in
        """
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        __self__.id = id
        """
        id is the provider-assigned unique ID for this managed resource.
        """
        if locked and not isinstance(locked, bool):
            raise TypeError("Expected argument 'locked' to be a bool")
        __self__.locked = locked
        """
        Whether the volume is locked or not
        """
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        __self__.name = name
        """
        The name of the volume
        * `project_id ` - The project id the volume is in
        """
        if plan and not isinstance(plan, str):
            raise TypeError("Expected argument 'plan' to be a str")
        __self__.plan = plan
        """
        Performance plan the volume is on
        """
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        __self__.project_id = project_id
        if size and not isinstance(size, float):
            raise TypeError("Expected argument 'size' to be a float")
        __self__.size = size
        """
        The size in GB of the volume
        """
        if snapshot_policies and not isinstance(snapshot_policies, list):
            raise TypeError("Expected argument 'snapshot_policies' to be a list")
        __self__.snapshot_policies = snapshot_policies
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        __self__.state = state
        """
        The state of the volume
        """
        if updated and not isinstance(updated, str):
            raise TypeError("Expected argument 'updated' to be a str")
        __self__.updated = updated
        if volume_id and not isinstance(volume_id, str):
            raise TypeError("Expected argument 'volume_id' to be a str")
        __self__.volume_id = volume_id
class AwaitableGetVolumeResult(GetVolumeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumeResult(
            billing_cycle=self.billing_cycle,
            created=self.created,
            description=self.description,
            device_ids=self.device_ids,
            facility=self.facility,
            id=self.id,
            locked=self.locked,
            name=self.name,
            plan=self.plan,
            project_id=self.project_id,
            size=self.size,
            snapshot_policies=self.snapshot_policies,
            state=self.state,
            updated=self.updated,
            volume_id=self.volume_id)

def get_volume(name=None,project_id=None,volume_id=None,opts=None):
    """
    Provides a Packet Block Storage Volume datasource to allow you to read existing volumes.

    > This content is derived from https://github.com/terraform-providers/terraform-provider-packet/blob/master/website/docs/d/volume.html.markdown.


    :param str name: Name of volume for lookup
    :param str project_id: The ID the parent Packet project (for lookup by name)
    """
    __args__ = dict()


    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['volumeId'] = volume_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = utilities.get_version()
    __ret__ = pulumi.runtime.invoke('packet:index/getVolume:getVolume', __args__, opts=opts).value

    return AwaitableGetVolumeResult(
        billing_cycle=__ret__.get('billingCycle'),
        created=__ret__.get('created'),
        description=__ret__.get('description'),
        device_ids=__ret__.get('deviceIds'),
        facility=__ret__.get('facility'),
        id=__ret__.get('id'),
        locked=__ret__.get('locked'),
        name=__ret__.get('name'),
        plan=__ret__.get('plan'),
        project_id=__ret__.get('projectId'),
        size=__ret__.get('size'),
        snapshot_policies=__ret__.get('snapshotPolicies'),
        state=__ret__.get('state'),
        updated=__ret__.get('updated'),
        volume_id=__ret__.get('volumeId'))
