"use strict";
(self["webpackChunk_julynter_labextension"] = self["webpackChunk_julynter_labextension"] || []).push([["lib_index_js"],{

/***/ "./lib/iconimports.js":
/*!****************************!*\
  !*** ./lib/iconimports.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "julynterIcon": () => (/* binding */ julynterIcon),
/* harmony export */   "julynterNewIcon": () => (/* binding */ julynterNewIcon),
/* harmony export */   "configIcon": () => (/* binding */ configIcon),
/* harmony export */   "requirermentsIcon": () => (/* binding */ requirermentsIcon),
/* harmony export */   "listIcon": () => (/* binding */ listIcon),
/* harmony export */   "typeIcon": () => (/* binding */ typeIcon),
/* harmony export */   "cellIcon": () => (/* binding */ cellIcon),
/* harmony export */   "pathIcon": () => (/* binding */ pathIcon),
/* harmony export */   "importIcon": () => (/* binding */ importIcon),
/* harmony export */   "confuseIcon": () => (/* binding */ confuseIcon),
/* harmony export */   "hiddenStateIcon": () => (/* binding */ hiddenStateIcon),
/* harmony export */   "titleIcon": () => (/* binding */ titleIcon),
/* harmony export */   "minusIcon": () => (/* binding */ minusIcon),
/* harmony export */   "plusIcon": () => (/* binding */ plusIcon),
/* harmony export */   "feedbackIcon": () => (/* binding */ feedbackIcon),
/* harmony export */   "kernelonIcon": () => (/* binding */ kernelonIcon),
/* harmony export */   "kerneloffIcon": () => (/* binding */ kerneloffIcon),
/* harmony export */   "disconnectedIcon": () => (/* binding */ disconnectedIcon),
/* harmony export */   "neverconnectedIcon": () => (/* binding */ neverconnectedIcon),
/* harmony export */   "toggleDownIcon": () => (/* binding */ toggleDownIcon),
/* harmony export */   "toggleRightIcon": () => (/* binding */ toggleRightIcon),
/* harmony export */   "eyeIcon": () => (/* binding */ eyeIcon),
/* harmony export */   "filterIcon": () => (/* binding */ filterIcon),
/* harmony export */   "iconMap": () => (/* binding */ iconMap)
/* harmony export */ });
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _style_img_julynter_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../style/img/julynter.svg */ "./style/img/julynter.svg");
/* harmony import */ var _style_img_julynter_new_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../style/img/julynter_new.svg */ "./style/img/julynter_new.svg");
/* harmony import */ var _style_img_config_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../style/img/config.svg */ "./style/img/config.svg");
/* harmony import */ var _style_img_rename_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../style/img/rename.svg */ "./style/img/rename.svg");
/* harmony import */ var _style_img_list_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../style/img/list.svg */ "./style/img/list.svg");
/* harmony import */ var _style_img_type_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../style/img/type.svg */ "./style/img/type.svg");
/* harmony import */ var _style_img_cell_svg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../style/img/cell.svg */ "./style/img/cell.svg");
/* harmony import */ var _style_img_absolute_path_svg__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../style/img/absolute_path.svg */ "./style/img/absolute_path.svg");
/* harmony import */ var _style_img_import_svg__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../style/img/import.svg */ "./style/img/import.svg");
/* harmony import */ var _style_img_confuse_notebook_svg__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../style/img/confuse_notebook.svg */ "./style/img/confuse_notebook.svg");
/* harmony import */ var _style_img_hidden_state_svg__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../style/img/hidden_state.svg */ "./style/img/hidden_state.svg");
/* harmony import */ var _style_img_title_svg__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../style/img/title.svg */ "./style/img/title.svg");
/* harmony import */ var _style_img_minus_svg__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../style/img/minus.svg */ "./style/img/minus.svg");
/* harmony import */ var _style_img_plus_svg__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../style/img/plus.svg */ "./style/img/plus.svg");
/* harmony import */ var _style_img_feedback_svg__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../style/img/feedback.svg */ "./style/img/feedback.svg");
/* harmony import */ var _style_img_kernelon_svg__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../style/img/kernelon.svg */ "./style/img/kernelon.svg");
/* harmony import */ var _style_img_kerneloff_svg__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../style/img/kerneloff.svg */ "./style/img/kerneloff.svg");
/* harmony import */ var _style_img_disconnected_svg__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../style/img/disconnected.svg */ "./style/img/disconnected.svg");
/* harmony import */ var _style_img_neverconnected_svg__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../style/img/neverconnected.svg */ "./style/img/neverconnected.svg");
/* harmony import */ var _style_img_toggle_down_svg__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../style/img/toggle_down.svg */ "./style/img/toggle_down.svg");
/* harmony import */ var _style_img_toggle_right_svg__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../style/img/toggle_right.svg */ "./style/img/toggle_right.svg");
/* harmony import */ var _style_img_eye_svg__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../style/img/eye.svg */ "./style/img/eye.svg");
/* harmony import */ var _style_img_filter_svg__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../style/img/filter.svg */ "./style/img/filter.svg");
























const julynterIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'julynter:icon',
    svgstr: _style_img_julynter_svg__WEBPACK_IMPORTED_MODULE_1__["default"]
});
const julynterNewIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'julynter:newicon',
    svgstr: _style_img_julynter_new_svg__WEBPACK_IMPORTED_MODULE_2__["default"]
});
const configIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'julynter:config',
    svgstr: _style_img_config_svg__WEBPACK_IMPORTED_MODULE_3__["default"]
});
const requirermentsIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'julynter:requirements',
    svgstr: _style_img_rename_svg__WEBPACK_IMPORTED_MODULE_4__["default"]
});
const listIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'julynter:list',
    svgstr: _style_img_list_svg__WEBPACK_IMPORTED_MODULE_5__["default"]
});
const typeIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'julynter:type',
    svgstr: _style_img_type_svg__WEBPACK_IMPORTED_MODULE_6__["default"]
});
const cellIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'julynter:cell',
    svgstr: _style_img_cell_svg__WEBPACK_IMPORTED_MODULE_7__["default"]
});
const pathIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'julynter:path',
    svgstr: _style_img_absolute_path_svg__WEBPACK_IMPORTED_MODULE_8__["default"]
});
const importIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'julynter:import',
    svgstr: _style_img_import_svg__WEBPACK_IMPORTED_MODULE_9__["default"]
});
const confuseIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'julynter:confuse',
    svgstr: _style_img_confuse_notebook_svg__WEBPACK_IMPORTED_MODULE_10__["default"]
});
const hiddenStateIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'julynter:hiddenstate',
    svgstr: _style_img_hidden_state_svg__WEBPACK_IMPORTED_MODULE_11__["default"]
});
const titleIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'julynter:title',
    svgstr: _style_img_title_svg__WEBPACK_IMPORTED_MODULE_12__["default"]
});
const minusIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'julynter:minus',
    svgstr: _style_img_minus_svg__WEBPACK_IMPORTED_MODULE_13__["default"]
});
const plusIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'julynter:plus',
    svgstr: _style_img_plus_svg__WEBPACK_IMPORTED_MODULE_14__["default"]
});
const feedbackIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'julynter:feedback',
    svgstr: _style_img_feedback_svg__WEBPACK_IMPORTED_MODULE_15__["default"]
});
const kernelonIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'julynter:kernelon',
    svgstr: _style_img_kernelon_svg__WEBPACK_IMPORTED_MODULE_16__["default"]
});
const kerneloffIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'julynter:kerneloff',
    svgstr: _style_img_kerneloff_svg__WEBPACK_IMPORTED_MODULE_17__["default"]
});
const disconnectedIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'julynter:disconnected',
    svgstr: _style_img_disconnected_svg__WEBPACK_IMPORTED_MODULE_18__["default"]
});
const neverconnectedIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'julynter:neverconnected',
    svgstr: _style_img_neverconnected_svg__WEBPACK_IMPORTED_MODULE_19__["default"]
});
const toggleDownIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'julynter:toggledown',
    svgstr: _style_img_toggle_down_svg__WEBPACK_IMPORTED_MODULE_20__["default"]
});
const toggleRightIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'julynter:toggleright',
    svgstr: _style_img_toggle_right_svg__WEBPACK_IMPORTED_MODULE_21__["default"]
});
const eyeIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'julynter:eye', svgstr: _style_img_eye_svg__WEBPACK_IMPORTED_MODULE_22__["default"] });
const filterIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.LabIcon({
    name: 'julynter:filter',
    svgstr: _style_img_filter_svg__WEBPACK_IMPORTED_MODULE_23__["default"]
});
const iconMap = {
    absolutepath: pathIcon,
    import: importIcon,
    confusenotebook: confuseIcon,
    hiddenstate: hiddenStateIcon,
    invalidtitle: titleIcon
};


/***/ }),

/***/ "./lib/index.js":
/*!**********************!*\
  !*** ./lib/index.js ***!
  \**********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _jupyterlab_application__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/application */ "webpack/sharing/consume/default/@jupyterlab/application");
/* harmony import */ var _jupyterlab_application__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_application__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/docmanager */ "webpack/sharing/consume/default/@jupyterlab/docmanager");
/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _linterlab_julynter__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./linterlab/julynter */ "./lib/linterlab/julynter.js");
/* harmony import */ var _style_index_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../style/index.css */ "./style/index.css");
/* harmony import */ var _linterlab_errorhandler__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./linterlab/errorhandler */ "./lib/linterlab/errorhandler.js");
/* harmony import */ var _iconimports__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./iconimports */ "./lib/iconimports.js");







/**
 * Initialization data for the julynter extension.
 */
const extension = {
    id: 'jupyterlab-extension:julynter',
    autoStart: true,
    requires: [_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2__.IDocumentManager, _jupyterlab_application__WEBPACK_IMPORTED_MODULE_0__.ILabShell, _jupyterlab_application__WEBPACK_IMPORTED_MODULE_0__.ILayoutRestorer, _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1__.INotebookTracker],
    activate: activateJulynter,
};
// VariableInspectionHandler -> JulynterHandler
function activateJulynter(app, docmanager, labShell, restorer, notebookTracker) {
    const eh = new _linterlab_errorhandler__WEBPACK_IMPORTED_MODULE_4__.ErrorHandler();
    try {
        // Create the widget.
        const julynter = new _linterlab_julynter__WEBPACK_IMPORTED_MODULE_5__.Julynter(docmanager, notebookTracker, labShell, eh);
        // Add the julynter to the left area.
        julynter.title.icon = _iconimports__WEBPACK_IMPORTED_MODULE_6__.julynterIcon.bindprops({ stylesheet: 'sideBar' });
        julynter.title.caption = 'Julynter';
        julynter.id = 'julynter';
        labShell.add(julynter, 'left', { rank: 700 });
        // Add the julynter widget to the application restorer.
        restorer.add(julynter, 'juputerlab-julynter');
        /**
         * Subscribes to the creation of new notebooks. If a new notebook is created, build a new handler for the notebook.
         * Adds a promise for a instanced handler to the 'handlers' collection.
         */
        notebookTracker.widgetAdded.connect((sender, nbPanel) => {
            julynter.addNewNotebook(nbPanel);
        });
        // Change the julynter when the active widget changes.
        labShell.currentChanged.connect((sender, args) => {
            const widget = args.newValue;
            if (!widget) {
                return;
            }
            julynter.changeActiveWidget(widget);
        });
        console.log('JupyterLab extension julynter is activated!');
        //return julynter;
    }
    catch (error) {
        throw eh.report(error, 'activateJulynter', []);
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (extension);


/***/ }),

/***/ "./lib/linter/interfaces.js":
/*!**********************************!*\
  !*** ./lib/linter/interfaces.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ViewModes": () => (/* binding */ ViewModes),
/* harmony export */   "ErrorTypeKeys": () => (/* binding */ ErrorTypeKeys),
/* harmony export */   "ReportIds": () => (/* binding */ ReportIds),
/* harmony export */   "GenericMatcher": () => (/* binding */ GenericMatcher)
/* harmony export */ });
/**
 * Possible visualization modes
 */
const ViewModes = ['list', 'cell', 'type'];
/**
 * Possible report types
 */
const ErrorTypeKeys = [
    'invalidtitle',
    'hiddenstate',
    'confusenotebook',
    'import',
    'absolutepath',
];
/**
 * Possible report ids
 */
const ReportIds = [
    'c1',
    'c2',
    'c3',
    'c4',
    'c5',
    'h1',
    'h2',
    'h3',
    'h4',
    'h5',
    'h6',
    'i1',
    'i2',
    'p1',
    't1',
    't2',
    't3',
    't4',
    't5',
    't6',
    't7',
];
const GenericMatcher = {
    kernel: null,
    language: null,
    initScript: null,
    name: 'default',
};


/***/ }),

/***/ "./lib/linter/lint.js":
/*!****************************!*\
  !*** ./lib/linter/lint.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "hash": () => (/* binding */ hash),
/* harmony export */   "Linter": () => (/* binding */ Linter)
/* harmony export */ });
/* harmony import */ var _reports__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./reports */ "./lib/linter/reports.js");
/* harmony import */ var _interfaces__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./interfaces */ "./lib/linter/interfaces.js");
/* harmony import */ var sha1__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! sha1 */ "webpack/sharing/consume/default/sha1/sha1");
/* harmony import */ var sha1__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(sha1__WEBPACK_IMPORTED_MODULE_0__);



function hash(value) {
    return sha1__WEBPACK_IMPORTED_MODULE_0___default()(value);
}
class Linter {
    constructor(options, update, hasKernel) {
        this.hasKernel = false;
        this.options = options;
        this.hasKernel = hasKernel;
        this.update = update;
    }
    generate(notebookMetadata, itemGenerator, groupGenerator) {
        const headings = [];
        let hashSource = this.checkTitle(notebookMetadata, headings, itemGenerator);
        hashSource += this.checkCellDefinitions(notebookMetadata, headings, itemGenerator);
        const result = this.createFilteredResult(headings, hash(hashSource));
        if (this.options.checkMode() === 'cell') {
            result.visible = this.groupByCell(result.visible, groupGenerator);
        }
        else if (this.options.checkMode() === 'type') {
            result.visible = this.groupByType(result.visible, groupGenerator);
        }
        return result;
    }
    checkTitle(notebookMetadata, headings, generator) {
        const title = notebookMetadata.title.toLowerCase();
        if (title === '.ipynb') {
            headings.push(generator.create('title', 'title', 't1', title, []));
        }
        if (title.startsWith('untitled')) {
            headings.push(generator.create('title', 'title', 't2', title, []));
        }
        if (title.includes('-copy')) {
            headings.push(generator.create('title', 'title', 't3', title, []));
        }
        if (title.includes(' ')) {
            headings.push(generator.create('title', 'title', 't4', title, []));
        }
        if (!/^([a-z]|[0-9]|_|-| |\.)*$/.test(title)) {
            headings.push(generator.create('title', 'title', 't5', title, []));
        }
        if (title.length > 100) {
            headings.push(generator.create('title', 'title', 't6', title, []));
        }
        if (title.length < 10) {
            headings.push(generator.create('title', 'title', 't7', title, []));
        }
        return title + ':';
    }
    checkCellDefinitions(notebookMetadata, headings, itemGenerator) {
        // Iterate through the cells in the notebook
        const executionCounts = {};
        const nonExecutedTail = this.getNonExecutedTail(notebookMetadata);
        const emptyTail = this.getEmptyTail(notebookMetadata);
        const executedCode = this.update.executed_code;
        const cellDependencies = this.update.cell_dependencies || {};
        const missingDependencies = this.update.missing_dependencies || {};
        const missingRequirements = this.update.missing_requirements || {};
        let lastExecutionCount = -1;
        let firstCodeCell = -1;
        let lastText = '';
        let emptyCounter = 0;
        let hashSource = '';
        for (let i = 0; i < notebookMetadata.cells.length; i++) {
            const cell = notebookMetadata.cells[i];
            const model = cell.model;
            const text = model.value.text;
            if (model.type === 'code') {
                if (firstCodeCell === -1) {
                    firstCodeCell = i;
                }
                const executionCount = cell.model
                    .executionCount;
                const executionCountNumber = executionCount;
                hashSource += `[${executionCountNumber || ''}]`;
                if (this.hasKernel) {
                    if (executionCountNumber !== null &&
                        executionCountNumber !== undefined) {
                        if (!{}.hasOwnProperty.call(executedCode, executionCountNumber)) {
                            headings.push(itemGenerator.create(i, cell.model.type, 'h1', `[${executionCountNumber}]${text}`, [i]));
                        }
                        else {
                            const historyCode = executedCode[executionCountNumber].trim();
                            if (historyCode !== text.trim()) {
                                headings.push(itemGenerator.create(i, cell.model.type, 'h2', `[${executionCountNumber}]${historyCode}`, [i]));
                            }
                        }
                    }
                }
                if (executionCountNumber === null) {
                    if (i < nonExecutedTail && model.value.text.trim() !== '') {
                        headings.push(itemGenerator.create(i, cell.model.type, 'c1', text, [i]));
                    }
                }
                else {
                    if (executionCountNumber < lastExecutionCount) {
                        headings.push(itemGenerator.create(i, cell.model.type, 'c2', `[${executionCountNumber}]${text}`, [i, executionCountNumber]));
                    }
                    if ({}.hasOwnProperty.call(executionCounts, executionCountNumber)) {
                        headings.push(itemGenerator.create(i, cell.model.type, 'h3', `[${executionCountNumber}]${text}`, [i, executionCountNumber]));
                    }
                    executionCounts[executionCountNumber] = [i, cell];
                    lastExecutionCount = executionCountNumber;
                }
            }
            hashSource += text + ';;;';
            if (text.trim() === '' && i < emptyTail) {
                headings.push(itemGenerator.create(i, cell.model.type, 'c3', `-${emptyCounter}-${lastText}`, [i]));
                emptyCounter += 1;
            }
            else {
                lastText = text;
                emptyCounter = 0;
            }
        }
        const hasImports = this.update.has_imports || [];
        const absolutePaths = this.update.absolute_paths || {};
        const hasKernel = this.hasKernel;
        lastExecutionCount = null;
        Object.keys(executionCounts)
            .sort((a, b) => Number(a) - Number(b))
            .forEach((currentCountS, i) => {
            const currentCount = Number(currentCountS);
            const tuple = executionCounts[currentCount];
            const cell = tuple[1];
            const index = tuple[0];
            const model = cell.model;
            const text = model.value.text;
            if (hasImports.includes(currentCount) && index !== firstCodeCell) {
                headings.push(itemGenerator.create(index, cell.model.type, 'i1', text, [index]));
            }
            if ({}.hasOwnProperty.call(absolutePaths, currentCount)) {
                headings.push(itemGenerator.create(index, cell.model.type, 'p1', text, [
                    index,
                    absolutePaths[currentCount].map((x) => "'" + x + "'").join(', '),
                ]));
            }
            if ({}.hasOwnProperty.call(missingRequirements, currentCount)) {
                Object.keys(missingRequirements[currentCount]).forEach((module, j) => {
                    headings.push(itemGenerator.create(index, cell.model.type, 'i2', `:${module}:${text}`, [index, module]));
                });
            }
            if (lastExecutionCount === null && currentCount !== 1) {
                headings.push(itemGenerator.create(index, cell.model.type, 'h4', text, [index]));
            }
            else if (lastExecutionCount !== null &&
                lastExecutionCount !== currentCount - 1) {
                headings.push(itemGenerator.create(index, cell.model.type, 'h4', text, [index]));
            }
            lastExecutionCount = currentCount;
            if (hasKernel) {
                const dependencies = cellDependencies[currentCount];
                if (dependencies !== undefined) {
                    Object.keys(dependencies).forEach((variable) => {
                        const number = Number(dependencies[variable]);
                        if (!{}.hasOwnProperty.call(executionCounts, number)) {
                            headings.push(itemGenerator.create(index, cell.model.type, 'h5', `${variable};${text}`, [index, number, executedCode[number], variable]));
                        }
                    });
                }
                const missing = missingDependencies[currentCount];
                if (missing !== undefined && missing.length > 0) {
                    headings.push(itemGenerator.create(index, cell.model.type, 'h6', `${missing.join(',')};${text}`, [index, missing.map((x) => "'" + x + "'").join(', ')]));
                }
            }
        });
        if (notebookMetadata.cells.length > 0) {
            const cell = notebookMetadata.cells[0];
            const model = cell.model;
            const text = model.value.text;
            if (model.type !== 'markdown') {
                headings.push(itemGenerator.create(0, cell.model.type, 'c4', text, [0]));
            }
        }
        if (emptyTail > 1) {
            const cell = notebookMetadata.cells[emptyTail - 1];
            const model = cell.model;
            const text = model.value.text;
            if (model.type !== 'markdown') {
                headings.push(itemGenerator.create(emptyTail - 1, cell.model.type, 'c5', text, [
                    emptyTail - 1,
                ]));
            }
        }
        return hashSource;
    }
    getNonExecutedTail(notebookMetadata) {
        let nonExecutedTail = notebookMetadata.cells.length;
        for (let i = notebookMetadata.cells.length - 1; i >= 0; i--) {
            const cell = notebookMetadata.cells[i];
            const model = cell.model;
            if (model.type === 'code') {
                const executionCountNumber = cell.model
                    .executionCount;
                if (executionCountNumber === null) {
                    nonExecutedTail = i;
                }
                else {
                    break;
                }
            }
        }
        return nonExecutedTail;
    }
    getEmptyTail(notebookMetadata) {
        let emptyTail = notebookMetadata.cells.length;
        for (let i = notebookMetadata.cells.length - 1; i >= 0; i--) {
            const cell = notebookMetadata.cells[i];
            const model = cell.model;
            const text = model.value.text;
            if (text.trim() === '') {
                emptyTail = i;
            }
            else {
                break;
            }
        }
        return emptyTail;
    }
    createFilteredResult(headings, notebookHash) {
        const options = this.options;
        const filtered = options.checkFiltered();
        const result = {
            visible: [],
            filteredType: [],
            filteredId: [],
            filteredRestart: [],
            filteredIndividual: [],
            hash: notebookHash,
        };
        headings.forEach((element) => {
            if (!options.checkType(element.reportType)) {
                result.filteredType.push(element);
            }
            else if (element.reportId !== 'group' &&
                !options.checkReport(element.reportId)) {
                result.filteredId.push(element);
            }
            else if (element.restart && !options.checkRestart()) {
                result.filteredRestart.push(element);
            }
            else if (filtered.includes(element.hash)) {
                result.filteredIndividual.push(element);
            }
            else {
                result.visible.push(element);
            }
        });
        return result;
    }
    groupByCell(headings, groupGenerator) {
        const groups = {};
        headings.forEach((element) => {
            if (element.cellId in groups) {
                groups[element.cellId].push(element);
            }
            else {
                groups[element.cellId] = [element];
            }
        });
        const newHeadings = [];
        for (const key in groups) {
            const elements = groups[key];
            newHeadings.push(groupGenerator.create(key, 'group', elements));
            newHeadings.push(...elements);
        }
        return newHeadings;
    }
    groupByType(headings, groupGenerator) {
        const groups = {};
        headings.forEach((element) => {
            if (element.reportType in groups) {
                groups[element.reportType].push(element);
            }
            else {
                groups[element.reportType] = [element];
            }
        });
        const newHeadings = [];
        for (const key of _interfaces__WEBPACK_IMPORTED_MODULE_1__.ErrorTypeKeys) {
            const elements = groups[key];
            if (elements) {
                const groupText = _reports__WEBPACK_IMPORTED_MODULE_2__.ERROR_TYPES_MAP[key].label;
                newHeadings.push(groupGenerator.create(groupText, key, elements));
                newHeadings.push(...elements);
            }
        }
        return newHeadings;
    }
}


/***/ }),

/***/ "./lib/linter/options.js":
/*!*******************************!*\
  !*** ./lib/linter/options.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AbstractOptionsManager": () => (/* binding */ AbstractOptionsManager)
/* harmony export */ });
/* harmony import */ var _interfaces__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./interfaces */ "./lib/linter/interfaces.js");

class AbstractOptionsManager {
    checkReport(key) {
        return this.checks.reports[key];
    }
    checkType(key) {
        return this.checks.types[key];
    }
    checkMode() {
        return this.checks.mode;
    }
    checkView() {
        return this.checks.view;
    }
    checkRestart() {
        return this.checks.restart;
    }
    checkRequirements() {
        return this.checks.requirements;
    }
    checkFiltered() {
        return this.filteredHashes;
    }
    updateReport(key, value) {
        this.checks.reports[key] = value;
        this.saveKey('report-' + key, value, true);
    }
    updateType(key, value) {
        this.checks.types[key] = value;
        this.saveKey('type-' + key, value, true);
    }
    updateMode(mode) {
        this.checks.mode = mode;
        this.saveKey('mode', mode, true);
    }
    updateView(view) {
        this.checks.view = view;
        this.saveKey('view', view, true);
    }
    updateRestart(restart) {
        this.checks.restart = restart;
        this.saveKey('restart', restart, true);
    }
    updateRequirements(req) {
        this.checks.requirements = req;
        this.saveKey('requirements', req, true);
    }
    resetFiltered() {
        this.filteredHashes = [];
        this.saveKey('filtered-hashes', this.filteredHashes, true);
    }
    addLintFilter(hash) {
        this.filteredHashes.push(hash);
        this.saveKey('filtered-hashes', this.filteredHashes, true);
    }
    // initialize options, will NOT change notebook metadata
    initializeOptions(checks, filteredHashes) {
        this.checks = checks;
        this.filteredHashes = filteredHashes;
    }
    reloadOptions() {
        this.initializeOptions({
            mode: this.loadKey('mode', this.default.mode),
            view: this.loadKey('view', this.default.view),
            restart: this.loadKey('restart', this.default.restart),
            requirements: this.loadKey('requirements', this.default.requirements),
            reports: _interfaces__WEBPACK_IMPORTED_MODULE_0__.ReportIds.reduce((previous, key) => {
                const rkey = 'report-' + key;
                previous[key] = this.loadKey(rkey, this.default.reports[key]);
                return previous;
            }, Object.assign({}, this.default.reports)),
            types: _interfaces__WEBPACK_IMPORTED_MODULE_0__.ErrorTypeKeys.reduce((previous, key) => {
                const tkey = 'type-' + key;
                previous[key] = this.loadKey(tkey, this.default.types[key]);
                return previous;
            }, Object.assign({}, this.default.types)),
            kernel: this.default.kernel,
        }, this.loadKey('filtered-hashes', []));
    }
    saveOptions() {
        this.saveKey('mode', this.checks.mode, false);
        this.saveKey('view', this.checks.view, false);
        this.saveKey('restart', this.checks.restart, false);
        this.saveKey('requirements', this.checks.requirements, false);
        for (const key of _interfaces__WEBPACK_IMPORTED_MODULE_0__.ErrorTypeKeys) {
            this.saveKey('type-' + key, this.checks.types[key], false);
        }
        for (const key of _interfaces__WEBPACK_IMPORTED_MODULE_0__.ReportIds) {
            this.saveKey('report-' + key, this.checks.reports[key], false);
        }
        this.saveKey('filtered-hashes', this.filteredHashes, false);
    }
}


/***/ }),

/***/ "./lib/linter/reports.js":
/*!*******************************!*\
  !*** ./lib/linter/reports.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ERROR_TYPES_MAP": () => (/* binding */ ERROR_TYPES_MAP),
/* harmony export */   "ERROR_TYPES": () => (/* binding */ ERROR_TYPES),
/* harmony export */   "ERRORS": () => (/* binding */ ERRORS)
/* harmony export */ });
const ERROR_TYPES_MAP = {
    invalidtitle: {
        key: 'invalidtitle',
        label: 'Invalid Title',
        toggle: 'Toggle Title Checking',
    },
    hiddenstate: {
        key: 'hiddenstate',
        label: 'Hidden State',
        toggle: 'Toggle Hidden State Checking',
    },
    confusenotebook: {
        key: 'confusenotebook',
        label: 'Confuse Notebook',
        toggle: 'Toggle Confuse Notebook Checking',
    },
    import: {
        key: 'import',
        label: 'Import',
        toggle: 'Toggle Import Checking',
    },
    absolutepath: {
        key: 'absolutepath',
        label: 'Absolute Path',
        toggle: 'Toggle Absolute Path Checking',
    },
};
const ERROR_TYPES = [
    ERROR_TYPES_MAP.invalidtitle,
    ERROR_TYPES_MAP.hiddenstate,
    ERROR_TYPES_MAP.confusenotebook,
    ERROR_TYPES_MAP.import,
    ERROR_TYPES_MAP.absolutepath,
];
const goToCell = {
    label: 'Go to cell',
    title: 'Move notebook scroll to cell',
    execute(itemgenerator, index, ...others) {
        return () => {
            itemgenerator.goToCell(index);
        };
    },
};
const renameNotebook = {
    label: 'Rename notebook',
    title: 'Open notebook rename dialog',
    execute(itemgenerator, ...others) {
        return () => {
            itemgenerator.renameNotebook();
        };
    },
};
const addModule = {
    label: 'Add module',
    title: 'Add module to requirements file',
    execute(itemgenerator, index, module, ...others) {
        return () => {
            itemgenerator.addModule(index, module);
        };
    },
};
const restoreCell = {
    label: 'Restore cell',
    title: 'Create deleted cell',
    execute: (itemgenerator, index, execCount, code, ...others) => {
        return () => {
            itemgenerator.restoreCell(index, execCount, code);
        };
    },
};
const ERRORS = {
    // Confuse notebook
    c1: {
        label: (i) => `Cell ${i} is a non-executed cell among executed ones`,
        suggestion: 'Please consider cleaning it to guarantee the reproducibility.',
        type: 'confusenotebook',
        action: goToCell,
        restart: false,
        reason: 'When you try to run all cells following the top-down order, non-executed cells might fail to execute or produce different results, hampering the reproducibility.',
    },
    c2: {
        label: (i, executionCountNumber) => `Cell ${i} has the execution count ${executionCountNumber} in the wrong order`,
        suggestion: 'Please consider re-running the notebook to guarantee the reproducibility.',
        type: 'confusenotebook',
        action: goToCell,
        restart: true,
        reason: 'When you try to run all cells following the top-down order, cells in the wrong order might fail to execute or produce different results, hampering the reproducibility.',
    },
    c3: {
        label: (i) => `Cell ${i} is empty in the middle of the notebook`,
        suggestion: 'Please consider removing it to improve the readability.',
        type: 'confusenotebook',
        action: goToCell,
        restart: false,
        reason: 'Empty cells in between executable ones occupy space and might impact the readability of the notebook.',
    },
    c4: {
        label: (i) => 'The first cell of the notebook is not a markdown cell',
        suggestion: 'Please consider adding a markdown cell to describe the notebook.',
        type: 'confusenotebook',
        action: goToCell,
        restart: false,
        reason: 'A markdown cell at the beginning of the notebook can provide a human-friendly title with no constraints and introduce the notebook, indicating its purpose and external requirements.',
    },
    c5: {
        label: (i) => 'The last cell of the notebook is not a markdown cell',
        suggestion: 'Please consider adding a markdown cell to conclude the notebook.',
        type: 'confusenotebook',
        action: goToCell,
        restart: false,
        reason: 'A markdown cell at the end of the notebook can conclude it, presenting a summary of the obtained results.',
    },
    // Hidden State
    h1: {
        label: (i) => `Cell ${i} has execution results, but it wasn't executed on this session`,
        suggestion: 'Please consider executing it to guarantee the reproducibility.',
        type: 'hiddenstate',
        action: goToCell,
        restart: false,
        reason: 'A cell with results of a previous session may fail to execute or produce different results in this one, hampering the reproducibility.',
    },
    h2: {
        label: (i) => `Cell ${i} has changed since its execution, but it wasn't executed after the changes`,
        suggestion: 'Please consider re-executing it to guarantee the reproducibility.',
        type: 'hiddenstate',
        action: goToCell,
        restart: false,
        reason: 'A cell with code changes may produce different results than what it generated before the changes, hampering the reproducibility.',
    },
    h3: {
        label: (i, executionCountNumber) => `Cell ${i} repeats the execution count ${executionCountNumber}`,
        suggestion: 'Please consider re-running the cell to guarantee the reproducibility.',
        type: 'hiddenstate',
        action: goToCell,
        restart: false,
        reason: 'A cell with a repeated execution count indicates that there are results of multiple execution sessions in this notebook. Running all cells in the top-down order might produce different results, hampering the reproducibility.',
    },
    h4: {
        label: (i) => `Cell ${i} skips the execution count`,
        suggestion: 'Please consider re-running the notebook to guarantee the reproducibility.',
        type: 'hiddenstate',
        action: goToCell,
        restart: true,
        reason: 'A skip in the execution count might indicate the presence of a hidden state caused by a cell that does not exist anymore. Hidden states might prevent cells from executing or producing the same results, hampering the reproducibility.',
    },
    h5: {
        label: (i, dep, code, variable) => `Cell ${i} uses name '${variable}' that was defined on In[${dep}], but it does not exist anymore`,
        suggestion: 'Please consider restoring the cell and re-running the notebook to guarantee the reproducibility.',
        type: 'hiddenstate',
        action: restoreCell,
        restart: false,
        reason: 'The cell that created the name was removed or edited, indicating a hidden state. Using a variable from a cell that does not exist anymore prevents the reproducibility of the notebook.',
    },
    h6: {
        label: (i, missing) => `Cell ${i} has the following undefined names: ${missing}`,
        suggestion: 'Please consider defining them to guarantee the reproducibility.',
        type: 'hiddenstate',
        action: goToCell,
        restart: false,
        reason: 'The cell uses a name that does not exist in this notebook. Using a name that does not exist prevents the reproducibility of the notebook.',
    },
    // Import
    i1: {
        label: (i) => `Cell ${i} has imports but it is not the first cell`,
        suggestion: 'Please consider moving the import to the first cell of the notebook.',
        type: 'import',
        action: goToCell,
        restart: false,
        reason: "Imports at the beginning of the notebook allow for a quick failure in the case of a non-installed dependency. It prevents users from stopping their executions for installing dependencies. Additionally, imports in the middle might reduce notebooks' readability by taking the attention from the logic to the import constructs.",
    },
    i2: {
        label: (i, module) => `Module ${module} was imported by Cell ${i}, but it is not in the requirements file`,
        suggestion: 'Please consider adding them to guarantee the reproducibility.',
        type: 'import',
        action: addModule,
        restart: false,
        reason: 'Using a requirements file with pinned versions for all imported modules increases the reproducibility of the notebook.',
    },
    // Path
    p1: {
        label: (i, paths) => `Cell ${i} has the following absolute paths: ${paths}`,
        suggestion: 'Please consider using relative paths to guarantee the reproducibility.',
        type: 'absolutepath',
        action: goToCell,
        restart: false,
        reason: 'Absolute paths prevent from running the notebook at different machines, hampering the reproducibility.',
    },
    // Title
    t1: {
        label: () => 'Title is empty',
        suggestion: 'Please consider renaming it to a meaningful name.',
        type: 'invalidtitle',
        action: renameNotebook,
        restart: false,
        reason: 'Empty titles are meaningless and provide no context for who is selecting the notebook in the file browser.',
    },
    t2: {
        label: () => 'Title starts with "Untitled"',
        suggestion: 'Please consider renaming it to a meaningful name.',
        type: 'invalidtitle',
        action: renameNotebook,
        restart: false,
        reason: 'Untitled notebooks provide no context for who is selecting the notebook in the file browser.',
    },
    t3: {
        label: () => 'Title has "-Copy"',
        suggestion: 'Please consider renaming it to a meaningful name.',
        type: 'invalidtitle',
        action: renameNotebook,
        restart: false,
        reason: 'Notebooks with "-Copy" in their name are hard to distinguish from their original version in the file browser.',
    },
    t4: {
        label: () => 'Title has blank spaces',
        suggestion: 'Please consider replacing them to support all OS.',
        type: 'invalidtitle',
        action: renameNotebook,
        restart: false,
        reason: 'Blank spaces on filenames are not safe to use on all operating systems, hampering the interoperability.',
    },
    t5: {
        label: () => 'Title has special characters',
        suggestion: 'Please consider replacing them to support all OS.',
        type: 'invalidtitle',
        action: renameNotebook,
        restart: false,
        reason: 'Special characters on filenames are not safe to use on all operating systems, hampering the interoperability.',
    },
    t6: {
        label: () => 'Title is too big',
        suggestion: 'Please consider renaming it a smaller name and using a markdown cell for the full name.',
        type: 'invalidtitle',
        action: renameNotebook,
        restart: false,
        reason: 'Big names not only cause problems on some operating systems but also are hard to read on tabs and some file browsers.',
    },
    t7: {
        label: () => 'Title is too small',
        suggestion: 'Please consider renaming it a meaningful name.',
        type: 'invalidtitle',
        action: renameNotebook,
        restart: false,
        reason: 'Small titles might be meaningless and provide no context for selecting the notebook in the file browser.',
    },
};


/***/ }),

/***/ "./lib/linterlab/config.js":
/*!*********************************!*\
  !*** ./lib/linterlab/config.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Config": () => (/* binding */ Config)
/* harmony export */ });
/* harmony import */ var _server__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../server */ "./lib/server.js");
/* harmony import */ var _linter_interfaces__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../linter/interfaces */ "./lib/linter/interfaces.js");
/* harmony import */ var _experimentmanager__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./experimentmanager */ "./lib/linterlab/experimentmanager.js");



class Config {
    constructor(experimentConfig, status, eh) {
        this._eh = eh;
        this.defaultOptions = this.createDefault();
        this.experimentConfig = experimentConfig;
        this.status = status;
        this.load();
    }
    createDefault() {
        return {
            mode: 'type',
            view: true,
            restart: true,
            requirements: 'requirements.txt',
            types: {
                invalidtitle: true,
                hiddenstate: true,
                confusenotebook: true,
                import: true,
                absolutepath: true,
            },
            reports: {
                c1: true,
                c2: true,
                c3: true,
                c4: true,
                c5: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                h6: true,
                i1: true,
                i2: true,
                p1: true,
                t1: true,
                t2: true,
                t3: true,
                t4: true,
                t5: true,
                t6: true,
                t7: true,
            },
            kernel: {
                order: ['python', 'default'],
                values: {
                    python: {
                        language: 'python',
                        initScript: 'import julynter.kernel; julynter.kernel.init()',
                    },
                    default: {
                        kernel: '.*',
                        initScript: null,
                    },
                },
            },
        };
    }
    loadData(options, experiment, data) {
        /* eslint @typescript-eslint/explicit-module-boundary-types: 0 */
        try {
            if (options) {
                this.merge(options, data.options);
            }
            if (experiment) {
                const dataExperiment = data.experiment;
                if (dataExperiment) {
                    for (const key of _experimentmanager__WEBPACK_IMPORTED_MODULE_0__.IExperimentConfigAttributes) {
                        const value = dataExperiment[key];
                        if (value !== undefined && value !== null) {
                            experiment[key] = value;
                        }
                    }
                }
                else {
                    experiment.enabled = false;
                }
                this.status.experiment = experiment.enabled;
            }
            else {
                this.status.experiment = false;
            }
        }
        catch (error) {
            throw this._eh.report(error, 'Config:loadData', [
                options,
                experiment,
                data,
            ]);
        }
    }
    load(onSuccess, onError) {
        try {
            (0,_server__WEBPACK_IMPORTED_MODULE_1__.requestAPI)('config')
                .then((data) => {
                this.loadData(this.defaultOptions, this.experimentConfig, data);
                if (onSuccess) {
                    onSuccess(data);
                }
            })
                .catch((reason) => {
                this.status.serverSide = false;
                this._eh.report(`The julynter server extension appears to be missing.\n${reason}`, 'Config:loadData', []);
                if (onError) {
                    onError(reason);
                }
            });
        }
        catch (error) {
            throw this._eh.report(error, 'Config:load', []);
        }
    }
    loadUser() {
        try {
            return (0,_server__WEBPACK_IMPORTED_MODULE_1__.requestAPI)('userconfig').then((data) => {
                const config = this.createDefault();
                this.loadData(config, null, data);
                return config;
            });
        }
        catch (error) {
            throw this._eh.report(error, 'Config:loadUser', []);
        }
    }
    loadProject() {
        try {
            return (0,_server__WEBPACK_IMPORTED_MODULE_1__.requestAPI)('config').then((data) => {
                const config = this.createDefault();
                this.loadData(config, null, data);
                this.loadData(this.defaultOptions, this.experimentConfig, data);
                return config;
            });
        }
        catch (error) {
            throw this._eh.report(error, 'Config:loadProject', []);
        }
    }
    saveProject(options) {
        try {
            this.defaultOptions = options;
            return (0,_server__WEBPACK_IMPORTED_MODULE_1__.requestAPI)('config', {
                body: JSON.stringify({ options: options }),
                method: 'POST',
            });
        }
        catch (error) {
            throw this._eh.report(error, 'Config:saveProject', [options]);
        }
    }
    saveUser(options) {
        try {
            return (0,_server__WEBPACK_IMPORTED_MODULE_1__.requestAPI)('userconfig', {
                body: JSON.stringify({ options: options }),
                method: 'POST',
            }).then((data) => {
                this.load();
                return data;
            });
        }
        catch (error) {
            throw this._eh.report(error, 'Config:saveUser', [options]);
        }
    }
    merge(original, newOptions) {
        try {
            if (!newOptions) {
                return;
            }
            if (newOptions.mode !== undefined) {
                original.mode = newOptions.mode;
            }
            if (newOptions.requirements !== undefined) {
                original.requirements = newOptions.requirements;
            }
            if (newOptions.types !== undefined) {
                for (const key of _linter_interfaces__WEBPACK_IMPORTED_MODULE_2__.ErrorTypeKeys) {
                    const value = newOptions.types[key];
                    if (value !== undefined) {
                        original.types[key] = value;
                    }
                }
            }
            if (newOptions.reports !== undefined) {
                for (const key of _linter_interfaces__WEBPACK_IMPORTED_MODULE_2__.ReportIds) {
                    const value = newOptions.reports[key];
                    if (value !== undefined) {
                        original.reports[key] = value;
                    }
                }
            }
            if (newOptions.kernel !== undefined) {
                original.kernel = newOptions.kernel;
            }
        }
        catch (error) {
            throw this._eh.report(error, 'Config:merge', [original, newOptions]);
        }
    }
}


/***/ }),

/***/ "./lib/linterlab/errorhandler.js":
/*!***************************************!*\
  !*** ./lib/linterlab/errorhandler.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ErrorHandler": () => (/* binding */ ErrorHandler)
/* harmony export */ });
/* harmony import */ var _server__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../server */ "./lib/server.js");

class ErrorHandler {
    constructor() {
        this._id = 0;
        this._errorStack = [];
        if (!('toJSON' in Error.prototype)) {
            Object.defineProperty(Error.prototype, 'toJSON', {
                value: function () {
                    const alt = {};
                    Object.getOwnPropertyNames(this).forEach((key) => {
                        alt[key] = this[key];
                    }, this);
                    return alt;
                },
                configurable: true,
                writable: true,
            });
        }
    }
    clear() {
        this._errorStack = [];
    }
    get errorStack() {
        return this._errorStack;
    }
    report(error, func, params) {
        /* eslint @typescript-eslint/explicit-module-boundary-types: 0 */
        if ({}.hasOwnProperty.call(this, 'julynterId')) {
            error.JulynterParent = error.julynterId;
        }
        if (typeof error === 'object') {
            error.julynterId = this._id++;
        }
        else {
            error = {
                julynterId: this._id++,
                message: error,
                otype: typeof error,
            };
        }
        const date = new Date();
        const result = {
            error: error,
            func: func,
            params: params,
            date: date,
        };
        this._errorStack.push(`${date} - ${func}:\n  ${error.toString()}\n  ${JSON.stringify(params.toString())}`);
        (0,_server__WEBPACK_IMPORTED_MODULE_0__.requestAPI)('error', {
            body: JSON.stringify(result),
            method: 'POST',
        }).catch((reason) => {
            console.error(`The julynter server extension appears to be missing.\n${reason}`);
            return reason;
        });
        console.error('Found error:', func, error, params);
        return error;
    }
}


/***/ }),

/***/ "./lib/linterlab/experimentmanager.js":
/*!********************************************!*\
  !*** ./lib/linterlab/experimentmanager.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "IExperimentConfigAttributes": () => (/* binding */ IExperimentConfigAttributes),
/* harmony export */   "ExperimentManager": () => (/* binding */ ExperimentManager)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_cells__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/cells */ "webpack/sharing/consume/default/@jupyterlab/cells");
/* harmony import */ var _jupyterlab_cells__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_cells__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _server__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../server */ "./lib/server.js");




const JUPYTER_CELL_MIME = 'application/vnd.jupyter.cells';
const IExperimentConfigAttributes = [
    'lintingMessages',
    'lintingTypes',
    'execution',
    'activity',
    'code',
    'name',
    'enabled',
];
class ExperimentManager {
    constructor(docmanager) {
        this.config = {
            lintingMessages: 'maybe',
            lintingTypes: 'maybe',
            execution: 'maybe',
            activity: 'maybe',
            code: 'maybe',
            name: 'maybe',
            enabled: true,
        };
        this.lastLint = {};
        this._overrideJupyterLab(docmanager);
    }
    _overrideJupyterLab(docmanager) {
        const oldRename = docmanager.rename.bind(docmanager);
        docmanager.rename = (oldPath, newPath) => {
            return oldRename(oldPath, newPath).then((result) => {
                this.reportRename(oldPath, newPath);
                return result;
            });
        };
        const oldExecute = _jupyterlab_cells__WEBPACK_IMPORTED_MODULE_1__.CodeCell.execute;
        _jupyterlab_cells__WEBPACK_IMPORTED_MODULE_1__.CodeCell.execute = (cell, sessionContext, metadata) => {
            return oldExecute(cell, sessionContext, metadata).then((msg) => {
                this.reportExecution(cell, sessionContext);
                return msg;
            });
        };
        const oldSplit = _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.splitCell;
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.splitCell = (notebook) => {
            const oldIndex = notebook.activeCellIndex;
            const result = oldSplit(notebook);
            this.reportSplitCell(oldIndex, notebook);
            return result;
        };
        const oldMerge = _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.mergeCells;
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.mergeCells = (notebook) => {
            const toMerge = this._getActiveIndexes(notebook);
            const result = oldMerge(notebook);
            this.reportMergeCell(toMerge, notebook);
            return result;
        };
        const oldDeleteCells = _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.deleteCells;
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.deleteCells = (notebook) => {
            const toDelete = this._getActiveIndexes(notebook);
            const result = oldDeleteCells(notebook);
            this.reportIndexesAction(toDelete, notebook, 'deleteCells');
            return result;
        };
        const oldInsertAbove = _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.insertAbove;
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.insertAbove = (notebook) => {
            const oldIndex = notebook.activeCellIndex;
            const result = oldInsertAbove(notebook);
            this.reportIndexesAction([oldIndex], notebook, 'insertAbove');
            return result;
        };
        const oldInsertBelow = _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.insertBelow;
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.insertBelow = (notebook) => {
            const oldIndex = notebook.activeCellIndex;
            const result = oldInsertBelow(notebook);
            this.reportIndexesAction([oldIndex], notebook, 'insertBelow');
            return result;
        };
        const oldMoveDown = _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.moveDown;
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.moveDown = (notebook) => {
            const toMove = this._getActiveIndexes(notebook);
            const result = oldMoveDown(notebook);
            this.reportIndexesAction(toMove, notebook, 'moveDown');
            return result;
        };
        const oldMoveUp = _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.moveUp;
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.moveUp = (notebook) => {
            const toMove = this._getActiveIndexes(notebook);
            const result = oldMoveUp(notebook);
            this.reportIndexesAction(toMove, notebook, 'moveUp');
            return result;
        };
        const oldChangeCellType = _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.changeCellType;
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.changeCellType = (notebook, value) => {
            const index = notebook.activeCellIndex;
            const oldValue = notebook.activeCell.model.type;
            const result = oldChangeCellType(notebook, value);
            this.reportChangeCellType(index, oldValue, value, notebook);
            return result;
        };
        const oldRun = _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.run;
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.run = (notebook, sessionContext) => {
            const cell = notebook.activeCell;
            if (cell.model.type === 'markdown') {
                this.reportExecution(cell, sessionContext);
            }
            const result = oldRun(notebook, sessionContext);
            return result;
        };
        const oldRunAndAdvance = _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.runAndAdvance;
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.runAndAdvance = (notebook, sessionContext) => {
            const index = notebook.activeCellIndex;
            const last = notebook.widgets.length - 1;
            const cell = notebook.activeCell;
            if (cell.model.type === 'markdown') {
                this.reportExecution(cell, sessionContext);
            }
            const result = oldRunAndAdvance(notebook, sessionContext);
            if (index === last) {
                this.reportIndexesAction([index], notebook, 'newCellAfterRun');
            }
            return result;
        };
        const oldRunAndInsert = _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.runAndInsert;
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.runAndInsert = (notebook, sessionContext) => {
            const index = notebook.activeCellIndex;
            const cell = notebook.activeCell;
            if (cell.model.type === 'markdown') {
                this.reportExecution(cell, sessionContext);
            }
            const result = oldRunAndInsert(notebook, sessionContext);
            this.reportIndexesAction([index], notebook, 'newCellAfterRun');
            return result;
        };
        const oldCut = _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.cut;
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.cut = (notebook) => {
            const toDelete = this._getActiveIndexes(notebook);
            const result = oldCut(notebook);
            this.reportIndexesAction(toDelete, notebook, 'cut');
            return result;
        };
        const oldPaste = _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.paste;
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.paste = (notebook, mode = 'below') => {
            if (!notebook.model || !notebook.activeCell) {
                return oldPaste(notebook, mode);
            }
            const clipboard = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Clipboard.getInstance();
            if (!clipboard.hasData(JUPYTER_CELL_MIME)) {
                return oldPaste(notebook, mode);
            }
            const toInsert = clipboard.getData(JUPYTER_CELL_MIME);
            let toDelete = [];
            if (mode === 'replace') {
                toDelete = this._getActiveIndexes(notebook);
            }
            const index = notebook.activeCellIndex;
            const result = oldPaste(notebook, mode);
            this.reportPaste(index, toInsert, toDelete, mode, notebook);
            return result;
        };
        const oldUndo = _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.undo;
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.undo = (notebook) => {
            const result = oldUndo(notebook);
            this.reportAction(notebook, 'undo');
            return result;
        };
        const oldRedo = _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.redo;
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.redo = (notebook) => {
            const result = oldRedo(notebook);
            this.reportAction(notebook, 'redo');
            return result;
        };
        const oldRunAll = _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.runAll;
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.runAll = (notebook, sessionContext) => {
            this.reportAction(notebook, 'runAll');
            return oldRunAll(notebook, sessionContext);
        };
        const oldRunAllAbove = _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.runAllAbove;
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.runAllAbove = (notebook, sessionContext) => {
            this.reportAction(notebook, 'runAllAbove');
            return oldRunAllAbove(notebook, sessionContext);
        };
        const oldRunAllBelow = _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.runAllBelow;
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.runAllBelow = (notebook, sessionContext) => {
            this.reportAction(notebook, 'runAllBelow');
            return oldRunAllBelow(notebook, sessionContext);
        };
        const oldClearOutputs = _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.clearOutputs;
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.clearOutputs = (notebook) => {
            const toDelete = this._getActiveIndexes(notebook);
            const result = oldClearOutputs(notebook);
            this.reportIndexesAction(toDelete, notebook, 'clearOutputs');
            return result;
        };
        const oldClearAllOutputs = _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.clearAllOutputs;
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookActions.clearAllOutputs = (notebook) => {
            this.reportAction(notebook, 'clearAllOutputs');
            return oldClearAllOutputs(notebook);
        };
    }
    /* Start Actions */
    reportRename(oldName, newName) {
        if (!this.config.enabled || !this.config.activity) {
            return;
        }
        const send = {
            header: 'Action',
            operation: 'rename',
            oldName: oldName,
            newName: newName,
        };
        this._send(send);
    }
    reportSplitCell(oldIndex, notebook) {
        if (!this.config.enabled || !this.config.activity) {
            return;
        }
        const newIndex = notebook.activeCellIndex;
        let codes = null;
        if (this.config.code) {
            codes = [];
            for (let i = oldIndex; i <= newIndex; i++) {
                codes.push(notebook.widgets[i].model.value.text);
            }
        }
        const send = {
            header: 'Action',
            operation: 'splitCell',
            notebookName: this._notebookName(notebook.title.label),
            notebookId: notebook.parent.id,
            indexes: [oldIndex],
            newIndexes: [newIndex],
            codes: codes,
        };
        this._send(send);
    }
    reportMergeCell(toMerge, notebook) {
        if (!this.config.enabled || !this.config.activity) {
            return;
        }
        const newIndex = notebook.activeCellIndex;
        let code = null;
        if (this.config.code) {
            code = notebook.widgets[newIndex].model.value.text;
        }
        const send = {
            header: 'Action',
            operation: 'mergeCells',
            notebookName: this._notebookName(notebook.title.label),
            notebookId: notebook.parent.id,
            indexes: toMerge,
            newIndexes: [newIndex],
            codes: [code],
        };
        this._send(send);
    }
    reportIndexesAction(indexes, notebook, operation) {
        if (!this.config.enabled || !this.config.activity) {
            return;
        }
        const send = {
            header: 'Action',
            operation: operation,
            notebookName: this._notebookName(notebook.title.label),
            notebookId: notebook.parent.id,
            indexes: indexes,
        };
        this._send(send);
    }
    reportChangeCellType(index, oldValue, newValue, notebook) {
        if (!this.config.enabled || !this.config.activity) {
            return;
        }
        const send = {
            header: 'Action',
            operation: 'changeCellType',
            notebookName: this._notebookName(notebook.title.label),
            notebookId: notebook.parent.id,
            indexes: [index],
            oldType: oldValue,
            newType: newValue,
        };
        this._send(send);
    }
    reportPaste(index, toInsert, toDelete, mode, notebook) {
        if (!this.config.enabled || !this.config.activity) {
            return;
        }
        let codes = null;
        if (this.config.code) {
            codes = [];
            for (let i = 0; i < toInsert.length; i++) {
                if (Array.isArray(toInsert[i].source)) {
                    codes.push(toInsert[i].source.join('\n'));
                }
                else {
                    codes.push(toInsert[i].source);
                }
            }
        }
        const send = {
            header: 'Action',
            operation: 'paste',
            notebookName: this._notebookName(notebook.title.label),
            notebookId: notebook.parent.id,
            indexes: toDelete,
            newIndexes: [index],
            codes: codes,
            info: mode,
            pasteCount: toInsert.length,
        };
        this._send(send);
    }
    reportAction(notebook, operation) {
        if (!this.config.enabled || !this.config.activity) {
            return;
        }
        const send = {
            header: 'Action',
            operation: operation,
            notebookName: this._notebookName(notebook.title.label),
            notebookId: notebook.parent.id,
        };
        this._send(send);
    }
    /* End Actions */
    /* Start Activities */
    reportLoadConfig(nbPanel, checks) {
        if (!this.config.enabled || !this.config.activity) {
            return;
        }
        const send = {
            header: 'Activity',
            operation: 'loadConfig',
            notebookName: this._notebookName(nbPanel.title.label),
            notebookId: nbPanel.id,
            options: checks,
        };
        this._send(send);
    }
    reportSaveConfig(nbPanel, checks) {
        if (!this.config.enabled || !this.config.activity) {
            return;
        }
        const send = {
            header: 'Activity',
            operation: 'saveConfig',
            notebookName: this._notebookName(nbPanel.title.label),
            notebookId: nbPanel.id,
            options: checks,
        };
        this._send(send);
    }
    reportCloseNotebook(handler) {
        if (!this.config.enabled || !this.config.activity) {
            return;
        }
        if ({}.hasOwnProperty.call(this.lastLint, handler.id)) {
            delete this.lastLint[handler.id];
        }
        const send = {
            header: 'Activity',
            operation: 'close',
            notebookName: this._notebookName(handler.name),
            notebookId: handler.id,
        };
        this._send(send);
    }
    reportKernelActivity(handler, operation, kernelName) {
        if (!this.config.enabled || !this.config.activity) {
            return;
        }
        const send = {
            header: 'Activity',
            operation: operation,
            notebookName: this._notebookName(handler.name),
            notebookId: handler.id,
            info: kernelName,
        };
        this._send(send);
    }
    reportActivity(handler, operation) {
        if (!this.config.enabled || !this.config.activity) {
            return;
        }
        const send = {
            header: 'Activity',
            operation: operation,
            notebookName: this._notebookName(handler.name),
            notebookId: handler.id,
        };
        this._send(send);
    }
    reportVisibility(handler, visible) {
        if (!this.config.enabled || !this.config.activity) {
            return;
        }
        if (!handler) {
            return;
        }
        const send = {
            header: 'Activity',
            operation: 'visibility',
            notebookName: this._notebookName(handler.name),
            notebookId: handler.id,
            info: visible.toString(),
        };
        this._send(send);
    }
    reportSetConfig(nbPanel, config, value) {
        if (!this.config.enabled || !this.config.activity) {
            return;
        }
        const send = {
            header: 'Activity',
            operation: 'setConfig',
            notebookName: this._notebookName(nbPanel.title.label),
            notebookId: nbPanel.id,
            param: config,
            info: value.toString(),
        };
        this._send(send);
    }
    reportNotebookKernel(handler, kernel, language) {
        if (!this.config.enabled || !this.config.activity) {
            return;
        }
        const send = {
            header: 'Activity',
            operation: 'loadKernel',
            notebookName: this._notebookName(handler.name),
            notebookId: handler.id,
            param: language,
            info: kernel,
        };
        this._send(send);
    }
    /* End Activities */
    /* Start code */
    reportNotebookCode(handler) {
        if (!this.config.enabled || !(this.config.code || this.config.execution)) {
            return;
        }
        const cells = [];
        const nbcells = handler.nbPanel.content.widgets;
        for (let i = 0; i < nbcells.length; i++) {
            const cell = nbcells[i];
            const cellResult = this._collectCell(cell);
            cells.push(cellResult);
        }
        const send = {
            header: 'Code',
            operation: 'code',
            notebookName: this._notebookName(handler.name),
            notebookId: handler.id,
            cells: cells,
        };
        this._send(send);
    }
    reportExecution(cell, sessionContext) {
        if (!this.config.enabled || !(this.config.code || this.config.execution)) {
            return;
        }
        const send = {
            header: 'Execution',
            operation: 'execute',
            notebookName: this._notebookName(sessionContext.path),
            notebookId: cell.parent.parent.id,
            cells: [this._collectCell(cell)],
            indexes: [cell.parent.widgets.indexOf(cell)],
        };
        this._send(send);
    }
    /* End code */
    /* Start lint */
    reportLinting(handler, result) {
        if (!this.config.enabled) {
            return;
        }
        const reports = result.visible;
        if (!{}.hasOwnProperty.call(this.lastLint, handler.id)) {
            this.lastLint[handler.id] = [];
        }
        const newReports = reports.filter((report) => {
            if (report.type === 'group') {
                return false;
            }
            const same = this.lastLint[handler.id].find((other) => {
                return (other.text === report.text &&
                    other.reportType === report.reportType &&
                    other.cellId === report.cellId &&
                    other.reportId === report.reportId);
            });
            if (same) {
                report.feedback = same.feedback;
                same.kept = true;
                return false;
            }
            else {
                report.feedback = 1;
            }
            return true;
        });
        const removedReports = this.lastLint[handler.id].filter((report) => {
            if (report.type === 'group') {
                return false;
            }
            if (report.kept) {
                return false;
            }
            return true;
        });
        this.lastLint[handler.id] = reports;
        if (!(this.config.lintingMessages || this.config.lintingTypes)) {
            return;
        }
        if (newReports.length === 0 && removedReports.length === 0) {
            return;
        }
        const mapfn = this.config.lintingMessages
            ? this.selectMessages.bind(this)
            : this.selectTypes.bind(this);
        const send = {
            header: 'Lint',
            operation: 'lint',
            notebookName: this._notebookName(handler.name),
            notebookId: handler.id,
            newReports: newReports.map(mapfn),
            removedReports: removedReports.map(mapfn),
        };
        this._send(send);
    }
    reportFeedback(handler, report, message, source) {
        if (!this.config.enabled) {
            return;
        }
        const mapfn = this.config.lintingMessages
            ? this.selectMessages.bind(this)
            : this.selectTypes.bind(this);
        const newReport = mapfn(report);
        const send = {
            header: 'Lint',
            operation: 'feedback',
            notebookName: this._notebookName(handler.name),
            notebookId: handler.id,
            report: newReport,
            message: message,
            source: source,
        };
        this._send(send);
    }
    reportLintClick(handler, report, source) {
        if (!this.config.enabled || !this.config.activity) {
            return;
        }
        if (!this.config.lintingMessages && !this.config.lintingTypes) {
            return;
        }
        const mapfn = this.config.lintingMessages
            ? this.selectMessages.bind(this)
            : this.selectTypes.bind(this);
        const newReport = mapfn(report);
        const send = {
            header: 'Lint',
            operation: 'lintclick',
            notebookName: this._notebookName(handler.name),
            notebookId: handler.id,
            report: newReport,
            source: source,
        };
        this._send(send);
    }
    selectMessages(report) {
        return {
            text: report.text,
            reportType: report.reportType,
            reportId: report.reportId,
            suggestion: report.suggestion,
            cellId: report.cellId.toString(),
            visible: report.visible,
            filteredOut: report.filteredOut,
            type: report.type,
        };
    }
    selectTypes(report) {
        return {
            reportType: report.reportType,
            reportId: report.reportId,
            cellId: report.cellId.toString(),
            visible: report.visible,
            filteredOut: report.filteredOut,
            type: report.type,
        };
    }
    /* End lint */
    _collectCell(cell) {
        const model = cell.model;
        const cellResult = {
            type: model.type,
            code: this.config.code ? model.value.text : null,
            length: model.value.text.length,
            empty: model.value.text.trim().length === 0,
            executionCount: null,
            outputs: null,
        };
        if (this.config.execution && model.type === 'code') {
            const outputs = [];
            const codeModel = model;
            const codeOutputs = codeModel.outputs.toJSON();
            for (let j = 0; j < codeOutputs.length; j++) {
                const codeOutput = codeOutputs[j];
                const output = {
                    type: codeOutput.output_type,
                    mime: [],
                };
                if (output.type === 'stream') {
                    output.mime = [codeOutput.name];
                }
                else if (output.type === 'error') {
                    output.mime = [codeOutput.ename];
                }
                else if ({}.hasOwnProperty.call(codeOutput, 'data')) {
                    output.mime = Object.keys(codeOutput.data);
                }
                outputs.push(output);
            }
            cellResult.executionCount = codeModel.executionCount;
            cellResult.outputs = outputs;
        }
        return cellResult;
    }
    _getActiveIndexes(notebook) {
        const result = [];
        notebook.widgets.forEach((child, index) => {
            if (notebook.isSelectedOrActive(child)) {
                result.push(index);
            }
        });
        return result;
    }
    _notebookName(name) {
        return this.config.name ? name : '<redacted>';
    }
    _send(data) {
        data['date'] = new Date();
        return (0,_server__WEBPACK_IMPORTED_MODULE_3__.requestAPI)('experiment', {
            body: JSON.stringify(data),
            method: 'POST',
        }).catch((reason) => {
            console.error(`The julynter server extension appears to be missing.\n${reason}`);
            return reason;
        });
    }
}


/***/ }),

/***/ "./lib/linterlab/itemgenerator.js":
/*!****************************************!*\
  !*** ./lib/linterlab/itemgenerator.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ItemGenerator": () => (/* binding */ ItemGenerator),
/* harmony export */   "GroupGenerator": () => (/* binding */ GroupGenerator)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/docmanager */ "webpack/sharing/consume/default/@jupyterlab/docmanager");
/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _linter_reports__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../linter/reports */ "./lib/linter/reports.js");
/* harmony import */ var _linter_lint__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../linter/lint */ "./lib/linter/lint.js");




function isNumber(value) {
    return value !== null && !isNaN(Number(value.toString()));
}
function capitalizeFirstLetter(string) {
    return string.charAt(0).toUpperCase() + string.slice(1);
}
class ItemGenerator {
    constructor(docManager, handler, eh) {
        this._docManager = docManager;
        this._handler = handler;
        this._notebookContent = handler.nbPanel.content;
        this._eh = eh;
    }
    create(cellId, type, messageId, hashSource, args) {
        try {
            const message = _linter_reports__WEBPACK_IMPORTED_MODULE_2__.ERRORS[messageId];
            return {
                text: message.label(...args),
                reportType: message.type,
                reportId: messageId,
                suggestion: message.suggestion,
                reason: message.reason,
                cellId: cellId,
                visible: true,
                filteredOut: false,
                type: type,
                hash: (0,_linter_lint__WEBPACK_IMPORTED_MODULE_3__.hash)(`<${messageId}>${hashSource}`),
                action: message.action,
                boundAction: message.action.execute(this, ...args),
                restart: message.restart,
            };
        }
        catch (error) {
            throw this._eh.report(error, 'ItemGenerator:create', [
                cellId,
                type,
                messageId,
                hashSource,
                args,
            ]);
        }
    }
    renameNotebook() {
        try {
            (0,_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_1__.renameDialog)(this._docManager, this._handler.nbPanel.context.path);
        }
        catch (error) {
            throw this._eh.report(error, 'ItemGenerator:renameNotebook', [
                this._handler.nbPanel.context.path,
            ]);
        }
    }
    goToCell(index) {
        try {
            const cell = this._notebookContent.widgets[index];
            this._notebookContent.activeCellIndex = index;
            cell.node.scrollIntoView();
        }
        catch (error) {
            throw this._eh.report(error, 'ItemGenerator:goToCell', [index]);
        }
    }
    addModule(index, module) {
        try {
            const handler = this._handler;
            (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showDialog)({
                title: 'Add requirement',
                body: `Add "${module}" to requirements?`,
                buttons: [_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog.cancelButton(), _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog.okButton({ label: 'Add' })],
            }).then((result) => {
                Promise.resolve(result.button.accept).then((ok) => {
                    try {
                        if (ok) {
                            handler.addModule(module);
                        }
                    }
                    catch (error) {
                        throw this._eh.report(error, 'ItemGenerator:addModule.ok', [
                            index,
                            module,
                            ok,
                        ]);
                    }
                });
            });
            this.goToCell(index);
        }
        catch (error) {
            throw this._eh.report(error, 'ItemGenerator:addModule', [index, module]);
        }
    }
    restoreCell(index, executionCount, code) {
        try {
            const cell = this._notebookContent.model.contentFactory.createCodeCell({});
            cell.value.text = code;
            cell.executionCount = executionCount;
            this._notebookContent.model.cells.insert(index, cell);
            this.goToCell(index);
        }
        catch (error) {
            throw this._eh.report(error, 'ItemGenerator:restoreCell', [
                index,
                executionCount,
                code,
            ]);
        }
    }
}
class GroupGenerator {
    constructor(nbPanel, update, eh) {
        this._nbPanel = nbPanel;
        this._update = update;
        this._eh = eh;
    }
    create(title, reportType, elements) {
        try {
            let strTitle;
            let metavar;
            let metaname;
            if (isNumber(title)) {
                strTitle = 'Cell ' + title;
                const cell = this._nbPanel.content.widgets[Number(title)];
                metavar = cell.model.metadata;
                metaname = 'julynter-cellgroup-collapsed';
            }
            else {
                strTitle = capitalizeFirstLetter(String(title));
                metavar = this._nbPanel.model.metadata;
                metaname =
                    'julynter-cellgroup-' +
                        strTitle.replace(' ', '-').toLowerCase() +
                        '-collapsed';
            }
            let collapsed = metavar.get(metaname);
            collapsed = collapsed !== undefined ? collapsed : false;
            elements.forEach((element) => {
                element.visible = !collapsed;
                element.hasParent = true;
            });
            const result = {
                text: strTitle,
                reportType: reportType,
                reportId: 'group',
                cellId: 'group',
                suggestion: null,
                reason: 'This groups other lint messages',
                visible: true,
                filteredOut: false,
                collapsed: collapsed,
                type: 'group',
                hash: (0,_linter_lint__WEBPACK_IMPORTED_MODULE_3__.hash)(strTitle),
                hasParent: true,
                action: null,
                restart: false,
                boundAction: () => {
                    return;
                },
            };
            const onClickFactory = (line) => {
                return () => {
                    try {
                        elements.forEach((element) => {
                            element.visible = result.collapsed;
                        });
                        result.collapsed = !result.collapsed;
                        result.action.label = result.collapsed
                            ? 'Expand category'
                            : 'Collapse category';
                        metavar.set(metaname, !collapsed);
                        this._update();
                    }
                    catch (error) {
                        throw this._eh.report(error, 'GroupGenerator:create.click', [
                            title,
                            reportType,
                            elements,
                        ]);
                    }
                };
            };
            result.boundAction = onClickFactory(0);
            result.action = {
                label: result.collapsed ? 'Expand category' : 'Collapse category',
                title: 'Collapse or expand lints of this type',
                execute: (ItemGenerator, ...args) => {
                    return () => {
                        return;
                    };
                },
            };
            return result;
        }
        catch (error) {
            throw this._eh.report(error, 'GroupGenerator:create', [
                title,
                reportType,
                elements,
            ]);
        }
    }
}


/***/ }),

/***/ "./lib/linterlab/julynter.js":
/*!***********************************!*\
  !*** ./lib/linterlab/julynter.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Julynter": () => (/* binding */ Julynter)
/* harmony export */ });
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./config */ "./lib/linterlab/config.js");
/* harmony import */ var _notebookhandler__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./notebookhandler */ "./lib/linterlab/notebookhandler.js");
/* harmony import */ var _experimentmanager__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./experimentmanager */ "./lib/linterlab/experimentmanager.js");
/* harmony import */ var _view_listwidget__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./view/listwidget */ "./lib/linterlab/view/listwidget.js");
/* harmony import */ var _view_toolbarwidget__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./view/toolbarwidget */ "./lib/linterlab/view/toolbarwidget.js");
/* harmony import */ var _view_headerwidget__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./view/headerwidget */ "./lib/linterlab/view/headerwidget.js");
/* harmony import */ var _view_cellwidget__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./view/cellwidget */ "./lib/linterlab/view/cellwidget.js");
/* harmony import */ var _iconimports__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../iconimports */ "./lib/iconimports.js");










/**
 * Timeout for throttling Julynter rendering.
 */
const RENDER_TIMEOUT = 1000;
/**
 * A widget for hosting a notebook julynter.
 */
class Julynter extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__.Panel {
    /**
     * Create a new table of contents.
     */
    constructor(docmanager, tracker, labShell, eh) {
        super();
        this._mainWidget = null;
        this._docmanager = docmanager;
        this._labShell = labShell;
        this._tracker = tracker;
        this._eh = eh;
        this.handlers = {};
        this._status = {
            connectedOnce: false,
            connectedNow: false,
            serverSide: false,
            hasKernel: false,
            experiment: false,
        };
        this._currentHandler = null;
        this._visibleWidget = null;
        this._experimentManager = new _experimentmanager__WEBPACK_IMPORTED_MODULE_2__.ExperimentManager(docmanager);
        this._config = new _config__WEBPACK_IMPORTED_MODULE_3__.Config(this._experimentManager.config, this._status, eh);
    }
    addNewNotebook(nbPanel) {
        //A promise that resolves after the initialization of the handler is done.
        try {
            const handlers = this.handlers;
            const update = this.update.bind(this);
            const experimentmanager = this._experimentManager;
            const config = this._config;
            const docManager = this._docmanager;
            const status = this._status;
            const errorhandler = this._eh;
            this.handlers[nbPanel.id] = new Promise((resolve, reject) => {
                const session = nbPanel.sessionContext;
                const handler = new _notebookhandler__WEBPACK_IMPORTED_MODULE_4__.NotebookHandler(docManager, session, nbPanel, config, experimentmanager, errorhandler, update);
                const scripts = session.ready.then(handler.getKernelLanguage.bind(handler));
                scripts.then((language) => {
                    status.connectedOnce = true;
                    handler.configureHandler(language);
                });
                scripts.catch((result) => {
                    this._eh.report(result, 'Julynter:addNewNotebook.session', [
                        nbPanel.title.label,
                        session.kernelDisplayName,
                    ]);
                    reject(result);
                });
                nbPanel.disposed.connect(() => {
                    delete handlers[nbPanel.id];
                    handler.dispose();
                });
                experimentmanager.reportNotebookCode(handler);
                resolve(handler);
            });
        }
        catch (error) {
            throw this._eh.report(error, 'Julynter:addNewNotebook', [
                nbPanel.title.label,
            ]);
        }
    }
    changeActiveWidget(widget) {
        try {
            this._currentWidget = widget;
            const future = this.handlers[widget.id];
            if (future !== undefined) {
                future.then((source) => {
                    this.currentHandler = source;
                });
            }
            else if (this._currentHandler !== null) {
                this.currentHandler = null;
            }
        }
        catch (error) {
            throw this._eh.report(error, 'Julynter:changeActiveWidget', [
                widget.title.label,
            ]);
        }
    }
    performQueryAndUpdate() {
        if (this.currentHandler) {
            this.currentHandler.performQuery();
        }
        this.updateJulynter();
    }
    updateJulynter() {
        try {
            if (this._mainWidget !== null && this.contains(this._mainWidget)) {
                this._mainWidget.dispose();
                this._mainWidget = null;
            }
            let title = 'Julynter';
            let listWidget = null;
            let toolbarWidget = null;
            this.title.icon = _iconimports__WEBPACK_IMPORTED_MODULE_5__.julynterIcon.bindprops({ stylesheet: 'sideBar' });
            this._status.connectedNow = false;
            this._status.hasKernel = false;
            if (this.currentHandler) {
                for (const cellLint of Object.values(this._currentHandler.cellLints)) {
                    cellLint.dispose();
                }
                this._currentHandler.cellLints = {};
                this._status.connectedNow = true;
                this._status.hasKernel = this.currentHandler.hasKernel;
                const lintResult = this.currentHandler.lint();
                const reports = lintResult.visible;
                this._visibleWidget = this.currentHandler.nbPanel;
                if (reports.length > 0) {
                    this.title.icon = _iconimports__WEBPACK_IMPORTED_MODULE_5__.julynterNewIcon.bindprops({
                        stylesheet: 'sideBar',
                    });
                }
                reports.forEach((report) => {
                    if (typeof report.cellId === 'number') {
                        const cell = this._currentHandler.nbPanel.content.widgets[report.cellId];
                        this._currentHandler.cellLints[report.cellId] = new _view_cellwidget__WEBPACK_IMPORTED_MODULE_6__.CellWidget(this._currentHandler, cell);
                        cell.layout.insertWidget(0, this._currentHandler.cellLints[report.cellId]);
                    }
                });
                title = this._currentHandler.name;
                const listOptions = {
                    reports: reports,
                    notebook: this.currentHandler,
                    errorHandler: this._eh,
                    cellLints: this._currentHandler.cellLints,
                };
                listWidget = new _view_listwidget__WEBPACK_IMPORTED_MODULE_7__.ListWidget(listOptions);
                toolbarWidget = new _view_toolbarwidget__WEBPACK_IMPORTED_MODULE_8__.ToolbarWidget({
                    tracker: this._tracker,
                    handlers: this.handlers,
                    config: this._config,
                    notebook: this.currentHandler,
                    labShell: this._labShell,
                    errorHandler: this._eh,
                    filtered: lintResult.filteredIndividual,
                });
            }
            else {
                listWidget = new _view_listwidget__WEBPACK_IMPORTED_MODULE_7__.EmptyListWidget();
            }
            const headerWidget = new _view_headerwidget__WEBPACK_IMPORTED_MODULE_9__.HeaderWidget(title, this._status, this._eh, this.performQueryAndUpdate.bind(this));
            this._mainWidget = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__.Panel();
            this._mainWidget.addClass('jp-Julynter');
            this._mainWidget.addWidget(headerWidget);
            if (toolbarWidget) {
                this._mainWidget.addWidget(toolbarWidget);
            }
            this._mainWidget.addWidget(listWidget);
            this.addWidget(this._mainWidget);
        }
        catch (error) {
            throw this._eh.report(error, 'Julynter:updateJulynter', []);
        }
    }
    /**
     * Rerender after showing.
     */
    onAfterShow(msg) {
        try {
            this._experimentManager.reportVisibility(this._currentHandler, true);
            this.update();
        }
        catch (error) {
            throw this._eh.report(error, 'Julynter:onAfterShow', []);
        }
    }
    /**
     * Notify after hide.
     */
    onAfterHide(msg) {
        try {
            this._experimentManager.reportVisibility(this._currentHandler, false);
        }
        catch (error) {
            throw this._eh.report(error, 'Julynter:onAfterHide', []);
        }
    }
    /**
     * Handle an update request.
     */
    onUpdateRequest(msg) {
        try {
            this.updateJulynter();
        }
        catch (error) {
            throw this._eh.report(error, 'Julynter:onUpdateRequest', []);
        }
    }
    dispose() {
        try {
            if (this.isDisposed) {
                return;
            }
            this._currentHandler.disconnectHandler();
            this._currentHandler = null;
            super.dispose();
        }
        catch (error) {
            throw this._eh.report(error, 'Julynter:dispose', []);
        }
    }
    get currentHandler() {
        return this._currentHandler;
    }
    set currentHandler(newHandler) {
        try {
            const widget = this._currentWidget;
            if (this._currentHandler !== newHandler) {
                if (this._currentHandler !== null) {
                    this._currentHandler.disconnectHandler();
                }
                this._currentHandler = newHandler;
                if (this._currentHandler !== null) {
                    this._currentHandler.connectHandler();
                }
            }
            if (!newHandler || widget !== newHandler.nbPanel) {
                this.updateJulynter();
                return;
            }
            if (this._tracker.has(widget) && widget !== this._visibleWidget) {
                // Dispose an old activity monitor if it existsd
                if (this._monitor) {
                    this._monitor.dispose();
                    this._monitor = null;
                }
                // Find the document model associated with the widget.
                const context = this._docmanager.contextForWidget(widget);
                if (!context || !context.model) {
                    throw Error('Could not find a context for Julynter');
                }
                // Throttle the rendering rate of julynter.
                this._monitor = new _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.ActivityMonitor({
                    signal: context.model.contentChanged,
                    timeout: RENDER_TIMEOUT,
                });
                this._monitor.activityStopped.connect(this.update, this);
                this._experimentManager.reportVisibility(this._currentHandler, true);
            }
            this.updateJulynter();
        }
        catch (error) {
            throw this._eh.report(error, 'Julynter:set currentHandler', [
                newHandler.name,
            ]);
        }
    }
}


/***/ }),

/***/ "./lib/linterlab/notebookhandler.js":
/*!******************************************!*\
  !*** ./lib/linterlab/notebookhandler.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "NotebookHandler": () => (/* binding */ NotebookHandler)
/* harmony export */ });
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/signaling */ "webpack/sharing/consume/default/@lumino/signaling");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _linter_interfaces__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../linter/interfaces */ "./lib/linter/interfaces.js");
/* harmony import */ var _linter_lint__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../linter/lint */ "./lib/linter/lint.js");
/* harmony import */ var _itemgenerator__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./itemgenerator */ "./lib/linterlab/itemgenerator.js");
/* harmony import */ var _optionsmanager__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./optionsmanager */ "./lib/linterlab/optionsmanager.js");





class NotebookHandler {
    constructor(docManager, session, nbPanel, config, em, eh, update) {
        this._kernelRestarted = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);
        this._disposed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);
        this._inspected = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);
        this._isDisposed = false;
        this._eh = eh;
        try {
            this.cellLints = {};
            this._docManager = docManager;
            this._session = session;
            this._nbPanel = nbPanel;
            this._experimentManager = em;
            this._update = update;
            this._panelId = this._nbPanel.id;
            this._language = _linter_interfaces__WEBPACK_IMPORTED_MODULE_1__.GenericMatcher;
            this.options = new _optionsmanager__WEBPACK_IMPORTED_MODULE_2__.OptionsManager(nbPanel, config, em, eh, update);
            this.update = {};
            this.hasKernel = false;
            this._reportedStart = false;
            this._icomm = null;
            this._boundQueryCall = this._queryCall.bind(this);
            em.reportActivity(this, 'open');
            session.statusChanged.connect((sender, status) => {
                try {
                    const kdn = session.kernelDisplayName;
                    if (status.endsWith('restarting')) {
                        em.reportKernelActivity(this, 'restartKernel', kdn);
                        this._reportedStart = true;
                        this._kernelRestarted.emit(this._session.ready);
                    }
                    else if (status === 'unknown') {
                        em.reportKernelActivity(this, 'stopKernel', kdn);
                        this._reportedStart = false;
                    }
                    else if ((status === 'idle' || status === 'busy') &&
                        !this._reportedStart) {
                        em.reportKernelActivity(this, 'useKernel', kdn);
                        this._reportedStart = true;
                    }
                }
                catch (error) {
                    throw this._eh.report(error, 'NotebookHandler:constructor.statusChanged', [nbPanel.title.label, status]);
                }
            });
        }
        catch (error) {
            throw this._eh.report(error, 'NotebookHandler:constructor', [
                nbPanel.title.label,
            ]);
        }
    }
    findLanguage(kernelName, languageName) {
        return new Promise((resolve, reject) => {
            this.options.reloadOptions();
            for (const kid of this.options.checks.kernel.order) {
                const kernel = this.options.checks.kernel.values[kid];
                if (kernel.kernel && kernelName.match(kernel.kernel)) {
                    resolve(kernel);
                    return;
                }
                if (kernel.language && languageName.match(kernel.language)) {
                    resolve(kernel);
                    return;
                }
            }
            resolve({
                kernel: null,
                language: null,
                initScript: null,
                name: 'default',
            });
        });
    }
    getKernelLanguage() {
        try {
            return this._session.session.kernel.info.then((infoReply) => {
                try {
                    this._session.session.kernel.name;
                    const model = this.findLanguage(this._session.session.kernel.name, infoReply.language_info.name);
                    this._experimentManager.reportNotebookKernel(this, this._session.session.kernel.name, infoReply.language_info.name);
                    return model;
                }
                catch (error) {
                    throw this._eh.report(error, 'NotebookHandler:getKernelLanguage.then', [this._session.session.kernel.name, infoReply.language_info.name]);
                }
            });
        }
        catch (error) {
            throw this._eh.report(error, 'NotebookHandler:getKernelLanguage', []);
        }
    }
    createComm() {
        const kernel = this._session.session.kernel;
        if (kernel) {
            kernel.registerCommTarget('julynter.comm', (comm, msg) => {
                this._icomm = comm;
                this._icomm.onMsg = this._receiveJulynterQuery.bind(this);
                // console.log('ICOMM!', this._icomm.commId);
            });
        }
    }
    configureHandler(language) {
        try {
            this._language = language;
            this._ready = this._session.ready.then(() => {
                this.createComm();
                this._initOnKernel();
            });
            this._kernelRestarted.connect((sender, kernelReady) => {
                this._inspected.emit({
                    status: 'Restarting Kernel...',
                });
                // Emit restarting
                this._ready = kernelReady.then(() => {
                    this.createComm();
                    this._initOnKernel();
                });
            });
        }
        catch (error) {
            throw this._eh.report(error, 'NotebookHandler:configureHandler', [
                language.name,
            ]);
        }
    }
    disconnectHandler() {
        try {
            this.inspected.disconnect(this.onQueryUpdate, this);
            this.disposed.disconnect(this.onSourceDisposed, this);
            this._experimentManager.reportActivity(this, 'MoveOut');
        }
        catch (error) {
            throw this._eh.report(error, 'NotebookHandler:disconnectHandler', []);
        }
    }
    connectHandler() {
        try {
            this.inspected.connect(this.onQueryUpdate, this);
            this.disposed.connect(this.onSourceDisposed, this);
            this.performQuery();
            this._experimentManager.reportActivity(this, 'MoveIn');
        }
        catch (error) {
            throw this._eh.report(error, 'NotebookHandler:connectHandler', []);
        }
    }
    get name() {
        return this._session.path;
    }
    get id() {
        return this._panelId;
    }
    get nbPanel() {
        return this._nbPanel;
    }
    get experimentManager() {
        return this._experimentManager;
    }
    /**
     * A signal emitted when the handler is disposed.
     */
    get disposed() {
        return this._disposed;
    }
    get isDisposed() {
        return this._isDisposed;
    }
    get ready() {
        return this._ready;
    }
    /**
     * A signal emitted when an inspector value is generated.
     */
    get inspected() {
        return this._inspected;
    }
    /**
     * Disposes the kernel connector.
     */
    dispose() {
        try {
            if (this.isDisposed) {
                return;
            }
            this._experimentManager.reportCloseNotebook(this);
            this._isDisposed = true;
            this._disposed.emit(void 0);
            _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal.clearData(this);
        }
        catch (error) {
            throw this._eh.report(error, 'NotebookHandler:dispose', []);
        }
    }
    /**
     * Map linting reports
     */
    mapReports(reports) {
        const result = [];
        reports.forEach((report) => {
            result.push({
                text: report.text,
                reportType: report.reportType,
                reportId: report.reportId,
                suggestion: report.suggestion,
                reason: report.reason,
                cellId: report.cellId,
                hash: report.hash,
            });
        });
        return result;
    }
    /**
     * Lint notebook
     */
    lint() {
        try {
            const groupGenerator = new _itemgenerator__WEBPACK_IMPORTED_MODULE_3__.GroupGenerator(this._nbPanel, this._update, this._eh);
            const itemGenerator = new _itemgenerator__WEBPACK_IMPORTED_MODULE_3__.ItemGenerator(this._docManager, this, this._eh);
            const notebookMetadata = {
                title: this.nbPanel.title.label,
                cells: this.nbPanel.content
                    .widgets,
            };
            const linter = new _linter_lint__WEBPACK_IMPORTED_MODULE_4__.Linter(this.options, this.update, this.hasKernel);
            const results = linter.generate(notebookMetadata, itemGenerator, groupGenerator);
            this._experimentManager.reportLinting(this, results);
            this.nbPanel.model.metadata.set('julynter-results', {
                visible: this.mapReports(results.visible),
                filteredType: this.mapReports(results.filteredType),
                filteredId: this.mapReports(results.filteredId),
                filteredRestart: this.mapReports(results.filteredRestart),
                filteredIndividual: this.mapReports(results.filteredIndividual),
                hash: results.hash,
            });
            return results;
        }
        catch (error) {
            throw this._eh.report(error, 'NotebookHandler:lint', []);
        }
    }
    _createPromise(error = null) {
        return new Promise((resolve, reject) => {
            if (!error) {
                resolve();
            }
            else {
                reject(error);
            }
        });
    }
    initScript() {
        try {
            if (this._language === null) {
                return this._createPromise('Language not loaded');
            }
            const code = this._language.initScript;
            if (code === null) {
                return this._createPromise();
            }
            const content = {
                code: code,
                stop_on_error: false,
                store_history: false,
                silent: true,
            };
            const kernel = this._session.session.kernel;
            if (!kernel) {
                return Promise.reject(new Error('Require kernel to perform advanced julynter operations!'));
            }
            const future = kernel.requestExecute(content, false);
            future.onIOPub = (msg) => {
                this.performQuery();
            };
            return future.done.then(() => {
                return;
            });
        }
        catch (error) {
            throw this._eh.report(error, 'NotebookHandler:initScript', []);
        }
    }
    send(data) {
        const session = this._session.session;
        if (this._icomm &&
            session &&
            session.kernel &&
            session.kernel.hasComm(this._icomm.commId)) {
            this._icomm.send(data);
        }
    }
    /**
     * Send a query command to the kernel
     */
    performQuery() {
        this.send({
            operation: 'query',
            requirements: this.options.checkRequirements(),
        });
    }
    /**
     * Send message to kernel add a module
     */
    addModule(module) {
        this.send({
            operation: 'addModule',
            module: module,
            requirements: this.options.checkRequirements(),
        });
    }
    /**
     * Initializes the kernel by running the set up script located at _initScriptPath.
     */
    _initOnKernel() {
        return this.initScript().then(() => {
            this._session.iopubMessage.disconnect(this._boundQueryCall);
            this._session.iopubMessage.connect(this._boundQueryCall);
        });
    }
    /*
     * Handle query response
     */
    _receiveJulynterQuery(msg) {
        try {
            const operation = msg.content.data.operation;
            if (operation === 'queryResult') {
                this._inspected.emit({
                    status: '',
                    kernelName: this._session.kernelDisplayName || '',
                    result: msg.content.data,
                });
            }
            else if (operation === 'error') {
                this._eh.report('Failed to run ICOMM command', 'NotebookHandler:_receiveJulynterQuery', [msg]);
            }
            else if (operation === 'init') {
                this.performQuery();
            }
        }
        catch (error) {
            throw this._eh.report(error, 'NotebookHandler:_receiveJulynterQuery', [
                msg,
            ]);
        }
    }
    /*
     * Invokes a inspection if the signal emitted from specified session is an 'execute_input' msg.
     */
    _queryCall(sess, args) {
        try {
            const msg = args;
            const msgType = msg.header.msg_type;
            switch (msgType) {
                case 'execute_input':
                    this.performQuery();
                    break;
                default:
                    break;
            }
        }
        catch (error) {
            throw this._eh.report(error, 'NotebookHandler:_queryCall', [
                args.content,
            ]);
        }
    }
    /**
     * Handle kernel signals.
     */
    onQueryUpdate(sender, update) {
        if (update.status !== '') {
            this.update = {};
            this.hasKernel = false;
        }
        else {
            this.hasKernel = true;
            this.update = update.result;
        }
        this._update();
    }
    /**
     * Handle disposed signals.
     */
    onSourceDisposed(sender, args) {
        return;
    }
}


/***/ }),

/***/ "./lib/linterlab/optionsmanager.js":
/*!*****************************************!*\
  !*** ./lib/linterlab/optionsmanager.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OptionsManager": () => (/* binding */ OptionsManager)
/* harmony export */ });
/* harmony import */ var _linter_options__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../linter/options */ "./lib/linter/options.js");

class OptionsManager extends _linter_options__WEBPACK_IMPORTED_MODULE_0__.AbstractOptionsManager {
    constructor(nbPanel, config, environmentManager, errorHandler, update) {
        super();
        this.default = config.defaultOptions;
        this._experimentManager = environmentManager;
        this._eh = errorHandler;
        this._nbPanel = nbPanel;
        this._update = update;
        this.initializeOptions(Object.assign({}, this.default), []);
        this.reloadOptions();
    }
    loadKey(key, def) {
        try {
            let result = def;
            if (this._nbPanel) {
                const temp = this._nbPanel.model.metadata.get('julynter-check-' + key);
                if (temp !== undefined && temp !== null) {
                    result = temp;
                }
            }
            return result;
        }
        catch (error) {
            throw this._eh.report(error, 'OptionsManager:loadKey', [key, def]);
        }
    }
    saveKey(key, value, ereport = true) {
        try {
            if (this._nbPanel) {
                this._nbPanel.model.metadata.set('julynter-check-' + key, value);
                if (ereport) {
                    this._experimentManager.reportSetConfig(this._nbPanel, key, value);
                }
            }
            this._update();
        }
        catch (error) {
            throw this._eh.report(error, 'OptionsManager:loadKey', [
                key,
                value,
                ereport,
            ]);
        }
    }
    // initialize options, will NOT change notebook metadata
    initializeOptions(checks, filtered) {
        try {
            super.initializeOptions(checks, filtered);
            this._update();
        }
        catch (error) {
            throw this._eh.report(error, 'OptionsManager:initializeOptions', [
                checks,
            ]);
        }
    }
    reloadOptions() {
        try {
            super.reloadOptions();
            this._experimentManager.reportLoadConfig(this._nbPanel, this.checks);
        }
        catch (error) {
            throw this._eh.report(error, 'OptionsManager:reloadOptions', []);
        }
    }
    saveOptions() {
        try {
            super.saveOptions();
            this._experimentManager.reportSaveConfig(this._nbPanel, this.checks);
            this._update();
        }
        catch (error) {
            throw this._eh.report(error, 'OptionsManager:saveOptions', []);
        }
    }
}


/***/ }),

/***/ "./lib/linterlab/view/cellwidget.js":
/*!******************************************!*\
  !*** ./lib/linterlab/view/cellwidget.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CellWidget": () => (/* binding */ CellWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_commands__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/commands */ "webpack/sharing/consume/default/@lumino/commands");
/* harmony import */ var _lumino_commands__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_commands__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _iconimports__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../iconimports */ "./lib/iconimports.js");
/* harmony import */ var _linter_reports__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../linter/reports */ "./lib/linter/reports.js");






class CellWidget extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.ReactWidget {
    constructor(notebook, cell) {
        super();
        this.notebook = notebook;
        this.cell = cell;
        this.lints = [];
        this.addClass('julynter-cell-mod');
    }
    add(action) {
        this.lints.push(action.clone('cell'));
        this.update();
    }
    click(event) {
        const commands = new _lumino_commands__WEBPACK_IMPORTED_MODULE_1__.CommandRegistry();
        const contextMenu = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.ContextMenu({ commands: commands });
        for (let i = 0; i < this.lints.length; i++) {
            const lint = this.lints[i];
            const icon = _iconimports__WEBPACK_IMPORTED_MODULE_4__.iconMap[lint.item.reportType];
            const rtype = _linter_reports__WEBPACK_IMPORTED_MODULE_5__.ERROR_TYPES_MAP[lint.item.reportType];
            commands.addCommand('info' + i, {
                label: rtype.label + ' - ' + lint.item.text,
                icon: icon.bindprops({
                    stylesheet: 'menuItem',
                }),
                caption: 'Why is this lint showing?',
                className: 'julynter-context-info',
                execute: lint.why.bind(lint),
            });
            contextMenu.addItem({
                command: 'info' + i,
                selector: '*',
            });
            contextMenu.addItem({
                type: 'separator',
                selector: '*',
            });
            lint.populateMenu(commands, contextMenu, i + '');
            if (i !== this.lints.length - 1) {
                contextMenu.addItem({
                    type: 'separator',
                    selector: '*',
                });
                contextMenu.addItem({
                    type: 'separator',
                    selector: '*',
                });
            }
        }
        contextMenu.open(event);
        event.preventDefault();
        event.stopPropagation();
    }
    render() {
        if (this.notebook.options.checkView() && this.lints.length > 0) {
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { onClick: this.click.bind(this) },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_iconimports__WEBPACK_IMPORTED_MODULE_4__.julynterNewIcon.react, { tag: "span" })));
        }
        else {
            return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null);
        }
    }
    dispose() {
        super.dispose();
    }
}


/***/ }),

/***/ "./lib/linterlab/view/feedbackrenderer.js":
/*!************************************************!*\
  !*** ./lib/linterlab/view/feedbackrenderer.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TextDialog": () => (/* binding */ TextDialog),
/* harmony export */   "showTextDialog": () => (/* binding */ showTextDialog),
/* harmony export */   "FeedbackDialogRenderer": () => (/* binding */ FeedbackDialogRenderer)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);


class TextDialog extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.Dialog {
    handleEvent(event) {
        switch (event.type) {
            case 'keydown':
                this._evtKeydown(event);
                break;
            case 'click':
                this._evtClick(event);
                break;
            case 'focus':
                this._evtFocus(event);
                break;
            case 'contextmenu':
                event.preventDefault();
                event.stopPropagation();
                break;
            default:
                break;
        }
    }
    _evtKeydown(event) {
        if (event.keyCode !== 13) {
            super._evtKeydown(event);
        }
    }
}
function showTextDialog(options = {}) {
    const dialog = new TextDialog(options);
    return dialog.launch();
}
class FeedbackDialogRenderer extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null,
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("ul", { className: "julynter-feedback-ul" },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", null,
                    "Type: ",
                    this.props.item.reportType),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", null,
                    "ID: ",
                    this.props.item.reportId),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", null,
                    "Message: ",
                    this.props.item.text),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", null,
                    "Suggestion: ",
                    this.props.item.suggestion),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", null, "Feedback:")),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("textarea", { className: "julynter-feedback-textarea", onChange: this.props.onChange })));
    }
}


/***/ }),

/***/ "./lib/linterlab/view/headerwidget.js":
/*!********************************************!*\
  !*** ./lib/linterlab/view/headerwidget.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HeaderWidget": () => (/* binding */ HeaderWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _statusrenderer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./statusrenderer */ "./lib/linterlab/view/statusrenderer.js");



class HeaderWidget extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.ReactWidget {
    constructor(jtitle, status, eh, update) {
        super();
        this.jtitle = jtitle;
        this.update = update;
        this.status = status;
        this.eh = eh;
        this.addClass('julynter-header-widget');
    }
    titleClick() {
        try {
            this.update();
        }
        catch (error) {
            throw this.eh.report(error, 'Julynter:titleClick', []);
        }
    }
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("header", null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "julynter-title", onClick: this.titleClick.bind(this), title: "Click to reload" }, this.jtitle),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_statusrenderer__WEBPACK_IMPORTED_MODULE_2__.StatusRenderer, Object.assign({}, this.status, { errorHandler: this.eh }))));
    }
}


/***/ }),

/***/ "./lib/linterlab/view/itemwidget.js":
/*!******************************************!*\
  !*** ./lib/linterlab/view/itemwidget.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ItemWidget": () => (/* binding */ ItemWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _linter_reports__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../linter/reports */ "./lib/linter/reports.js");
/* harmony import */ var _iconimports__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../iconimports */ "./lib/iconimports.js");
/* harmony import */ var _lintaction__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./lintaction */ "./lib/linterlab/view/lintaction.js");





class ItemWidget extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.ReactWidget {
    constructor(options) {
        super();
        this.item = options.item;
        this.notebook = options.notebook;
        this.errorHandler = options.errorHandler;
        this.cellLints = options.cellLints;
        this.action = new _lintaction__WEBPACK_IMPORTED_MODULE_2__.LintAction(options.item, options.notebook, options.errorHandler, this.update.bind(this), 'list');
        if (this.item.cellId in this.cellLints) {
            this.cellLints[this.item.cellId].add(this.action);
        }
    }
    createFeedback() {
        const item = this.item;
        if (item.feedback && this.notebook.experimentManager.config.enabled) {
            const negativeClass = 'julynter-feedback-icon ' +
                (item.feedback & 2 ? ' julynter-feedback-icon-selected' : '');
            const positiveClass = 'julynter-feedback-icon ' +
                (item.feedback & 4 ? ' julynter-feedback-icon-selected' : '');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "julynter-feedback" },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: "julynter-feedback-text" }, "Experiment Feedback:"),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "julynter-feedback-buttons" },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "julynter-feedback-button", title: "I do not like this lint", onClick: this.action.handle(this.action.negativeFeedback) },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_iconimports__WEBPACK_IMPORTED_MODULE_3__.minusIcon.react, { className: negativeClass, tag: "div", width: "24px", height: "24px" })),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "julynter-feedback-button", title: "I like this lint", onClick: this.action.handle(this.action.positiveFeedback) },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_iconimports__WEBPACK_IMPORTED_MODULE_3__.plusIcon.react, { className: positiveClass, tag: "div", width: "24px", height: "24px" })),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "julynter-feedback-button", title: "Send a text feedback about this lint", onClick: this.action.handle(this.action.messageFeedback) },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_iconimports__WEBPACK_IMPORTED_MODULE_3__.feedbackIcon.react, { className: "julynter-feedback-icon", tag: "div", width: "24px", height: "24px" })))));
        }
        return null;
    }
    render() {
        try {
            const item = this.item;
            if (!item.visible || item.filteredOut) {
                return null;
            }
            const reportDivClass = item.hasParent
                ? 'julynter-report-div julynter-has-parent'
                : 'julynter-report-div';
            let prefix = null;
            let twistButton = null;
            let fontSize = 'julynter-normal-size';
            const feedbackDiv = this.createFeedback();
            if (this.notebook.options.checkMode() !== 'type' &&
                item.type !== 'group') {
                prefix = _linter_reports__WEBPACK_IMPORTED_MODULE_4__.ERROR_TYPES_MAP[item.reportType].label + ' - ';
            }
            if (item.collapsed) {
                fontSize = 'julynter-title-size';
                twistButton = (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "julynter-collapse-button" },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "julynter-twist-placeholder" }, "placeholder"),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "julynter-rightarrow-img julynter-arrow-img" }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_iconimports__WEBPACK_IMPORTED_MODULE_3__.toggleRightIcon.react, { tag: "div", className: "julynter-arrow-img" })));
            }
            else if (item.collapsed === false) {
                fontSize = 'julynter-title-size';
                twistButton = (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "julynter-collapse-button" },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "julynter-twist-placeholder" }, "placeholder"),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_iconimports__WEBPACK_IMPORTED_MODULE_3__.toggleDownIcon.react, { tag: "div", className: "julynter-arrow-img" })));
            }
            const reportPromptClass = 'julynter-report-prompt ' + fontSize;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "julynter-list-item", onClick: this.action.handle(this.action.click) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "julynter-entry-holder", title: this.item.suggestion, onContextMenu: this.action.contextMenu.bind(this.action) },
                    twistButton,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: reportDivClass },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: reportPromptClass },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null,
                                prefix,
                                " ",
                                item.text),
                            feedbackDiv)))));
        }
        catch (error) {
            throw this.errorHandler.report(error, 'ItemWidget:render', []);
        }
    }
}


/***/ }),

/***/ "./lib/linterlab/view/julynterconfigwidget.js":
/*!****************************************************!*\
  !*** ./lib/linterlab/view/julynterconfigwidget.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "JulynterConfigContent": () => (/* binding */ JulynterConfigContent),
/* harmony export */   "ContextSwitcher": () => (/* binding */ ContextSwitcher),
/* harmony export */   "SaveButton": () => (/* binding */ SaveButton),
/* harmony export */   "LoadButton": () => (/* binding */ LoadButton),
/* harmony export */   "ResetButton": () => (/* binding */ ResetButton),
/* harmony export */   "createJulynterConfigWidget": () => (/* binding */ createJulynterConfigWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ "webpack/sharing/consume/default/react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _iconimports__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../iconimports */ "./lib/iconimports.js");
/* harmony import */ var _linter_reports__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../linter/reports */ "./lib/linter/reports.js");
/* harmony import */ var _linter_interfaces__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../linter/interfaces */ "./lib/linter/interfaces.js");








const MODES = {
    list: 'View as list',
    cell: 'Group by cell',
    type: 'Group by lint type',
};
class ReportGroup extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    /* eslint @typescript-eslint/no-unused-vars: 0 */
    constructor(props) {
        super(props);
        this.state = { collapsed: !this.props.current.types[this.props.group] };
    }
    clickItem(key) {
        return () => {
            try {
                this.props.current.reports[key] = !this.props.current.reports[key];
                this.forceUpdate();
            }
            catch (error) {
                throw this.props.errorHandler.report(error, 'ReportGroup:clickItem', [
                    key,
                ]);
            }
        };
    }
    changeItem() {
        return;
    }
    changeGroup(event) {
        try {
            const updateLater = this.props.current.types[this.props.group] !== this.state.collapsed;
            this.props.current.types[this.props.group] = event.target.checked;
            if (updateLater) {
                this.setState({
                    collapsed: !event.target.checked,
                });
            }
            this.forceUpdate();
        }
        catch (error) {
            throw this.props.errorHandler.report(error, 'ReportGroup:changeGroup', [
                this.props.group,
                event.target.checked,
            ]);
        }
    }
    collapseGroup() {
        try {
            this.setState({
                collapsed: !this.state.collapsed,
            });
            this.forceUpdate();
        }
        catch (error) {
            throw this.props.errorHandler.report(error, 'ReportGroup:collapseGroup', [
                this.props.group,
            ]);
        }
    }
    render() {
        try {
            let twistButton = null;
            const items = this.props.items.map((el) => {
                const key = 'config-report-' + el.key;
                return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("tr", { key: key, onClick: this.clickItem(el.key) },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("td", null,
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { type: "checkbox", onChange: this.changeItem, checked: this.props.current.reports[el.key] })),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("td", null, el.key),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("td", null, el.item.label('<T1>', '<T2>', '<T3>', '<T4>', '<T5>')),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("td", null, el.item.suggestion)));
            });
            let notice = null;
            if (!this.props.current.types[this.props.group]) {
                notice = (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, "This category is disabled. The individual options in the following table will have no effect."));
            }
            let children = (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                notice,
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("table", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("thead", null,
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("tr", null,
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("th", null, "Use"),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("th", null, "Code"),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("th", null, "Template"),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("th", null, "Suggestion"))),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("tbody", null, items))));
            if (this.state.collapsed) {
                children = null;
                twistButton = (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "julynter-collapse-button" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "julynter-twist-placeholder" }, "placeholder"),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "julynter-rightarrow-img julynter-arrow-img" })));
            }
            else {
                twistButton = (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "julynter-collapse-button" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "julynter-twist-placeholder" }, "placeholder"),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "julynter-downarrow-img julynter-arrow-img" })));
            }
            const errorType = _linter_reports__WEBPACK_IMPORTED_MODULE_5__.ERROR_TYPES_MAP[this.props.group];
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "julynter-config-group" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "julynter-config-group-head", onClick: this.collapseGroup.bind(this) },
                        twistButton,
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, errorType.label)),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { type: "checkbox", onChange: this.changeGroup.bind(this), checked: this.props.current.types[this.props.group] })),
                children));
        }
        catch (error) {
            throw this.props.errorHandler.report(error, 'ReportGroup:render', [
                this.props.group,
            ]);
        }
    }
}
class JulynterConfigContent extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.Widget {
    constructor(checks, eh) {
        super();
        this._eh = eh;
        this.addClass('julynter-config');
        this._key = 0;
        this._current = checks;
        this.display();
    }
    externalUpdate() {
        try {
            this._key += 1;
            this.display();
        }
        catch (error) {
            throw this._eh.report(error, 'JulynterConfigContent:externalUpdade', []);
        }
    }
    selectMode(event) {
        try {
            this._current.mode = event.currentTarget.value;
        }
        catch (error) {
            throw this._eh.report(error, 'JulynterConfigContent:selectMode', [
                event.currentTarget.value,
            ]);
        }
    }
    writeRequirements(event) {
        try {
            this._current.requirements = event.currentTarget.value;
        }
        catch (error) {
            throw this._eh.report(error, 'JulynterConfigContent:writeRequirements', [
                event.currentTarget.value,
            ]);
        }
    }
    changeView(event) {
        try {
            this._current.view = event.target.checked;
        }
        catch (error) {
            throw this._eh.report(error, 'JulynterConfigContent:changeView', [
                event.currentTarget.value,
            ]);
        }
    }
    changeRestart(event) {
        try {
            this._current.restart = event.target.checked;
        }
        catch (error) {
            throw this._eh.report(error, 'JulynterConfigContent:changeRestart', [
                event.currentTarget.value,
            ]);
        }
    }
    display() {
        try {
            let renderedJSX = null;
            const groups = {};
            for (const key of _linter_interfaces__WEBPACK_IMPORTED_MODULE_6__.ReportIds) {
                const error = _linter_reports__WEBPACK_IMPORTED_MODULE_5__.ERRORS[key];
                if (error.type in groups) {
                    groups[error.type].push({
                        key: key,
                        item: error,
                    });
                }
                else {
                    groups[error.type] = [
                        {
                            key: key,
                            item: error,
                        },
                    ];
                }
            }
            const reportGroups = _linter_interfaces__WEBPACK_IMPORTED_MODULE_6__.ErrorTypeKeys.map((el) => {
                const key = 'config-' + el + '-' + this._key;
                return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ReportGroup, { current: this._current, key: key, group: el, items: groups[el], errorHandler: this._eh }));
            });
            renderedJSX = (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "julynter-config-inner" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h1", null, " Configure Julynter "),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "julynter-config-notice" }, "Do not forget to click the \" Save \" button when you are done"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", { key: 'mode-' + this._key },
                    "Mode:",
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.HTMLSelect, { className: "julynter-config-select", defaultValue: this._current.mode, onChange: this.selectMode.bind(this), options: _linter_interfaces__WEBPACK_IMPORTED_MODULE_6__.ViewModes.map((el) => {
                            return { label: MODES[el], value: el };
                        }) })),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", null,
                    "Requirements file:",
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "julynter-config-input", key: 'req-' + this._key },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { type: "text", onChange: this.writeRequirements.bind(this), defaultValue: this._current.requirements }))),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { type: "checkbox", onChange: this.changeView.bind(this), defaultChecked: this._current.view }),
                    "Show lints on cells"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { type: "checkbox", onChange: this.changeRestart.bind(this), defaultChecked: this._current.restart }),
                    "Show lints that require a kernel restart"),
                reportGroups));
            react_dom__WEBPACK_IMPORTED_MODULE_1___default().render(renderedJSX, this.node);
        }
        catch (error) {
            throw this._eh.report(error, 'JulynterConfigContent:display', []);
        }
    }
}
class ContextSwitcher extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.ReactWidget {
    constructor(tracker, selected, content, eh) {
        super();
        this._eh = eh;
        this._tracker = tracker;
        this._content = content;
        this.selected = selected;
        this.update();
        tracker.widgetAdded.connect((sender, nbPanel) => {
            this.update();
        });
    }
    getSelected() {
        try {
            let result = this.selected;
            this._tracker.forEach((notebook) => {
                if (notebook.id === this.selected) {
                    result = notebook;
                }
            });
            return result;
        }
        catch (error) {
            throw this._eh.report(error, 'ContextSwitcher:getSelected', []);
        }
    }
    /**
     * Handle `change` events for the HTMLSelect component.
     */
    handleChange(event) {
        try {
            this.selected = event.target.value;
        }
        catch (error) {
            throw this._eh.report(error, 'ContextSwitcher:handleChange', [
                event.target.value,
            ]);
        }
    }
    /**
     * Handle `keydown` events for the HTMLSelect component.
     */
    handleKeyDown(event) {
        try {
            if (event.keyCode === 13) {
                this._content.activate();
            }
        }
        catch (error) {
            throw this._eh.report(error, 'ContextSwitcher:handleKeyDown', [
                event.keyCode,
            ]);
        }
    }
    render() {
        try {
            const value = this.selected;
            let i = 0;
            const result = [];
            this._tracker.forEach((notebook) => {
                const key = 'notebook-save-' + i++;
                result.push(react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: key, value: notebook.id },
                    notebook.title.label,
                    " Settings"));
            });
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.HTMLSelect, { onChange: this.handleChange.bind(this), onKeyDown: this.handleKeyDown.bind(this), defaultValue: value, "aria-label": "Cell type" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { value: "user" }, "User Settings"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { value: "project" }, "Project Settings"),
                result));
        }
        catch (error) {
            throw this._eh.report(error, 'ContextSwitcher:render', []);
        }
    }
}
class SaveButton extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.ReactWidget {
    constructor(switcher, handlers, config, checks, eh) {
        super();
        this._eh = eh;
        this._switcher = switcher;
        this._checks = checks;
        this._handlers = handlers;
        this._config = config;
        this._props = {
            className: 'julynter-save',
            tooltip: 'Save configuration',
            label: 'Save',
            onClick: this.onClick.bind(this),
        };
        this.addClass('jp-ToolbarButton');
    }
    onClick() {
        try {
            const selected = this._switcher.selected;
            if (selected === 'user') {
                this._config
                    .saveUser(this._checks)
                    .then(() => {
                    (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.showDialog)({
                        title: 'Success',
                        body: (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "Stored settings for user."),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "It will not change existing notebooks that have their own settings."))),
                        buttons: [_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.Dialog.okButton({ label: 'Ok' })],
                    });
                })
                    .catch((reason) => {
                    (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.showErrorMessage)('Failed', reason);
                });
            }
            else if (selected === 'project') {
                this._config
                    .saveProject(this._checks)
                    .then(() => {
                    (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.showDialog)({
                        title: 'Success',
                        body: (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "Stored settings for project."),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "It will not change existing notebooks that have their own settings."))),
                        buttons: [_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.Dialog.okButton({ label: 'Ok' })],
                    });
                })
                    .catch((reason) => {
                    (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.showErrorMessage)('Failed', reason);
                });
            }
            else if (selected in this._handlers) {
                this._handlers[selected].then((handler) => {
                    handler.options.initializeOptions(this._checks, handler.options.checkFiltered());
                    handler.options.saveOptions();
                    (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.showDialog)({
                        title: 'Success',
                        body: (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                                "Stored settings for ",
                                handler.name,
                                "."))),
                        buttons: [_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.Dialog.okButton({ label: 'Ok' })],
                    });
                });
            }
            else {
                (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.showErrorMessage)('Failed', 'Target not found!');
            }
        }
        catch (error) {
            throw this._eh.report(error, 'SaveButton:onClick', []);
        }
    }
    render() {
        return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.ToolbarButtonComponent, Object.assign({}, this._props));
    }
}
class LoadButton extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.ReactWidget {
    constructor(switcher, handlers, config, checks, content, eh) {
        super();
        this._eh = eh;
        this._switcher = switcher;
        this._checks = checks;
        this._handlers = handlers;
        this._config = config;
        this._content = content;
        this._props = {
            className: 'julynter-load',
            tooltip: 'Load configuration',
            label: 'Load',
            onClick: this.onClick.bind(this),
        };
        this.addClass('jp-ToolbarButton');
    }
    onClick() {
        try {
            const selected = this._switcher.selected;
            if (selected === 'user') {
                this._config
                    .loadUser()
                    .then((config) => {
                    this._config.merge(this._checks, config);
                    this._content.externalUpdate();
                })
                    .catch((reason) => {
                    (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.showErrorMessage)('Failed', reason);
                });
            }
            else if (selected === 'project') {
                this._config
                    .loadProject()
                    .then((config) => {
                    this._config.merge(this._checks, config);
                    this._content.externalUpdate();
                })
                    .catch((reason) => {
                    (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.showErrorMessage)('Failed', reason);
                });
            }
            else if (selected in this._handlers) {
                this._handlers[selected].then((handler) => {
                    handler.options.reloadOptions();
                    this._config.merge(this._checks, handler.options.checks);
                    this._content.externalUpdate();
                });
            }
            else {
                (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.showErrorMessage)('Failed', 'Target not found!');
            }
        }
        catch (error) {
            throw this._eh.report(error, 'LoadButton:onClick', []);
        }
    }
    render() {
        return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.ToolbarButtonComponent, Object.assign({}, this._props));
    }
}
class ResetButton extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.ReactWidget {
    constructor(config, checks, content, eh) {
        super();
        this._checks = checks;
        this._config = config;
        this._content = content;
        this._eh = eh;
        this._props = {
            className: 'julynter-reset',
            tooltip: 'Reset configuration',
            label: 'Reset',
            onClick: this.onClick.bind(this),
        };
        this.addClass('jp-ToolbarButton');
    }
    onClick() {
        try {
            this._config.merge(this._checks, this._config.createDefault());
            this._content.externalUpdate();
        }
        catch (error) {
            throw this._eh.report(error, 'ResetButton:onClick', []);
        }
    }
    render() {
        return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.ToolbarButtonComponent, Object.assign({}, this._props));
    }
}
function createJulynterConfigWidget(tracker, handlers, config, notebook, eh) {
    try {
        const checks = Object.assign({}, notebook.options.checks);
        checks.reports = Object.assign({}, checks.reports);
        const content = new JulynterConfigContent(checks, eh);
        const saveSwitcher = new ContextSwitcher(tracker, notebook.id, content, eh);
        const saveButton = new SaveButton(saveSwitcher, handlers, config, checks, eh);
        const loadButton = new LoadButton(saveSwitcher, handlers, config, checks, content, eh);
        const resetButton = new ResetButton(config, checks, content, eh);
        const toolbar = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.Toolbar();
        toolbar.addItem('julynter-reset', resetButton);
        toolbar.addItem('julynter-context', saveSwitcher);
        toolbar.addItem('julynter-load', loadButton);
        toolbar.addItem('julynter-save', saveButton);
        const conf = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.MainAreaWidget({ content, toolbar });
        conf.title.icon = _iconimports__WEBPACK_IMPORTED_MODULE_7__.julynterIcon.bindprops({ stylesheet: 'mainAreaTab' });
        conf.title.caption = 'Julynter Config';
        conf.title.label = 'Julynter Config';
        conf.title.closable = true;
        conf.id = 'julynter-config';
        return conf;
    }
    catch (error) {
        throw eh.report(error, 'createJulynterConfigWidget', []);
    }
}


/***/ }),

/***/ "./lib/linterlab/view/lintaction.js":
/*!******************************************!*\
  !*** ./lib/linterlab/view/lintaction.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LintAction": () => (/* binding */ LintAction)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_commands__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/commands */ "webpack/sharing/consume/default/@lumino/commands");
/* harmony import */ var _lumino_commands__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_commands__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _feedbackrenderer__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./feedbackrenderer */ "./lib/linterlab/view/feedbackrenderer.js");





class LintAction {
    constructor(item, notebook, errorHandler, update, source) {
        this.item = item;
        this.notebook = notebook;
        this.errorHandler = errorHandler;
        this.update = update;
        this.source = source;
        this.handle = this.handle.bind(this);
    }
    clone(newSource) {
        return new LintAction(this.item, this.notebook, this.errorHandler, this.update, newSource);
    }
    handle(action) {
        return (event) => {
            event.preventDefault();
            event.stopPropagation();
            action.bind(this)();
        };
    }
    click() {
        try {
            const notebook = this.notebook;
            notebook.experimentManager.reportLintClick(notebook, this.item, this.source);
            this.item.boundAction();
        }
        catch (error) {
            throw this.errorHandler.report(error, 'LintAction:click', []);
        }
    }
    why() {
        try {
            const action = this.clone(this.source + '-why');
            const item = this.item;
            let suggestion = null;
            if (item.suggestion) {
                suggestion = react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", null,
                    "Suggestion: ",
                    item.suggestion);
            }
            const body = (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("ul", { className: "julynter-feedback-ul" },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", null, item.reason),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", null,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("br", null)),
                    suggestion)));
            (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.showDialog)({
                title: item.reportId === 'group'
                    ? item.text
                    : item.reportId + ' - ' + item.text,
                body: body,
                buttons: [
                    _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.Dialog.cancelButton(),
                    _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.Dialog.okButton({ label: item.action.label }),
                ],
            }).then((result) => {
                Promise.resolve(result.button.accept).then((ok) => {
                    try {
                        if (ok) {
                            action.click();
                        }
                    }
                    catch (error) {
                        throw this.errorHandler.report(error, 'LintAction:why.then', [
                            this.source,
                            ok,
                        ]);
                    }
                });
            });
        }
        catch (error) {
            throw this.errorHandler.report(error, 'LintAction:why', [this.source]);
        }
    }
    populateMenu(commands, contextMenu, postfix = '') {
        try {
            const item = this.item;
            commands.addCommand('action' + postfix, {
                label: item.action.label,
                caption: item.action.title,
                execute: this.click.bind(this),
            });
            contextMenu.addItem({
                command: 'action' + postfix,
                selector: '*',
            });
            commands.addCommand('copy' + postfix, {
                label: 'Copy lint',
                caption: 'Copy lint text',
                execute: () => {
                    try {
                        const id = item.reportId;
                        const text = item.text;
                        const suggestion = item.suggestion || 'N/A';
                        _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.Clipboard.copyToSystem(`ID: ${id}\nMessage: ${text}\nSuggestion: ${suggestion}`);
                    }
                    catch (error) {
                        throw this.errorHandler.report(error, 'LintAction:contextMenu.copy', [this.source, item]);
                    }
                },
            });
            contextMenu.addItem({
                command: 'copy' + postfix,
                selector: '*',
            });
            let hideTitle = `Filter out lint ${item.reportId}`;
            let hideMessage = 'Are you sure you want to filter out ' +
                `lints with the id "${item.reportId}"?`;
            const hideInfo = (react__WEBPACK_IMPORTED_MODULE_0__.createElement("ul", { className: "julynter-feedback-ul" },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", null,
                    "Message: ",
                    item.text),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", null,
                    "Suggestion: ",
                    item.suggestion)));
            let hideExample = (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null,
                "Example of instance:",
                hideInfo));
            if (item.reportId !== 'group') {
                commands.addCommand('hidethis' + postfix, {
                    label: 'Filter out this lint',
                    caption: 'Filter out this lint',
                    execute: () => {
                        (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.showDialog)({
                            title: 'Filter out this lint',
                            body: (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null,
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null, " Are you sure you want to filter out this lint? "),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null,
                                    " ",
                                    hideInfo,
                                    " "))),
                            buttons: [
                                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.Dialog.cancelButton(),
                                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.Dialog.okButton({ label: 'Yes' }),
                            ],
                        }).then((result) => {
                            Promise.resolve(result.button.accept).then((ok) => {
                                try {
                                    console.log(ok);
                                    if (ok) {
                                        this.notebook.options.addLintFilter(item.hash);
                                    }
                                }
                                catch (error) {
                                    throw this.errorHandler.report(error, 'LintAction:contextMenu.hidethis', [this.source, ok, item]);
                                }
                            });
                        });
                    },
                });
                contextMenu.addItem({
                    command: 'hidethis' + postfix,
                    selector: '*',
                });
            }
            if (item.reportId === 'group') {
                hideTitle = `Filter out lint type ${item.text}`;
                hideMessage =
                    'Are you sure you want to filter out' +
                        `lints with the type "${item.text}"?`;
                hideExample = null;
            }
            commands.addCommand('hide' + postfix, {
                label: 'Filter out similar lints',
                caption: 'Filter out this type of lint',
                execute: () => {
                    (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.showDialog)({
                        title: hideTitle,
                        body: (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null,
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null,
                                " ",
                                hideMessage,
                                " "),
                            hideExample)),
                        buttons: [_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.Dialog.cancelButton(), _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.Dialog.okButton({ label: 'Yes' })],
                    }).then((result) => {
                        Promise.resolve(result.button.accept).then((ok) => {
                            try {
                                if (ok && item.reportId !== 'group') {
                                    this.notebook.options.updateReport(item.reportId, false);
                                }
                                else if (ok) {
                                    this.notebook.options.updateType(item.reportType, false);
                                }
                            }
                            catch (error) {
                                throw this.errorHandler.report(error, 'LintAction:contextMenu.hide', [this.source, ok, item]);
                            }
                        });
                    });
                },
            });
            contextMenu.addItem({
                command: 'hide' + postfix,
                selector: '*',
            });
            if (this.item.feedback) {
                contextMenu.addItem({
                    type: 'separator',
                    selector: '*',
                });
                const neg = item.feedback & 2 ? 'Undo' : 'Send';
                commands.addCommand('negative' + postfix, {
                    label: `${neg} negative feedback`,
                    caption: `${neg} feedback indicating that you do not like this lint`,
                    execute: this.negativeFeedback.bind(this),
                });
                contextMenu.addItem({
                    command: 'negative' + postfix,
                    selector: '*',
                });
                const pos = item.feedback & 4 ? 'Undo' : 'Send';
                commands.addCommand('positive' + postfix, {
                    label: `${pos} positive feedback`,
                    caption: `${pos} feedback indicating that you like this lint`,
                    execute: this.positiveFeedback.bind(this),
                });
                contextMenu.addItem({
                    command: 'positive' + postfix,
                    selector: '*',
                });
                commands.addCommand('feedback' + postfix, {
                    label: 'Send feedback',
                    caption: 'Send a textual feedback',
                    execute: this.messageFeedback.bind(this),
                });
                contextMenu.addItem({
                    command: 'feedback' + postfix,
                    selector: '*',
                });
            }
            return contextMenu;
        }
        catch (error) {
            throw this.errorHandler.report(error, 'LintAction:createMenu', [
                this.source,
            ]);
        }
    }
    contextMenu(event) {
        try {
            const action = this.clone(this.source + '-menu');
            const commands = new _lumino_commands__WEBPACK_IMPORTED_MODULE_1__.CommandRegistry();
            const contextMenu = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.ContextMenu({ commands: commands });
            const item = this.item;
            commands.addCommand('info', {
                label: (item.reportId === 'group' ? item.text : item.reportId) + ' - Why?',
                caption: 'Why is this lint showing?',
                className: 'julynter-context-info',
                execute: action.why.bind(action),
            });
            contextMenu.addItem({
                command: 'info',
                selector: '*',
            });
            contextMenu.addItem({
                type: 'separator',
                selector: '*',
            });
            action.populateMenu(commands, contextMenu);
            contextMenu.open(event);
            event.preventDefault();
            event.stopPropagation();
        }
        catch (error) {
            throw this.errorHandler.report(error, 'LintAction:contextMenu', [
                this.source,
            ]);
        }
    }
    negativeFeedback() {
        try {
            const notebook = this.notebook;
            const item = this.item;
            const em = notebook.experimentManager;
            if (item.feedback & 2) {
                em.reportFeedback(notebook, item, '<<negate-negative>>', this.source);
                item.feedback -= 2;
            }
            else {
                em.reportFeedback(notebook, item, '<<negative>>', this.source);
                item.feedback |= 2;
            }
            this.update();
        }
        catch (error) {
            throw this.errorHandler.report(error, 'LintAction:negativeFeedback', [
                this.source,
            ]);
        }
    }
    positiveFeedback() {
        try {
            const notebook = this.notebook;
            const item = this.item;
            const em = notebook.experimentManager;
            if (item.feedback & 4) {
                em.reportFeedback(notebook, item, '<<negate-positive>>', this.source);
                item.feedback -= 4;
            }
            else {
                em.reportFeedback(notebook, item, '<<positive>>', this.source);
                item.feedback |= 4;
            }
            this.update();
        }
        catch (error) {
            throw this.errorHandler.report(error, 'LintAction:positiveFeedback', [
                this.source,
            ]);
        }
    }
    messageFeedback() {
        let dialogResult = '';
        const onChange = (event) => {
            event.preventDefault();
            event.stopPropagation();
            dialogResult = event.currentTarget.value;
        };
        try {
            const body = (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_feedbackrenderer__WEBPACK_IMPORTED_MODULE_4__.FeedbackDialogRenderer, { item: this.item, onChange: onChange }));
            const notebook = this.notebook;
            (0,_feedbackrenderer__WEBPACK_IMPORTED_MODULE_4__.showTextDialog)({
                title: 'Send Feedback',
                body: body,
                buttons: [_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.Dialog.cancelButton(), _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.Dialog.okButton({ label: 'Send' })],
            }).then((result) => {
                Promise.resolve(result.button.accept).then((ok) => {
                    try {
                        if (ok && dialogResult) {
                            notebook.experimentManager.reportFeedback(notebook, this.item, dialogResult, this.source);
                        }
                    }
                    catch (error) {
                        throw this.errorHandler.report(error, 'LintAction:messageFeedback.then', [this.source, ok, dialogResult]);
                    }
                });
            });
        }
        catch (error) {
            throw this.errorHandler.report(error, 'LintAction:messageFeedback', [
                this.source,
            ]);
        }
    }
}


/***/ }),

/***/ "./lib/linterlab/view/listwidget.js":
/*!******************************************!*\
  !*** ./lib/linterlab/view/listwidget.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ListWidget": () => (/* binding */ ListWidget),
/* harmony export */   "EmptyListWidget": () => (/* binding */ EmptyListWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _itemwidget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./itemwidget */ "./lib/linterlab/view/itemwidget.js");



 /* eslint @typescript-eslint/no-unused-vars: 0 */
class ListWidget extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__.Panel {
    constructor(options) {
        super();
        this.reports = options.reports;
        this.notebook = options.notebook;
        this.errorHandler = options.errorHandler;
        this.cellLints = options.cellLints;
        this.create();
    }
    create() {
        try {
            this.addClass('jp-Julynter-content');
            this.reports.forEach((el) => {
                const itemWidget = new _itemwidget__WEBPACK_IMPORTED_MODULE_3__.ItemWidget({
                    item: el,
                    notebook: this.notebook,
                    errorHandler: this.errorHandler,
                    cellLints: this.cellLints,
                });
                this.addWidget(itemWidget);
            });
        }
        catch (error) {
            throw this.errorHandler.report(error, 'ListWidget:create', []);
        }
    }
}
class EmptyListWidget extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__.ReactWidget {
    render() {
        return react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "julynter-error-desc" }, " No notebooks to lint ");
    }
}


/***/ }),

/***/ "./lib/linterlab/view/statusrenderer.js":
/*!**********************************************!*\
  !*** ./lib/linterlab/view/statusrenderer.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StatusRenderer": () => (/* binding */ StatusRenderer)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _iconimports__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../iconimports */ "./lib/iconimports.js");



class StatusRenderer extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    chooseMessageIcon() {
        try {
            if (!this.props.connectedOnce) {
                return ['Julynter did not connect to a notebook', _iconimports__WEBPACK_IMPORTED_MODULE_2__.neverconnectedIcon];
            }
            if (!this.props.connectedNow) {
                return ['Julynter is not connected to a notebook', _iconimports__WEBPACK_IMPORTED_MODULE_2__.disconnectedIcon];
            }
            if (!this.props.hasKernel) {
                return ['Kernel not found', _iconimports__WEBPACK_IMPORTED_MODULE_2__.kerneloffIcon];
            }
            return ['Kernel connected', _iconimports__WEBPACK_IMPORTED_MODULE_2__.kernelonIcon];
        }
        catch (error) {
            throw this.props.errorHandler.report(error, 'StatusRenderer:chooseMessageIcon', []);
        }
    }
    clickError() {
        try {
            const text = this.props.errorHandler.errorStack.join('\n\n');
            (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.showDialog)({
                title: 'List of errors',
                body: (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null, "Please, submit the following log as a Bug report to"),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("a", { target: "_blank", rel: "noreferrer", href: "https://github.com/dew-uff/julynter/issues" }, "https://github.com/dew-uff/julynter/issues")),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("textarea", { className: "julynter-error-text", value: text }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null, "* Check the Browser console as well."))),
                buttons: [
                    _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.Dialog.cancelButton({ label: 'Dismiss' }),
                    _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.Dialog.okButton({ label: 'Clear' }),
                ],
            }).then((result) => {
                Promise.resolve(result.button.accept).then((ok) => {
                    try {
                        if (ok) {
                            this.props.errorHandler.clear();
                            this.forceUpdate();
                        }
                    }
                    catch (error) {
                        throw this.props.errorHandler.report(error, 'StatusRenderer:clickError.ok', [ok]);
                    }
                });
            });
        }
        catch (error) {
            throw this.props.errorHandler.report(error, 'StatusRenderer:clickError', []);
        }
    }
    render() {
        try {
            const [message, icon] = this.chooseMessageIcon();
            let exp = null;
            let error = null;
            if (this.props.experiment) {
                exp = react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { title: "Experiment is Active" }, "e");
            }
            if (this.props.errorHandler.errorStack.length > 0) {
                error = (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: "julynter-error-display", onClick: this.clickError.bind(this), title: "Click to see errors" }, "[Error]"));
            }
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "jp-Julynter-kernel", title: message },
                error,
                exp,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(icon.react, { elementSize: "normal", className: "julynter-icon", elementPosition: "center" })));
        }
        catch (error) {
            throw this.props.errorHandler.report(error, 'StatusRenderer:render', []);
        }
    }
}


/***/ }),

/***/ "./lib/linterlab/view/toolbarwidget.js":
/*!*********************************************!*\
  !*** ./lib/linterlab/view/toolbarwidget.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ToolbarWidget": () => (/* binding */ ToolbarWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _linter_reports__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../linter/reports */ "./lib/linter/reports.js");
/* harmony import */ var _linter_interfaces__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../linter/interfaces */ "./lib/linter/interfaces.js");
/* harmony import */ var _iconimports__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../iconimports */ "./lib/iconimports.js");
/* harmony import */ var _julynterconfigwidget__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./julynterconfigwidget */ "./lib/linterlab/view/julynterconfigwidget.js");









/**
 * A widget used to rename a file.
 */
class RequirementsHandler extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__.Widget {
    /**
     * Construct a new "rename" dialog.
     */
    constructor(oldPath) {
        const body = document.createElement('div');
        const existingLabel = document.createElement('label');
        existingLabel.textContent = 'Requirements file';
        const existingPath = document.createElement('span');
        existingPath.textContent = oldPath;
        const nameTitle = document.createElement('label');
        nameTitle.textContent = 'New Name';
        nameTitle.className = 'jp-new-name-title';
        const name = document.createElement('input');
        body.appendChild(existingLabel);
        body.appendChild(existingPath);
        body.appendChild(nameTitle);
        body.appendChild(name);
        super({ node: body });
        this.addClass('jp-FileDialog');
        const ext = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_4__.PathExt.extname(oldPath);
        const value = (this.inputNode.value = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_4__.PathExt.basename(oldPath));
        this.inputNode.setSelectionRange(0, value.length - ext.length);
    }
    /**
     * Get the input text node.
     */
    get inputNode() {
        return this.node.getElementsByTagName('input')[0];
    }
    /**
     * Get the value of the widget.
     */
    getValue() {
        return this.inputNode.value;
    }
}
class ToolbarWidget extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__.ReactWidget {
    constructor(options) {
        super();
        this.notebook = options.notebook;
        this.labShell = options.labShell;
        this.tracker = options.tracker;
        this.config = options.config;
        this.handlers = options.handlers;
        this.errorHandler = options.errorHandler;
        this.filtered = options.filtered;
        this.addClass('julynter-toolbar-widget');
    }
    toggle(key) {
        try {
            const options = this.notebook.options;
            options.updateType(key, !options.checkType(key));
        }
        catch (error) {
            throw this.errorHandler.report(error, 'ToolbarWidget:toggle', [key]);
        }
    }
    toggleMode() {
        try {
            let mode = this.notebook.options.checkMode();
            if (mode === 'list') {
                mode = 'cell';
            }
            else if (mode === 'cell') {
                mode = 'type';
            }
            else {
                mode = 'list';
            }
            this.notebook.options.updateMode(mode);
        }
        catch (error) {
            throw this.errorHandler.report(error, 'ToolbarWidget:toggleMode', []);
        }
    }
    toggleView() {
        try {
            const options = this.notebook.options;
            options.updateView(!options.checkView());
        }
        catch (error) {
            throw this.errorHandler.report(error, 'ToolbarWidget:toggleView', []);
        }
    }
    toggleRestart() {
        try {
            const options = this.notebook.options;
            options.updateRestart(!options.checkRestart());
        }
        catch (error) {
            throw this.errorHandler.report(error, 'ToolbarWidget:toggleRestart', []);
        }
    }
    removeFilters() {
        try {
            const options = this.notebook.options;
            options.resetFiltered();
        }
        catch (error) {
            throw this.errorHandler.report(error, 'ToolbarWidget:toggleRestart', []);
        }
    }
    changeRequirements() {
        try {
            const options = this.notebook.options;
            return (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__.showDialog)({
                title: 'Set requirements file',
                body: new RequirementsHandler(options.checkRequirements()),
                focusNodeSelector: 'input',
                buttons: [_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__.Dialog.cancelButton(), _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__.Dialog.okButton({ label: 'Set' })],
            }).then((result) => {
                if (!result.value) {
                    return;
                }
                const name = result.value;
                if (name.length === 0 || name.includes(':')) {
                    void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__.showErrorMessage)('Set Requirements Error', Error(`"${result.value}" is not a valid name for a file. ` +
                        'Names must have nonzero length, ' +
                        'and cannot include ":"'));
                    return null;
                }
                options.updateRequirements(name);
            });
        }
        catch (error) {
            throw this.errorHandler.report(error, 'ToolbarWidget:changeRequirements', []);
        }
    }
    configure() {
        try {
            this.labShell.add((0,_julynterconfigwidget__WEBPACK_IMPORTED_MODULE_5__.createJulynterConfigWidget)(this.tracker, this.handlers, this.config, this.notebook, this.errorHandler), 'main');
        }
        catch (error) {
            throw this.errorHandler.report(error, 'ToolbarWidget:configure', []);
        }
    }
    createFilterButtons() {
        let i = 0;
        return _linter_interfaces__WEBPACK_IMPORTED_MODULE_6__.ErrorTypeKeys.map((key) => {
            const element = _linter_reports__WEBPACK_IMPORTED_MODULE_7__.ERROR_TYPES_MAP[key];
            const toggleClass = this.notebook.options.checkType(key)
                ? 'julynter-toolbar-icon-selected'
                : 'julynter-toolbar-icon';
            const icon = _iconimports__WEBPACK_IMPORTED_MODULE_8__.iconMap[key];
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { key: `toolbar-${key}-${i++}`, className: "julynter-toolbar-button", title: element.label, onClick: () => this.toggle(key) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(icon.react, { elementSize: "normal", className: toggleClass, elementPosition: "center" })));
        });
    }
    createViewButton() {
        const toggleClass = this.notebook.options.checkView()
            ? 'julynter-toolbar-icon-selected'
            : 'julynter-toolbar-icon';
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "julynter-toolbar-button", title: "Toggle view on cells", onClick: this.toggleView.bind(this) },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_iconimports__WEBPACK_IMPORTED_MODULE_8__.eyeIcon.react, { elementSize: "normal", className: toggleClass, elementPosition: "center" })));
    }
    createRestartButton() {
        const toggleClass = this.notebook.options.checkRestart()
            ? 'julynter-toolbar-icon-selected'
            : 'julynter-toolbar-icon';
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "julynter-toolbar-button", title: "Toggle lints that require a kernel restart", onClick: this.toggleRestart.bind(this) },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.refreshIcon.react, { elementSize: "normal", className: toggleClass, elementPosition: "center" })));
    }
    createRestartFilterButton() {
        let toggleClass = 'julynter-toolbar-icon';
        let element = (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", null,
            " ",
            this.filtered.length > 99 ? '++' : this.filtered.length,
            " "));
        if (this.filtered.length === 0) {
            toggleClass = 'julynter-toolbar-icon-selected';
            element = react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", null);
        }
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "julynter-toolbar-button", title: "Remove all individual lint filters", onClick: this.removeFilters.bind(this) },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "julynter-toolbar-icon-with-text" },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_iconimports__WEBPACK_IMPORTED_MODULE_8__.filterIcon.react, { elementSize: "normal", className: toggleClass, elementPosition: "center" }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: "julynter-toolbar-icon-text" }, element))));
    }
    createModeButton() {
        let toggleIcon = null;
        const mode = this.notebook.options.checkMode();
        if (mode === 'list') {
            toggleIcon = (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_iconimports__WEBPACK_IMPORTED_MODULE_8__.listIcon.react, { elementSize: "normal", className: "julynter-toolbar-icon", elementPosition: "center" }));
        }
        else if (mode === 'cell') {
            toggleIcon = (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_iconimports__WEBPACK_IMPORTED_MODULE_8__.cellIcon.react, { elementSize: "normal", className: "julynter-toolbar-icon", elementPosition: "center" }));
        }
        else if (mode === 'type') {
            toggleIcon = (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_iconimports__WEBPACK_IMPORTED_MODULE_8__.typeIcon.react, { elementSize: "normal", className: "julynter-toolbar-icon", elementPosition: "center" }));
        }
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { key: "toolbar-mode", className: "julynter-toolbar-button", title: "Alternate Mode", onClick: this.toggleMode.bind(this) }, toggleIcon));
    }
    render() {
        try {
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'julynter-toolbar' },
                    this.createFilterButtons(),
                    this.createViewButton(),
                    this.createRestartButton(),
                    this.createRestartFilterButton(),
                    this.createModeButton(),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { key: "toolbar-req", title: "Change requirements location", className: "julynter-toolbar-button", onClick: this.changeRequirements.bind(this) },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_iconimports__WEBPACK_IMPORTED_MODULE_8__.requirermentsIcon.react, { elementSize: "normal", className: "julynter-toolbar-icon", elementPosition: "center" })),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { key: "toolbar-config", title: "Configure Julynter", className: "julynter-toolbar-button", onClick: this.configure.bind(this) },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_iconimports__WEBPACK_IMPORTED_MODULE_8__.configIcon.react, { elementSize: "normal", className: "julynter-toolbar-icon", elementPosition: "center" })))));
        }
        catch (error) {
            throw this.errorHandler.report(error, 'ToolbarWidget:render', []);
        }
    }
}


/***/ }),

/***/ "./lib/server.js":
/*!***********************!*\
  !*** ./lib/server.js ***!
  \***********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "requestAPI": () => (/* binding */ requestAPI)
/* harmony export */ });
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);


/**
 * Call the API extension
 *
 * @param endPoint API REST end point for the extension
 * @param init Initial values for the request
 * @returns The response body interpreted as JSON
 */
async function requestAPI(endPoint = '', init = {}) {
    // Make request to Jupyter API
    const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
    const requestUrl = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.URLExt.join(settings.baseUrl, 'julynter', // API Namespace
    endPoint);
    let response;
    try {
        response = await _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(requestUrl, init, settings);
    }
    catch (error) {
        throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.NetworkError(error);
    }
    let data = await response.text();
    if (data.length > 0) {
        try {
            data = JSON.parse(data);
        }
        catch (error) {
            console.error('Not a JSON response body.', response);
        }
    }
    if (!response.ok) {
        throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.ResponseError(response, data.message || data);
    }
    return data;
}


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/base.css":
/*!**************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/base.css ***!
  \**************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/cssWithMappingToString.js */ "./node_modules/css-loader/dist/runtime/cssWithMappingToString.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, "", "",{"version":3,"sources":[],"names":[],"mappings":"","sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/index.css":
/*!***************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/index.css ***!
  \***************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/cssWithMappingToString.js */ "./node_modules/css-loader/dist/runtime/cssWithMappingToString.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_base_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! -!../node_modules/css-loader/dist/cjs.js!./base.css */ "./node_modules/css-loader/dist/cjs.js!./style/base.css");
// Imports



var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0___default()));
___CSS_LOADER_EXPORT___.i(_node_modules_css_loader_dist_cjs_js_base_css__WEBPACK_IMPORTED_MODULE_2__["default"]);
// Module
___CSS_LOADER_EXPORT___.push([module.id, ":root {\n  --julynter-font-size1: var(--jp-ui-font-size1);\n  --julynter-title-font-size: var(--jp-ui-font-size0);\n  \n}\n\n.julynter-main-icon, .julynter-main-new-icon {\n  display: block;\n  height: auto;\n  margin: 0 auto;\n  width: 20px;\n}\n\n.jp-Julynter-content {\n  flex: 1 1 auto;\n  margin: 0;\n  padding: 0;\n  list-style-type: none;\n  overflow: auto;\n  background-color: var(--jp-layout-color1);\n}\n\n.jp-Julynter-content .julynter-list-item {\n  display: flex;\n  flex-direction: row;\n  padding: 4px 12px;\n  cursor: pointer;\n  padding-top: 8px;\n  padding-bottom: 8px;\n}\n\n.jp-Julynter-content .julynter-list-item:hover {\n  background: var(--jp-layout-color2);\n}\n\n.jp-Julynter {\n  display: flex;\n  flex-direction: column;\n  background: var(--jp-layout-color1);\n  color: var(--jp-ui-font-color1);\n  font-size: var(--julynter-title-font-size);\n  height: 100%;\n}\n\n.jp-Julynter header {\n  border-bottom: var(--jp-border-width) solid var(--jp-border-color2);\n  flex: 0 0 auto;\n  font-size: var(--julynter-title-font-size);\n  font-weight: 600;\n  letter-spacing: 1px;\n  margin: 0px;\n  padding: 12px 0 4px 12px;\n  text-transform: uppercase;\n}\n\n.julynter-title {\n  display: inline-block;\n}\n\n.julynter-title:hover {\n  cursor: pointer;\n}\n\n.jp-Julynter-kernel {\n  float: right;\n}\n\n.jp-Julynter-kernel span {\n  float: left;\n  margin: 0 3px;\n}\n\n.julynter-toolbar-icon,\n.julynter-toolbar-icon-selected {\n  float: left;\n  padding: 0px;\n  margin: 4px;\n  /*background-repeat: no-repeat;\n  background-color: none;\n  background-size: 100%;\n  background-position: center;*/\n  height: 24px;\n  width: 24px;\n  margin: 4px;\n  border-radius: 2px;\n}\n\n.julynter-icon {\n  float: left;\n  /*background-repeat: no-repeat;\n  background-color: none;\n  background-size: 100%;\n  background-position: center;*/\n  height: 12px;\n  width: 12px;\n  margin-right: 8px;\n}\n\n[data-jp-theme-light='true'] .julynter-toolbar-icon:hover {\n  background-color: var(--jp-input-background);\n}\n\n[data-jp-theme-light='false'] .julynter-toolbar-icon:hover {\n  background-color: #3a3a3a;\n}\n\n[data-jp-theme-light='true'] .julynter-toolbar-icon-selected {\n  background-color: var(--jp-layout-color2);\n}\n\n[data-jp-theme-light='false'] .julynter-toolbar-icon-selected {\n  background-color: #565656;\n}\n\n.julynter-toolbar-icon-selected:hover, .julynter-toolbar-icon:hover {\n  cursor: pointer;\n}\n\n.julynter-toolbar-icon-selected:hover, .julynter-toolbar-icon-with-text:hover {\n  cursor: pointer;\n}\n\n.julynter-toolbar-icon-with-text {\n  position: relative;\n}\n\n.julynter-toolbar-icon-text {\n  position: absolute;\n  right: 5px;\n  font-size: 8px;\n  bottom: -28px;\n}\n\n\n\n.julynter-toolbar {\n  position: relative;\n  width: 100%;\n  margin: 0px;\n  padding: 2px 0;\n  user-select: none;\n  border-bottom: var(--jp-border-width) solid var(--jp-border-color2);\n  display: flex;\n  align-items: center;\n  flex-wrap: wrap;\n}\n\n.julynter-entry-holder {\n  display: inline-flex;\n  position: relative;\n  align-items: center;\n  width: 100%;\n}\n\n.julynter-collapse-button {\n  padding-left: 3px;\n  cursor: default;\n  min-width: 11px;\n  position: absolute;\n}\n\n.julynter-arrow-img {\n  top: 0;\n  bottom: 0;\n  margin: auto;\n  position: absolute;\n  background-repeat: no-repeat;\n}\n\n.julynter-downarrow-img {\n  width: 12px;\n  height: 6px;\n}\n\n.julynter-rightarrow-img {\n  width: 7px;\n  height: 12px;\n}\n\n.julynter-twist-placeholder {\n  max-width: 10px;\n  opacity: 0;\n  overflow: hidden;\n}\n\n.julynter-report-div {\n  display: inline-flex;\n  width: 100%;\n}\n\n.julynter-has-parent {\n  padding-left: 24px;\n}\n\n.julynter-normal-size {\n  font-size: var(--julynter-font-size1);\n}\n\n.julynter-title-size {\n  font-size: var(--julynter-font-size1);\n  font-weight: bold;\n}\n\n.julynter-report-prompt {\n  width: 100%;\n}\n\n\n.julynter-feedback {\n  display: none;\n  align-items: center;\n  flex-wrap: wrap;\n}\n\n.julynter-report-prompt:hover .julynter-feedback {\n  display: flex;\n}\n\n.julynter-feedback-text {\n  flex: 1;\n  padding: 7px 0;\n}\n\n.julynter-feedback-buttons {\n  flex: 1;\n  display: flex;\n}\n\n.julynter-feedback-icon,\n.julynter-feedback-icon-selected {\n  float: left;\n  padding: 0px;\n  margin: 4px;\n  /*background-repeat: no-repeat;\n  background-color: none;\n  background-size: 100%;\n  background-position: center;*/\n  height: 24px;\n  width: 24px;\n  margin: 4px;\n  border-radius: 2px;\n}\n\n[data-jp-theme-light='true'] .julynter-feedback-icon:hover {\n  background-color: white;\n  cursor: pointer;\n}\n\n[data-jp-theme-light='false'] .julynter-feedback-icon:hover {\n  background-color: black;\n  cursor: pointer;\n}\n\n[data-jp-theme-light='true'] .julynter-feedback-icon-selected {\n  background-color: white !important\n}\n\n[data-jp-theme-light='false'] .julynter-feedback-icon-selected {\n  background-color: black !important;\n}\n\n.julynter-feedback-ul {\n  margin: 0;\n  margin-bottom: 5px;\n  padding: 0;\n  list-style-type: none;\n}\n\n.julynter-feedback-textarea {\n  min-width: 400px;\n  width: 99%;\n  min-height: 200px;\n}\n\n\n.julynter-config {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  overflow: auto;\n  padding: 15px;\n  background: var(--jp-layout-color1);\n  color: var(--jp-ui-font-color1);\n  font-size: var(--julynter-font-size0);\n}\n\n.julynter-config-inner h1 {\n  margin: 0;\n}\n\n.julynter-config-notice {\n  margin-bottom: 15px;\n}\n\n.julynter-config-inner table {\n  border-collapse: collapse;\n  border-style: hidden;\n}\n\n.julynter-config-inner table td {\n  border: none;\n  vertical-align: middle;\n  padding: 0.5em 0.5em;\n  line-height: normal;\n  white-space: normal;\n}\n\n.julynter-config-inner table th {\n  border: none;\n  text-align: left;\n}\n\n.julynter-config-inner table tr {\n  border: none;\n  text-align: left;\n}\n\n\n.julynter-config-inner table, .julynter-config-inner tr {\n  width: 100%;\n}\n\n.julynter-config-inner tr td:nth-child(1), .julynter-config-inner tr th:nth-child(1) {\n  width: 5%;\n  text-align: center;\n}\n\n.julynter-config-inner tr td:nth-child(2), .julynter-config-inner tr th:nth-child(2) {\n  width: 5%;\n  text-align: center;\n}\n\n.julynter-config-inner tr td:nth-child(3) {\n  width: 40%;\n}\n\n.julynter-config-inner tr td:nth-child(4) {\n  width: 50%;\n}\n\n.julynter-config-inner thead {\n  border-bottom: var(--jp-border-width) solid var(--jp-border-color1);\n  vertical-align: bottom;\n}\n\n.julynter-config-inner tbody tr:nth-child(2n) {\n  background: var(--jp-rendermime-table-row-background);\n}\n\n.julynter-config-inner tbody tr:hover {\n  background: var(--jp-rendermime-table-row-hover-background);\n  cursor: pointer;\n}\n\n.julynter-config-select {\n  display: flex;\n  position: relative;\n  flex-direction: column;\n  padding: 1px;\n  background-color: var(--jp-layout-color1);\n  height: 28px;\n  box-sizing: border-box;\n  margin-bottom: 12px;\n  width: 189px !important;\n\n}\n\n.julynter-config-select select {\n  color: var(--jp-ui-font-color0) !important;\n  border: var(--jp-border-width) solid var(--jp-border-color1) !important;\n\n  flex: 1 1 auto !important;\n  height: 32px !important;\n  width: 100% !important;\n  background: var(--jp-input-background) !important;\n  padding: 0 25px 0 8px !important;\n  border: var(--jp-border-width) solid var(--jp-input-border-color) !important;\n  border-radius: 0px !important;\n  outline: none !important;\n  appearance: none !important;\n  -webkit-appearance: none !important;\n  -moz-appearance: none !important;\n  \n}\n\n.julynter-config-select select:hover {\n  background-color: var(--jp-layout-color1) !important;\n  cursor: pointer !important;\n  color: var(--jp-ui-font-color0) !important;\n  background-color: var(--jp-input-hover-background) !important;\n  box-shadow: inset 0 0px 1px rgba(0, 0, 0, 0.5) !important;\n}\n\n.julynter-config-group-head {\n  display: inline;\n}\n\n.julynter-config-group-head span {\n  margin-left: 20px;\n}\n\n.julynter-error-desc {\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  height: 100%;\n  margin: 10px 0;\n}\n\n.julynter-context-info {\n  font-weight: bold;\n}\n\n.julynter-error-display:hover {\n  cursor: pointer !important;\n}\n\n.julynter-error-text {\n  min-width: 400px;\n  width: 99%;\n  min-height: 200px;\n}\n\n.julynter-cell-mod {\n  position: absolute;\n  left: 17px;\n  top: 12px;\n  z-index: 10;\n}\n\n.julynter-cell-mod:hover {\n  cursor: pointer !important;\n}\n\n.julynter-header-widget, .julynter-toolbar-widget {\n  overflow: initial !important;\n}", "",{"version":3,"sources":["webpack://./style/index.css"],"names":[],"mappings":"AAEA;EACE,8CAA8C;EAC9C,mDAAmD;;AAErD;;AAEA;EACE,cAAc;EACd,YAAY;EACZ,cAAc;EACd,WAAW;AACb;;AAEA;EACE,cAAc;EACd,SAAS;EACT,UAAU;EACV,qBAAqB;EACrB,cAAc;EACd,yCAAyC;AAC3C;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,iBAAiB;EACjB,eAAe;EACf,gBAAgB;EAChB,mBAAmB;AACrB;;AAEA;EACE,mCAAmC;AACrC;;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,mCAAmC;EACnC,+BAA+B;EAC/B,0CAA0C;EAC1C,YAAY;AACd;;AAEA;EACE,mEAAmE;EACnE,cAAc;EACd,0CAA0C;EAC1C,gBAAgB;EAChB,mBAAmB;EACnB,WAAW;EACX,wBAAwB;EACxB,yBAAyB;AAC3B;;AAEA;EACE,qBAAqB;AACvB;;AAEA;EACE,eAAe;AACjB;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,WAAW;EACX,aAAa;AACf;;AAEA;;EAEE,WAAW;EACX,YAAY;EACZ,WAAW;EACX;;;+BAG6B;EAC7B,YAAY;EACZ,WAAW;EACX,WAAW;EACX,kBAAkB;AACpB;;AAEA;EACE,WAAW;EACX;;;+BAG6B;EAC7B,YAAY;EACZ,WAAW;EACX,iBAAiB;AACnB;;AAEA;EACE,4CAA4C;AAC9C;;AAEA;EACE,yBAAyB;AAC3B;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,yBAAyB;AAC3B;;AAEA;EACE,eAAe;AACjB;;AAEA;EACE,eAAe;AACjB;;AAEA;EACE,kBAAkB;AACpB;;AAEA;EACE,kBAAkB;EAClB,UAAU;EACV,cAAc;EACd,aAAa;AACf;;;;AAIA;EACE,kBAAkB;EAClB,WAAW;EACX,WAAW;EACX,cAAc;EACd,iBAAiB;EACjB,mEAAmE;EACnE,aAAa;EACb,mBAAmB;EACnB,eAAe;AACjB;;AAEA;EACE,oBAAoB;EACpB,kBAAkB;EAClB,mBAAmB;EACnB,WAAW;AACb;;AAEA;EACE,iBAAiB;EACjB,eAAe;EACf,eAAe;EACf,kBAAkB;AACpB;;AAEA;EACE,MAAM;EACN,SAAS;EACT,YAAY;EACZ,kBAAkB;EAClB,4BAA4B;AAC9B;;AAEA;EACE,WAAW;EACX,WAAW;AACb;;AAEA;EACE,UAAU;EACV,YAAY;AACd;;AAEA;EACE,eAAe;EACf,UAAU;EACV,gBAAgB;AAClB;;AAEA;EACE,oBAAoB;EACpB,WAAW;AACb;;AAEA;EACE,kBAAkB;AACpB;;AAEA;EACE,qCAAqC;AACvC;;AAEA;EACE,qCAAqC;EACrC,iBAAiB;AACnB;;AAEA;EACE,WAAW;AACb;;;AAGA;EACE,aAAa;EACb,mBAAmB;EACnB,eAAe;AACjB;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,OAAO;EACP,cAAc;AAChB;;AAEA;EACE,OAAO;EACP,aAAa;AACf;;AAEA;;EAEE,WAAW;EACX,YAAY;EACZ,WAAW;EACX;;;+BAG6B;EAC7B,YAAY;EACZ,WAAW;EACX,WAAW;EACX,kBAAkB;AACpB;;AAEA;EACE,uBAAuB;EACvB,eAAe;AACjB;;AAEA;EACE,uBAAuB;EACvB,eAAe;AACjB;;AAEA;EACE;AACF;;AAEA;EACE,kCAAkC;AACpC;;AAEA;EACE,SAAS;EACT,kBAAkB;EAClB,UAAU;EACV,qBAAqB;AACvB;;AAEA;EACE,gBAAgB;EAChB,UAAU;EACV,iBAAiB;AACnB;;;AAGA;EACE,aAAa;EACb,sBAAsB;EACtB,mBAAmB;EACnB,cAAc;EACd,aAAa;EACb,mCAAmC;EACnC,+BAA+B;EAC/B,qCAAqC;AACvC;;AAEA;EACE,SAAS;AACX;;AAEA;EACE,mBAAmB;AACrB;;AAEA;EACE,yBAAyB;EACzB,oBAAoB;AACtB;;AAEA;EACE,YAAY;EACZ,sBAAsB;EACtB,oBAAoB;EACpB,mBAAmB;EACnB,mBAAmB;AACrB;;AAEA;EACE,YAAY;EACZ,gBAAgB;AAClB;;AAEA;EACE,YAAY;EACZ,gBAAgB;AAClB;;;AAGA;EACE,WAAW;AACb;;AAEA;EACE,SAAS;EACT,kBAAkB;AACpB;;AAEA;EACE,SAAS;EACT,kBAAkB;AACpB;;AAEA;EACE,UAAU;AACZ;;AAEA;EACE,UAAU;AACZ;;AAEA;EACE,mEAAmE;EACnE,sBAAsB;AACxB;;AAEA;EACE,qDAAqD;AACvD;;AAEA;EACE,2DAA2D;EAC3D,eAAe;AACjB;;AAEA;EACE,aAAa;EACb,kBAAkB;EAClB,sBAAsB;EACtB,YAAY;EACZ,yCAAyC;EACzC,YAAY;EACZ,sBAAsB;EACtB,mBAAmB;EACnB,uBAAuB;;AAEzB;;AAEA;EACE,0CAA0C;EAC1C,uEAAuE;;EAEvE,yBAAyB;EACzB,uBAAuB;EACvB,sBAAsB;EACtB,iDAAiD;EACjD,gCAAgC;EAChC,4EAA4E;EAC5E,6BAA6B;EAC7B,wBAAwB;EACxB,2BAA2B;EAC3B,mCAAmC;EACnC,gCAAgC;;AAElC;;AAEA;EACE,oDAAoD;EACpD,0BAA0B;EAC1B,0CAA0C;EAC1C,6DAA6D;EAC7D,yDAAyD;AAC3D;;AAEA;EACE,eAAe;AACjB;;AAEA;EACE,iBAAiB;AACnB;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,YAAY;EACZ,cAAc;AAChB;;AAEA;EACE,iBAAiB;AACnB;;AAEA;EACE,0BAA0B;AAC5B;;AAEA;EACE,gBAAgB;EAChB,UAAU;EACV,iBAAiB;AACnB;;AAEA;EACE,kBAAkB;EAClB,UAAU;EACV,SAAS;EACT,WAAW;AACb;;AAEA;EACE,0BAA0B;AAC5B;;AAEA;EACE,4BAA4B;AAC9B","sourcesContent":["@import url('base.css');\n\n:root {\n  --julynter-font-size1: var(--jp-ui-font-size1);\n  --julynter-title-font-size: var(--jp-ui-font-size0);\n  \n}\n\n.julynter-main-icon, .julynter-main-new-icon {\n  display: block;\n  height: auto;\n  margin: 0 auto;\n  width: 20px;\n}\n\n.jp-Julynter-content {\n  flex: 1 1 auto;\n  margin: 0;\n  padding: 0;\n  list-style-type: none;\n  overflow: auto;\n  background-color: var(--jp-layout-color1);\n}\n\n.jp-Julynter-content .julynter-list-item {\n  display: flex;\n  flex-direction: row;\n  padding: 4px 12px;\n  cursor: pointer;\n  padding-top: 8px;\n  padding-bottom: 8px;\n}\n\n.jp-Julynter-content .julynter-list-item:hover {\n  background: var(--jp-layout-color2);\n}\n\n.jp-Julynter {\n  display: flex;\n  flex-direction: column;\n  background: var(--jp-layout-color1);\n  color: var(--jp-ui-font-color1);\n  font-size: var(--julynter-title-font-size);\n  height: 100%;\n}\n\n.jp-Julynter header {\n  border-bottom: var(--jp-border-width) solid var(--jp-border-color2);\n  flex: 0 0 auto;\n  font-size: var(--julynter-title-font-size);\n  font-weight: 600;\n  letter-spacing: 1px;\n  margin: 0px;\n  padding: 12px 0 4px 12px;\n  text-transform: uppercase;\n}\n\n.julynter-title {\n  display: inline-block;\n}\n\n.julynter-title:hover {\n  cursor: pointer;\n}\n\n.jp-Julynter-kernel {\n  float: right;\n}\n\n.jp-Julynter-kernel span {\n  float: left;\n  margin: 0 3px;\n}\n\n.julynter-toolbar-icon,\n.julynter-toolbar-icon-selected {\n  float: left;\n  padding: 0px;\n  margin: 4px;\n  /*background-repeat: no-repeat;\n  background-color: none;\n  background-size: 100%;\n  background-position: center;*/\n  height: 24px;\n  width: 24px;\n  margin: 4px;\n  border-radius: 2px;\n}\n\n.julynter-icon {\n  float: left;\n  /*background-repeat: no-repeat;\n  background-color: none;\n  background-size: 100%;\n  background-position: center;*/\n  height: 12px;\n  width: 12px;\n  margin-right: 8px;\n}\n\n[data-jp-theme-light='true'] .julynter-toolbar-icon:hover {\n  background-color: var(--jp-input-background);\n}\n\n[data-jp-theme-light='false'] .julynter-toolbar-icon:hover {\n  background-color: #3a3a3a;\n}\n\n[data-jp-theme-light='true'] .julynter-toolbar-icon-selected {\n  background-color: var(--jp-layout-color2);\n}\n\n[data-jp-theme-light='false'] .julynter-toolbar-icon-selected {\n  background-color: #565656;\n}\n\n.julynter-toolbar-icon-selected:hover, .julynter-toolbar-icon:hover {\n  cursor: pointer;\n}\n\n.julynter-toolbar-icon-selected:hover, .julynter-toolbar-icon-with-text:hover {\n  cursor: pointer;\n}\n\n.julynter-toolbar-icon-with-text {\n  position: relative;\n}\n\n.julynter-toolbar-icon-text {\n  position: absolute;\n  right: 5px;\n  font-size: 8px;\n  bottom: -28px;\n}\n\n\n\n.julynter-toolbar {\n  position: relative;\n  width: 100%;\n  margin: 0px;\n  padding: 2px 0;\n  user-select: none;\n  border-bottom: var(--jp-border-width) solid var(--jp-border-color2);\n  display: flex;\n  align-items: center;\n  flex-wrap: wrap;\n}\n\n.julynter-entry-holder {\n  display: inline-flex;\n  position: relative;\n  align-items: center;\n  width: 100%;\n}\n\n.julynter-collapse-button {\n  padding-left: 3px;\n  cursor: default;\n  min-width: 11px;\n  position: absolute;\n}\n\n.julynter-arrow-img {\n  top: 0;\n  bottom: 0;\n  margin: auto;\n  position: absolute;\n  background-repeat: no-repeat;\n}\n\n.julynter-downarrow-img {\n  width: 12px;\n  height: 6px;\n}\n\n.julynter-rightarrow-img {\n  width: 7px;\n  height: 12px;\n}\n\n.julynter-twist-placeholder {\n  max-width: 10px;\n  opacity: 0;\n  overflow: hidden;\n}\n\n.julynter-report-div {\n  display: inline-flex;\n  width: 100%;\n}\n\n.julynter-has-parent {\n  padding-left: 24px;\n}\n\n.julynter-normal-size {\n  font-size: var(--julynter-font-size1);\n}\n\n.julynter-title-size {\n  font-size: var(--julynter-font-size1);\n  font-weight: bold;\n}\n\n.julynter-report-prompt {\n  width: 100%;\n}\n\n\n.julynter-feedback {\n  display: none;\n  align-items: center;\n  flex-wrap: wrap;\n}\n\n.julynter-report-prompt:hover .julynter-feedback {\n  display: flex;\n}\n\n.julynter-feedback-text {\n  flex: 1;\n  padding: 7px 0;\n}\n\n.julynter-feedback-buttons {\n  flex: 1;\n  display: flex;\n}\n\n.julynter-feedback-icon,\n.julynter-feedback-icon-selected {\n  float: left;\n  padding: 0px;\n  margin: 4px;\n  /*background-repeat: no-repeat;\n  background-color: none;\n  background-size: 100%;\n  background-position: center;*/\n  height: 24px;\n  width: 24px;\n  margin: 4px;\n  border-radius: 2px;\n}\n\n[data-jp-theme-light='true'] .julynter-feedback-icon:hover {\n  background-color: white;\n  cursor: pointer;\n}\n\n[data-jp-theme-light='false'] .julynter-feedback-icon:hover {\n  background-color: black;\n  cursor: pointer;\n}\n\n[data-jp-theme-light='true'] .julynter-feedback-icon-selected {\n  background-color: white !important\n}\n\n[data-jp-theme-light='false'] .julynter-feedback-icon-selected {\n  background-color: black !important;\n}\n\n.julynter-feedback-ul {\n  margin: 0;\n  margin-bottom: 5px;\n  padding: 0;\n  list-style-type: none;\n}\n\n.julynter-feedback-textarea {\n  min-width: 400px;\n  width: 99%;\n  min-height: 200px;\n}\n\n\n.julynter-config {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  overflow: auto;\n  padding: 15px;\n  background: var(--jp-layout-color1);\n  color: var(--jp-ui-font-color1);\n  font-size: var(--julynter-font-size0);\n}\n\n.julynter-config-inner h1 {\n  margin: 0;\n}\n\n.julynter-config-notice {\n  margin-bottom: 15px;\n}\n\n.julynter-config-inner table {\n  border-collapse: collapse;\n  border-style: hidden;\n}\n\n.julynter-config-inner table td {\n  border: none;\n  vertical-align: middle;\n  padding: 0.5em 0.5em;\n  line-height: normal;\n  white-space: normal;\n}\n\n.julynter-config-inner table th {\n  border: none;\n  text-align: left;\n}\n\n.julynter-config-inner table tr {\n  border: none;\n  text-align: left;\n}\n\n\n.julynter-config-inner table, .julynter-config-inner tr {\n  width: 100%;\n}\n\n.julynter-config-inner tr td:nth-child(1), .julynter-config-inner tr th:nth-child(1) {\n  width: 5%;\n  text-align: center;\n}\n\n.julynter-config-inner tr td:nth-child(2), .julynter-config-inner tr th:nth-child(2) {\n  width: 5%;\n  text-align: center;\n}\n\n.julynter-config-inner tr td:nth-child(3) {\n  width: 40%;\n}\n\n.julynter-config-inner tr td:nth-child(4) {\n  width: 50%;\n}\n\n.julynter-config-inner thead {\n  border-bottom: var(--jp-border-width) solid var(--jp-border-color1);\n  vertical-align: bottom;\n}\n\n.julynter-config-inner tbody tr:nth-child(2n) {\n  background: var(--jp-rendermime-table-row-background);\n}\n\n.julynter-config-inner tbody tr:hover {\n  background: var(--jp-rendermime-table-row-hover-background);\n  cursor: pointer;\n}\n\n.julynter-config-select {\n  display: flex;\n  position: relative;\n  flex-direction: column;\n  padding: 1px;\n  background-color: var(--jp-layout-color1);\n  height: 28px;\n  box-sizing: border-box;\n  margin-bottom: 12px;\n  width: 189px !important;\n\n}\n\n.julynter-config-select select {\n  color: var(--jp-ui-font-color0) !important;\n  border: var(--jp-border-width) solid var(--jp-border-color1) !important;\n\n  flex: 1 1 auto !important;\n  height: 32px !important;\n  width: 100% !important;\n  background: var(--jp-input-background) !important;\n  padding: 0 25px 0 8px !important;\n  border: var(--jp-border-width) solid var(--jp-input-border-color) !important;\n  border-radius: 0px !important;\n  outline: none !important;\n  appearance: none !important;\n  -webkit-appearance: none !important;\n  -moz-appearance: none !important;\n  \n}\n\n.julynter-config-select select:hover {\n  background-color: var(--jp-layout-color1) !important;\n  cursor: pointer !important;\n  color: var(--jp-ui-font-color0) !important;\n  background-color: var(--jp-input-hover-background) !important;\n  box-shadow: inset 0 0px 1px rgba(0, 0, 0, 0.5) !important;\n}\n\n.julynter-config-group-head {\n  display: inline;\n}\n\n.julynter-config-group-head span {\n  margin-left: 20px;\n}\n\n.julynter-error-desc {\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  height: 100%;\n  margin: 10px 0;\n}\n\n.julynter-context-info {\n  font-weight: bold;\n}\n\n.julynter-error-display:hover {\n  cursor: pointer !important;\n}\n\n.julynter-error-text {\n  min-width: 400px;\n  width: 99%;\n  min-height: 200px;\n}\n\n.julynter-cell-mod {\n  position: absolute;\n  left: 17px;\n  top: 12px;\n  z-index: 10;\n}\n\n.julynter-cell-mod:hover {\n  cursor: pointer !important;\n}\n\n.julynter-header-widget, .julynter-toolbar-widget {\n  overflow: initial !important;\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./style/img/absolute_path.svg":
/*!*************************************!*\
  !*** ./style/img/absolute_path.svg ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"none\" viewBox=\"0 0 14 14\" height=\"14\" width=\"14\">\n  <g transform=\"matrix(0.62624337,0,0,0.58706846,-1.7674072,-1.5478811)\" fill=\"#616161\" class=\"jp-icon3\" fill-opacity=\"1\" stroke-width=\"0.32197925\">\n    <path stroke-width=\"0.85676616\" d=\"M 19.906774,5.0659808 13.635702,23.128381 15.980084,24.054579 22.251156,5.992178 Z\"/>\n    <path d=\"m 5.748844,21.33427 v 2.720309 h 2.5 V 21.33427 Z\"/>\n    <path d=\"m 9.7342712,21.33427 v 2.720309 H 12.234271 V 21.33427 Z\"/>\n  </g>\n</svg>\n");

/***/ }),

/***/ "./style/img/cell.svg":
/*!****************************!*\
  !*** ./style/img/cell.svg ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"none\" viewBox=\"0 0 14 14\" height=\"14\" width=\"14\">\n  <g transform=\"matrix(0.62624337,0,0,0.58706846,-1.7674073,-1.547881)\" fill=\"#616161\" class=\"jp-icon3\" fill-opacity=\"1\">\n    <path stroke-width=\"0.85676616\" d=\"M 23.028232,6.7844226 H 4.9717685 V 9.4512465 H 23.028232 Z\"/>\n    <path stroke-width=\"0.67044264\" d=\"M 23.028232,13.226868 H 11.971384 v 2.666824 h 11.056848 z\"/>\n    <path stroke-width=\"0.67044264\" d=\"M 23.028232,19.669313 H 11.971384 v 2.666824 h 11.056848 z\"/>\n    <text transform=\"scale(0.96821721,1.0328261)\" stroke-width=\"1.64924073\" font-family=\"sans-serif\" font-weight=\"bold\" font-size=\"9px\" y=\"20.23761\" x=\"5.1371584\">\n      C\n    </text>\n  </g>\n</svg>\n");

/***/ }),

/***/ "./style/img/config.svg":
/*!******************************!*\
  !*** ./style/img/config.svg ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 16 16\" width=\"16\" height=\"16\">\n  <path d=\"m 14.009709,9.117343 1.356601,0.783062 c 0.154929,0.08942 0.226843,0.274339 0.173777,0.445187 -0.352394,1.134596 -0.95404,2.159623 -1.740923,3.010968 a 0.38250676,0.38250676 0 0 1 -0.472147,0.07175 l -1.355581,-0.782936 a 6.0984934,6.0984934 0 0 1 -1.934153,1.118297 v 1.565618 A 0.38231577,0.38231577 0 0 1 9.7387882,15.70231 c -1.112759,0.249889 -2.30787,0.262812 -3.476783,1.81e-4 -0.174762,-0.03927 -0.299326,-0.194054 -0.299326,-0.373177 V 13.763672 A 6.0977932,6.0977932 0 0 1 4.0285322,12.645376 L 2.6729503,13.428312 A 0.38250676,0.38250676 0 0 1 2.2008014,13.356556 C 1.4139503,12.505215 0.81227258,11.480188 0.45987978,10.345592 0.40681428,10.174777 0.47872428,9.989856 0.63365708,9.900405 L 1.9902892,9.117343 a 6.159072,6.159072 0 0 1 0,-2.234652 L 0.63368878,6.099627 C 0.47875648,6.010208 0.40684598,5.825289 0.45991178,5.654441 0.81230428,4.519846 1.4139503,3.4948188 2.200833,2.6434745 A 0.38250676,0.38250676 0 0 1 2.6729823,2.5717234 L 4.0285632,3.3546588 A 6.0984934,6.0984934 0 0 1 5.9627112,2.2363606 V 0.67071249 a 0.38231577,0.38231577 0 0 1 0.2985,-0.3730211 c 1.112759,-0.2498895 2.30787,-0.2628141 3.476779,-1.818e-4 0.174767,0.03925 0.2993248,0.1940548 0.2993248,0.3731803 V 2.2363695 a 6.0977932,6.0977932 0 0 1 1.934153,1.118297 l 1.35558,-0.7829354 a 0.38250676,0.38250676 0 0 1 0.472147,0.071751 c 0.786852,0.8513444 1.38853,1.8763719 1.740925,3.0109669 0.05307,0.170817 -0.01886,0.355736 -0.173778,0.445187 l -1.356633,0.783062 a 6.1592311,6.1592311 0 0 1 0,2.234684 z M 10.54665,8 c 0,-1.404222 -1.1424298,-2.546648 -2.5466508,-2.546648 -1.404225,0 -2.546649,1.142426 -2.546649,2.546648 0,1.404224 1.142424,2.546651 2.546649,2.546651 1.404221,0 2.5466508,-1.142427 2.5466508,-2.546651 z\" fill=\"#616161\" class=\"jp-icon3\"/>\n</svg>\n<!--\nFont Awesome Free 5.2.0 by @fontawesome - https://fontawesome.com\nLicense - https://fontawesome.com/license (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License)\n-->\n\n");

/***/ }),

/***/ "./style/img/confuse_notebook.svg":
/*!****************************************!*\
  !*** ./style/img/confuse_notebook.svg ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"none\" viewBox=\"0 0 14 14\" height=\"14\" width=\"14\">\n  <g transform=\"matrix(0.62624337,0,0,0.58706846,-1.7773957,-1.5478812)\" fill=\"#616161\" class=\"jp-icon3\">\n    <rect transform=\"matrix(0.27021647,0,0,1.1359728,1.7476977,-0.79510944)\" y=\"5.0442429\" x=\"4.392499\" height=\"2.200757\" width=\"19.215002\" stroke-width=\"0.79880279\"/>\n    <path stroke-width=\"0.81105113\" d=\"m 2.9346233,6.924827 v 17.26072 h 2.5 V 6.924827 Z\"/>\n    <path stroke-width=\"0.81105113\" d=\"M 22.597275,6.9248275 V 24.185547 h 2.500001 V 6.9248275 Z\"/>\n    <rect transform=\"matrix(0.27021647,0,0,1.1359728,18.718141,-0.79510944)\" y=\"5.0442429\" x=\"4.392499\" height=\"2.200757\" width=\"19.215002\" stroke-width=\"0.79880279\"/>\n    <rect transform=\"matrix(0.27021647,0,0,1.1359728,1.7476977,15.955424)\" y=\"5.0442429\" x=\"4.392499\" height=\"2.200757\" width=\"19.215002\" stroke-width=\"0.79880279\"/>\n    <rect transform=\"matrix(0.27021647,0,0,1.1359728,18.718141,15.955424)\" y=\"5.0442429\" x=\"4.392499\" height=\"2.200757\" width=\"19.215002\" stroke-width=\"0.79880279\"/>\n    <path stroke-width=\"0.68351513\" d=\"m 10.179567,10.180007 v 12.259105 h 2.500001 V 10.180007 Z\"/>\n    <path stroke-width=\"0.68351513\" d=\"M 15.320433,6.6814485 V 18.940554 h 2.500001 V 6.6814485 Z\"/>\n    <path d=\"M 11.429568,6.6814492 8.0469782,10.289757 h 6.7651788 z\"/>\n    <path d=\"m 16.570433,22.439111 -3.382589,-3.608307 h 6.765178 z\"/>\n  </g>\n</svg>\n");

/***/ }),

/***/ "./style/img/disconnected.svg":
/*!************************************!*\
  !*** ./style/img/disconnected.svg ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 16\" height=\"16\">\n  <g fill=\"#616161\" class=\"jp-icon3\">\n    <path transform=\"translate(0,-4)\" d=\"M 12,2 C 6.47,2 2,6.47 2,12 2,17.53 6.47,22 12,22 17.53,22 22,17.53 22,12 22,6.47 17.53,2 12,2 Z m 0,18 C 7.59,20 4,16.41 4,12 4,7.59 7.59,4 12,4 c 4.41,0 8,3.59 8,8 0,4.41 -3.59,8 -8,8 z\"/>\n    <path d=\"M 21.728414,-1.3268685 2.2715864,17.326869\" stroke=\"#616161\" class=\"jp-icon3\" stroke-width=\"2.10188866\"/>\n    <path transform=\"matrix(-1,0,0,1,24,0)\" stroke=\"#616161\" class=\"jp-icon3\" stroke-width=\"2.10188866\" d=\"M 21.728414,-1.3268685 2.2715864,17.326869\" />\n  </g>\n</svg>\n");

/***/ }),

/***/ "./style/img/eye.svg":
/*!***************************!*\
  !*** ./style/img/eye.svg ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 14 14\" height=\"14\" width=\"14\" fill=\"none\">\n  <g stroke=\"#616161\" class=\"jp-icon3\" transform=\"translate(-7.0357557,-7.0364287)\">\n    <path d=\"m 7.6858019,14.342784 c 4.6714231,-4.956115 8.8731271,-4.36956 12.7542391,0\" />\n    <path d=\"m 7.6214896,13.730082 c 4.6714234,4.956104 8.8731274,4.369548 12.7542384,0\" />\n    <circle fill=\"#616161\" class=\"jp-icon3\" stroke=\"none\" r=\"2.2468221\" cy=\"14.02391\" cx=\"14.099997\" />\n  </g>\n</svg>\n");

/***/ }),

/***/ "./style/img/feedback.svg":
/*!********************************!*\
  !*** ./style/img/feedback.svg ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"none\" viewBox=\"0 0 28 28\" height=\"28\" width=\"28\">\n  <path stroke=\"#616161\" class=\"jp-icon3\" d=\"m 9.2083696,15.861569 c 0.057557,0.907014 -0.2764341,1.665668 -0.7176961,2.647047 0.6746078,-0.478153 1.3293943,-0.910117 2.1741705,-1.288446 1.78906,-0.683699 3.622411,-0.758293 5.434908,-1.047956 2.014387,-0.230322 3.019376,-0.799644 4.062128,-2.409338 C 20.914136,12.016943 19.924227,10.69682 18.864116,9.7869423 16.74549,7.9685613 12.539235,8.2858562 10.405773,9.6030608 8.6829443,10.66674 6.2657853,12.611549 8.4449707,14.954164 c 0.2607704,0.280325 0.7390134,0.501489 0.7633989,0.907405 z\"/>\n</svg>\n");

/***/ }),

/***/ "./style/img/filter.svg":
/*!******************************!*\
  !*** ./style/img/filter.svg ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"none\" viewBox=\"0 0 14 14\" height=\"14\" width=\"14\">\n  <path class=\"jp-icon3\" stroke=\"#616161\" stroke-width=\"1px\" d=\"M 1.9521038,2.132089 H 12.061334 L 8.2022087,7.1657296 V 10.81512 L 5.8951231,11.654061 V 7.1657296 Z\"/>\n</svg>\n");

/***/ }),

/***/ "./style/img/hidden_state.svg":
/*!************************************!*\
  !*** ./style/img/hidden_state.svg ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"none\" viewBox=\"0 0 14 14\" height=\"14\" width=\"14\">\n  <g transform=\"matrix(0.62624337,0,0,0.58706846,-1.7773957,-1.5478812)\" fill=\"#616161\" class=\"jp-icon3\">\n    <rect transform=\"matrix(0.27021647,0,0,1.1359728,1.7476977,-0.79510944)\" y=\"5.0442429\" x=\"4.392499\" height=\"2.200757\" width=\"19.215002\" stroke-width=\"0.79880279\"/>\n    <path stroke-width=\"0.81105113\" d=\"m 2.9346233,6.924827 v 17.26072 h 2.5 V 6.924827 Z\"/>\n    <path stroke-width=\"0.81105113\" d=\"M 22.597275,6.9248275 V 24.185547 h 2.500001 V 6.9248275 Z\"/>\n    <rect transform=\"matrix(0.27021647,0,0,1.1359728,18.718141,-0.79510944)\" y=\"5.0442429\" x=\"4.392499\" height=\"2.200757\" width=\"19.215002\" stroke-width=\"0.79880279\"/>\n    <rect transform=\"matrix(0.27021647,0,0,1.1359728,1.7476977,15.955424)\" y=\"5.0442429\" x=\"4.392499\" height=\"2.200757\" width=\"19.215002\" stroke-width=\"0.79880279\"/>\n    <rect transform=\"matrix(0.27021647,0,0,1.1359728,18.718141,15.955424)\" y=\"5.0442429\" x=\"4.392499\" height=\"2.200757\" width=\"19.215002\" stroke-width=\"0.79880279\"/>\n    <text transform=\"scale(0.96821721,1.0328261)\" y=\"22.589752\" x=\"8.9420986\" font-size=\"22px\" stroke-width=\"1.64924073\" font-family=\"sans-serif\">\n      ?\n    </text>\n  </g>\n</svg>\n");

/***/ }),

/***/ "./style/img/import.svg":
/*!******************************!*\
  !*** ./style/img/import.svg ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"none\" viewBox=\"0 0 14 14\" height=\"14\" width=\"14\">\n  <g transform=\"matrix(0.62624337,0,0,0.58706846,-1.7773956,-0.3968846)\" fill=\"#616161\" class=\"jp-icon3\">\n    <rect transform=\"matrix(0.27021647,0,0,1.1359728,4.2715243,2.6116483)\" y=\"5.0442429\" x=\"4.392499\" height=\"2.200757\" width=\"19.215002\" stroke-width=\"0.79880279\"/>\n    <path d=\"m 5.4584499,10.0687 v 14.116847 h 2.5 V 10.0687 Z\" stroke-width=\"0.7334789\"/>\n    <path d=\"m 20.073448,10.0687 v 14.116847 h 2.500001 V 10.0687 Z\" stroke-width=\"0.7334789\"/>\n    <rect transform=\"matrix(0.27021647,0,0,1.1359728,16.194314,2.6116483)\" y=\"5.0442429\" x=\"4.392499\" height=\"2.200757\" width=\"19.215002\" stroke-width=\"0.79880279\"/>\n    <rect transform=\"matrix(0.87328074,0,0,1.1359728,1.6440535,15.955424)\" y=\"5.0442429\" x=\"4.392499\" height=\"2.200757\" width=\"19.215002\" stroke-width=\"0.79880279\"/>\n    <path d=\"m 12.143564,1.0138466 v 4.1850681 h 3.712872 V 1.0138466 Z\" stroke-width=\"0.48669285\"/>\n    <path d=\"M 14,8.6974717 8.9763532,5.0891647 H 19.023647 Z\"/>\n    <rect transform=\"matrix(0.29461795,0,0,0.61650316,7.5139397,12.068671)\" y=\"5.0442429\" x=\"4.392499\" height=\"2.200757\" width=\"19.215002\" stroke-width=\"0.79880279\"/>\n    <rect transform=\"matrix(0.29461795,0,0,0.61650316,7.5139397,14.112787)\" y=\"5.0442429\" x=\"4.392499\" height=\"2.200757\" width=\"19.215002\" stroke-width=\"0.79880279\"/>\n    <rect transform=\"matrix(0.29461795,0,0,0.61650316,7.5139397,16.256337)\" y=\"5.0442429\" x=\"4.392499\" height=\"2.200757\" width=\"19.215002\" stroke-width=\"0.79880279\"/>\n  </g>\n</svg>\n");

/***/ }),

/***/ "./style/img/julynter.svg":
/*!********************************!*\
  !*** ./style/img/julynter.svg ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"20\" viewBox=\"0 0 30 16\" height=\"16\">\n  <g transform=\"translate(2.0365779)\">\n    <path transform=\"translate(0,-4)\" fill=\"#616161\" class=\"jp-icon3\" d=\"M 12,2 C 6.47,2 2,6.47 2,12 2,17.53 6.47,22 12,22 17.53,22 22,17.53 22,12 22,6.47 17.53,2 12,2 Z m 0,18 C 7.59,20 4,16.41 4,12 4,7.59 7.59,4 12,4 c 4.41,0 8,3.59 8,8 0,4.41 -3.59,8 -8,8 z\" />\n    <path stroke=\"#616161\" class=\"jp-icon3\" d=\"M 6.0655869,7.1523533 11.451315,11.83538 23.069098,-1.2298715\" stroke-width=\"2.2956202\" style=\"fill:none;\"/>\n  </g>\n</svg>\n");

/***/ }),

/***/ "./style/img/julynter_new.svg":
/*!************************************!*\
  !*** ./style/img/julynter_new.svg ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"20\" viewBox=\"0 0 30 16\" height=\"16\">\n  <g transform=\"translate(2.0365779)\">\n    <path transform=\"translate(0,-4)\" fill=\"#616161\" class=\"jp-icon3\" d=\"M 12,2 C 6.47,2 2,6.47 2,12 2,17.53 6.47,22 12,22 17.53,22 22,17.53 22,12 22,6.47 17.53,2 12,2 Z m 0,18 C 7.59,20 4,16.41 4,12 4,7.59 7.59,4 12,4 c 4.41,0 8,3.59 8,8 0,4.41 -3.59,8 -8,8 z\" />\n    <path stroke=\"#616161\" class=\"jp-icon3\" d=\"M 6.0655869,7.1523533 11.451315,11.83538 23.069098,-1.2298715\" stroke-width=\"2.2956202\" style=\"fill:none;\"/>\n  </g>\n  <text x=\"19.525425\" y=\"26.101696\" font-family=\"sans-serif\" stroke-width=\"1.5\" font-size=\"22px\" fill=\"#d70000\">\n   *\n  </text>\n</svg>");

/***/ }),

/***/ "./style/img/kerneloff.svg":
/*!*********************************!*\
  !*** ./style/img/kerneloff.svg ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 16\" height=\"16\">\n  <g fill=\"#616161\" class=\"jp-icon3\">\n    <path transform=\"translate(0,-4)\" d=\"M 12,2 C 6.47,2 2,6.47 2,12 2,17.53 6.47,22 12,22 17.53,22 22,17.53 22,12 22,6.47 17.53,2 12,2 Z m 0,18 C 7.59,20 4,16.41 4,12 4,7.59 7.59,4 12,4 c 4.41,0 8,3.59 8,8 0,4.41 -3.59,8 -8,8 z\"/>\n    <path stroke=\"#616161\" class=\"jp-icon3\" stroke-width=\"2.10188866\" d=\"M 21.728414,-1.3268685 2.2715864,17.326869\"/>\n  </g>\n</svg>\n");

/***/ }),

/***/ "./style/img/kernelon.svg":
/*!********************************!*\
  !*** ./style/img/kernelon.svg ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 16\" height=\"16\">\n  <g fill=\"#616161\" class=\"jp-icon3\">\n    <path transform=\"translate(0,-4)\" d=\"M 12,2 C 6.47,2 2,6.47 2,12 2,17.53 6.47,22 12,22 17.53,22 22,17.53 22,12 22,6.47 17.53,2 12,2 Z m 0,18 C 7.59,20 4,16.41 4,12 4,7.59 7.59,4 12,4 c 4.41,0 8,3.59 8,8 0,4.41 -3.59,8 -8,8 z\"/>\n  </g>\n</svg>\n");

/***/ }),

/***/ "./style/img/list.svg":
/*!****************************!*\
  !*** ./style/img/list.svg ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"none\" viewBox=\"0 0 14 14\" height=\"14\" width=\"14\">\n  <g transform=\"matrix(0.62624337,0,0,0.58706846,-1.7674072,-1.547881)\" fill=\"#616161\" class=\"jp-icon3\" stroke-width=\"0.85676616\">\n    <path d=\"M 23.028232,6.7844226 H 4.9717685 V 9.4512465 H 23.028232 Z\"/>\n    <path d=\"M 23.028232,13.226868 H 4.9717681 v 2.666824 H 23.028232 Z\"/>\n    <path d=\"M 23.028232,19.669313 H 4.9717681 v 2.666824 H 23.028232 Z\"/>\n  </g>\n</svg>\n");

/***/ }),

/***/ "./style/img/minus.svg":
/*!*****************************!*\
  !*** ./style/img/minus.svg ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"none\" viewBox=\"0 0 28 28\" height=\"28\" width=\"28\">\n  <path fill=\"#616161\" class=\"jp-icon3\" d=\"M 19.65387,13.217196 H 8.3461296 v 1.565608 H 19.65387 Z\" stroke-width=\"0.51949126\" />\n</svg>\n");

/***/ }),

/***/ "./style/img/neverconnected.svg":
/*!**************************************!*\
  !*** ./style/img/neverconnected.svg ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 16\" height=\"16\">\n  <path stroke=\"#616161\" fill=\"#616161\" class=\"jp-icon3\" stroke-width=\"2.10188866\" d=\"M 2.271586,-1.3268685 21.728414,17.326869\"/>\n</svg>\n");

/***/ }),

/***/ "./style/img/plus.svg":
/*!****************************!*\
  !*** ./style/img/plus.svg ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"none\" viewBox=\"0 0 28 28\" height=\"28\" width=\"28\">\n  <g fill=\"#616161\" class=\"jp-icon3\" stroke-width=\"0.51949126\">\n    <path d=\"M 13.217196,8.3461282 V 19.653872 h 1.565608 V 8.3461282 Z\"/>\n    <path d=\"M 19.65387,13.217196 H 8.3461299 v 1.565608 H 19.65387 Z\"/>\n  </g>\n</svg>\n");

/***/ }),

/***/ "./style/img/rename.svg":
/*!******************************!*\
  !*** ./style/img/rename.svg ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"none\" viewBox=\"0 0 14 14\" height=\"14\" width=\"14\">\n  <g transform=\"matrix(0.62624337,0,0,0.58706846,-1.8325914,-0.9044806)\" fill=\"#616161\" class=\"jp-icon3\">\n    <rect transform=\"matrix(0.22401213,0,0,0.94173272,4.4915057,4.077517)\" y=\"5.0442429\" x=\"4.392499\" height=\"2.200757\" width=\"19.215002\" stroke-width=\"0.79880279\"/>\n    <path d=\"M 5.4754788,10.259487 V 21.962493 H 7.5480036 V 10.259487 Z\" stroke-width=\"0.60806131\" />\n    <path d=\"m 17.591457,10.259487 v 11.703006 h 2.072526 V 10.259487 Z\" stroke-width=\"0.60806131\"/>\n    <rect transform=\"matrix(0.22401213,0,0,0.94173272,14.375617,4.077517)\" y=\"5.0442429\" x=\"4.392499\" height=\"2.200757\" width=\"19.215002\" stroke-width=\"0.79880279\"/>\n    <rect transform=\"matrix(0.7239584,0,0,0.94173272,2.3133063,15.139639)\" y=\"5.0442429\" x=\"4.392499\" height=\"2.200757\" width=\"19.215002\" stroke-width=\"0.79880279\" />\n    <rect transform=\"matrix(0.2442412,0,0,0.51108724,7.1795002,11.917483)\" y=\"5.0442429\" x=\"4.392499\" height=\"2.200757\" width=\"19.215002\" stroke-width=\"0.79880279\" />\n    <rect transform=\"matrix(0.2442412,0,0,0.51108724,7.1795002,13.612075)\" y=\"5.0442429\" x=\"4.392499\" height=\"2.200757\" width=\"19.215002\" stroke-width=\"0.79880279\" />\n    <rect transform=\"matrix(0.2442412,0,0,0.51108724,7.1795002,15.389099)\" y=\"5.0442429\" x=\"4.392499\" height=\"2.200757\" width=\"19.215002\" stroke-width=\"0.79880279\" />\n    <text x=\"17.478132\" y=\"11.602592\" font-family=\"sans-serif\" font-weight=\"bold\" font-size=\"12px\" stroke-width=\"1.50995505\" transform=\"scale(0.96821721,1.0328261)\">\n      *\n    </text>\n    <rect transform=\"matrix(0.89158181,0,0,0.61650316,1.5259327,19.677232)\" y=\"5.0442429\" x=\"4.392499\" height=\"2.200757\" width=\"19.215002\" stroke-width=\"0.79880279\" />\n  </g>\n</svg>\n");

/***/ }),

/***/ "./style/img/title.svg":
/*!*****************************!*\
  !*** ./style/img/title.svg ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"14\" height=\"14\" viewBox=\"0 0 14 14\" fill=\"none\">\n  <g fill=\"#616161\" class=\"jp-icon3\" transform=\"matrix(0.62624337,0,0,0.58706846,-1.7674072,-1.5478812)\">\n    <rect transform=\"matrix(0.89071029,0,0,1.1359728,1.5300559,-0.79510944)\" width=\"19.215002\" height=\"2.200757\" x=\"4.392499\" y=\"5.0442429\" stroke-width=\"0.79880279\"/>\n    <path d=\"m 12.75,6.924827 v 17.26072 h 2.5 V 6.924827 Z\" stroke-width=\"0.79880279\"/>\n  </g>\n</svg>\n");

/***/ }),

/***/ "./style/img/toggle_down.svg":
/*!***********************************!*\
  !*** ./style/img/toggle_down.svg ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg width=\"12\" height=\"6\" viewBox=\"0 0 12 6\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n  <path d=\"M0.000324726 0L5.83366 5.83333L11.667 0L0.000324726 0Z\" fill=\"#616161\" class=\"jp-icon3\"/>\n</svg>\n");

/***/ }),

/***/ "./style/img/toggle_right.svg":
/*!************************************!*\
  !*** ./style/img/toggle_right.svg ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg width=\"7\" height=\"12\" viewBox=\"0 0 7 12\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n  <path d=\"M0.719727 11.8327L6.55306 5.99935L0.719727 0.166016V11.8327Z\" fill=\"#616161\" class=\"jp-icon3\"/>\n</svg>\n");

/***/ }),

/***/ "./style/img/type.svg":
/*!****************************!*\
  !*** ./style/img/type.svg ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"none\" viewBox=\"0 0 14 14\" height=\"14\" width=\"14\">\n  <g transform=\"matrix(0.62624337,0,0,0.58706846,-1.7674073,-1.547881)\" fill=\"#616161\" class=\"jp-icon3\">\n    <path stroke-width=\"0.85676616\" d=\"M 23.028232,6.7844226 H 4.9717685 V 9.4512465 H 23.028232 Z\"/>\n    <path stroke-width=\"0.67044264\" d=\"M 23.028232,13.226868 H 11.971384 v 2.666824 h 11.056848 z\"/>\n    <path stroke-width=\"0.67044264\" d=\"M 23.028232,19.669313 H 11.971384 v 2.666824 h 11.056848 z\"/>\n    <text transform=\"scale(0.96821721,1.0328261)\" y=\"20.23761\" x=\"5.1371584\" font-weight=\"bold\" font-size=\"9px\" font-family=\"sans-serif\" stroke-width=\"1.64924073\">\n     T\n   </text>\n  </g>\n</svg>\n");

/***/ }),

/***/ "./style/index.css":
/*!*************************!*\
  !*** ./style/index.css ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./index.css */ "./node_modules/css-loader/dist/cjs.js!./style/index.css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ })

}]);
//# sourceMappingURL=lib_index_js.477fc1f8a8e005d3f2cf.js.map