# #########################################################################
# Copyright (c) 2020, UChicago Argonne, LLC. All rights reserved.         #
#                                                                         #
# Copyright 2020. UChicago Argonne, LLC. This software was produced       #
# under U.S. Government contract DE-AC02-06CH11357 for Argonne National   #
# Laboratory (ANL), which is operated by UChicago Argonne, LLC for the    #
# U.S. Department of Energy. The U.S. Government has rights to use,       #
# reproduce, and distribute this software.  NEITHER THE GOVERNMENT NOR    #
# UChicago Argonne, LLC MAKES ANY WARRANTY, EXPRESS OR IMPLIED, OR        #
# ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.  If software is     #
# modified to produce derivative works, such modified software should     #
# be clearly marked, so as not to confuse it with the version available   #
# from ANL.                                                               #
#                                                                         #
# Additionally, redistribution and use in source and binary forms, with   #
# or without modification, are permitted provided that the following      #
# conditions are met:                                                     #
#                                                                         #
#     * Redistributions of source code must retain the above copyright    #
#       notice, this list of conditions and the following disclaimer.     #
#                                                                         #
#     * Redistributions in binary form must reproduce the above copyright #
#       notice, this list of conditions and the following disclaimer in   #
#       the documentation and/or other materials provided with the        #
#       distribution.                                                     #
#                                                                         #
#     * Neither the name of UChicago Argonne, LLC, Argonne National       #
#       Laboratory, ANL, the U.S. Government, nor the names of its        #
#       contributors may be used to endorse or promote products derived   #
#       from this software without specific prior written permission.     #
#                                                                         #
# THIS SOFTWARE IS PROVIDED BY UChicago Argonne, LLC AND CONTRIBUTORS     #
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT       #
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS       #
# FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL UChicago     #
# Argonne, LLC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,        #
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,    #
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;        #
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER        #
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT      #
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN       #
# ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE         #
# POSSIBILITY OF SUCH DAMAGE.                                             #
# #########################################################################
#
# This is a translation from matlab code:
#
#% Calculates the coeficients Delta and Beta of the Refractive Index
#% -------------------------------------------------------------------------
#% by Joan Vila, October 2010
#
#% The input parameters are the photon energy and the material
#%
#% Materials:    'Au' for Gold
#%               'Ir' for Iridium
#%               'Ni' for Niquel
#%               'Si' for Silicon
#%               'Diamond' for Diamond
#%               'Ge' for Germanium
#%               'SiO2' for Silicon Oxide
#%
#% The routine returns n = delta +i*beta
import numpy, xraylib
from orangecontrib.shadow.util.shadow_util import ShadowPhysics

REFRACTIVE_DATA = {
'Au': numpy.array([[30., 0.153792322, 0.549643338],
                   [30.4181843, 0.170580178, 0.54826504],
                   [30.8421955, 0.18453823, 0.542276204],
                   [31.2721214, 0.19882378, 0.535783827],
                   [31.7080383, 0.218878135, 0.521806717],
                   [32.150032, 0.227999225, 0.499722779],
                   [32.5981827, 0.230446294, 0.481251299],
                   [33.0525818, 0.231495038, 0.46591419],
                   [33.5133171, 0.232590765, 0.451959014],
                   [33.9804764, 0.233223572, 0.438420385],
                   [34.4541473, 0.233286321, 0.42528668],
                   [34.9344177, 0.232778057, 0.41253081],
                   [35.4213829, 0.231651664, 0.400140703],
                   [35.9151382, 0.229945689, 0.388121098],
                   [36.4157791, 0.227543131, 0.376463592],
                   [36.9233932, 0.224330127, 0.365784049],
                   [37.4380875, 0.220881969, 0.356333166],
                   [37.9599533, 0.218079567, 0.347669184],
                   [38.4890938, 0.215512767, 0.339214474],
                   [39.0256119, 0.213026881, 0.330966502],
                   [39.5696068, 0.210473791, 0.322918206],
                   [40.1211853, 0.207736552, 0.31531015],
                   [40.6804543, 0.205160603, 0.30814749],
                   [41.2475166, 0.202887446, 0.301286638],
                   [41.8224831, 0.200810343, 0.294580132],
                   [42.405468, 0.198879361, 0.288022012],
                   [42.9965744, 0.197136313, 0.281609029],
                   [43.5959282, 0.195742771, 0.275341004],
                   [44.2036324, 0.195055202, 0.268816441],
                   [44.8198051, 0.194133967, 0.26150161],
                   [45.4445686, 0.192560449, 0.253799528],
                   [46.0780411, 0.190471604, 0.246323436],
                   [46.7203445, 0.188117132, 0.239056647],
                   [47.3715973, 0.185607553, 0.231899455],
                   [48.0319328, 0.182662174, 0.224799469],
                   [48.7014732, 0.179344505, 0.21790497],
                   [49.3803444, 0.175494671, 0.2112225],
                   [50.0686798, 0.170776099, 0.205356091],
                   [50.7666092, 0.16579856, 0.200726718],
                   [51.4742699, 0.161908358, 0.197048634],
                   [52.1917915, 0.158622369, 0.193437442],
                   [52.9193192, 0.155572042, 0.189893827],
                   [53.6569862, 0.152562514, 0.186414301],
                   [54.4049339, 0.149253324, 0.183448583],
                   [55.163311, 0.146369472, 0.181181431],
                   [55.9322586, 0.144289434, 0.17935802],
                   [56.7119217, 0.142790094, 0.177553311],
                   [57.5024567, 0.141782597, 0.175766498],
                   [58.3040123, 0.141481057, 0.17399767],
                   [59.1167336, 0.142287806, 0.171703473],
                   [59.9407921, 0.142920256, 0.168615609],
                   [60.7763329, 0.143349633, 0.165284008],
                   [61.6235237, 0.143951774, 0.162018299],
                   [62.4825172, 0.145256504, 0.158437297],
                   [63.3534927, 0.147577286, 0.153586403],
                   [64.2366028, 0.148184776, 0.147411659],
                   [65.1320343, 0.148049772, 0.141411006],
                   [66.0399323, 0.147272989, 0.135144353],
                   [66.960495, 0.145865366, 0.128998265],
                   [67.8938904, 0.143917337, 0.123131841],
                   [68.8402939, 0.141474441, 0.117532335],
                   [69.7998886, 0.138513744, 0.112309888],
                   [70.7728577, 0.135268047, 0.108203813],
                   [71.7593994, 0.132507592, 0.104534507],
                   [72.7596817, 0.129904628, 0.101002328],
                   [73.7739182, 0.12728563, 0.097686246],
                   [74.8022842, 0.124816, 0.0946622938],
                   [75.844986, 0.122639604, 0.0918687209],
                   [76.9022217, 0.1207688, 0.0891030878],
                   [77.9741974, 0.119298518, 0.0861474872],
                   [79.0611115, 0.117417462, 0.082799837],
                   [80.1631851, 0.115307204, 0.0795816332],
                   [81.2806168, 0.112912454, 0.0764887333],
                   [82.4136276, 0.109830536, 0.0741740763],
                   [83.5624237, 0.107587419, 0.0733647645],
                   [84.7272415, 0.107667647, 0.0730995387],
                   [85.9082947, 0.108085461, 0.0693679675],
                   [87.1058121, 0.107524775, 0.0657591522],
                   [88.320015, 0.106351733, 0.0618373714],
                   [89.5511475, 0.104730055, 0.0580916107],
                   [90.7994385, 0.102873012, 0.0545728505],
                   [92.0651398, 0.100834124, 0.0511210896],
                   [93.3484802, 0.0985545516, 0.047691185],
                   [94.649704, 0.0959815681, 0.0445114784],
                   [95.9690704, 0.0931195468, 0.0417903028],
                   [97.3068314, 0.0904534385, 0.0394341275],
                   [98.6632385, 0.0879154503, 0.0372235849],
                   [100.038544, 0.0854682401, 0.035136953],
                   [101.433029, 0.0830886886, 0.0331056342],
                   [102.846954, 0.0807276741, 0.0311077721],
                   [104.280579, 0.0783212483, 0.0291960426],
                   [105.734192, 0.0758877024, 0.0274013989],
                   [107.208076, 0.0734095573, 0.0257173777],
                   [108.702492, 0.0709269941, 0.0242731795],
                   [110.217751, 0.0685524493, 0.02298389],
                   [111.754128, 0.0662919804, 0.0217852443],
                   [113.311913, 0.0641156137, 0.0206491388],
                   [114.891418, 0.0619986914, 0.019572312],
                   [116.492943, 0.0599303544, 0.0185527559],
                   [118.116798, 0.0579094253, 0.0176186245],
                   [119.763275, 0.0559628271, 0.0167441145],
                   [121.432716, 0.054079093, 0.0159148294],
                   [123.125427, 0.0522525422, 0.0151265869],
                   [124.841721, 0.0504826419, 0.014377404],
                   [126.581955, 0.0487850644, 0.0136539815],
                   [128.346436, 0.0471810997, 0.0129218185],
                   [130.135513, 0.0455195308, 0.012118144],
                   [131.949539, 0.0437939987, 0.0113645354],
                   [133.788834, 0.041984126, 0.0107169459],
                   [135.653778, 0.0402425751, 0.0102332551],
                   [137.544724, 0.0386097543, 0.00984230079],
                   [139.462021, 0.0370549113, 0.00946628023],
                   [141.406052, 0.0355489813, 0.00910463184],
                   [143.377167, 0.0340639204, 0.00875683315],
                   [145.375778, 0.0325561725, 0.00850432552],
                   [147.402222, 0.0311487336, 0.00832511578],
                   [149.45694, 0.0298261605, 0.00816496089],
                   [151.540268, 0.0285612457, 0.00800790731],
                   [153.652664, 0.027332278, 0.00785387587],
                   [155.794495, 0.0261201765, 0.00770644797],
                   [157.966202, 0.024890976, 0.00758087402],
                   [160.168167, 0.0237331614, 0.00758306822],
                   [162.400818, 0.0226457398, 0.0075852205],
                   [164.664597, 0.0216095392, 0.00758729735],
                   [166.95993, 0.0206059031, 0.00758942543],
                   [169.287262, 0.0196010582, 0.00761136273],
                   [171.647034, 0.0185959805, 0.00768630067],
                   [174.039703, 0.0176807102, 0.00783454068],
                   [176.465729, 0.0168476868, 0.00798582938],
                   [178.925552, 0.0160657503, 0.00813987758],
                   [181.419678, 0.015328181, 0.0082968967],
                   [183.948563, 0.0146319931, 0.00845856033],
                   [186.512726, 0.0139762908, 0.00862525497],
                   [189.112595, 0.0133605553, 0.00879628025],
                   [191.748734, 0.0127834072, 0.00897083525],
                   [194.4216, 0.0122449482, 0.00914862845],
                   [197.131729, 0.0117478585, 0.00933009479],
                   [199.879639, 0.011300127, 0.00951008126],
                   [202.665863, 0.0108857229, 0.00967819896],
                   [205.490906, 0.0104991151, 0.00984063093],
                   [208.355347, 0.0101442309, 0.0100058243],
                   [211.259705, 0.00983429328, 0.0101730516],
                   [214.204544, 0.00960165728, 0.0103378296],
                   [217.190445, 0.00937836431, 0.010398523],
                   [220.217957, 0.00914372224, 0.0104578603],
                   [223.287674, 0.00891437847, 0.0105174528],
                   [226.400192, 0.00869888254, 0.0105774095],
                   [229.556091, 0.0085045211, 0.0106377676],
                   [232.755981, 0.00833708141, 0.010690975],
                   [236.000458, 0.00819415599, 0.0107118189],
                   [239.290176, 0.00804730039, 0.0107149016],
                   [242.625763, 0.00790201966, 0.0107178437],
                   [246.007828, 0.00776735554, 0.0107208434],
                   [249.437057, 0.00765493046, 0.0107238842],
                   [252.914062, 0.00756024383, 0.0107102022],
                   [256.439545, 0.00746934908, 0.0106698908],
                   [260.01416, 0.0073741544, 0.0106264735],
                   [263.638641, 0.00728395255, 0.0105832173],
                   [267.313599, 0.00720431702, 0.0105401669],
                   [271.039825, 0.00714256288, 0.0104972851],
                   [274.817963, 0.00710585155, 0.0104314806],
                   [278.648773, 0.00707190577, 0.0103362892],
                   [282.53299, 0.00702055683, 0.0102237668],
                   [286.471375, 0.00695625274, 0.0101124672],
                   [290.4646, 0.00688985316, 0.0100023467],
                   [294.513519, 0.00682378747, 0.00989349373],
                   [298.618896, 0.00675969105, 0.00978577975],
                   [302.781494, 0.00669921655, 0.00967924669],
                   [307.002106, 0.00664595282, 0.00957387686],
                   [311.281525, 0.00660003349, 0.00946265459],
                   [315.620605, 0.00655633025, 0.00933752954],
                   [320.020203, 0.00650693523, 0.00920916535],
                   [324.48111, 0.00645377673, 0.00908256043],
                   [329.004181, 0.0064013158, 0.00895768218],
                   [333.590363, 0.0063506458, 0.00883454084],
                   [338.240417, 0.00630307151, 0.0087131029],
                   [342.955322, 0.00626032241, 0.00859331153],
                   [347.735901, 0.00622663321, 0.00847493205],
                   [352.58316, 0.00620846217, 0.00835503452],
                   [357.497986, 0.0061843521, 0.00819594227],
                   [362.481323, 0.00614811806, 0.00803989172],
                   [367.534119, 0.00610443251, 0.00788680371],
                   [372.657349, 0.00605684752, 0.00773663446],
                   [377.85199, 0.00600741245, 0.00758933509],
                   [383.119019, 0.00595727144, 0.00744484412],
                   [388.459473, 0.00590748526, 0.00730309589],
                   [393.87439, 0.00585963018, 0.00716403546],
                   [399.364807, 0.00581881823, 0.00702761998],
                   [404.931732, 0.00578210317, 0.0068792766],
                   [410.576233, 0.00573971821, 0.00672452012],
                   [416.299469, 0.00568928057, 0.00656992523],
                   [422.102448, 0.0056332266, 0.00641887123],
                   [427.986359, 0.00557476468, 0.00627130037],
                   [433.95224, 0.0055147917, 0.0061271172],
                   [440.001282, 0.00545417937, 0.0059862379],
                   [446.134674, 0.00539517449, 0.00584861869],
                   [452.353577, 0.00533773564, 0.00571049517],
                   [458.659119, 0.00527821016, 0.00557122659],
                   [465.052582, 0.00521504972, 0.00543288933],
                   [471.535156, 0.00514950184, 0.00529799471],
                   [478.108093, 0.00508261193, 0.00516645284],
                   [484.772644, 0.00501487544, 0.00503815711],
                   [491.530151, 0.00494674686, 0.00491306465],
                   [498.381775, 0.00487851631, 0.00479107723],
                   [505.328979, 0.00481069228, 0.00467211008],
                   [512.372986, 0.00474330178, 0.00455556717],
                   [519.515198, 0.00467598205, 0.00444104755],
                   [526.756958, 0.00460840529, 0.00432908861],
                   [534.09967, 0.00454095704, 0.0042199404],
                   [541.544739, 0.00447393628, 0.00411354611],
                   [549.093506, 0.00440752506, 0.00400983728],
                   [556.74762, 0.00434192177, 0.00390874268],
                   [564.508362, 0.00427762931, 0.00380999455],
                   [572.377319, 0.00421443768, 0.00371294934],
                   [580.355957, 0.00415127911, 0.00361704151],
                   [588.445801, 0.00408831937, 0.00352361961],
                   [596.648438, 0.00402602972, 0.00343260146],
                   [604.965332, 0.00396460807, 0.00334393699],
                   [613.398315, 0.00390424766, 0.00325756101],
                   [621.948669, 0.00384515733, 0.00317341788],
                   [630.618347, 0.00378763722, 0.00309144845],
                   [639.408813, 0.00373229594, 0.00301159685],
                   [648.321838, 0.00368036027, 0.00293372548],
                   [657.35907, 0.00363315828, 0.00285047665],
                   [666.522278, 0.00358227128, 0.00276421523],
                   [675.813293, 0.00352770253, 0.00267966324],
                   [685.233704, 0.0034712858, 0.00259769592],
                   [694.785522, 0.0034142402, 0.00251823245],
                   [704.470398, 0.0033568982, 0.00244120671],
                   [714.290344, 0.00329948589, 0.0023665342],
                   [724.247192, 0.00324182864, 0.00229414785],
                   [734.342834, 0.00318471412, 0.00222469121],
                   [744.579163, 0.0031284634, 0.00215743878],
                   [754.958191, 0.00307308487, 0.00209222827],
                   [765.481934, 0.00301861507, 0.00202898821],
                   [776.152344, 0.00296512363, 0.00196765829],
                   [786.971436, 0.00291287503, 0.00190818275],
                   [797.941406, 0.00286350236, 0.00185049267],
                   [809.06427, 0.00281420513, 0.00179079419],
                   [820.342224, 0.00276424619, 0.00173280074],
                   [831.777283, 0.00271441415, 0.00167668692],
                   [843.371826, 0.00266518863, 0.0016223914],
                   [855.127991, 0.00261677871, 0.00156985514],
                   [867.047974, 0.00256980187, 0.00151898235],
                   [879.134155, 0.00252664229, 0.00146955124],
                   [891.388855, 0.00248257606, 0.00141564745],
                   [903.814331, 0.00243653334, 0.00136365532],
                   [916.413025, 0.00238999375, 0.00131357287],
                   [929.187317, 0.00234360201, 0.00126532966],
                   [942.139648, 0.0022977856, 0.00121885841],
                   [955.272583, 0.00225283927, 0.00117377366],
                   [968.588562, 0.00220859307, 0.0011290462],
                   [982.09021, 0.00216411171, 0.00108524761],
                   [995.779968, 0.00211967179, 0.00104314892],
                   [1009.66058, 0.00207577483, 0.00100267911],
                   [1023.7348, 0.00203363854, 0.000963781495],
                   [1038.005, 0.00199303823, 0.000924860942],
                   [1052.47424, 0.00195244618, 0.000884819427],
                   [1067.14514, 0.00191027159, 0.000845069881],
                   [1082.02051, 0.00186723901, 0.000807101431],
                   [1097.10339, 0.00182401447, 0.000770840212],
                   [1112.39636, 0.00178094406, 0.000736206537],
                   [1127.90259, 0.00173816306, 0.000703129277],
                   [1143.62488, 0.00169576507, 0.000671535032],
                   [1159.56641, 0.00165381178, 0.000641352788],
                   [1175.73022, 0.00161234126, 0.000612521952],
                   [1192.11926, 0.00157136249, 0.000584987341],
                   [1208.73682, 0.00153067696, 0.000558692031],
                   [1225.58594, 0.00149012322, 0.000533909013],
                   [1242.66992, 0.00145062117, 0.000511187536],
                   [1259.99194, 0.00141245197, 0.000489894184],
                   [1277.55554, 0.00137553154, 0.00046948815],
                   [1295.36401, 0.00133975793, 0.000449930201],
                   [1313.42078, 0.00130527106, 0.000431171968],
                   [1331.72913, 0.00127147289, 0.000412043621],
                   [1350.29272, 0.00123800628, 0.000393583468],
                   [1369.11511, 0.00120494736, 0.000375923526],
                   [1388.19983, 0.0011724279, 0.000359056547],
                   [1407.55054, 0.0011403414, 0.0003429465],
                   [1427.17102, 0.00110866304, 0.00032777508],
                   [1447.06506, 0.00107791089, 0.000314022414],
                   [1467.23621, 0.00104861567, 0.000300961867],
                   [1487.68884, 0.00102122454, 0.00028841052],
                   [1508.42639, 0.00099408708, 0.000274052145],
                   [1529.453, 0.000966451073, 0.000259600638],
                   [1550.77271, 0.0009381891, 0.000246109441],
                   [1572.38977, 0.000909807102, 0.000233984785],
                   [1594.30786, 0.000882222608, 0.000223469149],
                   [1616.53174, 0.000855906866, 0.000213524661],
                   [1639.06531, 0.000830591307, 0.000203938136],
                   [1661.91296, 0.00080544065, 0.000194046908],
                   [1685.0791, 0.000780332251, 0.000184760502],
                   [1708.56824, 0.000755786663, 0.00017641345],
                   [1732.38477, 0.000731986947, 0.000168592887],
                   [1756.53333, 0.000708520762, 0.000160838827],
                   [1781.01831, 0.000685224426, 0.000154182751],
                   [1805.84485, 0.000663393934, 0.000148304898],
                   [1831.01721, 0.000641870429, 0.000141600889],
                   [1856.54065, 0.000620299485, 0.000135309107],
                   [1882.41992, 0.00059929362, 0.00012975678],
                   [1908.65979, 0.00057907094, 0.000124406724],
                   [1935.2655, 0.000559124397, 0.000118640208],
                   [1962.24194, 0.000538711087, 0.000112786089],
                   [1989.59473, 0.000518058601, 0.000107714601],
                   [2017.32861, 0.000497654604, 0.000103007813],
                   [2045.44897, 0.000477144145, 9.83261634E-05],
                   [2073.96143, 0.000456168404, 9.37005825E-05],
                   [2102.87134, 0.000434328482, 8.91867312E-05],
                   [2132.18433, 0.000411080488, 8.4838568E-05],
                   [2161.90576, 0.000385541556, 8.07193428E-05],
                   [2192.0415, 0.00035512005, 7.66349185E-05],
                   [2222.59741, 0.000304328278, 8.77657294E-05],
                   [2253.57935, 0.000284653419, 0.000132101253],
                   [2284.99292, 0.00027678872, 0.000162094628],
                   [2316.84448, 0.000274261314, 0.000180490621],
                   [2349.13989, 0.000282311725, 0.0002117923],
                   [2381.8855, 0.000302988075, 0.000215160588],
                   [2415.08789, 0.000315953628, 0.000211770879],
                   [2448.75293, 0.000319738203, 0.000204800686],
                   [2482.88721, 0.000321180938, 0.000198571273],
                   [2517.49707, 0.000321295549, 0.000192112595],
                   [2552.58984, 0.000319914892, 0.000184955046],
                   [2588.17163, 0.000316436286, 0.000177570822],
                   [2624.24927, 0.000311077951, 0.000171155654],
                   [2660.82983, 0.000306326197, 0.000166974642],
                   [2697.92041, 0.00029622906, 0.00016041621],
                   [2735.52783, 0.000288173731, 0.000164850047],
                   [2773.65967, 0.000287770585, 0.000166646147],
                   [2812.323, 0.000289621705, 0.000162986296],
                   [2851.52539, 0.000289405085, 0.000156758688],
                   [2891.27393, 0.000286930182, 0.000150997337],
                   [2931.57666, 0.00028419515, 0.000145106285],
                   [2972.44141, 0.000280389766, 0.000138730917],
                   [3013.87549, 0.000275848113, 0.000132811518],
                   [3055.88745, 0.000270997814, 0.000127259569],
                   [3098.48486, 0.000265349547, 0.000121834579],
                   [3141.67603, 0.00025944112, 0.000117789423],
                   [3185.46924, 0.000254448067, 0.000115431911],
                   [3229.8728, 0.000251068472, 0.000112598871],
                   [3274.89575, 0.000247620803, 0.000107656],
                   [3320.54614, 0.000243323477, 0.000103038183],
                   [3366.83252, 0.000238371664, 9.85808074E-05],
                   [3413.7644, 0.000233227038, 9.49850146E-05],
                   [3461.35059, 0.000228896577, 9.19403246E-05],
                   [3509.59961, 0.000225408527, 8.84907204E-05],
                   [3558.52148, 0.00022161896, 8.40877983E-05],
                   [3608.12549, 0.000216917717, 8.01675487E-05],
                   [3658.4209, 0.000212276878, 7.65144359E-05],
                   [3709.41724, 0.000207665405, 7.30517495E-05],
                   [3761.12451, 0.000203113887, 6.97747091E-05],
                   [3813.55249, 0.000198618596, 6.65971093E-05],
                   [3866.71143, 0.000194151275, 6.35092438E-05],
                   [3920.61133, 0.00018969395, 6.05629721E-05],
                   [3975.26221, 0.00018527887, 5.77637365E-05],
                   [4030.67554, 0.000180941977, 5.50962977E-05],
                   [4086.86084, 0.000176640795, 5.24910574E-05],
                   [4143.82959, 0.000172471337, 5.00457463E-05],
                   [4201.59229, 0.000168194441, 4.75209708E-05],
                   [4260.16016, 0.000163842604, 4.5243145E-05],
                   [4319.54443, 0.000159654592, 4.33770292E-05],
                   [4379.75635, 0.000155779257, 4.13362613E-05],
                   [4440.80811, 0.000151880056, 3.94581184E-05],
                   [4502.71045, 0.000148073246, 3.76098833E-05],
                   [4565.47559, 0.000144323698, 3.58553734E-05],
                   [4629.11572, 0.000140643446, 3.41770647E-05],
                   [4693.64355, 0.000137033261, 3.25731889E-05],
                   [4759.07031, 0.000133489099, 3.10472351E-05],
                   [4825.40918, 0.000130013024, 2.9598139E-05],
                   [4892.67285, 0.000126616898, 2.82368637E-05],
                   [4960.87402, 0.000123285892, 2.69292977E-05],
                   [5030.02588, 0.000120038007, 2.5723155E-05],
                   [5100.14209, 0.00011690383, 2.45648134E-05],
                   [5171.23486, 0.000113827526, 2.34215622E-05],
                   [5243.31885, 0.000110821653, 2.23736897E-05],
                   [5316.4082, 0.000107960426, 2.14585252E-05],
                   [5390.51611, 0.00010521974, 2.03656655E-05],
                   [5465.65723, 0.000102400511, 1.93965661E-05],
                   [5541.84521, 9.96691961E-05, 1.84744094E-05],
                   [5619.09521, 9.70041947E-05, 1.76009289E-05],
                   [5697.42285, 9.43996492E-05, 1.67736725E-05],
                   [5776.8418, 9.18723599E-05, 1.59986685E-05],
                   [5857.36768, 8.94320838E-05, 1.52547082E-05],
                   [5939.01611, 8.70488147E-05, 1.44794676E-05],
                   [6021.80273, 8.46967087E-05, 1.3836674E-05],
                   [6105.74316, 8.2425875E-05, 1.31666584E-05],
                   [6190.85449, 8.01967471E-05, 1.25245906E-05],
                   [6277.15186, 7.80176342E-05, 1.19159604E-05],
                   [6364.65137, 7.58937094E-05, 1.13378983E-05],
                   [6453.37158, 7.38237723E-05, 1.07874039E-05],
                   [6543.32812, 7.18057781E-05, 1.02630947E-05],
                   [6634.53809, 6.98385556E-05, 9.76390402E-06],
                   [6727.02051, 6.79209988E-05, 9.2884984E-06],
                   [6820.7915, 6.60525329E-05, 8.83600478E-06],
                   [6915.86914, 6.42322047E-05, 8.40526263E-06],
                   [7012.27295, 6.24589011E-05, 7.99521149E-06],
                   [7110.02002, 6.0731556E-05, 7.60486455E-06],
                   [7209.12988, 5.90491145E-05, 7.23327912E-06],
                   [7309.62109, 5.74103797E-05, 6.87977217E-06],
                   [7411.51318, 5.58141219E-05, 6.54349424E-06],
                   [7514.82617, 5.42599118E-05, 6.22345487E-06],
                   [7619.57861, 5.27465709E-05, 5.91882872E-06],
                   [7725.79102, 5.12729966E-05, 5.62901778E-06],
                   [7833.48438, 4.98382287E-05, 5.35337404E-06],
                   [7942.67969, 4.84414268E-05, 5.09120491E-06],
                   [8053.396, 4.70816522E-05, 4.84185102E-06],
                   [8165.65625, 4.57575989E-05, 4.60465753E-06],
                   [8279.48047, 4.44685356E-05, 4.37901645E-06],
                   [8394.89258, 4.32135785E-05, 4.16436887E-06],
                   [8511.91211, 4.19918106E-05, 3.96022233E-06],
                   [8630.56348, 4.08023225E-05, 3.76610456E-06],
                   [8750.86914, 3.96442374E-05, 3.58154625E-06],
                   [8872.85156, 3.8516675E-05, 3.40608403E-06],
                   [8996.53418, 3.7418642E-05, 3.23929657E-06],
                   [9121.94141, 3.63491017E-05, 3.08068752E-06],
                   [9249.0957, 3.53075047E-05, 2.92987102E-06],
                   [9378.02344, 3.42929015E-05, 2.78646075E-06],
                   [9508.74805, 3.33043754E-05, 2.65008657E-06],
                   [9641.29492, 3.23410495E-05, 2.52041991E-06],
                   [9775.68848, 3.14020544E-05, 2.39715382E-06],
                   [9911.95703, 3.04863024E-05, 2.27996406E-06],
                   [10050.125, 2.95921345E-05, 2.1686044E-06],
                   [10190.2178, 2.87191324E-05, 2.06276309E-06],
                   [10332.2637, 2.78660864E-05, 1.96214182E-06],
                   [10476.29, 2.70316359E-05, 1.86649299E-06],
                   [10622.3232, 2.62142294E-05, 1.77557763E-06],
                   [10770.3926, 2.54120114E-05, 1.68915096E-06],
                   [10920.5264, 2.462269E-05, 1.6070004E-06],
                   [11072.7529, 2.38396115E-05, 1.52892721E-06],
                   [11227.1006, 2.30578098E-05, 1.4547054E-06],
                   [11383.6006, 2.22663057E-05, 1.38415396E-06],
                   [11542.2822, 2.14397242E-05, 1.31709339E-06],
                   [11703.1748, 2.04854259E-05, 1.25335453E-06],
                   [11866.3105, 1.7929231E-05, 1.19275307E-06],
                   [12031.7207, 1.91125182E-05, 2.82612041E-06],
                   [12199.4365, 1.90790906E-05, 2.68429517E-06],
                   [12369.4902, 1.87949627E-05, 2.54955216E-06],
                   [12541.9141, 1.84239525E-05, 2.42158762E-06],
                   [12716.7412, 1.80098777E-05, 2.30005003E-06],
                   [12894.0059, 1.75698424E-05, 2.18462287E-06],
                   [13073.7412, 1.71102602E-05, 2.0749892E-06],
                   [13255.9824, 1.6630358E-05, 1.97084046E-06],
                   [13440.7637, 1.61163425E-05, 1.87194019E-06],
                   [13628.1211, 1.5447029E-05, 1.77798802E-06],
                   [13818.0889, 1.44683399E-05, 2.35606217E-06],
                   [14010.7061, 1.48751942E-05, 2.23948064E-06],
                   [14206.0068, 1.44834885E-05, 2.1286653E-06],
                   [14404.0312, 1.37876641E-05, 2.32722232E-06],
                   [14604.8164, 1.40040975E-05, 2.21812297E-06],
                   [14808.3994, 1.37464795E-05, 2.11415386E-06],
                   [15014.8203, 1.34591846E-05, 2.01477314E-06],
                   [15224.1182, 1.31634242E-05, 1.91983827E-06],
                   [15436.335, 1.28640968E-05, 1.82917256E-06],
                   [15651.5098, 1.25641982E-05, 1.74259492E-06],
                   [15869.6816, 1.22656129E-05, 1.65993981E-06],
                   [16090.8965, 1.19695715E-05, 1.58105388E-06],
                   [16315.1953, 1.16769697E-05, 1.50576795E-06],
                   [16542.6191, 1.13880951E-05, 1.43390128E-06],
                   [16773.2148, 1.11037198E-05, 1.36533504E-06],
                   [17007.0254, 1.08242912E-05, 1.29992418E-06],
                   [17244.0938, 1.0550003E-05, 1.23753762E-06],
                   [17484.4668, 1.0281E-05, 1.17805041E-06],
                   [17728.1914, 1.00173947E-05, 1.12133057E-06],
                   [17975.3125, 9.75925104E-06, 1.06724758E-06],
                   [18225.8789, 9.50651884E-06, 1.01569401E-06],
                   [18479.9375, 9.25921177E-06, 9.66546622E-07],
                   [18737.5371, 9.01743533E-06, 9.19706963E-07],
                   [18998.7285, 8.78115588E-06, 8.75077035E-07],
                   [19263.5605, 8.55033068E-06, 8.32554178E-07],
                   [19532.084, 8.3249015E-06, 7.92044773E-07],
                   [19804.3516, 8.10480287E-06, 7.53460426E-07],
                   [20080.4141, 7.88996203E-06, 7.1670388E-07],
                   [20360.3223, 7.68024165E-06, 6.81694075E-07],
                   [20644.1348, 7.47564627E-06, 6.48351659E-07],
                   [20931.9023, 7.27609267E-06, 6.16605632E-07],
                   [21223.6816, 7.08149082E-06, 5.86383294E-07],
                   [21519.5293, 6.89175022E-06, 5.57611429E-07],
                   [21819.5, 6.70677809E-06, 5.30223588E-07],
                   [22123.6523, 6.52648259E-06, 5.04154116E-07],
                   [22432.0449, 6.35073047E-06, 4.79338439E-07],
                   [22744.7324, 6.17946671E-06, 4.55721789E-07],
                   [23061.7832, 6.01259899E-06, 4.33249824E-07],
                   [23383.252, 5.85004E-06, 4.11867376E-07],
                   [23709.2012, 5.69169288E-06, 3.91522946E-07],
                   [24039.6953, 5.53745667E-06, 3.72168103E-07],
                   [24374.7949, 5.38724771E-06, 3.5375524E-07],
                   [24714.5664, 5.2409564E-06, 3.36239481E-07],
                   [25059.0742, 5.09849087E-06, 3.195793E-07],
                   [25408.3848, 4.95978065E-06, 3.03732264E-07],
                   [25762.5645, 4.82473661E-06, 2.88660743E-07],
                   [26121.6797, 4.69327006E-06, 2.74327931E-07],
                   [26485.8008, 4.56529369E-06, 2.60697846E-07],
                   [26855., 4.44071657E-06, 2.47738768E-07],
                   [27229.3438, 4.31945546E-06, 2.35416152E-07],
                   [27608.9062, 4.20143078E-06, 2.23699431E-07],
                   [27993.7598, 4.08656342E-06, 2.12559627E-07],
                   [28383.9766, 3.97478198E-06, 2.0196974E-07],
                   [28779.6348, 3.86601778E-06, 1.91902828E-07],
                   [29180.8066, 3.76032222E-06, 1.8233338E-07],
                   [29587.5723, 3.65740061E-06, 1.73237069E-07],
                   [30000.0059, 3.55550719E-06, 1.64591498E-07]]),
'Ir' : numpy.array([[30., 0.382560968, 0.510462046],
                   [30.4181843, 0.382750332, 0.490292817],
                   [30.8421955, 0.381290048, 0.470920324],
                   [31.2721214, 0.379120499, 0.452312291],
                   [31.7080383, 0.376925349, 0.434441537],
                   [32.150032, 0.375724018, 0.415502936],
                   [32.5981827, 0.372667342, 0.393861353],
                   [33.0525818, 0.3665663, 0.372298717],
                   [33.5133171, 0.357777506, 0.351916134],
                   [33.9804764, 0.346969247, 0.333494574],
                   [34.4541473, 0.334692717, 0.318296671],
                   [34.9344177, 0.323916674, 0.304725826],
                   [35.4213829, 0.313165724, 0.291733176],
                   [35.9151382, 0.301930398, 0.279294193],
                   [36.4157791, 0.289861679, 0.268692076],
                   [36.9233932, 0.278274477, 0.259898156],
                   [37.4380875, 0.267920673, 0.25211969],
                   [37.9599533, 0.258289635, 0.24457407],
                   [38.4890938, 0.248987883, 0.237253889],
                   [39.0256119, 0.239589691, 0.230153188],
                   [39.5696068, 0.229955137, 0.223434657],
                   [40.1211853, 0.22053729, 0.218160704],
                   [40.6804543, 0.211778849, 0.213563561],
                   [41.2475166, 0.203661174, 0.209063441],
                   [41.8224831, 0.195871159, 0.204658031],
                   [42.405468, 0.188262433, 0.200345516],
                   [42.9965744, 0.180541009, 0.196123883],
                   [43.5959282, 0.172595605, 0.192440212],
                   [44.2036324, 0.16497086, 0.189108029],
                   [44.8198051, 0.157440081, 0.185916394],
                   [45.4445686, 0.149644941, 0.182778478],
                   [46.0780411, 0.141252339, 0.17985028],
                   [46.7203445, 0.131770685, 0.177460566],
                   [47.3715973, 0.119064771, 0.17542316],
                   [48.0319328, 0.101259857, 0.18233107],
                   [48.7014732, 0.0937416628, 0.196830064],
                   [49.3803444, 0.0967554376, 0.215103939],
                   [50.0686798, 0.106974699, 0.223752931],
                   [50.7666092, 0.117786579, 0.219126746],
                   [51.4742699, 0.122661784, 0.214596227],
                   [52.1917915, 0.125372499, 0.210160419],
                   [52.9193192, 0.126870394, 0.205815613],
                   [53.6569862, 0.127688512, 0.20156014],
                   [54.4049339, 0.127996936, 0.197393194],
                   [55.163311, 0.127900422, 0.193312213],
                   [55.9322586, 0.127458349, 0.189314991],
                   [56.7119217, 0.126692161, 0.185400382],
                   [57.5024567, 0.12558192, 0.181567967],
                   [58.3040123, 0.123890027, 0.177814037],
                   [59.1167336, 0.12111818, 0.174802601],
                   [59.9407921, 0.118741453, 0.173566192],
                   [60.7763329, 0.117135741, 0.173008338],
                   [61.6235237, 0.116037883, 0.172622234],
                   [62.4825172, 0.115406178, 0.172873974],
                   [63.3534927, 0.116084509, 0.174368411],
                   [64.2366028, 0.118819058, 0.175876856],
                   [65.1320343, 0.124322928, 0.175379485],
                   [66.0399323, 0.129360929, 0.173348844],
                   [66.960495, 0.135074094, 0.170606419],
                   [67.8938904, 0.140986279, 0.165474132],
                   [68.8402939, 0.145844921, 0.157734275],
                   [69.7998886, 0.149296522, 0.150164276],
                   [70.7728577, 0.152850837, 0.141594574],
                   [71.7593994, 0.153600723, 0.131851643],
                   [72.7596817, 0.152858958, 0.122712426],
                   [73.7739182, 0.151138082, 0.114206612],
                   [74.8022842, 0.148742929, 0.106392302],
                   [75.844986, 0.145890653, 0.0992223099],
                   [76.9022217, 0.14273943, 0.092549935],
                   [77.9741974, 0.139319792, 0.0863260403],
                   [79.0611115, 0.135596335, 0.0805203095],
                   [80.1631851, 0.13161467, 0.0751055628],
                   [81.2806168, 0.127234384, 0.0701379031],
                   [82.4136276, 0.122814655, 0.0661047772],
                   [83.5624237, 0.118677497, 0.0627902821],
                   [84.7272415, 0.114894234, 0.0596419685],
                   [85.9082947, 0.111310229, 0.0566515662],
                   [87.1058121, 0.107837372, 0.053811077],
                   [88.320015, 0.104443975, 0.0511129759],
                   [89.5511475, 0.101099603, 0.0485501103],
                   [90.7994385, 0.0977524668, 0.0461158417],
                   [92.0651398, 0.0944425687, 0.0439386815],
                   [93.3484802, 0.0912626758, 0.042052608],
                   [94.649704, 0.0882748365, 0.0402622335],
                   [95.9690704, 0.0854120702, 0.0385480598],
                   [97.3068314, 0.0826460049, 0.036906831],
                   [98.6632385, 0.079962723, 0.0353354961],
                   [100.038544, 0.077354975, 0.0338310711],
                   [101.433029, 0.0748210773, 0.0323877521],
                   [102.846954, 0.0723493174, 0.0309909545],
                   [104.280579, 0.0699169561, 0.0296282824],
                   [105.734192, 0.06751322, 0.0283253342],
                   [107.208076, 0.0651270449, 0.0270798225],
                   [108.702492, 0.0627477542, 0.0258890297],
                   [110.217751, 0.06032186, 0.024817083],
                   [111.754128, 0.0579578504, 0.0238846596],
                   [113.311913, 0.0557114147, 0.0230465867],
                   [114.891418, 0.0535378605, 0.0222379137],
                   [116.492943, 0.0513820127, 0.0214610212],
                   [118.116798, 0.0490898527, 0.0208237302],
                   [119.763275, 0.0469982438, 0.0204020403],
                   [121.432716, 0.04506227, 0.0200180486],
                   [123.125427, 0.0432211272, 0.0196412876],
                   [124.841721, 0.0414179638, 0.0192716122],
                   [126.581955, 0.0396303236, 0.0189522915],
                   [128.346436, 0.037893828, 0.0187846497],
                   [130.135513, 0.0363188237, 0.0186778046],
                   [131.949539, 0.0348493159, 0.0185714737],
                   [133.788834, 0.0334570557, 0.0184659138],
                   [135.653778, 0.0321289711, 0.0183609519],
                   [137.544724, 0.0308521856, 0.0182565842],
                   [139.462021, 0.0296051782, 0.0181628596],
                   [141.406052, 0.0283748601, 0.018105628],
                   [143.377167, 0.0272418112, 0.0181231815],
                   [145.375778, 0.0261932202, 0.0181409195],
                   [147.402222, 0.0252082031, 0.0181586165],
                   [149.45694, 0.0242803507, 0.0181763433],
                   [151.540268, 0.0234073363, 0.018193299],
                   [153.652664, 0.0225845147, 0.018206818],
                   [155.794495, 0.0218049269, 0.0182149597],
                   [157.966202, 0.0210659653, 0.0182232857],
                   [160.168167, 0.0203722883, 0.0182317197],
                   [162.400818, 0.0197206829, 0.0182400551],
                   [164.664597, 0.0191128068, 0.0182482675],
                   [166.95993, 0.0185729023, 0.0182500724],
                   [169.287262, 0.0180800203, 0.0182124097],
                   [171.647034, 0.0175886527, 0.0181176178],
                   [174.039703, 0.0170894675, 0.0180232991],
                   [176.465729, 0.0165994577, 0.0179296322],
                   [178.925552, 0.0161197502, 0.0178362355],
                   [181.419678, 0.0156447645, 0.0177433696],
                   [183.948563, 0.0151728299, 0.0176745877],
                   [186.512726, 0.0147241652, 0.0176351927],
                   [189.112595, 0.0143197253, 0.0176124796],
                   [191.748734, 0.0139609398, 0.0175884422],
                   [194.4216, 0.0136473412, 0.0175493862],
                   [197.131729, 0.0133422995, 0.0174819957],
                   [199.879639, 0.0130483387, 0.01741294],
                   [202.665863, 0.0127689736, 0.0173441563],
                   [205.490906, 0.0125064775, 0.017275624],
                   [208.355347, 0.0122621348, 0.0172074009],
                   [211.259705, 0.0120368833, 0.0171395633],
                   [214.204544, 0.0118322773, 0.0170717873],
                   [217.190445, 0.011665835, 0.0170044713],
                   [220.217957, 0.0115283858, 0.0169102699],
                   [223.287674, 0.01139249, 0.0167907067],
                   [226.400192, 0.01125581, 0.0166620128],
                   [229.556091, 0.0111241564, 0.0165343452],
                   [232.755981, 0.0110025592, 0.0164076537],
                   [236.000458, 0.0108945193, 0.0162818972],
                   [239.290176, 0.0108075701, 0.0161572099],
                   [242.625763, 0.0107466131, 0.0160333812],
                   [246.007828, 0.0107569434, 0.0158781987],
                   [249.437057, 0.0107690739, 0.0156499315],
                   [252.914062, 0.0107366331, 0.0153759867],
                   [256.439545, 0.0106628677, 0.0151068484],
                   [260.01416, 0.0105769811, 0.0148424571],
                   [263.638641, 0.0104823206, 0.01458262],
                   [267.313599, 0.0103826942, 0.0143273249],
                   [271.039825, 0.0102831274, 0.0140751852],
                   [274.817963, 0.010181047, 0.0138233416],
                   [278.648773, 0.0100753913, 0.013573519],
                   [282.53299, 0.00996799953, 0.0133281723],
                   [286.471375, 0.00986275263, 0.0130860694],
                   [290.4646, 0.00976337958, 0.0128399935],
                   [294.513519, 0.00965594407, 0.0125856586],
                   [298.618896, 0.00953903608, 0.0123358592],
                   [302.781494, 0.00941686705, 0.0120910387],
                   [307.002106, 0.00929041766, 0.0118510742],
                   [311.281525, 0.00915712025, 0.0116158593],
                   [315.620605, 0.00901611615, 0.011389968],
                   [320.020203, 0.00887788087, 0.0111911781],
                   [324.48111, 0.00875185989, 0.0109988088],
                   [329.004181, 0.00863394421, 0.0108097745],
                   [333.590363, 0.00852184184, 0.0106239785],
                   [338.240417, 0.00841491576, 0.0104413806],
                   [342.955322, 0.0083131846, 0.0102619063],
                   [347.735901, 0.00821710285, 0.010085511],
                   [352.58316, 0.00812787842, 0.00991214812],
                   [357.497986, 0.00805322547, 0.00974179711],
                   [362.481323, 0.00798339397, 0.00955115352],
                   [367.534119, 0.00790747162, 0.00935510825],
                   [372.657349, 0.00782479066, 0.00916082039],
                   [377.85199, 0.0077383928, 0.00897055399],
                   [383.119019, 0.0076512401, 0.00878423639],
                   [388.459473, 0.00756413257, 0.00860180706],
                   [393.87439, 0.00747790281, 0.00842315797],
                   [399.364807, 0.00739345793, 0.0082481876],
                   [404.931732, 0.00731134461, 0.00807688665],
                   [410.576233, 0.00723261293, 0.00790914707],
                   [416.299469, 0.00715993857, 0.00774487481],
                   [422.102448, 0.00709540863, 0.00757851033],
                   [427.986359, 0.00703656161, 0.0074007581],
                   [433.95224, 0.00696994038, 0.00721171731],
                   [440.001282, 0.00688958354, 0.00702750031],
                   [446.134674, 0.00680606347, 0.00684798229],
                   [452.353577, 0.00672027422, 0.00667304732],
                   [458.659119, 0.00663290778, 0.00650257524],
                   [465.052582, 0.00654456392, 0.00633646129],
                   [471.535156, 0.0064557218, 0.00617460208],
                   [478.108093, 0.00636671996, 0.00601687143],
                   [484.772644, 0.00627796166, 0.00586316735],
                   [491.530151, 0.00618969975, 0.00571338367],
                   [498.381775, 0.00610219734, 0.00556743843],
                   [505.328979, 0.00601569004, 0.00542521803],
                   [512.372986, 0.00593041163, 0.00528663537],
                   [519.515198, 0.00584663311, 0.00515159499],
                   [526.756958, 0.00576467859, 0.00501999119],
                   [534.09967, 0.00568517949, 0.00489175832],
                   [541.544739, 0.00560887204, 0.00476679765],
                   [549.093506, 0.00553966314, 0.00464502722],
                   [556.74762, 0.00547804637, 0.0045218193],
                   [564.508362, 0.00541811856, 0.00438735588],
                   [572.377319, 0.00535199372, 0.00424273452],
                   [580.355957, 0.00527556613, 0.00410287874],
                   [588.445801, 0.00519482745, 0.00396762323],
                   [596.648438, 0.00511131901, 0.00383683504],
                   [604.965332, 0.00502635026, 0.00371035328],
                   [613.398315, 0.00494045345, 0.00358804478],
                   [621.948669, 0.00485402066, 0.0034697724],
                   [630.618347, 0.00476736436, 0.00335539319],
                   [639.408813, 0.0046807481, 0.00324478699],
                   [648.321838, 0.00459436188, 0.00313782343],
                   [657.35907, 0.00450825552, 0.00303439214],
                   [666.522278, 0.00442274008, 0.00293436553],
                   [675.813293, 0.00433791569, 0.00283763348],
                   [685.233704, 0.0042538913, 0.00274408958],
                   [694.785522, 0.00417075958, 0.00265363045],
                   [704.470398, 0.00408859365, 0.002566159],
                   [714.290344, 0.00400745543, 0.00248157023],
                   [724.247192, 0.00392738543, 0.0023997617],
                   [734.342834, 0.00384847098, 0.00232065795],
                   [744.579163, 0.00377078471, 0.00224415795],
                   [754.958191, 0.00369437155, 0.0021701802],
                   [765.481934, 0.00361928414, 0.00209864276],
                   [776.152344, 0.00354557927, 0.00202946388],
                   [786.971436, 0.00347331725, 0.00196256302],
                   [797.941406, 0.00340258097, 0.00189787091],
                   [809.06427, 0.00333354669, 0.00183530827],
                   [820.342224, 0.00326633896, 0.00177480618],
                   [831.777283, 0.0032011976, 0.00171630178],
                   [843.371826, 0.00313829631, 0.00165972637],
                   [855.127991, 0.00308167143, 0.00160501502],
                   [867.047974, 0.00303564896, 0.00154558453],
                   [879.134155, 0.0029901918, 0.00145268941],
                   [891.388855, 0.00290479884, 0.00139768724],
                   [903.814331, 0.00283274311, 0.00134509965],
                   [916.413025, 0.00276621012, 0.00129447761],
                   [929.187317, 0.00270221801, 0.00124508515],
                   [942.139648, 0.0026397123, 0.00119684311],
                   [955.272583, 0.00257808878, 0.00115020503],
                   [968.588562, 0.00251742289, 0.00110516045],
                   [982.09021, 0.00245771185, 0.00106186245],
                   [995.779968, 0.00239913841, 0.00102015806],
                   [1009.66058, 0.00234178989, 0.000979989883],
                   [1023.7348, 0.00228554383, 0.00094082352],
                   [1038.005, 0.00223009894, 0.000902754313],
                   [1052.47424, 0.00217527756, 0.000866115326],
                   [1067.14514, 0.00212126481, 0.000830861158],
                   [1082.02051, 0.00206806557, 0.000797027315],
                   [1097.10339, 0.00201575132, 0.000764556637],
                   [1112.39636, 0.00196438166, 0.000733397785],
                   [1127.90259, 0.00191397313, 0.000703505182],
                   [1143.62488, 0.00186453864, 0.000674827257],
                   [1159.56641, 0.00181607902, 0.000647308247],
                   [1175.73022, 0.00176858634, 0.000620896812],
                   [1192.11926, 0.00172205351, 0.0005955589],
                   [1208.73682, 0.00167645793, 0.000571245269],
                   [1225.58594, 0.00163185026, 0.00054791139],
                   [1242.66992, 0.0015882171, 0.000525451149],
                   [1259.99194, 0.00154552213, 0.000503810588],
                   [1277.55554, 0.00150368956, 0.000482948381],
                   [1295.36401, 0.00146263966, 0.000462846743],
                   [1313.42078, 0.00142237032, 0.000443567726],
                   [1331.72913, 0.00138285419, 0.000425088569],
                   [1350.29272, 0.00134414178, 0.000407374027],
                   [1369.11511, 0.00130622811, 0.000390390021],
                   [1388.19983, 0.00126909895, 0.000374109019],
                   [1407.55054, 0.00123273884, 0.000358503865],
                   [1427.17102, 0.00119713414, 0.000343545777],
                   [1447.06506, 0.00116227451, 0.000329202448],
                   [1467.23621, 0.00112810754, 0.000315438112],
                   [1487.68884, 0.00109461253, 0.000302223052],
                   [1508.42639, 0.001061777, 0.000289487973],
                   [1529.453, 0.00102953403, 0.000277259329],
                   [1550.77271, 0.000997861731, 0.000265543],
                   [1572.38977, 0.000966754393, 0.00025431774],
                   [1594.30786, 0.000936188211, 0.000243555754],
                   [1616.53174, 0.000906096131, 0.000233246785],
                   [1639.06531, 0.000876405975, 0.000223372015],
                   [1661.91296, 0.000847136835, 0.000213916661],
                   [1685.0791, 0.000818248722, 0.000204858021],
                   [1708.56824, 0.000789688958, 0.000196175984],
                   [1732.38477, 0.000761389849, 0.000187823389],
                   [1756.53333, 0.000733255874, 0.000179749361],
                   [1781.01831, 0.00070512417, 0.00017199252],
                   [1805.84485, 0.000676645432, 0.000164541489],
                   [1831.01721, 0.000647807785, 0.000157407354],
                   [1856.54065, 0.000618353602, 0.00015058252],
                   [1882.41992, 0.000587910356, 0.000144055404],
                   [1908.65979, 0.000555906794, 0.000137810988],
                   [1935.2655, 0.000521421665, 0.000131834342],
                   [1962.24194, 0.000482917967, 0.000126115105],
                   [1989.59473, 0.000434508256, 0.00012064047],
                   [2017.32861, 0.000354747172, 0.000115449933],
                   [2045.44897, 8.6445747E-05, 0.000315354118],
                   [2073.96143, 0.000332131924, 0.000301339984],
                   [2102.87134, 0.000244207185, 0.000287948584],
                   [2132.18433, 0.000346563407, 0.000405162806],
                   [2161.90576, 0.000410576176, 0.00038639683],
                   [2192.0415, 0.000434896763, 0.000368502835],
                   [2222.59741, 0.000447889121, 0.000351434952],
                   [2253.57935, 0.000454907189, 0.000335163466],
                   [2284.99292, 0.00045785238, 0.000319643412],
                   [2316.84448, 0.000457832473, 0.000304845045],
                   [2349.13989, 0.000455529895, 0.000290738943],
                   [2381.8855, 0.00045137704, 0.000277285755],
                   [2415.08789, 0.00044556908, 0.000264453032],
                   [2448.75293, 0.000437912648, 0.000252223545],
                   [2482.88721, 0.00042811234, 0.000240562207],
                   [2517.49707, 0.000412881374, 0.000229442085],
                   [2552.58984, 0.000349393638, 0.000254116167],
                   [2588.17163, 0.000404773396, 0.000242084439],
                   [2624.24927, 0.000406497391, 0.000230621823],
                   [2660.82983, 0.000403705839, 0.000219701411],
                   [2697.92041, 0.00039886203, 0.000209312202],
                   [2735.52783, 0.000392954593, 0.000199415939],
                   [2773.65967, 0.000386227592, 0.000189990562],
                   [2812.323, 0.000378736586, 0.000181014082],
                   [2851.52539, 0.000370166556, 0.000172465341],
                   [2891.27393, 0.000355028722, 0.000164323123],
                   [2931.57666, 0.000353656185, 0.000166530925],
                   [2972.44141, 0.000349745416, 0.000158801748],
                   [3013.87549, 0.00034392465, 0.000151436456],
                   [3055.88745, 0.000337345642, 0.000144417616],
                   [3098.48486, 0.00033020394, 0.000137725918],
                   [3141.67603, 0.000319687999, 0.000131344874],
                   [3185.46924, 0.000309460942, 0.000129890454],
                   [3229.8728, 0.000309932017, 0.000124037644],
                   [3274.89575, 0.000304112065, 0.000118437747],
                   [3320.54614, 0.000297949329, 0.000113076494],
                   [3366.83252, 0.000291682285, 0.000107946529],
                   [3413.7644, 0.000285377027, 0.000103037848],
                   [3461.35059, 0.000279074127, 9.83424106E-05],
                   [3509.59961, 0.00027279905, 9.38507656E-05],
                   [3558.52148, 0.000266568619, 8.9553163E-05],
                   [3608.12549, 0.000260397908, 8.54481477E-05],
                   [3658.4209, 0.00025428753, 8.15194435E-05],
                   [3709.41724, 0.000248255441, 7.77668829E-05],
                   [3761.12451, 0.000242307855, 7.41775511E-05],
                   [3813.55249, 0.000236449763, 7.07480649E-05],
                   [3866.71143, 0.000230685677, 6.74736148E-05],
                   [3920.61133, 0.000225019437, 6.43460589E-05],
                   [3975.26221, 0.000219453199, 6.13586089E-05],
                   [4030.67554, 0.000213980602, 5.85021044E-05],
                   [4086.86084, 0.000208612299, 5.57782587E-05],
                   [4143.82959, 0.000203349104, 5.31751793E-05],
                   [4201.59229, 0.000198189635, 5.06892102E-05],
                   [4260.16016, 0.000193133994, 4.83163749E-05],
                   [4319.54443, 0.00018818317, 4.60518022E-05],
                   [4379.75635, 0.000183337266, 4.38908392E-05],
                   [4440.80811, 0.000178593444, 4.18279124E-05],
                   [4502.71045, 0.000173951223, 3.98595002E-05],
                   [4565.47559, 0.000169412189, 3.79816156E-05],
                   [4629.11572, 0.000164975252, 3.6189911E-05],
                   [4693.64355, 0.000160639145, 3.44807049E-05],
                   [4759.07031, 0.000156402763, 3.2850654E-05],
                   [4825.40918, 0.000152264911, 3.1296091E-05],
                   [4892.67285, 0.000148223829, 2.981336E-05],
                   [4960.87402, 0.00014427671, 2.83990485E-05],
                   [5030.02588, 0.000140424352, 2.70507644E-05],
                   [5100.14209, 0.000136664778, 2.576529E-05],
                   [5171.23486, 0.000132996662, 2.45398151E-05],
                   [5243.31885, 0.000129418404, 2.33715728E-05],
                   [5316.4082, 0.000125928171, 2.22578674E-05],
                   [5390.51611, 0.000122524565, 2.11965307E-05],
                   [5465.65723, 0.000119204567, 2.0184887E-05],
                   [5541.84521, 0.000115967865, 1.92209282E-05],
                   [5619.09521, 0.000112812988, 1.83023039E-05],
                   [5697.42285, 0.000109738219, 1.74269098E-05],
                   [5776.8418, 0.000106741776, 1.65927959E-05],
                   [5857.36768, 0.000103821963, 1.57981449E-05],
                   [5939.01611, 0.000100977217, 1.50410406E-05],
                   [6021.80273, 9.82051206E-05, 1.43197276E-05],
                   [6105.74316, 9.55046635E-05, 1.36326744E-05],
                   [6190.85449, 9.28743248E-05, 1.29782493E-05],
                   [6277.15186, 9.03125547E-05, 1.23549517E-05],
                   [6364.65137, 8.7817818E-05, 1.17613845E-05],
                   [6453.37158, 8.53884994E-05, 1.11960708E-05],
                   [6543.32812, 8.30230347E-05, 1.06575908E-05],
                   [6634.53809, 8.07198012E-05, 1.01448513E-05],
                   [6727.02051, 7.84769218E-05, 9.65657E-06],
                   [6820.7915, 7.62934651E-05, 9.19161084E-06],
                   [6915.86914, 7.41678014E-05, 8.74876696E-06],
                   [7012.27295, 7.2098519E-05, 8.32710339E-06],
                   [7110.02002, 7.00842502E-05, 7.925717E-06],
                   [7209.12988, 6.81235324E-05, 7.54359826E-06],
                   [7309.62109, 6.62150633E-05, 7.1798836E-06],
                   [7411.51318, 6.43569874E-05, 6.83350027E-06],
                   [7514.82617, 6.25484608E-05, 6.50377069E-06],
                   [7619.57861, 6.07881484E-05, 6.18995409E-06],
                   [7725.79102, 5.90748132E-05, 5.89118372E-06],
                   [7833.48438, 5.74071382E-05, 5.60670787E-06],
                   [7942.67969, 5.57838503E-05, 5.33593584E-06],
                   [8053.396, 5.42037487E-05, 5.07824825E-06],
                   [8165.65625, 5.26651056E-05, 4.83289432E-06],
                   [8279.48047, 5.11671169E-05, 4.59942703E-06],
                   [8394.89258, 4.97085748E-05, 4.37719655E-06],
                   [8511.91211, 4.82884825E-05, 4.16573084E-06],
                   [8630.56348, 4.69056176E-05, 3.96444875E-06],
                   [8750.86914, 4.55587178E-05, 3.77282413E-06],
                   [8872.85156, 4.42467172E-05, 3.59051955E-06],
                   [8996.53418, 4.29679785E-05, 3.41693658E-06],
                   [9121.94141, 4.17212286E-05, 3.25179985E-06],
                   [9249.0957, 4.05055107E-05, 3.09460665E-06],
                   [9378.02344, 3.93195987E-05, 2.94503639E-06],
                   [9508.74805, 3.81621503E-05, 2.80268728E-06],
                   [9641.29492, 3.70316811E-05, 2.66722031E-06],
                   [9775.68848, 3.59267033E-05, 2.53836606E-06],
                   [9911.95703, 3.48455906E-05, 2.41572343E-06],
                   [10050.125, 3.3783148E-05, 2.2977199E-06],
                   [10190.2178, 3.27374837E-05, 2.18555579E-06],
                   [10332.2637, 3.17047234E-05, 2.07894914E-06],
                   [10476.29, 3.06788534E-05, 1.97763234E-06],
                   [10622.3232, 2.96500821E-05, 1.88135061E-06],
                   [10770.3926, 2.86007344E-05, 1.78984556E-06],
                   [10920.5264, 2.74973936E-05, 1.70288195E-06],
                   [11072.7529, 2.61445057E-05, 1.62025469E-06],
                   [11227.1006, 2.0953803E-05, 3.95164125E-06],
                   [11383.6006, 2.48095366E-05, 3.74710544E-06],
                   [11542.2822, 2.47242442E-05, 3.55315478E-06],
                   [11703.1748, 2.43225713E-05, 3.36926701E-06],
                   [11866.3105, 2.38207358E-05, 3.19490186E-06],
                   [12031.7207, 2.32668463E-05, 3.02954254E-06],
                   [12199.4365, 2.26736029E-05, 2.87277567E-06],
                   [12369.4902, 2.20431302E-05, 2.72409102E-06],
                   [12541.9141, 2.13539133E-05, 2.58311752E-06],
                   [12716.7412, 2.02144674E-05, 2.44944249E-06],
                   [12894.0059, 1.87403184E-05, 3.25814358E-06],
                   [13073.7412, 1.97389982E-05, 3.10039195E-06],
                   [13255.9824, 1.92751322E-05, 2.95026257E-06],
                   [13440.7637, 1.85999052E-05, 3.18359071E-06],
                   [13628.1211, 1.85681492E-05, 3.03459888E-06],
                   [13818.0889, 1.82459389E-05, 2.89230684E-06],
                   [14010.7061, 1.78733771E-05, 2.75638286E-06],
                   [14206.0068, 1.74852721E-05, 2.62658386E-06],
                   [14404.0312, 1.7090957E-05, 2.50265475E-06],
                   [14604.8164, 1.66951177E-05, 2.38432517E-06],
                   [14808.3994, 1.63004443E-05, 2.27139503E-06],
                   [15014.8203, 1.59079664E-05, 2.16357239E-06],
                   [15224.1182, 1.55200851E-05, 2.06069217E-06],
                   [15436.335, 1.51375616E-05, 1.96253086E-06],
                   [15651.5098, 1.47609708E-05, 1.8688886E-06],
                   [15869.6816, 1.43907309E-05, 1.77957202E-06],
                   [16090.8965, 1.4027145E-05, 1.69439772E-06],
                   [16315.1953, 1.36704466E-05, 1.61318349E-06],
                   [16542.6191, 1.33205631E-05, 1.53572137E-06],
                   [16773.2148, 1.29778136E-05, 1.46187506E-06],
                   [17007.0254, 1.26423283E-05, 1.39147767E-06],
                   [17244.0938, 1.23141308E-05, 1.32438083E-06],
                   [17484.4668, 1.19932047E-05, 1.26044426E-06],
                   [17728.1914, 1.16795172E-05, 1.19951972E-06],
                   [17975.3125, 1.13730221E-05, 1.14146019E-06],
                   [18225.8789, 1.10735682E-05, 1.08614893E-06],
                   [18479.9375, 1.07811002E-05, 1.03344996E-06],
                   [18737.5371, 1.04956262E-05, 9.83248697E-07],
                   [18998.7285, 1.02170352E-05, 9.3543764E-07],
                   [19263.5605, 9.94522543E-06, 8.89903674E-07],
                   [19532.084, 9.68008317E-06, 8.46544026E-07],
                   [19804.3516, 9.42148836E-06, 8.05261152E-07],
                   [20080.4141, 9.16931731E-06, 7.6594722E-07],
                   [20360.3223, 8.92341268E-06, 7.28515317E-07],
                   [20644.1348, 8.6837108E-06, 6.92877677E-07],
                   [20931.9023, 8.45009436E-06, 6.58956367E-07],
                   [21223.6816, 8.22244056E-06, 6.26670783E-07],
                   [21519.5293, 8.00062026E-06, 5.95941685E-07],
                   [21819.5, 7.78450521E-06, 5.6669802E-07],
                   [22123.6523, 7.57397129E-06, 5.38867653E-07],
                   [22432.0449, 7.36886977E-06, 5.12380382E-07],
                   [22744.7324, 7.16910836E-06, 4.8717726E-07],
                   [23061.7832, 6.97456517E-06, 4.63199171E-07],
                   [23383.252, 6.78512788E-06, 4.40386202E-07],
                   [23709.2012, 6.60067462E-06, 4.18682646E-07],
                   [24039.6953, 6.42108171E-06, 3.98036462E-07],
                   [24374.7949, 6.24623817E-06, 3.78396919E-07],
                   [24714.5664, 6.07600987E-06, 3.59715017E-07],
                   [25059.0742, 5.91030039E-06, 3.41945935E-07],
                   [25408.3848, 5.74900469E-06, 3.25044823E-07],
                   [25762.5645, 5.59201499E-06, 3.08970726E-07],
                   [26121.6797, 5.43921897E-06, 2.9368411E-07],
                   [26485.8008, 5.29051385E-06, 2.79146519E-07],
                   [26855., 5.14580051E-06, 2.65323933E-07],
                   [27229.3438, 5.00497572E-06, 2.52179206E-07],
                   [27608.9062, 4.86793169E-06, 2.39679991E-07],
                   [27993.7598, 4.73458203E-06, 2.2779578E-07],
                   [28383.9766, 4.60483534E-06, 2.16496545E-07],
                   [28779.6348, 4.47861157E-06, 2.05753949E-07],
                   [29180.8066, 4.35595939E-06, 1.95541162E-07],
                   [29587.5723, 4.23655365E-06, 1.85831965E-07],
                   [30000.0059, 4.11850533E-06, 1.76602171E-07]]),
'Si': numpy.array([[30., 0.145224988, 0.0142891994],
                   [30.4181843, 0.140436038, 0.0139345387],
                   [30.8421955, 0.135814235, 0.0135886809],
                   [31.2721214, 0.131336331, 0.0132530928],
                   [31.7080383, 0.127011597, 0.0129477074],
                   [32.150032, 0.122850023, 0.0127012618],
                   [32.5981827, 0.118857257, 0.0124645438],
                   [33.0525818, 0.11501807, 0.0122322477],
                   [33.5133171, 0.111319959, 0.0120042702],
                   [33.9804764, 0.107754596, 0.011780533],
                   [34.4541473, 0.104315214, 0.011560984],
                   [34.9344177, 0.100996301, 0.0113454964],
                   [35.4213829, 0.0977928638, 0.0111340377],
                   [35.9151382, 0.0946987346, 0.010926527],
                   [36.4157791, 0.0917092189, 0.0107228914],
                   [36.9233932, 0.0888204798, 0.0105230445],
                   [37.4380875, 0.0860289335, 0.0103269136],
                   [37.9599533, 0.0833313987, 0.0101344567],
                   [38.4890938, 0.0807253346, 0.00994556677],
                   [39.0256119, 0.0782143027, 0.00976019911],
                   [39.5696068, 0.0757993534, 0.00956073869],
                   [40.1211853, 0.0734570622, 0.00933954306],
                   [40.6804543, 0.0711698607, 0.00911327917],
                   [41.2475166, 0.0689380467, 0.00889249612],
                   [41.8224831, 0.066770114, 0.00867705699],
                   [42.405468, 0.0646637753, 0.00846684817],
                   [42.9965744, 0.0626167506, 0.00826171506],
                   [43.5959282, 0.0606281199, 0.00806155335],
                   [44.2036324, 0.0586964414, 0.00786624476],
                   [44.8198051, 0.0568203069, 0.00767567521],
                   [45.4445686, 0.0549989343, 0.00748972176],
                   [46.0780411, 0.0532308854, 0.00730617484],
                   [46.7203445, 0.0515129939, 0.00712073408],
                   [47.3715973, 0.0498393774, 0.00693663349],
                   [48.0319328, 0.0482058749, 0.00675729988],
                   [48.7014732, 0.0466151796, 0.00658260938],
                   [49.3803444, 0.0450660028, 0.00641242787],
                   [50.0686798, 0.0435568094, 0.00624664268],
                   [50.7666092, 0.0420862027, 0.00608515041],
                   [51.4742699, 0.0406516343, 0.00592783652],
                   [52.1917915, 0.0392451808, 0.00577458646],
                   [52.9193192, 0.0378681496, 0.00563373649],
                   [53.6569862, 0.0365319625, 0.00551373884],
                   [54.4049339, 0.0352378488, 0.00539998058],
                   [55.163311, 0.0339821838, 0.00528856087],
                   [55.9322586, 0.032761123, 0.00517943595],
                   [56.7119217, 0.0315721743, 0.00507256901],
                   [57.5024567, 0.030413093, 0.00496790931],
                   [58.3040123, 0.0292748418, 0.00486540375],
                   [59.1167336, 0.0281465445, 0.00476501742],
                   [59.9407921, 0.027049493, 0.00470540673],
                   [60.7763329, 0.0259973649, 0.00466601597],
                   [61.6235237, 0.0249908753, 0.00462989602],
                   [62.4825172, 0.0240239911, 0.00459405454],
                   [63.3534927, 0.023093747, 0.00455849199],
                   [64.2366028, 0.0222011805, 0.00452321162],
                   [65.1320343, 0.0213631224, 0.00448428933],
                   [66.0399323, 0.0205427464, 0.00440320559],
                   [66.960495, 0.0197327491, 0.00431014877],
                   [67.8938904, 0.0189380553, 0.00421905424],
                   [68.8402939, 0.0181679465, 0.00412988616],
                   [69.7998886, 0.0174302161, 0.00403630035],
                   [70.7728577, 0.0167284422, 0.00389889325],
                   [71.7593994, 0.0159940161, 0.00371463713],
                   [72.7596817, 0.0152436486, 0.00353699108],
                   [73.7739182, 0.0144979069, 0.00336783659],
                   [74.8022842, 0.0137657057, 0.00318411947],
                   [75.844986, 0.0130260279, 0.00297594839],
                   [76.9022217, 0.0122436816, 0.00275878352],
                   [77.9741974, 0.0114194043, 0.00255745766],
                   [79.0611115, 0.0105633233, 0.00237230281],
                   [80.1631851, 0.00969524961, 0.00227208086],
                   [81.2806168, 0.00885013118, 0.00218887208],
                   [82.4136276, 0.00801841635, 0.00210871105],
                   [83.5624237, 0.00717720529, 0.00203244807],
                   [84.7272415, 0.00631613098, 0.00196965248],
                   [85.9082947, 0.00545288436, 0.00194257183],
                   [87.1058121, 0.00459559215, 0.00191586674],
                   [88.320015, 0.0037132625, 0.00188952591],
                   [89.5511475, 0.00279815542, 0.00186354958],
                   [90.7994385, 0.00183396996, 0.0018408153],
                   [92.0651398, 0.000804258976, 0.00182473147],
                   [93.3484802, -0.000313971337, 0.00181476725],
                   [94.649704, -0.00156157615, 0.00180486089],
                   [95.9690704, -0.00304994197, 0.00179500796],
                   [97.3068314, -0.00507385004, 0.0017906198],
                   [98.6632385, -0.0086174272, 0.00180488802],
                   [100.038544, -0.0160029624, 0.00764494296],
                   [101.433029, -0.00629231287, 0.017251458],
                   [102.846954, -0.00422382262, 0.0120728482],
                   [104.280579, -0.00523979031, 0.0103707369],
                   [105.734192, -0.00752048008, 0.0115892664],
                   [107.208076, -0.00666557578, 0.0135918912],
                   [108.702492, -0.00593095459, 0.0143676847],
                   [110.217751, -0.00590907689, 0.0147453099],
                   [111.754128, -0.00554097164, 0.0156555586],
                   [113.311913, -0.00519302906, 0.0161573198],
                   [114.891418, -0.00517762313, 0.0169034488],
                   [116.492943, -0.00467113033, 0.0181893408],
                   [118.116798, -0.00350276497, 0.019246636],
                   [119.763275, -0.00217946013, 0.0194694214],
                   [121.432716, -0.00135115115, 0.0196760576],
                   [123.125427, -0.000274209771, 0.0196132958],
                   [124.841721, 0.000563973328, 0.019412579],
                   [126.581955, 0.00110622169, 0.0192521345],
                   [128.346436, 0.00167961023, 0.0191761181],
                   [130.135513, 0.0023507704, 0.0192396846],
                   [131.949539, 0.00335369282, 0.0192366969],
                   [133.788834, 0.00458680512, 0.018726401],
                   [135.653778, 0.0052315807, 0.0174630955],
                   [137.544724, 0.00519081717, 0.0164539702],
                   [139.462021, 0.00501844753, 0.0161111318],
                   [141.406052, 0.00515376357, 0.0158411693],
                   [143.377167, 0.00508207828, 0.0154644493],
                   [145.375778, 0.00512892101, 0.0154476669],
                   [147.402222, 0.00539070833, 0.0153009715],
                   [149.45694, 0.00567043107, 0.0149849588],
                   [151.540268, 0.00567485718, 0.0150179984],
                   [153.652664, 0.00653794641, 0.0144752609],
                   [155.794495, 0.00623837346, 0.0136955753],
                   [157.966202, 0.00603050459, 0.0136175826],
                   [160.168167, 0.00617286004, 0.0136053786],
                   [162.400818, 0.00631487463, 0.0136944558],
                   [164.664597, 0.00675057061, 0.0136403861],
                   [166.95993, 0.00715658721, 0.0133243017],
                   [169.287262, 0.00774588389, 0.0131522315],
                   [171.647034, 0.00837748591, 0.0125023611],
                   [174.039703, 0.00865232479, 0.0115839122],
                   [176.465729, 0.00848829187, 0.0107647395],
                   [178.925552, 0.00822979119, 0.010216807],
                   [181.419678, 0.00805879291, 0.00989953242],
                   [183.948563, 0.00802738033, 0.00956187397],
                   [186.512726, 0.00790408161, 0.00923523307],
                   [189.112595, 0.00781944953, 0.00891754124],
                   [191.748734, 0.00773876626, 0.00860352442],
                   [194.4216, 0.00765487365, 0.00830060244],
                   [197.131729, 0.00756809814, 0.00800832734],
                   [199.879639, 0.00747622736, 0.00772633916],
                   [202.665863, 0.00737909274, 0.00745817088],
                   [205.490906, 0.007280841, 0.00720523251],
                   [208.355347, 0.00718741259, 0.00696420902],
                   [211.259705, 0.00709701376, 0.00673125451],
                   [214.204544, 0.0070082508, 0.00650608726],
                   [217.190445, 0.00692612631, 0.00628844649],
                   [220.217957, 0.00684985984, 0.00607489143],
                   [223.287674, 0.00677241106, 0.00585438171],
                   [226.400192, 0.00668758806, 0.00562991574],
                   [229.556091, 0.00659409119, 0.00541404774],
                   [232.755981, 0.00649611279, 0.00520644989],
                   [236.000458, 0.00639513694, 0.00500682043],
                   [239.290176, 0.00629265048, 0.00481485575],
                   [242.625763, 0.00618968066, 0.00463024667],
                   [246.007828, 0.00608849339, 0.00445270957],
                   [249.437057, 0.00598817831, 0.00427873712],
                   [252.914062, 0.0058858688, 0.00410642102],
                   [256.439545, 0.00578002213, 0.00394008774],
                   [260.01416, 0.00567243621, 0.0037804842],
                   [263.638641, 0.00556406239, 0.00362735381],
                   [267.313599, 0.00545563269, 0.00348041975],
                   [271.039825, 0.00534747541, 0.00333943451],
                   [274.817963, 0.00523983408, 0.00320416503],
                   [278.648773, 0.00513292477, 0.00307437754],
                   [282.53299, 0.00502696587, 0.00294984761],
                   [286.471375, 0.00492210593, 0.00283035613],
                   [290.4646, 0.00481854985, 0.00271571032],
                   [294.513519, 0.00471697794, 0.00260570552],
                   [298.618896, 0.00461704191, 0.00249894988],
                   [302.781494, 0.00451815547, 0.00239521638],
                   [307.002106, 0.00441984693, 0.00229506334],
                   [311.281525, 0.00432206644, 0.00219910219],
                   [315.620605, 0.00422543148, 0.00210715388],
                   [320.020203, 0.00412995694, 0.00201904471],
                   [324.48111, 0.00403596833, 0.00193462789],
                   [329.004181, 0.00394351874, 0.00185373845],
                   [333.590363, 0.00385265681, 0.00177622854],
                   [338.240417, 0.00376346079, 0.00170195964],
                   [342.955322, 0.00367600122, 0.0016307967],
                   [347.735901, 0.00359031674, 0.00156260841],
                   [352.58316, 0.00350652472, 0.00149727345],
                   [357.497986, 0.00342488172, 0.00143466599],
                   [362.481323, 0.00334608834, 0.00137468067],
                   [367.534119, 0.00326964422, 0.00131464819],
                   [372.657349, 0.00319398916, 0.00125495519],
                   [377.85199, 0.00311802025, 0.00119734404],
                   [383.119019, 0.00304222014, 0.00114237948],
                   [388.459473, 0.00296739815, 0.00108993798],
                   [393.87439, 0.00289369468, 0.00103989954],
                   [399.364807, 0.00282126479, 0.000992159592],
                   [404.931732, 0.00275015924, 0.000946611864],
                   [410.576233, 0.00268042949, 0.000903154956],
                   [416.299469, 0.00261210697, 0.000861692533],
                   [422.102448, 0.00254520169, 0.000822134083],
                   [427.986359, 0.00247972389, 0.000784391828],
                   [433.95224, 0.002415661, 0.000748383231],
                   [440.001282, 0.00235304073, 0.000714026333],
                   [446.134674, 0.00229189778, 0.000681247038],
                   [452.353577, 0.00223225378, 0.000649972411],
                   [458.659119, 0.00217415346, 0.000620065897],
                   [465.052582, 0.00211755815, 0.000591272023],
                   [471.535156, 0.00206217798, 0.000563233974],
                   [478.108093, 0.00200772611, 0.000536526728],
                   [484.772644, 0.00195440208, 0.000511084741],
                   [491.530151, 0.00190229074, 0.000486849895],
                   [498.381775, 0.00185139407, 0.000463764532],
                   [505.328979, 0.00180170103, 0.000441772514],
                   [512.372986, 0.00175320648, 0.00042082346],
                   [519.515198, 0.00170590577, 0.000400869816],
                   [526.756958, 0.00165976258, 0.00038185998],
                   [534.09967, 0.00161477155, 0.000363752799],
                   [541.544739, 0.00157092267, 0.000346504065],
                   [549.093506, 0.00152820209, 0.00033007309],
                   [556.74762, 0.00148659456, 0.000314420991],
                   [564.508362, 0.00144608878, 0.000299511332],
                   [572.377319, 0.0014066844, 0.000285308663],
                   [580.355957, 0.00136843137, 0.000271779514],
                   [588.445801, 0.00133121025, 0.000258572662],
                   [596.648438, 0.00129482697, 0.000245834148],
                   [604.965332, 0.00125925045, 0.000233685379],
                   [613.398315, 0.00122450304, 0.000222136616],
                   [621.948669, 0.00119061128, 0.000211159044],
                   [630.618347, 0.00115757505, 0.000200723807],
                   [639.408813, 0.00112537644, 0.000190803956],
                   [648.321838, 0.00109400274, 0.000181375115],
                   [657.35907, 0.00106344512, 0.000172411921],
                   [666.522278, 0.0010336797, 0.000163891164],
                   [675.813293, 0.00100469694, 0.000155791975],
                   [685.233704, 0.000976427458, 0.000148093342],
                   [694.785522, 0.000948816887, 0.000140820805],
                   [704.470398, 0.000921951025, 0.000134073911],
                   [714.290344, 0.000895965961, 0.00012774358],
                   [724.247192, 0.00087076833, 0.000121711506],
                   [734.342834, 0.000846297247, 0.000115964707],
                   [744.579163, 0.000822530128, 0.000110489302],
                   [754.958191, 0.000799447356, 0.0001052722],
                   [765.481934, 0.000777028908, 0.000100301258],
                   [776.152344, 0.000755256857, 9.5565083E-05],
                   [786.971436, 0.000734124798, 9.1052927E-05],
                   [797.941406, 0.000713680056, 8.66937698E-05],
                   [809.06427, 0.000693736074, 8.24175659E-05],
                   [820.342224, 0.000674282026, 7.83200521E-05],
                   [831.777283, 0.000655329844, 7.44260979E-05],
                   [843.371826, 0.000636882905, 7.07254439E-05],
                   [855.127991, 0.000618933176, 6.72091264E-05],
                   [867.047974, 0.000601478852, 6.38676938E-05],
                   [879.134155, 0.0005845087, 6.06922331E-05],
                   [891.388855, 0.000568038144, 5.76744787E-05],
                   [903.814331, 0.000552055251, 5.47317577E-05],
                   [916.413025, 0.000536477077, 5.18719535E-05],
                   [929.187317, 0.000521265611, 4.91324354E-05],
                   [942.139648, 0.000506436802, 4.65376579E-05],
                   [955.272583, 0.000491991232, 4.40798831E-05],
                   [968.588562, 0.000477926253, 4.17519113E-05],
                   [982.09021, 0.000464238256, 3.95466232E-05],
                   [995.779968, 0.000450918946, 3.74569681E-05],
                   [1009.66058, 0.000437957176, 3.54764852E-05],
                   [1023.7348, 0.000425344188, 3.35997538E-05],
                   [1038.005, 0.000413071975, 3.18221173E-05],
                   [1052.47424, 0.000401129888, 3.01388591E-05],
                   [1067.14514, 0.000389500317, 2.85442311E-05],
                   [1082.02051, 0.000378172001, 2.7034177E-05],
                   [1097.10339, 0.000367129513, 2.56477524E-05],
                   [1112.39636, 0.000356416131, 2.43693194E-05],
                   [1127.90259, 0.000346029323, 2.31692047E-05],
                   [1143.62488, 0.000335944758, 2.20276779E-05],
                   [1159.56641, 0.00032614643, 2.09422833E-05],
                   [1175.73022, 0.000316623307, 1.9910427E-05],
                   [1192.11926, 0.0003073673, 1.89290913E-05],
                   [1208.73682, 0.000298365398, 1.79950184E-05],
                   [1225.58594, 0.000289609801, 1.71062729E-05],
                   [1242.66992, 0.000281092711, 1.62610959E-05],
                   [1259.99194, 0.000272806879, 1.54577065E-05],
                   [1277.55554, 0.000264745409, 1.46940865E-05],
                   [1295.36401, 0.000256901432, 1.39680615E-05],
                   [1313.42078, 0.000249258912, 1.32749437E-05],
                   [1331.72913, 0.00024181552, 1.26160885E-05],
                   [1350.29272, 0.000234565552, 1.19896695E-05],
                   [1369.11511, 0.000227501252, 1.13943343E-05],
                   [1388.19983, 0.000220615009, 1.08282384E-05],
                   [1407.55054, 0.00021389965, 1.02894664E-05],
                   [1427.17102, 0.000207348334, 9.77692162E-06],
                   [1447.06506, 0.000200948503, 9.28941336E-06],
                   [1467.23621, 0.000194692824, 8.82620407E-06],
                   [1487.68884, 0.000188575403, 8.38594042E-06],
                   [1508.42639, 0.000182587624, 7.96242693E-06],
                   [1529.453, 0.000176717411, 7.5564767E-06],
                   [1550.77271, 0.000170951753, 7.17073453E-06],
                   [1572.38977, 0.000165278936, 6.80433277E-06],
                   [1594.30786, 0.000159677438, 6.45677574E-06],
                   [1616.53174, 0.000154117108, 6.12691792E-06],
                   [1639.06531, 0.000148584571, 5.81384757E-06],
                   [1661.91296, 0.00014304489, 5.51677749E-06],
                   [1685.0791, 0.000137449882, 5.23491417E-06],
                   [1708.56824, 0.000131730412, 4.96746634E-06],
                   [1732.38477, 0.000125779974, 4.71290105E-06],
                   [1756.53333, 0.000119410317, 4.46704462E-06],
                   [1781.01831, 0.000111896865, 4.23308438E-06],
                   [1805.84485, 0.000101646438, 4.01063198E-06],
                   [1831.01721, 5.07619188E-05, 3.79973153E-06],
                   [1856.54065, 9.11733587E-05, 4.10004432E-05],
                   [1882.41992, 9.91268462E-05, 3.91196882E-05],
                   [1908.65979, 0.000102691811, 3.73249168E-05],
                   [1935.2655, 0.000103961, 3.56122619E-05],
                   [1962.24194, 0.00010413627, 3.39780381E-05],
                   [1989.59473, 0.000103667538, 3.24177854E-05],
                   [2017.32861, 0.000102780788, 3.09259449E-05],
                   [2045.44897, 0.000101586891, 2.94989586E-05],
                   [2073.96143, 0.000100187091, 2.81367611E-05],
                   [2102.87134, 9.86479863E-05, 2.68226468E-05],
                   [2132.18433, 9.70017136E-05, 2.55632785E-05],
                   [2161.90576, 9.52745177E-05, 2.43599188E-05],
                   [2192.0415, 9.34882046E-05, 2.32095808E-05],
                   [2222.59741, 9.16604913E-05, 2.21098762E-05],
                   [2253.57935, 8.98023864E-05, 2.10604085E-05],
                   [2284.99292, 8.79224172E-05, 2.00572722E-05],
                   [2316.84448, 8.60382061E-05, 1.90991086E-05],
                   [2349.13989, 8.41545625E-05, 1.81848409E-05],
                   [2381.8855, 8.22771399E-05, 1.73119515E-05],
                   [2415.08789, 8.04109004E-05, 1.64786816E-05],
                   [2448.75293, 7.85595403E-05, 1.56841033E-05],
                   [2482.88721, 7.67266247E-05, 1.49258012E-05],
                   [2517.49707, 7.4911397E-05, 1.42022664E-05],
                   [2552.58984, 7.31204273E-05, 1.35129012E-05],
                   [2588.17163, 7.13554255E-05, 1.2855171E-05],
                   [2624.24927, 6.96172792E-05, 1.22281663E-05],
                   [2660.82983, 6.79073128E-05, 1.16308829E-05],
                   [2697.92041, 6.62269813E-05, 1.1061702E-05],
                   [2735.52783, 6.45768014E-05, 1.05186737E-05],
                   [2773.65967, 6.29559727E-05, 1.00017396E-05],
                   [2812.323, 6.13658194E-05, 9.50937374E-06],
                   [2851.52539, 5.98074294E-05, 9.04028639E-06],
                   [2891.27393, 5.82808389E-05, 8.593639E-06],
                   [2931.57666, 5.67858915E-05, 8.16830106E-06],
                   [2972.44141, 5.53226891E-05, 7.76325123E-06],
                   [3013.87549, 5.38915592E-05, 7.37788605E-06],
                   [3055.88745, 5.24915595E-05, 7.0110068E-06],
                   [3098.48486, 5.1122337E-05, 6.66167944E-06],
                   [3141.67603, 4.97841647E-05, 6.32945421E-06],
                   [3185.46924, 4.84767152E-05, 6.01326155E-06],
                   [3229.8728, 4.71998683E-05, 5.71238706E-06],
                   [3274.89575, 4.5953333E-05, 5.42626003E-06],
                   [3320.54614, 4.47364728E-05, 5.15412512E-06],
                   [3366.83252, 4.35484326E-05, 4.89508329E-06],
                   [3413.7644, 4.23889069E-05, 4.6488899E-06],
                   [3461.35059, 4.12577319E-05, 4.41475231E-06],
                   [3509.59961, 4.01544639E-05, 4.19210528E-06],
                   [3558.52148, 3.90786226E-05, 3.98049087E-06],
                   [3608.12549, 3.80296697E-05, 3.77931656E-06],
                   [3658.4209, 3.70070447E-05, 3.58799957E-06],
                   [3709.41724, 3.60102749E-05, 3.40623365E-06],
                   [3761.12451, 3.50385126E-05, 3.2335015E-06],
                   [3813.55249, 3.40915503E-05, 3.06924267E-06],
                   [3866.71143, 3.31689771E-05, 2.91322522E-06],
                   [3920.61133, 3.22701235E-05, 2.76498076E-06],
                   [3975.26221, 3.13945202E-05, 2.62412141E-06],
                   [4030.67554, 3.05417379E-05, 2.49031245E-06],
                   [4086.86084, 2.97112274E-05, 2.36323581E-06],
                   [4143.82959, 2.89023374E-05, 2.24244809E-06],
                   [4201.59229, 2.8114544E-05, 2.12777468E-06],
                   [4260.16016, 2.73476471E-05, 2.01887042E-06],
                   [4319.54443, 2.66010393E-05, 1.91543245E-06],
                   [4379.75635, 2.5874162E-05, 1.81720804E-06],
                   [4440.80811, 2.51665933E-05, 1.72394891E-06],
                   [4502.71045, 2.44779712E-05, 1.63538061E-06],
                   [4565.47559, 2.38075663E-05, 1.5512943E-06],
                   [4629.11572, 2.31551239E-05, 1.47147034E-06],
                   [4693.64355, 2.25202148E-05, 1.39566112E-06],
                   [4759.07031, 2.19023859E-05, 1.32371417E-06],
                   [4825.40918, 2.13011244E-05, 1.25544216E-06],
                   [4892.67285, 2.07160683E-05, 1.19064327E-06],
                   [4960.87402, 2.01469411E-05, 1.12914108E-06],
                   [5030.02588, 1.95931552E-05, 1.07078915E-06],
                   [5100.14209, 1.90542432E-05, 1.01535056E-06],
                   [5171.23486, 1.85300687E-05, 9.62764375E-07],
                   [5243.31885, 1.80200695E-05, 9.12889163E-07],
                   [5316.4082, 1.75239475E-05, 8.65561162E-07],
                   [5390.51611, 1.70414023E-05, 8.20653099E-07],
                   [5465.65723, 1.65720376E-05, 7.78052936E-07],
                   [5541.84521, 1.61154421E-05, 7.37626635E-07],
                   [5619.09521, 1.56713395E-05, 6.99271311E-07],
                   [5697.42285, 1.5239305E-05, 6.62889533E-07],
                   [5776.8418, 1.48191621E-05, 6.28380974E-07],
                   [5857.36768, 1.44105052E-05, 5.95653944E-07],
                   [5939.01611, 1.40130433E-05, 5.64611696E-07],
                   [6021.80273, 1.36265226E-05, 5.3516186E-07],
                   [6105.74316, 1.3250602E-05, 5.07233381E-07],
                   [6190.85449, 1.28850488E-05, 4.80753499E-07],
                   [6277.15186, 1.25295091E-05, 4.55644425E-07],
                   [6364.65137, 1.21837902E-05, 4.31834707E-07],
                   [6453.37158, 1.18474873E-05, 4.09225493E-07],
                   [6543.32812, 1.15205021E-05, 3.87819483E-07],
                   [6634.53809, 1.12025409E-05, 3.67521352E-07],
                   [6727.02051, 1.08933518E-05, 3.4826374E-07],
                   [6820.7915, 1.05926965E-05, 3.30007055E-07],
                   [6915.86914, 1.0300304E-05, 3.12702952E-07],
                   [7012.27295, 1.00159814E-05, 2.96297372E-07],
                   [7110.02002, 9.73952319E-06, 2.80743109E-07],
                   [7209.12988, 9.47066019E-06, 2.66000256E-07],
                   [7309.62109, 9.20926777E-06, 2.52025586E-07],
                   [7411.51318, 8.95503672E-06, 2.3877385E-07],
                   [7514.82617, 8.70786153E-06, 2.26214837E-07],
                   [7619.57861, 8.46752118E-06, 2.14312749E-07],
                   [7725.79102, 8.23383743E-06, 2.0303159E-07],
                   [7833.48438, 8.00661019E-06, 1.92338419E-07],
                   [7942.67969, 7.78562753E-06, 1.82204843E-07],
                   [8053.396, 7.57078396E-06, 1.72600394E-07],
                   [8165.65625, 7.36191168E-06, 1.63498015E-07],
                   [8279.48047, 7.15876604E-06, 1.54872822E-07],
                   [8394.89258, 6.96127518E-06, 1.4669881E-07],
                   [8511.91211, 6.76923673E-06, 1.3895324E-07],
                   [8630.56348, 6.58249201E-06, 1.31613803E-07],
                   [8750.86914, 6.40093049E-06, 1.24658911E-07],
                   [8872.85156, 6.22440621E-06, 1.18068876E-07],
                   [8996.53418, 6.05275E-06, 1.11826488E-07],
                   [9121.94141, 5.88582634E-06, 1.05909393E-07],
                   [9249.0957, 5.72353292E-06, 1.00304291E-07],
                   [9378.02344, 5.56572149E-06, 9.49948813E-08],
                   [9508.74805, 5.41227519E-06, 8.99642316E-08],
                   [9641.29492, 5.26308577E-06, 8.5197577E-08],
                   [9775.68848, 5.11803228E-06, 8.06824332E-08],
                   [9911.95703, 4.9769742E-06, 7.64050512E-08],
                   [10050.125, 4.83983285E-06, 7.23531315E-08],
                   [10190.2178, 4.70647137E-06, 6.85141828E-08],
                   [10332.2637, 4.57680198E-06, 6.48780443E-08],
                   [10476.29, 4.45071464E-06, 6.14336386E-08],
                   [10622.3232, 4.32811703E-06, 5.81710218E-08],
                   [10770.3926, 4.2089282E-06, 5.50811237E-08],
                   [10920.5264, 4.09299901E-06, 5.21538368E-08],
                   [11072.7529, 3.9802876E-06, 4.9382205E-08],
                   [11227.1006, 3.87069986E-06, 4.67564334E-08],
                   [11383.6006, 3.764148E-06, 4.42697718E-08],
                   [11542.2822, 3.66053609E-06, 4.19147952E-08],
                   [11703.1748, 3.55977681E-06, 3.96844406E-08],
                   [11866.3105, 3.46179445E-06, 3.75721072E-08],
                   [12031.7207, 3.36652624E-06, 3.55717553E-08],
                   [12199.4365, 3.2738983E-06, 3.36775905E-08],
                   [12369.4902, 3.1838365E-06, 3.18840279E-08],
                   [12541.9141, 3.0962542E-06, 3.01852836E-08],
                   [12716.7412, 3.01108139E-06, 2.85767587E-08],
                   [12894.0059, 2.92825825E-06, 2.70537868E-08],
                   [13073.7412, 2.84772796E-06, 2.5611719E-08],
                   [13255.9824, 2.76942478E-06, 2.42464786E-08],
                   [13440.7637, 2.69327461E-06, 2.29533068E-08],
                   [13628.1211, 2.6192331E-06, 2.17292637E-08],
                   [13818.0889, 2.54724046E-06, 2.05702548E-08],
                   [14010.7061, 2.47722937E-06, 1.94727861E-08],
                   [14206.0068, 2.40914301E-06, 1.84338926E-08],
                   [14404.0312, 2.34293179E-06, 1.745045E-08],
                   [14604.8164, 2.27855162E-06, 1.65191132E-08],
                   [14808.3994, 2.21595269E-06, 1.56375837E-08],
                   [15014.8203, 2.15507339E-06, 1.48029295E-08],
                   [15224.1182, 2.09587711E-06, 1.40124419E-08],
                   [15436.335, 2.03830905E-06, 1.32641942E-08],
                   [15651.5098, 1.98232783E-06, 1.25558541E-08],
                   [15869.6816, 1.92789071E-06, 1.18852492E-08],
                   [16090.8965, 1.87495016E-06, 1.1250477E-08],
                   [16315.1953, 1.82347219E-06, 1.0649627E-08],
                   [16542.6191, 1.77340814E-06, 1.00807807E-08],
                   [16773.2148, 1.7247271E-06, 9.54238999E-09],
                   [17007.0254, 1.67738381E-06, 9.03282604E-09],
                   [17244.0938, 1.63134564E-06, 8.55049098E-09],
                   [17484.4668, 1.58657576E-06, 8.09394507E-09],
                   [17728.1914, 1.54303621E-06, 7.66183472E-09],
                   [17975.3125, 1.50069866E-06, 7.2528854E-09],
                   [18225.8789, 1.45952288E-06, 6.86581458E-09],
                   [18479.9375, 1.41947669E-06, 6.49945342E-09],
                   [18737.5371, 1.38053576E-06, 6.15268858E-09],
                   [18998.7285, 1.34266986E-06, 5.82453508E-09],
                   [19263.5605, 1.3058459E-06, 5.51399726E-09],
                   [19532.084, 1.27003193E-06, 5.22012034E-09],
                   [19804.3516, 1.23520067E-06, 4.94198149E-09],
                   [20080.4141, 1.20133143E-06, 4.67860817E-09],
                   [20360.3223, 1.16839112E-06, 4.42934578E-09],
                   [20644.1348, 1.13635372E-06, 4.19358326E-09],
                   [20931.9023, 1.10519909E-06, 3.97057232E-09],
                   [21223.6816, 1.07490109E-06, 3.75962861E-09],
                   [21519.5293, 1.04543562E-06, 3.56009666E-09],
                   [21819.5, 1.01678211E-06, 3.3713794E-09],
                   [22123.6523, 9.88914053E-07, 3.19287818E-09],
                   [22432.0449, 9.61809519E-07, 3.02399839E-09],
                   [22744.7324, 9.35453215E-07, 2.86427793E-09],
                   [23061.7832, 9.09819619E-07, 2.713197E-09],
                   [23383.252, 8.8488855E-07, 2.57028843E-09],
                   [23709.2012, 8.60642558E-07, 2.43511944E-09],
                   [24039.6953, 8.37064192E-07, 2.30727015E-09],
                   [24374.7949, 8.14131909E-07, 2.18633445E-09],
                   [24714.5664, 7.9183252E-07, 2.0719253E-09],
                   [25059.0742, 7.70144084E-07, 1.96371119E-09],
                   [25408.3848, 7.49049491E-07, 1.86134808E-09],
                   [25762.5645, 7.28532768E-07, 1.76451531E-09],
                   [26121.6797, 7.08579819E-07, 1.67292191E-09],
                   [26485.8008, 6.8917592E-07, 1.58628288E-09],
                   [26855., 6.70303166E-07, 1.504324E-09],
                   [27229.3438, 6.51947346E-07, 1.42679601E-09],
                   [27608.9062, 6.34097773E-07, 1.3534438E-09],
                   [27993.7598, 6.16737168E-07, 1.28405508E-09],
                   [28383.9766, 5.99851944E-07, 1.21841592E-09],
                   [28779.6348, 5.83430506E-07, 1.15631749E-09],
                   [29180.8066, 5.67459608E-07, 1.09756537E-09],
                   [29587.5723, 5.51924188E-07, 1.04197861E-09],
                   [30000.0059, 5.36819186E-07, 9.89393789E-10]]),
'Diamond': numpy.array([[30., 0.496328741, 0.358168721],
                   [30.4181843, 0.486987412, 0.34238863],
                   [30.8421955, 0.477445602, 0.327300042],
                   [31.2721214, 0.467828959, 0.312874705],
                   [31.7080383, 0.458164096, 0.299086988],
                   [32.150032, 0.448494494, 0.28590548],
                   [32.5981827, 0.43885684, 0.273305774],
                   [33.0525818, 0.429266632, 0.261261433],
                   [33.5133171, 0.419737905, 0.249747917],
                   [33.9804764, 0.410278648, 0.238741741],
                   [34.4541473, 0.400887012, 0.228220031],
                   [34.9344177, 0.391539514, 0.218163103],
                   [35.4213829, 0.382254928, 0.208778203],
                   [35.9151382, 0.373240739, 0.199839637],
                   [36.4157791, 0.36444208, 0.191291645],
                   [36.9233932, 0.355832309, 0.183109641],
                   [37.4380875, 0.347406179, 0.175277457],
                   [37.9599533, 0.339165807, 0.167780042],
                   [38.4890938, 0.331116319, 0.160604402],
                   [39.0256119, 0.323396087, 0.15373452],
                   [39.5696068, 0.315941244, 0.146891356],
                   [40.1211853, 0.308434457, 0.140118167],
                   [40.6804543, 0.300883532, 0.133574799],
                   [41.2475166, 0.29336217, 0.127336949],
                   [41.8224831, 0.285911858, 0.121390447],
                   [42.405468, 0.27854833, 0.115721956],
                   [42.9965744, 0.271266252, 0.110317715],
                   [43.5959282, 0.264072567, 0.105165556],
                   [44.2036324, 0.256926239, 0.100254685],
                   [44.8198051, 0.249807179, 0.0956031159],
                   [45.4445686, 0.242790401, 0.0913954601],
                   [46.0780411, 0.236010119, 0.0876563191],
                   [46.7203445, 0.229570672, 0.0840699971],
                   [47.3715973, 0.223360494, 0.080630742],
                   [48.0319328, 0.217343628, 0.0773322731],
                   [48.7014732, 0.211499423, 0.0741686597],
                   [49.3803444, 0.205815628, 0.0711343363],
                   [50.0686798, 0.200282201, 0.0682241097],
                   [50.7666092, 0.194889814, 0.0654329285],
                   [51.4742699, 0.18962878, 0.0627557859],
                   [52.1917915, 0.184486702, 0.0601882488],
                   [52.9193192, 0.179426283, 0.0577261448],
                   [53.6569862, 0.174419329, 0.0554907843],
                   [54.4049339, 0.169623792, 0.0534470901],
                   [55.163311, 0.165045321, 0.0515173562],
                   [55.9322586, 0.16064541, 0.0496571995],
                   [56.7119217, 0.156399146, 0.0478641056],
                   [57.5024567, 0.152296007, 0.0461357683],
                   [58.3040123, 0.148334444, 0.0444701128],
                   [59.1167336, 0.144509897, 0.0428643636],
                   [59.9407921, 0.14083001, 0.0413166434],
                   [60.7763329, 0.137317911, 0.0397841893],
                   [61.6235237, 0.133917391, 0.0382077619],
                   [62.4825172, 0.130546734, 0.0365907662],
                   [63.3534927, 0.127190992, 0.035042312],
                   [64.2366028, 0.123887852, 0.0335591771],
                   [65.1320343, 0.12064933, 0.0321387611],
                   [66.0399323, 0.117480069, 0.030778585],
                   [66.960495, 0.114381336, 0.0294759907],
                   [67.8938904, 0.111353606, 0.0282285325],
                   [68.8402939, 0.108396739, 0.0270338897],
                   [69.7998886, 0.105510339, 0.0258898195],
                   [70.7728577, 0.102693401, 0.0247939881],
                   [71.7593994, 0.0999442413, 0.0237446539],
                   [72.7596817, 0.0972631499, 0.0227397997],
                   [73.7739182, 0.0946487337, 0.0217774138],
                   [74.8022842, 0.0920997411, 0.0208557677],
                   [75.844986, 0.0896149352, 0.0199731514],
                   [76.9022217, 0.0871930271, 0.01912787],
                   [77.9741974, 0.0848326683, 0.0183182992],
                   [79.0611115, 0.0825318694, 0.0175430644],
                   [80.1631851, 0.0802901685, 0.0168005992],
                   [81.2806168, 0.0781061798, 0.0160895605],
                   [82.4136276, 0.0759784877, 0.0154086221],
                   [83.5624237, 0.0739059076, 0.0147565054],
                   [84.7272415, 0.0718872249, 0.0141319828],
                   [85.9082947, 0.0699209571, 0.0135338828],
                   [87.1058121, 0.0680055991, 0.0129611185],
                   [88.320015, 0.0661403313, 0.0124125769],
                   [89.5511475, 0.0643239245, 0.0118872477],
                   [90.7994385, 0.062555179, 0.0113841584],
                   [92.0651398, 0.0608329251, 0.0109023592],
                   [93.3484802, 0.0591560453, 0.0104409475],
                   [94.649704, 0.0575233549, 0.00999907311],
                   [95.9690704, 0.0559337772, 0.00957590155],
                   [97.3068314, 0.054385934, 0.00917062536],
                   [98.6632385, 0.0528791137, 0.00878250692],
                   [100.038544, 0.0514122918, 0.00841081142],
                   [101.433029, 0.0499844253, 0.00805484038],
                   [102.846954, 0.048594512, 0.00771394419],
                   [104.280579, 0.047241576, 0.00738749932],
                   [105.734192, 0.0459246747, 0.00707482034],
                   [107.208076, 0.0446425974, 0.00677542062],
                   [108.702492, 0.0433947332, 0.00648867059],
                   [110.217751, 0.0421802066, 0.00621404406],
                   [111.754128, 0.0409981348, 0.00595104508],
                   [113.311913, 0.0398477092, 0.00569918146],
                   [114.891418, 0.0387281068, 0.00545798521],
                   [116.492943, 0.0376384594, 0.00522701815],
                   [118.116798, 0.0365778953, 0.00500578294],
                   [119.763275, 0.0355456881, 0.00479393266],
                   [121.432716, 0.0345412903, 0.00459104637],
                   [123.125427, 0.0335639156, 0.00439674174],
                   [124.841721, 0.0326129235, 0.00421066815],
                   [126.581955, 0.0316877365, 0.00403247494],
                   [128.346436, 0.0307877213, 0.0038617875],
                   [130.135513, 0.0299125612, 0.00369835901],
                   [131.949539, 0.0290630646, 0.00354185281],
                   [133.788834, 0.0282357484, 0.00338649214],
                   [135.653778, 0.0274284687, 0.00323625584],
                   [137.544724, 0.0266407803, 0.00309268036],
                   [139.462021, 0.0258728769, 0.00295547117],
                   [141.406052, 0.0251246504, 0.00282435189],
                   [143.377167, 0.0243956875, 0.00269906619],
                   [145.375778, 0.0236853156, 0.00257931952],
                   [147.402222, 0.0229934603, 0.00246489211],
                   [149.45694, 0.0223196447, 0.00235554227],
                   [151.540268, 0.0216633938, 0.002251036],
                   [153.652664, 0.0210242551, 0.00215116469],
                   [155.794495, 0.0204018299, 0.00205574161],
                   [157.966202, 0.0197955929, 0.00196453882],
                   [160.168167, 0.0192047339, 0.00187737413],
                   [162.400818, 0.018629251, 0.00179408374],
                   [164.664597, 0.0180686861, 0.00171449943],
                   [166.95993, 0.01752262, 0.00163843809],
                   [169.287262, 0.0169906523, 0.0015657458],
                   [171.647034, 0.0164723955, 0.00149628392],
                   [174.039703, 0.0159674902, 0.00142990646],
                   [176.465729, 0.0154752722, 0.001366465],
                   [178.925552, 0.0149956122, 0.0013058444],
                   [181.419678, 0.0145284608, 0.00124791509],
                   [183.948563, 0.0140749337, 0.00119255052],
                   [186.512726, 0.0136332093, 0.00113659515],
                   [189.112595, 0.0132003631, 0.00107916677],
                   [191.748734, 0.0127751008, 0.00102453504],
                   [194.4216, 0.0123581756, 0.000972680224],
                   [197.131729, 0.0119493539, 0.000923445157],
                   [199.879639, 0.0115490211, 0.000876700506],
                   [202.665863, 0.0111569101, 0.000832321821],
                   [205.490906, 0.0107726986, 0.000790192978],
                   [208.355347, 0.0103959953, 0.000750195817],
                   [211.259705, 0.0100263925, 0.000712217938],
                   [214.204544, 0.00966338161, 0.000676169933],
                   [217.190445, 0.00930526014, 0.0006419415],
                   [220.217957, 0.00895224977, 0.000609794573],
                   [223.287674, 0.00860456284, 0.000579893182],
                   [226.400192, 0.00826163497, 0.000551727135],
                   [229.556091, 0.00792258885, 0.000524927978],
                   [232.755981, 0.00758649781, 0.00049942953],
                   [236.000458, 0.00725237234, 0.000475171022],
                   [239.290176, 0.00691687735, 0.000452089269],
                   [242.625763, 0.00657957047, 0.000430131506],
                   [246.007828, 0.00624039955, 0.000408596039],
                   [249.437057, 0.00589460507, 0.000386118045],
                   [252.914062, 0.00553760864, 0.000363529049],
                   [256.439545, 0.00516527053, 0.000342262443],
                   [260.01416, 0.00477242004, 0.000322238018],
                   [263.638641, 0.00434403215, 0.000303386041],
                   [267.313599, 0.00385798374, 0.000285638147],
                   [271.039825, 0.00328379287, 0.000268927222],
                   [274.817963, 0.00254316302, 0.000253193633],
                   [278.648773, 0.00137187436, 0.000238381152],
                   [282.53299, -0.00239146408, 0.000224435425],
                   [286.471375, -0.000150937107, 0.00611820444],
                   [290.4646, 0.00198474596, 0.00585151045],
                   [294.513519, 0.00289568165, 0.00559643004],
                   [298.618896, 0.00346968719, 0.00535247568],
                   [302.781494, 0.00386046665, 0.00511914073],
                   [307.002106, 0.00413779635, 0.00489598839],
                   [311.281525, 0.00433798367, 0.00468258141],
                   [315.620605, 0.00448247232, 0.00447845552],
                   [320.020203, 0.00458493968, 0.0042832219],
                   [324.48111, 0.00465156417, 0.00409650197],
                   [329.004181, 0.0046934709, 0.00391794555],
                   [333.590363, 0.00471534114, 0.00374715589],
                   [338.240417, 0.00472068926, 0.00358380005],
                   [342.955322, 0.00471231341, 0.00342757162],
                   [347.735901, 0.00469252001, 0.00327816559],
                   [352.58316, 0.00466323085, 0.00313526881],
                   [357.497986, 0.00462545315, 0.00299859629],
                   [362.481323, 0.00458113896, 0.00286788354],
                   [367.534119, 0.00453195628, 0.00274286536],
                   [372.657349, 0.00447966438, 0.00262329541],
                   [377.85199, 0.00442482904, 0.00250664074],
                   [383.119019, 0.00436647702, 0.00239126547],
                   [388.459473, 0.00430281041, 0.00227887928],
                   [393.87439, 0.00423387811, 0.0021717737],
                   [399.364807, 0.00416188268, 0.002069704],
                   [404.931732, 0.00408786861, 0.00197242829],
                   [410.576233, 0.00401234813, 0.00187972386],
                   [416.299469, 0.00393573102, 0.00179137732],
                   [422.102448, 0.00385836465, 0.00170718518],
                   [427.986359, 0.00378055475, 0.00162694557],
                   [433.95224, 0.00370253343, 0.00155047642],
                   [440.001282, 0.00362432352, 0.00147760636],
                   [446.134674, 0.00354639487, 0.00140816043],
                   [452.353577, 0.00346889952, 0.00134197518],
                   [458.659119, 0.00339197717, 0.00127890427],
                   [465.052582, 0.00331575656, 0.00121879845],
                   [471.535156, 0.00324035808, 0.00116151478],
                   [478.108093, 0.00316590234, 0.00110692543],
                   [484.772644, 0.00309254765, 0.0010548631],
                   [491.530151, 0.00302007049, 0.00100467016],
                   [498.381775, 0.00294840685, 0.000956783828],
                   [505.328979, 0.00287768804, 0.00091117766],
                   [512.372986, 0.00280803046, 0.000867746712],
                   [519.515198, 0.00273949513, 0.000826387026],
                   [526.756958, 0.00267212675, 0.000786996388],
                   [534.09967, 0.00260591786, 0.00074948289],
                   [541.544739, 0.00254090154, 0.000713759277],
                   [549.093506, 0.00247713528, 0.000679738005],
                   [556.74762, 0.0024146284, 0.000647338049],
                   [564.508362, 0.00235338602, 0.000616481761],
                   [572.377319, 0.00229340931, 0.00058709539],
                   [580.355957, 0.00223469967, 0.000559112639],
                   [588.445801, 0.00217724056, 0.000532464532],
                   [596.648438, 0.00212101266, 0.000507084187],
                   [604.965332, 0.00206603808, 0.000482913136],
                   [613.398315, 0.00201230333, 0.000459895236],
                   [621.948669, 0.00195979909, 0.000437974581],
                   [630.618347, 0.00190850906, 0.000417097646],
                   [639.408813, 0.0018584166, 0.000397217169],
                   [648.321838, 0.00180950284, 0.00037828277],
                   [657.35907, 0.00176171726, 0.0003602535],
                   [666.522278, 0.001715024, 0.000343080756],
                   [675.813293, 0.00166940549, 0.000326919166],
                   [685.233704, 0.00162501493, 0.00031174178],
                   [694.785522, 0.00158209493, 0.000297418475],
                   [704.470398, 0.00154073176, 0.000283633446],
                   [714.290344, 0.00150059152, 0.000269864278],
                   [724.247192, 0.00146094058, 0.000256294821],
                   [734.342834, 0.00142202014, 0.000243409158],
                   [744.579163, 0.00138394663, 0.000231171944],
                   [754.958191, 0.00134674879, 0.000219549765],
                   [765.481934, 0.00131043477, 0.000208510639],
                   [776.152344, 0.001275004, 0.000198024572],
                   [786.971436, 0.00124044856, 0.000188063146],
                   [797.941406, 0.00120675145, 0.000178600341],
                   [809.06427, 0.00117389904, 0.000169612278],
                   [820.342224, 0.00114188821, 0.000161077493],
                   [831.777283, 0.00111070718, 0.000152973327],
                   [843.371826, 0.0010803428, 0.000145269572],
                   [855.127991, 0.00105077541, 0.000137940006],
                   [867.047974, 0.00102197856, 0.000130966233],
                   [879.134155, 0.000993925845, 0.000124332888],
                   [891.388855, 0.000966600259, 0.000118036689],
                   [903.814331, 0.000940000056, 0.000112059555],
                   [916.413025, 0.000914111617, 0.000106385436],
                   [929.187317, 0.000888917944, 0.000100988836],
                   [942.139648, 0.000864397094, 9.5856034E-05],
                   [955.272583, 0.000840527995, 9.09816808E-05],
                   [968.588562, 0.000817299413, 8.63532259E-05],
                   [982.09021, 0.000794694817, 8.1958482E-05],
                   [995.779968, 0.000772700761, 7.77882888E-05],
                   [1009.66058, 0.00075130508, 7.38308881E-05],
                   [1023.7348, 0.000730501197, 7.00784585E-05],
                   [1038.005, 0.000710278109, 6.65092157E-05],
                   [1052.47424, 0.000690610555, 6.31005823E-05],
                   [1067.14514, 0.000671462796, 5.98473016E-05],
                   [1082.02051, 0.0006528261, 5.67631796E-05],
                   [1097.10339, 0.000634696044, 5.38369859E-05],
                   [1112.39636, 0.00061706081, 5.1060073E-05],
                   [1127.90259, 0.000599907595, 4.84271586E-05],
                   [1143.62488, 0.000583225628, 4.59309995E-05],
                   [1159.56641, 0.000567003619, 4.35634902E-05],
                   [1175.73022, 0.000551229576, 4.13176313E-05],
                   [1192.11926, 0.000535892323, 3.91881331E-05],
                   [1208.73682, 0.000520981615, 3.71681563E-05],
                   [1225.58594, 0.000506486278, 3.52519201E-05],
                   [1242.66992, 0.000492396881, 3.34295801E-05],
                   [1259.99194, 0.000478700473, 3.16952901E-05],
                   [1277.55554, 0.000465381367, 3.00440715E-05],
                   [1295.36401, 0.000452425331, 2.84728012E-05],
                   [1313.42078, 0.000439824653, 2.69841275E-05],
                   [1331.72913, 0.000427572668, 2.55732375E-05],
                   [1350.29272, 0.000415660295, 2.42358365E-05],
                   [1369.11511, 0.00040407863, 2.29684665E-05],
                   [1388.19983, 0.000392818998, 2.17674788E-05],
                   [1407.55054, 0.000381873193, 2.06292571E-05],
                   [1427.17102, 0.00037123292, 1.95504381E-05],
                   [1447.06506, 0.000360889477, 1.85279787E-05],
                   [1467.23621, 0.000350836141, 1.75586447E-05],
                   [1487.68884, 0.000341063336, 1.66390582E-05],
                   [1508.42639, 0.000331564253, 1.57650538E-05],
                   [1529.453, 0.000322329026, 1.49358902E-05],
                   [1550.77271, 0.00031335064, 1.41501268E-05],
                   [1572.38977, 0.000304622838, 1.34056381E-05],
                   [1594.30786, 0.000296138867, 1.27003223E-05],
                   [1616.53174, 0.000287891686, 1.20321183E-05],
                   [1639.06531, 0.000279875589, 1.13990327E-05],
                   [1661.91296, 0.000272083591, 1.07992964E-05],
                   [1685.0791, 0.000264510105, 1.02311487E-05],
                   [1708.56824, 0.000257149106, 9.69295706E-06],
                   [1732.38477, 0.000249994773, 9.18236401E-06],
                   [1756.53333, 0.00024304098, 8.69691848E-06],
                   [1781.01831, 0.000236280321, 8.23648861E-06],
                   [1805.84485, 0.000229708559, 7.79990569E-06],
                   [1831.01721, 0.00022332005, 7.38646349E-06],
                   [1856.54065, 0.000217110079, 6.99498378E-06],
                   [1882.41992, 0.000211073871, 6.62427465E-06],
                   [1908.65979, 0.000205206452, 6.2732106E-06],
                   [1935.2655, 0.000199502902, 5.94075709E-06],
                   [1962.24194, 0.000193958971, 5.62593459E-06],
                   [1989.59473, 0.00018857028, 5.32775766E-06],
                   [2017.32861, 0.000183332624, 5.04669924E-06],
                   [2045.44897, 0.000178242597, 4.77899994E-06],
                   [2073.96143, 0.000173294582, 4.52482618E-06],
                   [2102.87134, 0.000168484359, 4.28406111E-06],
                   [2132.18433, 0.000163808494, 4.05598757E-06],
                   [2161.90576, 0.000159263174, 3.83993302E-06],
                   [2192.0415, 0.000154844951, 3.63529489E-06],
                   [2222.59741, 0.000150550215, 3.44141426E-06],
                   [2253.57935, 0.000146375416, 3.25780957E-06],
                   [2284.99292, 0.000142317003, 3.08390986E-06],
                   [2316.84448, 0.000138371906, 2.91921083E-06],
                   [2349.13989, 0.000134537055, 2.76321566E-06],
                   [2381.8855, 0.000130809, 2.61541959E-06],
                   [2415.08789, 0.000127185122, 2.47552134E-06],
                   [2448.75293, 0.000123662321, 2.34303184E-06],
                   [2482.88721, 0.000120237775, 2.21752157E-06],
                   [2517.49707, 0.000116908763, 2.09869904E-06],
                   [2552.58984, 0.000113672453, 1.98620091E-06],
                   [2588.17163, 0.000110526351, 1.87965611E-06],
                   [2624.24927, 0.000107468048, 1.77874836E-06],
                   [2660.82983, 0.000104494837, 1.68328586E-06],
                   [2697.92041, 0.000101604579, 1.59278954E-06],
                   [2735.52783, 9.87947351E-05, 1.5071422E-06],
                   [2773.65967, 9.60631296E-05, 1.42606552E-06],
                   [2812.323, 9.34075215E-05, 1.34934305E-06],
                   [2851.52539, 9.08257934E-05, 1.27668375E-06],
                   [2891.27393, 8.83159228E-05, 1.20784171E-06],
                   [2931.57666, 8.58758067E-05, 1.14275485E-06],
                   [2972.44141, 8.35036335E-05, 1.08109725E-06],
                   [3013.87549, 8.1197526E-05, 1.02273907E-06],
                   [3055.88745, 7.8955396E-05, 9.67492269E-07],
                   [3098.48486, 7.67755628E-05, 9.1519604E-07],
                   [3141.67603, 7.46563092E-05, 8.65698155E-07],
                   [3185.46924, 7.25959035E-05, 8.18851163E-07],
                   [3229.8728, 7.05926795E-05, 7.74512159E-07],
                   [3274.89575, 6.8645073E-05, 7.32543413E-07],
                   [3320.54614, 6.6751556E-05, 6.92820095E-07],
                   [3366.83252, 6.49105859E-05, 6.55231645E-07],
                   [3413.7644, 6.31206713E-05, 6.19658749E-07],
                   [3461.35059, 6.13804004E-05, 5.85992382E-07],
                   [3509.59961, 5.96884056E-05, 5.5413409E-07],
                   [3558.52148, 5.80433189E-05, 5.23987012E-07],
                   [3608.12549, 5.64438342E-05, 4.95458437E-07],
                   [3658.4209, 5.48886565E-05, 4.68463497E-07],
                   [3709.41724, 5.33765851E-05, 4.42923692E-07],
                   [3761.12451, 5.19063578E-05, 4.18758674E-07],
                   [3813.55249, 5.04768432E-05, 3.95891988E-07],
                   [3866.71143, 4.90869315E-05, 3.74258406E-07],
                   [3920.61133, 4.77354879E-05, 3.53795855E-07],
                   [3975.26221, 4.64213772E-05, 3.34442205E-07],
                   [4030.67554, 4.51436681E-05, 3.16223549E-07],
                   [4086.86084, 4.39013602E-05, 2.9890586E-07],
                   [4143.82959, 4.26933875E-05, 2.8251489E-07],
                   [4201.59229, 4.15188078E-05, 2.67017469E-07],
                   [4260.16016, 4.03766826E-05, 2.52364202E-07],
                   [4319.54443, 3.92661204E-05, 2.38507027E-07],
                   [4379.75635, 3.81862374E-05, 2.25407334E-07],
                   [4440.80811, 3.71361893E-05, 2.13022631E-07],
                   [4502.71045, 3.61151651E-05, 2.01310783E-07],
                   [4565.47559, 3.51223352E-05, 1.90237202E-07],
                   [4629.11572, 3.41569248E-05, 1.79767E-07],
                   [4693.64355, 3.32181589E-05, 1.69868926E-07],
                   [4759.07031, 3.23053027E-05, 1.6051375E-07],
                   [4825.40918, 3.14176177E-05, 1.51670577E-07],
                   [4892.67285, 3.05544781E-05, 1.43311155E-07],
                   [4960.87402, 2.97151273E-05, 1.35408811E-07],
                   [5030.02588, 2.88989067E-05, 1.27939344E-07],
                   [5100.14209, 2.81051944E-05, 1.20877587E-07],
                   [5171.23486, 2.73333881E-05, 1.14204333E-07],
                   [5243.31885, 2.65828712E-05, 1.07897982E-07],
                   [5316.4082, 2.58530326E-05, 1.0193579E-07],
                   [5390.51611, 2.51432666E-05, 9.63005675E-08],
                   [5465.65723, 2.44530875E-05, 9.09736357E-08],
                   [5541.84521, 2.37819422E-05, 8.59403215E-08],
                   [5619.09521, 2.31292797E-05, 8.1186954E-08],
                   [5697.42285, 2.24945798E-05, 7.66948105E-08],
                   [5776.8418, 2.18773494E-05, 7.24481666E-08],
                   [5857.36768, 2.12771138E-05, 6.84348578E-08],
                   [5939.01611, 2.06934146E-05, 6.46425278E-08],
                   [6021.80273, 2.0125759E-05, 6.10611011E-08],
                   [6105.74316, 1.95737484E-05, 5.76774468E-08],
                   [6190.85449, 1.90369228E-05, 5.44787575E-08],
                   [6277.15186, 1.85148674E-05, 5.1456734E-08],
                   [6364.65137, 1.80071729E-05, 4.86023346E-08],
                   [6453.37158, 1.75134319E-05, 4.59058533E-08],
                   [6543.32812, 1.70332569E-05, 4.33585967E-08],
                   [6634.53809, 1.65663132E-05, 4.09525462E-08],
                   [6727.02051, 1.6112208E-05, 3.86794667E-08],
                   [6820.7915, 1.56705719E-05, 3.65326507E-08],
                   [6915.86914, 1.52410757E-05, 3.45050104E-08],
                   [7012.27295, 1.48233839E-05, 3.25896004E-08],
                   [7110.02002, 1.44171681E-05, 3.07804484E-08],
                   [7209.12988, 1.40221055E-05, 2.90721545E-08],
                   [7309.62109, 1.36378994E-05, 2.7458718E-08],
                   [7411.51318, 1.3264259E-05, 2.59353801E-08],
                   [7514.82617, 1.29008686E-05, 2.44963534E-08],
                   [7619.57861, 1.25474644E-05, 2.31375861E-08],
                   [7725.79102, 1.220377E-05, 2.1854758E-08],
                   [7833.48438, 1.18695116E-05, 2.06433981E-08],
                   [7942.67969, 1.15444209E-05, 1.94994776E-08],
                   [8053.396, 1.12282487E-05, 1.84191435E-08],
                   [8165.65625, 1.09207658E-05, 1.739879E-08],
                   [8279.48047, 1.06217194E-05, 1.6435429E-08],
                   [8394.89258, 1.03308812E-05, 1.55258419E-08],
                   [8511.91211, 1.00480165E-05, 1.46671404E-08],
                   [8630.56348, 9.77291347E-06, 1.38565897E-08],
                   [8750.86914, 9.5053656E-06, 1.3091447E-08],
                   [8872.85156, 9.24514552E-06, 1.23689832E-08],
                   [8996.53418, 8.99207316E-06, 1.16869536E-08],
                   [9121.94141, 8.74593934E-06, 1.10432312E-08],
                   [9249.0957, 8.50655397E-06, 1.0435576E-08],
                   [9378.02344, 8.27372878E-06, 9.86212534E-09],
                   [9508.74805, 8.04728734E-06, 9.32089428E-09],
                   [9641.29492, 7.82705501E-06, 8.80996076E-09],
                   [9775.68848, 7.61286674E-06, 8.32760882E-09],
                   [9911.95703, 7.40453743E-06, 7.87255594E-09],
                   [10050.125, 7.2019302E-06, 7.44280904E-09],
                   [10190.2178, 7.00486817E-06, 7.03701497E-09],
                   [10332.2637, 6.8132108E-06, 6.65401378E-09],
                   [10476.29, 6.62680759E-06, 6.29256292E-09],
                   [10622.3232, 6.44551028E-06, 5.95147576E-09],
                   [10770.3926, 6.26917517E-06, 5.62957458E-09],
                   [10920.5264, 6.09767858E-06, 5.32582156E-09],
                   [11072.7529, 5.93087361E-06, 5.03916064E-09],
                   [11227.1006, 5.76864568E-06, 4.7685953E-09],
                   [11383.6006, 5.61085744E-06, 4.51329019E-09],
                   [11542.2822, 5.45738885E-06, 4.27238644E-09],
                   [11703.1748, 5.30812622E-06, 4.04508471E-09],
                   [11866.3105, 5.16294904E-06, 3.83060117E-09],
                   [12031.7207, 5.02174362E-06, 3.62819419E-09],
                   [12199.4365, 4.88441265E-06, 3.43723383E-09],
                   [12369.4902, 4.75083789E-06, 3.25698468E-09],
                   [12541.9141, 4.62092112E-06, 3.08692338E-09],
                   [12716.7412, 4.4945632E-06, 2.92645619E-09],
                   [12894.0059, 4.37166182E-06, 2.77505352E-09],
                   [13073.7412, 4.25212284E-06, 2.63219002E-09],
                   [13255.9824, 4.13585803E-06, 2.49734833E-09],
                   [13440.7637, 4.02277738E-06, 2.37012654E-09],
                   [13628.1211, 3.91278809E-06, 2.2500477E-09],
                   [13818.0889, 3.80581514E-06, 2.13675677E-09],
                   [14010.7061, 3.70176508E-06, 2.02983075E-09],
                   [14206.0068, 3.60056379E-06, 1.92892169E-09],
                   [14404.0312, 3.50213372E-06, 1.8336942E-09],
                   [14604.8164, 3.40639417E-06, 1.74380921E-09],
                   [14808.3994, 3.31327237E-06, 1.65899994E-09],
                   [15014.8203, 3.22270034E-06, 1.57889923E-09],
                   [15224.1182, 3.13460896E-06, 1.50293022E-09],
                   [15436.335, 3.04892546E-06, 1.43120038E-09],
                   [15651.5098, 2.96558642E-06, 1.36347389E-09],
                   [15869.6816, 2.88452793E-06, 1.29952316E-09],
                   [16090.8965, 2.80568543E-06, 1.23913668E-09],
                   [16315.1953, 2.7290007E-06, 1.18211008E-09],
                   [16542.6191, 2.65441281E-06, 1.12823673E-09],
                   [16773.2148, 2.58186583E-06, 1.07734877E-09],
                   [17007.0254, 2.511302E-06, 1.02927455E-09],
                   [17244.0938, 2.44266926E-06, 9.83850446E-10],
                   [17484.4668, 2.37591371E-06, 9.40932998E-10],
                   [17728.1914, 2.31098306E-06, 9.00376385E-10],
                   [17975.3125, 2.24782934E-06, 8.62032168E-10],
                   [18225.8789, 2.18640162E-06, 8.25794044E-10],
                   [18479.9375, 2.12665236E-06, 7.91529675E-10],
                   [18737.5371, 2.06853861E-06, 7.59125873E-10],
                   [18998.7285, 2.01201328E-06, 7.28479221E-10],
                   [19263.5605, 1.95703365E-06, 6.99488023E-10],
                   [19532.084, 1.90355831E-06, 6.7205902E-10],
                   [19804.3516, 1.85154352E-06, 6.46380893E-10],
                   [20080.4141, 1.8009506E-06, 6.23623486E-10],
                   [20360.3223, 1.75174512E-06, 5.99398475E-10],
                   [20644.1348, 1.70388171E-06, 5.76410308E-10],
                   [20931.9023, 1.65732592E-06, 5.54646551E-10],
                   [21223.6816, 1.61204343E-06, 5.34034594E-10],
                   [21519.5293, 1.56799888E-06, 5.1450455E-10],
                   [21819.5, 1.52515793E-06, 4.9599358E-10],
                   [22123.6523, 1.48348761E-06, 4.78440565E-10],
                   [22432.0449, 1.44295768E-06, 4.6179105E-10],
                   [22744.7324, 1.40353552E-06, 4.45991605E-10],
                   [23061.7832, 1.36518986E-06, 4.3099263E-10],
                   [23383.252, 1.32789307E-06, 4.16746915E-10],
                   [23709.2012, 1.29161538E-06, 4.03210743E-10],
                   [24039.6953, 1.25632812E-06, 3.90343063E-10],
                   [24374.7949, 1.22200629E-06, 3.7810502E-10],
                   [24714.5664, 1.18862363E-06, 3.6646175E-10],
                   [25059.0742, 1.15615171E-06, 3.55378782E-10],
                   [25408.3848, 1.12456758E-06, 3.44822337E-10],
                   [25762.5645, 1.09384678E-06, 3.34762995E-10],
                   [26121.6797, 1.06396533E-06, 3.25172778E-10],
                   [26485.8008, 1.03490061E-06, 3.16024734E-10],
                   [26855., 1.00663067E-06, 3.07294995E-10],
                   [27229.3438, 9.79131642E-07, 2.98958969E-10],
                   [27608.9062, 9.52385108E-07, 2.9099545E-10],
                   [27993.7598, 9.26369353E-07, 2.83382817E-10],
                   [28383.9766, 9.01065164E-07, 2.7610178E-10],
                   [28779.6348, 8.76451907E-07, 2.69133937E-10],
                   [29180.8066, 8.52510766E-07, 2.62461969E-10],
                   [29587.5723, 8.29224177E-07, 2.5606961E-10],
                   [30000.0059, 8.06572757E-07, 2.49941956E-10]]),
'Ni': numpy.array([[30.,        0.289391518, 0.255935937],
                   [30.4181843, 0.283550143, 0.247024685],
                   [30.8421955, 0.277632445, 0.238550931],
                   [31.2721214, 0.271730721, 0.230397359],
                   [31.7080383, 0.265782893, 0.222523361],
                   [32.150032,  0.259795099, 0.214918002],
                   [32.5981827, 0.253786743, 0.207572505],
                   [33.0525818, 0.247762755, 0.200478226],
                   [33.5133171, 0.241722479, 0.193626344],
                   [33.9804764, 0.235655263, 0.187008545],
                   [34.4541473, 0.229549646, 0.180630118],
                   [34.9344177, 0.223429218, 0.174565986],
                   [35.4213829, 0.217361361, 0.168835148],
                   [35.9151382, 0.21138519,  0.163297653],
                   [36.4157791, 0.205465436, 0.157941788],
                   [36.9233932, 0.199576691, 0.152761728],
                   [37.4380875, 0.193692252, 0.147751436],
                   [37.9599533, 0.187764317, 0.142905459],
                   [38.4890938, 0.181701034, 0.138220072],
                   [39.0256119, 0.175653815, 0.134396493],
                   [39.5696068, 0.169932306, 0.130710587],
                   [40.1211853, 0.164455697, 0.127131537],
                   [40.6804543, 0.15912804,  0.123650469],
                   [41.2475166, 0.15386951,  0.120264746],
                   [41.8224831, 0.148613974, 0.116971649],
                   [42.405468,  0.143301502, 0.113791965],
                   [42.9965744, 0.138023585, 0.111158095],
                   [43.5959282, 0.133061156, 0.10880173],
                   [44.2036324, 0.128353685, 0.106521986],
                   [44.8198051, 0.123830356, 0.104290262],
                   [45.4445686, 0.11944218,  0.102105275],
                   [46.0780411, 0.115161665, 0.0999658927],
                   [46.7203445, 0.110955194, 0.097871393],
                   [47.3715973, 0.106665745, 0.0958208665],
                   [48.0319328, 0.102341674, 0.093954213],
                   [48.7014732, 0.0982101262, 0.0924816355],
                   [49.3803444, 0.0943234786, 0.0911316276],
                   [50.0686798, 0.0906371623, 0.0898014084],
                   [50.7666092, 0.0870879367, 0.0884906724],
                   [51.4742699, 0.083640568, 0.0871989429],
                   [52.1917915, 0.0802725405, 0.0859263316],
                   [52.9193192, 0.0769695267, 0.0847320333],
                   [53.6569862, 0.0737565085, 0.0835723206],
                   [54.4049339, 0.0706157759, 0.0824322253],
                   [55.163311, 0.0675295219, 0.0813076645],
                   [55.9322586, 0.0644851029, 0.0801983997],
                   [56.7119217, 0.0614900254, 0.0791007057],
                   [57.5024567, 0.0585823394, 0.0779942572],
                   [58.3040123, 0.0554986931, 0.0765965953],
                   [59.1167336, 0.0521469302, 0.075224109],
                   [59.9407921, 0.0484439544, 0.0738761649],
                   [60.7763329, 0.0440191142, 0.0727770701],
                   [61.6235237, 0.0391687974, 0.0723607689],
                   [62.4825172, 0.03438228, 0.072707206],
                   [63.3534927, 0.0294972192, 0.0730549842],
                   [64.2366028, 0.0236772578, 0.0734045655],
                   [65.1320343, 0.0165002402, 0.0777895227],
                   [66.0399323, 0.0117463544, 0.0847868398],
                   [66.960495, 0.00987932831, 0.0931128711],
                   [67.8938904, 0.0116074476, 0.102256],
                   [68.8402939, 0.0167771485, 0.109615855],
                   [69.7998886, 0.0233755093, 0.110243991],
                   [70.7728577, 0.0282125212, 0.110447362],
                   [71.7593994, 0.0322385468, 0.110436641],
                   [72.7596817, 0.0359261334, 0.109006427],
                   [73.7739182, 0.0387002826, 0.107248016],
                   [74.8022842, 0.0408328287, 0.105517901],
                   [75.844986, 0.0427458398, 0.103815667],
                   [76.9022217, 0.0445707515, 0.10206151],
                   [77.9741974, 0.0462153517, 0.0999360681],
                   [79.0611115, 0.0475147702, 0.0976980776],
                   [80.1631851, 0.0485698096, 0.0955101475],
                   [81.2806168, 0.0494793244, 0.0933713615],
                   [82.4136276, 0.0503514074, 0.0912803859],
                   [83.5624237, 0.0512219444, 0.0890456066],
                   [84.7272415, 0.0519793704, 0.0865214095],
                   [85.9082947, 0.0523611307, 0.0839744955],
                   [87.1058121, 0.052514486, 0.0815025792],
                   [88.320015, 0.0525064804, 0.0791034475],
                   [89.5511475, 0.0523719415, 0.0767749175],
                   [90.7994385, 0.0521016344, 0.0745149255],
                   [92.0651398, 0.0516860187, 0.0723530725],
                   [93.3484802, 0.0511729494, 0.0703384802],
                   [94.649704, 0.0506774187, 0.0684967414],
                   [95.9690704, 0.0502185188, 0.0667032674],
                   [97.3068314, 0.0497461595, 0.0649567321],
                   [98.6632385, 0.0492598414, 0.0632559508],
                   [100.038544, 0.0487601757, 0.0615997352],
                   [101.433029, 0.0482484251, 0.0599868335],
                   [102.846954, 0.047726471, 0.058416117],
                   [104.280579, 0.0471968912, 0.0568865836],
                   [105.734192, 0.0466640331, 0.0553971305],
                   [107.208076, 0.0461425632, 0.0539466441],
                   [108.702492, 0.045611959, 0.0524888523],
                   [110.217751, 0.0450631753, 0.0510525815],
                   [111.754128, 0.0444896147, 0.0496515222],
                   [113.311913, 0.0438963175, 0.048288919],
                   [114.891418, 0.0432943441, 0.0469637029],
                   [116.492943, 0.0426855981, 0.0456748828],
                   [118.116798, 0.0420747474, 0.0444214083],
                   [119.763275, 0.0414663367, 0.0432023555],
                   [121.432716, 0.0408641286, 0.0419884101],
                   [123.125427, 0.0402431302, 0.0407907926],
                   [124.841721, 0.0395979062, 0.0396221802],
                   [126.581955, 0.0389375351, 0.038487006],
                   [128.346436, 0.0382644124, 0.0373843126],
                   [130.135513, 0.03757561,   0.0363132954],
                   [131.949539, 0.0368532836, 0.0352729335],
                   [133.788834, 0.0360519737, 0.0342623517],
                   [135.653778, 0.0352505706, 0.0334134996],
                   [137.544724, 0.0345164761, 0.0326812677],
                   [139.462021, 0.0338633843, 0.0319747701],
                   [141.406052, 0.0332573764, 0.0312834829],
                   [143.377167, 0.0326882228, 0.03060719],
                   [145.375778, 0.032153111,  0.0299454611],
                   [147.402222, 0.0316459648, 0.0292982068],
                   [149.45694,  0.0311666038, 0.0286648888],
                   [151.540268, 0.0307162832, 0.0280451626],
                   [153.652664, 0.0302973129, 0.0274388399],
                   [155.794495, 0.0299260598, 0.0268420316],
                   [157.966202, 0.0296573769, 0.0262385532],
                   [160.168167, 0.0293836892, 0.0254563894],
                   [162.400818, 0.0290056821, 0.0246975627],
                   [164.664597, 0.0285950657, 0.0239613894],
                   [166.95993,  0.0281715542, 0.02324716],
                   [169.287262, 0.0277397484, 0.0225542188],
                   [171.647034, 0.0273028463, 0.0218819603],
                   [174.039703, 0.0268631615, 0.0212297607],
                   [176.465729, 0.0264229849, 0.0205969904],
                   [178.925552, 0.0259836633, 0.0199829657],
                   [181.419678, 0.0255469456, 0.0193873663],
                   [183.948563, 0.0251139347, 0.0188094676],
                   [186.512726, 0.024685422,  0.0182488039],
                   [189.112595, 0.0242623352, 0.0177049302],
                   [191.748734, 0.0238457974, 0.0171771478],
                   [194.4216,   0.023436768,  0.0166651346],
                   [197.131729, 0.0230371021, 0.0161684118],
                   [199.879639, 0.0226561818, 0.0156864766],
                   [202.665863, 0.0222977828, 0.0152188968],
                   [205.490906, 0.021951858,  0.0147316158],
                   [208.355347, 0.0215994157, 0.0142180482],
                   [211.259705, 0.0212251246, 0.0137134716],
                   [214.204544, 0.0208388455, 0.0132268574],
                   [217.190445, 0.0204466768, 0.0127574764],
                   [220.217957, 0.0200533774, 0.0123047475],
                   [223.287674, 0.0196604431, 0.0118681071],
                   [226.400192, 0.0192691684, 0.0114469593],
                   [229.556091, 0.0188804977, 0.0110407444],
                   [232.755981, 0.0184950661, 0.0106489398],
                   [236.000458, 0.0181134194, 0.0102710519],
                   [239.290176, 0.0177358091, 0.0099065695],
                   [242.625763, 0.0173629504, 0.00955503061],
                   [246.007828, 0.0169952419, 0.00921595655],
                   [249.437057, 0.0166329686, 0.00888890494],
                   [252.914062, 0.016276367,  0.00857347343],
                   [256.439545, 0.0159256514, 0.00826924015],
                   [260.01416, 0.0155810593,  0.00797578599],
                   [263.638641, 0.0152428234, 0.00769276125],
                   [267.313599, 0.0149111683, 0.00741977338],
                   [271.039825, 0.0145866256, 0.00715646427],
                   [274.817963, 0.0142690716, 0.00690250611],
                   [278.648773, 0.0139628258, 0.00665756455],
                   [282.53299, 0.0136692608,  0.00641929731],
                   [286.471375, 0.0133827999, 0.00618153019],
                   [290.4646, 0.0130981728, 0.00593138766],
                   [294.513519, 0.0128065804, 0.00569136301],
                   [298.618896, 0.0125154182, 0.00546105579],
                   [302.781494, 0.0122263562, 0.00524006132],
                   [307.002106, 0.0119403936, 0.00502801174],
                   [311.281525, 0.0116581293, 0.00482455269],
                   [315.620605, 0.0113799265, 0.00462932279],
                   [320.020203, 0.0111060804, 0.00444198772],
                   [324.48111, 0.01083651, 0.00426222663],
                   [329.004181, 0.0105717545, 0.00408975687],
                   [333.590363, 0.0103118848, 0.00392426178],
                   [338.240417, 0.010056993, 0.00376545708],
                   [342.955322, 0.00980715547, 0.00361308036],
                   [347.735901, 0.00956242438, 0.00346687646],
                   [352.58316, 0.0093228044, 0.00332658412],
                   [357.497986, 0.00908838212, 0.00319196633],
                   [362.481323, 0.00885936338, 0.00306279957],
                   [367.534119, 0.00863688346, 0.00293885614],
                   [372.657349, 0.00841941405, 0.00281719235],
                   [377.85199, 0.00820570067, 0.00269805733],
                   [383.119019, 0.00799517054, 0.00258317287],
                   [388.459473, 0.00778776035, 0.00247317832],
                   [393.87439, 0.00758413784, 0.00236787274],
                   [399.364807, 0.00738441804, 0.00226704869],
                   [404.931732, 0.00718885427, 0.00217051595],
                   [410.576233, 0.00699746981, 0.00207809242],
                   [416.299469, 0.00681022555, 0.00198960467],
                   [422.102448, 0.00662709586, 0.00190488866],
                   [427.986359, 0.0064480654, 0.00182377745],
                   [433.95224, 0.00627305778, 0.00174611609],
                   [440.001282, 0.00610196916, 0.00167176512],
                   [446.134674, 0.00593483588, 0.00160058239],
                   [452.353577, 0.00577164022, 0.00153242832],
                   [458.659119, 0.00561233889, 0.00146717776],
                   [465.052582, 0.00545687182, 0.00140470557],
                   [471.535156, 0.00530519336, 0.00134489266],
                   [478.108093, 0.00515729748, 0.00128762715],
                   [484.772644, 0.00501320977, 0.00123279775],
                   [491.530151, 0.00487328274, 0.00118030421],
                   [498.381775, 0.0047377632, 0.00112904655],
                   [505.328979, 0.00460546603, 0.00107748446],
                   [512.372986, 0.00447493093, 0.00102663913],
                   [519.515198, 0.00434563775, 0.000978191267],
                   [526.756958, 0.00421859371, 0.000932029157],
                   [534.09967, 0.00409391336, 0.000888048206],
                   [541.544739, 0.0039716363, 0.000846138922],
                   [549.093506, 0.00385186449, 0.000806209689],
                   [556.74762, 0.00373459095, 0.000768163707],
                   [564.508362, 0.0036197661, 0.000731913722],
                   [572.377319, 0.00350731984, 0.00069737446],
                   [580.355957, 0.00339719257, 0.000664464838],
                   [588.445801, 0.00328925508, 0.00063310843],
                   [596.648438, 0.00318316161, 0.000603231485],
                   [604.965332, 0.0030785983, 0.000574764272],
                   [613.398315, 0.00297621056, 0.000548900571],
                   [621.948669, 0.00287631433, 0.000525104173],
                   [630.618347, 0.00277900277, 0.000502584036],
                   [639.408813, 0.0026841904, 0.000481030205],
                   [648.321838, 0.00259143836, 0.000460401381],
                   [657.35907, 0.00250030798, 0.000440656673],
                   [666.522278, 0.00241082557, 0.000421758479],
                   [675.813293, 0.00232285168, 0.00040367106],
                   [685.233704, 0.00223626685, 0.000386359257],
                   [694.785522, 0.00215096399, 0.000369789341],
                   [704.470398, 0.00206697453, 0.000353930431],
                   [714.290344, 0.00198452082, 0.000338574406],
                   [724.247192, 0.00190278876, 0.000321042258],
                   [734.342834, 0.00181780255, 0.000300530111],
                   [744.579163, 0.00172745076, 0.000280914974],
                   [754.958191, 0.00163522491, 0.000267110445],
                   [765.481934, 0.00154180382, 0.000256385043],
                   [776.152344, 0.00144546514, 0.00024519884],
                   [786.971436, 0.00134415447, 0.000234892723],
                   [797.941406, 0.00123452186, 0.000225362615],
                   [809.06427, 0.00110862532, 0.000216259257],
                   [820.342224, 0.000955841795, 0.000207526595],
                   [831.777283, 0.000743272249, 0.000199147646],
                   [843.371826, 0.000193313841, 0.000191107232],
                   [855.127991, -0.00104756514, 0.00147225091],
                   [867.047974, 0.000617984857, 0.00140489277],
                   [879.134155, 0.000868633855, 0.00134061102],
                   [891.388855, 0.000996751129, 0.00127927063],
                   [903.814331, 0.00107986864, 0.00122073607],
                   [916.413025, 0.00113422342, 0.00116488081],
                   [929.187317, 0.00116921158, 0.00111208064],
                   [942.139648, 0.00118994259, 0.00106189644],
                   [955.272583, 0.00119833124, 0.00101346162],
                   [968.588562, 0.00119371375, 0.000967185013],
                   [982.09021, 0.00117778464, 0.000932851573],
                   [995.779968, 0.00114994799, 0.000919390528],
                   [1009.66058, 0.00116010243, 0.000926382083],
                   [1023.7348, 0.0011883867, 0.000908954709],
                   [1038.005, 0.00120637415, 0.000867784081],
                   [1052.47424, 0.00120494387, 0.000828000426],
                   [1067.14514, 0.0011997727, 0.000789836049],
                   [1082.02051, 0.00119095831, 0.000753417786],
                   [1097.10339, 0.00117939478, 0.000718677649],
                   [1112.39636, 0.00116588466, 0.000685533916],
                   [1127.90259, 0.00115081423, 0.000653919007],
                   [1143.62488, 0.00113448838, 0.000623766158],
                   [1159.56641, 0.00111716043, 0.000595005869],
                   [1175.73022, 0.00109904236, 0.000567569456],
                   [1192.11926, 0.00108027621, 0.000541397952],
                   [1208.73682, 0.00106095464, 0.000516432978],
                   [1225.58594, 0.00104132399, 0.000492617837],
                   [1242.66992, 0.00102147809, 0.000469853316],
                   [1259.99194, 0.00100147165, 0.000448078965],
                   [1277.55554, 0.000981341698, 0.000427244813],
                   [1295.36401, 0.000961125945, 0.000407318497],
                   [1313.42078, 0.000940878876, 0.000388320332],
                   [1331.72913, 0.000920624065, 0.00037020765],
                   [1350.29272, 0.000900471874, 0.000352937845],
                   [1369.11511, 0.00088046788, 0.000336474972],
                   [1388.19983, 0.000860645552, 0.000320781226],
                   [1407.55054, 0.00084103673, 0.000305819296],
                   [1427.17102, 0.000821670343, 0.000291554461],
                   [1447.06506, 0.0008025727, 0.000277953077],
                   [1467.23621, 0.000783781114, 0.000264956354],
                   [1487.68884, 0.000765274395, 0.000252521102],
                   [1508.42639, 0.000747052778, 0.000240520356],
                   [1529.453, 0.000729053223, 0.000229027544],
                   [1550.77271, 0.000711285975, 0.000218075002],
                   [1572.38977, 0.00069379562, 0.000207646852],
                   [1594.30786, 0.000676605559, 0.000197715926],
                   [1616.53174, 0.000659713929, 0.000188259015],
                   [1639.06531, 0.000643129752, 0.000179252907],
                   [1661.91296, 0.000626870955, 0.000170678657],
                   [1685.0791, 0.00061094237, 0.000162515818],
                   [1708.56824, 0.000595355697, 0.000154744834],
                   [1732.38477, 0.000580113207, 0.000147327533],
                   [1756.53333, 0.000565199996, 0.000140222925],
                   [1781.01831, 0.000550590281, 0.00013344569],
                   [1805.84485, 0.000536262698, 0.000126983723],
                   [1831.01721, 0.000522248447, 0.000120834477],
                   [1856.54065, 0.000508546771, 0.000114983173],
                   [1882.41992, 0.000495155226, 0.000109414883],
                   [1908.65979, 0.000482072734, 0.000104116516],
                   [1935.2655, 0.000469296967, 9.90759727E-05],
                   [1962.24194, 0.000456820795, 9.42793558E-05],
                   [1989.59473, 0.00044464157, 8.97131104E-05],
                   [2017.32861, 0.000432765752, 8.5393156E-05],
                   [2045.44897, 0.000421190256, 8.12528524E-05],
                   [2073.96143, 0.0004099012, 7.72992935E-05],
                   [2102.87134, 0.000398884818, 7.3535004E-05],
                   [2132.18433, 0.000388134649, 6.99517041E-05],
                   [2161.90576, 0.000377653574, 6.654147E-05],
                   [2192.0415, 0.000367431581, 6.32930387E-05],
                   [2222.59741, 0.000357467943, 6.02040309E-05],
                   [2253.57935, 0.000347758265, 5.72627832E-05],
                   [2284.99292, 0.000338295999, 5.44626782E-05],
                   [2316.84448, 0.000329075876, 5.17984809E-05],
                   [2349.13989, 0.000320093328, 4.92641011E-05],
                   [2381.8855, 0.000311343581, 4.68521648E-05],
                   [2415.08789, 0.000302823144, 4.4558059E-05],
                   [2448.75293, 0.000294522732, 4.23735146E-05],
                   [2482.88721, 0.000286440161, 4.02951409E-05],
                   [2517.49707, 0.000278571795, 3.83190454E-05],
                   [2552.58984, 0.000270911201, 3.6438385E-05],
                   [2588.17163, 0.000263452937, 3.46485067E-05],
                   [2624.24927, 0.000256193016, 3.29465183E-05],
                   [2660.82983, 0.000249127275, 3.13270466E-05],
                   [2697.92041, 0.00024224908, 2.97867409E-05],
                   [2735.52783, 0.000235555795, 2.83214722E-05],
                   [2773.65967, 0.000229042635, 2.6927697E-05],
                   [2812.323, 0.000222704562, 2.56018684E-05],
                   [2851.52539, 0.000216537519, 2.43408485E-05],
                   [2891.27393, 0.000210537852, 2.31415797E-05],
                   [2931.57666, 0.000204700613, 2.20008042E-05],
                   [2972.44141, 0.000199021131, 2.09158516E-05],
                   [3013.87549, 0.00019349654, 1.98841608E-05],
                   [3055.88745, 0.000188122358, 1.8902927E-05],
                   [3098.48486, 0.000182894844, 1.79696235E-05],
                   [3141.67603, 0.000177810274, 1.7082064E-05],
                   [3185.46924, 0.000172864762, 1.62380893E-05],
                   [3229.8728, 0.000168054539, 1.54354493E-05],
                   [3274.89575, 0.000163375851, 1.46724024E-05],
                   [3320.54614, 0.000158825977, 1.39466929E-05],
                   [3366.83252, 0.000154401219, 1.32565947E-05],
                   [3413.7644, 0.000150098087, 1.26003215E-05],
                   [3461.35059, 0.000145913291, 1.19763681E-05],
                   [3509.59961, 0.00014184395, 1.13831657E-05],
                   [3558.52148, 0.000137887182, 1.08190288E-05],
                   [3608.12549, 0.000134039306, 1.02827953E-05],
                   [3658.4209, 0.000130297558, 9.77281343E-06],
                   [3709.41724, 0.000126659215, 9.28791724E-06],
                   [3761.12451, 0.000123121456, 8.82695076E-06],
                   [3813.55249, 0.000119681506, 8.38874439E-06],
                   [3866.71143, 0.000116336836, 7.97212579E-06],
                   [3920.61133, 0.00011308492, 7.57599946E-06],
                   [3975.26221, 0.000109923021, 7.19951095E-06],
                   [4030.67554, 0.000106848478, 6.84141378E-06],
                   [4086.86084, 0.000103859042, 6.50106404E-06],
                   [4143.82959, 0.000100952391, 6.17744126E-06],
                   [4201.59229, 9.81264238E-05, 5.86986152E-06],
                   [4260.16016, 9.53789058E-05, 5.57750946E-06],
                   [4319.54443, 9.27075525E-05, 5.29952968E-06],
                   [4379.75635, 9.01102467E-05, 5.03523188E-06],
                   [4440.80811, 8.75848782E-05, 4.78411584E-06],
                   [4502.71045, 8.5129519E-05, 4.54525161E-06],
                   [4565.47559, 8.27420808E-05, 4.31829994E-06],
                   [4629.11572, 8.04207157E-05, 4.10254916E-06],
                   [4693.64355, 7.81635681E-05, 3.89743764E-06],
                   [4759.07031, 7.59690083E-05, 3.7024945E-06],
                   [4825.40918, 7.38353701E-05, 3.51721928E-06],
                   [4892.67285, 7.17606163E-05, 3.3411593E-06],
                   [4960.87402, 6.97430442E-05, 3.17370768E-06],
                   [5030.02588, 6.77810822E-05, 3.01452792E-06],
                   [5100.14209, 6.58733261E-05, 2.86331328E-06],
                   [5171.23486, 6.40182843E-05, 2.71960471E-06],
                   [5243.31885, 6.2214378E-05, 2.58298019E-06],
                   [5316.4082, 6.046009E-05, 2.45311185E-06],
                   [5390.51611, 5.87541326E-05, 2.32971843E-06],
                   [5465.65723, 5.70946468E-05, 2.21237656E-06],
                   [5541.84521, 5.54806247E-05, 2.10099211E-06],
                   [5619.09521, 5.39107496E-05, 1.99501937E-06],
                   [5697.42285, 5.23837371E-05, 1.89432251E-06],
                   [5776.8418, 5.08982885E-05, 1.79868277E-06],
                   [5857.36768, 4.94531851E-05, 1.7077939E-06],
                   [5939.01611, 4.80473318E-05, 1.62139406E-06],
                   [6021.80273, 4.66791425E-05, 1.53924191E-06],
                   [6105.74316, 4.53474713E-05, 1.46124239E-06],
                   [6190.85449, 4.40514559E-05, 1.38708083E-06],
                   [6277.15186, 4.27898085E-05, 1.3166167E-06],
                   [6364.65137, 4.15614668E-05, 1.24967767E-06],
                   [6453.37158, 4.03653685E-05, 1.18606658E-06],
                   [6543.32812, 3.92003385E-05, 1.12561702E-06],
                   [6634.53809, 3.80649944E-05, 1.06819118E-06],
                   [6727.02051, 3.69578484E-05, 1.01362127E-06],
                   [6820.7915, 3.58781217E-05, 9.61768933E-07],
                   [6915.86914, 3.48245121E-05, 9.1251502E-07],
                   [7012.27295, 3.37957717E-05, 8.65718391E-07],
                   [7110.02002, 3.27904563E-05, 8.21255639E-07],
                   [7209.12988, 3.18068996E-05, 7.79021207E-07],
                   [7309.62109, 3.08434865E-05, 7.38896802E-07],
                   [7411.51318, 2.98953946E-05, 7.00785677E-07],
                   [7514.82617, 2.89613581E-05, 6.64569143E-07],
                   [7619.57861, 2.8037226E-05, 6.30172053E-07],
                   [7725.79102, 2.71171448E-05, 5.97504823E-07],
                   [7833.48438, 2.61920995E-05, 5.66477581E-07],
                   [7942.67969, 2.52469817E-05, 5.37008361E-07],
                   [8053.396, 2.42549322E-05, 5.09014797E-07],
                   [8165.65625, 2.31093054E-05, 4.82427595E-07],
                   [8279.48047, 2.10075268E-05, 4.57199405E-07],
                   [8394.89258, 1.86434008E-05, 3.3940396E-06],
                   [8511.91211, 2.14598604E-05, 3.23519725E-06],
                   [8630.56348, 2.14166685E-05, 3.08356266E-06],
                   [8750.86914, 2.11697698E-05, 2.93860103E-06],
                   [8872.85156, 2.08371493E-05, 2.80004838E-06],
                   [8996.53418, 2.04567059E-05, 2.66763459E-06],
                   [9121.94141, 2.00498725E-05, 2.54107272E-06],
                   [9249.0957, 1.96298115E-05, 2.42013334E-06],
                   [9378.02344, 1.92022635E-05, 2.30465275E-06],
                   [9508.74805, 1.87713431E-05, 2.19442131E-06],
                   [9641.29492, 1.83399698E-05, 2.0891996E-06],
                   [9775.68848, 1.79102535E-05, 1.98876319E-06],
                   [9911.95703, 1.74836168E-05, 1.89300727E-06],
                   [10050.125, 1.70608037E-05, 1.8015362E-06],
                   [10190.2178, 1.6643653E-05, 1.71429701E-06],
                   [10332.2637, 1.62326978E-05, 1.63109689E-06],
                   [10476.29, 1.58284074E-05, 1.5517669E-06],
                   [10622.3232, 1.54311583E-05, 1.47614173E-06],
                   [10770.3926, 1.5041227E-05, 1.40405143E-06],
                   [10920.5264, 1.46587872E-05, 1.33535286E-06],
                   [11072.7529, 1.42837162E-05, 1.26987084E-06],
                   [11227.1006, 1.39163885E-05, 1.20747166E-06],
                   [11383.6006, 1.35568898E-05, 1.14803265E-06],
                   [11542.2822, 1.32052446E-05, 1.0914199E-06],
                   [11703.1748, 1.28614265E-05, 1.03750858E-06],
                   [11866.3105, 1.25253719E-05, 9.86175678E-07],
                   [12031.7207, 1.21970443E-05, 9.37298125E-07],
                   [12199.4365, 1.18762446E-05, 8.90770991E-07],
                   [12369.4902, 1.15629773E-05, 8.46466776E-07],
                   [12541.9141, 1.12571979E-05, 8.04307831E-07],
                   [12716.7412, 1.09588027E-05, 7.64189281E-07],
                   [12894.0059, 1.06676753E-05, 7.2602063E-07],
                   [13073.7412, 1.03836883E-05, 6.89708202E-07],
                   [13255.9824, 1.01067008E-05, 6.55155588E-07],
                   [13440.7637, 9.83661448E-06, 6.22291907E-07],
                   [13628.1211, 9.5732421E-06, 5.91028652E-07],
                   [13818.0889, 9.31650993E-06, 5.61301533E-07],
                   [14010.7061, 9.06628156E-06, 5.33031312E-07],
                   [14206.0068, 8.82245149E-06, 5.06153469E-07],
                   [14404.0312, 8.58487238E-06, 4.80601898E-07],
                   [14604.8164, 8.3533796E-06, 4.56307959E-07],
                   [14808.3994, 8.12787766E-06, 4.33221544E-07],
                   [15014.8203, 7.90817467E-06, 4.11269951E-07],
                   [15224.1182, 7.6942124E-06, 3.90408729E-07],
                   [15436.335, 7.48583125E-06, 3.70582853E-07],
                   [15651.5098, 7.28289933E-06, 3.5174503E-07],
                   [15869.6816, 7.08530433E-06, 3.33847026E-07],
                   [16090.8965, 6.89292301E-06, 3.16842772E-07],
                   [16315.1953, 6.70561076E-06, 3.00690459E-07],
                   [16542.6191, 6.52323934E-06, 2.85344441E-07],
                   [16773.2148, 6.34570551E-06, 2.70766861E-07],
                   [17007.0254, 6.17289334E-06, 2.56921481E-07],
                   [17244.0938, 6.00469093E-06, 2.43772632E-07],
                   [17484.4668, 5.84098188E-06, 2.31287387E-07],
                   [17728.1914, 5.68165251E-06, 2.19431769E-07],
                   [17975.3125, 5.52659776E-06, 2.08172423E-07],
                   [18225.8789, 5.37568485E-06, 1.97484098E-07],
                   [18479.9375, 5.22883329E-06, 1.87335914E-07],
                   [18737.5371, 5.08593075E-06, 1.77700386E-07],
                   [18998.7285, 4.94687856E-06, 1.68554251E-07],
                   [19263.5605, 4.81158531E-06, 1.59872712E-07],
                   [19532.084, 4.67994914E-06, 1.51632847E-07],
                   [19804.3516, 4.55186E-06, 1.43813224E-07],
                   [20080.4141, 4.42725377E-06, 1.36390483E-07],
                   [20360.3223, 4.30600858E-06, 1.29345722E-07],
                   [20644.1348, 4.18806076E-06, 1.2265977E-07],
                   [20931.9023, 4.07331481E-06, 1.16315881E-07],
                   [21223.6816, 3.96168844E-06, 1.1029703E-07],
                   [21519.5293, 3.85309659E-06, 1.04586334E-07],
                   [21819.5, 3.74745696E-06, 9.91683962E-08],
                   [22123.6523, 3.64470407E-06, 9.4028195E-08],
                   [22432.0449, 3.5447365E-06, 8.91512428E-08],
                   [22744.7324, 3.4475122E-06, 8.4525027E-08],
                   [23061.7832, 3.35293134E-06, 8.01368714E-08],
                   [23383.252, 3.26093141E-06, 7.59746399E-08],
                   [23709.2012, 3.17144804E-06, 7.20269071E-08],
                   [24039.6953, 3.08441167E-06, 6.82827235E-08],
                   [24374.7949, 2.99975636E-06, 6.47315801E-08],
                   [24714.5664, 2.91741594E-06, 6.13638989E-08],
                   [25059.0742, 2.83732834E-06, 5.81702295E-08],
                   [25408.3848, 2.75943762E-06, 5.5141463E-08],
                   [25762.5645, 2.6836808E-06, 5.22694741E-08],
                   [26121.6797, 2.60999718E-06, 4.95462693E-08],
                   [26485.8008, 2.53833196E-06, 4.69641002E-08],
                   [26855.    , 2.46863328E-06, 4.4516149E-08],
                   [27229.3438, 2.40084228E-06, 4.21951221E-08],
                   [27608.9062, 2.33491278E-06, 3.9994422E-08],
                   [27993.7598, 2.27079909E-06, 3.79081158E-08],
                   [28383.9766, 2.20844322E-06, 3.59303449E-08],
                   [28779.6348, 2.14780607E-06, 3.40554713E-08],
                   [29180.8066, 2.08885444E-06, 3.22781943E-08],
                   [29587.5723, 2.03148738E-06, 3.05934442E-08],
                   [30000.0059, 1.97541658E-06, 2.89965385E-08],]),
'Ge' : numpy.array([[30., 0.00746412715, 0.0448890142],
                   [30.4181843, 0.00595638156, 0.054626964],
                   [30.8421955, 0.00843961537, 0.064649187],
                   [31.2721214, 0.0145479031, 0.0694300383],
                   [31.7080383, 0.0201119911, 0.0717813969],
                   [32.150032, 0.0247143302, 0.0729829594],
                   [32.5981827, 0.0300033595, 0.0719562247],
                   [33.0525818, 0.0337366909, 0.0691851228],
                   [33.5133171, 0.035629265, 0.0658273473],
                   [33.9804764, 0.0364880487, 0.0626908764],
                   [34.4541473, 0.0367206857, 0.0598161891],
                   [34.9344177, 0.0364921354, 0.057073541],
                   [35.4213829, 0.0358153023, 0.054476168],
                   [35.9151382, 0.0348861255, 0.0521287061],
                   [36.4157791, 0.0337591134, 0.0499143675],
                   [36.9233932, 0.0323952064, 0.0477941073],
                   [37.4380875, 0.0306861848, 0.0458641313],
                   [37.9599533, 0.0286653452, 0.044312384],
                   [38.4890938, 0.026903905, 0.043294739],
                   [39.0256119, 0.025325546, 0.0423005521],
                   [39.5696068, 0.023750931, 0.0413291343],
                   [40.1211853, 0.0221010745, 0.0404147245],
                   [40.6804543, 0.0204559471, 0.039669428],
                   [41.2475166, 0.0188729037, 0.0390567072],
                   [41.8224831, 0.0173175409, 0.0384534411],
                   [42.405468, 0.0156761054, 0.0378773585],
                   [42.9965744, 0.0137803946, 0.0376656689],
                   [43.5959282, 0.0122494642, 0.037720114],
                   [44.2036324, 0.0109225987, 0.0378079824],
                   [44.8198051, 0.00970301498, 0.0378961228],
                   [45.4445686, 0.00851756148, 0.0379844531],
                   [46.0780411, 0.00734507106, 0.0381585509],
                   [46.7203445, 0.00625048717, 0.0385971367],
                   [47.3715973, 0.00544564659, 0.0391160659],
                   [48.0319328, 0.00492605986, 0.0396421254],
                   [48.7014732, 0.00472767279, 0.0399275646],
                   [49.3803444, 0.00449123606, 0.0399906822],
                   [50.0686798, 0.00414999807, 0.0399591886],
                   [50.7666092, 0.0037753589, 0.0399277322],
                   [51.4742699, 0.00341013959, 0.0398952588],
                   [52.1917915, 0.00306519447, 0.0398563705],
                   [52.9193192, 0.00272500934, 0.0398046859],
                   [53.6569862, 0.00239406223, 0.0397527218],
                   [54.4049339, 0.00207070657, 0.0397008806],
                   [55.163311, 0.00174392061, 0.0396490917],
                   [55.9322586, 0.00142306031, 0.0396291576],
                   [56.7119217, 0.0011363097, 0.0396700986],
                   [57.5024567, 0.000903255364, 0.0397112407],
                   [58.3040123, 0.00071347761, 0.0397525765],
                   [59.1167336, 0.0005585865, 0.0397939496],
                   [59.9407921, 0.000435519178, 0.039835263],
                   [60.7763329, 0.000341158389, 0.0398801938],
                   [61.6235237, 0.000280344801, 0.0399308801],
                   [62.4825172, 0.000259507768, 0.0399860032],
                   [63.3534927, 0.00027766393, 0.040041063],
                   [64.2366028, 0.000340630795, 0.0400963016],
                   [65.1320343, 0.000452831388, 0.0401516072],
                   [66.0399323, 0.000617577985, 0.0402069315],
                   [66.960495, 0.00084663037, 0.0402623937],
                   [67.8938904, 0.00119270338, 0.0403360911],
                   [68.8402939, 0.00167880207, 0.040310964],
                   [69.7998886, 0.00222697319, 0.0399566106],
                   [70.7728577, 0.00259982911, 0.0395302884],
                   [71.7593994, 0.00287018367, 0.039108485],
                   [72.7596817, 0.003100381, 0.0386911817],
                   [73.7739182, 0.00330210384, 0.0382783636],
                   [74.8022842, 0.00348244561, 0.0378699005],
                   [75.844986, 0.00364650972, 0.0374657586],
                   [76.9022217, 0.00379802682, 0.0370659642],
                   [77.9741974, 0.003939969, 0.0366705023],
                   [79.0611115, 0.0040755393, 0.0362792127],
                   [80.1631851, 0.00420675706, 0.0358920768],
                   [81.2806168, 0.00433590636, 0.0355091244],
                   [82.4136276, 0.00446793763, 0.0351302251],
                   [83.5624237, 0.00460189721, 0.0347447656],
                   [84.7272415, 0.00473068608, 0.0343448557],
                   [85.9082947, 0.00484651234, 0.0339470915],
                   [87.1058121, 0.00495414343, 0.0335539281],
                   [88.320015, 0.00505763246, 0.0331653319],
                   [89.5511475, 0.00515786093, 0.0327812582],
                   [90.7994385, 0.00525579276, 0.0324016176],
                   [92.0651398, 0.00535228057, 0.0320263728],
                   [93.3484802, 0.00544817373, 0.0316554718],
                   [94.649704, 0.00554438913, 0.0312888548],
                   [95.9690704, 0.00564278057, 0.0309264939],
                   [97.3068314, 0.00574762002, 0.0305683371],
                   [98.6632385, 0.00586958183, 0.0302051399],
                   [100.038544, 0.00598489307, 0.0298264232],
                   [101.433029, 0.00608654739, 0.0294419434],
                   [102.846954, 0.00617840607, 0.0290623643],
                   [104.280579, 0.0062653455, 0.0286875833],
                   [105.734192, 0.00634898199, 0.0283178613],
                   [107.208076, 0.00643146923, 0.0279526729],
                   [108.702492, 0.00651242537, 0.0275923461],
                   [110.217751, 0.00659254007, 0.0272368155],
                   [111.754128, 0.00667225523, 0.026885787],
                   [113.311913, 0.00675211987, 0.0265391376],
                   [114.891418, 0.0068327426, 0.0261969175],
                   [116.492943, 0.00691458024, 0.0258592013],
                   [118.116798, 0.00700079743, 0.0255259443],
                   [119.763275, 0.00709098019, 0.0251968745],
                   [121.432716, 0.00718665402, 0.0248719305],
                   [123.125427, 0.00729130954, 0.0245512519],
                   [124.841721, 0.00741547998, 0.0242305212],
                   [126.581955, 0.00755574834, 0.0238914378],
                   [128.346436, 0.00767891901, 0.0235053506],
                   [130.135513, 0.00777894445, 0.0231255181],
                   [131.949539, 0.0078658089, 0.0227516908],
                   [133.788834, 0.00794554129, 0.0223839264],
                   [135.653778, 0.0080202762, 0.0220221579],
                   [137.544724, 0.00809166022, 0.0216663275],
                   [139.462021, 0.00816112943, 0.0213162638],
                   [141.406052, 0.00822997, 0.0209717527],
                   [143.377167, 0.00830024667, 0.0206326414],
                   [145.375778, 0.00837578811, 0.020299295],
                   [147.402222, 0.00845837127, 0.0199712589],
                   [149.45694, 0.00855618902, 0.0196485091],
                   [151.540268, 0.00868764333, 0.0193074495],
                   [153.652664, 0.00882508978, 0.0189238042],
                   [155.794495, 0.00891377032, 0.0184993222],
                   [157.966202, 0.00897123758, 0.0180844013],
                   [160.168167, 0.00900930259, 0.0176789071],
                   [162.400818, 0.0090345284, 0.0172824021],
                   [164.664597, 0.00904949103, 0.0168947466],
                   [166.95993, 0.00905623008, 0.0165158026],
                   [169.287262, 0.00905620214, 0.0161453653],
                   [171.647034, 0.00905052945, 0.0157832298],
                   [174.039703, 0.00904028025, 0.0154292565],
                   [176.465729, 0.00902698841, 0.0150831668],
                   [178.925552, 0.00901139621, 0.0147448713],
                   [181.419678, 0.00899437536, 0.0144141559],
                   [183.948563, 0.00897705182, 0.0140908612],
                   [186.512726, 0.00896062329, 0.0137748206],
                   [189.112595, 0.00894683972, 0.0134658935],
                   [191.748734, 0.00893872697, 0.0131638972],
                   [194.4216, 0.00894418545, 0.012868613],
                   [197.131729, 0.00899027195, 0.0125473123],
                   [199.879639, 0.00899908133, 0.0121846432],
                   [202.665863, 0.00897714868, 0.01181952],
                   [205.490906, 0.00893516466, 0.0114653613],
                   [208.355347, 0.00888009556, 0.011121816],
                   [211.259705, 0.00881535653, 0.0107885348],
                   [214.204544, 0.00874274224, 0.0104652764],
                   [217.190445, 0.00866363198, 0.0101516619],
                   [220.217957, 0.00857971888, 0.00984750688],
                   [223.287674, 0.00849183369, 0.00955242477],
                   [226.400192, 0.00840073917, 0.00926619861],
                   [229.556091, 0.00830707513, 0.00898855366],
                   [232.755981, 0.00821136311, 0.00871918164],
                   [236.000458, 0.00811409764, 0.00845790096],
                   [239.290176, 0.00801582355, 0.00820446573],
                   [242.625763, 0.00791698415, 0.00795865059],
                   [246.007828, 0.00781806186, 0.00772018125],
                   [249.437057, 0.00771956146, 0.00748883421],
                   [252.914062, 0.007621984, 0.00726442179],
                   [256.439545, 0.00752591016, 0.00704674888],
                   [260.01416, 0.00743211852, 0.00683561014],
                   [263.638641, 0.00734240143, 0.00663077924],
                   [267.313599, 0.0072655254, 0.00643210392],
                   [271.039825, 0.00719788205, 0.00621870672],
                   [274.817963, 0.00711895898, 0.00599379512],
                   [278.648773, 0.00702540111, 0.00576912891],
                   [282.53299, 0.00692288391, 0.00555287907],
                   [286.471375, 0.00681513967, 0.00534476014],
                   [290.4646, 0.00670376746, 0.00514443638],
                   [294.513519, 0.00658970699, 0.00495160371],
                   [298.618896, 0.00647414476, 0.00476600928],
                   [302.781494, 0.00635767728, 0.00458735414],
                   [307.002106, 0.0062407339, 0.00441541197],
                   [311.281525, 0.00612365501, 0.00424993271],
                   [315.620605, 0.00600674003, 0.00409063045],
                   [320.020203, 0.00589024182, 0.00393730029],
                   [324.48111, 0.00577417389, 0.00378972013],
                   [329.004181, 0.0056589935, 0.00364767248],
                   [333.590363, 0.00554483524, 0.00351095549],
                   [338.240417, 0.00543187, 0.00337935216],
                   [342.955322, 0.00532022677, 0.00325267669],
                   [347.735901, 0.00521002011, 0.00313076051],
                   [352.58316, 0.00510137947, 0.00301341852],
                   [357.497986, 0.00499444362, 0.00290046376],
                   [362.481323, 0.0048895739, 0.00279174768],
                   [367.534119, 0.00478790142, 0.00268591195],
                   [372.657349, 0.00468727294, 0.00258214376],
                   [377.85199, 0.00458674319, 0.00248131179],
                   [383.119019, 0.00448671263, 0.00238441955],
                   [388.459473, 0.00438792538, 0.00229130057],
                   [393.87439, 0.00429049833, 0.00220182817],
                   [399.364807, 0.00419456325, 0.00211584358],
                   [404.931732, 0.00410031015, 0.00203321851],
                   [410.576233, 0.00400784425, 0.00195382163],
                   [416.299469, 0.00391726941, 0.0018775257],
                   [422.102448, 0.00382870785, 0.00180420931],
                   [427.986359, 0.00374258007, 0.00173375336],
                   [433.95224, 0.00366033986, 0.0016660518],
                   [440.001282, 0.00358028035, 0.00159605255],
                   [446.134674, 0.0034988774, 0.00152691267],
                   [452.353577, 0.00341714267, 0.00146036164],
                   [458.659119, 0.00333580817, 0.00139671215],
                   [465.052582, 0.00325530348, 0.00133583613],
                   [471.535156, 0.00317585422, 0.00127761182],
                   [478.108093, 0.0030975854, 0.00122192758],
                   [484.772644, 0.00302049937, 0.00116866722],
                   [491.530151, 0.00294475211, 0.00111772993],
                   [498.381775, 0.00287041161, 0.00106901245],
                   [505.328979, 0.00279749907, 0.00102241791],
                   [512.372986, 0.00272603147, 0.000977855874],
                   [519.515198, 0.00265602209, 0.000935235759],
                   [526.756958, 0.00258748163, 0.000894472178],
                   [534.09967, 0.00252039777, 0.000855486898],
                   [541.544739, 0.00245478493, 0.000818198954],
                   [549.093506, 0.002390682, 0.000782537449],
                   [556.74762, 0.00232811458, 0.000748429622],
                   [564.508362, 0.00226718374, 0.000715808361],
                   [572.377319, 0.00220795721, 0.000684329483],
                   [580.355957, 0.00215027691, 0.000653471099],
                   [588.445801, 0.00209334982, 0.000623407192],
                   [596.648438, 0.00203711679, 0.000594724843],
                   [604.965332, 0.00198199577, 0.000567362586],
                   [613.398315, 0.00192801643, 0.000541259185],
                   [621.948669, 0.00187519717, 0.000516357715],
                   [630.618347, 0.00182354171, 0.000492600957],
                   [639.408813, 0.00177304912, 0.000469937338],
                   [648.321838, 0.00172371813, 0.000448316394],
                   [657.35907, 0.00167550077, 0.0004276908],
                   [666.522278, 0.00162841484, 0.000408013177],
                   [675.813293, 0.00158245489, 0.000389241293],
                   [685.233704, 0.00153760321, 0.000371333357],
                   [694.785522, 0.00149384548, 0.000354248885],
                   [704.470398, 0.00145116902, 0.000337950652],
                   [714.290344, 0.00140955718, 0.000322402542],
                   [724.247192, 0.0013691542, 0.000307569455],
                   [734.342834, 0.00132964901, 0.000293046236],
                   [744.579163, 0.0012909373, 0.000279149244],
                   [754.958191, 0.0012530582, 0.000265904993],
                   [765.481934, 0.00121603825, 0.000253288803],
                   [776.152344, 0.00117987581, 0.000241271206],
                   [786.971436, 0.00114455994, 0.000229824029],
                   [797.941406, 0.00111005583, 0.000218919842],
                   [809.06427, 0.00107634044, 0.000208532772],
                   [820.342224, 0.00104341959, 0.000198638736],
                   [831.777283, 0.00101127324, 0.000189214261],
                   [843.371826, 0.000979881734, 0.00018023669],
                   [855.127991, 0.000949228939, 0.00017168514],
                   [867.047974, 0.000919317419, 0.00016352316],
                   [879.134155, 0.000890201249, 0.000155660833],
                   [891.388855, 0.000861532113, 0.00014795168],
                   [903.814331, 0.000833319966, 0.000140621909],
                   [916.413025, 0.000805601536, 0.000133655121],
                   [929.187317, 0.000778343994, 0.000127033418],
                   [942.139648, 0.000751469401, 0.00012078556],
                   [955.272583, 0.000724979036, 0.000114998758],
                   [968.588562, 0.000699096825, 0.000109783236],
                   [982.09021, 0.000673706701, 0.000104805258],
                   [995.779968, 0.000648699584, 0.000100059042],
                   [1009.66058, 0.00062400609, 9.55334035E-05],
                   [1023.7348, 0.000599571387, 9.1245478E-05],
                   [1038.005, 0.000575321785, 8.71688317E-05],
                   [1052.47424, 0.000551148318, 8.32639198E-05],
                   [1067.14514, 0.000526912801, 7.95241212E-05],
                   [1082.02051, 0.00050232478, 7.59519826E-05],
                   [1097.10339, 0.00047706769, 7.2540679E-05],
                   [1112.39636, 0.000450899504, 6.9282898E-05],
                   [1127.90259, 0.000423290214, 6.61702652E-05],
                   [1143.62488, 0.000393389171, 6.31970615E-05],
                   [1159.56641, 0.000359699974, 6.03577064E-05],
                   [1175.73022, 0.000319304585, 5.76456259E-05],
                   [1192.11926, 0.000265157578, 5.50553959E-05],
                   [1208.73682, 0.000135648108, 5.25816213E-05],
                   [1225.58594, 2.11181632E-05, 0.000338461803],
                   [1242.66992, 0.000250797311, 0.000326134148],
                   [1259.99194, 0.000296794111, 0.000314268022],
                   [1277.55554, 0.000321443193, 0.000302855711],
                   [1295.36401, 0.00033668644, 0.000291877077],
                   [1313.42078, 0.000346486922, 0.000281296525],
                   [1331.72913, 0.000352409552, 0.000271101075],
                   [1350.29272, 0.000356007717, 0.000261274719],
                   [1369.11511, 0.0003578756, 0.000251802587],
                   [1388.19983, 0.000358418591, 0.000242673748],
                   [1407.55054, 0.000357984507, 0.000233875791],
                   [1427.17102, 0.00035672012, 0.000225402633],
                   [1447.06506, 0.00035496059, 0.000217218039],
                   [1467.23621, 0.00035291852, 0.000209133592],
                   [1487.68884, 0.000350736169, 0.000201068891],
                   [1508.42639, 0.000347916299, 0.000192352847],
                   [1529.453, 0.000344317319, 0.000183605545],
                   [1550.77271, 0.000340021623, 0.000175188732],
                   [1572.38977, 0.000335215707, 0.000167157777],
                   [1594.30786, 0.000330074807, 0.000159495772],
                   [1616.53174, 0.000324663037, 0.000152185545],
                   [1639.06531, 0.000319039129, 0.000145207989],
                   [1661.91296, 0.000313283323, 0.000138551768],
                   [1685.0791, 0.000307432696, 0.000132201254],
                   [1708.56824, 0.000301545748, 0.000126141997],
                   [1732.38477, 0.000295646227, 0.000120327211],
                   [1756.53333, 0.000289710646, 0.000114703907],
                   [1781.01831, 0.000283726258, 0.000109314824],
                   [1805.84485, 0.000277698418, 0.000104155064],
                   [1831.01721, 0.000271671248, 9.92377609E-05],
                   [1856.54065, 0.000265668234, 9.4552619E-05],
                   [1882.41992, 0.000259704771, 9.00887026E-05],
                   [1908.65979, 0.000253792532, 8.58361745E-05],
                   [1935.2655, 0.000247941614, 8.1785467E-05],
                   [1962.24194, 0.000242160502, 7.79253314E-05],
                   [1989.59473, 0.000236436201, 7.42458433E-05],
                   [2017.32861, 0.000230833612, 7.07713916E-05],
                   [2045.44897, 0.000225327065, 6.74136245E-05],
                   [2073.96143, 0.000219894617, 6.41922961E-05],
                   [2102.87134, 0.000214538013, 6.11194482E-05],
                   [2132.18433, 0.000209268561, 5.81894419E-05],
                   [2161.90576, 0.000204089127, 5.53963582E-05],
                   [2192.0415, 0.00019900086, 5.27339544E-05],
                   [2222.59741, 0.00019400398, 5.0192979E-05],
                   [2253.57935, 0.000189102691, 4.77723224E-05],
                   [2284.99292, 0.000184298362, 4.54657129E-05],
                   [2316.84448, 0.000179591632, 4.32674569E-05],
                   [2349.13989, 0.000174982255, 4.1172716E-05],
                   [2381.8855, 0.000170469692, 3.91769026E-05],
                   [2415.08789, 0.000166054277, 3.72758477E-05],
                   [2448.75293, 0.000161732052, 3.54633594E-05],
                   [2482.88721, 0.000157505216, 3.37375459E-05],
                   [2517.49707, 0.000153373883, 3.20944346E-05],
                   [2552.58984, 0.000149336993, 3.05297399E-05],
                   [2588.17163, 0.000145393569, 2.90398057E-05],
                   [2624.24927, 0.000141542681, 2.76213268E-05],
                   [2660.82983, 0.000137782772, 2.62707072E-05],
                   [2697.92041, 0.000134110218, 2.49836885E-05],
                   [2735.52783, 0.000130525877, 2.37594286E-05],
                   [2773.65967, 0.000127028819, 2.2593722E-05],
                   [2812.323, 0.000123617167, 2.14844422E-05],
                   [2851.52539, 0.000120289667, 2.04291955E-05],
                   [2891.27393, 0.000117045485, 1.9425006E-05],
                   [2931.57666, 0.000113882816, 1.84690507E-05],
                   [2972.44141, 0.000110798603, 1.75589521E-05],
                   [3013.87549, 0.000107791944, 1.66930949E-05],
                   [3055.88745, 0.000104861843, 1.58695548E-05],
                   [3098.48486, 0.000102006859, 1.50860478E-05],
                   [3141.67603, 9.92254863E-05, 1.43406623E-05],
                   [3185.46924, 9.65160361E-05, 1.3631643E-05],
                   [3229.8728, 9.38768062E-05, 1.29571872E-05],
                   [3274.89575, 9.13062249E-05, 1.23157088E-05],
                   [3320.54614, 8.88026698E-05, 1.1705537E-05],
                   [3366.83252, 8.63650203E-05, 1.11252875E-05],
                   [3413.7644, 8.3991632E-05, 1.05734434E-05],
                   [3461.35059, 8.16809697E-05, 1.00486313E-05],
                   [3509.59961, 7.9431702E-05, 9.54961979E-06],
                   [3558.52148, 7.72424319E-05, 9.07516733E-06],
                   [3608.12549, 7.51116168E-05, 8.62401976E-06],
                   [3658.4209, 7.30374304E-05, 8.19497291E-06],
                   [3709.41724, 7.10189124E-05, 7.7871091E-06],
                   [3761.12451, 6.90547386E-05, 7.39937059E-06],
                   [3813.55249, 6.71435992E-05, 7.0307683E-06],
                   [3866.71143, 6.52841627E-05, 6.68034863E-06],
                   [3920.61133, 6.3475054E-05, 6.34718663E-06],
                   [3975.26221, 6.17149853E-05, 6.03050103E-06],
                   [4030.67554, 6.00025814E-05, 5.72955787E-06],
                   [4086.86084, 5.83368783E-05, 5.44342129E-06],
                   [4143.82959, 5.67166244E-05, 5.17146509E-06],
                   [4201.59229, 5.5140601E-05, 4.91299897E-06],
                   [4260.16016, 5.36076914E-05, 4.66732081E-06],
                   [4319.54443, 5.2116764E-05, 4.43381305E-06],
                   [4379.75635, 5.06666183E-05, 4.21198183E-06],
                   [4440.80811, 4.92563122E-05, 4.0011405E-06],
                   [4502.71045, 4.7884776E-05, 3.80075289E-06],
                   [4565.47559, 4.65508965E-05, 3.61026218E-06],
                   [4629.11572, 4.52537206E-05, 3.4293023E-06],
                   [4693.64355, 4.39923133E-05, 3.25735323E-06],
                   [4759.07031, 4.2765736E-05, 3.09396296E-06],
                   [4825.40918, 4.1572981E-05, 2.93877588E-06],
                   [4892.67285, 4.04131861E-05, 2.79127858E-06],
                   [4960.87402, 3.92854272E-05, 2.65108974E-06],
                   [5030.02588, 3.81887803E-05, 2.51789561E-06],
                   [5100.14209, 3.71225105E-05, 2.39138171E-06],
                   [5171.23486, 3.60857994E-05, 2.27118699E-06],
                   [5243.31885, 3.50777846E-05, 2.15696423E-06],
                   [5316.4082, 3.40976512E-05, 2.04842809E-06],
                   [5390.51611, 3.31445954E-05, 1.94539348E-06],
                   [5465.65723, 3.22180786E-05, 1.84749103E-06],
                   [5541.84521, 3.13172313E-05, 1.75442494E-06],
                   [5619.09521, 3.04413479E-05, 1.66603274E-06],
                   [5697.42285, 2.95897407E-05, 1.58209184E-06],
                   [5776.8418, 2.87617422E-05, 1.50234382E-06],
                   [5857.36768, 2.79567139E-05, 1.42657245E-06],
                   [5939.01611, 2.71740173E-05, 1.35463597E-06],
                   [6021.80273, 2.64130867E-05, 1.28626607E-06],
                   [6105.74316, 2.56731964E-05, 1.2213435E-06],
                   [6190.85449, 2.49537807E-05, 1.15965622E-06],
                   [6277.15186, 2.42542919E-05, 1.10107521E-06],
                   [6364.65137, 2.35742136E-05, 1.04545006E-06],
                   [6453.37158, 2.29130055E-05, 9.92596938E-07],
                   [6543.32812, 2.22701146E-05, 9.42348777E-07],
                   [6634.53809, 2.16449334E-05, 8.94670734E-07],
                   [6727.02051, 2.1037009E-05, 8.49415926E-07],
                   [6820.7915, 2.04459539E-05, 8.06417745E-07],
                   [6915.86914, 1.98712078E-05, 7.65556877E-07],
                   [7012.27295, 1.93122851E-05, 7.26747942E-07],
                   [7110.02002, 1.8768782E-05, 6.89901185E-07],
                   [7209.12988, 1.82402837E-05, 6.54906785E-07],
                   [7309.62109, 1.77262791E-05, 6.21667994E-07],
                   [7411.51318, 1.72263171E-05, 5.90107334E-07],
                   [7514.82617, 1.67400485E-05, 5.60131127E-07],
                   [7619.57861, 1.62671131E-05, 5.3166724E-07],
                   [7725.79102, 1.58070889E-05, 5.04637171E-07],
                   [7833.48438, 1.5359572E-05, 4.7896566E-07],
                   [7942.67969, 1.49242069E-05, 4.54586797E-07],
                   [8053.396, 1.45006552E-05, 4.31436405E-07],
                   [8165.65625, 1.40884267E-05, 4.09453975E-07],
                   [8279.48047, 1.36872568E-05, 3.88577803E-07],
                   [8394.89258, 1.3296758E-05, 3.68756815E-07],
                   [8511.91211, 1.29166301E-05, 3.49932634E-07],
                   [8630.56348, 1.25465194E-05, 3.3205751E-07],
                   [8750.86914, 1.21860639E-05, 3.15087448E-07],
                   [8872.85156, 1.18349417E-05, 2.98973703E-07],
                   [8996.53418, 1.14927252E-05, 2.83671142E-07],
                   [9121.94141, 1.1158907E-05, 2.6914276E-07],
                   [9249.0957, 1.08332715E-05, 2.55347516E-07],
                   [9378.02344, 1.05154249E-05, 2.42250564E-07],
                   [9508.74805, 1.02048998E-05, 2.29815441E-07],
                   [9641.29492, 9.90120407E-06, 2.18009703E-07],
                   [9775.68848, 9.60382931E-06, 2.06803691E-07],
                   [9911.95703, 9.31201703E-06, 1.96161594E-07],
                   [10050.125, 9.02419106E-06, 1.86056837E-07],
                   [10190.2178, 8.73956742E-06, 1.76465406E-07],
                   [10332.2637, 8.45627073E-06, 1.67359332E-07],
                   [10476.29, 8.17132059E-06, 1.58714926E-07],
                   [10622.3232, 7.87931094E-06, 1.50509536E-07],
                   [10770.3926, 7.56865575E-06, 1.42720125E-07],
                   [10920.5264, 7.2078974E-06, 1.35326204E-07],
                   [11072.7529, 6.33033005E-06, 1.28306837E-07],
                   [11227.1006, 6.32421416E-06, 9.25710253E-07],
                   [11383.6006, 6.78617425E-06, 8.81769722E-07],
                   [11542.2822, 6.72949454E-06, 8.39845598E-07],
                   [11703.1748, 6.63036462E-06, 7.99814984E-07],
                   [11866.3105, 6.51212895E-06, 7.6159688E-07],
                   [12031.7207, 6.38375832E-06, 7.2511051E-07],
                   [12199.4365, 6.24914401E-06, 6.90289767E-07],
                   [12369.4902, 6.11159066E-06, 6.57050691E-07],
                   [12541.9141, 5.97297867E-06, 6.25344342E-07],
                   [12716.7412, 5.83428437E-06, 5.95102733E-07],
                   [12894.0059, 5.69620806E-06, 5.66264873E-07],
                   [13073.7412, 5.55927727E-06, 5.38768461E-07],
                   [13255.9824, 5.42388534E-06, 5.125504E-07],
                   [13440.7637, 5.29022418E-06, 4.87559817E-07],
                   [13628.1211, 5.15847614E-06, 4.63734011E-07],
                   [13818.0889, 5.02896046E-06, 4.41035411E-07],
                   [14010.7061, 4.90179582E-06, 4.19407144E-07],
                   [14206.0068, 4.77705635E-06, 3.98803479E-07],
                   [14404.0312, 4.65479161E-06, 3.79179454E-07],
                   [14604.8164, 4.53504163E-06, 3.60488741E-07],
                   [14808.3994, 4.41781322E-06, 3.42694875E-07],
                   [15014.8203, 4.3030609E-06, 3.25744139E-07],
                   [15224.1182, 4.19085382E-06, 3.09606889E-07],
                   [15436.335, 4.08120104E-06, 2.94246547E-07],
                   [15651.5098, 3.97407393E-06, 2.79627017E-07],
                   [15869.6816, 3.86945021E-06, 2.65713709E-07],
                   [16090.8965, 3.76730463E-06, 2.5247536E-07],
                   [16315.1953, 3.6675965E-06, 2.39881302E-07],
                   [16542.6191, 3.57027807E-06, 2.27895683E-07],
                   [16773.2148, 3.47532432E-06, 2.1649366E-07],
                   [17007.0254, 3.38270888E-06, 2.05648419E-07],
                   [17244.0938, 3.29239242E-06, 1.95333683E-07],
                   [17484.4668, 3.20433401E-06, 1.85525806E-07],
                   [17728.1914, 3.11849067E-06, 1.76200132E-07],
                   [17975.3125, 3.03481829E-06, 1.67331649E-07],
                   [18225.8789, 2.95326777E-06, 1.58901415E-07],
                   [18479.9375, 2.87378612E-06, 1.50885413E-07],
                   [18737.5371, 2.79634878E-06, 1.43265609E-07],
                   [18998.7285, 2.72090961E-06, 1.3602353E-07],
                   [19263.5605, 2.64742516E-06, 1.29140446E-07],
                   [19532.084, 2.57585225E-06, 1.22599545E-07],
                   [19804.3516, 2.50614585E-06, 1.16384868E-07],
                   [20080.4141, 2.43825843E-06, 1.1047883E-07],
                   [20360.3223, 2.3721484E-06, 1.04866544E-07],
                   [20644.1348, 2.30777891E-06, 9.95344891E-08],
                   [20931.9023, 2.24510518E-06, 9.44692431E-08],
                   [21223.6816, 2.18409059E-06, 8.96579095E-08],
                   [21519.5293, 2.12469558E-06, 8.50879758E-08],
                   [21819.5, 2.06687992E-06, 8.07478031E-08],
                   [22123.6523, 2.01060561E-06, 7.66254402E-08],
                   [22432.0449, 1.95582265E-06, 7.27102645E-08],
                   [22744.7324, 1.9025066E-06, 6.89923993E-08],
                   [23061.7832, 1.85061845E-06, 6.54625438E-08],
                   [23383.252, 1.80012159E-06, 6.21108356E-08],
                   [23709.2012, 1.75098069E-06, 5.89285456E-08],
                   [24039.6953, 1.70316309E-06, 5.59075701E-08],
                   [24374.7949, 1.65663607E-06, 5.303961E-08],
                   [24714.5664, 1.61135586E-06, 5.0316924E-08],
                   [25059.0742, 1.56730198E-06, 4.77326481E-08],
                   [25408.3848, 1.5244359E-06, 4.52794851E-08],
                   [25762.5645, 1.48273045E-06, 4.29511502E-08],
                   [26121.6797, 1.44215642E-06, 4.07414191E-08],
                   [26485.8008, 1.4026831E-06, 3.8644238E-08],
                   [26855., 1.36428082E-06, 3.66542992E-08],
                   [27229.3438, 1.3269206E-06, 3.47658329E-08],
                   [27608.9062, 1.29057366E-06, 3.29737908E-08],
                   [27993.7598, 1.2552166E-06, 3.1273359E-08],
                   [28383.9766, 1.2208227E-06, 2.96600327E-08],
                   [28779.6348, 1.18736727E-06, 2.8129362E-08],
                   [29180.8066, 1.15484568E-06, 2.66771636E-08],
                   [29587.5723, 1.1232006E-06, 2.52994585E-08],
                   [30000.0059, 1.09215068E-06, 2.39925413E-08]]),
'SiO2': numpy.array([[30., 0.111903027, 0.163769349],
                   [30.4181843, 0.11088752, 0.159944609],
                   [30.8421955, 0.109864555, 0.156209186],
                   [31.2721214, 0.108831093, 0.15256165],
                   [31.7080383, 0.10780108, 0.149009123],
                   [32.150032, 0.106787689, 0.145562217],
                   [32.5981827, 0.105798461, 0.142197385],
                   [33.0525818, 0.104834497, 0.138910383],
                   [33.5133171, 0.103899404, 0.135699511],
                   [33.9804764, 0.102999806, 0.132562995],
                   [34.4541473, 0.10214483, 0.129499093],
                   [34.9344177, 0.10135448, 0.126506075],
                   [35.4213829, 0.10069453, 0.123582311],
                   [35.9151382, 0.100236863, 0.120726258],
                   [36.4157791, 0.0999948978, 0.117436305],
                   [36.9233932, 0.0995604843, 0.113862418],
                   [37.4380875, 0.0987579003, 0.11029353],
                   [37.9599533, 0.0977891535, 0.106837258],
                   [38.4890938, 0.0967133641, 0.103490189],
                   [39.0256119, 0.0955561772, 0.10024859],
                   [39.5696068, 0.0943513587, 0.0971015617],
                   [40.1211853, 0.0931020007, 0.0940424353],
                   [40.6804543, 0.0918117389, 0.0910755694],
                   [41.2475166, 0.0904899538, 0.0882025361],
                   [41.8224831, 0.089148052, 0.0854202285],
                   [42.405468, 0.0877919272, 0.082726106],
                   [42.9965744, 0.0864252672, 0.0801170319],
                   [43.5959282, 0.085054785, 0.0775904432],
                   [44.2036324, 0.0836858749, 0.0751437992],
                   [44.8198051, 0.0823229328, 0.072774455],
                   [45.4445686, 0.0809705853, 0.0704799965],
                   [46.0780411, 0.0796337426, 0.0682571828],
                   [46.7203445, 0.0783175677, 0.0661017969],
                   [47.3715973, 0.077030547, 0.0640131086],
                   [48.0319328, 0.0758000836, 0.0619905852],
                   [48.7014732, 0.0746731609, 0.0599527322],
                   [49.3803444, 0.0735145137, 0.0578228049],
                   [50.0686798, 0.0722664446, 0.0556867272],
                   [50.7666092, 0.0709436014, 0.0536299162],
                   [51.4742699, 0.0695868805, 0.0516493991],
                   [52.1917915, 0.0682081804, 0.0497423485],
                   [52.9193192, 0.0668135062, 0.0479099005],
                   [53.6569862, 0.0654191226, 0.0461529568],
                   [54.4049339, 0.0640300885, 0.0444627292],
                   [55.163311, 0.0626482591, 0.0428350568],
                   [55.9322586, 0.0612749644, 0.0412675887],
                   [56.7119217, 0.0599117987, 0.0397580825],
                   [57.5024567, 0.0585597567, 0.038304463],
                   [58.3040123, 0.0572151579, 0.0369045995],
                   [59.1167336, 0.0558765866, 0.0355564095],
                   [59.9407921, 0.054554984, 0.0342751741],
                   [60.7763329, 0.0532576554, 0.0330499709],
                   [61.6235237, 0.0519859791, 0.0318715014],
                   [62.4825172, 0.0507382043, 0.0307367332],
                   [63.3534927, 0.049513761, 0.0296441056],
                   [64.2366028, 0.0483132228, 0.0285919681],
                   [65.1320343, 0.0471448191, 0.0275770985],
                   [66.0399323, 0.0459933579, 0.0265810601],
                   [66.960495, 0.0448560193, 0.025615748],
                   [67.8938904, 0.0437352173, 0.0246859938],
                   [68.8402939, 0.0426349826, 0.0237904657],
                   [69.7998886, 0.0415585637, 0.0229256824],
                   [70.7728577, 0.040508166, 0.02207678],
                   [71.7593994, 0.0394575745, 0.0212376714],
                   [72.7596817, 0.0384129845, 0.0204297192],
                   [73.7739182, 0.0373830386, 0.019652646],
                   [74.8022842, 0.0363715068, 0.0188953374],
                   [75.844986, 0.0353690721, 0.0181524456],
                   [76.9022217, 0.0343602076, 0.0174297895],
                   [77.9741974, 0.0333451517, 0.0167373866],
                   [79.0611115, 0.032328058, 0.0160746481],
                   [80.1631851, 0.0313179977, 0.01547103],
                   [81.2806168, 0.0303303562, 0.0148957167],
                   [82.4136276, 0.0293608624, 0.0143417967],
                   [83.5624237, 0.0283993781, 0.0138089135],
                   [84.7272415, 0.0274412557, 0.0133005558],
                   [85.9082947, 0.0264942572, 0.0128258625],
                   [87.1058121, 0.0255618822, 0.0123685403],
                   [88.320015, 0.024630582, 0.0119279707],
                   [89.5511475, 0.0236969106, 0.011503526],
                   [90.7994385, 0.0227537565, 0.0110958964],
                   [92.0651398, 0.0217939746, 0.0107060056],
                   [93.3484802, 0.0208076183, 0.0103330556],
                   [94.649704, 0.0197770335, 0.00997384172],
                   [95.9690704, 0.018654177, 0.00962788332],
                   [97.3068314, 0.0173122771, 0.00929702912],
                   [98.6632385, 0.0153265884, 0.00897610653],
                   [100.038544, 0.0116465399, 0.0112148151],
                   [101.433029, 0.0155063076, 0.0151173295],
                   [102.846954, 0.0159913842, 0.0125088757],
                   [104.280579, 0.015117635, 0.0114487158],
                   [105.734192, 0.0136905145, 0.0116908234],
                   [107.208076, 0.0136526739, 0.0122917769],
                   [108.702492, 0.0135684935, 0.0123634003],
                   [110.217751, 0.0131768566, 0.0122709405],
                   [111.754128, 0.0129454024, 0.0124247205],
                   [113.311913, 0.0127125913, 0.0124088768],
                   [114.891418, 0.01234065, 0.0125110904],
                   [116.492943, 0.0121931443, 0.0128613273],
                   [118.116798, 0.0123453038, 0.0131199984],
                   [119.763275, 0.0125735551, 0.013019301],
                   [121.432716, 0.0125910742, 0.0129200509],
                   [123.125427, 0.0127260052, 0.0127100917],
                   [124.841721, 0.0127631472, 0.0124470927],
                   [126.581955, 0.0126771629, 0.0122093782],
                   [128.346436, 0.0126123205, 0.0120160775],
                   [130.135513, 0.0125977658, 0.011891284],
                   [131.949539, 0.0127365645, 0.0117436973],
                   [133.788834, 0.0129830427, 0.0113785239],
                   [135.653778, 0.0129770702, 0.0106889289],
                   [137.544724, 0.0126764821, 0.0101183355],
                   [139.462021, 0.0123256827, 0.00984706264],
                   [141.406052, 0.0121179437, 0.00961299147],
                   [143.377167, 0.0118258093, 0.00933665223],
                   [145.375778, 0.0115927095, 0.00922377221],
                   [147.402222, 0.0114610512, 0.00905799121],
                   [149.45694, 0.0113437194, 0.00882172212],
                   [151.540268, 0.0111111458, 0.00874357112],
                   [153.652664, 0.0112636611, 0.00841519609],
                   [155.794495, 0.0109090069, 0.0079859877],
                   [157.966202, 0.0106006777, 0.007870025],
                   [160.168167, 0.0104526589, 0.00778653426],
                   [162.400818, 0.0103101181, 0.00775101595],
                   [164.664597, 0.0103027318, 0.00765547529],
                   [166.95993, 0.0102876946, 0.00744729955],
                   [169.287262, 0.0103589296, 0.00730556389],
                   [171.647034, 0.0104541732, 0.00695571443],
                   [174.039703, 0.0103972983, 0.00648997445],
                   [176.465729, 0.010152299, 0.00607057754],
                   [178.925552, 0.00987204164, 0.00577333244],
                   [181.419678, 0.00963890273, 0.00557741709],
                   [183.948563, 0.00946955662, 0.00536923623],
                   [186.512726, 0.00925964955, 0.00516547589],
                   [189.112595, 0.00906803738, 0.0049687596],
                   [191.748734, 0.00888056867, 0.00477658398],
                   [194.4216, 0.00869444199, 0.0045920955],
                   [197.131729, 0.00851002149, 0.00441493699],
                   [199.879639, 0.00832656212, 0.00424481602],
                   [202.665863, 0.00814403128, 0.00408316124],
                   [205.490906, 0.00796427391, 0.00393047603],
                   [208.355347, 0.00778990192, 0.00378517946],
                   [211.259705, 0.007620099, 0.00364545989],
                   [214.204544, 0.00745421555, 0.00351109868],
                   [217.190445, 0.00729434704, 0.00338186673],
                   [220.217957, 0.00714017171, 0.00325615914],
                   [223.287674, 0.00698852353, 0.00312901521],
                   [226.400192, 0.00683659222, 0.00300167198],
                   [229.556091, 0.00668371748, 0.00287958933],
                   [232.755981, 0.00653166603, 0.002762547],
                   [236.000458, 0.00638097478, 0.00265035639],
                   [239.290176, 0.00623114547, 0.0025432657],
                   [242.625763, 0.0060845986, 0.00244204863],
                   [246.007828, 0.00594245689, 0.00234509422],
                   [249.437057, 0.00580383139, 0.00225058012],
                   [252.914062, 0.00566712487, 0.00215762574],
                   [256.439545, 0.00553152943, 0.00206810166],
                   [260.01416, 0.00539772864, 0.00198229798],
                   [263.638641, 0.00526604755, 0.0019000686],
                   [267.313599, 0.00513671013, 0.00182125717],
                   [271.039825, 0.00500981417, 0.00174572261],
                   [274.817963, 0.004885389, 0.00167329749],
                   [278.648773, 0.00476342952, 0.00160383456],
                   [282.53299, 0.0046439385, 0.00153721613],
                   [286.471375, 0.00452690758, 0.00147334358],
                   [290.4646, 0.00441236701, 0.00141213147],
                   [294.513519, 0.00430055335, 0.00135346851],
                   [298.618896, 0.00419128314, 0.00129671954],
                   [302.781494, 0.0040842481, 0.00124176021],
                   [307.002106, 0.00397918839, 0.00118881592],
                   [311.281525, 0.00387603254, 0.00113813614],
                   [315.620605, 0.00377500267, 0.00108962157],
                   [320.020203, 0.00367605826, 0.00104317616],
                   [324.48111, 0.0035792673, 0.000998717267],
                   [329.004181, 0.00348462863, 0.000956157746],
                   [333.590363, 0.00339212385, 0.000915414421],
                   [338.240417, 0.00330174225, 0.000876410923],
                   [342.955322, 0.00321347173, 0.000839072978],
                   [347.735901, 0.00312728784, 0.000803328294],
                   [352.58316, 0.00304319756, 0.000769110397],
                   [357.497986, 0.0029612463, 0.000736351998],
                   [362.481323, 0.00288171577, 0.000704992795],
                   [367.534119, 0.0028043557, 0.000673843781],
                   [372.657349, 0.00272843777, 0.000643064908],
                   [377.85199, 0.00265343813, 0.000613414973],
                   [383.119019, 0.00257953373, 0.000585128786],
                   [388.459473, 0.00250704377, 0.000558131549],
                   [393.87439, 0.00243594614, 0.000532347593],
                   [399.364807, 0.00236622617, 0.00050775113],
                   [404.931732, 0.00229791808, 0.00048428966],
                   [410.576233, 0.00223099976, 0.000461910618],
                   [416.299469, 0.0021654414, 0.000440565665],
                   [422.102448, 0.0021012018, 0.000420208526],
                   [427.986359, 0.00203823275, 0.000400792254],
                   [433.95224, 0.0019764672, 0.000382273545],
                   [440.001282, 0.00191573973, 0.000364609703],
                   [446.134674, 0.00185608654, 0.000347762718],
                   [452.353577, 0.00179743185, 0.00033169589],
                   [458.659119, 0.00173969904, 0.000316343416],
                   [465.052582, 0.00168275251, 0.000301586319],
                   [471.535156, 0.0016263203, 0.000287261384],
                   [478.108093, 0.00157010474, 0.000273616723],
                   [484.772644, 0.00151363423, 0.000260620232],
                   [491.530151, 0.00145668047, 0.00024824182],
                   [498.381775, 0.00139875012, 0.000236451946],
                   [505.328979, 0.00133898016, 0.000225220807],
                   [512.372986, 0.00127595232, 0.00021452253],
                   [519.515198, 0.00120709511, 0.000204333483],
                   [526.756958, 0.00112727913, 0.000194628345],
                   [534.09967, 0.00101855793, 0.000185384764],
                   [541.544739, 0.00048945751, 0.000176580084],
                   [549.093506, 0.000821481459, 0.000583428948],
                   [556.74762, 0.00101521134, 0.000556021114],
                   [564.508362, 0.00105467183, 0.000529915502],
                   [572.377319, 0.00107006961, 0.000505113218],
                   [580.355957, 0.00107373367, 0.000481625],
                   [588.445801, 0.0010702851, 0.000459136325],
                   [596.648438, 0.00106192753, 0.000437651819],
                   [604.965332, 0.00105057482, 0.000417155446],
                   [613.398315, 0.0010370271, 0.00039761691],
                   [621.948669, 0.00102187542, 0.000378983066],
                   [630.618347, 0.00100556994, 0.000361134968],
                   [639.408813, 0.000988412881, 0.000343922322],
                   [648.321838, 0.000970481371, 0.000327267917],
                   [657.35907, 0.000951566442, 0.000311224139],
                   [666.522278, 0.000932041032, 0.00029596602],
                   [675.813293, 0.000912081858, 0.000281808578],
                   [685.233704, 0.000892091484, 0.000268678617],
                   [694.785522, 0.000872371136, 0.000256377447],
                   [704.470398, 0.000853045145, 0.000244687806],
                   [714.290344, 0.000834040751, 0.000233306375],
                   [724.247192, 0.000814990199, 0.000222252915],
                   [734.342834, 0.000796051114, 0.000211730643],
                   [744.579163, 0.000777321111, 0.000201705087],
                   [754.958191, 0.000758836628, 0.000192150852],
                   [765.481934, 0.000740638177, 0.000183034499],
                   [776.152344, 0.000722749741, 0.000174307948],
                   [786.971436, 0.000705156999, 0.000165919395],
                   [797.941406, 0.000687806227, 0.000157840346],
                   [809.06427, 0.000670661218, 0.000150098611],
                   [820.342224, 0.000653766794, 0.000142722463],
                   [831.777283, 0.00063714321, 0.000135708673],
                   [843.371826, 0.000620798208, 0.00012907057],
                   [855.127991, 0.000604751986, 0.000122812955],
                   [867.047974, 0.000589052739, 0.000116913579],
                   [879.134155, 0.000573748723, 0.000111345835],
                   [891.388855, 0.000558826781, 0.00010604327],
                   [903.814331, 0.000544284238, 0.00010096046],
                   [916.413025, 0.000530089426, 9.60919715E-05],
                   [929.187317, 0.000516219588, 9.1386144E-05],
                   [942.139648, 0.00050265051, 8.68472271E-05],
                   [955.272583, 0.000489347905, 8.25122843E-05],
                   [968.588562, 0.000476315414, 7.83760188E-05],
                   [982.09021, 0.000463558099, 7.44466888E-05],
                   [995.779968, 0.000451086118, 7.07162762E-05],
                   [1009.66058, 0.000438902382, 6.7174733E-05],
                   [1023.7348, 0.000427011197, 6.38222918E-05],
                   [1038.005, 0.000415416027, 6.06403046E-05],
                   [1052.47424, 0.000404108694, 5.76058701E-05],
                   [1067.14514, 0.000393065275, 5.47127092E-05],
                   [1082.02051, 0.000382280763, 5.19645509E-05],
                   [1097.10339, 0.000371750648, 4.93738626E-05],
                   [1112.39636, 0.000361495797, 4.6928435E-05],
                   [1127.90259, 0.000351514056, 4.46108061E-05],
                   [1143.62488, 0.00034179361, 4.24077152E-05],
                   [1159.56641, 0.000332325813, 4.03132726E-05],
                   [1175.73022, 0.000323103974, 3.8321883E-05],
                   [1192.11926, 0.000314122415, 3.64287371E-05],
                   [1208.73682, 0.000305372727, 3.46286688E-05],
                   [1225.58594, 0.000296851969, 3.29171853E-05],
                   [1242.66992, 0.000288555108, 3.12876728E-05],
                   [1259.99194, 0.000280475768, 2.97355436E-05],
                   [1277.55554, 0.000272605859, 2.8256547E-05],
                   [1295.36401, 0.000264937524, 2.68474778E-05],
                   [1313.42078, 0.000257462932, 2.55074319E-05],
                   [1331.72913, 0.000250179291, 2.42343722E-05],
                   [1350.29272, 0.000243083428, 2.30246405E-05],
                   [1369.11511, 0.000236170235, 2.18754722E-05],
                   [1388.19983, 0.000229434489, 2.0783571E-05],
                   [1407.55054, 0.000222870862, 1.97456447E-05],
                   [1427.17102, 0.00021647416, 1.87591504E-05],
                   [1447.06506, 0.000210237107, 1.78219216E-05],
                   [1467.23621, 0.000204155644, 1.6930584E-05],
                   [1487.68884, 0.000198223395, 1.60821091E-05],
                   [1508.42639, 0.000192434134, 1.52693083E-05],
                   [1529.453, 0.000186778052, 1.44940977E-05],
                   [1550.77271, 0.000181247713, 1.37579327E-05],
                   [1572.38977, 0.000175837355, 1.30590688E-05],
                   [1594.30786, 0.000170535932, 1.23954615E-05],
                   [1616.53174, 0.000165327918, 1.17655582E-05],
                   [1639.06531, 0.000160206022, 1.11677564E-05],
                   [1661.91296, 0.000155153422, 1.0600208E-05],
                   [1685.0791, 0.000150146981, 1.00614816E-05],
                   [1708.56824, 0.000145154685, 9.5501282E-06],
                   [1732.38477, 0.000140127944, 9.06376226E-06],
                   [1756.53333, 0.000134981645, 8.5987831E-06],
                   [1781.01831, 0.000129393055, 8.15669682E-06],
                   [1805.84485, 0.00012265757, 7.73655847E-06],
                   [1831.01721, 9.80479526E-05, 7.33795059E-06],
                   [1856.54065, 0.000113790855, 2.3466795E-05],
                   [1882.41992, 0.000115265437, 2.23616898E-05],
                   [1908.65979, 0.00011485882, 2.13086114E-05],
                   [1935.2655, 0.000113493224, 2.03051422E-05],
                   [1962.24194, 0.000111697736, 1.93489741E-05],
                   [1989.59473, 0.000109669301, 1.84374694E-05],
                   [2017.32861, 0.000107506996, 1.75686655E-05],
                   [2045.44897, 0.000105258689, 1.67379731E-05],
                   [2073.96143, 0.000102966849, 1.59455358E-05],
                   [2102.87134, 0.000100659374, 1.5183994E-05],
                   [2132.18433, 9.83493737E-05, 1.44558471E-05],
                   [2161.90576, 9.60472971E-05, 1.37612205E-05],
                   [2192.0415, 9.37616423E-05, 1.30982808E-05],
                   [2222.59741, 9.14990742E-05, 1.24655762E-05],
                   [2253.57935, 8.92634052E-05, 1.18625658E-05],
                   [2284.99292, 8.70572476E-05, 1.12871185E-05],
                   [2316.84448, 8.48872878E-05, 1.07382848E-05],
                   [2349.13989, 8.2754661E-05, 1.02152644E-05],
                   [2381.8855, 8.06608441E-05, 9.7166203E-06],
                   [2415.08789, 7.86070668E-05, 9.24124288E-06],
                   [2448.75293, 7.65939767E-05, 8.78842729E-06],
                   [2482.88721, 7.46221922E-05, 8.35688752E-06],
                   [2517.49707, 7.26905346E-05, 7.94562311E-06],
                   [2552.58984, 7.08009538E-05, 7.55414021E-06],
                   [2588.17163, 6.89533554E-05, 7.18110596E-06],
                   [2624.24927, 6.71472808E-05, 6.82588052E-06],
                   [2660.82983, 6.53825482E-05, 6.48780451E-06],
                   [2697.92041, 6.3658932E-05, 6.16593661E-06],
                   [2735.52783, 6.19759448E-05, 5.85923772E-06],
                   [2773.65967, 6.03324588E-05, 5.56751229E-06],
                   [2812.323, 5.87283212E-05, 5.2899095E-06],
                   [2851.52539, 5.71632954E-05, 5.02568173E-06],
                   [2891.27393, 5.56367086E-05, 4.77429057E-06],
                   [2931.57666, 5.41478148E-05, 4.53509256E-06],
                   [2972.44141, 5.2695952E-05, 4.30749742E-06],
                   [3013.87549, 5.12806982E-05, 4.09113545E-06],
                   [3055.88745, 4.99009802E-05, 3.88530998E-06],
                   [3098.48486, 4.85560377E-05, 3.68948918E-06],
                   [3141.67603, 4.72454012E-05, 3.50336813E-06],
                   [3185.46924, 4.59683433E-05, 3.32636728E-06],
                   [3229.8728, 4.47242783E-05, 3.15806528E-06],
                   [3274.89575, 4.35124894E-05, 2.99811859E-06],
                   [3320.54614, 4.23322381E-05, 2.846077E-06],
                   [3366.83252, 4.11825713E-05, 2.70148371E-06],
                   [3413.7644, 4.00628924E-05, 2.56413341E-06],
                   [3461.35059, 3.89726411E-05, 2.43358954E-06],
                   [3509.59961, 3.79111334E-05, 2.30952787E-06],
                   [3558.52148, 3.68776819E-05, 2.19167532E-06],
                   [3608.12549, 3.58716534E-05, 2.07970265E-06],
                   [3658.4209, 3.48923459E-05, 1.97326381E-06],
                   [3709.41724, 3.39390863E-05, 1.87220326E-06],
                   [3761.12451, 3.30111397E-05, 1.77622246E-06],
                   [3813.55249, 3.21080079E-05, 1.6850081E-06],
                   [3866.71143, 3.12291231E-05, 1.59840681E-06],
                   [3920.61133, 3.0373807E-05, 1.516167E-06],
                   [3975.26221, 2.95414757E-05, 1.43806415E-06],
                   [4030.67554, 2.87315797E-05, 1.36388292E-06],
                   [4086.86084, 2.79435408E-05, 1.29349883E-06],
                   [4143.82959, 2.71767476E-05, 1.2266571E-06],
                   [4201.59229, 2.64306418E-05, 1.16323929E-06],
                   [4260.16016, 2.57048123E-05, 1.10305325E-06],
                   [4319.54443, 2.49986879E-05, 1.04592823E-06],
                   [4379.75635, 2.43117338E-05, 9.91720867E-07],
                   [4440.80811, 2.36434644E-05, 9.40284849E-07],
                   [4502.71045, 2.29934394E-05, 8.91470506E-07],
                   [4565.47559, 2.23610605E-05, 8.45158013E-07],
                   [4629.11572, 2.17459419E-05, 8.01220835E-07],
                   [4693.64355, 2.11476345E-05, 7.59522834E-07],
                   [4759.07031, 2.05656961E-05, 7.19973059E-07],
                   [4825.40918, 1.99996339E-05, 6.82464588E-07],
                   [4892.67285, 1.94490785E-05, 6.46886349E-07],
                   [4960.87402, 1.89136554E-05, 6.13139264E-07],
                   [5030.02588, 1.8392886E-05, 5.8113767E-07],
                   [5100.14209, 1.78863338E-05, 5.50758557E-07],
                   [5171.23486, 1.73937406E-05, 5.21958384E-07],
                   [5243.31885, 1.69146424E-05, 4.94657058E-07],
                   [5316.4082, 1.64486937E-05, 4.68764966E-07],
                   [5390.51611, 1.59955853E-05, 4.44211992E-07],
                   [5465.65723, 1.55549515E-05, 4.20932736E-07],
                   [5541.84521, 1.51264176E-05, 3.98855576E-07],
                   [5619.09521, 1.47096825E-05, 3.77922674E-07],
                   [5697.42285, 1.43043826E-05, 3.58078069E-07],
                   [5776.8418, 1.39102667E-05, 3.39265227E-07],
                   [5857.36768, 1.35269956E-05, 3.21432935E-07],
                   [5939.01611, 1.31542811E-05, 3.04528129E-07],
                   [6021.80273, 1.27918465E-05, 2.88499336E-07],
                   [6105.74316, 1.2439411E-05, 2.73307876E-07],
                   [6190.85449, 1.20966988E-05, 2.58910518E-07],
                   [6277.15186, 1.17634199E-05, 2.45266079E-07],
                   [6364.65137, 1.14393488E-05, 2.32335097E-07],
                   [6453.37158, 1.11241734E-05, 2.20065516E-07],
                   [6543.32812, 1.08177155E-05, 2.08451539E-07],
                   [6634.53809, 1.05197232E-05, 1.97444365E-07],
                   [6727.02051, 1.02299582E-05, 1.87008695E-07],
                   [6820.7915, 9.94819402E-06, 1.77120825E-07],
                   [6915.86914, 9.67419419E-06, 1.67753313E-07],
                   [7012.27295, 9.40775499E-06, 1.5887683E-07],
                   [7110.02002, 9.14867542E-06, 1.50465567E-07],
                   [7209.12988, 8.89673174E-06, 1.42496887E-07],
                   [7309.62109, 8.65175934E-06, 1.34947427E-07],
                   [7411.51318, 8.41352812E-06, 1.27793271E-07],
                   [7514.82617, 8.18188801E-06, 1.21015489E-07],
                   [7619.57861, 7.95663982E-06, 1.14595693E-07],
                   [7725.79102, 7.73761894E-06, 1.08513959E-07],
                   [7833.48438, 7.52464211E-06, 1.02752111E-07],
                   [7942.67969, 7.31752471E-06, 9.72948513E-08],
                   [8053.396, 7.11613939E-06, 9.21257026E-08],
                   [8165.65625, 6.92032609E-06, 8.72284147E-08],
                   [8279.48047, 6.72989563E-06, 8.2590077E-08],
                   [8394.89258, 6.54473524E-06, 7.81966349E-08],
                   [8511.91211, 6.36468258E-06, 7.40356114E-08],
                   [8630.56348, 6.18958893E-06, 7.00947993E-08],
                   [8750.86914, 6.01933471E-06, 6.63624391E-08],
                   [8872.85156, 5.85378439E-06, 6.28276737E-08],
                   [8996.53418, 5.69279291E-06, 5.94808789E-08],
                   [9121.94141, 5.53624022E-06, 5.63103413E-08],
                   [9249.0957, 5.38401082E-06, 5.33083906E-08],
                   [9378.02344, 5.23597691E-06, 5.04661486E-08],
                   [9508.74805, 5.09202664E-06, 4.77745381E-08],
                   [9641.29492, 4.95205131E-06, 4.52255584E-08],
                   [9775.68848, 4.81594043E-06, 4.28122497E-08],
                   [9911.95703, 4.68357484E-06, 4.05272296E-08],
                   [10050.125, 4.55486588E-06, 3.8363499E-08],
                   [10190.2178, 4.42970122E-06, 3.63144999E-08],
                   [10332.2637, 4.30798809E-06, 3.43746578E-08],
                   [10476.29, 4.18962691E-06, 3.25380363E-08],
                   [10622.3232, 4.0745299E-06, 3.07992458E-08],
                   [10770.3926, 3.96261339E-06, 2.91532611E-08],
                   [10920.5264, 3.85376279E-06, 2.75947585E-08],
                   [11072.7529, 3.74792239E-06, 2.61197517E-08],
                   [11227.1006, 3.64499874E-06, 2.47230787E-08],
                   [11383.6006, 3.54491272E-06, 2.34010571E-08],
                   [11542.2822, 3.44758223E-06, 2.21496599E-08],
                   [11703.1748, 3.35292816E-06, 2.09650874E-08],
                   [11866.3105, 3.26087638E-06, 1.98437693E-08],
                   [12031.7207, 3.17136232E-06, 1.87823925E-08],
                   [12199.4365, 3.08431868E-06, 1.77778698E-08],
                   [12369.4902, 2.99967337E-06, 1.68270926E-08],
                   [12541.9141, 2.91735455E-06, 1.59270748E-08],
                   [12716.7412, 2.83729787E-06, 1.5075269E-08],
                   [12894.0059, 2.7594433E-06, 1.42691636E-08],
                   [13073.7412, 2.68373401E-06, 1.35062477E-08],
                   [13255.9824, 2.6101086E-06, 1.27842661E-08],
                   [13440.7637, 2.53850567E-06, 1.21008092E-08],
                   [13628.1211, 2.46887589E-06, 1.14541354E-08],
                   [13818.0889, 2.40116356E-06, 1.08421405E-08],
                   [14010.7061, 2.33531136E-06, 1.0262915E-08],
                   [14206.0068, 2.27126793E-06, 9.71485026E-09],
                   [14404.0312, 2.20898369E-06, 9.19627574E-09],
                   [14604.8164, 2.14841384E-06, 8.70542038E-09],
                   [14808.3994, 2.08951087E-06, 8.24104163E-09],
                   [15014.8203, 2.03222544E-06, 7.80153542E-09],
                   [15224.1182, 1.97651616E-06, 7.38538164E-09],
                   [15436.335, 1.92233642E-06, 6.99163127E-09],
                   [15651.5098, 1.86964542E-06, 6.61904842E-09],
                   [15869.6816, 1.81840312E-06, 6.26647312E-09],
                   [16090.8965, 1.76856724E-06, 5.93288219E-09],
                   [16315.1953, 1.72010118E-06, 5.61725422E-09],
                   [16542.6191, 1.67296537E-06, 5.31856381E-09],
                   [16773.2148, 1.6271257E-06, 5.03597963E-09],
                   [17007.0254, 1.58254409E-06, 4.76862771E-09],
                   [17244.0938, 1.53918688E-06, 4.51566429E-09],
                   [17484.4668, 1.49702043E-06, 4.2763264E-09],
                   [17728.1914, 1.45601098E-06, 4.04988532E-09],
                   [17975.3125, 1.41612884E-06, 3.83565446E-09],
                   [18225.8789, 1.37733991E-06, 3.63296615E-09],
                   [18479.9375, 1.33961407E-06, 3.44119155E-09],
                   [18737.5371, 1.30292517E-06, 3.25973892E-09],
                   [18998.7285, 1.26724456E-06, 3.0880829E-09],
                   [19263.5605, 1.23254301E-06, 2.92569191E-09],
                   [19532.084, 1.19879257E-06, 2.7720628E-09],
                   [19804.3516, 1.16596686E-06, 2.62671862E-09],
                   [20080.4141, 1.1340436E-06, 2.48915977E-09],
                   [20360.3223, 1.10299527E-06, 2.35887887E-09],
                   [20644.1348, 1.0727972E-06, 2.23566654E-09],
                   [20931.9023, 1.04342826E-06, 2.11913465E-09],
                   [21223.6816, 1.01486512E-06, 2.00892059E-09],
                   [21519.5293, 9.87084832E-07, 1.90467753E-09],
                   [21819.5, 9.60067041E-07, 1.80608872E-09],
                   [22123.6523, 9.33789806E-07, 1.71283876E-09],
                   [22432.0449, 9.08231584E-07, 1.62461911E-09],
                   [22744.7324, 8.83375833E-07, 1.54118107E-09],
                   [23061.7832, 8.59200497E-07, 1.46225354E-09],
                   [23383.252, 8.35687274E-07, 1.38759004E-09],
                   [23709.2012, 8.12818939E-07, 1.31696265E-09],
                   [24039.6953, 7.90577815E-07, 1.25015076E-09],
                   [24374.7949, 7.68945654E-07, 1.18694243E-09],
                   [24714.5664, 7.47907507E-07, 1.12713539E-09],
                   [25059.0742, 7.27445808E-07, 1.07055453E-09],
                   [25408.3848, 7.07543848E-07, 1.01701914E-09],
                   [25762.5645, 6.88186503E-07, 9.6636199E-10],
                   [26121.6797, 6.69359622E-07, 9.18430221E-10],
                   [26485.8008, 6.51049334E-07, 8.7307428E-10],
                   [26855., 6.33240006E-07, 8.3015278E-10],
                   [27229.3438, 6.15918282E-07, 7.89534105E-10],
                   [27608.9062, 5.99071598E-07, 7.51085971E-10],
                   [27993.7598, 5.82686425E-07, 7.14696691E-10],
                   [28383.9766, 5.6674952E-07, 6.80254908E-10],
                   [28779.6348, 5.51249343E-07, 6.4765171E-10],
                   [29180.8066, 5.36173673E-07, 6.167859E-10],
                   [29587.5723, 5.21509492E-07, 5.87563276E-10],
                   [30000.0059, 5.07248672E-07, 5.59898017E-10]])
}


def get_delta_beta(energy_in_KeV, material, xraylib_only=True):
    if xraylib_only:
        density = ShadowPhysics.getMaterialDensity(material)
        delta = (1 - xraylib.Refractive_Index_Re(material, energy_in_KeV, density))
        beta  = xraylib.Refractive_Index_Im(material, energy_in_KeV, density)
    elif material in REFRACTIVE_DATA.keys():
        data = REFRACTIVE_DATA[material]
        delta = numpy.interp([energy_in_KeV * 1000], data[:, 0], data[:, 1])[0]
        beta  = numpy.interp([energy_in_KeV * 1000], data[:, 0], data[:, 2])[0]

    return delta, beta
