# pylandtemp

[![GitHub license](https://img.shields.io/github/license/pylandtemp/pylandtemp)](https://github.com/pylandtemp/pylandtemp/blob/master/LICENSE)
[![GitHub stars](https://img.shields.io/github/stars/pylandtemp/pylandtemp)](https://github.com/pylandtemp/pylandtemp/stargazers)
[![GitHub forks](https://img.shields.io/github/forks/pylandtemp/pylandtemp)](https://github.com/pylandtemp/pylandtemp/network)
[![GitHub issues](https://img.shields.io/github/issues/pylandtemp/pylandtemp)](https://github.com/pylandtemp/pylandtemp/issues)

## Description

**pylandtemp** is a Python tool for retrieving land surface temperature from NASA's [Landsat 8](https://www.usgs.gov/core-science-systems/nli/landsat/landsat-8?qt-science_support_page_related_con=0#qt-science_support_page_related_con) satellite imagery using the mono-window and split-window techniques in literature.
Additionally, it also provides multiple methods for computing land surface emissivity. It is targeted towards supporting research and science workflows in many fields including climate science, earth sciences, remote sensing, geospatial data science, environmental studies, among others.

Even though only Landsat 8 images are currently 'officially' supported, the methods available via this Python tool can be applied to other dataset including ASTER and MODIS.


## What's new:
- ***December 2021***: Implementing tutorial notebooks based on the different methods. Find them [here](https://github.com/pylandtemp/pylandtemp/tree/master/tutorials)


## Installation

`pip install pylandtemp`



## How to start using pylandtemp
The notebooks [here](https://github.com/pylandtemp/pylandtemp/tree/master/tutorials) are a good place to start.



## How to contribute to pylandtemp

All kinds of contributions are welcome --- development of enhancements, bug fixes, documentation, tutorial notebooks, new methods, new data, etc.... 

A guide to get you started with contributing to pylandtemp is available [here]().

```
@Misc{pylandtemp,
author = {Oladimeji Mudele},
title =        {pylandtemp - a Python tool for retrieving land surface temperature from Landsat 8 satellite imagery},
howpublished = {Github},
year =         {2021},
url =          {https://github.com/pylandtemp}
}
```


