#!/usr/bin/env python
from setuptools import setup
setup(
  name = 'cs.cmdutils',
  description = 'convenience functions for working with the Cmd module and other command line related stuff',
  author = 'Cameron Simpson',
  author_email = 'cs@cskk.id.au',
  version = '20200318',
  url = 'https://bitbucket.org/cameron_simpson/css/commits/all',
  classifiers = ['Programming Language :: Python', 'Programming Language :: Python :: 2', 'Programming Language :: Python :: 3', 'Development Status :: 4 - Beta', 'Intended Audience :: Developers', 'Operating System :: OS Independent', 'Topic :: Software Development :: Libraries :: Python Modules', 'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)'],
  include_package_data = True,
  install_requires = ['cs.context', 'cs.lex', 'cs.pfx', 'cs.resources'],
  keywords = ['python2', 'python3'],
  license = 'GNU General Public License v3 or later (GPLv3+)',
  long_description = '*Latest release 20200318*:\nBaseCommand.run: make argv optional, get additional usage keywords from self.USAGE_KEYWORDS.\n@BaseCommand.add_usage_to_docstring: honour cls.USAGE_KEYWORDS.\nBaseCommand: do not require GETOPT_SPEC for commands with no defined options.\nBaseCommand.run: call cs.logutils.setup_logging.\n\nConvenience functions for working with the Cmd module\nand other command line related stuff.\n\n## Class `BaseCommand`\n\nA base class for handling nestable command lines.\n\nThis class provides the basic parse and dispatch mechanisms\nfor command lines.\nTo implement a command line\none instantiates a subclass of BaseCommand:\n\n    class MyCommand(BaseCommand):\n      GETOPT_SPEC = \'ab:c\'\n      USAGE_FORMAT = r"""Usage: {cmd} [-a] [-b bvalue] [-c] [--] arguments...\n        -a    Do it all.\n        -b    But using bvalue.\n        -c    The \'c\' option!\n      """\n    ...\n    the_cmd = MyCommand()\n\nRunning a command is done by:\n\n    the_cmd.run(argv)\n\nThe subclass is customised by overriding the following methods:\n* `apply_defaults(options)`:\n  prepare the initial state of `options`\n  before any command line options are applied\n* `apply_opts(options,opts)`:\n  apply the `opts` to `options`.\n  `opts` is an option value mapping\n  as returned by `getopot.getopt`.\n* `cmd_`*subcmd*`(argv,options)`:\n  if the command line options are followed by an argument\n  whose value is *subcmd*,\n  then method `cmd_`*subcmd*`(argv,options)`\n  will be called where `argv` contains the command line arguments\n  after *subcmd*.\n* `main(argv,options)`:\n  if there are no command line aguments after the options\n  or the first argument does not have a corresponding\n  `cmd_`*subcmd* method\n  then method `main(argv,options)`\n  will be called where `argv` contains the command line arguments.\n* `run_context(argv,options,cmd)`:\n  a context manager to provide setup or teardown actions\n  to occur before and after the command implementation respectively.\n  If the implementation is a `cmd_`*subcmd* method\n  then this is called with `cmd=`*subcmd*;\n  if the implementation is `main`\n  then this is called with `cmd=None`.\n\nTo aid recursive use\nit is intended that all the per command state\nis contained in the `options` object\nand therefore that in typical use\nall of `apply_opts`, `cmd_`*subcmd*, `main` and `run_context`\nshould be static methods making no reference to `self`.\n\nEditorial: why not arparse?\nPrimarily because when incorrectly invoked\nan argparse command line prints the help/usage messgae\nand aborts the whole programme with `SystemExit`.\n\n## Function `docmd(dofunc)`\n\nDecorator for Cmd subclass methods\nto supply some basic quality of service.\n\nThis decorator:\n- wraps the function call in a `cs.pfx.Pfx` for context\n- intercepts `getopt.GetoptError`s, issues a `warning`\n  and runs `self.do_help` with the method name,\n  then returns `None`\n- intercepts other `Exception`s,\n  issues an `exception` log message\n  and returns `None`\n\nThe intended use is to decorate `cmd.Cmd` `do_`* methods:\n\n    from cmd import Cmd\n    class MyCmd(Cmd):\n      @docmd\n      def do_something(...):\n        ... do something ...\n\n\n\n# Release Log\n\n*Release 20200318*:\nBaseCommand.run: make argv optional, get additional usage keywords from self.USAGE_KEYWORDS.\n@BaseCommand.add_usage_to_docstring: honour cls.USAGE_KEYWORDS.\nBaseCommand: do not require GETOPT_SPEC for commands with no defined options.\nBaseCommand.run: call cs.logutils.setup_logging.\n\n*Release 20200229*:\nImprove subcommand selection logic, replace StackableValues with stackattrs, drop `cmd` from arguments passed to main/cmd_* methods (present in `options`).\n\n*Release 20200210*:\nNew BaseCommand.add_usage_to_docstring class method to be called after class setup, to append the usage message to the class docstring.\nBaseCommand.run: remove spurious Pfx(cmd), as logutils does this for us already.\n\n*Release 20190729*:\nBaseCommand: support for a USAGE_FORMAT usage message format string and a getopt_error_handler method.\n\n*Release 20190619.1*:\nAnother niggling docstring formatting fix.\n\n*Release 20190619*:\nMinor documentation updates.\n\n*Release 20190617.2*:\nLint.\n\n*Release 20190617.1*:\nInitial release with @docmd decorator and alpha quality BaseCommand command line assistance class.',
  long_description_content_type = 'text/markdown',
  package_dir = {'': 'lib/python'},
  py_modules = ['cs.cmdutils'],
)
