from typing import Any as _py_Any
from typing import List as _py_List
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import java.lang
import java.net
import java.nio
import java.nio.channels
import java.nio.charset
import java.nio.file
import java.security
import java.util
import java.util.stream


class Bits: ...

class Closeable(java.lang.AutoCloseable):
    def close(self) -> None: ...

class DataInput:
    def readBoolean(self) -> bool: ...
    def readByte(self) -> int: ...
    def readChar(self) -> str: ...
    def readDouble(self) -> float: ...
    def readFloat(self) -> float: ...
    @overload
    def readFully(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def readFully(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...
    def readInt(self) -> int: ...
    def readLine(self) -> str: ...
    def readLong(self) -> int: ...
    def readShort(self) -> int: ...
    def readUTF(self) -> str: ...
    def readUnsignedByte(self) -> int: ...
    def readUnsignedShort(self) -> int: ...
    def skipBytes(self, int: int) -> int: ...

class DataOutput:
    @overload
    def write(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def write(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...
    @overload
    def write(self, int: int) -> None: ...
    def writeBoolean(self, boolean: bool) -> None: ...
    def writeByte(self, int: int) -> None: ...
    def writeBytes(self, string: str) -> None: ...
    def writeChar(self, int: int) -> None: ...
    def writeChars(self, string: str) -> None: ...
    def writeDouble(self, double: float) -> None: ...
    def writeFloat(self, float: float) -> None: ...
    def writeInt(self, int: int) -> None: ...
    def writeLong(self, long: int) -> None: ...
    def writeShort(self, int: int) -> None: ...
    def writeUTF(self, string: str) -> None: ...

class DefaultFileSystem:
    @classmethod
    def getFileSystem(cls) -> 'FileSystem': ...

class DeleteOnExitHook: ...

class ExpiringCache: ...

class FileDescriptor:
    in_: _py_ClassVar['FileDescriptor'] = ...
    out: _py_ClassVar['FileDescriptor'] = ...
    err: _py_ClassVar['FileDescriptor'] = ...
    def __init__(self): ...
    def sync(self) -> None: ...
    def valid(self) -> bool: ...

class FileFilter:
    def accept(self, file: 'File') -> bool: ...

class FileSystem:
    BA_EXISTS: _py_ClassVar[int] = ...
    BA_REGULAR: _py_ClassVar[int] = ...
    BA_DIRECTORY: _py_ClassVar[int] = ...
    BA_HIDDEN: _py_ClassVar[int] = ...
    ACCESS_READ: _py_ClassVar[int] = ...
    ACCESS_WRITE: _py_ClassVar[int] = ...
    ACCESS_EXECUTE: _py_ClassVar[int] = ...
    SPACE_TOTAL: _py_ClassVar[int] = ...
    SPACE_FREE: _py_ClassVar[int] = ...
    SPACE_USABLE: _py_ClassVar[int] = ...
    def canonicalize(self, string: str) -> str: ...
    def checkAccess(self, file: 'File', int: int) -> bool: ...
    def compare(self, file: 'File', file2: 'File') -> int: ...
    def createDirectory(self, file: 'File') -> bool: ...
    def createFileExclusively(self, string: str) -> bool: ...
    def delete(self, file: 'File') -> bool: ...
    def fromURIPath(self, string: str) -> str: ...
    def getBooleanAttributes(self, file: 'File') -> int: ...
    def getDefaultParent(self) -> str: ...
    def getLastModifiedTime(self, file: 'File') -> int: ...
    def getLength(self, file: 'File') -> int: ...
    def getPathSeparator(self) -> str: ...
    def getSeparator(self) -> str: ...
    def getSpace(self, file: 'File', int: int) -> int: ...
    @overload
    def hashCode(self, file: 'File') -> int: ...
    @overload
    def hashCode(self) -> int: ...
    def isAbsolute(self, file: 'File') -> bool: ...
    def list(self, file: 'File') -> _py_List[str]: ...
    def listRoots(self) -> _py_List['File']: ...
    def normalize(self, string: str) -> str: ...
    def prefixLength(self, string: str) -> int: ...
    def rename(self, file: 'File', file2: 'File') -> bool: ...
    @overload
    def resolve(self, file: 'File') -> str: ...
    @overload
    def resolve(self, string: str, string2: str) -> str: ...
    def setLastModifiedTime(self, file: 'File', long: int) -> bool: ...
    def setPermission(self, file: 'File', int: int, boolean: bool, boolean2: bool) -> bool: ...
    def setReadOnly(self, file: 'File') -> bool: ...

class FilenameFilter:
    def accept(self, file: 'File', string: str) -> bool: ...

class Flushable:
    def flush(self) -> None: ...

class IOError(java.lang.Error):
    def __init__(self, throwable: java.lang.Throwable): ...

class IOException(java.lang.Exception):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class ObjectInputValidation:
    def validateObject(self) -> None: ...

class ObjectStreamConstants:
    STREAM_MAGIC: _py_ClassVar[int] = ...
    STREAM_VERSION: _py_ClassVar[int] = ...
    TC_BASE: _py_ClassVar[int] = ...
    TC_NULL: _py_ClassVar[int] = ...
    TC_REFERENCE: _py_ClassVar[int] = ...
    TC_CLASSDESC: _py_ClassVar[int] = ...
    TC_OBJECT: _py_ClassVar[int] = ...
    TC_STRING: _py_ClassVar[int] = ...
    TC_ARRAY: _py_ClassVar[int] = ...
    TC_CLASS: _py_ClassVar[int] = ...
    TC_BLOCKDATA: _py_ClassVar[int] = ...
    TC_ENDBLOCKDATA: _py_ClassVar[int] = ...
    TC_RESET: _py_ClassVar[int] = ...
    TC_BLOCKDATALONG: _py_ClassVar[int] = ...
    TC_EXCEPTION: _py_ClassVar[int] = ...
    TC_LONGSTRING: _py_ClassVar[int] = ...
    TC_PROXYCLASSDESC: _py_ClassVar[int] = ...
    TC_ENUM: _py_ClassVar[int] = ...
    TC_MAX: _py_ClassVar[int] = ...
    baseWireHandle: _py_ClassVar[int] = ...
    SC_WRITE_METHOD: _py_ClassVar[int] = ...
    SC_BLOCK_DATA: _py_ClassVar[int] = ...
    SC_SERIALIZABLE: _py_ClassVar[int] = ...
    SC_EXTERNALIZABLE: _py_ClassVar[int] = ...
    SC_ENUM: _py_ClassVar[int] = ...
    SUBSTITUTION_PERMISSION: _py_ClassVar['SerializablePermission'] = ...
    SUBCLASS_IMPLEMENTATION_PERMISSION: _py_ClassVar['SerializablePermission'] = ...
    PROTOCOL_VERSION_1: _py_ClassVar[int] = ...
    PROTOCOL_VERSION_2: _py_ClassVar[int] = ...

class ObjectStreamField(java.lang.Comparable[_py_Any]):
    @overload
    def __init__(self, string: str, class_: _py_Type[_py_Any]): ...
    @overload
    def __init__(self, string: str, class_: _py_Type[_py_Any], boolean: bool): ...
    def compareTo(self, object: _py_Any) -> int: ...
    def getName(self) -> str: ...
    def getOffset(self) -> int: ...
    def getType(self) -> _py_Type[_py_Any]: ...
    def getTypeCode(self) -> str: ...
    def getTypeString(self) -> str: ...
    def isPrimitive(self) -> bool: ...
    def isUnshared(self) -> bool: ...
    def toString(self) -> str: ...

class SerialCallbackContext:
    def __init__(self, object: _py_Any, objectStreamClass: 'ObjectStreamClass'): ...
    def check(self) -> None: ...
    def getDesc(self) -> 'ObjectStreamClass': ...
    def getObj(self) -> _py_Any: ...
    def setUsed(self) -> None: ...

class Serializable: ...

class SerializablePermission(java.security.BasicPermission):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...

class StreamTokenizer:
    ttype: int = ...
    TT_EOF: _py_ClassVar[int] = ...
    TT_EOL: _py_ClassVar[int] = ...
    TT_NUMBER: _py_ClassVar[int] = ...
    TT_WORD: _py_ClassVar[int] = ...
    sval: str = ...
    nval: float = ...
    @overload
    def __init__(self, inputStream: 'InputStream'): ...
    @overload
    def __init__(self, reader: 'Reader'): ...
    def commentChar(self, int: int) -> None: ...
    def eolIsSignificant(self, boolean: bool) -> None: ...
    def lineno(self) -> int: ...
    def lowerCaseMode(self, boolean: bool) -> None: ...
    def nextToken(self) -> int: ...
    def ordinaryChar(self, int: int) -> None: ...
    def ordinaryChars(self, int: int, int2: int) -> None: ...
    def parseNumbers(self) -> None: ...
    def pushBack(self) -> None: ...
    def quoteChar(self, int: int) -> None: ...
    def resetSyntax(self) -> None: ...
    def slashSlashComments(self, boolean: bool) -> None: ...
    def slashStarComments(self, boolean: bool) -> None: ...
    def toString(self) -> str: ...
    def whitespaceChars(self, int: int, int2: int) -> None: ...
    def wordChars(self, int: int, int2: int) -> None: ...

class UncheckedIOException(java.lang.RuntimeException):
    @overload
    def __init__(self, iOException: IOException): ...
    @overload
    def __init__(self, string: str, iOException: IOException): ...
    @overload
    def getCause(self) -> IOException: ...
    @overload
    def getCause(self) -> java.lang.Throwable: ...

class CharConversionException(IOException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class Console(Flushable):
    def flush(self) -> None: ...
    def format(self, string: str, objectArray: _py_List[_py_Any]) -> 'Console': ...
    def printf(self, string: str, objectArray: _py_List[_py_Any]) -> 'Console': ...
    @overload
    def readLine(self) -> str: ...
    @overload
    def readLine(self, string: str, objectArray: _py_List[_py_Any]) -> str: ...
    @overload
    def readPassword(self) -> _py_List[str]: ...
    @overload
    def readPassword(self, string: str, objectArray: _py_List[_py_Any]) -> _py_List[str]: ...
    def reader(self) -> 'Reader': ...
    def writer(self) -> 'PrintWriter': ...

class EOFException(IOException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class Externalizable(Serializable):
    def readExternal(self, objectInput: 'ObjectInput') -> None: ...
    def writeExternal(self, objectOutput: 'ObjectOutput') -> None: ...

class File(Serializable, java.lang.Comparable['File']):
    separatorChar: _py_ClassVar[str] = ...
    separator: _py_ClassVar[str] = ...
    pathSeparatorChar: _py_ClassVar[str] = ...
    pathSeparator: _py_ClassVar[str] = ...
    @overload
    def __init__(self, file: 'File', string: str): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    @overload
    def __init__(self, uRI: java.net.URI): ...
    def canExecute(self) -> bool: ...
    def canRead(self) -> bool: ...
    def canWrite(self) -> bool: ...
    @overload
    def compareTo(self, file: 'File') -> int: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    def createNewFile(self) -> bool: ...
    @classmethod
    @overload
    def createTempFile(cls, string: str, string2: str) -> 'File': ...
    @classmethod
    @overload
    def createTempFile(cls, string: str, string2: str, file: 'File') -> 'File': ...
    def delete(self) -> bool: ...
    def deleteOnExit(self) -> None: ...
    def equals(self, object: _py_Any) -> bool: ...
    def exists(self) -> bool: ...
    def getAbsoluteFile(self) -> 'File': ...
    def getAbsolutePath(self) -> str: ...
    def getCanonicalFile(self) -> 'File': ...
    def getCanonicalPath(self) -> str: ...
    def getFreeSpace(self) -> int: ...
    def getName(self) -> str: ...
    def getParent(self) -> str: ...
    def getParentFile(self) -> 'File': ...
    def getPath(self) -> str: ...
    def getTotalSpace(self) -> int: ...
    def getUsableSpace(self) -> int: ...
    def hashCode(self) -> int: ...
    def isAbsolute(self) -> bool: ...
    def isDirectory(self) -> bool: ...
    def isFile(self) -> bool: ...
    def isHidden(self) -> bool: ...
    def lastModified(self) -> int: ...
    def length(self) -> int: ...
    @overload
    def list(self) -> _py_List[str]: ...
    @overload
    def list(self, filenameFilter: FilenameFilter) -> _py_List[str]: ...
    @overload
    def listFiles(self) -> _py_List['File']: ...
    @overload
    def listFiles(self, fileFilter: FileFilter) -> _py_List['File']: ...
    @overload
    def listFiles(self, filenameFilter: FilenameFilter) -> _py_List['File']: ...
    @classmethod
    def listRoots(cls) -> _py_List['File']: ...
    def mkdir(self) -> bool: ...
    def mkdirs(self) -> bool: ...
    def renameTo(self, file: 'File') -> bool: ...
    @overload
    def setExecutable(self, boolean: bool) -> bool: ...
    @overload
    def setExecutable(self, boolean: bool, boolean2: bool) -> bool: ...
    def setLastModified(self, long: int) -> bool: ...
    def setReadOnly(self) -> bool: ...
    @overload
    def setReadable(self, boolean: bool) -> bool: ...
    @overload
    def setReadable(self, boolean: bool, boolean2: bool) -> bool: ...
    @overload
    def setWritable(self, boolean: bool) -> bool: ...
    @overload
    def setWritable(self, boolean: bool, boolean2: bool) -> bool: ...
    def toPath(self) -> java.nio.file.Path: ...
    def toString(self) -> str: ...
    def toURI(self) -> java.net.URI: ...
    def toURL(self) -> java.net.URL: ...

class FileNotFoundException(IOException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class FilePermission(java.security.Permission, Serializable):
    def __init__(self, string: str, string2: str): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getActions(self) -> str: ...
    def hashCode(self) -> int: ...
    def implies(self, permission: java.security.Permission) -> bool: ...
    def newPermissionCollection(self) -> java.security.PermissionCollection: ...

class FilePermissionCollection(java.security.PermissionCollection, Serializable):
    def __init__(self): ...
    def add(self, permission: java.security.Permission) -> None: ...
    def elements(self) -> java.util.Enumeration[java.security.Permission]: ...
    def implies(self, permission: java.security.Permission) -> bool: ...

class InputStream(Closeable):
    def __init__(self): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int]) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int], int: int, int2: int) -> int: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...

class InterruptedIOException(IOException):
    bytesTransferred: int = ...
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class ObjectInput(DataInput, java.lang.AutoCloseable):
    def available(self) -> int: ...
    def close(self) -> None: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int]) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int], int: int, int2: int) -> int: ...
    def readObject(self) -> _py_Any: ...
    def skip(self, long: int) -> int: ...

class ObjectOutput(DataOutput, java.lang.AutoCloseable):
    def close(self) -> None: ...
    def flush(self) -> None: ...
    @overload
    def write(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def write(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...
    @overload
    def write(self, int: int) -> None: ...
    def writeObject(self, object: _py_Any) -> None: ...

class ObjectStreamClass(Serializable):
    NO_FIELDS: _py_ClassVar[_py_List[ObjectStreamField]] = ...
    def forClass(self) -> _py_Type[_py_Any]: ...
    def getField(self, string: str) -> ObjectStreamField: ...
    def getFields(self) -> _py_List[ObjectStreamField]: ...
    def getName(self) -> str: ...
    def getSerialVersionUID(self) -> int: ...
    @classmethod
    def lookup(cls, class_: _py_Type[_py_Any]) -> 'ObjectStreamClass': ...
    @classmethod
    def lookupAny(cls, class_: _py_Type[_py_Any]) -> 'ObjectStreamClass': ...
    def toString(self) -> str: ...

class ObjectStreamException(IOException): ...

class OutputStream(Closeable, Flushable):
    def __init__(self): ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    @overload
    def write(self, int: int) -> None: ...
    @overload
    def write(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def write(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...

class RandomAccessFile(DataOutput, DataInput, Closeable):
    @overload
    def __init__(self, file: File, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    def close(self) -> None: ...
    def getChannel(self) -> java.nio.channels.FileChannel: ...
    def getFD(self) -> FileDescriptor: ...
    def getFilePointer(self) -> int: ...
    def length(self) -> int: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int]) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int], int: int, int2: int) -> int: ...
    def readBoolean(self) -> bool: ...
    def readByte(self) -> int: ...
    def readChar(self) -> str: ...
    def readDouble(self) -> float: ...
    def readFloat(self) -> float: ...
    @overload
    def readFully(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def readFully(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...
    def readInt(self) -> int: ...
    def readLine(self) -> str: ...
    def readLong(self) -> int: ...
    def readShort(self) -> int: ...
    def readUTF(self) -> str: ...
    def readUnsignedByte(self) -> int: ...
    def readUnsignedShort(self) -> int: ...
    def seek(self, long: int) -> None: ...
    def setLength(self, long: int) -> None: ...
    def skipBytes(self, int: int) -> int: ...
    @overload
    def write(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def write(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...
    @overload
    def write(self, int: int) -> None: ...
    def writeBoolean(self, boolean: bool) -> None: ...
    def writeByte(self, int: int) -> None: ...
    def writeBytes(self, string: str) -> None: ...
    def writeChar(self, int: int) -> None: ...
    def writeChars(self, string: str) -> None: ...
    def writeDouble(self, double: float) -> None: ...
    def writeFloat(self, float: float) -> None: ...
    def writeInt(self, int: int) -> None: ...
    def writeLong(self, long: int) -> None: ...
    def writeShort(self, int: int) -> None: ...
    def writeUTF(self, string: str) -> None: ...

class Reader(java.lang.Readable, Closeable):
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @overload
    def read(self, charArray: _py_List[str], int: int, int2: int) -> int: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, charArray: _py_List[str]) -> int: ...
    @overload
    def read(self, charBuffer: java.nio.CharBuffer) -> int: ...
    def ready(self) -> bool: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...

class SyncFailedException(IOException):
    def __init__(self, string: str): ...

class UTFDataFormatException(IOException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class UnsupportedEncodingException(IOException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class WinNTFileSystem(FileSystem):
    def __init__(self): ...
    def canonicalize(self, string: str) -> str: ...
    def checkAccess(self, file: File, int: int) -> bool: ...
    def compare(self, file: File, file2: File) -> int: ...
    def createDirectory(self, file: File) -> bool: ...
    def createFileExclusively(self, string: str) -> bool: ...
    def delete(self, file: File) -> bool: ...
    def fromURIPath(self, string: str) -> str: ...
    def getBooleanAttributes(self, file: File) -> int: ...
    def getDefaultParent(self) -> str: ...
    def getLastModifiedTime(self, file: File) -> int: ...
    def getLength(self, file: File) -> int: ...
    def getPathSeparator(self) -> str: ...
    def getSeparator(self) -> str: ...
    def getSpace(self, file: File, int: int) -> int: ...
    @overload
    def hashCode(self, file: File) -> int: ...
    @overload
    def hashCode(self) -> int: ...
    def isAbsolute(self, file: File) -> bool: ...
    def list(self, file: File) -> _py_List[str]: ...
    def listRoots(self) -> _py_List[File]: ...
    def normalize(self, string: str) -> str: ...
    def prefixLength(self, string: str) -> int: ...
    def rename(self, file: File, file2: File) -> bool: ...
    @overload
    def resolve(self, file: File) -> str: ...
    @overload
    def resolve(self, string: str, string2: str) -> str: ...
    def setLastModifiedTime(self, file: File, long: int) -> bool: ...
    def setPermission(self, file: File, int: int, boolean: bool, boolean2: bool) -> bool: ...
    def setReadOnly(self, file: File) -> bool: ...

class Writer(java.lang.Appendable, Closeable, Flushable):
    @overload
    def append(self, char: str) -> 'Writer': ...
    @overload
    def append(self, charSequence: java.lang.CharSequence) -> 'Writer': ...
    @overload
    def append(self, charSequence: java.lang.CharSequence, int: int, int2: int) -> 'Writer': ...
    @overload
    def append(self, char: str) -> java.lang.Appendable: ...
    @overload
    def append(self, charSequence: java.lang.CharSequence) -> java.lang.Appendable: ...
    @overload
    def append(self, charSequence: java.lang.CharSequence, int: int, int2: int) -> java.lang.Appendable: ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    @overload
    def write(self, charArray: _py_List[str], int: int, int2: int) -> None: ...
    @overload
    def write(self, charArray: _py_List[str]) -> None: ...
    @overload
    def write(self, int: int) -> None: ...
    @overload
    def write(self, string: str) -> None: ...
    @overload
    def write(self, string: str, int: int, int2: int) -> None: ...

class BufferedReader(Reader):
    @overload
    def __init__(self, reader: Reader): ...
    @overload
    def __init__(self, reader: Reader, int: int): ...
    def close(self) -> None: ...
    def lines(self) -> java.util.stream.Stream[str]: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, charArray: _py_List[str], int: int, int2: int) -> int: ...
    @overload
    def read(self, charArray: _py_List[str]) -> int: ...
    @overload
    def read(self, charBuffer: java.nio.CharBuffer) -> int: ...
    def readLine(self) -> str: ...
    def ready(self) -> bool: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...

class BufferedWriter(Writer):
    @overload
    def __init__(self, writer: Writer): ...
    @overload
    def __init__(self, writer: Writer, int: int): ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    def newLine(self) -> None: ...
    @overload
    def write(self, charArray: _py_List[str], int: int, int2: int) -> None: ...
    @overload
    def write(self, int: int) -> None: ...
    @overload
    def write(self, string: str, int: int, int2: int) -> None: ...
    @overload
    def write(self, charArray: _py_List[str]) -> None: ...
    @overload
    def write(self, string: str) -> None: ...

class ByteArrayInputStream(InputStream):
    @overload
    def __init__(self, byteArray: _py_List[int]): ...
    @overload
    def __init__(self, byteArray: _py_List[int], int: int, int2: int): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @overload
    def read(self, byteArray: _py_List[int]) -> int: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int], int: int, int2: int) -> int: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...

class ByteArrayOutputStream(OutputStream):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int): ...
    def close(self) -> None: ...
    def reset(self) -> None: ...
    def size(self) -> int: ...
    def toByteArray(self) -> _py_List[int]: ...
    @overload
    def toString(self) -> str: ...
    @overload
    def toString(self, int: int) -> str: ...
    @overload
    def toString(self, string: str) -> str: ...
    @overload
    def write(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...
    @overload
    def write(self, int: int) -> None: ...
    @overload
    def write(self, byteArray: _py_List[int]) -> None: ...
    def writeTo(self, outputStream: OutputStream) -> None: ...

class CharArrayReader(Reader):
    @overload
    def __init__(self, charArray: _py_List[str]): ...
    @overload
    def __init__(self, charArray: _py_List[str], int: int, int2: int): ...
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, charArray: _py_List[str], int: int, int2: int) -> int: ...
    @overload
    def read(self, charArray: _py_List[str]) -> int: ...
    @overload
    def read(self, charBuffer: java.nio.CharBuffer) -> int: ...
    def ready(self) -> bool: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...

class CharArrayWriter(Writer):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int): ...
    @overload
    def append(self, char: str) -> 'CharArrayWriter': ...
    @overload
    def append(self, charSequence: java.lang.CharSequence) -> 'CharArrayWriter': ...
    @overload
    def append(self, charSequence: java.lang.CharSequence, int: int, int2: int) -> 'CharArrayWriter': ...
    @overload
    def append(self, char: str) -> Writer: ...
    @overload
    def append(self, charSequence: java.lang.CharSequence) -> Writer: ...
    @overload
    def append(self, charSequence: java.lang.CharSequence, int: int, int2: int) -> Writer: ...
    @overload
    def append(self, char: str) -> java.lang.Appendable: ...
    @overload
    def append(self, charSequence: java.lang.CharSequence) -> java.lang.Appendable: ...
    @overload
    def append(self, charSequence: java.lang.CharSequence, int: int, int2: int) -> java.lang.Appendable: ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    def reset(self) -> None: ...
    def size(self) -> int: ...
    def toCharArray(self) -> _py_List[str]: ...
    def toString(self) -> str: ...
    @overload
    def write(self, charArray: _py_List[str], int: int, int2: int) -> None: ...
    @overload
    def write(self, int: int) -> None: ...
    @overload
    def write(self, string: str, int: int, int2: int) -> None: ...
    @overload
    def write(self, charArray: _py_List[str]) -> None: ...
    @overload
    def write(self, string: str) -> None: ...
    def writeTo(self, writer: Writer) -> None: ...

class FileInputStream(InputStream):
    @overload
    def __init__(self, file: File): ...
    @overload
    def __init__(self, fileDescriptor: FileDescriptor): ...
    @overload
    def __init__(self, string: str): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    def getChannel(self) -> java.nio.channels.FileChannel: ...
    def getFD(self) -> FileDescriptor: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int]) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int], int: int, int2: int) -> int: ...
    def skip(self, long: int) -> int: ...

class FileOutputStream(OutputStream):
    @overload
    def __init__(self, file: File): ...
    @overload
    def __init__(self, file: File, boolean: bool): ...
    @overload
    def __init__(self, fileDescriptor: FileDescriptor): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, boolean: bool): ...
    def close(self) -> None: ...
    def getChannel(self) -> java.nio.channels.FileChannel: ...
    def getFD(self) -> FileDescriptor: ...
    @overload
    def write(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def write(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...
    @overload
    def write(self, int: int) -> None: ...

class FilterInputStream(InputStream):
    def available(self) -> int: ...
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int]) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int], int: int, int2: int) -> int: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...

class FilterOutputStream(OutputStream):
    def __init__(self, outputStream: OutputStream): ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    @overload
    def write(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def write(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...
    @overload
    def write(self, int: int) -> None: ...

class FilterReader(Reader):
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, charArray: _py_List[str], int: int, int2: int) -> int: ...
    @overload
    def read(self, charArray: _py_List[str]) -> int: ...
    @overload
    def read(self, charBuffer: java.nio.CharBuffer) -> int: ...
    def ready(self) -> bool: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...

class FilterWriter(Writer):
    def close(self) -> None: ...
    def flush(self) -> None: ...
    @overload
    def write(self, charArray: _py_List[str], int: int, int2: int) -> None: ...
    @overload
    def write(self, int: int) -> None: ...
    @overload
    def write(self, string: str, int: int, int2: int) -> None: ...
    @overload
    def write(self, charArray: _py_List[str]) -> None: ...
    @overload
    def write(self, string: str) -> None: ...

class InputStreamReader(Reader):
    @overload
    def __init__(self, inputStream: InputStream): ...
    @overload
    def __init__(self, inputStream: InputStream, string: str): ...
    @overload
    def __init__(self, inputStream: InputStream, charset: java.nio.charset.Charset): ...
    @overload
    def __init__(self, inputStream: InputStream, charsetDecoder: java.nio.charset.CharsetDecoder): ...
    def close(self) -> None: ...
    def getEncoding(self) -> str: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, charArray: _py_List[str], int: int, int2: int) -> int: ...
    @overload
    def read(self, charArray: _py_List[str]) -> int: ...
    @overload
    def read(self, charBuffer: java.nio.CharBuffer) -> int: ...
    def ready(self) -> bool: ...

class InvalidClassException(ObjectStreamException):
    classname: str = ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    def getMessage(self) -> str: ...

class InvalidObjectException(ObjectStreamException):
    def __init__(self, string: str): ...

class NotActiveException(ObjectStreamException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class NotSerializableException(ObjectStreamException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class ObjectInputStream(InputStream, ObjectInput, ObjectStreamConstants):
    def __init__(self, inputStream: InputStream): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    def defaultReadObject(self) -> None: ...
    @overload
    def read(self, byteArray: _py_List[int]) -> int: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int], int: int, int2: int) -> int: ...
    def readBoolean(self) -> bool: ...
    def readByte(self) -> int: ...
    def readChar(self) -> str: ...
    def readDouble(self) -> float: ...
    def readFields(self) -> 'ObjectInputStream.GetField': ...
    def readFloat(self) -> float: ...
    @overload
    def readFully(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def readFully(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...
    def readInt(self) -> int: ...
    def readLine(self) -> str: ...
    def readLong(self) -> int: ...
    def readObject(self) -> _py_Any: ...
    def readShort(self) -> int: ...
    def readUTF(self) -> str: ...
    def readUnshared(self) -> _py_Any: ...
    def readUnsignedByte(self) -> int: ...
    def readUnsignedShort(self) -> int: ...
    def registerValidation(self, objectInputValidation: ObjectInputValidation, int: int) -> None: ...
    def skipBytes(self, int: int) -> int: ...
    class GetField:
        def __init__(self): ...
        def defaulted(self, string: str) -> bool: ...
        @overload
        def get(self, string: str, boolean: bool) -> bool: ...
        @overload
        def get(self, string: str, byte: int) -> int: ...
        @overload
        def get(self, string: str, char: str) -> str: ...
        @overload
        def get(self, string: str, double: float) -> float: ...
        @overload
        def get(self, string: str, float: float) -> float: ...
        @overload
        def get(self, string: str, int: int) -> int: ...
        @overload
        def get(self, string: str, object: _py_Any) -> _py_Any: ...
        @overload
        def get(self, string: str, long: int) -> int: ...
        @overload
        def get(self, string: str, short: int) -> int: ...
        def getObjectStreamClass(self) -> ObjectStreamClass: ...

class ObjectOutputStream(OutputStream, ObjectOutput, ObjectStreamConstants):
    def __init__(self, outputStream: OutputStream): ...
    def close(self) -> None: ...
    def defaultWriteObject(self) -> None: ...
    def flush(self) -> None: ...
    def putFields(self) -> 'ObjectOutputStream.PutField': ...
    def reset(self) -> None: ...
    def useProtocolVersion(self, int: int) -> None: ...
    @overload
    def write(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def write(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...
    @overload
    def write(self, int: int) -> None: ...
    def writeBoolean(self, boolean: bool) -> None: ...
    def writeByte(self, int: int) -> None: ...
    def writeBytes(self, string: str) -> None: ...
    def writeChar(self, int: int) -> None: ...
    def writeChars(self, string: str) -> None: ...
    def writeDouble(self, double: float) -> None: ...
    def writeFields(self) -> None: ...
    def writeFloat(self, float: float) -> None: ...
    def writeInt(self, int: int) -> None: ...
    def writeLong(self, long: int) -> None: ...
    def writeObject(self, object: _py_Any) -> None: ...
    def writeShort(self, int: int) -> None: ...
    def writeUTF(self, string: str) -> None: ...
    def writeUnshared(self, object: _py_Any) -> None: ...
    class PutField:
        def __init__(self): ...
        @overload
        def put(self, string: str, boolean: bool) -> None: ...
        @overload
        def put(self, string: str, byte: int) -> None: ...
        @overload
        def put(self, string: str, char: str) -> None: ...
        @overload
        def put(self, string: str, double: float) -> None: ...
        @overload
        def put(self, string: str, float: float) -> None: ...
        @overload
        def put(self, string: str, int: int) -> None: ...
        @overload
        def put(self, string: str, object: _py_Any) -> None: ...
        @overload
        def put(self, string: str, long: int) -> None: ...
        @overload
        def put(self, string: str, short: int) -> None: ...
        def write(self, objectOutput: ObjectOutput) -> None: ...

class OptionalDataException(ObjectStreamException):
    length: int = ...
    eof: bool = ...

class OutputStreamWriter(Writer):
    @overload
    def __init__(self, outputStream: OutputStream): ...
    @overload
    def __init__(self, outputStream: OutputStream, string: str): ...
    @overload
    def __init__(self, outputStream: OutputStream, charset: java.nio.charset.Charset): ...
    @overload
    def __init__(self, outputStream: OutputStream, charsetEncoder: java.nio.charset.CharsetEncoder): ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    def getEncoding(self) -> str: ...
    @overload
    def write(self, charArray: _py_List[str], int: int, int2: int) -> None: ...
    @overload
    def write(self, int: int) -> None: ...
    @overload
    def write(self, string: str, int: int, int2: int) -> None: ...
    @overload
    def write(self, charArray: _py_List[str]) -> None: ...
    @overload
    def write(self, string: str) -> None: ...

class PipedInputStream(InputStream):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, pipedOutputStream: 'PipedOutputStream'): ...
    @overload
    def __init__(self, pipedOutputStream: 'PipedOutputStream', int: int): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    def connect(self, pipedOutputStream: 'PipedOutputStream') -> None: ...
    @overload
    def read(self, byteArray: _py_List[int]) -> int: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int], int: int, int2: int) -> int: ...

class PipedOutputStream(OutputStream):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, pipedInputStream: PipedInputStream): ...
    def close(self) -> None: ...
    def connect(self, pipedInputStream: PipedInputStream) -> None: ...
    def flush(self) -> None: ...
    @overload
    def write(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def write(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...
    @overload
    def write(self, int: int) -> None: ...

class PipedReader(Reader):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, pipedWriter: 'PipedWriter'): ...
    @overload
    def __init__(self, pipedWriter: 'PipedWriter', int: int): ...
    def close(self) -> None: ...
    def connect(self, pipedWriter: 'PipedWriter') -> None: ...
    @overload
    def read(self, charArray: _py_List[str]) -> int: ...
    @overload
    def read(self, charBuffer: java.nio.CharBuffer) -> int: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, charArray: _py_List[str], int: int, int2: int) -> int: ...
    def ready(self) -> bool: ...

class PipedWriter(Writer):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, pipedReader: PipedReader): ...
    def close(self) -> None: ...
    def connect(self, pipedReader: PipedReader) -> None: ...
    def flush(self) -> None: ...
    @overload
    def write(self, charArray: _py_List[str], int: int, int2: int) -> None: ...
    @overload
    def write(self, int: int) -> None: ...
    @overload
    def write(self, charArray: _py_List[str]) -> None: ...
    @overload
    def write(self, string: str) -> None: ...
    @overload
    def write(self, string: str, int: int, int2: int) -> None: ...

class PrintWriter(Writer):
    @overload
    def __init__(self, file: File): ...
    @overload
    def __init__(self, file: File, string: str): ...
    @overload
    def __init__(self, outputStream: OutputStream): ...
    @overload
    def __init__(self, outputStream: OutputStream, boolean: bool): ...
    @overload
    def __init__(self, writer: Writer): ...
    @overload
    def __init__(self, writer: Writer, boolean: bool): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    @overload
    def append(self, char: str) -> 'PrintWriter': ...
    @overload
    def append(self, charSequence: java.lang.CharSequence) -> 'PrintWriter': ...
    @overload
    def append(self, charSequence: java.lang.CharSequence, int: int, int2: int) -> 'PrintWriter': ...
    @overload
    def append(self, char: str) -> Writer: ...
    @overload
    def append(self, charSequence: java.lang.CharSequence) -> Writer: ...
    @overload
    def append(self, charSequence: java.lang.CharSequence, int: int, int2: int) -> Writer: ...
    @overload
    def append(self, char: str) -> java.lang.Appendable: ...
    @overload
    def append(self, charSequence: java.lang.CharSequence) -> java.lang.Appendable: ...
    @overload
    def append(self, charSequence: java.lang.CharSequence, int: int, int2: int) -> java.lang.Appendable: ...
    def checkError(self) -> bool: ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    @overload
    def format(self, string: str, objectArray: _py_List[_py_Any]) -> 'PrintWriter': ...
    @overload
    def format(self, locale: java.util.Locale, string: str, objectArray: _py_List[_py_Any]) -> 'PrintWriter': ...
    @overload
    def printf(self, string: str, objectArray: _py_List[_py_Any]) -> 'PrintWriter': ...
    @overload
    def printf(self, locale: java.util.Locale, string: str, objectArray: _py_List[_py_Any]) -> 'PrintWriter': ...
    @overload
    def println(self) -> None: ...
    @overload
    def println(self, boolean: bool) -> None: ...
    @overload
    def println(self, char: str) -> None: ...
    @overload
    def println(self, charArray: _py_List[str]) -> None: ...
    @overload
    def println(self, double: float) -> None: ...
    @overload
    def println(self, float: float) -> None: ...
    @overload
    def println(self, int: int) -> None: ...
    @overload
    def println(self, object: _py_Any) -> None: ...
    @overload
    def println(self, string: str) -> None: ...
    @overload
    def println(self, long: int) -> None: ...
    @overload
    def write(self, charArray: _py_List[str]) -> None: ...
    @overload
    def write(self, charArray: _py_List[str], int: int, int2: int) -> None: ...
    @overload
    def write(self, int: int) -> None: ...
    @overload
    def write(self, string: str) -> None: ...
    @overload
    def write(self, string: str, int: int, int2: int) -> None: ...

class SequenceInputStream(InputStream):
    @overload
    def __init__(self, inputStream: InputStream, inputStream2: InputStream): ...
    @overload
    def __init__(self, enumeration: java.util.Enumeration[InputStream]): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    @overload
    def read(self, byteArray: _py_List[int]) -> int: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int], int: int, int2: int) -> int: ...

class StreamCorruptedException(ObjectStreamException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class StringBufferInputStream(InputStream):
    def __init__(self, string: str): ...
    def available(self) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int]) -> int: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int], int: int, int2: int) -> int: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...

class StringReader(Reader):
    def __init__(self, string: str): ...
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @overload
    def read(self, charArray: _py_List[str]) -> int: ...
    @overload
    def read(self, charBuffer: java.nio.CharBuffer) -> int: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, charArray: _py_List[str], int: int, int2: int) -> int: ...
    def ready(self) -> bool: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...

class StringWriter(Writer):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int): ...
    @overload
    def append(self, char: str) -> 'StringWriter': ...
    @overload
    def append(self, charSequence: java.lang.CharSequence) -> 'StringWriter': ...
    @overload
    def append(self, charSequence: java.lang.CharSequence, int: int, int2: int) -> 'StringWriter': ...
    @overload
    def append(self, char: str) -> Writer: ...
    @overload
    def append(self, charSequence: java.lang.CharSequence) -> Writer: ...
    @overload
    def append(self, charSequence: java.lang.CharSequence, int: int, int2: int) -> Writer: ...
    @overload
    def append(self, char: str) -> java.lang.Appendable: ...
    @overload
    def append(self, charSequence: java.lang.CharSequence) -> java.lang.Appendable: ...
    @overload
    def append(self, charSequence: java.lang.CharSequence, int: int, int2: int) -> java.lang.Appendable: ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    def getBuffer(self) -> java.lang.StringBuffer: ...
    def toString(self) -> str: ...
    @overload
    def write(self, charArray: _py_List[str], int: int, int2: int) -> None: ...
    @overload
    def write(self, int: int) -> None: ...
    @overload
    def write(self, string: str) -> None: ...
    @overload
    def write(self, string: str, int: int, int2: int) -> None: ...
    @overload
    def write(self, charArray: _py_List[str]) -> None: ...

class WriteAbortedException(ObjectStreamException):
    detail: java.lang.Exception = ...
    def __init__(self, string: str, exception: java.lang.Exception): ...
    def getCause(self) -> java.lang.Throwable: ...
    def getMessage(self) -> str: ...

class BufferedInputStream(FilterInputStream):
    @overload
    def __init__(self, inputStream: InputStream): ...
    @overload
    def __init__(self, inputStream: InputStream, int: int): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @overload
    def read(self, byteArray: _py_List[int]) -> int: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int], int: int, int2: int) -> int: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...

class BufferedOutputStream(FilterOutputStream):
    @overload
    def __init__(self, outputStream: OutputStream): ...
    @overload
    def __init__(self, outputStream: OutputStream, int: int): ...
    def flush(self) -> None: ...
    @overload
    def write(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...
    @overload
    def write(self, int: int) -> None: ...
    @overload
    def write(self, byteArray: _py_List[int]) -> None: ...

class DataInputStream(FilterInputStream, DataInput):
    def __init__(self, inputStream: InputStream): ...
    @overload
    def read(self, byteArray: _py_List[int]) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int], int: int, int2: int) -> int: ...
    @overload
    def read(self) -> int: ...
    def readBoolean(self) -> bool: ...
    def readByte(self) -> int: ...
    def readChar(self) -> str: ...
    def readDouble(self) -> float: ...
    def readFloat(self) -> float: ...
    @overload
    def readFully(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def readFully(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...
    def readInt(self) -> int: ...
    def readLine(self) -> str: ...
    def readLong(self) -> int: ...
    def readShort(self) -> int: ...
    @overload
    def readUTF(self) -> str: ...
    @classmethod
    @overload
    def readUTF(cls, dataInput: DataInput) -> str: ...
    def readUnsignedByte(self) -> int: ...
    def readUnsignedShort(self) -> int: ...
    def skipBytes(self, int: int) -> int: ...

class DataOutputStream(FilterOutputStream, DataOutput):
    def __init__(self, outputStream: OutputStream): ...
    def flush(self) -> None: ...
    def size(self) -> int: ...
    @overload
    def write(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...
    @overload
    def write(self, int: int) -> None: ...
    @overload
    def write(self, byteArray: _py_List[int]) -> None: ...
    def writeBoolean(self, boolean: bool) -> None: ...
    def writeByte(self, int: int) -> None: ...
    def writeBytes(self, string: str) -> None: ...
    def writeChar(self, int: int) -> None: ...
    def writeChars(self, string: str) -> None: ...
    def writeDouble(self, double: float) -> None: ...
    def writeFloat(self, float: float) -> None: ...
    def writeInt(self, int: int) -> None: ...
    def writeLong(self, long: int) -> None: ...
    def writeShort(self, int: int) -> None: ...
    def writeUTF(self, string: str) -> None: ...

class FileReader(InputStreamReader):
    @overload
    def __init__(self, file: File): ...
    @overload
    def __init__(self, fileDescriptor: FileDescriptor): ...
    @overload
    def __init__(self, string: str): ...

class FileWriter(OutputStreamWriter):
    @overload
    def __init__(self, file: File): ...
    @overload
    def __init__(self, file: File, boolean: bool): ...
    @overload
    def __init__(self, fileDescriptor: FileDescriptor): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, boolean: bool): ...

class LineNumberInputStream(FilterInputStream):
    def __init__(self, inputStream: InputStream): ...
    def available(self) -> int: ...
    def getLineNumber(self) -> int: ...
    def mark(self, int: int) -> None: ...
    @overload
    def read(self, byteArray: _py_List[int]) -> int: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int], int: int, int2: int) -> int: ...
    def reset(self) -> None: ...
    def setLineNumber(self, int: int) -> None: ...
    def skip(self, long: int) -> int: ...

class LineNumberReader(BufferedReader):
    @overload
    def __init__(self, reader: Reader): ...
    @overload
    def __init__(self, reader: Reader, int: int): ...
    def getLineNumber(self) -> int: ...
    def mark(self, int: int) -> None: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, charArray: _py_List[str], int: int, int2: int) -> int: ...
    @overload
    def read(self, charArray: _py_List[str]) -> int: ...
    @overload
    def read(self, charBuffer: java.nio.CharBuffer) -> int: ...
    def readLine(self) -> str: ...
    def reset(self) -> None: ...
    def setLineNumber(self, int: int) -> None: ...
    def skip(self, long: int) -> int: ...

class PrintStream(FilterOutputStream, java.lang.Appendable, Closeable):
    @overload
    def __init__(self, file: File): ...
    @overload
    def __init__(self, file: File, string: str): ...
    @overload
    def __init__(self, outputStream: OutputStream): ...
    @overload
    def __init__(self, outputStream: OutputStream, boolean: bool): ...
    @overload
    def __init__(self, outputStream: OutputStream, boolean: bool, string: str): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    @overload
    def append(self, char: str) -> 'PrintStream': ...
    @overload
    def append(self, charSequence: java.lang.CharSequence) -> 'PrintStream': ...
    @overload
    def append(self, charSequence: java.lang.CharSequence, int: int, int2: int) -> 'PrintStream': ...
    @overload
    def append(self, char: str) -> java.lang.Appendable: ...
    @overload
    def append(self, charSequence: java.lang.CharSequence) -> java.lang.Appendable: ...
    @overload
    def append(self, charSequence: java.lang.CharSequence, int: int, int2: int) -> java.lang.Appendable: ...
    def checkError(self) -> bool: ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    @overload
    def format(self, string: str, objectArray: _py_List[_py_Any]) -> 'PrintStream': ...
    @overload
    def format(self, locale: java.util.Locale, string: str, objectArray: _py_List[_py_Any]) -> 'PrintStream': ...
    @overload
    def printf(self, string: str, objectArray: _py_List[_py_Any]) -> 'PrintStream': ...
    @overload
    def printf(self, locale: java.util.Locale, string: str, objectArray: _py_List[_py_Any]) -> 'PrintStream': ...
    @overload
    def println(self) -> None: ...
    @overload
    def println(self, boolean: bool) -> None: ...
    @overload
    def println(self, char: str) -> None: ...
    @overload
    def println(self, charArray: _py_List[str]) -> None: ...
    @overload
    def println(self, double: float) -> None: ...
    @overload
    def println(self, float: float) -> None: ...
    @overload
    def println(self, int: int) -> None: ...
    @overload
    def println(self, object: _py_Any) -> None: ...
    @overload
    def println(self, string: str) -> None: ...
    @overload
    def println(self, long: int) -> None: ...
    @overload
    def write(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def write(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...
    @overload
    def write(self, int: int) -> None: ...

class PushbackInputStream(FilterInputStream):
    @overload
    def __init__(self, inputStream: InputStream): ...
    @overload
    def __init__(self, inputStream: InputStream, int: int): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @overload
    def read(self, byteArray: _py_List[int]) -> int: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int], int: int, int2: int) -> int: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...
    @overload
    def unread(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def unread(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...
    @overload
    def unread(self, int: int) -> None: ...

class PushbackReader(FilterReader):
    @overload
    def __init__(self, reader: Reader): ...
    @overload
    def __init__(self, reader: Reader, int: int): ...
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, charArray: _py_List[str], int: int, int2: int) -> int: ...
    @overload
    def read(self, charArray: _py_List[str]) -> int: ...
    @overload
    def read(self, charBuffer: java.nio.CharBuffer) -> int: ...
    def ready(self) -> bool: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...
    @overload
    def unread(self, charArray: _py_List[str]) -> None: ...
    @overload
    def unread(self, charArray: _py_List[str], int: int, int2: int) -> None: ...
    @overload
    def unread(self, int: int) -> None: ...
