from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.domain
import cern.accsoft.commons.domain.particletransfers
import cern.accsoft.commons.util
import cern.accsoft.commons.value
import cern.lsa.domain.commons
import cern.lsa.domain.settings
import java.lang
import java.util


class BaseTypes:
    BASE_TYPE_NAME_COMPARATOR: _py_ClassVar[java.util.Comparator] = ...
    @classmethod
    def isPreCycling(cls, beamProcessType: 'BeamProcessType') -> bool: ...

class BeamProcessPurpose(cern.accsoft.commons.util.Named):
    def isDefault(self) -> bool: ...

class BeamProcessPurposes:
    _filterBeamProcessesByPurposes__T = _py_TypeVar('_filterBeamProcessesByPurposes__T', bound=cern.lsa.domain.settings.BeamProcess)  # <T>
    @classmethod
    def filterBeamProcessesByPurposes(cls, collection: java.util.Collection[_filterBeamProcessesByPurposes__T], collection2: java.util.Collection[BeamProcessPurpose]) -> java.util.Collection[_filterBeamProcessesByPurposes__T]: ...
    _getBeamProcessByPurpose__T = _py_TypeVar('_getBeamProcessByPurpose__T', bound=cern.lsa.domain.settings.BeamProcess)  # <T>
    @classmethod
    def getBeamProcessByPurpose(cls, collection: java.util.Collection[_getBeamProcessByPurpose__T], beamProcessPurpose: BeamProcessPurpose) -> _getBeamProcessByPurpose__T: ...

class BeamProcessTypeCategory(java.lang.Enum['BeamProcessTypeCategory']):
    FUNCTION_BEAM_IN: _py_ClassVar['BeamProcessTypeCategory'] = ...
    FUNCTION_BEAM_OUT: _py_ClassVar['BeamProcessTypeCategory'] = ...
    DISCRETE: _py_ClassVar['BeamProcessTypeCategory'] = ...
    def isBeamIn(self) -> bool: ...
    def isBeamOut(self) -> bool: ...
    def isDiscrete(self) -> bool: ...
    def isFunction(self) -> bool: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'BeamProcessTypeCategory': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['BeamProcessTypeCategory']: ...

class BeamProcessTypeSegmentAttribute(cern.lsa.domain.commons.Attribute):
    @overload
    def getAttributeDefinition(self) -> 'BeamProcessTypeSegmentAttributeDefinition': ...
    @overload
    def getAttributeDefinition(self) -> cern.lsa.domain.commons.AttributeDefinition: ...
    def getSegmentIndex(self) -> int: ...

class BeamProcessTypeSegmentAttributeDefinition(cern.lsa.domain.commons.AttributeDefinition):
    def getSegmentId(self) -> int: ...
    def getSegmentName(self) -> str: ...

class BeamProcessTypeSegmentAttributes:
    def __init__(self): ...
    @classmethod
    def getSegmentNames(cls, collection: java.util.Collection[BeamProcessTypeSegmentAttributeDefinition]) -> java.util.SortedSet[str]: ...
    @classmethod
    def mapAttributeDefinitionsBySegmentName(cls, collection: java.util.Collection[BeamProcessTypeSegmentAttributeDefinition]) -> java.util.Map[str, java.util.Set[BeamProcessTypeSegmentAttributeDefinition]]: ...

class BeamProcessTypeSegments:
    def getAttributeDoubleValue(self, int: int, string: str) -> float: ...
    def getAttributeDoubleValues(self, string: str) -> _py_List[float]: ...
    def getAttributeNames(self, int: int) -> java.util.Set[str]: ...
    def getAttributeStringValue(self, int: int, string: str) -> str: ...
    def getAttributes(self) -> java.util.List[BeamProcessTypeSegmentAttribute]: ...
    def getSegmentCount(self) -> int: ...
    def getSegmentName(self, int: int) -> str: ...
    def hasAttribute(self, int: int, string: str) -> bool: ...

class ContextType(cern.lsa.domain.commons.IdentifiedEntity, cern.accsoft.commons.util.Named, java.lang.Comparable['ContextType']):
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getContextCategory(self) -> cern.lsa.domain.settings.ContextCategory: ...
    def getCreationDate(self) -> java.util.Date: ...
    def getDescription(self) -> str: ...
    def getLength(self) -> int: ...

class CycleTypeAttribute(cern.accsoft.commons.util.Named):
    def getDescription(self) -> str: ...
    def getValue(self) -> cern.accsoft.commons.value.ImmutableScalar: ...

class IncorporationBounds:
    def __init__(self): ...
    class Backward(java.lang.Enum['IncorporationBounds.Backward']):
        BP_START: _py_ClassVar['IncorporationBounds.Backward'] = ...
        RANGE_START: _py_ClassVar['IncorporationBounds.Backward'] = ...
        PREV_OPTIC: _py_ClassVar['IncorporationBounds.Backward'] = ...
        CUSTOM: _py_ClassVar['IncorporationBounds.Backward'] = ...
        @classmethod
        def fromString(cls, string: str) -> 'IncorporationBounds.Backward': ...
        def toString(self) -> str: ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'IncorporationBounds.Backward': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['IncorporationBounds.Backward']: ...
    class Forward(java.lang.Enum['IncorporationBounds.Forward']):
        BP_END: _py_ClassVar['IncorporationBounds.Forward'] = ...
        RANGE_END: _py_ClassVar['IncorporationBounds.Forward'] = ...
        NEXT_OPTIC: _py_ClassVar['IncorporationBounds.Forward'] = ...
        CUSTOM: _py_ClassVar['IncorporationBounds.Forward'] = ...
        @classmethod
        def fromString(cls, string: str) -> 'IncorporationBounds.Forward': ...
        def toString(self) -> str: ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'IncorporationBounds.Forward': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['IncorporationBounds.Forward']: ...

class IncorporationRange:
    def clone(self) -> _py_Any: ...
    def getBackwardIncorporationRule(self) -> str: ...
    def getBackwardIncorporationRuleParameter(self) -> str: ...
    def getBeamProcessTypeName(self) -> str: ...
    def getEndTime(self) -> int: ...
    def getForwardIncorporationRule(self) -> str: ...
    def getForwardIncorporationRuleParameter(self) -> str: ...
    def getParameterGroupName(self) -> str: ...
    def getParameterTypeName(self) -> str: ...
    def getStartTime(self) -> int: ...
    def setBeamProcessTypeName(self, string: str) -> None: ...

class IncorporationRuleDescriptor:
    def getRuleName(self) -> str: ...
    def isParametrized(self) -> bool: ...

class TypeSchedulingItem:
    SCHEDULING_START_TIME_COMPARATOR: _py_ClassVar[java.util.Comparator] = ...
    def getScheduledType(self) -> ContextType: ...
    def getStartTime(self) -> int: ...

class BeamProcessType(ContextType):
    def getCategory(self) -> BeamProcessTypeCategory: ...
    def getParticleTransfer(self) -> cern.accsoft.commons.domain.particletransfers.ParticleTransfer: ...
    def getParticleType(self) -> cern.accsoft.commons.domain.ParticleType: ...
    def getPurpose(self) -> BeamProcessPurpose: ...
    def getSegments(self) -> BeamProcessTypeSegments: ...
    def isExplicit(self) -> bool: ...

class TypeScheduler(ContextType):
    def getParticleTransfers(self) -> java.util.Set[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]: ...
    def getSchedulings(self) -> java.util.List[TypeSchedulingItem]: ...

class CycleType(TypeScheduler, cern.lsa.domain.commons.AttributeAware):
    def getBeamProcessType(self, string: str) -> BeamProcessType: ...
