from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import ClassVar as _py_ClassVar
from typing import Generic as _py_Generic
from typing import overload
import cern.accsoft.commons.domain
import cern.accsoft.commons.domain.particletransfers
import cern.accsoft.commons.domain.zones
import cern.accsoft.commons.value
import cern.lsa.domain.commons
import cern.lsa.domain.commons.spi
import cern.lsa.domain.devices
import cern.lsa.domain.devices.type
import cern.lsa.domain.settings
import cern.lsa.domain.settings.spi
import cern.lsa.domain.settings.type
import java.time
import java.util


_AbstractKnobBuilder__T = _py_TypeVar('_AbstractKnobBuilder__T', bound='AbstractKnobBuilder')  # <T>
class AbstractKnobBuilder(_py_Generic[_AbstractKnobBuilder__T]):
    @overload
    def addFactor(self, knobFactor: cern.lsa.domain.settings.KnobFactor) -> _AbstractKnobBuilder__T: ...
    @overload
    def addFactor(self, string: str, string2: str, double: float) -> _AbstractKnobBuilder__T: ...
    @overload
    def addOrUpdateFactor(self, knobFactor: cern.lsa.domain.settings.KnobFactor) -> _AbstractKnobBuilder__T: ...
    @overload
    def addOrUpdateFactor(self, string: str, string2: str, double: float) -> _AbstractKnobBuilder__T: ...
    def build(self) -> cern.lsa.domain.settings.Knob: ...
    def clear(self) -> _AbstractKnobBuilder__T: ...
    def removeFactor(self, string: str, string2: str) -> _AbstractKnobBuilder__T: ...
    @overload
    def updateFactor(self, knobFactor: cern.lsa.domain.settings.KnobFactor) -> _AbstractKnobBuilder__T: ...
    @overload
    def updateFactor(self, string: str, string2: str, double: float) -> _AbstractKnobBuilder__T: ...

class BeamProcessIncorporationRequestBuilder(cern.lsa.domain.commons.spi.AbstractPropertiesHolder):
    def __init__(self): ...
    def build(self) -> cern.lsa.domain.settings.BeamProcessIncorporationRequest: ...
    def setDescription(self, string: str) -> 'BeamProcessIncorporationRequestBuilder': ...
    def setDestBeamProcess(self, beamProcess: cern.lsa.domain.settings.BeamProcess) -> 'BeamProcessIncorporationRequestBuilder': ...
    def setDestPointInTime(self, double: float) -> 'BeamProcessIncorporationRequestBuilder': ...
    def setDrive(self, boolean: bool) -> 'BeamProcessIncorporationRequestBuilder': ...
    def setIncorporateAllParameters(self) -> 'BeamProcessIncorporationRequestBuilder': ...
    def setParameters(self, collection: java.util.Collection[cern.lsa.domain.settings.Parameter]) -> 'BeamProcessIncorporationRequestBuilder': ...
    def setSettingPart(self, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> 'BeamProcessIncorporationRequestBuilder': ...
    def setSettingsSource(self, settingsSource: cern.lsa.domain.settings.SettingsSource) -> 'BeamProcessIncorporationRequestBuilder': ...
    def setSourceBeamProcess(self, beamProcess: cern.lsa.domain.settings.BeamProcess) -> 'BeamProcessIncorporationRequestBuilder': ...
    def setSourcePointInTime(self, double: float) -> 'BeamProcessIncorporationRequestBuilder': ...

class ContextSettingsBuilder:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, contextSettings: cern.lsa.domain.settings.ContextSettings): ...
    def addFunction(self, parameter: cern.lsa.domain.settings.Parameter, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction) -> 'ContextSettingsBuilder': ...
    def addFunctionsArray(self, parameter: cern.lsa.domain.settings.Parameter, immutableDiscreteFunctionsArray: cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray) -> 'ContextSettingsBuilder': ...
    @overload
    def addScalar(self, parameter: cern.lsa.domain.settings.Parameter, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> 'ContextSettingsBuilder': ...
    @overload
    def addScalar(self, parameter: cern.lsa.domain.settings.Parameter, drivableContext: cern.lsa.domain.settings.DrivableContext, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> 'ContextSettingsBuilder': ...
    def addSetting(self, setting: cern.lsa.domain.settings.Setting) -> 'ContextSettingsBuilder': ...
    def addValue(self, parameter: cern.lsa.domain.settings.Parameter, beamProcess: cern.lsa.domain.settings.BeamProcess, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> 'ContextSettingsBuilder': ...
    def build(self) -> cern.lsa.domain.settings.ContextSettings: ...
    def context(self, standAloneContext: cern.lsa.domain.settings.StandAloneContext) -> 'ContextSettingsBuilder': ...
    def parameterSettingMap(self, map: java.util.Map[str, cern.lsa.domain.settings.spi.ParameterSettingsImpl]) -> 'ContextSettingsBuilder': ...
    def parameterSettings(self, collection: java.util.Collection[cern.lsa.domain.settings.spi.ParameterSettingsImpl]) -> 'ContextSettingsBuilder': ...

class ParameterTreesRequestBuilder:
    def __init__(self): ...
    def build(self) -> cern.lsa.domain.settings.ParameterTreesRequest: ...
    @classmethod
    def byParameterAndHierarchyFindDependentTrees(cls, string: str, string2: str) -> cern.lsa.domain.settings.ParameterTreesRequest: ...
    @classmethod
    def byParameterAndHierarchyFindSourceTrees(cls, string: str, string2: str) -> cern.lsa.domain.settings.ParameterTreesRequest: ...
    @classmethod
    def byParameterFindDependentTrees(cls, string: str) -> cern.lsa.domain.settings.ParameterTreesRequest: ...
    @classmethod
    def byParameterFindSourceTrees(cls, string: str) -> cern.lsa.domain.settings.ParameterTreesRequest: ...
    def setHierarchy(self, string: str) -> 'ParameterTreesRequestBuilder': ...
    def setParameter(self, parameter: cern.lsa.domain.settings.Parameter) -> 'ParameterTreesRequestBuilder': ...
    def setParameterName(self, string: str) -> 'ParameterTreesRequestBuilder': ...
    def setParameterNames(self, collection: java.util.Collection[str]) -> 'ParameterTreesRequestBuilder': ...
    def setParameters(self, collection: java.util.Collection[cern.lsa.domain.settings.Parameter]) -> 'ParameterTreesRequestBuilder': ...
    def setTreeDirection(self, treeDirection: cern.lsa.domain.settings.ParameterTreesRequest.TreeDirection) -> 'ParameterTreesRequestBuilder': ...

class ParameterTypesRequestBuilder:
    ALL_PARAMETER_TYPES: _py_ClassVar[cern.lsa.domain.settings.ParameterTypesRequest] = ...
    def __init__(self): ...
    def build(self) -> cern.lsa.domain.settings.ParameterTypesRequest: ...
    @classmethod
    def byParameterTypeName(cls, string: str) -> cern.lsa.domain.settings.ParameterTypesRequest: ...
    @classmethod
    @overload
    def byParameterTypeNames(cls, stringArray: _py_List[str]) -> cern.lsa.domain.settings.ParameterTypesRequest: ...
    @classmethod
    @overload
    def byParameterTypeNames(cls, collection: java.util.Collection[str]) -> cern.lsa.domain.settings.ParameterTypesRequest: ...
    def setParameterTypeName(self, string: str) -> 'ParameterTypesRequestBuilder': ...
    def setParameterTypeNames(self, collection: java.util.Collection[str]) -> 'ParameterTypesRequestBuilder': ...

class ParametersRequestBuilder:
    def __init__(self): ...
    def build(self) -> cern.lsa.domain.settings.ParametersRequest: ...
    @classmethod
    def byAccelerator(cls, accelerator: cern.accsoft.commons.domain.Accelerator) -> cern.lsa.domain.settings.ParametersRequest: ...
    @classmethod
    def byAcceleratorZone(cls, acceleratorZone: cern.accsoft.commons.domain.zones.AcceleratorZone) -> cern.lsa.domain.settings.ParametersRequest: ...
    @classmethod
    def byAcceleratorZones(cls, collection: java.util.Collection[cern.accsoft.commons.domain.zones.AcceleratorZone]) -> cern.lsa.domain.settings.ParametersRequest: ...
    @classmethod
    def byDevice(cls, device: cern.lsa.domain.devices.Device) -> cern.lsa.domain.settings.ParametersRequest: ...
    @classmethod
    def byDeviceName(cls, string: str) -> cern.lsa.domain.settings.ParametersRequest: ...
    @classmethod
    def byDeviceNames(cls, collection: java.util.Collection[str]) -> cern.lsa.domain.settings.ParametersRequest: ...
    @classmethod
    def byDevices(cls, collection: java.util.Collection[cern.lsa.domain.devices.Device]) -> cern.lsa.domain.settings.ParametersRequest: ...
    @classmethod
    def byParameterGroup(cls, string: str) -> cern.lsa.domain.settings.ParametersRequest: ...
    @classmethod
    def byParameterGroups(cls, collection: java.util.Collection[str]) -> cern.lsa.domain.settings.ParametersRequest: ...
    @classmethod
    def byParameterName(cls, string: str) -> cern.lsa.domain.settings.ParametersRequest: ...
    @classmethod
    def byParameterNamePattern(cls, string: str) -> cern.lsa.domain.settings.ParametersRequest: ...
    @classmethod
    def byParameterNames(cls, collection: java.util.Collection[str]) -> cern.lsa.domain.settings.ParametersRequest: ...
    @classmethod
    def byParameterType(cls, string: str) -> cern.lsa.domain.settings.ParametersRequest: ...
    @classmethod
    def byParameterTypes(cls, collection: java.util.Collection[str]) -> cern.lsa.domain.settings.ParametersRequest: ...
    @classmethod
    def byParticleTransfer(cls, particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer) -> cern.lsa.domain.settings.ParametersRequest: ...
    @classmethod
    def byParticleTransfers(cls, collection: java.util.Collection[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]) -> cern.lsa.domain.settings.ParametersRequest: ...
    @classmethod
    def byPropertyField(cls, propertyField: cern.lsa.domain.devices.type.PropertyField) -> cern.lsa.domain.settings.ParametersRequest: ...
    @classmethod
    def byPropertyFields(cls, collection: java.util.Collection[cern.lsa.domain.devices.type.PropertyField]) -> cern.lsa.domain.settings.ParametersRequest: ...
    def setAccelerator(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> 'ParametersRequestBuilder': ...
    def setAcceleratorZone(self, acceleratorZone: cern.accsoft.commons.domain.zones.AcceleratorZone) -> 'ParametersRequestBuilder': ...
    def setAcceleratorZones(self, collection: java.util.Collection[cern.accsoft.commons.domain.zones.AcceleratorZone]) -> 'ParametersRequestBuilder': ...
    def setCritical(self, boolean: bool) -> 'ParametersRequestBuilder': ...
    def setDevice(self, device: cern.lsa.domain.devices.Device) -> 'ParametersRequestBuilder': ...
    def setDeviceName(self, string: str) -> 'ParametersRequestBuilder': ...
    def setDeviceNames(self, collection: java.util.Collection[str]) -> 'ParametersRequestBuilder': ...
    def setDevices(self, collection: java.util.Collection[cern.lsa.domain.devices.Device]) -> 'ParametersRequestBuilder': ...
    def setMultiplexed(self, boolean: bool) -> 'ParametersRequestBuilder': ...
    def setParameterGroup(self, string: str) -> 'ParametersRequestBuilder': ...
    def setParameterGroups(self, collection: java.util.Collection[str]) -> 'ParametersRequestBuilder': ...
    def setParameterName(self, string: str) -> 'ParametersRequestBuilder': ...
    def setParameterNamePattern(self, string: str) -> 'ParametersRequestBuilder': ...
    def setParameterNames(self, collection: java.util.Collection[str]) -> 'ParametersRequestBuilder': ...
    def setParameterTypeName(self, string: str) -> 'ParametersRequestBuilder': ...
    def setParameterTypeNames(self, collection: java.util.Collection[str]) -> 'ParametersRequestBuilder': ...
    def setParticleTransfer(self, particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer) -> 'ParametersRequestBuilder': ...
    def setParticleTransfers(self, collection: java.util.Collection[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]) -> 'ParametersRequestBuilder': ...
    def setPropertyFields(self, collection: java.util.Collection[cern.lsa.domain.devices.type.PropertyField]) -> 'ParametersRequestBuilder': ...
    def setPropertyName(self, string: str) -> 'ParametersRequestBuilder': ...
    def setPropertyNames(self, collection: java.util.Collection[str]) -> 'ParametersRequestBuilder': ...
    def setReadable(self, boolean: bool) -> 'ParametersRequestBuilder': ...
    def setValueType(self, type: cern.accsoft.commons.value.Type) -> 'ParametersRequestBuilder': ...
    def setValueTypes(self, collection: java.util.Collection[cern.accsoft.commons.value.Type]) -> 'ParametersRequestBuilder': ...
    def setVirtual(self, boolean: bool) -> 'ParametersRequestBuilder': ...
    def setWritable(self, boolean: bool) -> 'ParametersRequestBuilder': ...

class SettingComparisonRequestBuilder:
    def __init__(self): ...
    def build(self) -> cern.lsa.domain.settings.SettingComparisonRequest: ...
    def setCompareAllParameters(self, boolean: bool) -> 'SettingComparisonRequestBuilder': ...
    def setDestinationBeamProcesses(self, list: java.util.List[cern.lsa.domain.settings.BeamProcess]) -> 'SettingComparisonRequestBuilder': ...
    def setDestinationSettingsSource(self, settingsSource: cern.lsa.domain.settings.SettingsSource) -> 'SettingComparisonRequestBuilder': ...
    def setIgnoreFlatFunctionsLength(self, boolean: bool) -> 'SettingComparisonRequestBuilder': ...
    def setParameters(self, collection: java.util.Collection[cern.lsa.domain.settings.Parameter]) -> 'SettingComparisonRequestBuilder': ...
    def setPointInDestFunction(self, int: int) -> 'SettingComparisonRequestBuilder': ...
    def setPointInSourceFunction(self, int: int) -> 'SettingComparisonRequestBuilder': ...
    def setSourceBeamProcesses(self, list: java.util.List[cern.lsa.domain.settings.BeamProcess]) -> 'SettingComparisonRequestBuilder': ...
    def setSourceSettingsSource(self, settingsSource: cern.lsa.domain.settings.SettingsSource) -> 'SettingComparisonRequestBuilder': ...

class StandAloneContextCloneRequestBuilder(cern.lsa.domain.commons.spi.AbstractPropertiesHolder):
    def __init__(self): ...
    def build(self) -> cern.lsa.domain.settings.StandAloneContextCloneRequest: ...
    def setAttributes(self, collection: java.util.Collection[cern.lsa.domain.commons.Attribute]) -> 'StandAloneContextCloneRequestBuilder': ...
    def setCloneName(self, string: str) -> 'StandAloneContextCloneRequestBuilder': ...
    def setContextCategory(self, contextCategory: cern.lsa.domain.settings.ContextCategory) -> 'StandAloneContextCloneRequestBuilder': ...
    def setDescription(self, string: str) -> 'StandAloneContextCloneRequestBuilder': ...
    def setHistoryCutOffDate(self, instant: java.time.Instant) -> 'StandAloneContextCloneRequestBuilder': ...
    def setSource(self, standAloneContext: cern.lsa.domain.settings.StandAloneContext) -> 'StandAloneContextCloneRequestBuilder': ...
    def setWithHistory(self, boolean: bool) -> 'StandAloneContextCloneRequestBuilder': ...
    def shouldCloneType(self, boolean: bool) -> 'StandAloneContextCloneRequestBuilder': ...

class StandAloneContextCreationRequestBuilder(cern.lsa.domain.commons.spi.AbstractPropertiesHolder):
    def __init__(self): ...
    def build(self) -> cern.lsa.domain.settings.StandAloneContextCreationRequest: ...
    def setAttributes(self, collection: java.util.Collection[cern.lsa.domain.commons.Attribute]) -> 'StandAloneContextCreationRequestBuilder': ...
    def setContextCategory(self, contextCategory: cern.lsa.domain.settings.ContextCategory) -> 'StandAloneContextCreationRequestBuilder': ...
    def setContextType(self, contextType: cern.lsa.domain.settings.type.ContextType) -> 'StandAloneContextCreationRequestBuilder': ...
    def setDescription(self, string: str) -> 'StandAloneContextCreationRequestBuilder': ...
    def setLength(self, integer: int) -> 'StandAloneContextCreationRequestBuilder': ...
    def setMultiplexed(self, boolean: bool) -> 'StandAloneContextCreationRequestBuilder': ...
    def setName(self, string: str) -> 'StandAloneContextCreationRequestBuilder': ...

class TrimRequestBuilder:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, trimRequest: cern.lsa.domain.settings.TrimRequest): ...
    def addCustomSettingPart(self, parameter: cern.lsa.domain.settings.Parameter, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> 'TrimRequestBuilder': ...
    def addFunction(self, parameter: cern.lsa.domain.settings.Parameter, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction) -> 'TrimRequestBuilder': ...
    def addFunctionsArray(self, parameter: cern.lsa.domain.settings.Parameter, immutableDiscreteFunctionsArray: cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray) -> 'TrimRequestBuilder': ...
    @overload
    def addScalar(self, parameter: cern.lsa.domain.settings.Parameter, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> 'TrimRequestBuilder': ...
    @overload
    def addScalar(self, parameter: cern.lsa.domain.settings.Parameter, drivableContext: cern.lsa.domain.settings.DrivableContext, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> 'TrimRequestBuilder': ...
    def addSetting(self, setting: cern.lsa.domain.settings.Setting) -> 'TrimRequestBuilder': ...
    def addValue(self, parameter: cern.lsa.domain.settings.Parameter, beamProcess: cern.lsa.domain.settings.BeamProcess, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> 'TrimRequestBuilder': ...
    def build(self) -> cern.lsa.domain.settings.TrimRequest: ...
    def newTrimRequest(self) -> cern.lsa.domain.settings.TrimRequest: ...
    def setAttribute(self, string: str, object: _py_Any) -> 'TrimRequestBuilder': ...
    def setChildSettingPart(self, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> 'TrimRequestBuilder': ...
    def setCommit(self, boolean: bool) -> 'TrimRequestBuilder': ...
    def setContext(self, standAloneContext: cern.lsa.domain.settings.StandAloneContext) -> 'TrimRequestBuilder': ...
    def setContextSettings(self, contextSettings: cern.lsa.domain.settings.ContextSettings) -> 'TrimRequestBuilder': ...
    def setCustomSettingPartMap(self, map: java.util.Map[cern.lsa.domain.settings.Parameter, cern.lsa.domain.settings.SettingPartEnum]) -> 'TrimRequestBuilder': ...
    def setDescription(self, string: str) -> 'TrimRequestBuilder': ...
    def setDrive(self, boolean: bool) -> 'TrimRequestBuilder': ...
    def setForceDrive(self, boolean: bool) -> 'TrimRequestBuilder': ...
    def setForceProcessing(self, boolean: bool) -> 'TrimRequestBuilder': ...
    def setIgnoreErrors(self, boolean: bool) -> 'TrimRequestBuilder': ...
    def setLenientDrive(self, boolean: bool) -> 'TrimRequestBuilder': ...
    def setParameters(self, collection: java.util.Collection[cern.lsa.domain.settings.Parameter]) -> 'TrimRequestBuilder': ...
    def setPersistSettings(self, boolean: bool) -> 'TrimRequestBuilder': ...
    def setPropagateToChildren(self, boolean: bool) -> 'TrimRequestBuilder': ...
    def setRelative(self, boolean: bool) -> 'TrimRequestBuilder': ...
    def setReturnSettings(self, boolean: bool) -> 'TrimRequestBuilder': ...
    def setSettingPart(self, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> 'TrimRequestBuilder': ...
    def setSkipProcessing(self, boolean: bool) -> 'TrimRequestBuilder': ...

class CopySettingsRequestBuilder(TrimRequestBuilder):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, copySettingsRequest: cern.lsa.domain.settings.CopySettingsRequest): ...
    @overload
    def __init__(self, trimRequest: cern.lsa.domain.settings.TrimRequest): ...
    @overload
    def addCustomSettingPart(self, parameter: cern.lsa.domain.settings.Parameter, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> 'CopySettingsRequestBuilder': ...
    @overload
    def addCustomSettingPart(self, parameter: cern.lsa.domain.settings.Parameter, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> TrimRequestBuilder: ...
    @overload
    def addFunction(self, parameter: cern.lsa.domain.settings.Parameter, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction) -> 'CopySettingsRequestBuilder': ...
    @overload
    def addFunction(self, parameter: cern.lsa.domain.settings.Parameter, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction) -> TrimRequestBuilder: ...
    @overload
    def addFunctionsArray(self, parameter: cern.lsa.domain.settings.Parameter, immutableDiscreteFunctionsArray: cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray) -> 'CopySettingsRequestBuilder': ...
    @overload
    def addFunctionsArray(self, parameter: cern.lsa.domain.settings.Parameter, immutableDiscreteFunctionsArray: cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray) -> TrimRequestBuilder: ...
    @overload
    def addScalar(self, parameter: cern.lsa.domain.settings.Parameter, drivableContext: cern.lsa.domain.settings.DrivableContext, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> 'CopySettingsRequestBuilder': ...
    @overload
    def addScalar(self, parameter: cern.lsa.domain.settings.Parameter, drivableContext: cern.lsa.domain.settings.DrivableContext, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> TrimRequestBuilder: ...
    @overload
    def addScalar(self, parameter: cern.lsa.domain.settings.Parameter, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> TrimRequestBuilder: ...
    @overload
    def addSetting(self, setting: cern.lsa.domain.settings.Setting) -> 'CopySettingsRequestBuilder': ...
    @overload
    def addSetting(self, setting: cern.lsa.domain.settings.Setting) -> TrimRequestBuilder: ...
    @overload
    def addValue(self, parameter: cern.lsa.domain.settings.Parameter, beamProcess: cern.lsa.domain.settings.BeamProcess, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> 'CopySettingsRequestBuilder': ...
    @overload
    def addValue(self, parameter: cern.lsa.domain.settings.Parameter, beamProcess: cern.lsa.domain.settings.BeamProcess, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> TrimRequestBuilder: ...
    @overload
    def build(self) -> cern.lsa.domain.settings.CopySettingsRequest: ...
    @overload
    def build(self) -> cern.lsa.domain.settings.TrimRequest: ...
    @overload
    def setAttribute(self, string: str, object: _py_Any) -> 'CopySettingsRequestBuilder': ...
    @overload
    def setAttribute(self, string: str, object: _py_Any) -> TrimRequestBuilder: ...
    @overload
    def setChildSettingPart(self, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> 'CopySettingsRequestBuilder': ...
    @overload
    def setChildSettingPart(self, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> TrimRequestBuilder: ...
    @overload
    def setContext(self, standAloneContext: cern.lsa.domain.settings.StandAloneContext) -> 'CopySettingsRequestBuilder': ...
    @overload
    def setContext(self, standAloneContext: cern.lsa.domain.settings.StandAloneContext) -> TrimRequestBuilder: ...
    @overload
    def setContextSettings(self, contextSettings: cern.lsa.domain.settings.ContextSettings) -> 'CopySettingsRequestBuilder': ...
    @overload
    def setContextSettings(self, contextSettings: cern.lsa.domain.settings.ContextSettings) -> TrimRequestBuilder: ...
    @overload
    def setCustomSettingPartMap(self, map: java.util.Map[cern.lsa.domain.settings.Parameter, cern.lsa.domain.settings.SettingPartEnum]) -> 'CopySettingsRequestBuilder': ...
    @overload
    def setCustomSettingPartMap(self, map: java.util.Map) -> TrimRequestBuilder: ...
    @overload
    def setDescription(self, string: str) -> 'CopySettingsRequestBuilder': ...
    @overload
    def setDescription(self, string: str) -> TrimRequestBuilder: ...
    def setDestinationContexts(self, collection: java.util.Collection[cern.lsa.domain.settings.Context]) -> 'CopySettingsRequestBuilder': ...
    def setDestinationParameters(self, collection: java.util.Collection[cern.lsa.domain.settings.Parameter]) -> 'CopySettingsRequestBuilder': ...
    @overload
    def setDrive(self, boolean: bool) -> 'CopySettingsRequestBuilder': ...
    @overload
    def setDrive(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setForceDrive(self, boolean: bool) -> 'CopySettingsRequestBuilder': ...
    @overload
    def setForceDrive(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setForceProcessing(self, boolean: bool) -> 'CopySettingsRequestBuilder': ...
    @overload
    def setForceProcessing(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setIgnoreErrors(self, boolean: bool) -> 'CopySettingsRequestBuilder': ...
    @overload
    def setIgnoreErrors(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setLenientDrive(self, boolean: bool) -> 'CopySettingsRequestBuilder': ...
    @overload
    def setLenientDrive(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setParameters(self, collection: java.util.Collection[cern.lsa.domain.settings.Parameter]) -> 'CopySettingsRequestBuilder': ...
    @overload
    def setParameters(self, collection: java.util.Collection) -> TrimRequestBuilder: ...
    @overload
    def setPersistSettings(self, boolean: bool) -> 'CopySettingsRequestBuilder': ...
    @overload
    def setPersistSettings(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setPropagateToChildren(self, boolean: bool) -> 'CopySettingsRequestBuilder': ...
    @overload
    def setPropagateToChildren(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setRelative(self, boolean: bool) -> 'CopySettingsRequestBuilder': ...
    @overload
    def setRelative(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setReturnSettings(self, boolean: bool) -> 'CopySettingsRequestBuilder': ...
    @overload
    def setReturnSettings(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setSettingPart(self, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> 'CopySettingsRequestBuilder': ...
    @overload
    def setSettingPart(self, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> TrimRequestBuilder: ...
    def setSettingsSource(self, settingsSource: cern.lsa.domain.settings.SettingsSource) -> 'CopySettingsRequestBuilder': ...
    @overload
    def setSkipProcessing(self, boolean: bool) -> 'CopySettingsRequestBuilder': ...
    @overload
    def setSkipProcessing(self, boolean: bool) -> TrimRequestBuilder: ...
    def setSourceContexts(self, collection: java.util.Collection[cern.lsa.domain.settings.Context]) -> 'CopySettingsRequestBuilder': ...

class IncorporationRequestBuilder(TrimRequestBuilder):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, incorporationRequest: cern.lsa.domain.settings.IncorporationRequest): ...
    @overload
    def addCustomSettingPart(self, parameter: cern.lsa.domain.settings.Parameter, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> 'IncorporationRequestBuilder': ...
    @overload
    def addCustomSettingPart(self, parameter: cern.lsa.domain.settings.Parameter, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> TrimRequestBuilder: ...
    @overload
    def addFunction(self, parameter: cern.lsa.domain.settings.Parameter, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction) -> 'IncorporationRequestBuilder': ...
    @overload
    def addFunction(self, parameter: cern.lsa.domain.settings.Parameter, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction) -> TrimRequestBuilder: ...
    @overload
    def addFunctionsArray(self, parameter: cern.lsa.domain.settings.Parameter, immutableDiscreteFunctionsArray: cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray) -> 'IncorporationRequestBuilder': ...
    @overload
    def addFunctionsArray(self, parameter: cern.lsa.domain.settings.Parameter, immutableDiscreteFunctionsArray: cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray) -> TrimRequestBuilder: ...
    def addIncorporationSetting(self, incorporationSetting: cern.lsa.domain.settings.IncorporationSetting) -> 'IncorporationRequestBuilder': ...
    @overload
    def addScalar(self, parameter: cern.lsa.domain.settings.Parameter, drivableContext: cern.lsa.domain.settings.DrivableContext, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> 'IncorporationRequestBuilder': ...
    @overload
    def addScalar(self, parameter: cern.lsa.domain.settings.Parameter, drivableContext: cern.lsa.domain.settings.DrivableContext, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> TrimRequestBuilder: ...
    @overload
    def addScalar(self, parameter: cern.lsa.domain.settings.Parameter, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> TrimRequestBuilder: ...
    @overload
    def addSetting(self, setting: cern.lsa.domain.settings.Setting) -> 'IncorporationRequestBuilder': ...
    @overload
    def addSetting(self, setting: cern.lsa.domain.settings.Setting) -> TrimRequestBuilder: ...
    @overload
    def addValue(self, parameter: cern.lsa.domain.settings.Parameter, beamProcess: cern.lsa.domain.settings.BeamProcess, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> 'IncorporationRequestBuilder': ...
    @overload
    def addValue(self, parameter: cern.lsa.domain.settings.Parameter, beamProcess: cern.lsa.domain.settings.BeamProcess, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> TrimRequestBuilder: ...
    @overload
    def build(self) -> cern.lsa.domain.settings.IncorporationRequest: ...
    @overload
    def build(self) -> cern.lsa.domain.settings.TrimRequest: ...
    @overload
    def setAttribute(self, string: str, object: _py_Any) -> 'IncorporationRequestBuilder': ...
    @overload
    def setAttribute(self, string: str, object: _py_Any) -> TrimRequestBuilder: ...
    @overload
    def setChildSettingPart(self, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> 'IncorporationRequestBuilder': ...
    @overload
    def setChildSettingPart(self, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> TrimRequestBuilder: ...
    @overload
    def setContext(self, standAloneContext: cern.lsa.domain.settings.StandAloneContext) -> 'IncorporationRequestBuilder': ...
    @overload
    def setContext(self, standAloneContext: cern.lsa.domain.settings.StandAloneContext) -> TrimRequestBuilder: ...
    @overload
    def setContextSettings(self, contextSettings: cern.lsa.domain.settings.ContextSettings) -> 'IncorporationRequestBuilder': ...
    @overload
    def setContextSettings(self, contextSettings: cern.lsa.domain.settings.ContextSettings) -> TrimRequestBuilder: ...
    @overload
    def setCustomSettingPartMap(self, map: java.util.Map[cern.lsa.domain.settings.Parameter, cern.lsa.domain.settings.SettingPartEnum]) -> 'IncorporationRequestBuilder': ...
    @overload
    def setCustomSettingPartMap(self, map: java.util.Map) -> TrimRequestBuilder: ...
    @overload
    def setDescription(self, string: str) -> 'IncorporationRequestBuilder': ...
    @overload
    def setDescription(self, string: str) -> TrimRequestBuilder: ...
    @overload
    def setDrive(self, boolean: bool) -> 'IncorporationRequestBuilder': ...
    @overload
    def setDrive(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setForceDrive(self, boolean: bool) -> 'IncorporationRequestBuilder': ...
    @overload
    def setForceDrive(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setForceProcessing(self, boolean: bool) -> 'IncorporationRequestBuilder': ...
    @overload
    def setForceProcessing(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setIgnoreErrors(self, boolean: bool) -> 'IncorporationRequestBuilder': ...
    @overload
    def setIgnoreErrors(self, boolean: bool) -> TrimRequestBuilder: ...
    def setIncorporationSettings(self, collection: java.util.Collection[cern.lsa.domain.settings.IncorporationSetting]) -> 'IncorporationRequestBuilder': ...
    @overload
    def setLenientDrive(self, boolean: bool) -> 'IncorporationRequestBuilder': ...
    @overload
    def setLenientDrive(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setParameters(self, collection: java.util.Collection[cern.lsa.domain.settings.Parameter]) -> 'IncorporationRequestBuilder': ...
    @overload
    def setParameters(self, collection: java.util.Collection) -> TrimRequestBuilder: ...
    @overload
    def setPersistSettings(self, boolean: bool) -> 'IncorporationRequestBuilder': ...
    @overload
    def setPersistSettings(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setPropagateToChildren(self, boolean: bool) -> 'IncorporationRequestBuilder': ...
    @overload
    def setPropagateToChildren(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setRelative(self, boolean: bool) -> 'IncorporationRequestBuilder': ...
    @overload
    def setRelative(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setReturnSettings(self, boolean: bool) -> 'IncorporationRequestBuilder': ...
    @overload
    def setReturnSettings(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setSettingPart(self, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> 'IncorporationRequestBuilder': ...
    @overload
    def setSettingPart(self, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> TrimRequestBuilder: ...
    @overload
    def setSkipProcessing(self, boolean: bool) -> 'IncorporationRequestBuilder': ...
    @overload
    def setSkipProcessing(self, boolean: bool) -> TrimRequestBuilder: ...

class KnobCreationBuilder(AbstractKnobBuilder['KnobCreationBuilder']):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, knob: cern.lsa.domain.settings.Knob): ...
    def setKnobParameterName(self, string: str) -> 'KnobCreationBuilder': ...
    def setKnobParameterType(self, parameterType: cern.lsa.domain.settings.ParameterType) -> 'KnobCreationBuilder': ...
    def setMultiplexed(self, boolean: bool) -> 'KnobCreationBuilder': ...
    def setValueType(self, type: cern.accsoft.commons.value.Type) -> 'KnobCreationBuilder': ...

class KnobModificationBuilder(AbstractKnobBuilder['KnobModificationBuilder']):
    def __init__(self, knob: cern.lsa.domain.settings.Knob): ...

class RevertTrimRequestBuilder(TrimRequestBuilder):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, revertTrimRequest: cern.lsa.domain.settings.RevertTrimRequest): ...
    @overload
    def __init__(self, trimRequest: cern.lsa.domain.settings.TrimRequest): ...
    @overload
    def addCustomSettingPart(self, parameter: cern.lsa.domain.settings.Parameter, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> 'RevertTrimRequestBuilder': ...
    @overload
    def addCustomSettingPart(self, parameter: cern.lsa.domain.settings.Parameter, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> TrimRequestBuilder: ...
    @overload
    def addFunction(self, parameter: cern.lsa.domain.settings.Parameter, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction) -> 'RevertTrimRequestBuilder': ...
    @overload
    def addFunction(self, parameter: cern.lsa.domain.settings.Parameter, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction) -> TrimRequestBuilder: ...
    @overload
    def addFunctionsArray(self, parameter: cern.lsa.domain.settings.Parameter, immutableDiscreteFunctionsArray: cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray) -> 'RevertTrimRequestBuilder': ...
    @overload
    def addFunctionsArray(self, parameter: cern.lsa.domain.settings.Parameter, immutableDiscreteFunctionsArray: cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray) -> TrimRequestBuilder: ...
    @overload
    def addScalar(self, parameter: cern.lsa.domain.settings.Parameter, drivableContext: cern.lsa.domain.settings.DrivableContext, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> 'RevertTrimRequestBuilder': ...
    @overload
    def addScalar(self, parameter: cern.lsa.domain.settings.Parameter, drivableContext: cern.lsa.domain.settings.DrivableContext, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> TrimRequestBuilder: ...
    @overload
    def addScalar(self, parameter: cern.lsa.domain.settings.Parameter, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> TrimRequestBuilder: ...
    @overload
    def addSetting(self, setting: cern.lsa.domain.settings.Setting) -> 'RevertTrimRequestBuilder': ...
    @overload
    def addSetting(self, setting: cern.lsa.domain.settings.Setting) -> TrimRequestBuilder: ...
    @overload
    def addValue(self, parameter: cern.lsa.domain.settings.Parameter, beamProcess: cern.lsa.domain.settings.BeamProcess, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> 'RevertTrimRequestBuilder': ...
    @overload
    def addValue(self, parameter: cern.lsa.domain.settings.Parameter, beamProcess: cern.lsa.domain.settings.BeamProcess, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> TrimRequestBuilder: ...
    @overload
    def build(self) -> cern.lsa.domain.settings.RevertTrimRequest: ...
    @overload
    def build(self) -> cern.lsa.domain.settings.TrimRequest: ...
    @overload
    def setAttribute(self, string: str, object: _py_Any) -> 'RevertTrimRequestBuilder': ...
    @overload
    def setAttribute(self, string: str, object: _py_Any) -> TrimRequestBuilder: ...
    def setBeamProcesses(self, collection: java.util.Collection[cern.lsa.domain.settings.BeamProcess]) -> 'RevertTrimRequestBuilder': ...
    @overload
    def setChildSettingPart(self, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> 'RevertTrimRequestBuilder': ...
    @overload
    def setChildSettingPart(self, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> TrimRequestBuilder: ...
    @overload
    def setContext(self, standAloneContext: cern.lsa.domain.settings.StandAloneContext) -> 'RevertTrimRequestBuilder': ...
    @overload
    def setContext(self, standAloneContext: cern.lsa.domain.settings.StandAloneContext) -> TrimRequestBuilder: ...
    @overload
    def setContextSettings(self, contextSettings: cern.lsa.domain.settings.ContextSettings) -> 'RevertTrimRequestBuilder': ...
    @overload
    def setContextSettings(self, contextSettings: cern.lsa.domain.settings.ContextSettings) -> TrimRequestBuilder: ...
    @overload
    def setCustomSettingPartMap(self, map: java.util.Map[cern.lsa.domain.settings.Parameter, cern.lsa.domain.settings.SettingPartEnum]) -> 'RevertTrimRequestBuilder': ...
    @overload
    def setCustomSettingPartMap(self, map: java.util.Map) -> TrimRequestBuilder: ...
    @overload
    def setDescription(self, string: str) -> 'RevertTrimRequestBuilder': ...
    @overload
    def setDescription(self, string: str) -> TrimRequestBuilder: ...
    @overload
    def setDrive(self, boolean: bool) -> 'RevertTrimRequestBuilder': ...
    @overload
    def setDrive(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setForceDrive(self, boolean: bool) -> 'RevertTrimRequestBuilder': ...
    @overload
    def setForceDrive(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setForceProcessing(self, boolean: bool) -> 'RevertTrimRequestBuilder': ...
    @overload
    def setForceProcessing(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setIgnoreErrors(self, boolean: bool) -> 'RevertTrimRequestBuilder': ...
    @overload
    def setIgnoreErrors(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setLenientDrive(self, boolean: bool) -> 'RevertTrimRequestBuilder': ...
    @overload
    def setLenientDrive(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setParameters(self, collection: java.util.Collection[cern.lsa.domain.settings.Parameter]) -> 'RevertTrimRequestBuilder': ...
    @overload
    def setParameters(self, collection: java.util.Collection) -> TrimRequestBuilder: ...
    @overload
    def setPersistSettings(self, boolean: bool) -> 'RevertTrimRequestBuilder': ...
    @overload
    def setPersistSettings(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setPropagateToChildren(self, boolean: bool) -> 'RevertTrimRequestBuilder': ...
    @overload
    def setPropagateToChildren(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setRelative(self, boolean: bool) -> 'RevertTrimRequestBuilder': ...
    @overload
    def setRelative(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setReturnSettings(self, boolean: bool) -> 'RevertTrimRequestBuilder': ...
    @overload
    def setReturnSettings(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setSettingPart(self, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> 'RevertTrimRequestBuilder': ...
    @overload
    def setSettingPart(self, settingPartEnum: cern.lsa.domain.settings.SettingPartEnum) -> TrimRequestBuilder: ...
    @overload
    def setSkipProcessing(self, boolean: bool) -> 'RevertTrimRequestBuilder': ...
    @overload
    def setSkipProcessing(self, boolean: bool) -> TrimRequestBuilder: ...
    def setTrimHeader(self, trimHeader: cern.lsa.domain.settings.TrimHeader) -> 'RevertTrimRequestBuilder': ...

class SettingsGenerationRequestBuilder(TrimRequestBuilder):
    def __init__(self): ...
    @overload
    def build(self) -> cern.lsa.domain.settings.SettingsGenerationRequest: ...
    @overload
    def build(self) -> cern.lsa.domain.settings.TrimRequest: ...
    @overload
    def setAttribute(self, string: str, object: _py_Any) -> 'SettingsGenerationRequestBuilder': ...
    @overload
    def setAttribute(self, string: str, object: _py_Any) -> TrimRequestBuilder: ...
    @overload
    def setContext(self, standAloneContext: cern.lsa.domain.settings.StandAloneContext) -> 'SettingsGenerationRequestBuilder': ...
    @overload
    def setContext(self, standAloneContext: cern.lsa.domain.settings.StandAloneContext) -> TrimRequestBuilder: ...
    @overload
    def setDescription(self, string: str) -> 'SettingsGenerationRequestBuilder': ...
    @overload
    def setDescription(self, string: str) -> TrimRequestBuilder: ...
    @overload
    def setDrive(self, boolean: bool) -> 'SettingsGenerationRequestBuilder': ...
    @overload
    def setDrive(self, boolean: bool) -> TrimRequestBuilder: ...
    def setGenerateZeroSettings(self, boolean: bool) -> 'SettingsGenerationRequestBuilder': ...
    @overload
    def setParameters(self, collection: java.util.Collection[cern.lsa.domain.settings.Parameter]) -> 'SettingsGenerationRequestBuilder': ...
    @overload
    def setParameters(self, collection: java.util.Collection) -> TrimRequestBuilder: ...
    @overload
    def setPersistSettings(self, boolean: bool) -> 'SettingsGenerationRequestBuilder': ...
    @overload
    def setPersistSettings(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setPropagateToChildren(self, boolean: bool) -> 'SettingsGenerationRequestBuilder': ...
    @overload
    def setPropagateToChildren(self, boolean: bool) -> TrimRequestBuilder: ...
    @overload
    def setReturnSettings(self, boolean: bool) -> 'SettingsGenerationRequestBuilder': ...
    @overload
    def setReturnSettings(self, boolean: bool) -> TrimRequestBuilder: ...
    def setSubContexts(self, set: java.util.Set[cern.lsa.domain.settings.SubContext]) -> 'SettingsGenerationRequestBuilder': ...
