from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.domain
import cern.accsoft.commons.domain.particletransfers
import cern.accsoft.commons.domain.zones
import cern.accsoft.commons.util
import cern.lsa.domain.commons
import cern.lsa.domain.devices.factory
import com.google.common.collect
import java.io
import java.lang
import java.util


class CalibrationsRequest:
    ALL: _py_ClassVar['CalibrationsRequest'] = ...
    @classmethod
    def builder(cls) -> 'DefaultCalibrationsRequest.Builder': ...
    @classmethod
    def byCalibrationNames(cls, collection: java.util.Collection[str]) -> 'CalibrationsRequest': ...
    @classmethod
    def byLogicalHardwareName(cls, string: str) -> 'CalibrationsRequest': ...
    @classmethod
    def byParticleTransfer(cls, particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer) -> 'CalibrationsRequest': ...
    def getCalibrationNames(self) -> java.util.Set[str]: ...
    def getLogicalHardwareName(self) -> str: ...
    def getParticleTransfer(self) -> cern.accsoft.commons.domain.particletransfers.ParticleTransfer: ...

class Device(cern.accsoft.commons.util.Named, cern.lsa.domain.commons.IdentifiedEntity, java.lang.Comparable['Device']):
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getAcceleratorZone(self) -> cern.accsoft.commons.domain.zones.AcceleratorZone: ...
    def getAlias(self) -> str: ...
    def getDescription(self) -> str: ...
    def getDeviceGroups(self) -> java.util.Set[str]: ...
    def getDeviceType(self) -> 'DeviceType': ...
    def getDeviceTypeVersion(self) -> 'DeviceTypeVersion': ...
    def getFecName(self) -> str: ...
    def getPosition(self) -> float: ...
    def getServerName(self) -> str: ...
    def getSortOrder(self) -> int: ...
    def getState(self) -> 'Device.DeviceState': ...
    def isCycleBound(self) -> bool: ...
    def isMultiplexed(self) -> bool: ...
    class DeviceState(java.lang.Enum['Device.DeviceState']):
        OPERATIONAL: _py_ClassVar['Device.DeviceState'] = ...
        EXPERT: _py_ClassVar['Device.DeviceState'] = ...
        DEVELOPMENT: _py_ClassVar['Device.DeviceState'] = ...
        OBSOLETE: _py_ClassVar['Device.DeviceState'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'Device.DeviceState': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['Device.DeviceState']: ...

class DeviceFilter(cern.accsoft.commons.util.Filters.Filter[Device]):
    def __init__(self): ...
    @classmethod
    def acceleratorZone(cls, acceleratorZone: cern.accsoft.commons.domain.zones.AcceleratorZone) -> 'DeviceFilter': ...
    @classmethod
    def acceleratorZoneIn(cls, collection: java.util.Collection[cern.accsoft.commons.domain.zones.AcceleratorZone]) -> 'DeviceFilter': ...
    @overload
    def accepts(self, device: Device) -> bool: ...
    @overload
    def accepts(self, object: _py_Any) -> bool: ...
    @classmethod
    def deviceGroupName(cls, string: str) -> 'DeviceFilter': ...
    @classmethod
    def deviceTypeName(cls, string: str) -> 'DeviceFilter': ...
    @classmethod
    def deviceTypeNames(cls, collection: java.util.Collection[str]) -> 'DeviceFilter': ...
    def setAcceleratorZone(self, acceleratorZone: cern.accsoft.commons.domain.zones.AcceleratorZone) -> 'DeviceFilter': ...
    def setAcceleratorZones(self, collection: java.util.Collection[cern.accsoft.commons.domain.zones.AcceleratorZone]) -> 'DeviceFilter': ...
    def setDeviceGroupName(self, string: str) -> 'DeviceFilter': ...
    def setDeviceGroupNames(self, collection: java.util.Collection[str]) -> 'DeviceFilter': ...
    def setDeviceType(self, deviceType: 'DeviceType') -> 'DeviceFilter': ...
    def setDeviceTypeName(self, string: str) -> 'DeviceFilter': ...
    def setDeviceTypeNames(self, collection: java.util.Collection[str]) -> 'DeviceFilter': ...
    def setDeviceTypeVersions(self, collection: java.util.Collection['DeviceTypeVersion']) -> 'DeviceFilter': ...
    def setDeviceTypes(self, collection: java.util.Collection['DeviceType']) -> 'DeviceFilter': ...

class DeviceGroup(cern.accsoft.commons.util.Named, cern.lsa.domain.commons.IdentifiedEntity):
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getChildGroups(self) -> java.util.Set['DeviceGroup']: ...
    def getCreateTime(self) -> java.util.Date: ...
    def getCreator(self) -> str: ...
    def getDisplayName(self) -> str: ...
    def getModifier(self) -> str: ...
    def getModifyTime(self) -> java.util.Date: ...
    def getType(self) -> 'DeviceGroupType': ...
    def isOperational(self) -> bool: ...

class DeviceGroupFilter(cern.accsoft.commons.util.Filters.Filter[DeviceGroup]):
    def __init__(self): ...
    @classmethod
    def accelerator(cls, accelerator: cern.accsoft.commons.domain.Accelerator) -> 'DeviceGroupFilter': ...
    @overload
    def accepts(self, deviceGroup: DeviceGroup) -> bool: ...
    @overload
    def accepts(self, object: _py_Any) -> bool: ...
    def setAccelerator(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> 'DeviceGroupFilter': ...
    def setType(self, deviceGroupType: 'DeviceGroupType') -> 'DeviceGroupFilter': ...
    def setTypes(self, collection: java.util.Collection['DeviceGroupType']) -> 'DeviceGroupFilter': ...
    @classmethod
    def type(cls, deviceGroupType: 'DeviceGroupType') -> 'DeviceGroupFilter': ...
    @classmethod
    def typeIn(cls, collection: java.util.Collection['DeviceGroupType']) -> 'DeviceGroupFilter': ...

class DeviceGroupType(cern.accsoft.commons.util.Named):
    def getDescription(self) -> str: ...

class DeviceGroups:
    CHILD_GROUPS: _py_ClassVar[cern.accsoft.commons.util.Mappers.Mapper] = ...
    def __init__(self): ...
    @classmethod
    def filterGroupsByType(cls, collection: java.util.Collection[DeviceGroup], deviceGroupType: DeviceGroupType) -> java.util.Set[DeviceGroup]: ...
    @classmethod
    def getAllChildDeviceGroups(cls, collection: java.util.Collection[DeviceGroup]) -> java.util.Set[DeviceGroup]: ...
    @classmethod
    def getDirectChildDeviceGroups(cls, collection: java.util.Collection[DeviceGroup]) -> java.util.Set[DeviceGroup]: ...

class DeviceGroupsRequest:
    @classmethod
    def builder(cls) -> cern.lsa.domain.devices.factory.DeviceGroupsRequestBuilder: ...
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getDeviceGroupNamePattern(self) -> str: ...
    def getDeviceGroupNames(self) -> java.util.Set[str]: ...
    def getDeviceGroupTypes(self) -> java.util.Set[DeviceGroupType]: ...

class DeviceMetaTypeEnum(java.lang.Enum['DeviceMetaTypeEnum']):
    ACTUAL: _py_ClassVar['DeviceMetaTypeEnum'] = ...
    LOGICAL: _py_ClassVar['DeviceMetaTypeEnum'] = ...
    BEAM: _py_ClassVar['DeviceMetaTypeEnum'] = ...
    ALL: _py_ClassVar['DeviceMetaTypeEnum'] = ...
    NONE: _py_ClassVar['DeviceMetaTypeEnum'] = ...
    def getMetaType(self) -> str: ...
    def toString(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, char: str) -> 'DeviceMetaTypeEnum': ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'DeviceMetaTypeEnum': ...
    _valueOf_2__T = _py_TypeVar('_valueOf_2__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_2__T], string: str) -> _valueOf_2__T: ...
    @classmethod
    def values(cls) -> _py_List['DeviceMetaTypeEnum']: ...

class DeviceType(cern.accsoft.commons.util.Named, cern.lsa.domain.commons.IdentifiedEntity, java.lang.Comparable['DeviceType']):
    def getDescription(self) -> str: ...
    def getMetaType(self) -> DeviceMetaTypeEnum: ...
    def getVersions(self) -> java.util.SortedSet['DeviceTypeVersion']: ...

class DeviceTypeImplementation(java.lang.Enum['DeviceTypeImplementation'], cern.accsoft.commons.util.Named):
    HARDWARE: _py_ClassVar['DeviceTypeImplementation'] = ...
    FESA2: _py_ClassVar['DeviceTypeImplementation'] = ...
    FESA3: _py_ClassVar['DeviceTypeImplementation'] = ...
    VIRTUAL: _py_ClassVar['DeviceTypeImplementation'] = ...
    GM: _py_ClassVar['DeviceTypeImplementation'] = ...
    DEVACC: _py_ClassVar['DeviceTypeImplementation'] = ...
    LSA: _py_ClassVar['DeviceTypeImplementation'] = ...
    FGC: _py_ClassVar['DeviceTypeImplementation'] = ...
    def getName(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'DeviceTypeImplementation': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['DeviceTypeImplementation']: ...

class DeviceTypeVersion(cern.lsa.domain.commons.IdentifiedEntity, java.lang.Comparable['DeviceTypeVersion']):
    def getDeviceType(self) -> DeviceType: ...
    def getImplementation(self) -> DeviceTypeImplementation: ...
    def getVersionNumber(self) -> 'DeviceTypeVersionNumber': ...

class DeviceTypeVersionNumber(java.lang.Comparable['DeviceTypeVersionNumber']):
    def getMajor(self) -> int: ...
    def getMinor(self) -> int: ...

class DeviceTypes:
    def __init__(self): ...
    @classmethod
    def getLatestVersion(cls, deviceType: DeviceType) -> DeviceTypeVersion: ...
    @classmethod
    def toDeviceTypeVersionByDeviceTypeMap(cls, collection: java.util.Collection[DeviceTypeVersion]) -> java.util.Map[DeviceType, java.util.SortedSet[DeviceTypeVersion]]: ...
    @classmethod
    def toDeviceTypeVersions(cls, collection: java.util.Collection[DeviceType]) -> java.util.Set[DeviceTypeVersion]: ...
    @classmethod
    def toDeviceTypes(cls, collection: java.util.Collection[DeviceTypeVersion]) -> java.util.Set[DeviceType]: ...

class DeviceTypesRequest:
    @classmethod
    def builder(cls) -> cern.lsa.domain.devices.factory.DeviceTypesRequestBuilder: ...
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getAllTypesRequested(self) -> bool: ...
    def getDeviceTypeImplementations(self) -> java.util.Set[DeviceTypeImplementation]: ...
    def getDeviceTypeNamePattern(self) -> str: ...
    def getDeviceTypeNames(self) -> java.util.Set[str]: ...
    def getDeviceTypeVersionNumber(self) -> DeviceTypeVersionNumber: ...

class Devices:
    DEVICE_TYPES: _py_ClassVar[cern.accsoft.commons.util.Mappers.Mapper] = ...
    DEVICE_TYPE_NAMES: _py_ClassVar[cern.accsoft.commons.util.Mappers.Mapper] = ...
    DEVICE_TYPE_VERSIONS: _py_ClassVar[cern.accsoft.commons.util.Mappers.Mapper] = ...
    FRONT_END_NAMES: _py_ClassVar[cern.accsoft.commons.util.Mappers.Mapper] = ...
    DEVICE_GROUP_NAMES: _py_ClassVar[cern.accsoft.commons.util.Mappers.Mapper] = ...
    def __init__(self): ...
    @classmethod
    def deviceGroupNameIn(cls, collection: java.util.Collection[str]) -> cern.accsoft.commons.util.Filters.Filter[Device]: ...
    @classmethod
    def filterDevicesByGroupNames(cls, collection: java.util.Collection[Device], collection2: java.util.Collection[str]) -> java.util.Set[Device]: ...
    @classmethod
    def filterDevicesNotAssignedToAnyGroup(cls, collection: java.util.Collection[Device]) -> java.util.Set[Device]: ...
    @classmethod
    def filterDevicesNotAssignedToGroup(cls, collection: java.util.Collection[Device], collection2: java.util.Collection[str]) -> java.util.Set[Device]: ...
    @classmethod
    def findGroupsContainingDeviceByType(cls, collection: java.util.Collection[DeviceGroup], deviceGroupType: DeviceGroupType, device2: Device) -> java.util.Set[DeviceGroup]: ...
    @classmethod
    def getDeviceGroupNames(cls, set: java.util.Set[Device]) -> java.util.Set[str]: ...
    @classmethod
    def getDeviceTypeNames(cls, collection: java.util.Collection[Device]) -> java.util.Set[str]: ...
    @classmethod
    def getDeviceTypeVersions(cls, collection: java.util.Collection[Device]) -> java.util.Set[DeviceTypeVersion]: ...
    @classmethod
    def getDeviceTypes(cls, collection: java.util.Collection[Device]) -> java.util.Set[DeviceType]: ...
    @classmethod
    def getDeviceTypesByDeviceGroup(cls, set: java.util.Set[Device], string: str) -> java.util.Set[DeviceType]: ...
    @classmethod
    def getFrontEndNames(cls, set: java.util.Set[Device]) -> java.util.Set[str]: ...
    @classmethod
    def groupDevicesByDeviceGroup(cls, collection: java.util.Collection[Device]) -> java.util.Map[str, java.util.Set[Device]]: ...

class DevicesRequest:
    @classmethod
    def builder(cls) -> cern.lsa.domain.devices.factory.DevicesRequestBuilder: ...
    def existInLsaOnly(self) -> bool: ...
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getAcceleratorZones(self) -> java.util.Set[cern.accsoft.commons.domain.zones.AcceleratorZone]: ...
    def getDeviceAliases(self) -> java.util.Set[str]: ...
    def getDeviceGroupIds(self) -> java.util.Set[int]: ...
    def getDeviceGroupNames(self) -> java.util.Set[str]: ...
    def getDeviceNamePattern(self) -> str: ...
    def getDeviceNames(self) -> java.util.Set[str]: ...
    def getDeviceTypeNamePattern(self) -> str: ...
    def getDeviceTypeNames(self) -> java.util.Set[str]: ...
    def getDeviceTypeVersions(self) -> java.util.Set[DeviceTypeVersion]: ...
    def getElementName(self) -> str: ...
    def getFecNames(self) -> java.util.Set[str]: ...
    def getMetaType(self) -> DeviceMetaTypeEnum: ...
    def getParticleTransfers(self) -> java.util.Set[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]: ...
    def isMultiplexed(self) -> bool: ...

class DefaultCalibrationsRequest(CalibrationsRequest, java.io.Serializable):
    @classmethod
    def builder(cls) -> 'DefaultCalibrationsRequest.Builder': ...
    @classmethod
    def copyOf(cls, calibrationsRequest: CalibrationsRequest) -> 'DefaultCalibrationsRequest': ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def getCalibrationNames(self) -> com.google.common.collect.ImmutableSet[str]: ...
    @overload
    def getCalibrationNames(self) -> java.util.Set: ...
    def getLogicalHardwareName(self) -> str: ...
    def getParticleTransfer(self) -> cern.accsoft.commons.domain.particletransfers.ParticleTransfer: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    @overload
    def withCalibrationNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultCalibrationsRequest': ...
    @overload
    def withCalibrationNames(self, stringArray: _py_List[str]) -> 'DefaultCalibrationsRequest': ...
    def withLogicalHardwareName(self, string: str) -> 'DefaultCalibrationsRequest': ...
    def withParticleTransfer(self, particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer) -> 'DefaultCalibrationsRequest': ...
    class Builder:
        def addAllCalibrationNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultCalibrationsRequest.Builder': ...
        def addCalibrationName(self, string: str) -> 'DefaultCalibrationsRequest.Builder': ...
        def addCalibrationNames(self, stringArray: _py_List[str]) -> 'DefaultCalibrationsRequest.Builder': ...
        def build(self) -> 'DefaultCalibrationsRequest': ...
        def calibrationNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultCalibrationsRequest.Builder': ...
        def logicalHardwareName(self, string: str) -> 'DefaultCalibrationsRequest.Builder': ...
        def particleTransfer(self, particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer) -> 'DefaultCalibrationsRequest.Builder': ...
