from typing import Any as _py_Any
from typing import List as _py_List
from typing import overload
import cern.accsoft.commons.util
import com.google.common.collect
import java.lang
import java.time
import java.util


class AcceleratorZoneRest(cern.accsoft.commons.util.Named):
    @classmethod
    def builder(cls) -> 'DefaultAcceleratorZoneRest.Builder': ...
    def getAcceleratorName(self) -> str: ...

class BooleanItemRest:
    @classmethod
    def builder(cls) -> 'DefaultBooleanItemRest.Builder': ...
    def getStandardMeaning(self) -> str: ...
    def getValue(self) -> bool: ...

class BooleanTypeRest(cern.accsoft.commons.util.Named):
    @classmethod
    def builder(cls) -> 'DefaultBooleanTypeRest.Builder': ...
    def getBooleanItems(self) -> java.util.List[BooleanItemRest]: ...

class DeviceMetaTypeRest(cern.accsoft.commons.util.Named):
    @classmethod
    def builder(cls) -> 'DefaultDeviceMetaTypeRest.Builder': ...

class DeviceRest(cern.accsoft.commons.util.Named):
    @classmethod
    def builder(cls) -> 'DefaultDeviceRest.Builder': ...
    def getAcceleratorZone(self) -> AcceleratorZoneRest: ...
    def getDescription(self) -> str: ...
    def getDeviceAlias(self) -> str: ...
    def getDeviceGroups(self) -> java.util.Set[str]: ...
    def getDeviceTypeVersion(self) -> 'DeviceTypeVersionContainerRest': ...
    def getFecName(self) -> str: ...
    def getId(self) -> int: ...
    def getPosition(self) -> float: ...
    def getServerName(self) -> str: ...
    def getSortOrder(self) -> int: ...
    def getState(self) -> 'DeviceStateRest': ...
    def isCycleBound(self) -> bool: ...
    def isMultiplexed(self) -> bool: ...

class DeviceStateRest(cern.accsoft.commons.util.Named):
    @classmethod
    def builder(cls) -> 'DefaultDeviceStateRest.Builder': ...

class DeviceTypeImplementationRest(cern.accsoft.commons.util.Named):
    @classmethod
    def builder(cls) -> 'DefaultDeviceTypeImplementationRest.Builder': ...

class DeviceTypeVersionContainerRest(cern.accsoft.commons.util.Named):
    @classmethod
    def builder(cls) -> 'DefaultDeviceTypeVersionContainerRest.Builder': ...
    def getDescription(self) -> str: ...
    def getId(self) -> int: ...
    def getMetaType(self) -> DeviceMetaTypeRest: ...
    def getOtherVersions(self) -> java.util.List['DeviceTypeVersionRest']: ...
    def getPrimaryVersion(self) -> 'DeviceTypeVersionRest': ...

class DeviceTypeVersionNumberRest:
    @classmethod
    def builder(cls) -> 'DefaultDeviceTypeVersionNumberRest.Builder': ...
    def getMajor(self) -> int: ...
    def getMinor(self) -> int: ...

class DeviceTypeVersionRest:
    @classmethod
    def builder(cls) -> 'DefaultDeviceTypeVersionRest.Builder': ...
    def getId(self) -> int: ...
    def getImplementation(self) -> DeviceTypeImplementationRest: ...
    def getVersionNumber(self) -> DeviceTypeVersionNumberRest: ...

class EnumItemRest:
    @classmethod
    def builder(cls) -> 'DefaultEnumItemRest.Builder': ...
    def getCode(self) -> int: ...
    def getStandardMeaning(self) -> str: ...
    def getSymbol(self) -> str: ...
    def isSettable(self) -> bool: ...

class EnumTypeRest(cern.accsoft.commons.util.Named):
    @classmethod
    def builder(cls) -> 'DefaultEnumTypeRest.Builder': ...
    def getEnumItems(self) -> java.util.List[EnumItemRest]: ...
    def getEnumTypeBitSize(self) -> str: ...

class ErrorDto:
    @classmethod
    def builder(cls) -> 'DefaultErrorDto.Builder': ...
    def getErrorType(self) -> str: ...
    def getMessage(self) -> str: ...
    def getPath(self) -> str: ...
    def getTimestamp(self) -> java.time.OffsetDateTime: ...

class IncaPropertyFieldInfoRest:
    @classmethod
    def builder(cls) -> 'DefaultIncaPropertyFieldInfoRest.Builder': ...
    def getAssociatedPropertyFieldRest(self) -> 'PropertyFieldRest': ...
    def getControlWarningMessage(self) -> str: ...
    def getDisplayFormat(self) -> str: ...
    def getDisplayName(self) -> str: ...
    def getParameterValueCompareType(self) -> str: ...
    def getPropertyFieldRest(self) -> 'PropertyFieldRest': ...
    def isMainStatus(self) -> bool: ...

class IncaPropertyFieldInfosRequestRest:
    @classmethod
    def builder(cls) -> 'DefaultIncaPropertyFieldInfosRequestRest.Builder': ...
    @classmethod
    def byPropertyFieldId(cls, long: int) -> 'IncaPropertyFieldInfosRequestRest': ...
    @classmethod
    def byPropertyFieldIds(cls, set: java.util.Set[int]) -> 'IncaPropertyFieldInfosRequestRest': ...
    def getPropertyFieldIds(self) -> java.util.Set[int]: ...

class MakeRuleClassInfoRest:
    @classmethod
    def builder(cls) -> 'DefaultMakeRuleClassInfoRest.Builder': ...
    def getClassName(self) -> str: ...
    def getProductName(self) -> str: ...
    def getVersion(self) -> str: ...

class MakeRuleConfigInfoRest:
    @classmethod
    def builder(cls) -> 'DefaultMakeRuleConfigInfoRest.Builder': ...
    def getMakeRuleConfigStatus(self) -> 'MakeRuleConfigStatusRest': ...
    def getMakeRuleInfo(self) -> 'MakeRuleInfoRest': ...

class MakeRuleConfigStatusRest:
    @classmethod
    def builder(cls) -> 'DefaultMakeRuleConfigStatusRest.Builder': ...
    def getName(self) -> str: ...

class MakeRuleInfoRest:
    @classmethod
    def builder(cls) -> 'DefaultMakeRuleInfoRest.Builder': ...
    def getMakeRuleClassInfo(self) -> MakeRuleClassInfoRest: ...
    def getMakeRuleName(self) -> str: ...

class ParameterAttributesRest:
    @classmethod
    def builder(cls) -> 'DefaultParameterAttributesRest.Builder': ...
    def getAbsoluteTolerance(self) -> float: ...
    def getDefaultHierarchy(self) -> str: ...
    def getDevice(self) -> DeviceRest: ...
    def getMaxValue(self) -> float: ...
    def getMinValue(self) -> float: ...
    def getParameterId(self) -> int: ...
    def getParameterName(self) -> str: ...
    def getParameterType(self) -> 'ParameterTypeRest': ...
    def getPropertyField(self) -> 'PropertyFieldRest': ...
    def getRelativeTolerance(self) -> float: ...
    def getXPrecision(self) -> int: ...
    def getYPrecision(self) -> int: ...
    def isBelongsToFunctionBProc(self) -> bool: ...
    def isReservedForOpExperts(self) -> bool: ...
    def isTrimable(self) -> bool: ...

class ParameterGroupRest(cern.accsoft.commons.util.Named):
    @classmethod
    def builder(cls) -> 'DefaultParameterGroupRest.Builder': ...
    def getAcceleratorName(self) -> str: ...
    def getCreateDate(self) -> java.time.OffsetDateTime: ...
    def getCreator(self) -> str: ...
    def getDescription(self) -> str: ...
    def getId(self) -> int: ...

class ParameterRest(cern.accsoft.commons.util.Named):
    def belongsToFunctionBeamProcess(self) -> bool: ...
    @classmethod
    def builder(cls) -> 'DefaultParameterRest.Builder': ...
    def getDefaultHierarchy(self) -> str: ...
    def getDevice(self) -> DeviceRest: ...
    def getId(self) -> int: ...
    def getParameterGroups(self) -> java.util.List[str]: ...
    def getParameterType(self) -> 'ParameterTypeRest': ...
    def getPropertyField(self) -> 'PropertyFieldRest': ...
    def getValueDescriptor(self) -> 'ValueDescriptorRest': ...
    def getValueType(self) -> 'TypeRest': ...
    def isCritical(self) -> bool: ...
    def isCycleBound(self) -> bool: ...
    def isMonitorable(self) -> bool: ...
    def isMultiplexed(self) -> bool: ...
    def isPropertySupportingPartialSet(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isReservedForOpExperts(self) -> bool: ...
    def isTrimable(self) -> bool: ...
    def isVirtual(self) -> bool: ...
    def isWritable(self) -> bool: ...

class ParameterTreeDataRest:
    @classmethod
    def builder(cls) -> 'DefaultParameterTreeDataRest.Builder': ...
    def getNodes(self) -> java.util.Set['ParameterTreeNodeRest']: ...
    def getRelations(self) -> java.util.Set['ParameterTreeRelationRest']: ...
    def getStartNodeIds(self) -> java.util.Set[int]: ...

class ParameterTreeNodeRest:
    @classmethod
    def builder(cls) -> 'DefaultParameterTreeNodeRest.Builder': ...
    def getParameter(self) -> ParameterRest: ...
    def isSource(self) -> bool: ...

class ParameterTreeRelationRest:
    @classmethod
    def builder(cls) -> 'DefaultParameterTreeRelationRest.Builder': ...
    def getChildParameterId(self) -> int: ...
    def getParentParameterId(self) -> int: ...

class ParameterTreesRequestRest:
    @classmethod
    def builder(cls) -> 'DefaultParameterTreesRequestRest.Builder': ...
    def getHierarchy(self) -> str: ...
    def getParameterNames(self) -> java.util.Set[str]: ...
    def getTreeDirection(self) -> str: ...

class ParameterTypeCategoryRest(cern.accsoft.commons.util.Named):
    @classmethod
    def builder(cls) -> 'DefaultParameterTypeCategoryRest.Builder': ...

class ParameterTypeRest(cern.accsoft.commons.util.Named):
    @classmethod
    def builder(cls) -> 'DefaultParameterTypeRest.Builder': ...
    def getCategory(self) -> ParameterTypeCategoryRest: ...
    def getId(self) -> int: ...
    def isLinkRuleApplicable(self) -> bool: ...

class ParameterTypesRequestRest:
    def getParameterTypeNames(self) -> java.util.Set[str]: ...
    def isAllParameterTypesRequested(self) -> bool: ...

class ParametersRequestRest:
    @classmethod
    def builder(cls) -> 'DefaultParametersRequestRest.Builder': ...
    def getAcceleratorName(self) -> str: ...
    def getAcceleratorZoneNames(self) -> java.util.Set[str]: ...
    def getDeviceIds(self) -> java.util.Set[int]: ...
    def getDeviceNames(self) -> java.util.Set[str]: ...
    def getParameterGroups(self) -> java.util.Set[str]: ...
    def getParameterNamePattern(self) -> str: ...
    def getParameterNames(self) -> java.util.Set[str]: ...
    def getParameterTypeNames(self) -> java.util.Set[str]: ...
    def getParticleTransferNames(self) -> java.util.Set[str]: ...
    def getPropertyFieldIds(self) -> java.util.Set[int]: ...
    def getPropertyNames(self) -> java.util.Set[str]: ...
    def getValueTypes(self) -> java.util.Set[str]: ...
    def isCritical(self) -> bool: ...
    def isMultiplexed(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isVirtual(self) -> bool: ...
    def isWritable(self) -> bool: ...

class ParentToChildrenRelationRest:
    @classmethod
    def builder(cls) -> 'DefaultParentToChildrenRelationRest.Builder': ...
    def getChildrenIds(self) -> java.util.List[int]: ...
    def getParentId(self) -> int: ...

class PropertyAndDeviceRest:
    @classmethod
    def builder(cls) -> 'DefaultPropertyAndDeviceRest.Builder': ...
    def getDeviceId(self) -> int: ...
    def getPropertyName(self) -> str: ...

class PropertyFieldRest:
    @classmethod
    def builder(cls) -> 'DefaultPropertyFieldRest.Builder': ...
    def getDeviceTypeName(self) -> str: ...
    def getFieldName(self) -> str: ...
    def getId(self) -> int: ...
    def getPropertyName(self) -> str: ...

class SaveParameterRelationRest:
    @classmethod
    def builder(cls) -> 'DefaultSaveParameterRelationRest.Builder': ...
    def getHierarchy(self) -> str: ...
    def getParent2ChildrenRelations(self) -> java.util.List[ParentToChildrenRelationRest]: ...

class TypeRest(cern.accsoft.commons.util.Named):
    @classmethod
    def builder(cls) -> 'DefaultTypeRest.Builder': ...

class ValueCompareTypeRest(cern.accsoft.commons.util.Named):
    @classmethod
    def builder(cls) -> 'DefaultValueCompareTypeRest.Builder': ...

class ValueDescriptorRest:
    @classmethod
    def builder(cls) -> 'DefaultValueDescriptorRest.Builder': ...
    def getAbsoluteTolerance(self) -> float: ...
    def getBooleanType(self) -> BooleanTypeRest: ...
    def getColumnCount(self) -> int: ...
    def getEnumType(self) -> EnumTypeRest: ...
    def getMax(self) -> float: ...
    def getMin(self) -> float: ...
    def getRelativeTolerance(self) -> float: ...
    def getRowCount(self) -> int: ...
    def getXPrecision(self) -> int: ...
    def getXUnit(self) -> str: ...
    def getYPrecision(self) -> int: ...
    def getYUnit(self) -> str: ...

class DefaultAcceleratorZoneRest(AcceleratorZoneRest):
    @classmethod
    def builder(cls) -> 'DefaultAcceleratorZoneRest.Builder': ...
    @classmethod
    def copyOf(cls, acceleratorZoneRest: AcceleratorZoneRest) -> 'DefaultAcceleratorZoneRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAcceleratorName(self) -> str: ...
    def getName(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withAcceleratorName(self, string: str) -> 'DefaultAcceleratorZoneRest': ...
    def withName(self, string: str) -> 'DefaultAcceleratorZoneRest': ...
    class Builder:
        def acceleratorName(self, string: str) -> 'DefaultAcceleratorZoneRest.Builder': ...
        def build(self) -> 'DefaultAcceleratorZoneRest': ...
        def name(self, string: str) -> 'DefaultAcceleratorZoneRest.Builder': ...

class DefaultBooleanItemRest(BooleanItemRest):
    @classmethod
    def builder(cls) -> 'DefaultBooleanItemRest.Builder': ...
    @classmethod
    def copyOf(cls, booleanItemRest: BooleanItemRest) -> 'DefaultBooleanItemRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getStandardMeaning(self) -> str: ...
    def getValue(self) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withStandardMeaning(self, string: str) -> 'DefaultBooleanItemRest': ...
    def withValue(self, boolean: bool) -> 'DefaultBooleanItemRest': ...
    class Builder:
        def build(self) -> 'DefaultBooleanItemRest': ...
        def standardMeaning(self, string: str) -> 'DefaultBooleanItemRest.Builder': ...
        def value(self, boolean: bool) -> 'DefaultBooleanItemRest.Builder': ...

class DefaultBooleanTypeRest(BooleanTypeRest):
    @classmethod
    def builder(cls) -> 'DefaultBooleanTypeRest.Builder': ...
    @classmethod
    def copyOf(cls, booleanTypeRest: BooleanTypeRest) -> 'DefaultBooleanTypeRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def getBooleanItems(self) -> com.google.common.collect.ImmutableList[BooleanItemRest]: ...
    @overload
    def getBooleanItems(self) -> java.util.List: ...
    def getName(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    @overload
    def withBooleanItems(self, booleanItemRestArray: _py_List[BooleanItemRest]) -> 'DefaultBooleanTypeRest': ...
    @overload
    def withBooleanItems(self, iterable: java.lang.Iterable[BooleanItemRest]) -> 'DefaultBooleanTypeRest': ...
    def withName(self, string: str) -> 'DefaultBooleanTypeRest': ...
    class Builder:
        def addAllBooleanItems(self, iterable: java.lang.Iterable[BooleanItemRest]) -> 'DefaultBooleanTypeRest.Builder': ...
        def addBooleanItem(self, booleanItemRest: BooleanItemRest) -> 'DefaultBooleanTypeRest.Builder': ...
        def addBooleanItems(self, booleanItemRestArray: _py_List[BooleanItemRest]) -> 'DefaultBooleanTypeRest.Builder': ...
        def booleanItems(self, iterable: java.lang.Iterable[BooleanItemRest]) -> 'DefaultBooleanTypeRest.Builder': ...
        def build(self) -> 'DefaultBooleanTypeRest': ...
        def name(self, string: str) -> 'DefaultBooleanTypeRest.Builder': ...

class DefaultDeviceMetaTypeRest(DeviceMetaTypeRest):
    @classmethod
    def builder(cls) -> 'DefaultDeviceMetaTypeRest.Builder': ...
    @classmethod
    def copyOf(cls, deviceMetaTypeRest: DeviceMetaTypeRest) -> 'DefaultDeviceMetaTypeRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getName(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withName(self, string: str) -> 'DefaultDeviceMetaTypeRest': ...
    class Builder:
        def build(self) -> 'DefaultDeviceMetaTypeRest': ...
        def name(self, string: str) -> 'DefaultDeviceMetaTypeRest.Builder': ...

class DefaultDeviceRest(DeviceRest):
    @classmethod
    def builder(cls) -> 'DefaultDeviceRest.Builder': ...
    @classmethod
    def copyOf(cls, deviceRest: DeviceRest) -> 'DefaultDeviceRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAcceleratorZone(self) -> AcceleratorZoneRest: ...
    def getDescription(self) -> str: ...
    def getDeviceAlias(self) -> str: ...
    @overload
    def getDeviceGroups(self) -> com.google.common.collect.ImmutableSet[str]: ...
    @overload
    def getDeviceGroups(self) -> java.util.Set: ...
    def getDeviceTypeVersion(self) -> DeviceTypeVersionContainerRest: ...
    def getFecName(self) -> str: ...
    def getId(self) -> int: ...
    def getName(self) -> str: ...
    def getPosition(self) -> float: ...
    def getServerName(self) -> str: ...
    def getSortOrder(self) -> int: ...
    def getState(self) -> DeviceStateRest: ...
    def hashCode(self) -> int: ...
    def isCycleBound(self) -> bool: ...
    def isMultiplexed(self) -> bool: ...
    def toString(self) -> str: ...
    def withAcceleratorZone(self, acceleratorZoneRest: AcceleratorZoneRest) -> 'DefaultDeviceRest': ...
    def withCycleBound(self, boolean: bool) -> 'DefaultDeviceRest': ...
    def withDescription(self, string: str) -> 'DefaultDeviceRest': ...
    def withDeviceAlias(self, string: str) -> 'DefaultDeviceRest': ...
    @overload
    def withDeviceGroups(self, iterable: java.lang.Iterable[str]) -> 'DefaultDeviceRest': ...
    @overload
    def withDeviceGroups(self, stringArray: _py_List[str]) -> 'DefaultDeviceRest': ...
    def withDeviceTypeVersion(self, deviceTypeVersionContainerRest: DeviceTypeVersionContainerRest) -> 'DefaultDeviceRest': ...
    def withFecName(self, string: str) -> 'DefaultDeviceRest': ...
    def withId(self, long: int) -> 'DefaultDeviceRest': ...
    def withMultiplexed(self, boolean: bool) -> 'DefaultDeviceRest': ...
    def withName(self, string: str) -> 'DefaultDeviceRest': ...
    def withPosition(self, double: float) -> 'DefaultDeviceRest': ...
    def withServerName(self, string: str) -> 'DefaultDeviceRest': ...
    def withSortOrder(self, int: int) -> 'DefaultDeviceRest': ...
    def withState(self, deviceStateRest: DeviceStateRest) -> 'DefaultDeviceRest': ...
    class Builder:
        def acceleratorZone(self, acceleratorZoneRest: AcceleratorZoneRest) -> 'DefaultDeviceRest.Builder': ...
        def addAllDeviceGroups(self, iterable: java.lang.Iterable[str]) -> 'DefaultDeviceRest.Builder': ...
        def addDeviceGroup(self, string: str) -> 'DefaultDeviceRest.Builder': ...
        def addDeviceGroups(self, stringArray: _py_List[str]) -> 'DefaultDeviceRest.Builder': ...
        def build(self) -> 'DefaultDeviceRest': ...
        def cycleBound(self, boolean: bool) -> 'DefaultDeviceRest.Builder': ...
        def description(self, string: str) -> 'DefaultDeviceRest.Builder': ...
        def deviceAlias(self, string: str) -> 'DefaultDeviceRest.Builder': ...
        def deviceGroups(self, iterable: java.lang.Iterable[str]) -> 'DefaultDeviceRest.Builder': ...
        def deviceTypeVersion(self, deviceTypeVersionContainerRest: DeviceTypeVersionContainerRest) -> 'DefaultDeviceRest.Builder': ...
        def fecName(self, string: str) -> 'DefaultDeviceRest.Builder': ...
        def id(self, long: int) -> 'DefaultDeviceRest.Builder': ...
        def multiplexed(self, boolean: bool) -> 'DefaultDeviceRest.Builder': ...
        def name(self, string: str) -> 'DefaultDeviceRest.Builder': ...
        def position(self, double: float) -> 'DefaultDeviceRest.Builder': ...
        def serverName(self, string: str) -> 'DefaultDeviceRest.Builder': ...
        def sortOrder(self, int: int) -> 'DefaultDeviceRest.Builder': ...
        def state(self, deviceStateRest: DeviceStateRest) -> 'DefaultDeviceRest.Builder': ...

class DefaultDeviceStateRest(DeviceStateRest):
    @classmethod
    def builder(cls) -> 'DefaultDeviceStateRest.Builder': ...
    @classmethod
    def copyOf(cls, deviceStateRest: DeviceStateRest) -> 'DefaultDeviceStateRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getName(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withName(self, string: str) -> 'DefaultDeviceStateRest': ...
    class Builder:
        def build(self) -> 'DefaultDeviceStateRest': ...
        def name(self, string: str) -> 'DefaultDeviceStateRest.Builder': ...

class DefaultDeviceTypeImplementationRest(DeviceTypeImplementationRest):
    @classmethod
    def builder(cls) -> 'DefaultDeviceTypeImplementationRest.Builder': ...
    @classmethod
    def copyOf(cls, deviceTypeImplementationRest: DeviceTypeImplementationRest) -> 'DefaultDeviceTypeImplementationRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getName(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withName(self, string: str) -> 'DefaultDeviceTypeImplementationRest': ...
    class Builder:
        def build(self) -> 'DefaultDeviceTypeImplementationRest': ...
        def name(self, string: str) -> 'DefaultDeviceTypeImplementationRest.Builder': ...

class DefaultDeviceTypeVersionContainerRest(DeviceTypeVersionContainerRest):
    @classmethod
    def builder(cls) -> 'DefaultDeviceTypeVersionContainerRest.Builder': ...
    @classmethod
    def copyOf(cls, deviceTypeVersionContainerRest: DeviceTypeVersionContainerRest) -> 'DefaultDeviceTypeVersionContainerRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getDescription(self) -> str: ...
    def getId(self) -> int: ...
    def getMetaType(self) -> DeviceMetaTypeRest: ...
    def getName(self) -> str: ...
    @overload
    def getOtherVersions(self) -> com.google.common.collect.ImmutableList[DeviceTypeVersionRest]: ...
    @overload
    def getOtherVersions(self) -> java.util.List: ...
    def getPrimaryVersion(self) -> DeviceTypeVersionRest: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withDescription(self, string: str) -> 'DefaultDeviceTypeVersionContainerRest': ...
    def withId(self, long: int) -> 'DefaultDeviceTypeVersionContainerRest': ...
    def withMetaType(self, deviceMetaTypeRest: DeviceMetaTypeRest) -> 'DefaultDeviceTypeVersionContainerRest': ...
    def withName(self, string: str) -> 'DefaultDeviceTypeVersionContainerRest': ...
    @overload
    def withOtherVersions(self, deviceTypeVersionRestArray: _py_List[DeviceTypeVersionRest]) -> 'DefaultDeviceTypeVersionContainerRest': ...
    @overload
    def withOtherVersions(self, iterable: java.lang.Iterable[DeviceTypeVersionRest]) -> 'DefaultDeviceTypeVersionContainerRest': ...
    def withPrimaryVersion(self, deviceTypeVersionRest: DeviceTypeVersionRest) -> 'DefaultDeviceTypeVersionContainerRest': ...
    class Builder:
        def addAllOtherVersions(self, iterable: java.lang.Iterable[DeviceTypeVersionRest]) -> 'DefaultDeviceTypeVersionContainerRest.Builder': ...
        def addOtherVersion(self, deviceTypeVersionRest: DeviceTypeVersionRest) -> 'DefaultDeviceTypeVersionContainerRest.Builder': ...
        def addOtherVersions(self, deviceTypeVersionRestArray: _py_List[DeviceTypeVersionRest]) -> 'DefaultDeviceTypeVersionContainerRest.Builder': ...
        def build(self) -> 'DefaultDeviceTypeVersionContainerRest': ...
        def description(self, string: str) -> 'DefaultDeviceTypeVersionContainerRest.Builder': ...
        def id(self, long: int) -> 'DefaultDeviceTypeVersionContainerRest.Builder': ...
        def metaType(self, deviceMetaTypeRest: DeviceMetaTypeRest) -> 'DefaultDeviceTypeVersionContainerRest.Builder': ...
        def name(self, string: str) -> 'DefaultDeviceTypeVersionContainerRest.Builder': ...
        def otherVersions(self, iterable: java.lang.Iterable[DeviceTypeVersionRest]) -> 'DefaultDeviceTypeVersionContainerRest.Builder': ...
        def primaryVersion(self, deviceTypeVersionRest: DeviceTypeVersionRest) -> 'DefaultDeviceTypeVersionContainerRest.Builder': ...

class DefaultDeviceTypeVersionNumberRest(DeviceTypeVersionNumberRest):
    @classmethod
    def builder(cls) -> 'DefaultDeviceTypeVersionNumberRest.Builder': ...
    @classmethod
    def copyOf(cls, deviceTypeVersionNumberRest: DeviceTypeVersionNumberRest) -> 'DefaultDeviceTypeVersionNumberRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getMajor(self) -> int: ...
    def getMinor(self) -> int: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withMajor(self, integer: int) -> 'DefaultDeviceTypeVersionNumberRest': ...
    def withMinor(self, integer: int) -> 'DefaultDeviceTypeVersionNumberRest': ...
    class Builder:
        def build(self) -> 'DefaultDeviceTypeVersionNumberRest': ...
        def major(self, integer: int) -> 'DefaultDeviceTypeVersionNumberRest.Builder': ...
        def minor(self, integer: int) -> 'DefaultDeviceTypeVersionNumberRest.Builder': ...

class DefaultDeviceTypeVersionRest(DeviceTypeVersionRest):
    @classmethod
    def builder(cls) -> 'DefaultDeviceTypeVersionRest.Builder': ...
    @classmethod
    def copyOf(cls, deviceTypeVersionRest: DeviceTypeVersionRest) -> 'DefaultDeviceTypeVersionRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getId(self) -> int: ...
    def getImplementation(self) -> DeviceTypeImplementationRest: ...
    def getVersionNumber(self) -> DeviceTypeVersionNumberRest: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withId(self, long: int) -> 'DefaultDeviceTypeVersionRest': ...
    def withImplementation(self, deviceTypeImplementationRest: DeviceTypeImplementationRest) -> 'DefaultDeviceTypeVersionRest': ...
    def withVersionNumber(self, deviceTypeVersionNumberRest: DeviceTypeVersionNumberRest) -> 'DefaultDeviceTypeVersionRest': ...
    class Builder:
        def build(self) -> 'DefaultDeviceTypeVersionRest': ...
        def id(self, long: int) -> 'DefaultDeviceTypeVersionRest.Builder': ...
        def implementation(self, deviceTypeImplementationRest: DeviceTypeImplementationRest) -> 'DefaultDeviceTypeVersionRest.Builder': ...
        def versionNumber(self, deviceTypeVersionNumberRest: DeviceTypeVersionNumberRest) -> 'DefaultDeviceTypeVersionRest.Builder': ...

class DefaultEnumItemRest(EnumItemRest):
    @classmethod
    def builder(cls) -> 'DefaultEnumItemRest.Builder': ...
    @classmethod
    def copyOf(cls, enumItemRest: EnumItemRest) -> 'DefaultEnumItemRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getCode(self) -> int: ...
    def getStandardMeaning(self) -> str: ...
    def getSymbol(self) -> str: ...
    def hashCode(self) -> int: ...
    def isSettable(self) -> bool: ...
    def toString(self) -> str: ...
    def withCode(self, long: int) -> 'DefaultEnumItemRest': ...
    def withSettable(self, boolean: bool) -> 'DefaultEnumItemRest': ...
    def withStandardMeaning(self, string: str) -> 'DefaultEnumItemRest': ...
    def withSymbol(self, string: str) -> 'DefaultEnumItemRest': ...
    class Builder:
        def build(self) -> 'DefaultEnumItemRest': ...
        def code(self, long: int) -> 'DefaultEnumItemRest.Builder': ...
        def settable(self, boolean: bool) -> 'DefaultEnumItemRest.Builder': ...
        def standardMeaning(self, string: str) -> 'DefaultEnumItemRest.Builder': ...
        def symbol(self, string: str) -> 'DefaultEnumItemRest.Builder': ...

class DefaultEnumTypeRest(EnumTypeRest):
    @classmethod
    def builder(cls) -> 'DefaultEnumTypeRest.Builder': ...
    @classmethod
    def copyOf(cls, enumTypeRest: EnumTypeRest) -> 'DefaultEnumTypeRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def getEnumItems(self) -> com.google.common.collect.ImmutableList[EnumItemRest]: ...
    @overload
    def getEnumItems(self) -> java.util.List: ...
    def getEnumTypeBitSize(self) -> str: ...
    def getName(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    @overload
    def withEnumItems(self, enumItemRestArray: _py_List[EnumItemRest]) -> 'DefaultEnumTypeRest': ...
    @overload
    def withEnumItems(self, iterable: java.lang.Iterable[EnumItemRest]) -> 'DefaultEnumTypeRest': ...
    def withEnumTypeBitSize(self, string: str) -> 'DefaultEnumTypeRest': ...
    def withName(self, string: str) -> 'DefaultEnumTypeRest': ...
    class Builder:
        def addAllEnumItems(self, iterable: java.lang.Iterable[EnumItemRest]) -> 'DefaultEnumTypeRest.Builder': ...
        def addEnumItem(self, enumItemRest: EnumItemRest) -> 'DefaultEnumTypeRest.Builder': ...
        def addEnumItems(self, enumItemRestArray: _py_List[EnumItemRest]) -> 'DefaultEnumTypeRest.Builder': ...
        def build(self) -> 'DefaultEnumTypeRest': ...
        def enumItems(self, iterable: java.lang.Iterable[EnumItemRest]) -> 'DefaultEnumTypeRest.Builder': ...
        def enumTypeBitSize(self, string: str) -> 'DefaultEnumTypeRest.Builder': ...
        def name(self, string: str) -> 'DefaultEnumTypeRest.Builder': ...

class DefaultErrorDto(ErrorDto):
    @classmethod
    def builder(cls) -> 'DefaultErrorDto.Builder': ...
    @classmethod
    def copyOf(cls, errorDto: ErrorDto) -> 'DefaultErrorDto': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getErrorType(self) -> str: ...
    def getMessage(self) -> str: ...
    def getPath(self) -> str: ...
    def getTimestamp(self) -> java.time.OffsetDateTime: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withErrorType(self, string: str) -> 'DefaultErrorDto': ...
    def withMessage(self, string: str) -> 'DefaultErrorDto': ...
    def withPath(self, string: str) -> 'DefaultErrorDto': ...
    def withTimestamp(self, offsetDateTime: java.time.OffsetDateTime) -> 'DefaultErrorDto': ...
    class Builder:
        def build(self) -> 'DefaultErrorDto': ...
        def errorType(self, string: str) -> 'DefaultErrorDto.Builder': ...
        def message(self, string: str) -> 'DefaultErrorDto.Builder': ...
        def path(self, string: str) -> 'DefaultErrorDto.Builder': ...
        def timestamp(self, offsetDateTime: java.time.OffsetDateTime) -> 'DefaultErrorDto.Builder': ...

class DefaultIncaPropertyFieldInfoRest(IncaPropertyFieldInfoRest):
    @classmethod
    def builder(cls) -> 'DefaultIncaPropertyFieldInfoRest.Builder': ...
    @classmethod
    def copyOf(cls, incaPropertyFieldInfoRest: IncaPropertyFieldInfoRest) -> 'DefaultIncaPropertyFieldInfoRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAssociatedPropertyFieldRest(self) -> PropertyFieldRest: ...
    def getControlWarningMessage(self) -> str: ...
    def getDisplayFormat(self) -> str: ...
    def getDisplayName(self) -> str: ...
    def getParameterValueCompareType(self) -> str: ...
    def getPropertyFieldRest(self) -> PropertyFieldRest: ...
    def hashCode(self) -> int: ...
    def isMainStatus(self) -> bool: ...
    def toString(self) -> str: ...
    def withAssociatedPropertyFieldRest(self, propertyFieldRest: PropertyFieldRest) -> 'DefaultIncaPropertyFieldInfoRest': ...
    def withControlWarningMessage(self, string: str) -> 'DefaultIncaPropertyFieldInfoRest': ...
    def withDisplayFormat(self, string: str) -> 'DefaultIncaPropertyFieldInfoRest': ...
    def withDisplayName(self, string: str) -> 'DefaultIncaPropertyFieldInfoRest': ...
    def withMainStatus(self, boolean: bool) -> 'DefaultIncaPropertyFieldInfoRest': ...
    def withParameterValueCompareType(self, string: str) -> 'DefaultIncaPropertyFieldInfoRest': ...
    def withPropertyFieldRest(self, propertyFieldRest: PropertyFieldRest) -> 'DefaultIncaPropertyFieldInfoRest': ...
    class Builder:
        def associatedPropertyFieldRest(self, propertyFieldRest: PropertyFieldRest) -> 'DefaultIncaPropertyFieldInfoRest.Builder': ...
        def build(self) -> 'DefaultIncaPropertyFieldInfoRest': ...
        def controlWarningMessage(self, string: str) -> 'DefaultIncaPropertyFieldInfoRest.Builder': ...
        def displayFormat(self, string: str) -> 'DefaultIncaPropertyFieldInfoRest.Builder': ...
        def displayName(self, string: str) -> 'DefaultIncaPropertyFieldInfoRest.Builder': ...
        def mainStatus(self, boolean: bool) -> 'DefaultIncaPropertyFieldInfoRest.Builder': ...
        def parameterValueCompareType(self, string: str) -> 'DefaultIncaPropertyFieldInfoRest.Builder': ...
        def propertyFieldRest(self, propertyFieldRest: PropertyFieldRest) -> 'DefaultIncaPropertyFieldInfoRest.Builder': ...

class DefaultIncaPropertyFieldInfosRequestRest(IncaPropertyFieldInfosRequestRest):
    @classmethod
    def builder(cls) -> 'DefaultIncaPropertyFieldInfosRequestRest.Builder': ...
    @classmethod
    def copyOf(cls, incaPropertyFieldInfosRequestRest: IncaPropertyFieldInfosRequestRest) -> 'DefaultIncaPropertyFieldInfosRequestRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def getPropertyFieldIds(self) -> com.google.common.collect.ImmutableSet[int]: ...
    @overload
    def getPropertyFieldIds(self) -> java.util.Set: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    @overload
    def withPropertyFieldIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultIncaPropertyFieldInfosRequestRest': ...
    @overload
    def withPropertyFieldIds(self, longArray: _py_List[int]) -> 'DefaultIncaPropertyFieldInfosRequestRest': ...
    class Builder:
        def addAllPropertyFieldIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultIncaPropertyFieldInfosRequestRest.Builder': ...
        def addPropertyFieldId(self, long: int) -> 'DefaultIncaPropertyFieldInfosRequestRest.Builder': ...
        def addPropertyFieldIds(self, longArray: _py_List[int]) -> 'DefaultIncaPropertyFieldInfosRequestRest.Builder': ...
        def build(self) -> 'DefaultIncaPropertyFieldInfosRequestRest': ...
        def propertyFieldIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultIncaPropertyFieldInfosRequestRest.Builder': ...

class DefaultMakeRuleClassInfoRest(MakeRuleClassInfoRest):
    @classmethod
    def builder(cls) -> 'DefaultMakeRuleClassInfoRest.Builder': ...
    @classmethod
    def copyOf(cls, makeRuleClassInfoRest: MakeRuleClassInfoRest) -> 'DefaultMakeRuleClassInfoRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getClassName(self) -> str: ...
    def getProductName(self) -> str: ...
    def getVersion(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withClassName(self, string: str) -> 'DefaultMakeRuleClassInfoRest': ...
    def withProductName(self, string: str) -> 'DefaultMakeRuleClassInfoRest': ...
    def withVersion(self, string: str) -> 'DefaultMakeRuleClassInfoRest': ...
    class Builder:
        def build(self) -> 'DefaultMakeRuleClassInfoRest': ...
        def className(self, string: str) -> 'DefaultMakeRuleClassInfoRest.Builder': ...
        def productName(self, string: str) -> 'DefaultMakeRuleClassInfoRest.Builder': ...
        def version(self, string: str) -> 'DefaultMakeRuleClassInfoRest.Builder': ...

class DefaultMakeRuleConfigInfoRest(MakeRuleConfigInfoRest):
    @classmethod
    def builder(cls) -> 'DefaultMakeRuleConfigInfoRest.Builder': ...
    @classmethod
    def copyOf(cls, makeRuleConfigInfoRest: MakeRuleConfigInfoRest) -> 'DefaultMakeRuleConfigInfoRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getMakeRuleConfigStatus(self) -> MakeRuleConfigStatusRest: ...
    def getMakeRuleInfo(self) -> MakeRuleInfoRest: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withMakeRuleConfigStatus(self, makeRuleConfigStatusRest: MakeRuleConfigStatusRest) -> 'DefaultMakeRuleConfigInfoRest': ...
    def withMakeRuleInfo(self, makeRuleInfoRest: MakeRuleInfoRest) -> 'DefaultMakeRuleConfigInfoRest': ...
    class Builder:
        def build(self) -> 'DefaultMakeRuleConfigInfoRest': ...
        def makeRuleConfigStatus(self, makeRuleConfigStatusRest: MakeRuleConfigStatusRest) -> 'DefaultMakeRuleConfigInfoRest.Builder': ...
        def makeRuleInfo(self, makeRuleInfoRest: MakeRuleInfoRest) -> 'DefaultMakeRuleConfigInfoRest.Builder': ...

class DefaultMakeRuleConfigStatusRest(MakeRuleConfigStatusRest):
    @classmethod
    def builder(cls) -> 'DefaultMakeRuleConfigStatusRest.Builder': ...
    @classmethod
    def copyOf(cls, makeRuleConfigStatusRest: MakeRuleConfigStatusRest) -> 'DefaultMakeRuleConfigStatusRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getName(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withName(self, string: str) -> 'DefaultMakeRuleConfigStatusRest': ...
    class Builder:
        def build(self) -> 'DefaultMakeRuleConfigStatusRest': ...
        def name(self, string: str) -> 'DefaultMakeRuleConfigStatusRest.Builder': ...

class DefaultMakeRuleInfoRest(MakeRuleInfoRest):
    @classmethod
    def builder(cls) -> 'DefaultMakeRuleInfoRest.Builder': ...
    @classmethod
    def copyOf(cls, makeRuleInfoRest: MakeRuleInfoRest) -> 'DefaultMakeRuleInfoRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getMakeRuleClassInfo(self) -> MakeRuleClassInfoRest: ...
    def getMakeRuleName(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withMakeRuleClassInfo(self, makeRuleClassInfoRest: MakeRuleClassInfoRest) -> 'DefaultMakeRuleInfoRest': ...
    def withMakeRuleName(self, string: str) -> 'DefaultMakeRuleInfoRest': ...
    class Builder:
        def build(self) -> 'DefaultMakeRuleInfoRest': ...
        def makeRuleClassInfo(self, makeRuleClassInfoRest: MakeRuleClassInfoRest) -> 'DefaultMakeRuleInfoRest.Builder': ...
        def makeRuleName(self, string: str) -> 'DefaultMakeRuleInfoRest.Builder': ...

class DefaultParameterAttributesRest(ParameterAttributesRest):
    @classmethod
    def builder(cls) -> 'DefaultParameterAttributesRest.Builder': ...
    @classmethod
    def copyOf(cls, parameterAttributesRest: ParameterAttributesRest) -> 'DefaultParameterAttributesRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAbsoluteTolerance(self) -> float: ...
    def getDefaultHierarchy(self) -> str: ...
    def getDevice(self) -> DeviceRest: ...
    def getMaxValue(self) -> float: ...
    def getMinValue(self) -> float: ...
    def getParameterId(self) -> int: ...
    def getParameterName(self) -> str: ...
    def getParameterType(self) -> ParameterTypeRest: ...
    def getPropertyField(self) -> PropertyFieldRest: ...
    def getRelativeTolerance(self) -> float: ...
    def getXPrecision(self) -> int: ...
    def getYPrecision(self) -> int: ...
    def hashCode(self) -> int: ...
    def isBelongsToFunctionBProc(self) -> bool: ...
    def isReservedForOpExperts(self) -> bool: ...
    def isTrimable(self) -> bool: ...
    def toString(self) -> str: ...
    def withAbsoluteTolerance(self, double: float) -> 'DefaultParameterAttributesRest': ...
    def withBelongsToFunctionBProc(self, boolean: bool) -> 'DefaultParameterAttributesRest': ...
    def withDefaultHierarchy(self, string: str) -> 'DefaultParameterAttributesRest': ...
    def withDevice(self, deviceRest: DeviceRest) -> 'DefaultParameterAttributesRest': ...
    def withMaxValue(self, double: float) -> 'DefaultParameterAttributesRest': ...
    def withMinValue(self, double: float) -> 'DefaultParameterAttributesRest': ...
    def withParameterId(self, long: int) -> 'DefaultParameterAttributesRest': ...
    def withParameterName(self, string: str) -> 'DefaultParameterAttributesRest': ...
    def withParameterType(self, parameterTypeRest: ParameterTypeRest) -> 'DefaultParameterAttributesRest': ...
    def withPropertyField(self, propertyFieldRest: PropertyFieldRest) -> 'DefaultParameterAttributesRest': ...
    def withRelativeTolerance(self, double: float) -> 'DefaultParameterAttributesRest': ...
    def withReservedForOpExperts(self, boolean: bool) -> 'DefaultParameterAttributesRest': ...
    def withTrimable(self, boolean: bool) -> 'DefaultParameterAttributesRest': ...
    def withXPrecision(self, integer: int) -> 'DefaultParameterAttributesRest': ...
    def withYPrecision(self, integer: int) -> 'DefaultParameterAttributesRest': ...
    class Builder:
        def absoluteTolerance(self, double: float) -> 'DefaultParameterAttributesRest.Builder': ...
        def belongsToFunctionBProc(self, boolean: bool) -> 'DefaultParameterAttributesRest.Builder': ...
        def build(self) -> 'DefaultParameterAttributesRest': ...
        def defaultHierarchy(self, string: str) -> 'DefaultParameterAttributesRest.Builder': ...
        def device(self, deviceRest: DeviceRest) -> 'DefaultParameterAttributesRest.Builder': ...
        def maxValue(self, double: float) -> 'DefaultParameterAttributesRest.Builder': ...
        def minValue(self, double: float) -> 'DefaultParameterAttributesRest.Builder': ...
        def parameterId(self, long: int) -> 'DefaultParameterAttributesRest.Builder': ...
        def parameterName(self, string: str) -> 'DefaultParameterAttributesRest.Builder': ...
        def parameterType(self, parameterTypeRest: ParameterTypeRest) -> 'DefaultParameterAttributesRest.Builder': ...
        def propertyField(self, propertyFieldRest: PropertyFieldRest) -> 'DefaultParameterAttributesRest.Builder': ...
        def relativeTolerance(self, double: float) -> 'DefaultParameterAttributesRest.Builder': ...
        def reservedForOpExperts(self, boolean: bool) -> 'DefaultParameterAttributesRest.Builder': ...
        def trimable(self, boolean: bool) -> 'DefaultParameterAttributesRest.Builder': ...
        def xPrecision(self, integer: int) -> 'DefaultParameterAttributesRest.Builder': ...
        def yPrecision(self, integer: int) -> 'DefaultParameterAttributesRest.Builder': ...

class DefaultParameterGroupRest(ParameterGroupRest):
    @classmethod
    def builder(cls) -> 'DefaultParameterGroupRest.Builder': ...
    @classmethod
    def copyOf(cls, parameterGroupRest: ParameterGroupRest) -> 'DefaultParameterGroupRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAcceleratorName(self) -> str: ...
    def getCreateDate(self) -> java.time.OffsetDateTime: ...
    def getCreator(self) -> str: ...
    def getDescription(self) -> str: ...
    def getId(self) -> int: ...
    def getName(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withAcceleratorName(self, string: str) -> 'DefaultParameterGroupRest': ...
    def withCreateDate(self, offsetDateTime: java.time.OffsetDateTime) -> 'DefaultParameterGroupRest': ...
    def withCreator(self, string: str) -> 'DefaultParameterGroupRest': ...
    def withDescription(self, string: str) -> 'DefaultParameterGroupRest': ...
    def withId(self, long: int) -> 'DefaultParameterGroupRest': ...
    def withName(self, string: str) -> 'DefaultParameterGroupRest': ...
    class Builder:
        def acceleratorName(self, string: str) -> 'DefaultParameterGroupRest.Builder': ...
        def build(self) -> 'DefaultParameterGroupRest': ...
        def createDate(self, offsetDateTime: java.time.OffsetDateTime) -> 'DefaultParameterGroupRest.Builder': ...
        def creator(self, string: str) -> 'DefaultParameterGroupRest.Builder': ...
        def description(self, string: str) -> 'DefaultParameterGroupRest.Builder': ...
        def id(self, long: int) -> 'DefaultParameterGroupRest.Builder': ...
        def name(self, string: str) -> 'DefaultParameterGroupRest.Builder': ...

class DefaultParameterRest(ParameterRest):
    def belongsToFunctionBeamProcess(self) -> bool: ...
    @classmethod
    def builder(cls) -> 'DefaultParameterRest.Builder': ...
    @classmethod
    def copyOf(cls, parameterRest: ParameterRest) -> 'DefaultParameterRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getDefaultHierarchy(self) -> str: ...
    def getDevice(self) -> DeviceRest: ...
    def getId(self) -> int: ...
    def getName(self) -> str: ...
    @overload
    def getParameterGroups(self) -> com.google.common.collect.ImmutableList[str]: ...
    @overload
    def getParameterGroups(self) -> java.util.List: ...
    def getParameterType(self) -> ParameterTypeRest: ...
    def getPropertyField(self) -> PropertyFieldRest: ...
    def getValueDescriptor(self) -> ValueDescriptorRest: ...
    def getValueType(self) -> TypeRest: ...
    def hashCode(self) -> int: ...
    def isCritical(self) -> bool: ...
    def isCycleBound(self) -> bool: ...
    def isMonitorable(self) -> bool: ...
    def isMultiplexed(self) -> bool: ...
    def isPropertySupportingPartialSet(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isReservedForOpExperts(self) -> bool: ...
    def isTrimable(self) -> bool: ...
    def isVirtual(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def toString(self) -> str: ...
    def withBelongsToFunctionBeamProcess(self, boolean: bool) -> 'DefaultParameterRest': ...
    def withCritical(self, boolean: bool) -> 'DefaultParameterRest': ...
    def withCycleBound(self, boolean: bool) -> 'DefaultParameterRest': ...
    def withDefaultHierarchy(self, string: str) -> 'DefaultParameterRest': ...
    def withDevice(self, deviceRest: DeviceRest) -> 'DefaultParameterRest': ...
    def withId(self, long: int) -> 'DefaultParameterRest': ...
    def withMonitorable(self, boolean: bool) -> 'DefaultParameterRest': ...
    def withMultiplexed(self, boolean: bool) -> 'DefaultParameterRest': ...
    def withName(self, string: str) -> 'DefaultParameterRest': ...
    @overload
    def withParameterGroups(self, iterable: java.lang.Iterable[str]) -> 'DefaultParameterRest': ...
    @overload
    def withParameterGroups(self, stringArray: _py_List[str]) -> 'DefaultParameterRest': ...
    def withParameterType(self, parameterTypeRest: ParameterTypeRest) -> 'DefaultParameterRest': ...
    def withPropertyField(self, propertyFieldRest: PropertyFieldRest) -> 'DefaultParameterRest': ...
    def withPropertySupportingPartialSet(self, boolean: bool) -> 'DefaultParameterRest': ...
    def withReadable(self, boolean: bool) -> 'DefaultParameterRest': ...
    def withReservedForOpExperts(self, boolean: bool) -> 'DefaultParameterRest': ...
    def withTrimable(self, boolean: bool) -> 'DefaultParameterRest': ...
    def withValueDescriptor(self, valueDescriptorRest: ValueDescriptorRest) -> 'DefaultParameterRest': ...
    def withValueType(self, typeRest: TypeRest) -> 'DefaultParameterRest': ...
    def withVirtual(self, boolean: bool) -> 'DefaultParameterRest': ...
    def withWritable(self, boolean: bool) -> 'DefaultParameterRest': ...
    class Builder:
        def addAllParameterGroups(self, iterable: java.lang.Iterable[str]) -> 'DefaultParameterRest.Builder': ...
        def addParameterGroup(self, string: str) -> 'DefaultParameterRest.Builder': ...
        def addParameterGroups(self, stringArray: _py_List[str]) -> 'DefaultParameterRest.Builder': ...
        def belongsToFunctionBeamProcess(self, boolean: bool) -> 'DefaultParameterRest.Builder': ...
        def build(self) -> 'DefaultParameterRest': ...
        def critical(self, boolean: bool) -> 'DefaultParameterRest.Builder': ...
        def cycleBound(self, boolean: bool) -> 'DefaultParameterRest.Builder': ...
        def defaultHierarchy(self, string: str) -> 'DefaultParameterRest.Builder': ...
        def device(self, deviceRest: DeviceRest) -> 'DefaultParameterRest.Builder': ...
        def id(self, long: int) -> 'DefaultParameterRest.Builder': ...
        def monitorable(self, boolean: bool) -> 'DefaultParameterRest.Builder': ...
        def multiplexed(self, boolean: bool) -> 'DefaultParameterRest.Builder': ...
        def name(self, string: str) -> 'DefaultParameterRest.Builder': ...
        def parameterGroups(self, iterable: java.lang.Iterable[str]) -> 'DefaultParameterRest.Builder': ...
        def parameterType(self, parameterTypeRest: ParameterTypeRest) -> 'DefaultParameterRest.Builder': ...
        def propertyField(self, propertyFieldRest: PropertyFieldRest) -> 'DefaultParameterRest.Builder': ...
        def propertySupportingPartialSet(self, boolean: bool) -> 'DefaultParameterRest.Builder': ...
        def readable(self, boolean: bool) -> 'DefaultParameterRest.Builder': ...
        def reservedForOpExperts(self, boolean: bool) -> 'DefaultParameterRest.Builder': ...
        def trimable(self, boolean: bool) -> 'DefaultParameterRest.Builder': ...
        def valueDescriptor(self, valueDescriptorRest: ValueDescriptorRest) -> 'DefaultParameterRest.Builder': ...
        def valueType(self, typeRest: TypeRest) -> 'DefaultParameterRest.Builder': ...
        def virtual(self, boolean: bool) -> 'DefaultParameterRest.Builder': ...
        def writable(self, boolean: bool) -> 'DefaultParameterRest.Builder': ...

class DefaultParameterTreeDataRest(ParameterTreeDataRest):
    @classmethod
    def builder(cls) -> 'DefaultParameterTreeDataRest.Builder': ...
    @classmethod
    def copyOf(cls, parameterTreeDataRest: ParameterTreeDataRest) -> 'DefaultParameterTreeDataRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def getNodes(self) -> com.google.common.collect.ImmutableSet[ParameterTreeNodeRest]: ...
    @overload
    def getNodes(self) -> java.util.Set: ...
    @overload
    def getRelations(self) -> com.google.common.collect.ImmutableSet[ParameterTreeRelationRest]: ...
    @overload
    def getRelations(self) -> java.util.Set: ...
    @overload
    def getStartNodeIds(self) -> com.google.common.collect.ImmutableSet[int]: ...
    @overload
    def getStartNodeIds(self) -> java.util.Set: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    @overload
    def withNodes(self, parameterTreeNodeRestArray: _py_List[ParameterTreeNodeRest]) -> 'DefaultParameterTreeDataRest': ...
    @overload
    def withNodes(self, iterable: java.lang.Iterable[ParameterTreeNodeRest]) -> 'DefaultParameterTreeDataRest': ...
    @overload
    def withRelations(self, parameterTreeRelationRestArray: _py_List[ParameterTreeRelationRest]) -> 'DefaultParameterTreeDataRest': ...
    @overload
    def withRelations(self, iterable: java.lang.Iterable[ParameterTreeRelationRest]) -> 'DefaultParameterTreeDataRest': ...
    @overload
    def withStartNodeIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultParameterTreeDataRest': ...
    @overload
    def withStartNodeIds(self, longArray: _py_List[int]) -> 'DefaultParameterTreeDataRest': ...
    class Builder:
        def addAllNodes(self, iterable: java.lang.Iterable[ParameterTreeNodeRest]) -> 'DefaultParameterTreeDataRest.Builder': ...
        def addAllRelations(self, iterable: java.lang.Iterable[ParameterTreeRelationRest]) -> 'DefaultParameterTreeDataRest.Builder': ...
        def addAllStartNodeIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultParameterTreeDataRest.Builder': ...
        def addNode(self, parameterTreeNodeRest: ParameterTreeNodeRest) -> 'DefaultParameterTreeDataRest.Builder': ...
        def addNodes(self, parameterTreeNodeRestArray: _py_List[ParameterTreeNodeRest]) -> 'DefaultParameterTreeDataRest.Builder': ...
        def addRelation(self, parameterTreeRelationRest: ParameterTreeRelationRest) -> 'DefaultParameterTreeDataRest.Builder': ...
        def addRelations(self, parameterTreeRelationRestArray: _py_List[ParameterTreeRelationRest]) -> 'DefaultParameterTreeDataRest.Builder': ...
        def addStartNodeId(self, long: int) -> 'DefaultParameterTreeDataRest.Builder': ...
        def addStartNodeIds(self, longArray: _py_List[int]) -> 'DefaultParameterTreeDataRest.Builder': ...
        def build(self) -> 'DefaultParameterTreeDataRest': ...
        def nodes(self, iterable: java.lang.Iterable[ParameterTreeNodeRest]) -> 'DefaultParameterTreeDataRest.Builder': ...
        def relations(self, iterable: java.lang.Iterable[ParameterTreeRelationRest]) -> 'DefaultParameterTreeDataRest.Builder': ...
        def startNodeIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultParameterTreeDataRest.Builder': ...

class DefaultParameterTreeNodeRest(ParameterTreeNodeRest):
    @classmethod
    def builder(cls) -> 'DefaultParameterTreeNodeRest.Builder': ...
    @classmethod
    def copyOf(cls, parameterTreeNodeRest: ParameterTreeNodeRest) -> 'DefaultParameterTreeNodeRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getParameter(self) -> ParameterRest: ...
    def hashCode(self) -> int: ...
    def isSource(self) -> bool: ...
    def toString(self) -> str: ...
    def withParameter(self, parameterRest: ParameterRest) -> 'DefaultParameterTreeNodeRest': ...
    def withSource(self, boolean: bool) -> 'DefaultParameterTreeNodeRest': ...
    class Builder:
        def build(self) -> 'DefaultParameterTreeNodeRest': ...
        def parameter(self, parameterRest: ParameterRest) -> 'DefaultParameterTreeNodeRest.Builder': ...
        def source(self, boolean: bool) -> 'DefaultParameterTreeNodeRest.Builder': ...

class DefaultParameterTreeRelationRest(ParameterTreeRelationRest):
    @classmethod
    def builder(cls) -> 'DefaultParameterTreeRelationRest.Builder': ...
    @classmethod
    def copyOf(cls, parameterTreeRelationRest: ParameterTreeRelationRest) -> 'DefaultParameterTreeRelationRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getChildParameterId(self) -> int: ...
    def getParentParameterId(self) -> int: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withChildParameterId(self, long: int) -> 'DefaultParameterTreeRelationRest': ...
    def withParentParameterId(self, long: int) -> 'DefaultParameterTreeRelationRest': ...
    class Builder:
        def build(self) -> 'DefaultParameterTreeRelationRest': ...
        def childParameterId(self, long: int) -> 'DefaultParameterTreeRelationRest.Builder': ...
        def parentParameterId(self, long: int) -> 'DefaultParameterTreeRelationRest.Builder': ...

class DefaultParameterTreesRequestRest(ParameterTreesRequestRest):
    @classmethod
    def builder(cls) -> 'DefaultParameterTreesRequestRest.Builder': ...
    @classmethod
    def copyOf(cls, parameterTreesRequestRest: ParameterTreesRequestRest) -> 'DefaultParameterTreesRequestRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getHierarchy(self) -> str: ...
    @overload
    def getParameterNames(self) -> com.google.common.collect.ImmutableSet[str]: ...
    @overload
    def getParameterNames(self) -> java.util.Set: ...
    def getTreeDirection(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withHierarchy(self, string: str) -> 'DefaultParameterTreesRequestRest': ...
    @overload
    def withParameterNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParameterTreesRequestRest': ...
    @overload
    def withParameterNames(self, stringArray: _py_List[str]) -> 'DefaultParameterTreesRequestRest': ...
    def withTreeDirection(self, string: str) -> 'DefaultParameterTreesRequestRest': ...
    class Builder:
        def addAllParameterNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParameterTreesRequestRest.Builder': ...
        def addParameterName(self, string: str) -> 'DefaultParameterTreesRequestRest.Builder': ...
        def addParameterNames(self, stringArray: _py_List[str]) -> 'DefaultParameterTreesRequestRest.Builder': ...
        def build(self) -> 'DefaultParameterTreesRequestRest': ...
        def hierarchy(self, string: str) -> 'DefaultParameterTreesRequestRest.Builder': ...
        def parameterNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParameterTreesRequestRest.Builder': ...
        def treeDirection(self, string: str) -> 'DefaultParameterTreesRequestRest.Builder': ...

class DefaultParameterTypeCategoryRest(ParameterTypeCategoryRest):
    @classmethod
    def builder(cls) -> 'DefaultParameterTypeCategoryRest.Builder': ...
    @classmethod
    def copyOf(cls, parameterTypeCategoryRest: ParameterTypeCategoryRest) -> 'DefaultParameterTypeCategoryRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getName(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withName(self, string: str) -> 'DefaultParameterTypeCategoryRest': ...
    class Builder:
        def build(self) -> 'DefaultParameterTypeCategoryRest': ...
        def name(self, string: str) -> 'DefaultParameterTypeCategoryRest.Builder': ...

class DefaultParameterTypeRest(ParameterTypeRest):
    @classmethod
    def builder(cls) -> 'DefaultParameterTypeRest.Builder': ...
    @classmethod
    def copyOf(cls, parameterTypeRest: ParameterTypeRest) -> 'DefaultParameterTypeRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getCategory(self) -> ParameterTypeCategoryRest: ...
    def getId(self) -> int: ...
    def getName(self) -> str: ...
    def hashCode(self) -> int: ...
    def isLinkRuleApplicable(self) -> bool: ...
    def toString(self) -> str: ...
    def withCategory(self, parameterTypeCategoryRest: ParameterTypeCategoryRest) -> 'DefaultParameterTypeRest': ...
    def withId(self, long: int) -> 'DefaultParameterTypeRest': ...
    def withLinkRuleApplicable(self, boolean: bool) -> 'DefaultParameterTypeRest': ...
    def withName(self, string: str) -> 'DefaultParameterTypeRest': ...
    class Builder:
        def build(self) -> 'DefaultParameterTypeRest': ...
        def category(self, parameterTypeCategoryRest: ParameterTypeCategoryRest) -> 'DefaultParameterTypeRest.Builder': ...
        def id(self, long: int) -> 'DefaultParameterTypeRest.Builder': ...
        def linkRuleApplicable(self, boolean: bool) -> 'DefaultParameterTypeRest.Builder': ...
        def name(self, string: str) -> 'DefaultParameterTypeRest.Builder': ...

class DefaultParameterTypesRequestRest(ParameterTypesRequestRest):
    @classmethod
    def builder(cls) -> 'DefaultParameterTypesRequestRest.Builder': ...
    @classmethod
    def copyOf(cls, parameterTypesRequestRest: ParameterTypesRequestRest) -> 'DefaultParameterTypesRequestRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def getParameterTypeNames(self) -> com.google.common.collect.ImmutableSet[str]: ...
    @overload
    def getParameterTypeNames(self) -> java.util.Set: ...
    def hashCode(self) -> int: ...
    def isAllParameterTypesRequested(self) -> bool: ...
    def toString(self) -> str: ...
    def withAllParameterTypesRequested(self, boolean: bool) -> 'DefaultParameterTypesRequestRest': ...
    @overload
    def withParameterTypeNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParameterTypesRequestRest': ...
    @overload
    def withParameterTypeNames(self, stringArray: _py_List[str]) -> 'DefaultParameterTypesRequestRest': ...
    class Builder:
        def addAllParameterTypeNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParameterTypesRequestRest.Builder': ...
        def addParameterTypeName(self, string: str) -> 'DefaultParameterTypesRequestRest.Builder': ...
        def addParameterTypeNames(self, stringArray: _py_List[str]) -> 'DefaultParameterTypesRequestRest.Builder': ...
        def allParameterTypesRequested(self, boolean: bool) -> 'DefaultParameterTypesRequestRest.Builder': ...
        def build(self) -> 'DefaultParameterTypesRequestRest': ...
        def parameterTypeNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParameterTypesRequestRest.Builder': ...

class DefaultParametersRequestRest(ParametersRequestRest):
    @classmethod
    def builder(cls) -> 'DefaultParametersRequestRest.Builder': ...
    @classmethod
    def copyOf(cls, parametersRequestRest: ParametersRequestRest) -> 'DefaultParametersRequestRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAcceleratorName(self) -> str: ...
    @overload
    def getAcceleratorZoneNames(self) -> com.google.common.collect.ImmutableSet[str]: ...
    @overload
    def getAcceleratorZoneNames(self) -> java.util.Set: ...
    @overload
    def getDeviceIds(self) -> com.google.common.collect.ImmutableSet[int]: ...
    @overload
    def getDeviceIds(self) -> java.util.Set: ...
    @overload
    def getDeviceNames(self) -> com.google.common.collect.ImmutableSet[str]: ...
    @overload
    def getDeviceNames(self) -> java.util.Set: ...
    @overload
    def getParameterGroups(self) -> com.google.common.collect.ImmutableSet[str]: ...
    @overload
    def getParameterGroups(self) -> java.util.Set: ...
    def getParameterNamePattern(self) -> str: ...
    @overload
    def getParameterNames(self) -> com.google.common.collect.ImmutableSet[str]: ...
    @overload
    def getParameterNames(self) -> java.util.Set: ...
    @overload
    def getParameterTypeNames(self) -> com.google.common.collect.ImmutableSet[str]: ...
    @overload
    def getParameterTypeNames(self) -> java.util.Set: ...
    @overload
    def getParticleTransferNames(self) -> com.google.common.collect.ImmutableSet[str]: ...
    @overload
    def getParticleTransferNames(self) -> java.util.Set: ...
    @overload
    def getPropertyFieldIds(self) -> com.google.common.collect.ImmutableSet[int]: ...
    @overload
    def getPropertyFieldIds(self) -> java.util.Set: ...
    @overload
    def getPropertyNames(self) -> com.google.common.collect.ImmutableSet[str]: ...
    @overload
    def getPropertyNames(self) -> java.util.Set: ...
    @overload
    def getValueTypes(self) -> com.google.common.collect.ImmutableSet[str]: ...
    @overload
    def getValueTypes(self) -> java.util.Set: ...
    def hashCode(self) -> int: ...
    def isCritical(self) -> bool: ...
    def isMultiplexed(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isVirtual(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def toString(self) -> str: ...
    def withAcceleratorName(self, string: str) -> 'DefaultParametersRequestRest': ...
    @overload
    def withAcceleratorZoneNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest': ...
    @overload
    def withAcceleratorZoneNames(self, stringArray: _py_List[str]) -> 'DefaultParametersRequestRest': ...
    def withCritical(self, boolean: bool) -> 'DefaultParametersRequestRest': ...
    @overload
    def withDeviceIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultParametersRequestRest': ...
    @overload
    def withDeviceIds(self, longArray: _py_List[int]) -> 'DefaultParametersRequestRest': ...
    @overload
    def withDeviceNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest': ...
    @overload
    def withDeviceNames(self, stringArray: _py_List[str]) -> 'DefaultParametersRequestRest': ...
    def withMultiplexed(self, boolean: bool) -> 'DefaultParametersRequestRest': ...
    @overload
    def withParameterGroups(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest': ...
    @overload
    def withParameterGroups(self, stringArray: _py_List[str]) -> 'DefaultParametersRequestRest': ...
    def withParameterNamePattern(self, string: str) -> 'DefaultParametersRequestRest': ...
    @overload
    def withParameterNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest': ...
    @overload
    def withParameterNames(self, stringArray: _py_List[str]) -> 'DefaultParametersRequestRest': ...
    @overload
    def withParameterTypeNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest': ...
    @overload
    def withParameterTypeNames(self, stringArray: _py_List[str]) -> 'DefaultParametersRequestRest': ...
    @overload
    def withParticleTransferNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest': ...
    @overload
    def withParticleTransferNames(self, stringArray: _py_List[str]) -> 'DefaultParametersRequestRest': ...
    @overload
    def withPropertyFieldIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultParametersRequestRest': ...
    @overload
    def withPropertyFieldIds(self, longArray: _py_List[int]) -> 'DefaultParametersRequestRest': ...
    @overload
    def withPropertyNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest': ...
    @overload
    def withPropertyNames(self, stringArray: _py_List[str]) -> 'DefaultParametersRequestRest': ...
    def withReadable(self, boolean: bool) -> 'DefaultParametersRequestRest': ...
    @overload
    def withValueTypes(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest': ...
    @overload
    def withValueTypes(self, stringArray: _py_List[str]) -> 'DefaultParametersRequestRest': ...
    def withVirtual(self, boolean: bool) -> 'DefaultParametersRequestRest': ...
    def withWritable(self, boolean: bool) -> 'DefaultParametersRequestRest': ...
    class Builder:
        def acceleratorName(self, string: str) -> 'DefaultParametersRequestRest.Builder': ...
        def acceleratorZoneNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def addAcceleratorZoneName(self, string: str) -> 'DefaultParametersRequestRest.Builder': ...
        def addAcceleratorZoneNames(self, stringArray: _py_List[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def addAllAcceleratorZoneNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def addAllDeviceIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultParametersRequestRest.Builder': ...
        def addAllDeviceNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def addAllParameterGroups(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def addAllParameterNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def addAllParameterTypeNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def addAllParticleTransferNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def addAllPropertyFieldIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultParametersRequestRest.Builder': ...
        def addAllPropertyNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def addAllValueTypes(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def addDeviceId(self, long: int) -> 'DefaultParametersRequestRest.Builder': ...
        def addDeviceIds(self, longArray: _py_List[int]) -> 'DefaultParametersRequestRest.Builder': ...
        def addDeviceName(self, string: str) -> 'DefaultParametersRequestRest.Builder': ...
        def addDeviceNames(self, stringArray: _py_List[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def addParameterGroup(self, string: str) -> 'DefaultParametersRequestRest.Builder': ...
        def addParameterGroups(self, stringArray: _py_List[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def addParameterName(self, string: str) -> 'DefaultParametersRequestRest.Builder': ...
        def addParameterNames(self, stringArray: _py_List[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def addParameterTypeName(self, string: str) -> 'DefaultParametersRequestRest.Builder': ...
        def addParameterTypeNames(self, stringArray: _py_List[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def addParticleTransferName(self, string: str) -> 'DefaultParametersRequestRest.Builder': ...
        def addParticleTransferNames(self, stringArray: _py_List[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def addPropertyFieldId(self, long: int) -> 'DefaultParametersRequestRest.Builder': ...
        def addPropertyFieldIds(self, longArray: _py_List[int]) -> 'DefaultParametersRequestRest.Builder': ...
        def addPropertyName(self, string: str) -> 'DefaultParametersRequestRest.Builder': ...
        def addPropertyNames(self, stringArray: _py_List[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def addValueType(self, string: str) -> 'DefaultParametersRequestRest.Builder': ...
        def addValueTypes(self, stringArray: _py_List[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def build(self) -> 'DefaultParametersRequestRest': ...
        def critical(self, boolean: bool) -> 'DefaultParametersRequestRest.Builder': ...
        def deviceIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultParametersRequestRest.Builder': ...
        def deviceNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def multiplexed(self, boolean: bool) -> 'DefaultParametersRequestRest.Builder': ...
        def parameterGroups(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def parameterNamePattern(self, string: str) -> 'DefaultParametersRequestRest.Builder': ...
        def parameterNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def parameterTypeNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def particleTransferNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def propertyFieldIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultParametersRequestRest.Builder': ...
        def propertyNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def readable(self, boolean: bool) -> 'DefaultParametersRequestRest.Builder': ...
        def valueTypes(self, iterable: java.lang.Iterable[str]) -> 'DefaultParametersRequestRest.Builder': ...
        def virtual(self, boolean: bool) -> 'DefaultParametersRequestRest.Builder': ...
        def writable(self, boolean: bool) -> 'DefaultParametersRequestRest.Builder': ...

class DefaultParentToChildrenRelationRest(ParentToChildrenRelationRest):
    @classmethod
    def builder(cls) -> 'DefaultParentToChildrenRelationRest.Builder': ...
    @classmethod
    def copyOf(cls, parentToChildrenRelationRest: ParentToChildrenRelationRest) -> 'DefaultParentToChildrenRelationRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def getChildrenIds(self) -> com.google.common.collect.ImmutableList[int]: ...
    @overload
    def getChildrenIds(self) -> java.util.List: ...
    def getParentId(self) -> int: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    @overload
    def withChildrenIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultParentToChildrenRelationRest': ...
    @overload
    def withChildrenIds(self, longArray: _py_List[int]) -> 'DefaultParentToChildrenRelationRest': ...
    def withParentId(self, long: int) -> 'DefaultParentToChildrenRelationRest': ...
    class Builder:
        def addAllChildrenIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultParentToChildrenRelationRest.Builder': ...
        def addChildrenId(self, long: int) -> 'DefaultParentToChildrenRelationRest.Builder': ...
        def addChildrenIds(self, longArray: _py_List[int]) -> 'DefaultParentToChildrenRelationRest.Builder': ...
        def build(self) -> 'DefaultParentToChildrenRelationRest': ...
        def childrenIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultParentToChildrenRelationRest.Builder': ...
        def parentId(self, long: int) -> 'DefaultParentToChildrenRelationRest.Builder': ...

class DefaultPropertyAndDeviceRest(PropertyAndDeviceRest):
    @classmethod
    def builder(cls) -> 'DefaultPropertyAndDeviceRest.Builder': ...
    @classmethod
    def copyOf(cls, propertyAndDeviceRest: PropertyAndDeviceRest) -> 'DefaultPropertyAndDeviceRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getDeviceId(self) -> int: ...
    def getPropertyName(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withDeviceId(self, long: int) -> 'DefaultPropertyAndDeviceRest': ...
    def withPropertyName(self, string: str) -> 'DefaultPropertyAndDeviceRest': ...
    class Builder:
        def build(self) -> 'DefaultPropertyAndDeviceRest': ...
        def deviceId(self, long: int) -> 'DefaultPropertyAndDeviceRest.Builder': ...
        def propertyName(self, string: str) -> 'DefaultPropertyAndDeviceRest.Builder': ...

class DefaultPropertyFieldRest(PropertyFieldRest):
    @classmethod
    def builder(cls) -> 'DefaultPropertyFieldRest.Builder': ...
    @classmethod
    def copyOf(cls, propertyFieldRest: PropertyFieldRest) -> 'DefaultPropertyFieldRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getDeviceTypeName(self) -> str: ...
    def getFieldName(self) -> str: ...
    def getId(self) -> int: ...
    def getPropertyName(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withDeviceTypeName(self, string: str) -> 'DefaultPropertyFieldRest': ...
    def withFieldName(self, string: str) -> 'DefaultPropertyFieldRest': ...
    def withId(self, long: int) -> 'DefaultPropertyFieldRest': ...
    def withPropertyName(self, string: str) -> 'DefaultPropertyFieldRest': ...
    class Builder:
        def build(self) -> 'DefaultPropertyFieldRest': ...
        def deviceTypeName(self, string: str) -> 'DefaultPropertyFieldRest.Builder': ...
        def fieldName(self, string: str) -> 'DefaultPropertyFieldRest.Builder': ...
        def id(self, long: int) -> 'DefaultPropertyFieldRest.Builder': ...
        def propertyName(self, string: str) -> 'DefaultPropertyFieldRest.Builder': ...

class DefaultSaveParameterRelationRest(SaveParameterRelationRest):
    @classmethod
    def builder(cls) -> 'DefaultSaveParameterRelationRest.Builder': ...
    @classmethod
    def copyOf(cls, saveParameterRelationRest: SaveParameterRelationRest) -> 'DefaultSaveParameterRelationRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getHierarchy(self) -> str: ...
    @overload
    def getParent2ChildrenRelations(self) -> com.google.common.collect.ImmutableList[ParentToChildrenRelationRest]: ...
    @overload
    def getParent2ChildrenRelations(self) -> java.util.List: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withHierarchy(self, string: str) -> 'DefaultSaveParameterRelationRest': ...
    @overload
    def withParent2ChildrenRelations(self, parentToChildrenRelationRestArray: _py_List[ParentToChildrenRelationRest]) -> 'DefaultSaveParameterRelationRest': ...
    @overload
    def withParent2ChildrenRelations(self, iterable: java.lang.Iterable[ParentToChildrenRelationRest]) -> 'DefaultSaveParameterRelationRest': ...
    class Builder:
        def addAllParent2ChildrenRelations(self, iterable: java.lang.Iterable[ParentToChildrenRelationRest]) -> 'DefaultSaveParameterRelationRest.Builder': ...
        def addParent2ChildrenRelation(self, parentToChildrenRelationRest: ParentToChildrenRelationRest) -> 'DefaultSaveParameterRelationRest.Builder': ...
        def addParent2ChildrenRelations(self, parentToChildrenRelationRestArray: _py_List[ParentToChildrenRelationRest]) -> 'DefaultSaveParameterRelationRest.Builder': ...
        def build(self) -> 'DefaultSaveParameterRelationRest': ...
        def hierarchy(self, string: str) -> 'DefaultSaveParameterRelationRest.Builder': ...
        def parent2ChildrenRelations(self, iterable: java.lang.Iterable[ParentToChildrenRelationRest]) -> 'DefaultSaveParameterRelationRest.Builder': ...

class DefaultTypeRest(TypeRest):
    @classmethod
    def builder(cls) -> 'DefaultTypeRest.Builder': ...
    @classmethod
    def copyOf(cls, typeRest: TypeRest) -> 'DefaultTypeRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getName(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withName(self, string: str) -> 'DefaultTypeRest': ...
    class Builder:
        def build(self) -> 'DefaultTypeRest': ...
        def name(self, string: str) -> 'DefaultTypeRest.Builder': ...

class DefaultValueCompareTypeRest(ValueCompareTypeRest):
    @classmethod
    def builder(cls) -> 'DefaultValueCompareTypeRest.Builder': ...
    @classmethod
    def copyOf(cls, valueCompareTypeRest: ValueCompareTypeRest) -> 'DefaultValueCompareTypeRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getName(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withName(self, string: str) -> 'DefaultValueCompareTypeRest': ...
    class Builder:
        def build(self) -> 'DefaultValueCompareTypeRest': ...
        def name(self, string: str) -> 'DefaultValueCompareTypeRest.Builder': ...

class DefaultValueDescriptorRest(ValueDescriptorRest):
    @classmethod
    def builder(cls) -> 'DefaultValueDescriptorRest.Builder': ...
    @classmethod
    def copyOf(cls, valueDescriptorRest: ValueDescriptorRest) -> 'DefaultValueDescriptorRest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAbsoluteTolerance(self) -> float: ...
    def getBooleanType(self) -> BooleanTypeRest: ...
    def getColumnCount(self) -> int: ...
    def getEnumType(self) -> EnumTypeRest: ...
    def getMax(self) -> float: ...
    def getMin(self) -> float: ...
    def getRelativeTolerance(self) -> float: ...
    def getRowCount(self) -> int: ...
    def getXPrecision(self) -> int: ...
    def getXUnit(self) -> str: ...
    def getYPrecision(self) -> int: ...
    def getYUnit(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withAbsoluteTolerance(self, double: float) -> 'DefaultValueDescriptorRest': ...
    def withBooleanType(self, booleanTypeRest: BooleanTypeRest) -> 'DefaultValueDescriptorRest': ...
    def withColumnCount(self, integer: int) -> 'DefaultValueDescriptorRest': ...
    def withEnumType(self, enumTypeRest: EnumTypeRest) -> 'DefaultValueDescriptorRest': ...
    def withMax(self, double: float) -> 'DefaultValueDescriptorRest': ...
    def withMin(self, double: float) -> 'DefaultValueDescriptorRest': ...
    def withRelativeTolerance(self, double: float) -> 'DefaultValueDescriptorRest': ...
    def withRowCount(self, integer: int) -> 'DefaultValueDescriptorRest': ...
    def withXPrecision(self, integer: int) -> 'DefaultValueDescriptorRest': ...
    def withXUnit(self, string: str) -> 'DefaultValueDescriptorRest': ...
    def withYPrecision(self, integer: int) -> 'DefaultValueDescriptorRest': ...
    def withYUnit(self, string: str) -> 'DefaultValueDescriptorRest': ...
    class Builder:
        def absoluteTolerance(self, double: float) -> 'DefaultValueDescriptorRest.Builder': ...
        def booleanType(self, booleanTypeRest: BooleanTypeRest) -> 'DefaultValueDescriptorRest.Builder': ...
        def build(self) -> 'DefaultValueDescriptorRest': ...
        def columnCount(self, integer: int) -> 'DefaultValueDescriptorRest.Builder': ...
        def enumType(self, enumTypeRest: EnumTypeRest) -> 'DefaultValueDescriptorRest.Builder': ...
        def max(self, double: float) -> 'DefaultValueDescriptorRest.Builder': ...
        def min(self, double: float) -> 'DefaultValueDescriptorRest.Builder': ...
        def relativeTolerance(self, double: float) -> 'DefaultValueDescriptorRest.Builder': ...
        def rowCount(self, integer: int) -> 'DefaultValueDescriptorRest.Builder': ...
        def xPrecision(self, integer: int) -> 'DefaultValueDescriptorRest.Builder': ...
        def xUnit(self, string: str) -> 'DefaultValueDescriptorRest.Builder': ...
        def yPrecision(self, integer: int) -> 'DefaultValueDescriptorRest.Builder': ...
        def yUnit(self, string: str) -> 'DefaultValueDescriptorRest.Builder': ...
