from typing import Any as _py_Any
from typing import List as _py_List
from typing import overload
import cern.japc.core
import cern.japc.value
import cern.japc.value.spi.value.core
import java.io
import java.lang
import java.util


class AbstractMapParameterValue(cern.japc.value.spi.value.core.ParameterValueImpl, cern.japc.value.MapParameterValue):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, mapDescriptor: cern.japc.value.MapDescriptor): ...
    @overload
    def __init__(self, stringArray: _py_List[str], simpleParameterValueArray: _py_List[cern.japc.value.SimpleParameterValue]): ...
    @overload
    def __init__(self, map: java.util.Map[str, cern.japc.value.SimpleParameterValue]): ...
    def clone(self) -> _py_Any: ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, string: str) -> cern.japc.value.SimpleParameterValue: ...
    def getNames(self) -> _py_List[str]: ...
    @overload
    def getString(self, string: str) -> str: ...
    @overload
    def getString(self, string: str, int: int) -> str: ...
    @overload
    def getString(self) -> str: ...
    def hashCode(self) -> int: ...
    @overload
    def makeMutable(self) -> 'AbstractMapParameterValue': ...
    @overload
    def makeMutable(self) -> cern.japc.value.MapParameterValue: ...
    @overload
    def makeMutable(self) -> cern.japc.value.ParameterValue: ...
    def put(self, string: str, simpleParameterValue: cern.japc.value.SimpleParameterValue) -> None: ...
    def remove(self, string: str) -> cern.japc.value.SimpleParameterValue: ...
    def setMutable(self, boolean: bool) -> None: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...

class MapDescriptorImpl(cern.japc.value.spi.value.core.AbstractValueDescriptor, cern.japc.value.MapDescriptor, java.io.Serializable):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, stringArray: _py_List[str], simpleDescriptorArray: _py_List[cern.japc.value.SimpleDescriptor]): ...
    @overload
    def __init__(self, map: java.util.Map[str, cern.japc.value.SimpleDescriptor]): ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, string: str) -> cern.japc.value.SimpleDescriptor: ...
    def getNames(self) -> _py_List[str]: ...
    def hashCode(self) -> int: ...
    def put(self, string: str, simpleDescriptor: cern.japc.value.SimpleDescriptor) -> None: ...
    def remove(self, string: str) -> cern.japc.value.SimpleDescriptor: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...

class ObjectParameterValueImpl(cern.japc.value.spi.value.core.ParameterValueImpl, cern.japc.core.ObjectParameterValue):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, object: _py_Any): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getString(self) -> str: ...
    def getValue(self) -> _py_Any: ...
    def hashCode(self) -> int: ...
    @overload
    def makeMutable(self) -> cern.japc.core.ObjectParameterValue: ...
    @overload
    def makeMutable(self) -> 'ObjectParameterValueImpl': ...
    @overload
    def makeMutable(self) -> cern.japc.value.ParameterValue: ...
    def setValue(self, object: _py_Any) -> None: ...
    def toString(self) -> str: ...

class SimpleDescriptorImpl(cern.japc.value.spi.value.core.AbstractValueDescriptor, cern.japc.value.SimpleDescriptor, java.io.Serializable):
    @overload
    def __init__(self, valueType: cern.japc.value.ValueType): ...
    @overload
    def __init__(self, valueType: cern.japc.value.ValueType, booleanType: cern.japc.value.BooleanType): ...
    @overload
    def __init__(self, valueType: cern.japc.value.ValueType, enumType: cern.japc.value.EnumType): ...
    def addExtraCharacteristic(self, string: str, string2: str) -> None: ...
    def get(self, string: str) -> cern.japc.value.SimpleDescriptor: ...
    def getBooleanType(self) -> cern.japc.value.BooleanType: ...
    def getColumnCount(self) -> int: ...
    def getDescription(self) -> str: ...
    def getEnumType(self) -> cern.japc.value.EnumType: ...
    def getExtraCharacteristic(self, string: str) -> str: ...
    def getExtraCharacteristicNames(self) -> _py_List[str]: ...
    def getFormatPattern(self) -> str: ...
    def getLength(self) -> int: ...
    def getMaxValue(self) -> float: ...
    def getMinValue(self) -> float: ...
    def getNames(self) -> _py_List[str]: ...
    def getRowCount(self) -> int: ...
    def getStandardMeaning(self, object: _py_Any) -> cern.japc.value.SimpleValueStandardMeaning: ...
    def getTitle(self) -> str: ...
    def getUnit(self) -> str: ...
    def getValueType(self) -> cern.japc.value.ValueType: ...
    def getXMaxValue(self) -> float: ...
    def getXMinValue(self) -> float: ...
    def getXUnit(self) -> str: ...
    def getYMaxValue(self) -> float: ...
    def getYMinValue(self) -> float: ...
    def getYUnit(self) -> str: ...
    def isDiscrete(self) -> bool: ...
    def isFilterable(self) -> bool: ...
    def isSettable(self, object: _py_Any) -> bool: ...
    def setColumnCount(self, int: int) -> None: ...
    def setDescription(self, string: str) -> None: ...
    def setFilterable(self, boolean: bool) -> None: ...
    def setFormatPattern(self, string: str) -> None: ...
    def setLength(self, int: int) -> None: ...
    def setMaxValue(self, double: float) -> None: ...
    def setMinValue(self, double: float) -> None: ...
    def setRowCount(self, int: int) -> None: ...
    def setTitle(self, string: str) -> None: ...
    def setUnit(self, string: str) -> None: ...
    def setXMaxValue(self, double: float) -> None: ...
    def setXMinValue(self, double: float) -> None: ...
    def setXUnit(self, string: str) -> None: ...
    def setYMaxValue(self, double: float) -> None: ...
    def setYMinValue(self, double: float) -> None: ...
    def setYUnit(self, string: str) -> None: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...

class SimpleDescriptorSupport(cern.japc.value.spi.value.core.TypedObject, cern.japc.value.SimpleDescriptor, java.io.Serializable):
    def __init__(self): ...
    def get(self, string: str) -> cern.japc.value.SimpleDescriptor: ...
    def getBooleanType(self) -> cern.japc.value.BooleanType: ...
    def getColumnCount(self) -> int: ...
    def getDescription(self) -> str: ...
    def getEnumType(self) -> cern.japc.value.EnumType: ...
    def getExtraCharacteristic(self, string: str) -> str: ...
    def getExtraCharacteristicNames(self) -> _py_List[str]: ...
    def getFormatPattern(self) -> str: ...
    def getLength(self) -> int: ...
    def getMaxValue(self) -> float: ...
    def getMinValue(self) -> float: ...
    def getNames(self) -> _py_List[str]: ...
    def getRowCount(self) -> int: ...
    def getStandardMeaning(self, object: _py_Any) -> cern.japc.value.SimpleValueStandardMeaning: ...
    def getTitle(self) -> str: ...
    def getUnit(self) -> str: ...
    def isConstant(self) -> bool: ...
    def isDiscrete(self) -> bool: ...
    def isFilterable(self) -> bool: ...
    def isSettable(self, object: _py_Any) -> bool: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...

class SimpleDescriptorToStringHelper:
    @overload
    def toString(self) -> str: ...
    @classmethod
    @overload
    def toString(cls, simpleDescriptor: cern.japc.value.SimpleDescriptor) -> str: ...
    @classmethod
    @overload
    def toString(cls, simpleDescriptor: cern.japc.value.SimpleDescriptor, string: str) -> str: ...

class EnumValueDescriptor(SimpleDescriptorImpl):
    def __init__(self, valueType: cern.japc.value.ValueType, enumType: cern.japc.value.EnumType, map: java.util.Map[cern.japc.value.EnumItem, cern.japc.value.SimpleValueStandardMeaning], set: java.util.Set[cern.japc.value.EnumItem]): ...
    def getStandardMeaning(self, object: _py_Any) -> cern.japc.value.SimpleValueStandardMeaning: ...
    def isDiscrete(self) -> bool: ...
    def isSettable(self, object: _py_Any) -> bool: ...

class MapParameterValueImpl(AbstractMapParameterValue, cern.japc.value.MapParameterValue, java.io.Serializable, java.lang.Cloneable):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, immutableMapParameterValue: cern.japc.value.ImmutableMapParameterValue): ...
    @overload
    def __init__(self, mapDescriptor: cern.japc.value.MapDescriptor): ...
    @overload
    def __init__(self, stringArray: _py_List[str], simpleParameterValueArray: _py_List[cern.japc.value.SimpleParameterValue]): ...
    @overload
    def __init__(self, map: java.util.Map[str, cern.japc.value.SimpleParameterValue]): ...
    def getArray2D(self, string: str) -> cern.japc.value.Array2D: ...
    @overload
    def getBoolean(self, string: str) -> bool: ...
    @overload
    def getBoolean(self, string: str, int: int) -> bool: ...
    @overload
    def getBooleans(self, string: str) -> _py_List[bool]: ...
    @overload
    def getBooleans(self, string: str, int: int, int2: int) -> _py_List[bool]: ...
    @overload
    def getByte(self, string: str) -> int: ...
    @overload
    def getByte(self, string: str, int: int) -> int: ...
    @overload
    def getBytes(self, string: str) -> _py_List[int]: ...
    @overload
    def getBytes(self, string: str, int: int, int2: int) -> _py_List[int]: ...
    def getColumnCount(self, string: str) -> int: ...
    def getDiscreteFunction(self, string: str) -> cern.japc.value.DiscreteFunction: ...
    def getDiscreteFunctionList(self, string: str) -> cern.japc.value.DiscreteFunctionList: ...
    @overload
    def getDouble(self, string: str) -> float: ...
    @overload
    def getDouble(self, string: str, int: int) -> float: ...
    @overload
    def getDoubles(self, string: str) -> _py_List[float]: ...
    @overload
    def getDoubles(self, string: str, int: int, int2: int) -> _py_List[float]: ...
    def getEnumItem(self, string: str) -> cern.japc.value.EnumItem: ...
    def getEnumItemSet(self, string: str) -> cern.japc.value.EnumItemSet: ...
    def getEnumItemSets(self, string: str) -> _py_List[cern.japc.value.EnumItemSet]: ...
    def getEnumItems(self, string: str) -> _py_List[cern.japc.value.EnumItem]: ...
    @overload
    def getFloat(self, string: str) -> float: ...
    @overload
    def getFloat(self, string: str, int: int) -> float: ...
    @overload
    def getFloats(self, string: str) -> _py_List[float]: ...
    @overload
    def getFloats(self, string: str, int: int, int2: int) -> _py_List[float]: ...
    @overload
    def getInt(self, string: str) -> int: ...
    @overload
    def getInt(self, string: str, int: int) -> int: ...
    @overload
    def getInts(self, string: str) -> _py_List[int]: ...
    @overload
    def getInts(self, string: str, int: int, int2: int) -> _py_List[int]: ...
    def getLength(self, string: str) -> int: ...
    @overload
    def getLong(self, string: str) -> int: ...
    @overload
    def getLong(self, string: str, int: int) -> int: ...
    @overload
    def getLongs(self, string: str) -> _py_List[int]: ...
    @overload
    def getLongs(self, string: str, int: int, int2: int) -> _py_List[int]: ...
    def getMaxValue(self, string: str) -> float: ...
    def getMinValue(self, string: str) -> float: ...
    @overload
    def getObject(self, string: str) -> _py_Any: ...
    @overload
    def getObject(self, string: str, int: int) -> _py_Any: ...
    def getRowCount(self, string: str) -> int: ...
    def getScale(self, string: str) -> int: ...
    @overload
    def getShort(self, string: str) -> int: ...
    @overload
    def getShort(self, string: str, int: int) -> int: ...
    @overload
    def getShorts(self, string: str) -> _py_List[int]: ...
    @overload
    def getShorts(self, string: str, int: int, int2: int) -> _py_List[int]: ...
    @overload
    def getString(self) -> str: ...
    @overload
    def getString(self, string: str) -> str: ...
    @overload
    def getString(self, string: str, int: int) -> str: ...
    @overload
    def getStrings(self, string: str) -> _py_List[str]: ...
    @overload
    def getStrings(self, string: str, int: int, int2: int) -> _py_List[str]: ...
    def getUnit(self, string: str) -> str: ...
    def getValueType(self, string: str) -> cern.japc.value.ValueType: ...
    def getXMaxValue(self, string: str) -> float: ...
    def getXMinValue(self, string: str) -> float: ...
    def getXUnit(self, string: str) -> str: ...
    def getYMaxValue(self, string: str) -> float: ...
    def getYMinValue(self, string: str) -> float: ...
    def getYUnit(self, string: str) -> str: ...
    @overload
    def setBoolean(self, string: str, boolean: bool) -> None: ...
    @overload
    def setBoolean(self, string: str, int: int, boolean: bool) -> None: ...
    def setBooleans(self, string: str, booleanArray: _py_List[bool]) -> None: ...
    def setBooleans2D(self, string: str, booleanArray: _py_List[bool], intArray: _py_List[int]) -> None: ...
    @overload
    def setByte(self, string: str, byte: int) -> None: ...
    @overload
    def setByte(self, string: str, int: int, byte: int) -> None: ...
    def setBytes(self, string: str, byteArray: _py_List[int]) -> None: ...
    def setBytes2D(self, string: str, byteArray: _py_List[int], intArray: _py_List[int]) -> None: ...
    def setDiscreteFunction(self, string: str, discreteFunction: cern.japc.value.DiscreteFunction) -> None: ...
    def setDiscreteFunctionList(self, string: str, discreteFunctionList: cern.japc.value.DiscreteFunctionList) -> None: ...
    @overload
    def setDouble(self, string: str, double: float) -> None: ...
    @overload
    def setDouble(self, string: str, int: int, double: float) -> None: ...
    def setDoubles(self, string: str, doubleArray: _py_List[float]) -> None: ...
    def setDoubles2D(self, string: str, doubleArray: _py_List[float], intArray: _py_List[int]) -> None: ...
    def setEnumItem(self, string: str, enumItem: cern.japc.value.EnumItem) -> None: ...
    def setEnumItemSet(self, string: str, enumItemSet: cern.japc.value.EnumItemSet) -> None: ...
    def setEnumItemSets(self, string: str, enumItemSetArray: _py_List[cern.japc.value.EnumItemSet]) -> None: ...
    def setEnumItemSets2D(self, string: str, enumItemSetArray: _py_List[cern.japc.value.EnumItemSet], intArray: _py_List[int]) -> None: ...
    def setEnumItems(self, string: str, enumItemArray: _py_List[cern.japc.value.EnumItem]) -> None: ...
    def setEnumItems2D(self, string: str, enumItemArray: _py_List[cern.japc.value.EnumItem], intArray: _py_List[int]) -> None: ...
    @overload
    def setFloat(self, string: str, float: float) -> None: ...
    @overload
    def setFloat(self, string: str, int: int, float: float) -> None: ...
    def setFloats(self, string: str, floatArray: _py_List[float]) -> None: ...
    def setFloats2D(self, string: str, floatArray: _py_List[float], intArray: _py_List[int]) -> None: ...
    @overload
    def setInt(self, string: str, int: int) -> None: ...
    @overload
    def setInt(self, string: str, int: int, int2: int) -> None: ...
    def setInts(self, string: str, intArray: _py_List[int]) -> None: ...
    def setInts2D(self, string: str, intArray: _py_List[int], intArray2: _py_List[int]) -> None: ...
    @overload
    def setLong(self, string: str, int: int, long: int) -> None: ...
    @overload
    def setLong(self, string: str, long: int) -> None: ...
    def setLongs(self, string: str, longArray: _py_List[int]) -> None: ...
    def setLongs2D(self, string: str, longArray: _py_List[int], intArray: _py_List[int]) -> None: ...
    def setObject(self, string: str, object: _py_Any) -> None: ...
    def setObjects2D(self, string: str, object: _py_Any, intArray: _py_List[int]) -> None: ...
    @overload
    def setShort(self, string: str, int: int, short: int) -> None: ...
    @overload
    def setShort(self, string: str, short: int) -> None: ...
    def setShorts(self, string: str, shortArray: _py_List[int]) -> None: ...
    def setShorts2D(self, string: str, shortArray: _py_List[int], intArray: _py_List[int]) -> None: ...
    @overload
    def setString(self, string: str, int: int, string2: str) -> None: ...
    @overload
    def setString(self, string: str, string2: str) -> None: ...
    def setStrings(self, string: str, stringArray: _py_List[str]) -> None: ...
    def setStrings2D(self, string: str, stringArray: _py_List[str], intArray: _py_List[int]) -> None: ...
