from typing import List as _py_List
from typing import overload
import cern.japc.core
import cern.japc.core.transaction
import cern.japc.value


class BasicParameterGroup:
    def add(self, parameter: cern.japc.core.Parameter) -> None: ...
    def addAll(self, parameterArray: _py_List[cern.japc.core.Parameter]) -> None: ...
    def clear(self) -> None: ...
    @overload
    def get(self, int: int) -> cern.japc.core.Parameter: ...
    @overload
    def get(self, string: str) -> cern.japc.core.Parameter: ...
    def getName(self) -> str: ...
    def getNames(self) -> _py_List[str]: ...
    def getParameterDescriptor(self, string: str) -> cern.japc.core.ParameterDescriptor: ...
    def getParameters(self) -> _py_List[cern.japc.core.Parameter]: ...
    def getValueDescriptor(self, string: str) -> cern.japc.value.ValueDescriptor: ...
    def isEmpty(self) -> bool: ...
    def remove(self, parameter: cern.japc.core.Parameter) -> None: ...
    def removeAll(self, parameterArray: _py_List[cern.japc.core.Parameter]) -> None: ...
    def size(self) -> int: ...

class FailSafeParameterValueListener:
    def valueReceived(self, failSafeParameterValueArray: _py_List[cern.japc.core.FailSafeParameterValue]) -> None: ...

class GroupSubscriptionHandle(cern.japc.core.SubscriptionConfigurator):
    def getImmediateUpdateListener(self) -> cern.japc.core.ParameterValueListener: ...
    def getListener(self) -> FailSafeParameterValueListener: ...
    def getParameterGroup(self) -> 'ImmutableParameterGroup': ...
    def isMonitoring(self) -> bool: ...
    def peekValues(self, long: int) -> _py_List[cern.japc.core.FailSafeParameterValue]: ...
    def registerImmediateUpdateListener(self, parameterValueListener: cern.japc.core.ParameterValueListener) -> None: ...
    def startMonitoring(self) -> None: ...
    def stopMonitoring(self) -> None: ...

class ParameterFieldNames:
    def __init__(self, string: str, stringArray: _py_List[str]): ...
    @classmethod
    def concatParameterFieldNames(cls, parameterFieldNamesArray: _py_List['ParameterFieldNames']) -> _py_List[str]: ...
    def getFieldNames(self) -> _py_List[str]: ...
    def getFullParameterNames(self) -> _py_List[str]: ...
    def getParameterName(self) -> str: ...

class ParameterGroupValueReceivedAdapter:
    def adaptValueReceived(self, failSafeParameterValueArray: _py_List[cern.japc.core.FailSafeParameterValue]) -> cern.japc.core.AcquiredParameterValue: ...

class ParameterGroupValueSentAdapter:
    def adaptValueSent(self, parameterValue: cern.japc.value.ParameterValue) -> _py_List[cern.japc.value.ParameterValue]: ...

class ImmutableParameterGroup(BasicParameterGroup):
    def createSubscription(self, selector: cern.japc.core.Selector, failSafeParameterValueListener: FailSafeParameterValueListener) -> GroupSubscriptionHandle: ...
    @overload
    def getValue(self, selector: cern.japc.core.Selector) -> _py_List[cern.japc.core.FailSafeParameterValue]: ...
    @overload
    def getValue(self, selector: cern.japc.core.Selector, failSafeParameterValueListener: FailSafeParameterValueListener) -> None: ...

class ParameterGroup(ImmutableParameterGroup):
    @overload
    def setValue(self, selector: cern.japc.core.Selector, parameterValueArray: _py_List[cern.japc.value.ParameterValue]) -> _py_List[cern.japc.core.FailSafeParameterValue]: ...
    @overload
    def setValue(self, selector: cern.japc.core.Selector, parameterValueArray: _py_List[cern.japc.value.ParameterValue], failSafeParameterValueListener: FailSafeParameterValueListener) -> None: ...

class TransactionalParameterGroup(ParameterGroup):
    def prepareValue(self, selector: cern.japc.core.Selector, parameterValueArray: _py_List[cern.japc.value.ParameterValue], compositeTransaction: cern.japc.core.transaction.CompositeTransaction) -> None: ...
