from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import Generic as _py_Generic
from typing import overload
import cern.accsoft.commons.value.operation
import cern.accsoft.commons.value.spi.operation
import java.lang


class OperationFactory:
    def createIndexing(self, integer: int) -> cern.accsoft.commons.value.spi.operation.Indexing: ...
    def createUnaryMinus(self) -> cern.accsoft.commons.value.spi.operation.UnaryMinus: ...
    def findBinaryOperation(self, string: str) -> cern.accsoft.commons.value.operation.BinaryOperation: ...
    def findFunctionOperation(self, string: str) -> cern.accsoft.commons.value.operation.MultiOperation: ...
    def findUnaryOperation(self, string: str) -> cern.accsoft.commons.value.operation.UnaryOperation: ...
    def getCoreOperation(self, coreOperation: 'OperationFactory.CoreOperation') -> cern.accsoft.commons.value.operation.BinaryOperation: ...
    def init(self) -> None: ...
    def registerProvider(self, operationProvider: 'OperationProvider'[cern.accsoft.commons.value.operation.Operation]) -> None: ...
    class CoreOperation(java.lang.Enum['OperationFactory.CoreOperation']):
        ADDITION: _py_ClassVar['OperationFactory.CoreOperation'] = ...
        SUBTRACTION: _py_ClassVar['OperationFactory.CoreOperation'] = ...
        MULTIPLICATION: _py_ClassVar['OperationFactory.CoreOperation'] = ...
        DIVISION: _py_ClassVar['OperationFactory.CoreOperation'] = ...
        EXPONENTIATION: _py_ClassVar['OperationFactory.CoreOperation'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'OperationFactory.CoreOperation': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['OperationFactory.CoreOperation']: ...

_OperationProvider__T = _py_TypeVar('_OperationProvider__T')  # <T>
class OperationProvider(_py_Generic[_OperationProvider__T]):
    def doProvide(self) -> None: ...
    def getInstance(self, string: str) -> _OperationProvider__T: ...
    def getType(self) -> cern.accsoft.commons.value.operation.OperationType: ...

class AbstractOperationFactory(OperationFactory):
    def __init__(self): ...
    def createUnaryMinus(self) -> cern.accsoft.commons.value.spi.operation.UnaryMinus: ...
    def getCoreOperation(self, coreOperation: OperationFactory.CoreOperation) -> cern.accsoft.commons.value.operation.BinaryOperation: ...
    def init(self) -> None: ...
    def registerProvider(self, operationProvider: OperationProvider[cern.accsoft.commons.value.operation.Operation]) -> None: ...

_AbstractOperationProvider__T = _py_TypeVar('_AbstractOperationProvider__T', bound=cern.accsoft.commons.value.operation.Operation)  # <T>
class AbstractOperationProvider(OperationProvider[_AbstractOperationProvider__T], _py_Generic[_AbstractOperationProvider__T]):
    def __init__(self): ...
    def doProvide(self) -> None: ...
    @overload
    def getInstance(self, string: str) -> _AbstractOperationProvider__T: ...
    @overload
    def getInstance(self, string: str) -> _py_Any: ...

class DefaultOperationFactory(AbstractOperationFactory):
    def __init__(self): ...
    def createIndexing(self, integer: int) -> cern.accsoft.commons.value.spi.operation.Indexing: ...
    def findBinaryOperation(self, string: str) -> cern.accsoft.commons.value.operation.BinaryOperation: ...
    def findFunctionOperation(self, string: str) -> cern.accsoft.commons.value.operation.MultiOperation: ...
    def findUnaryOperation(self, string: str) -> cern.accsoft.commons.value.operation.UnaryOperation: ...
    def init(self) -> None: ...
