from typing import Any as _py_Any
from typing import ClassVar as _py_ClassVar
from typing import overload
import java.io
import java.util


class Jps:
    def findMainClassName(self, int: int) -> str: ...

class ProcOsUtils:
    JNLP_SUFFIX: _py_ClassVar[str] = ...
    MISSING_RESULT: _py_ClassVar[str] = ...
    def findJnlpUrl(self) -> str: ...
    def findPid(self) -> int: ...
    def findProcessName(self) -> str: ...
    def findUserName(self) -> str: ...
    def isJavaExecutable(self, string: str) -> bool: ...

class ProcUtils:
    SYSPROP_APP_NAME: _py_ClassVar[str] = ...
    SYSPROP_APP_VERSION: _py_ClassVar[str] = ...
    UNKNOWN_PROCNAME: _py_ClassVar[str] = ...
    INVALID_PID: _py_ClassVar[int] = ...
    @classmethod
    def get(cls) -> 'ProcUtils': ...
    @classmethod
    def getApplicationName(cls) -> str: ...
    @classmethod
    def getNoJmxInit(cls) -> 'ProcUtils': ...
    @classmethod
    def getOfficialApplicationId(cls) -> str: ...
    @classmethod
    def getPid(cls) -> int: ...
    @overload
    def getProcessInfo(self) -> 'ProcessInfo': ...
    @overload
    def getProcessInfo(self, boolean: bool) -> 'ProcessInfo': ...
    class PUMBean:
        def geMainClassName(self) -> str: ...
        def getApplicationName(self) -> str: ...
        def getApplicationOsName(self) -> str: ...
        def getApplicationVersion(self) -> str: ...
        def getOfficialApplicationId(self) -> str: ...

class ProcUtilsBean:
    def __init__(self): ...
    def getAppName(self) -> str: ...
    def getAppVersion(self) -> str: ...
    @overload
    def getProcessInfo(self) -> 'ProcessInfo': ...
    @overload
    def getProcessInfo(self, boolean: bool) -> 'ProcessInfo': ...
    def setAppName(self, string: str) -> None: ...
    def setAppVersion(self, string: str) -> None: ...

class ProcessInfo(java.io.Serializable):
    def __init__(self): ...
    def getApplicationName(self) -> str: ...
    def getAsMap(self) -> java.util.Map[str, _py_Any]: ...
    def getHostName(self) -> str: ...
    def getJmxPort(self) -> int: ...
    def getJnlpUrl(self) -> str: ...
    def getMainClassName(self) -> str: ...
    def getOfficialApplicationId(self) -> str: ...
    def getOsProcessName(self) -> str: ...
    def getPid(self) -> int: ...
    def getSystemProperties(self) -> java.util.Properties: ...
    def getUserId(self) -> str: ...
    def getVersion(self) -> str: ...
    def getWindowTitle(self) -> str: ...
    def isJnlp(self) -> bool: ...
    def reComposeOfficialApplicationId(self) -> None: ...
    def restoreFromMap(self, map: java.util.Map[str, _py_Any]) -> None: ...
    def setApplicationName(self, string: str) -> None: ...
    def setUserId(self, string: str) -> None: ...
    def toString(self) -> str: ...

class JpsImpl(Jps):
    def findMainClassName(self, int: int) -> str: ...
    @classmethod
    def get(cls) -> Jps: ...

class ProcOsUtilsLinux(ProcOsUtils):
    def __init__(self): ...
    def findJnlpUrl(self) -> str: ...
    def findPid(self) -> int: ...
    def findProcessName(self) -> str: ...
    def findUserName(self) -> str: ...
    def isJavaExecutable(self, string: str) -> bool: ...

class ProcOsUtilsUnsupported(ProcOsUtils):
    def findJnlpUrl(self) -> str: ...
    def findPid(self) -> int: ...
    def findProcessName(self) -> str: ...
    def findUserName(self) -> str: ...
    def isJavaExecutable(self, string: str) -> bool: ...

class ProcOsUtilsWindows(ProcOsUtils):
    def findJnlpUrl(self) -> str: ...
    def findPid(self) -> int: ...
    def findProcessName(self) -> str: ...
    def findUserName(self) -> str: ...
    def isJavaExecutable(self, string: str) -> bool: ...
