from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Generic as _py_Generic
from typing import overload
import java.lang
import java.util
import java.util.concurrent
import java.util.function


_CallableWrapper__T = _py_TypeVar('_CallableWrapper__T')  # <T>
class CallableWrapper(java.util.concurrent.Callable[_CallableWrapper__T], _py_Generic[_CallableWrapper__T]):
    def call(self) -> _CallableWrapper__T: ...

class ContextAwareExecutors:
    @overload
    def newCachedThreadPool(self) -> java.util.concurrent.ExecutorService: ...
    @overload
    def newCachedThreadPool(self, threadFactory: java.util.concurrent.ThreadFactory) -> java.util.concurrent.ExecutorService: ...
    @overload
    def newFixedThreadPool(self, int: int) -> java.util.concurrent.ExecutorService: ...
    @overload
    def newFixedThreadPool(self, int: int, threadFactory: java.util.concurrent.ThreadFactory) -> java.util.concurrent.ExecutorService: ...
    @overload
    def newScheduledThreadPool(self, int: int) -> java.util.concurrent.ScheduledExecutorService: ...
    @overload
    def newScheduledThreadPool(self, int: int, threadFactory: java.util.concurrent.ThreadFactory) -> java.util.concurrent.ScheduledExecutorService: ...
    @overload
    def newSingleThreadScheduledExecutor(self) -> java.util.concurrent.ScheduledExecutorService: ...
    @overload
    def newSingleThreadScheduledExecutor(self, threadFactory: java.util.concurrent.ThreadFactory) -> java.util.concurrent.ScheduledExecutorService: ...
    @classmethod
    def withContexts(cls, contextDefinitionArray: _py_List['ContextDefinition']) -> 'ContextAwareExecutors': ...

class ContextDefinition:
    @overload
    def __init__(self, supplier: java.util.function.Supplier['ContextForwarder']): ...
    @overload
    def __init__(self, supplier: java.util.function.Supplier['ContextForwarder'], supplier2: java.util.function.Supplier['ExecutionValidator']): ...

class ContextForwarder:
    def clearContext(self) -> None: ...
    def setContext(self) -> None: ...

class ExecutionValidator:
    def validateExecute(self, runnable: java.lang.Runnable) -> None: ...
    _validateInvokeAll_0__T = _py_TypeVar('_validateInvokeAll_0__T')  # <T>
    @overload
    def validateInvokeAll(self, collection: java.util.Collection[java.util.concurrent.Callable[_validateInvokeAll_0__T]]) -> None: ...
    _validateInvokeAll_1__T = _py_TypeVar('_validateInvokeAll_1__T')  # <T>
    @overload
    def validateInvokeAll(self, collection: java.util.Collection[java.util.concurrent.Callable[_validateInvokeAll_1__T]], long: int, timeUnit: java.util.concurrent.TimeUnit) -> None: ...
    _validateInvokeAny_0__T = _py_TypeVar('_validateInvokeAny_0__T')  # <T>
    @overload
    def validateInvokeAny(self, collection: java.util.Collection[java.util.concurrent.Callable[_validateInvokeAny_0__T]]) -> None: ...
    _validateInvokeAny_1__T = _py_TypeVar('_validateInvokeAny_1__T')  # <T>
    @overload
    def validateInvokeAny(self, collection: java.util.Collection[java.util.concurrent.Callable[_validateInvokeAny_1__T]], long: int, timeUnit: java.util.concurrent.TimeUnit) -> None: ...
    @overload
    def validateSchedule(self, runnable: java.lang.Runnable, long: int, timeUnit: java.util.concurrent.TimeUnit) -> None: ...
    _validateSchedule_1__V = _py_TypeVar('_validateSchedule_1__V')  # <V>
    @overload
    def validateSchedule(self, callable: java.util.concurrent.Callable[_validateSchedule_1__V], long: int, timeUnit: java.util.concurrent.TimeUnit) -> None: ...
    def validateScheduleAtFixedRate(self, runnable: java.lang.Runnable, long: int, long2: int, timeUnit: java.util.concurrent.TimeUnit) -> None: ...
    def validateScheduleWithFixedDelay(self, runnable: java.lang.Runnable, long: int, long2: int, timeUnit: java.util.concurrent.TimeUnit) -> None: ...
    @overload
    def validateSubmit(self, runnable: java.lang.Runnable) -> None: ...
    _validateSubmit_1__T = _py_TypeVar('_validateSubmit_1__T')  # <T>
    @overload
    def validateSubmit(self, runnable: java.lang.Runnable, t: _validateSubmit_1__T) -> None: ...
    _validateSubmit_2__T = _py_TypeVar('_validateSubmit_2__T')  # <T>
    @overload
    def validateSubmit(self, callable: java.util.concurrent.Callable[_validateSubmit_2__T]) -> None: ...

class RunnableWrapper(java.lang.Runnable):
    def run(self) -> None: ...

class WrapperUtils: ...
