from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.domain
import cern.accsoft.commons.domain.modes
import cern.accsoft.commons.util
import java.lang
import java.util


class Beam(cern.accsoft.commons.util.Named):
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getBeamNumber(self) -> int: ...

class AdBeam(java.lang.Enum['AdBeam'], Beam):
    BEAM1: _py_ClassVar['AdBeam'] = ...
    @classmethod
    def fromBeamNumber(cls, int: int) -> 'AdBeam': ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.CernAccelerator: ...
    def getBeamNumber(self) -> int: ...
    def getName(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'AdBeam': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['AdBeam']: ...

class AwakeBeam(java.lang.Enum['AwakeBeam'], Beam):
    BEAM1: _py_ClassVar['AwakeBeam'] = ...
    @classmethod
    def fromBeamNumber(cls, int: int) -> 'AwakeBeam': ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.CernAccelerator: ...
    def getBeamNumber(self) -> int: ...
    def getName(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'AwakeBeam': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['AwakeBeam']: ...

class ElenaBeam(java.lang.Enum['ElenaBeam'], Beam):
    BEAM1: _py_ClassVar['ElenaBeam'] = ...
    @classmethod
    def fromBeamNumber(cls, int: int) -> 'ElenaBeam': ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.CernAccelerator: ...
    def getBeamNumber(self) -> int: ...
    def getName(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'ElenaBeam': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['ElenaBeam']: ...

class IsoldeBeam(java.lang.Enum['IsoldeBeam'], Beam):
    BEAM1: _py_ClassVar['IsoldeBeam'] = ...
    @classmethod
    def fromBeamNumber(cls, int: int) -> 'IsoldeBeam': ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.CernAccelerator: ...
    def getBeamNumber(self) -> int: ...
    def getName(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'IsoldeBeam': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['IsoldeBeam']: ...

class LeirBeam(java.lang.Enum['LeirBeam'], Beam):
    BEAM1: _py_ClassVar['LeirBeam'] = ...
    @classmethod
    def fromBeamNumber(cls, int: int) -> 'LeirBeam': ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.CernAccelerator: ...
    def getBeamNumber(self) -> int: ...
    def getName(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'LeirBeam': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['LeirBeam']: ...

class LhcBeam(java.lang.Enum['LhcBeam'], Beam):
    BEAM1: _py_ClassVar['LhcBeam'] = ...
    BEAM2: _py_ClassVar['LhcBeam'] = ...
    @classmethod
    def fromBeamNumber(cls, int: int) -> 'LhcBeam': ...
    @classmethod
    def fromNonStandardName(cls, string: str) -> 'LhcBeam': ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.CernAccelerator: ...
    def getBeamModes(self) -> java.util.Set[cern.accsoft.commons.domain.modes.LhcBeamMode]: ...
    def getBeamNumber(self) -> int: ...
    def getName(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'LhcBeam': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['LhcBeam']: ...

class PsBeam(java.lang.Enum['PsBeam'], Beam):
    BEAM1: _py_ClassVar['PsBeam'] = ...
    @classmethod
    def fromBeamNumber(cls, int: int) -> 'PsBeam': ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.CernAccelerator: ...
    def getBeamNumber(self) -> int: ...
    def getName(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'PsBeam': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['PsBeam']: ...

class PsbBeam(java.lang.Enum['PsbBeam'], Beam):
    BEAM1: _py_ClassVar['PsbBeam'] = ...
    BEAM2: _py_ClassVar['PsbBeam'] = ...
    BEAM3: _py_ClassVar['PsbBeam'] = ...
    BEAM4: _py_ClassVar['PsbBeam'] = ...
    @classmethod
    def fromBeamNumber(cls, int: int) -> 'PsbBeam': ...
    @classmethod
    def fromNonStandardName(cls, string: str) -> 'PsbBeam': ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.CernAccelerator: ...
    def getBeamNumber(self) -> int: ...
    def getName(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'PsbBeam': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['PsbBeam']: ...

class SpsBeam(java.lang.Enum['SpsBeam'], Beam):
    BEAM1: _py_ClassVar['SpsBeam'] = ...
    @classmethod
    def fromBeamNumber(cls, int: int) -> 'SpsBeam': ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.CernAccelerator: ...
    def getBeamNumber(self) -> int: ...
    def getName(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'SpsBeam': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['SpsBeam']: ...
