# Generated by Django 3.2.7 on 2021-09-14 15:48

from django.db import migrations, models


def encrypt_tokens(apps, schema_editor):
    SocialUser = apps.get_model('compliant_social_django', 'UserSocialAuth')
    for social_user in SocialUser.objects.all():
        extra_data = social_user.extra_data
        save = False

        if extra_data:
            access_token = extra_data.pop('access_token', None)
            if access_token is not None:
                social_user.actual_access_token = access_token
                save = True

            refresh_token = extra_data.pop('refresh_token', None)
            if refresh_token is not None:
                social_user.actual_refresh_token = refresh_token
                save = True

        if save is True:
            social_user.save()


class Migration(migrations.Migration):

    dependencies = [
        ('compliant_social_django', '0011_create_kms_token_fields'),
    ]

    operations = [
        migrations.RunPython(encrypt_tokens),
    ]
