# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 password_length: Optional[pulumi.Input[int]] = None,
                 password_reset_required: Optional[pulumi.Input[bool]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 permissions_boundary: Optional[pulumi.Input[str]] = None,
                 pgp_key: Optional[pulumi.Input[str]] = None,
                 ssh_key_encoding: Optional[pulumi.Input[str]] = None,
                 ssh_public_key: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 upload_iam_user_ssh_key: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[str] name: Desired name for the IAM user.
        :param pulumi.Input[bool] force_destroy: When destroying this user, destroy even if it has non-Pulumi-managed IAM access keys, login profile or MFA devices. Without forceDestroy a user with non-Pulumi-managed access keys and login profile will fail to be destroyed.
        :param pulumi.Input[int] password_length: The length of the generated password
        :param pulumi.Input[bool] password_reset_required: Whether the user should be forced to reset the generated password on first login.
        :param pulumi.Input[str] path: Desired path for the IAM user.
        :param pulumi.Input[str] permissions_boundary: The ARN of the policy that is used to set the permissions boundary for the user.
        :param pulumi.Input[str] pgp_key: Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:username`. Used to encrypt password and access key.
        :param pulumi.Input[str] ssh_key_encoding: Specifies the public key encoding format to use in the response. To retrieve the public key in ssh-rsa format, use SSH. To retrieve the public key in PEM format, use PEM.
        :param pulumi.Input[str] ssh_public_key: The SSH public key. The public key must be encoded in ssh-rsa format or PEM format.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to add.
        :param pulumi.Input[bool] upload_iam_user_ssh_key: Whether to upload a public ssh key to the IAM user.
        """
        pulumi.set(__self__, "name", name)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if password_length is not None:
            pulumi.set(__self__, "password_length", password_length)
        if password_reset_required is not None:
            pulumi.set(__self__, "password_reset_required", password_reset_required)
        if path is None:
            path = '/'
        if path is not None:
            pulumi.set(__self__, "path", path)
        if permissions_boundary is not None:
            pulumi.set(__self__, "permissions_boundary", permissions_boundary)
        if pgp_key is not None:
            pulumi.set(__self__, "pgp_key", pgp_key)
        if ssh_key_encoding is None:
            ssh_key_encoding = 'SSH'
        if ssh_key_encoding is not None:
            pulumi.set(__self__, "ssh_key_encoding", ssh_key_encoding)
        if ssh_public_key is not None:
            pulumi.set(__self__, "ssh_public_key", ssh_public_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if upload_iam_user_ssh_key is not None:
            pulumi.set(__self__, "upload_iam_user_ssh_key", upload_iam_user_ssh_key)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Desired name for the IAM user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        When destroying this user, destroy even if it has non-Pulumi-managed IAM access keys, login profile or MFA devices. Without forceDestroy a user with non-Pulumi-managed access keys and login profile will fail to be destroyed.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter(name="passwordLength")
    def password_length(self) -> Optional[pulumi.Input[int]]:
        """
        The length of the generated password
        """
        return pulumi.get(self, "password_length")

    @password_length.setter
    def password_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "password_length", value)

    @property
    @pulumi.getter(name="passwordResetRequired")
    def password_reset_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the user should be forced to reset the generated password on first login.
        """
        return pulumi.get(self, "password_reset_required")

    @password_reset_required.setter
    def password_reset_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "password_reset_required", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Desired path for the IAM user.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="permissionsBoundary")
    def permissions_boundary(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the policy that is used to set the permissions boundary for the user.
        """
        return pulumi.get(self, "permissions_boundary")

    @permissions_boundary.setter
    def permissions_boundary(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permissions_boundary", value)

    @property
    @pulumi.getter(name="pgpKey")
    def pgp_key(self) -> Optional[pulumi.Input[str]]:
        """
        Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:username`. Used to encrypt password and access key.
        """
        return pulumi.get(self, "pgp_key")

    @pgp_key.setter
    def pgp_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pgp_key", value)

    @property
    @pulumi.getter(name="sshKeyEncoding")
    def ssh_key_encoding(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the public key encoding format to use in the response. To retrieve the public key in ssh-rsa format, use SSH. To retrieve the public key in PEM format, use PEM.
        """
        return pulumi.get(self, "ssh_key_encoding")

    @ssh_key_encoding.setter
    def ssh_key_encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_key_encoding", value)

    @property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        The SSH public key. The public key must be encoded in ssh-rsa format or PEM format.
        """
        return pulumi.get(self, "ssh_public_key")

    @ssh_public_key.setter
    def ssh_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_public_key", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to add.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="uploadIamUserSshKey")
    def upload_iam_user_ssh_key(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to upload a public ssh key to the IAM user.
        """
        return pulumi.get(self, "upload_iam_user_ssh_key")

    @upload_iam_user_ssh_key.setter
    def upload_iam_user_ssh_key(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "upload_iam_user_ssh_key", value)


class User(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password_length: Optional[pulumi.Input[int]] = None,
                 password_reset_required: Optional[pulumi.Input[bool]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 permissions_boundary: Optional[pulumi.Input[str]] = None,
                 pgp_key: Optional[pulumi.Input[str]] = None,
                 ssh_key_encoding: Optional[pulumi.Input[str]] = None,
                 ssh_public_key: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 upload_iam_user_ssh_key: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Create a User resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] force_destroy: When destroying this user, destroy even if it has non-Pulumi-managed IAM access keys, login profile or MFA devices. Without forceDestroy a user with non-Pulumi-managed access keys and login profile will fail to be destroyed.
        :param pulumi.Input[str] name: Desired name for the IAM user.
        :param pulumi.Input[int] password_length: The length of the generated password
        :param pulumi.Input[bool] password_reset_required: Whether the user should be forced to reset the generated password on first login.
        :param pulumi.Input[str] path: Desired path for the IAM user.
        :param pulumi.Input[str] permissions_boundary: The ARN of the policy that is used to set the permissions boundary for the user.
        :param pulumi.Input[str] pgp_key: Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:username`. Used to encrypt password and access key.
        :param pulumi.Input[str] ssh_key_encoding: Specifies the public key encoding format to use in the response. To retrieve the public key in ssh-rsa format, use SSH. To retrieve the public key in PEM format, use PEM.
        :param pulumi.Input[str] ssh_public_key: The SSH public key. The public key must be encoded in ssh-rsa format or PEM format.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to add.
        :param pulumi.Input[bool] upload_iam_user_ssh_key: Whether to upload a public ssh key to the IAM user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a User resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password_length: Optional[pulumi.Input[int]] = None,
                 password_reset_required: Optional[pulumi.Input[bool]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 permissions_boundary: Optional[pulumi.Input[str]] = None,
                 pgp_key: Optional[pulumi.Input[str]] = None,
                 ssh_key_encoding: Optional[pulumi.Input[str]] = None,
                 ssh_public_key: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 upload_iam_user_ssh_key: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["force_destroy"] = force_destroy
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["password_length"] = password_length
            __props__.__dict__["password_reset_required"] = password_reset_required
            if path is None:
                path = '/'
            __props__.__dict__["path"] = path
            __props__.__dict__["permissions_boundary"] = permissions_boundary
            __props__.__dict__["pgp_key"] = pgp_key
            if ssh_key_encoding is None:
                ssh_key_encoding = 'SSH'
            __props__.__dict__["ssh_key_encoding"] = ssh_key_encoding
            __props__.__dict__["ssh_public_key"] = ssh_public_key
            __props__.__dict__["tags"] = tags
            __props__.__dict__["upload_iam_user_ssh_key"] = upload_iam_user_ssh_key
            __props__.__dict__["access_key"] = None
            __props__.__dict__["keybase"] = None
            __props__.__dict__["user_info"] = None
        super(User, __self__).__init__(
            'aws-iam:index:User',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output['outputs.AccessKeyOutput']:
        """
        The IAM access key.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def keybase(self) -> pulumi.Output['outputs.KeybaseOutput']:
        return pulumi.get(self, "keybase")

    @property
    @pulumi.getter(name="pgpKey")
    def pgp_key(self) -> pulumi.Output[str]:
        """
        PGP key used to encrypt sensitive data for this user (if empty - secrets are not encrypted).
        """
        return pulumi.get(self, "pgp_key")

    @property
    @pulumi.getter(name="userInfo")
    def user_info(self) -> pulumi.Output['outputs.UserOutput']:
        """
        The IAM user.
        """
        return pulumi.get(self, "user_info")

