# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'AccountPasswordPolicyArgs',
    'AdminRoleWithMFAArgs',
    'AdminRoleArgs',
    'EKSAmazonManagedServicePrometheusPolicyArgs',
    'EKSAppmeshPolicyArgs',
    'EKSCertManagerPolicyArgs',
    'EKSClusterAutoscalerPolicyArgs',
    'EKSEBSCSIPolicyArgs',
    'EKSEFSCSIPolicyArgs',
    'EKSExternalDNSPolicyArgs',
    'EKSExternalSecretsPolicyArgs',
    'EKSKarpenterControllerPolicyArgs',
    'EKSLoadBalancerPolicyArgs',
    'EKSNodeTerminationHandlerPolicyArgs',
    'EKSRolePoliciesArgs',
    'EKSServiceAccountRoleArgs',
    'EKSVPNCNIPolicyArgs',
    'EKSVeleroPolicyArgs',
    'FSxLustreCSIPolicyArgs',
    'OIDCProviderArgs',
    'PoweruserRoleWithMFAArgs',
    'PoweruserRoleArgs',
    'ReadonlyRoleWithMFAArgs',
    'ReadonlyRoleArgs',
    'RoleWithMFAArgs',
    'RoleArgs',
]

@pulumi.input_type
class AccountPasswordPolicyArgs:
    def __init__(__self__, *,
                 allow_users_to_change: pulumi.Input[bool],
                 hard_expiry: pulumi.Input[bool],
                 require_lowercase_characters: pulumi.Input[bool],
                 require_numbers: pulumi.Input[bool],
                 require_symbols: pulumi.Input[bool],
                 require_uppercase_characters: pulumi.Input[bool],
                 max_age: Optional[pulumi.Input[int]] = None,
                 minimum_length: Optional[pulumi.Input[int]] = None,
                 reuse_prevention: Optional[pulumi.Input[int]] = None):
        """
        Options to specify complexity requirements and mandatory rotation periods for your IAM users' passwords.
        :param pulumi.Input[bool] allow_users_to_change: Whether to allow users to change their own password.
        :param pulumi.Input[bool] hard_expiry: Whether users are prevented from setting a new password after their password has
               expired (i.e. require administrator reset).
        :param pulumi.Input[bool] require_lowercase_characters: Whether to require lowercase characters for user passwords.
        :param pulumi.Input[bool] require_numbers: Whether to require numbers for user passwords.
        :param pulumi.Input[bool] require_symbols: Whether to require symbols for user passwords.
        :param pulumi.Input[bool] require_uppercase_characters: Whether to require uppercase characters for user passwords.
        :param pulumi.Input[int] max_age: The number of days that an user password is valid. If not set or a value of `0` is provided, then
               passwords will not expire.
        :param pulumi.Input[int] minimum_length: Minimum length to require for user passwords. Defaults to `8` if not set or
               the provided value is invalid. Valid values are between 6 and 128.
        :param pulumi.Input[int] reuse_prevention: The number of previous passwords that users are prevented from reusing. If not set or a
               value of `0` is provided, no reuse prevention policy will be used.
        """
        pulumi.set(__self__, "allow_users_to_change", allow_users_to_change)
        pulumi.set(__self__, "hard_expiry", hard_expiry)
        pulumi.set(__self__, "require_lowercase_characters", require_lowercase_characters)
        pulumi.set(__self__, "require_numbers", require_numbers)
        pulumi.set(__self__, "require_symbols", require_symbols)
        pulumi.set(__self__, "require_uppercase_characters", require_uppercase_characters)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)
        if minimum_length is not None:
            pulumi.set(__self__, "minimum_length", minimum_length)
        if reuse_prevention is not None:
            pulumi.set(__self__, "reuse_prevention", reuse_prevention)

    @property
    @pulumi.getter(name="allowUsersToChange")
    def allow_users_to_change(self) -> pulumi.Input[bool]:
        """
        Whether to allow users to change their own password.
        """
        return pulumi.get(self, "allow_users_to_change")

    @allow_users_to_change.setter
    def allow_users_to_change(self, value: pulumi.Input[bool]):
        pulumi.set(self, "allow_users_to_change", value)

    @property
    @pulumi.getter(name="hardExpiry")
    def hard_expiry(self) -> pulumi.Input[bool]:
        """
        Whether users are prevented from setting a new password after their password has
        expired (i.e. require administrator reset).
        """
        return pulumi.get(self, "hard_expiry")

    @hard_expiry.setter
    def hard_expiry(self, value: pulumi.Input[bool]):
        pulumi.set(self, "hard_expiry", value)

    @property
    @pulumi.getter(name="requireLowercaseCharacters")
    def require_lowercase_characters(self) -> pulumi.Input[bool]:
        """
        Whether to require lowercase characters for user passwords.
        """
        return pulumi.get(self, "require_lowercase_characters")

    @require_lowercase_characters.setter
    def require_lowercase_characters(self, value: pulumi.Input[bool]):
        pulumi.set(self, "require_lowercase_characters", value)

    @property
    @pulumi.getter(name="requireNumbers")
    def require_numbers(self) -> pulumi.Input[bool]:
        """
        Whether to require numbers for user passwords.
        """
        return pulumi.get(self, "require_numbers")

    @require_numbers.setter
    def require_numbers(self, value: pulumi.Input[bool]):
        pulumi.set(self, "require_numbers", value)

    @property
    @pulumi.getter(name="requireSymbols")
    def require_symbols(self) -> pulumi.Input[bool]:
        """
        Whether to require symbols for user passwords.
        """
        return pulumi.get(self, "require_symbols")

    @require_symbols.setter
    def require_symbols(self, value: pulumi.Input[bool]):
        pulumi.set(self, "require_symbols", value)

    @property
    @pulumi.getter(name="requireUppercaseCharacters")
    def require_uppercase_characters(self) -> pulumi.Input[bool]:
        """
        Whether to require uppercase characters for user passwords.
        """
        return pulumi.get(self, "require_uppercase_characters")

    @require_uppercase_characters.setter
    def require_uppercase_characters(self, value: pulumi.Input[bool]):
        pulumi.set(self, "require_uppercase_characters", value)

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days that an user password is valid. If not set or a value of `0` is provided, then
        passwords will not expire.
        """
        return pulumi.get(self, "max_age")

    @max_age.setter
    def max_age(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_age", value)

    @property
    @pulumi.getter(name="minimumLength")
    def minimum_length(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum length to require for user passwords. Defaults to `8` if not set or
        the provided value is invalid. Valid values are between 6 and 128.
        """
        return pulumi.get(self, "minimum_length")

    @minimum_length.setter
    def minimum_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minimum_length", value)

    @property
    @pulumi.getter(name="reusePrevention")
    def reuse_prevention(self) -> Optional[pulumi.Input[int]]:
        """
        The number of previous passwords that users are prevented from reusing. If not set or a
        value of `0` is provided, no reuse prevention policy will be used.
        """
        return pulumi.get(self, "reuse_prevention")

    @reuse_prevention.setter
    def reuse_prevention(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "reuse_prevention", value)


@pulumi.input_type
class AdminRoleWithMFAArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 permissions_boundary_arn: Optional[pulumi.Input[str]] = None,
                 policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 requires_mfa: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The admin role.
        :param pulumi.Input[str] name: IAM role with admin access.
        :param pulumi.Input[str] path: Path of admin IAM role.
        :param pulumi.Input[str] permissions_boundary_arn: Permissions boundary ARN to use for admin role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policy_arns: List of policy ARNs to use for admin role.
        :param pulumi.Input[bool] requires_mfa: Whether admin role requires MFA.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to add.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if permissions_boundary_arn is None:
            permissions_boundary_arn = ''
        if permissions_boundary_arn is not None:
            pulumi.set(__self__, "permissions_boundary_arn", permissions_boundary_arn)
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)
        if requires_mfa is not None:
            pulumi.set(__self__, "requires_mfa", requires_mfa)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role with admin access.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path of admin IAM role.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="permissionsBoundaryArn")
    def permissions_boundary_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Permissions boundary ARN to use for admin role.
        """
        return pulumi.get(self, "permissions_boundary_arn")

    @permissions_boundary_arn.setter
    def permissions_boundary_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permissions_boundary_arn", value)

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of policy ARNs to use for admin role.
        """
        return pulumi.get(self, "policy_arns")

    @policy_arns.setter
    def policy_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policy_arns", value)

    @property
    @pulumi.getter(name="requiresMfa")
    def requires_mfa(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether admin role requires MFA.
        """
        return pulumi.get(self, "requires_mfa")

    @requires_mfa.setter
    def requires_mfa(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "requires_mfa", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to add.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class AdminRoleArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 permissions_boundary_arn: Optional[pulumi.Input[str]] = None,
                 policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The admin role.
        :param pulumi.Input[str] name: IAM role with admin access.
        :param pulumi.Input[str] path: Path of admin IAM role.
        :param pulumi.Input[str] permissions_boundary_arn: Permissions boundary ARN to use for admin role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policy_arns: List of policy ARNs to use for admin role.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to add.
        """
        if name is None:
            name = 'admin'
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is None:
            path = '/'
        if path is not None:
            pulumi.set(__self__, "path", path)
        if permissions_boundary_arn is None:
            permissions_boundary_arn = ''
        if permissions_boundary_arn is not None:
            pulumi.set(__self__, "permissions_boundary_arn", permissions_boundary_arn)
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role with admin access.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path of admin IAM role.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="permissionsBoundaryArn")
    def permissions_boundary_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Permissions boundary ARN to use for admin role.
        """
        return pulumi.get(self, "permissions_boundary_arn")

    @permissions_boundary_arn.setter
    def permissions_boundary_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permissions_boundary_arn", value)

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of policy ARNs to use for admin role.
        """
        return pulumi.get(self, "policy_arns")

    @policy_arns.setter
    def policy_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policy_arns", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to add.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class EKSAmazonManagedServicePrometheusPolicyArgs:
    def __init__(__self__, *,
                 attach: pulumi.Input[bool],
                 workspace_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The Amazon Managed Service for Prometheus IAM policy to the role.
        :param pulumi.Input[bool] attach: Determines whether to attach the Amazon Managed Service for Prometheus IAM policy to the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] workspace_arns: List of AMP Workspace ARNs to read and write metrics. If not provided, a default ARN of "*"
               will be provided.
        """
        pulumi.set(__self__, "attach", attach)
        if workspace_arns is not None:
            pulumi.set(__self__, "workspace_arns", workspace_arns)

    @property
    @pulumi.getter
    def attach(self) -> pulumi.Input[bool]:
        """
        Determines whether to attach the Amazon Managed Service for Prometheus IAM policy to the role.
        """
        return pulumi.get(self, "attach")

    @attach.setter
    def attach(self, value: pulumi.Input[bool]):
        pulumi.set(self, "attach", value)

    @property
    @pulumi.getter(name="workspaceArns")
    def workspace_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of AMP Workspace ARNs to read and write metrics. If not provided, a default ARN of "*"
        will be provided.
        """
        return pulumi.get(self, "workspace_arns")

    @workspace_arns.setter
    def workspace_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "workspace_arns", value)


@pulumi.input_type
class EKSAppmeshPolicyArgs:
    def __init__(__self__, *,
                 controller: Optional[pulumi.Input[bool]] = None,
                 envoy_proxy: Optional[pulumi.Input[bool]] = None):
        """
        The Appmesh policies.
        :param pulumi.Input[bool] controller: Determines whether to attach the Appmesh Controller policy to the role.
        :param pulumi.Input[bool] envoy_proxy: Determines whether to attach the Appmesh envoy proxy policy to the role.
        """
        if controller is not None:
            pulumi.set(__self__, "controller", controller)
        if envoy_proxy is not None:
            pulumi.set(__self__, "envoy_proxy", envoy_proxy)

    @property
    @pulumi.getter
    def controller(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether to attach the Appmesh Controller policy to the role.
        """
        return pulumi.get(self, "controller")

    @controller.setter
    def controller(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "controller", value)

    @property
    @pulumi.getter(name="envoyProxy")
    def envoy_proxy(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether to attach the Appmesh envoy proxy policy to the role.
        """
        return pulumi.get(self, "envoy_proxy")

    @envoy_proxy.setter
    def envoy_proxy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "envoy_proxy", value)


@pulumi.input_type
class EKSCertManagerPolicyArgs:
    def __init__(__self__, *,
                 attach: pulumi.Input[bool],
                 hosted_zone_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The Cert Manager IAM policy to attach to the role.
        :param pulumi.Input[bool] attach: Determines whether to attach the Cert Manager IAM policy to the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hosted_zone_arns: Route53 hosted zone ARNs to allow Cert manager to manage records. If not provided,
               the default ARN "arn:aws:route53:::hostedzone/*" will be applied.
        """
        pulumi.set(__self__, "attach", attach)
        if hosted_zone_arns is not None:
            pulumi.set(__self__, "hosted_zone_arns", hosted_zone_arns)

    @property
    @pulumi.getter
    def attach(self) -> pulumi.Input[bool]:
        """
        Determines whether to attach the Cert Manager IAM policy to the role.
        """
        return pulumi.get(self, "attach")

    @attach.setter
    def attach(self, value: pulumi.Input[bool]):
        pulumi.set(self, "attach", value)

    @property
    @pulumi.getter(name="hostedZoneArns")
    def hosted_zone_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Route53 hosted zone ARNs to allow Cert manager to manage records. If not provided,
        the default ARN "arn:aws:route53:::hostedzone/*" will be applied.
        """
        return pulumi.get(self, "hosted_zone_arns")

    @hosted_zone_arns.setter
    def hosted_zone_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "hosted_zone_arns", value)


@pulumi.input_type
class EKSClusterAutoscalerPolicyArgs:
    def __init__(__self__, *,
                 attach: pulumi.Input[bool],
                 cluster_ids: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        The Cluster Autoscaler IAM policy to the role.
        :param pulumi.Input[bool] attach: Determines whether to attach the Cluster Autoscaler IAM policy to the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cluster_ids: List of cluster IDs to appropriately scope permissions within the Cluster Autoscaler IAM policy.
        """
        pulumi.set(__self__, "attach", attach)
        pulumi.set(__self__, "cluster_ids", cluster_ids)

    @property
    @pulumi.getter
    def attach(self) -> pulumi.Input[bool]:
        """
        Determines whether to attach the Cluster Autoscaler IAM policy to the role.
        """
        return pulumi.get(self, "attach")

    @attach.setter
    def attach(self, value: pulumi.Input[bool]):
        pulumi.set(self, "attach", value)

    @property
    @pulumi.getter(name="clusterIds")
    def cluster_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of cluster IDs to appropriately scope permissions within the Cluster Autoscaler IAM policy.
        """
        return pulumi.get(self, "cluster_ids")

    @cluster_ids.setter
    def cluster_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "cluster_ids", value)


@pulumi.input_type
class EKSEBSCSIPolicyArgs:
    def __init__(__self__, *,
                 attach: pulumi.Input[bool],
                 kms_cmk_ids: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        The EBS CSI IAM policy to the role.
        :param pulumi.Input[bool] attach: Determines whether to attach the EBS CSI IAM policy to the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kms_cmk_ids: KMS CMK IDs to allow EBS CSI to manage encrypted volumes.
        """
        pulumi.set(__self__, "attach", attach)
        pulumi.set(__self__, "kms_cmk_ids", kms_cmk_ids)

    @property
    @pulumi.getter
    def attach(self) -> pulumi.Input[bool]:
        """
        Determines whether to attach the EBS CSI IAM policy to the role.
        """
        return pulumi.get(self, "attach")

    @attach.setter
    def attach(self, value: pulumi.Input[bool]):
        pulumi.set(self, "attach", value)

    @property
    @pulumi.getter(name="kmsCmkIds")
    def kms_cmk_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        KMS CMK IDs to allow EBS CSI to manage encrypted volumes.
        """
        return pulumi.get(self, "kms_cmk_ids")

    @kms_cmk_ids.setter
    def kms_cmk_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "kms_cmk_ids", value)


@pulumi.input_type
class EKSEFSCSIPolicyArgs:
    def __init__(__self__, *,
                 attach: pulumi.Input[bool]):
        """
        The EFS CSI IAM policy to the role.
        :param pulumi.Input[bool] attach: Determines whether to attach the EFS CSI IAM policy to the role.
        """
        pulumi.set(__self__, "attach", attach)

    @property
    @pulumi.getter
    def attach(self) -> pulumi.Input[bool]:
        """
        Determines whether to attach the EFS CSI IAM policy to the role.
        """
        return pulumi.get(self, "attach")

    @attach.setter
    def attach(self, value: pulumi.Input[bool]):
        pulumi.set(self, "attach", value)


@pulumi.input_type
class EKSExternalDNSPolicyArgs:
    def __init__(__self__, *,
                 attach: pulumi.Input[bool],
                 hosted_zone_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The External DNS IAM policy to the role.
        :param pulumi.Input[bool] attach: Determines whether to attach the External DNS IAM policy to the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hosted_zone_arns: Route53 hosted zone ARNs to allow External DNS to manage records. If not provided,
               the default ARN "arn:aws:route53:::hostedzone/*" will be applied.
        """
        pulumi.set(__self__, "attach", attach)
        if hosted_zone_arns is not None:
            pulumi.set(__self__, "hosted_zone_arns", hosted_zone_arns)

    @property
    @pulumi.getter
    def attach(self) -> pulumi.Input[bool]:
        """
        Determines whether to attach the External DNS IAM policy to the role.
        """
        return pulumi.get(self, "attach")

    @attach.setter
    def attach(self, value: pulumi.Input[bool]):
        pulumi.set(self, "attach", value)

    @property
    @pulumi.getter(name="hostedZoneArns")
    def hosted_zone_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Route53 hosted zone ARNs to allow External DNS to manage records. If not provided,
        the default ARN "arn:aws:route53:::hostedzone/*" will be applied.
        """
        return pulumi.get(self, "hosted_zone_arns")

    @hosted_zone_arns.setter
    def hosted_zone_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "hosted_zone_arns", value)


@pulumi.input_type
class EKSExternalSecretsPolicyArgs:
    def __init__(__self__, *,
                 attach: pulumi.Input[bool],
                 secrets_manager_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ssm_parameter_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The External Secrets policy to the role.
        :param pulumi.Input[bool] attach: Determines whether to attach the External Secrets policy to the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] secrets_manager_arns: List of Secrets Manager ARNs that contain secrets to mount using External Secrets. If not provided, the default ARN "arn:aws:secretsmanager:*:*:secret:*" will be applied.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssm_parameter_arns: List of Systems Manager Parameter ARNs that contain secrets to mount using External Secrets. If not provided,
               the default ARN "arn:aws:ssm:*:*:parameter/*" will be applied.
        """
        pulumi.set(__self__, "attach", attach)
        if secrets_manager_arns is not None:
            pulumi.set(__self__, "secrets_manager_arns", secrets_manager_arns)
        if ssm_parameter_arns is not None:
            pulumi.set(__self__, "ssm_parameter_arns", ssm_parameter_arns)

    @property
    @pulumi.getter
    def attach(self) -> pulumi.Input[bool]:
        """
        Determines whether to attach the External Secrets policy to the role.
        """
        return pulumi.get(self, "attach")

    @attach.setter
    def attach(self, value: pulumi.Input[bool]):
        pulumi.set(self, "attach", value)

    @property
    @pulumi.getter(name="secretsManagerArns")
    def secrets_manager_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Secrets Manager ARNs that contain secrets to mount using External Secrets. If not provided, the default ARN "arn:aws:secretsmanager:*:*:secret:*" will be applied.
        """
        return pulumi.get(self, "secrets_manager_arns")

    @secrets_manager_arns.setter
    def secrets_manager_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "secrets_manager_arns", value)

    @property
    @pulumi.getter(name="ssmParameterArns")
    def ssm_parameter_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Systems Manager Parameter ARNs that contain secrets to mount using External Secrets. If not provided,
        the default ARN "arn:aws:ssm:*:*:parameter/*" will be applied.
        """
        return pulumi.get(self, "ssm_parameter_arns")

    @ssm_parameter_arns.setter
    def ssm_parameter_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ssm_parameter_arns", value)


@pulumi.input_type
class EKSKarpenterControllerPolicyArgs:
    def __init__(__self__, *,
                 attach: pulumi.Input[bool],
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 node_iam_role_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ssm_parameter_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_account_id: Optional[pulumi.Input[str]] = None,
                 tag_key: Optional[pulumi.Input[str]] = None):
        """
        The Karpenter Controller policy to the role.
        :param pulumi.Input[bool] attach: Determines whether to attach the Karpenter Controller policy to the role.
        :param pulumi.Input[str] cluster_id: Cluster ID where the Karpenter controller is provisioned/managing.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_iam_role_arns: List of node IAM role ARNs Karpenter can use to launch nodes. If not provided,
               the default ARN "*" will be applied.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssm_parameter_arns: List of SSM Parameter ARNs that contain AMI IDs launched by Karpenter. If not provided,
               the default ARN "arn:aws:ssm:*:*:parameter/aws/service/*" will be applied.
        :param pulumi.Input[str] subnet_account_id: Account ID of where the subnets Karpenter will utilize resides. Used when subnets are shared from another account.
        :param pulumi.Input[str] tag_key: Tag key (`{key = value}`) applied to resources launched by Karpenter through the Karpenter provisioner.
        """
        pulumi.set(__self__, "attach", attach)
        if cluster_id is None:
            cluster_id = '*'
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if node_iam_role_arns is not None:
            pulumi.set(__self__, "node_iam_role_arns", node_iam_role_arns)
        if ssm_parameter_arns is not None:
            pulumi.set(__self__, "ssm_parameter_arns", ssm_parameter_arns)
        if subnet_account_id is not None:
            pulumi.set(__self__, "subnet_account_id", subnet_account_id)
        if tag_key is None:
            tag_key = 'karpenter.sh/discovery'
        if tag_key is not None:
            pulumi.set(__self__, "tag_key", tag_key)

    @property
    @pulumi.getter
    def attach(self) -> pulumi.Input[bool]:
        """
        Determines whether to attach the Karpenter Controller policy to the role.
        """
        return pulumi.get(self, "attach")

    @attach.setter
    def attach(self, value: pulumi.Input[bool]):
        pulumi.set(self, "attach", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster ID where the Karpenter controller is provisioned/managing.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="nodeIamRoleArns")
    def node_iam_role_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of node IAM role ARNs Karpenter can use to launch nodes. If not provided,
        the default ARN "*" will be applied.
        """
        return pulumi.get(self, "node_iam_role_arns")

    @node_iam_role_arns.setter
    def node_iam_role_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_iam_role_arns", value)

    @property
    @pulumi.getter(name="ssmParameterArns")
    def ssm_parameter_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of SSM Parameter ARNs that contain AMI IDs launched by Karpenter. If not provided,
        the default ARN "arn:aws:ssm:*:*:parameter/aws/service/*" will be applied.
        """
        return pulumi.get(self, "ssm_parameter_arns")

    @ssm_parameter_arns.setter
    def ssm_parameter_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ssm_parameter_arns", value)

    @property
    @pulumi.getter(name="subnetAccountId")
    def subnet_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Account ID of where the subnets Karpenter will utilize resides. Used when subnets are shared from another account.
        """
        return pulumi.get(self, "subnet_account_id")

    @subnet_account_id.setter
    def subnet_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_account_id", value)

    @property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> Optional[pulumi.Input[str]]:
        """
        Tag key (`{key = value}`) applied to resources launched by Karpenter through the Karpenter provisioner.
        """
        return pulumi.get(self, "tag_key")

    @tag_key.setter
    def tag_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_key", value)


@pulumi.input_type
class EKSLoadBalancerPolicyArgs:
    def __init__(__self__, *,
                 controller: Optional[pulumi.Input[bool]] = None,
                 target_group_binding_only: Optional[pulumi.Input[bool]] = None):
        """
        The Load Balancer policy.
        :param pulumi.Input[bool] controller: Determines whether to attach the Load Balancer Controller policy to the role.
        :param pulumi.Input[bool] target_group_binding_only: Determines whether to attach the Load Balancer Controller policy for the TargetGroupBinding only.
        """
        if controller is not None:
            pulumi.set(__self__, "controller", controller)
        if target_group_binding_only is not None:
            pulumi.set(__self__, "target_group_binding_only", target_group_binding_only)

    @property
    @pulumi.getter
    def controller(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether to attach the Load Balancer Controller policy to the role.
        """
        return pulumi.get(self, "controller")

    @controller.setter
    def controller(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "controller", value)

    @property
    @pulumi.getter(name="targetGroupBindingOnly")
    def target_group_binding_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether to attach the Load Balancer Controller policy for the TargetGroupBinding only.
        """
        return pulumi.get(self, "target_group_binding_only")

    @target_group_binding_only.setter
    def target_group_binding_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "target_group_binding_only", value)


@pulumi.input_type
class EKSNodeTerminationHandlerPolicyArgs:
    def __init__(__self__, *,
                 attach: pulumi.Input[bool],
                 sqs_queue_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The Node Termination Handler policy to the role.
        :param pulumi.Input[bool] attach: Determines whether to attach the Node Termination Handler policy to the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sqs_queue_arns: List of SQS ARNs that contain node termination events. If not provided, then a default
               ARN of "*" will be provided.
        """
        pulumi.set(__self__, "attach", attach)
        if sqs_queue_arns is not None:
            pulumi.set(__self__, "sqs_queue_arns", sqs_queue_arns)

    @property
    @pulumi.getter
    def attach(self) -> pulumi.Input[bool]:
        """
        Determines whether to attach the Node Termination Handler policy to the role.
        """
        return pulumi.get(self, "attach")

    @attach.setter
    def attach(self, value: pulumi.Input[bool]):
        pulumi.set(self, "attach", value)

    @property
    @pulumi.getter(name="sqsQueueArns")
    def sqs_queue_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of SQS ARNs that contain node termination events. If not provided, then a default
        ARN of "*" will be provided.
        """
        return pulumi.get(self, "sqs_queue_arns")

    @sqs_queue_arns.setter
    def sqs_queue_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sqs_queue_arns", value)


@pulumi.input_type
class EKSRolePoliciesArgs:
    def __init__(__self__, *,
                 amazon_managed_service_prometheus: Optional[pulumi.Input['EKSAmazonManagedServicePrometheusPolicyArgs']] = None,
                 appmesh: Optional[pulumi.Input['EKSAppmeshPolicyArgs']] = None,
                 cert_manager: Optional[pulumi.Input['EKSCertManagerPolicyArgs']] = None,
                 cluster_auto_scaling: Optional[pulumi.Input['EKSClusterAutoscalerPolicyArgs']] = None,
                 ebs_csi: Optional[pulumi.Input['EKSEBSCSIPolicyArgs']] = None,
                 efs_csi: Optional[pulumi.Input['EKSEFSCSIPolicyArgs']] = None,
                 external_dns: Optional[pulumi.Input['EKSExternalDNSPolicyArgs']] = None,
                 external_secrets: Optional[pulumi.Input['EKSExternalSecretsPolicyArgs']] = None,
                 fsx_lustre_csi: Optional[pulumi.Input['FSxLustreCSIPolicyArgs']] = None,
                 karpenter_controller: Optional[pulumi.Input['EKSKarpenterControllerPolicyArgs']] = None,
                 load_balancer: Optional[pulumi.Input['EKSLoadBalancerPolicyArgs']] = None,
                 node_termination_handler: Optional[pulumi.Input['EKSNodeTerminationHandlerPolicyArgs']] = None,
                 velero: Optional[pulumi.Input['EKSVeleroPolicyArgs']] = None,
                 vpn_cni: Optional[pulumi.Input['EKSVPNCNIPolicyArgs']] = None):
        """
        The different policies to attach to the role.
        :param pulumi.Input['EKSAmazonManagedServicePrometheusPolicyArgs'] amazon_managed_service_prometheus: The Amazon Managed Service for Prometheus IAM policy.
        :param pulumi.Input['EKSAppmeshPolicyArgs'] appmesh: The Appmesh policies.
        :param pulumi.Input['EKSCertManagerPolicyArgs'] cert_manager: The Cert Manager IAM policy.
        :param pulumi.Input['EKSClusterAutoscalerPolicyArgs'] cluster_auto_scaling: The Cluster Autoscaler IAM policy.
        :param pulumi.Input['EKSEBSCSIPolicyArgs'] ebs_csi: The EBS CSI IAM policy.
        :param pulumi.Input['EKSEFSCSIPolicyArgs'] efs_csi: The EFS CSI IAM policy.
        :param pulumi.Input['EKSExternalDNSPolicyArgs'] external_dns: The External DNS IAM policy.
        :param pulumi.Input['EKSExternalSecretsPolicyArgs'] external_secrets: The External Secrets policy.
        :param pulumi.Input['FSxLustreCSIPolicyArgs'] fsx_lustre_csi: The FSx for Lustre CSI Driver IAM policy.
        :param pulumi.Input['EKSKarpenterControllerPolicyArgs'] karpenter_controller: The Karpenter Controller policy.
        :param pulumi.Input['EKSLoadBalancerPolicyArgs'] load_balancer: The Load Balancer policy.
        :param pulumi.Input['EKSNodeTerminationHandlerPolicyArgs'] node_termination_handler: The Node Termination Handler policy to the role.
        :param pulumi.Input['EKSVeleroPolicyArgs'] velero: The Velero IAM policy.
        :param pulumi.Input['EKSVPNCNIPolicyArgs'] vpn_cni: The VPC CNI IAM policy to the role.
        """
        if amazon_managed_service_prometheus is not None:
            pulumi.set(__self__, "amazon_managed_service_prometheus", amazon_managed_service_prometheus)
        if appmesh is not None:
            pulumi.set(__self__, "appmesh", appmesh)
        if cert_manager is not None:
            pulumi.set(__self__, "cert_manager", cert_manager)
        if cluster_auto_scaling is not None:
            pulumi.set(__self__, "cluster_auto_scaling", cluster_auto_scaling)
        if ebs_csi is not None:
            pulumi.set(__self__, "ebs_csi", ebs_csi)
        if efs_csi is not None:
            pulumi.set(__self__, "efs_csi", efs_csi)
        if external_dns is not None:
            pulumi.set(__self__, "external_dns", external_dns)
        if external_secrets is not None:
            pulumi.set(__self__, "external_secrets", external_secrets)
        if fsx_lustre_csi is not None:
            pulumi.set(__self__, "fsx_lustre_csi", fsx_lustre_csi)
        if karpenter_controller is not None:
            pulumi.set(__self__, "karpenter_controller", karpenter_controller)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if node_termination_handler is not None:
            pulumi.set(__self__, "node_termination_handler", node_termination_handler)
        if velero is not None:
            pulumi.set(__self__, "velero", velero)
        if vpn_cni is not None:
            pulumi.set(__self__, "vpn_cni", vpn_cni)

    @property
    @pulumi.getter(name="amazonManagedServicePrometheus")
    def amazon_managed_service_prometheus(self) -> Optional[pulumi.Input['EKSAmazonManagedServicePrometheusPolicyArgs']]:
        """
        The Amazon Managed Service for Prometheus IAM policy.
        """
        return pulumi.get(self, "amazon_managed_service_prometheus")

    @amazon_managed_service_prometheus.setter
    def amazon_managed_service_prometheus(self, value: Optional[pulumi.Input['EKSAmazonManagedServicePrometheusPolicyArgs']]):
        pulumi.set(self, "amazon_managed_service_prometheus", value)

    @property
    @pulumi.getter
    def appmesh(self) -> Optional[pulumi.Input['EKSAppmeshPolicyArgs']]:
        """
        The Appmesh policies.
        """
        return pulumi.get(self, "appmesh")

    @appmesh.setter
    def appmesh(self, value: Optional[pulumi.Input['EKSAppmeshPolicyArgs']]):
        pulumi.set(self, "appmesh", value)

    @property
    @pulumi.getter(name="certManager")
    def cert_manager(self) -> Optional[pulumi.Input['EKSCertManagerPolicyArgs']]:
        """
        The Cert Manager IAM policy.
        """
        return pulumi.get(self, "cert_manager")

    @cert_manager.setter
    def cert_manager(self, value: Optional[pulumi.Input['EKSCertManagerPolicyArgs']]):
        pulumi.set(self, "cert_manager", value)

    @property
    @pulumi.getter(name="clusterAutoScaling")
    def cluster_auto_scaling(self) -> Optional[pulumi.Input['EKSClusterAutoscalerPolicyArgs']]:
        """
        The Cluster Autoscaler IAM policy.
        """
        return pulumi.get(self, "cluster_auto_scaling")

    @cluster_auto_scaling.setter
    def cluster_auto_scaling(self, value: Optional[pulumi.Input['EKSClusterAutoscalerPolicyArgs']]):
        pulumi.set(self, "cluster_auto_scaling", value)

    @property
    @pulumi.getter(name="ebsCsi")
    def ebs_csi(self) -> Optional[pulumi.Input['EKSEBSCSIPolicyArgs']]:
        """
        The EBS CSI IAM policy.
        """
        return pulumi.get(self, "ebs_csi")

    @ebs_csi.setter
    def ebs_csi(self, value: Optional[pulumi.Input['EKSEBSCSIPolicyArgs']]):
        pulumi.set(self, "ebs_csi", value)

    @property
    @pulumi.getter(name="efsCsi")
    def efs_csi(self) -> Optional[pulumi.Input['EKSEFSCSIPolicyArgs']]:
        """
        The EFS CSI IAM policy.
        """
        return pulumi.get(self, "efs_csi")

    @efs_csi.setter
    def efs_csi(self, value: Optional[pulumi.Input['EKSEFSCSIPolicyArgs']]):
        pulumi.set(self, "efs_csi", value)

    @property
    @pulumi.getter(name="externalDns")
    def external_dns(self) -> Optional[pulumi.Input['EKSExternalDNSPolicyArgs']]:
        """
        The External DNS IAM policy.
        """
        return pulumi.get(self, "external_dns")

    @external_dns.setter
    def external_dns(self, value: Optional[pulumi.Input['EKSExternalDNSPolicyArgs']]):
        pulumi.set(self, "external_dns", value)

    @property
    @pulumi.getter(name="externalSecrets")
    def external_secrets(self) -> Optional[pulumi.Input['EKSExternalSecretsPolicyArgs']]:
        """
        The External Secrets policy.
        """
        return pulumi.get(self, "external_secrets")

    @external_secrets.setter
    def external_secrets(self, value: Optional[pulumi.Input['EKSExternalSecretsPolicyArgs']]):
        pulumi.set(self, "external_secrets", value)

    @property
    @pulumi.getter(name="fsxLustreCsi")
    def fsx_lustre_csi(self) -> Optional[pulumi.Input['FSxLustreCSIPolicyArgs']]:
        """
        The FSx for Lustre CSI Driver IAM policy.
        """
        return pulumi.get(self, "fsx_lustre_csi")

    @fsx_lustre_csi.setter
    def fsx_lustre_csi(self, value: Optional[pulumi.Input['FSxLustreCSIPolicyArgs']]):
        pulumi.set(self, "fsx_lustre_csi", value)

    @property
    @pulumi.getter(name="karpenterController")
    def karpenter_controller(self) -> Optional[pulumi.Input['EKSKarpenterControllerPolicyArgs']]:
        """
        The Karpenter Controller policy.
        """
        return pulumi.get(self, "karpenter_controller")

    @karpenter_controller.setter
    def karpenter_controller(self, value: Optional[pulumi.Input['EKSKarpenterControllerPolicyArgs']]):
        pulumi.set(self, "karpenter_controller", value)

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional[pulumi.Input['EKSLoadBalancerPolicyArgs']]:
        """
        The Load Balancer policy.
        """
        return pulumi.get(self, "load_balancer")

    @load_balancer.setter
    def load_balancer(self, value: Optional[pulumi.Input['EKSLoadBalancerPolicyArgs']]):
        pulumi.set(self, "load_balancer", value)

    @property
    @pulumi.getter(name="nodeTerminationHandler")
    def node_termination_handler(self) -> Optional[pulumi.Input['EKSNodeTerminationHandlerPolicyArgs']]:
        """
        The Node Termination Handler policy to the role.
        """
        return pulumi.get(self, "node_termination_handler")

    @node_termination_handler.setter
    def node_termination_handler(self, value: Optional[pulumi.Input['EKSNodeTerminationHandlerPolicyArgs']]):
        pulumi.set(self, "node_termination_handler", value)

    @property
    @pulumi.getter
    def velero(self) -> Optional[pulumi.Input['EKSVeleroPolicyArgs']]:
        """
        The Velero IAM policy.
        """
        return pulumi.get(self, "velero")

    @velero.setter
    def velero(self, value: Optional[pulumi.Input['EKSVeleroPolicyArgs']]):
        pulumi.set(self, "velero", value)

    @property
    @pulumi.getter(name="vpnCni")
    def vpn_cni(self) -> Optional[pulumi.Input['EKSVPNCNIPolicyArgs']]:
        """
        The VPC CNI IAM policy to the role.
        """
        return pulumi.get(self, "vpn_cni")

    @vpn_cni.setter
    def vpn_cni(self, value: Optional[pulumi.Input['EKSVPNCNIPolicyArgs']]):
        pulumi.set(self, "vpn_cni", value)


@pulumi.input_type
class EKSServiceAccountRoleArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 permissions_boundary_arn: Optional[pulumi.Input[str]] = None,
                 policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] description: IAM Role description.
        :param pulumi.Input[str] name: IAM role name.
        :param pulumi.Input[str] name_prefix: IAM role name prefix.
        :param pulumi.Input[str] path: Path of admin IAM role.
        :param pulumi.Input[str] permissions_boundary_arn: Permissions boundary ARN to use for the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policy_arns: List of policy ARNs to use for the role.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is None:
            name = ''
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is None:
            name_prefix = ''
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if path is None:
            path = '/'
        if path is not None:
            pulumi.set(__self__, "path", path)
        if permissions_boundary_arn is None:
            permissions_boundary_arn = ''
        if permissions_boundary_arn is not None:
            pulumi.set(__self__, "permissions_boundary_arn", permissions_boundary_arn)
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        IAM Role description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role name prefix.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path of admin IAM role.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="permissionsBoundaryArn")
    def permissions_boundary_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Permissions boundary ARN to use for the role.
        """
        return pulumi.get(self, "permissions_boundary_arn")

    @permissions_boundary_arn.setter
    def permissions_boundary_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permissions_boundary_arn", value)

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of policy ARNs to use for the role.
        """
        return pulumi.get(self, "policy_arns")

    @policy_arns.setter
    def policy_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policy_arns", value)


@pulumi.input_type
class EKSVPNCNIPolicyArgs:
    def __init__(__self__, *,
                 attach: pulumi.Input[bool],
                 enable_ipv4: Optional[pulumi.Input[bool]] = None,
                 enable_ipv6: Optional[pulumi.Input[bool]] = None):
        """
        The VPC CNI IAM policy to the role.
        :param pulumi.Input[bool] attach: Determines whether to attach the VPC CNI IAM policy to the role.
        :param pulumi.Input[bool] enable_ipv4: Determines whether to enable IPv4 permissions for VPC CNI policy.
        :param pulumi.Input[bool] enable_ipv6: Determines whether to enable IPv6 permissions for VPC CNI policy.
        """
        pulumi.set(__self__, "attach", attach)
        if enable_ipv4 is not None:
            pulumi.set(__self__, "enable_ipv4", enable_ipv4)
        if enable_ipv6 is not None:
            pulumi.set(__self__, "enable_ipv6", enable_ipv6)

    @property
    @pulumi.getter
    def attach(self) -> pulumi.Input[bool]:
        """
        Determines whether to attach the VPC CNI IAM policy to the role.
        """
        return pulumi.get(self, "attach")

    @attach.setter
    def attach(self, value: pulumi.Input[bool]):
        pulumi.set(self, "attach", value)

    @property
    @pulumi.getter(name="enableIpv4")
    def enable_ipv4(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether to enable IPv4 permissions for VPC CNI policy.
        """
        return pulumi.get(self, "enable_ipv4")

    @enable_ipv4.setter
    def enable_ipv4(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ipv4", value)

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether to enable IPv6 permissions for VPC CNI policy.
        """
        return pulumi.get(self, "enable_ipv6")

    @enable_ipv6.setter
    def enable_ipv6(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ipv6", value)


@pulumi.input_type
class EKSVeleroPolicyArgs:
    def __init__(__self__, *,
                 attach: pulumi.Input[bool],
                 s3_bucket_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The Velero IAM policy to the role.
        :param pulumi.Input[bool] attach: Determines whether to attach the Velero IAM policy to the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] s3_bucket_arns: List of S3 Bucket ARNs that Velero needs access to in order to backup and restore cluster resources.
               If not provided, a default ARN of "*" will be provided.
        """
        pulumi.set(__self__, "attach", attach)
        if s3_bucket_arns is not None:
            pulumi.set(__self__, "s3_bucket_arns", s3_bucket_arns)

    @property
    @pulumi.getter
    def attach(self) -> pulumi.Input[bool]:
        """
        Determines whether to attach the Velero IAM policy to the role.
        """
        return pulumi.get(self, "attach")

    @attach.setter
    def attach(self, value: pulumi.Input[bool]):
        pulumi.set(self, "attach", value)

    @property
    @pulumi.getter(name="s3BucketArns")
    def s3_bucket_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of S3 Bucket ARNs that Velero needs access to in order to backup and restore cluster resources.
        If not provided, a default ARN of "*" will be provided.
        """
        return pulumi.get(self, "s3_bucket_arns")

    @s3_bucket_arns.setter
    def s3_bucket_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "s3_bucket_arns", value)


@pulumi.input_type
class FSxLustreCSIPolicyArgs:
    def __init__(__self__, *,
                 attach: pulumi.Input[bool],
                 service_role_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The FSx for Lustre CSI Driver IAM policy to the role.
        :param pulumi.Input[bool] attach: Determines whether to attach the FSx for Lustre CSI Driver IAM policy to the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_role_arns: Service role ARNs to allow FSx for Lustre CSI create and manage FSX for Lustre service linked roles. If not provided,
               the default ARN "arn:aws:iam::*:role/aws-service-role/s3.data-source.lustre.fsx.amazonaws.com/*" will be applied.
        """
        pulumi.set(__self__, "attach", attach)
        if service_role_arns is not None:
            pulumi.set(__self__, "service_role_arns", service_role_arns)

    @property
    @pulumi.getter
    def attach(self) -> pulumi.Input[bool]:
        """
        Determines whether to attach the FSx for Lustre CSI Driver IAM policy to the role.
        """
        return pulumi.get(self, "attach")

    @attach.setter
    def attach(self, value: pulumi.Input[bool]):
        pulumi.set(self, "attach", value)

    @property
    @pulumi.getter(name="serviceRoleArns")
    def service_role_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Service role ARNs to allow FSx for Lustre CSI create and manage FSX for Lustre service linked roles. If not provided,
        the default ARN "arn:aws:iam::*:role/aws-service-role/s3.data-source.lustre.fsx.amazonaws.com/*" will be applied.
        """
        return pulumi.get(self, "service_role_arns")

    @service_role_arns.setter
    def service_role_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "service_role_arns", value)


@pulumi.input_type
class OIDCProviderArgs:
    def __init__(__self__, *,
                 namespace_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 provider_arn: Optional[pulumi.Input[str]] = None):
        if namespace_service_accounts is not None:
            pulumi.set(__self__, "namespace_service_accounts", namespace_service_accounts)
        if provider_arn is not None:
            pulumi.set(__self__, "provider_arn", provider_arn)

    @property
    @pulumi.getter(name="namespaceServiceAccounts")
    def namespace_service_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "namespace_service_accounts")

    @namespace_service_accounts.setter
    def namespace_service_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "namespace_service_accounts", value)

    @property
    @pulumi.getter(name="providerArn")
    def provider_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "provider_arn")

    @provider_arn.setter
    def provider_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_arn", value)


@pulumi.input_type
class PoweruserRoleWithMFAArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 permissions_boundary_arn: Optional[pulumi.Input[str]] = None,
                 policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 requires_mfa: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The poweruser role.
        :param pulumi.Input[str] name: IAM role with poweruser access.
        :param pulumi.Input[str] path: Path of poweruser IAM role.
        :param pulumi.Input[str] permissions_boundary_arn: Permissions boundary ARN to use for poweruser role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policy_arns: List of policy ARNs to use for poweruser role.
        :param pulumi.Input[bool] requires_mfa: Whether admin role requires MFA.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to add.
        """
        if name is None:
            name = 'poweruser'
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is None:
            path = '/'
        if path is not None:
            pulumi.set(__self__, "path", path)
        if permissions_boundary_arn is None:
            permissions_boundary_arn = ''
        if permissions_boundary_arn is not None:
            pulumi.set(__self__, "permissions_boundary_arn", permissions_boundary_arn)
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)
        if requires_mfa is None:
            requires_mfa = True
        if requires_mfa is not None:
            pulumi.set(__self__, "requires_mfa", requires_mfa)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role with poweruser access.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path of poweruser IAM role.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="permissionsBoundaryArn")
    def permissions_boundary_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Permissions boundary ARN to use for poweruser role.
        """
        return pulumi.get(self, "permissions_boundary_arn")

    @permissions_boundary_arn.setter
    def permissions_boundary_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permissions_boundary_arn", value)

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of policy ARNs to use for poweruser role.
        """
        return pulumi.get(self, "policy_arns")

    @policy_arns.setter
    def policy_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policy_arns", value)

    @property
    @pulumi.getter(name="requiresMfa")
    def requires_mfa(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether admin role requires MFA.
        """
        return pulumi.get(self, "requires_mfa")

    @requires_mfa.setter
    def requires_mfa(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "requires_mfa", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to add.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class PoweruserRoleArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 permissions_boundary_arn: Optional[pulumi.Input[str]] = None,
                 policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The poweruser role.
        :param pulumi.Input[str] name: IAM role with poweruser access.
        :param pulumi.Input[str] path: Path of poweruser IAM role.
        :param pulumi.Input[str] permissions_boundary_arn: Permissions boundary ARN to use for poweruser role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policy_arns: List of policy ARNs to use for poweruser role.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to add.
        """
        if name is None:
            name = 'poweruser'
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is None:
            path = '/'
        if path is not None:
            pulumi.set(__self__, "path", path)
        if permissions_boundary_arn is None:
            permissions_boundary_arn = ''
        if permissions_boundary_arn is not None:
            pulumi.set(__self__, "permissions_boundary_arn", permissions_boundary_arn)
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role with poweruser access.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path of poweruser IAM role.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="permissionsBoundaryArn")
    def permissions_boundary_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Permissions boundary ARN to use for poweruser role.
        """
        return pulumi.get(self, "permissions_boundary_arn")

    @permissions_boundary_arn.setter
    def permissions_boundary_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permissions_boundary_arn", value)

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of policy ARNs to use for poweruser role.
        """
        return pulumi.get(self, "policy_arns")

    @policy_arns.setter
    def policy_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policy_arns", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to add.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class ReadonlyRoleWithMFAArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 permissions_boundary_arn: Optional[pulumi.Input[str]] = None,
                 policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 requires_mfa: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The readonly role.
        :param pulumi.Input[str] name: IAM role with readonly access.
        :param pulumi.Input[str] path: Path of readonly IAM role.
        :param pulumi.Input[str] permissions_boundary_arn: Permissions boundary ARN to use for readonly role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policy_arns: List of policy ARNs to use for readonly role.
        :param pulumi.Input[bool] requires_mfa: Whether admin role requires MFA.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to add.
        """
        if name is None:
            name = 'readonly'
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is None:
            path = '/'
        if path is not None:
            pulumi.set(__self__, "path", path)
        if permissions_boundary_arn is None:
            permissions_boundary_arn = ''
        if permissions_boundary_arn is not None:
            pulumi.set(__self__, "permissions_boundary_arn", permissions_boundary_arn)
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)
        if requires_mfa is None:
            requires_mfa = True
        if requires_mfa is not None:
            pulumi.set(__self__, "requires_mfa", requires_mfa)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role with readonly access.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path of readonly IAM role.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="permissionsBoundaryArn")
    def permissions_boundary_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Permissions boundary ARN to use for readonly role.
        """
        return pulumi.get(self, "permissions_boundary_arn")

    @permissions_boundary_arn.setter
    def permissions_boundary_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permissions_boundary_arn", value)

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of policy ARNs to use for readonly role.
        """
        return pulumi.get(self, "policy_arns")

    @policy_arns.setter
    def policy_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policy_arns", value)

    @property
    @pulumi.getter(name="requiresMfa")
    def requires_mfa(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether admin role requires MFA.
        """
        return pulumi.get(self, "requires_mfa")

    @requires_mfa.setter
    def requires_mfa(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "requires_mfa", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to add.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class ReadonlyRoleArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 permissions_boundary_arn: Optional[pulumi.Input[str]] = None,
                 policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The readonly role.
        :param pulumi.Input[str] name: IAM role with readonly access.
        :param pulumi.Input[str] path: Path of readonly IAM role.
        :param pulumi.Input[str] permissions_boundary_arn: Permissions boundary ARN to use for readonly role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policy_arns: List of policy ARNs to use for readonly role.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to add.
        """
        if name is None:
            name = 'readonly'
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is None:
            path = '/'
        if path is not None:
            pulumi.set(__self__, "path", path)
        if permissions_boundary_arn is None:
            permissions_boundary_arn = ''
        if permissions_boundary_arn is not None:
            pulumi.set(__self__, "permissions_boundary_arn", permissions_boundary_arn)
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role with readonly access.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path of readonly IAM role.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="permissionsBoundaryArn")
    def permissions_boundary_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Permissions boundary ARN to use for readonly role.
        """
        return pulumi.get(self, "permissions_boundary_arn")

    @permissions_boundary_arn.setter
    def permissions_boundary_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permissions_boundary_arn", value)

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of policy ARNs to use for readonly role.
        """
        return pulumi.get(self, "policy_arns")

    @policy_arns.setter
    def policy_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policy_arns", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to add.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class RoleWithMFAArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 permissions_boundary_arn: Optional[pulumi.Input[str]] = None,
                 policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 requires_mfa: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        An IAM role that requires MFA.
        :param pulumi.Input[str] name: IAM role with the access.
        :param pulumi.Input[str] path: Path of the IAM role.
        :param pulumi.Input[str] permissions_boundary_arn: Permissions boundary ARN to use for the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policy_arns: List of policy ARNs to use for the role.
        :param pulumi.Input[bool] requires_mfa: Whether the role requires MFA.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to add.
        """
        if name is None:
            name = 'admin'
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is None:
            path = '/'
        if path is not None:
            pulumi.set(__self__, "path", path)
        if permissions_boundary_arn is None:
            permissions_boundary_arn = ''
        if permissions_boundary_arn is not None:
            pulumi.set(__self__, "permissions_boundary_arn", permissions_boundary_arn)
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)
        if requires_mfa is None:
            requires_mfa = True
        if requires_mfa is not None:
            pulumi.set(__self__, "requires_mfa", requires_mfa)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role with the access.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path of the IAM role.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="permissionsBoundaryArn")
    def permissions_boundary_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Permissions boundary ARN to use for the role.
        """
        return pulumi.get(self, "permissions_boundary_arn")

    @permissions_boundary_arn.setter
    def permissions_boundary_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permissions_boundary_arn", value)

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of policy ARNs to use for the role.
        """
        return pulumi.get(self, "policy_arns")

    @policy_arns.setter
    def policy_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policy_arns", value)

    @property
    @pulumi.getter(name="requiresMfa")
    def requires_mfa(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the role requires MFA.
        """
        return pulumi.get(self, "requires_mfa")

    @requires_mfa.setter
    def requires_mfa(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "requires_mfa", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to add.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class RoleArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 permissions_boundary_arn: Optional[pulumi.Input[str]] = None,
                 policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        An IAM role.
        :param pulumi.Input[str] name: IAM role name.
        :param pulumi.Input[str] name_prefix: IAM role name prefix.
        :param pulumi.Input[str] path: Path of admin IAM role.
        :param pulumi.Input[str] permissions_boundary_arn: Permissions boundary ARN to use for the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policy_arns: List of policy ARNs to use for the role.
        """
        if name is None:
            name = ''
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is None:
            name_prefix = ''
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if path is None:
            path = '/'
        if path is not None:
            pulumi.set(__self__, "path", path)
        if permissions_boundary_arn is None:
            permissions_boundary_arn = ''
        if permissions_boundary_arn is not None:
            pulumi.set(__self__, "permissions_boundary_arn", permissions_boundary_arn)
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role name prefix.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path of admin IAM role.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="permissionsBoundaryArn")
    def permissions_boundary_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Permissions boundary ARN to use for the role.
        """
        return pulumi.get(self, "permissions_boundary_arn")

    @permissions_boundary_arn.setter
    def permissions_boundary_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permissions_boundary_arn", value)

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of policy ARNs to use for the role.
        """
        return pulumi.get(self, "policy_arns")

    @policy_arns.setter
    def policy_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policy_arns", value)


