# Generated by sila2.code_generator; sila2.__version__: 0.9.2
from __future__ import annotations

from typing import Optional

from sila2.framework.errors.defined_execution_error import DefinedExecutionError

from .lockcontroller_feature import LockControllerFeature


class InvalidLockIdentifier(DefinedExecutionError):
    def __init__(self, message: Optional[str] = None):
        if message is None:
            message = "The sent lock identifier is not valid."
        super().__init__(LockControllerFeature.defined_execution_errors["InvalidLockIdentifier"], message=message)


class ServerAlreadyLocked(DefinedExecutionError):
    def __init__(self, message: Optional[str] = None):
        if message is None:
            message = "The SiLA Server can not be locked because it is already locked."
        super().__init__(LockControllerFeature.defined_execution_errors["ServerAlreadyLocked"], message=message)


class ServerNotLocked(DefinedExecutionError):
    def __init__(self, message: Optional[str] = None):
        if message is None:
            message = "The SiLA Server can not be unlocked because it is not locked."
        super().__init__(LockControllerFeature.defined_execution_errors["ServerNotLocked"], message=message)
