# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['svgtrace']

package_data = \
{'': ['*']}

install_requires = \
['metprint>=2020.6,<2021.0', 'pyppeteer>=0.2.2,<0.3.0']

setup_kwargs = {
    'name': 'svgtrace',
    'version': '2020.0.3',
    'description': 'Leverage pyppeteer and the imagetrace.js library to trace a bitmap to svg in python',
    'long_description': '[![GitHub top language](https://img.shields.io/github/languages/top/FHPythonUtils/SvgTrace.svg?style=for-the-badge)](../../)\n[![Codacy grade](https://img.shields.io/codacy/grade/2a0d815f69e543ecbe38b0720b4d359b.svg?style=for-the-badge)](https://www.codacy.com/gh/FHPythonUtils/SvgTrace)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/SvgTrace.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/SvgTrace.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/SvgTrace.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/SvgTrace.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/SvgTrace.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/svgtrace.svg?style=for-the-badge)](https://pypi.org/project/svgtrace/)\n[![PyPI Version](https://img.shields.io/pypi/v/svgtrace.svg?style=for-the-badge)](https://pypi.org/project/svgtrace/)\n\n<!-- omit in TOC -->\n# SvgTrace\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\nLeverage pyppeteer and the imagetrace.js library to trace a bitmap to SVG in\npython\n\n## Example\n\nConvert the following files:\n<div>\n<img src="logo-bw.png" alt="Screenshot 1" width="300">\n<img src="logo.png" alt="Screenshot 2" width="300">\n</div>\n\n\n```python\n""" Test the image tracer """\n\nfrom pathlib import Path\nfrom svgtrace import trace\n\nTHISDIR = str(Path(__file__).resolve().parent)\n\nbw = open(THISDIR + "/logo-bw.svg", "w")\nbw.write(trace(THISDIR + "/logo-bw.png", True))\nbw.close()\ncolour = open(THISDIR + "/logo.svg", "w")\ncolour.write(trace(THISDIR + "/logo.png"))\ncolour.close()\n```\n\nOutput\n\n<div>\n<img src="logo-bw.svg" alt="Screenshot 1" width="300">\n<img src="logo.svg" alt="Screenshot 2" width="300">\n</div>\n\n\n## Install With PIP\n\n```python\npip install svgtrace\n```\n\nHead to https://pypi.org/project/svgtrace/ for more info\n\n## Language information\n### Built for\nThis program has been written for Python 3 and has been tested with\nPython version 3.8.0 <https://www.python.org/downloads/release/python-380/>.\n\n## Install Python on Windows\n### Chocolatey\n```powershell\nchoco install python\n```\n### Download\nTo install Python, go to <https://www.python.org/> and download the latest\nversion.\n\n## Install Python on Linux\n### Apt\n```bash\nsudo apt install python3.8\n```\n\n## How to run\n### With VSCode\n1. Open the .py file in vscode\n2. Ensure a python 3.8 interpreter is selected (Ctrl+Shift+P > Python:Select\nInterpreter > Python 3.8)\n3. Run by pressing Ctrl+F5 (if you are prompted to install any modules, accept)\n### From the Terminal\n```bash\n./[file].py\n```\n\n## How to update, build and publish\n\n1. Ensure you have installed the following dependencies\n\tLinux\n\t```bash\n\twget dephell.org/install | python3.8\n\twget https://raw.githubusercontent.com/python-poetry/poetry/master/get-poetry.py | python3.8\n\t```\n\tWindows\n\t```powershell\n\t(wget dephell.org/install -UseBasicParsing).Content | python\n\t(wget https://raw.githubusercontent.com/python-poetry/poetry/master/get-poetry.py -UseBasicParsing).Content | python\n\t```\n2. Use poetry for the heavy lifting and dephell to generate requirements\n\t```bash\n\tpoetry update\n\tdephell deps convert\n\t```\n3. Build/ Publish\n\t```bash\n\tpoetry build\n\tpoetry publish\n\t```\n\tor\n\t```bash\n\tpoetry publish --build\n\t```\n\n## Download\n### Clone\n#### Using The Command Line\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to\nclone to\n4. Type \'git clone\' followed by URL in step 2\n```bash\n$ git clone https://github.com/FHPythonUtils/SvgTrace\n```\n\nMore information can be found at\n<https://help.github.com/en/articles/cloning-a-repository>\n\n#### Using GitHub Desktop\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\n<https://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop>\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\n## Community Files\n### Licence\nMIT License\nCopyright (c) FredHappyface\n(See the [LICENSE](/LICENSE.md) for more information.)\n\n### Changelog\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\nIn the interest of fostering an open and welcoming environment, we\nas contributors and maintainers pledge to make participation in our\nproject and our community a harassment-free experience for everyone.\nPlease see the\n[Code of Conduct](https://github.com/FHPythonUtils/.github/blob/master/CODE_OF_CONDUCT.md) for more information.\n\n### Contributing\nContributions are welcome, please see the [Contributing Guidelines](https://github.com/FHPythonUtils/.github/blob/master/CONTRIBUTING.md) for more information.\n\n### Security\nThank you for improving the security of the project, please see the [Security Policy](https://github.com/FHPythonUtils/.github/blob/master/SECURITY.md) for more information.\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FHPythonUtils/SvgTrace',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
