# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class WebDeploymentConfigurationVersion(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        WebDeploymentConfigurationVersion - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'version': 'str',
            'description': 'str',
            'languages': 'list[str]',
            'default_language': 'str',
            'custom_i18n_labels': 'list[CustomI18nLabels]',
            'messenger': 'MessengerSettings',
            'position': 'PositionSettings',
            'support_center': 'SupportCenterSettings',
            'cobrowse': 'CobrowseSettings',
            'journey_events': 'JourneyEventsSettings',
            'authentication_settings': 'AuthenticationSettings',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'date_published': 'datetime',
            'last_modified_user': 'AddressableEntityRef',
            'created_user': 'AddressableEntityRef',
            'published_user': 'AddressableEntityRef',
            'status': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'version': 'version',
            'description': 'description',
            'languages': 'languages',
            'default_language': 'defaultLanguage',
            'custom_i18n_labels': 'customI18nLabels',
            'messenger': 'messenger',
            'position': 'position',
            'support_center': 'supportCenter',
            'cobrowse': 'cobrowse',
            'journey_events': 'journeyEvents',
            'authentication_settings': 'authenticationSettings',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'date_published': 'datePublished',
            'last_modified_user': 'lastModifiedUser',
            'created_user': 'createdUser',
            'published_user': 'publishedUser',
            'status': 'status',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._version = None
        self._description = None
        self._languages = None
        self._default_language = None
        self._custom_i18n_labels = None
        self._messenger = None
        self._position = None
        self._support_center = None
        self._cobrowse = None
        self._journey_events = None
        self._authentication_settings = None
        self._date_created = None
        self._date_modified = None
        self._date_published = None
        self._last_modified_user = None
        self._created_user = None
        self._published_user = None
        self._status = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this WebDeploymentConfigurationVersion.
        The configuration version ID

        :return: The id of this WebDeploymentConfigurationVersion.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this WebDeploymentConfigurationVersion.
        The configuration version ID

        :param id: The id of this WebDeploymentConfigurationVersion.
        :type: str
        """
        

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this WebDeploymentConfigurationVersion.
        The configuration version name

        :return: The name of this WebDeploymentConfigurationVersion.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this WebDeploymentConfigurationVersion.
        The configuration version name

        :param name: The name of this WebDeploymentConfigurationVersion.
        :type: str
        """
        

        self._name = name

    @property
    def version(self):
        """
        Gets the version of this WebDeploymentConfigurationVersion.
        The version of the configuration

        :return: The version of this WebDeploymentConfigurationVersion.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this WebDeploymentConfigurationVersion.
        The version of the configuration

        :param version: The version of this WebDeploymentConfigurationVersion.
        :type: str
        """
        

        self._version = version

    @property
    def description(self):
        """
        Gets the description of this WebDeploymentConfigurationVersion.
        The description of the configuration

        :return: The description of this WebDeploymentConfigurationVersion.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this WebDeploymentConfigurationVersion.
        The description of the configuration

        :param description: The description of this WebDeploymentConfigurationVersion.
        :type: str
        """
        

        self._description = description

    @property
    def languages(self):
        """
        Gets the languages of this WebDeploymentConfigurationVersion.
        A list of languages supported on the configuration required if the messenger is enabled

        :return: The languages of this WebDeploymentConfigurationVersion.
        :rtype: list[str]
        """
        return self._languages

    @languages.setter
    def languages(self, languages):
        """
        Sets the languages of this WebDeploymentConfigurationVersion.
        A list of languages supported on the configuration required if the messenger is enabled

        :param languages: The languages of this WebDeploymentConfigurationVersion.
        :type: list[str]
        """
        

        self._languages = languages

    @property
    def default_language(self):
        """
        Gets the default_language of this WebDeploymentConfigurationVersion.
        The default language to use for the configuration required if the messenger is enabled

        :return: The default_language of this WebDeploymentConfigurationVersion.
        :rtype: str
        """
        return self._default_language

    @default_language.setter
    def default_language(self, default_language):
        """
        Sets the default_language of this WebDeploymentConfigurationVersion.
        The default language to use for the configuration required if the messenger is enabled

        :param default_language: The default_language of this WebDeploymentConfigurationVersion.
        :type: str
        """
        

        self._default_language = default_language

    @property
    def custom_i18n_labels(self):
        """
        Gets the custom_i18n_labels of this WebDeploymentConfigurationVersion.
        The localization settings for homescreen app

        :return: The custom_i18n_labels of this WebDeploymentConfigurationVersion.
        :rtype: list[CustomI18nLabels]
        """
        return self._custom_i18n_labels

    @custom_i18n_labels.setter
    def custom_i18n_labels(self, custom_i18n_labels):
        """
        Sets the custom_i18n_labels of this WebDeploymentConfigurationVersion.
        The localization settings for homescreen app

        :param custom_i18n_labels: The custom_i18n_labels of this WebDeploymentConfigurationVersion.
        :type: list[CustomI18nLabels]
        """
        

        self._custom_i18n_labels = custom_i18n_labels

    @property
    def messenger(self):
        """
        Gets the messenger of this WebDeploymentConfigurationVersion.
        The settings for messenger

        :return: The messenger of this WebDeploymentConfigurationVersion.
        :rtype: MessengerSettings
        """
        return self._messenger

    @messenger.setter
    def messenger(self, messenger):
        """
        Sets the messenger of this WebDeploymentConfigurationVersion.
        The settings for messenger

        :param messenger: The messenger of this WebDeploymentConfigurationVersion.
        :type: MessengerSettings
        """
        

        self._messenger = messenger

    @property
    def position(self):
        """
        Gets the position of this WebDeploymentConfigurationVersion.
        The settings for position

        :return: The position of this WebDeploymentConfigurationVersion.
        :rtype: PositionSettings
        """
        return self._position

    @position.setter
    def position(self, position):
        """
        Sets the position of this WebDeploymentConfigurationVersion.
        The settings for position

        :param position: The position of this WebDeploymentConfigurationVersion.
        :type: PositionSettings
        """
        

        self._position = position

    @property
    def support_center(self):
        """
        Gets the support_center of this WebDeploymentConfigurationVersion.
        The settings for support center

        :return: The support_center of this WebDeploymentConfigurationVersion.
        :rtype: SupportCenterSettings
        """
        return self._support_center

    @support_center.setter
    def support_center(self, support_center):
        """
        Sets the support_center of this WebDeploymentConfigurationVersion.
        The settings for support center

        :param support_center: The support_center of this WebDeploymentConfigurationVersion.
        :type: SupportCenterSettings
        """
        

        self._support_center = support_center

    @property
    def cobrowse(self):
        """
        Gets the cobrowse of this WebDeploymentConfigurationVersion.
        The settings for cobrowse

        :return: The cobrowse of this WebDeploymentConfigurationVersion.
        :rtype: CobrowseSettings
        """
        return self._cobrowse

    @cobrowse.setter
    def cobrowse(self, cobrowse):
        """
        Sets the cobrowse of this WebDeploymentConfigurationVersion.
        The settings for cobrowse

        :param cobrowse: The cobrowse of this WebDeploymentConfigurationVersion.
        :type: CobrowseSettings
        """
        

        self._cobrowse = cobrowse

    @property
    def journey_events(self):
        """
        Gets the journey_events of this WebDeploymentConfigurationVersion.
        The settings for journey events

        :return: The journey_events of this WebDeploymentConfigurationVersion.
        :rtype: JourneyEventsSettings
        """
        return self._journey_events

    @journey_events.setter
    def journey_events(self, journey_events):
        """
        Sets the journey_events of this WebDeploymentConfigurationVersion.
        The settings for journey events

        :param journey_events: The journey_events of this WebDeploymentConfigurationVersion.
        :type: JourneyEventsSettings
        """
        

        self._journey_events = journey_events

    @property
    def authentication_settings(self):
        """
        Gets the authentication_settings of this WebDeploymentConfigurationVersion.
        The settings for authenticated deployments

        :return: The authentication_settings of this WebDeploymentConfigurationVersion.
        :rtype: AuthenticationSettings
        """
        return self._authentication_settings

    @authentication_settings.setter
    def authentication_settings(self, authentication_settings):
        """
        Sets the authentication_settings of this WebDeploymentConfigurationVersion.
        The settings for authenticated deployments

        :param authentication_settings: The authentication_settings of this WebDeploymentConfigurationVersion.
        :type: AuthenticationSettings
        """
        

        self._authentication_settings = authentication_settings

    @property
    def date_created(self):
        """
        Gets the date_created of this WebDeploymentConfigurationVersion.
        The date the configuration version was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this WebDeploymentConfigurationVersion.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """
        Sets the date_created of this WebDeploymentConfigurationVersion.
        The date the configuration version was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this WebDeploymentConfigurationVersion.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self):
        """
        Gets the date_modified of this WebDeploymentConfigurationVersion.
        The date the configuration version was most recently modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this WebDeploymentConfigurationVersion.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this WebDeploymentConfigurationVersion.
        The date the configuration version was most recently modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this WebDeploymentConfigurationVersion.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def date_published(self):
        """
        Gets the date_published of this WebDeploymentConfigurationVersion.
        The date the configuration version was most recently published. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_published of this WebDeploymentConfigurationVersion.
        :rtype: datetime
        """
        return self._date_published

    @date_published.setter
    def date_published(self, date_published):
        """
        Sets the date_published of this WebDeploymentConfigurationVersion.
        The date the configuration version was most recently published. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_published: The date_published of this WebDeploymentConfigurationVersion.
        :type: datetime
        """
        

        self._date_published = date_published

    @property
    def last_modified_user(self):
        """
        Gets the last_modified_user of this WebDeploymentConfigurationVersion.
        A reference to the user who most recently modified the configuration version

        :return: The last_modified_user of this WebDeploymentConfigurationVersion.
        :rtype: AddressableEntityRef
        """
        return self._last_modified_user

    @last_modified_user.setter
    def last_modified_user(self, last_modified_user):
        """
        Sets the last_modified_user of this WebDeploymentConfigurationVersion.
        A reference to the user who most recently modified the configuration version

        :param last_modified_user: The last_modified_user of this WebDeploymentConfigurationVersion.
        :type: AddressableEntityRef
        """
        

        self._last_modified_user = last_modified_user

    @property
    def created_user(self):
        """
        Gets the created_user of this WebDeploymentConfigurationVersion.
        A reference to the user who created the configuration version

        :return: The created_user of this WebDeploymentConfigurationVersion.
        :rtype: AddressableEntityRef
        """
        return self._created_user

    @created_user.setter
    def created_user(self, created_user):
        """
        Sets the created_user of this WebDeploymentConfigurationVersion.
        A reference to the user who created the configuration version

        :param created_user: The created_user of this WebDeploymentConfigurationVersion.
        :type: AddressableEntityRef
        """
        

        self._created_user = created_user

    @property
    def published_user(self):
        """
        Gets the published_user of this WebDeploymentConfigurationVersion.
        A reference to the user who published the configuration version

        :return: The published_user of this WebDeploymentConfigurationVersion.
        :rtype: AddressableEntityRef
        """
        return self._published_user

    @published_user.setter
    def published_user(self, published_user):
        """
        Sets the published_user of this WebDeploymentConfigurationVersion.
        A reference to the user who published the configuration version

        :param published_user: The published_user of this WebDeploymentConfigurationVersion.
        :type: AddressableEntityRef
        """
        

        self._published_user = published_user

    @property
    def status(self):
        """
        Gets the status of this WebDeploymentConfigurationVersion.
        The current status of the configuration version

        :return: The status of this WebDeploymentConfigurationVersion.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this WebDeploymentConfigurationVersion.
        The current status of the configuration version

        :param status: The status of this WebDeploymentConfigurationVersion.
        :type: str
        """
        allowed_values = ["Pending", "Active", "Inactive", "Error", "Deleting"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def self_uri(self):
        """
        Gets the self_uri of this WebDeploymentConfigurationVersion.
        The URI for this object

        :return: The self_uri of this WebDeploymentConfigurationVersion.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this WebDeploymentConfigurationVersion.
        The URI for this object

        :param self_uri: The self_uri of this WebDeploymentConfigurationVersion.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

