# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class RecordingJobsQuery(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        RecordingJobsQuery - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'action': 'str',
            'action_date': 'datetime',
            'integration_id': 'str',
            'include_screen_recordings': 'bool',
            'conversation_query': 'AsyncConversationQuery'
        }

        self.attribute_map = {
            'action': 'action',
            'action_date': 'actionDate',
            'integration_id': 'integrationId',
            'include_screen_recordings': 'includeScreenRecordings',
            'conversation_query': 'conversationQuery'
        }

        self._action = None
        self._action_date = None
        self._integration_id = None
        self._include_screen_recordings = None
        self._conversation_query = None

    @property
    def action(self):
        """
        Gets the action of this RecordingJobsQuery.
        Operation to perform bulk task. The date when the action will be performed can either be specified as an absolute date for all recordings with the actionDate/screenRecordingActionDate parameters, or as the number of days after each recording's creation time with the actionAge/screenRecordingActionAge parameters. If the operation will cause the delete date of a recording to be older than the export date, the export date will be adjusted to the delete date.

        :return: The action of this RecordingJobsQuery.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this RecordingJobsQuery.
        Operation to perform bulk task. The date when the action will be performed can either be specified as an absolute date for all recordings with the actionDate/screenRecordingActionDate parameters, or as the number of days after each recording's creation time with the actionAge/screenRecordingActionAge parameters. If the operation will cause the delete date of a recording to be older than the export date, the export date will be adjusted to the delete date.

        :param action: The action of this RecordingJobsQuery.
        :type: str
        """
        allowed_values = ["DELETE", "EXPORT"]
        if action.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for action -> " + action)
            self._action = "outdated_sdk_version"
        else:
            self._action = action

    @property
    def action_date(self):
        """
        Gets the action_date of this RecordingJobsQuery.
        The date when the action will be performed. If screenRecordingActionDate is also provided, this value is only used for non-screen recordings. Otherwise this value is used for all recordings. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The action_date of this RecordingJobsQuery.
        :rtype: datetime
        """
        return self._action_date

    @action_date.setter
    def action_date(self, action_date):
        """
        Sets the action_date of this RecordingJobsQuery.
        The date when the action will be performed. If screenRecordingActionDate is also provided, this value is only used for non-screen recordings. Otherwise this value is used for all recordings. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param action_date: The action_date of this RecordingJobsQuery.
        :type: datetime
        """
        

        self._action_date = action_date

    @property
    def integration_id(self):
        """
        Gets the integration_id of this RecordingJobsQuery.
        IntegrationId to Access AWS S3 bucket for bulk recording exports. This field is required and used only for EXPORT action.

        :return: The integration_id of this RecordingJobsQuery.
        :rtype: str
        """
        return self._integration_id

    @integration_id.setter
    def integration_id(self, integration_id):
        """
        Sets the integration_id of this RecordingJobsQuery.
        IntegrationId to Access AWS S3 bucket for bulk recording exports. This field is required and used only for EXPORT action.

        :param integration_id: The integration_id of this RecordingJobsQuery.
        :type: str
        """
        

        self._integration_id = integration_id

    @property
    def include_screen_recordings(self):
        """
        Gets the include_screen_recordings of this RecordingJobsQuery.
        Whether to include Screen recordings for the action, default value = true 

        :return: The include_screen_recordings of this RecordingJobsQuery.
        :rtype: bool
        """
        return self._include_screen_recordings

    @include_screen_recordings.setter
    def include_screen_recordings(self, include_screen_recordings):
        """
        Sets the include_screen_recordings of this RecordingJobsQuery.
        Whether to include Screen recordings for the action, default value = true 

        :param include_screen_recordings: The include_screen_recordings of this RecordingJobsQuery.
        :type: bool
        """
        

        self._include_screen_recordings = include_screen_recordings

    @property
    def conversation_query(self):
        """
        Gets the conversation_query of this RecordingJobsQuery.
        Conversation Query. Note: After the recording is created, it might take up to 48 hours for the recording to be included in the submitted job query.  This result depends on the analytics data lake job completion. See also: https://developer.genesys.cloud/analyticsdatamanagement/analytics/jobs/conversation-details-job#data-availability

        :return: The conversation_query of this RecordingJobsQuery.
        :rtype: AsyncConversationQuery
        """
        return self._conversation_query

    @conversation_query.setter
    def conversation_query(self, conversation_query):
        """
        Sets the conversation_query of this RecordingJobsQuery.
        Conversation Query. Note: After the recording is created, it might take up to 48 hours for the recording to be included in the submitted job query.  This result depends on the analytics data lake job completion. See also: https://developer.genesys.cloud/analyticsdatamanagement/analytics/jobs/conversation-details-job#data-availability

        :param conversation_query: The conversation_query of this RecordingJobsQuery.
        :type: AsyncConversationQuery
        """
        

        self._conversation_query = conversation_query

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

