# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class KnowledgeGuestDocument(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        KnowledgeGuestDocument - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'title': 'str',
            'visible': 'bool',
            'alternatives': 'list[KnowledgeDocumentAlternative]',
            'state': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'last_published_version_number': 'int',
            'date_published': 'datetime',
            'created_by': 'UserReference',
            'modified_by': 'UserReference',
            'document_version': 'AddressableEntityRef',
            'variations': 'list[KnowledgeGuestDocumentVariation]',
            'session_id': 'str',
            'category': 'GuestCategoryReference',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'title': 'title',
            'visible': 'visible',
            'alternatives': 'alternatives',
            'state': 'state',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'last_published_version_number': 'lastPublishedVersionNumber',
            'date_published': 'datePublished',
            'created_by': 'createdBy',
            'modified_by': 'modifiedBy',
            'document_version': 'documentVersion',
            'variations': 'variations',
            'session_id': 'sessionId',
            'category': 'category',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._title = None
        self._visible = None
        self._alternatives = None
        self._state = None
        self._date_created = None
        self._date_modified = None
        self._last_published_version_number = None
        self._date_published = None
        self._created_by = None
        self._modified_by = None
        self._document_version = None
        self._variations = None
        self._session_id = None
        self._category = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this KnowledgeGuestDocument.
        The globally unique identifier for the object.

        :return: The id of this KnowledgeGuestDocument.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this KnowledgeGuestDocument.
        The globally unique identifier for the object.

        :param id: The id of this KnowledgeGuestDocument.
        :type: str
        """
        

        self._id = id

    @property
    def title(self):
        """
        Gets the title of this KnowledgeGuestDocument.
        Document title.

        :return: The title of this KnowledgeGuestDocument.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this KnowledgeGuestDocument.
        Document title.

        :param title: The title of this KnowledgeGuestDocument.
        :type: str
        """
        

        self._title = title

    @property
    def visible(self):
        """
        Gets the visible of this KnowledgeGuestDocument.
        Indicates if the knowledge document should be included in search results.

        :return: The visible of this KnowledgeGuestDocument.
        :rtype: bool
        """
        return self._visible

    @visible.setter
    def visible(self, visible):
        """
        Sets the visible of this KnowledgeGuestDocument.
        Indicates if the knowledge document should be included in search results.

        :param visible: The visible of this KnowledgeGuestDocument.
        :type: bool
        """
        

        self._visible = visible

    @property
    def alternatives(self):
        """
        Gets the alternatives of this KnowledgeGuestDocument.
        List of alternate phrases related to the title which improves search results.

        :return: The alternatives of this KnowledgeGuestDocument.
        :rtype: list[KnowledgeDocumentAlternative]
        """
        return self._alternatives

    @alternatives.setter
    def alternatives(self, alternatives):
        """
        Sets the alternatives of this KnowledgeGuestDocument.
        List of alternate phrases related to the title which improves search results.

        :param alternatives: The alternatives of this KnowledgeGuestDocument.
        :type: list[KnowledgeDocumentAlternative]
        """
        

        self._alternatives = alternatives

    @property
    def state(self):
        """
        Gets the state of this KnowledgeGuestDocument.
        State of the document.

        :return: The state of this KnowledgeGuestDocument.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this KnowledgeGuestDocument.
        State of the document.

        :param state: The state of this KnowledgeGuestDocument.
        :type: str
        """
        allowed_values = ["Draft", "Published", "Archived"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def date_created(self):
        """
        Gets the date_created of this KnowledgeGuestDocument.
        Document creation date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this KnowledgeGuestDocument.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """
        Sets the date_created of this KnowledgeGuestDocument.
        Document creation date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this KnowledgeGuestDocument.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self):
        """
        Gets the date_modified of this KnowledgeGuestDocument.
        Document last modification date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this KnowledgeGuestDocument.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this KnowledgeGuestDocument.
        Document last modification date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this KnowledgeGuestDocument.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def last_published_version_number(self):
        """
        Gets the last_published_version_number of this KnowledgeGuestDocument.
        The last published version number of the document.

        :return: The last_published_version_number of this KnowledgeGuestDocument.
        :rtype: int
        """
        return self._last_published_version_number

    @last_published_version_number.setter
    def last_published_version_number(self, last_published_version_number):
        """
        Sets the last_published_version_number of this KnowledgeGuestDocument.
        The last published version number of the document.

        :param last_published_version_number: The last_published_version_number of this KnowledgeGuestDocument.
        :type: int
        """
        

        self._last_published_version_number = last_published_version_number

    @property
    def date_published(self):
        """
        Gets the date_published of this KnowledgeGuestDocument.
        The date on which the document was last published. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_published of this KnowledgeGuestDocument.
        :rtype: datetime
        """
        return self._date_published

    @date_published.setter
    def date_published(self, date_published):
        """
        Sets the date_published of this KnowledgeGuestDocument.
        The date on which the document was last published. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_published: The date_published of this KnowledgeGuestDocument.
        :type: datetime
        """
        

        self._date_published = date_published

    @property
    def created_by(self):
        """
        Gets the created_by of this KnowledgeGuestDocument.
        The user who created the document.

        :return: The created_by of this KnowledgeGuestDocument.
        :rtype: UserReference
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this KnowledgeGuestDocument.
        The user who created the document.

        :param created_by: The created_by of this KnowledgeGuestDocument.
        :type: UserReference
        """
        

        self._created_by = created_by

    @property
    def modified_by(self):
        """
        Gets the modified_by of this KnowledgeGuestDocument.
        The user who modified the document.

        :return: The modified_by of this KnowledgeGuestDocument.
        :rtype: UserReference
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by):
        """
        Sets the modified_by of this KnowledgeGuestDocument.
        The user who modified the document.

        :param modified_by: The modified_by of this KnowledgeGuestDocument.
        :type: UserReference
        """
        

        self._modified_by = modified_by

    @property
    def document_version(self):
        """
        Gets the document_version of this KnowledgeGuestDocument.
        The version of the document.

        :return: The document_version of this KnowledgeGuestDocument.
        :rtype: AddressableEntityRef
        """
        return self._document_version

    @document_version.setter
    def document_version(self, document_version):
        """
        Sets the document_version of this KnowledgeGuestDocument.
        The version of the document.

        :param document_version: The document_version of this KnowledgeGuestDocument.
        :type: AddressableEntityRef
        """
        

        self._document_version = document_version

    @property
    def variations(self):
        """
        Gets the variations of this KnowledgeGuestDocument.
        Variations of the document.

        :return: The variations of this KnowledgeGuestDocument.
        :rtype: list[KnowledgeGuestDocumentVariation]
        """
        return self._variations

    @variations.setter
    def variations(self, variations):
        """
        Sets the variations of this KnowledgeGuestDocument.
        Variations of the document.

        :param variations: The variations of this KnowledgeGuestDocument.
        :type: list[KnowledgeGuestDocumentVariation]
        """
        

        self._variations = variations

    @property
    def session_id(self):
        """
        Gets the session_id of this KnowledgeGuestDocument.
        ID of the guest session.

        :return: The session_id of this KnowledgeGuestDocument.
        :rtype: str
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id):
        """
        Sets the session_id of this KnowledgeGuestDocument.
        ID of the guest session.

        :param session_id: The session_id of this KnowledgeGuestDocument.
        :type: str
        """
        

        self._session_id = session_id

    @property
    def category(self):
        """
        Gets the category of this KnowledgeGuestDocument.
        The reference to category associated with the document.

        :return: The category of this KnowledgeGuestDocument.
        :rtype: GuestCategoryReference
        """
        return self._category

    @category.setter
    def category(self, category):
        """
        Sets the category of this KnowledgeGuestDocument.
        The reference to category associated with the document.

        :param category: The category of this KnowledgeGuestDocument.
        :type: GuestCategoryReference
        """
        

        self._category = category

    @property
    def self_uri(self):
        """
        Gets the self_uri of this KnowledgeGuestDocument.
        The URI for this object

        :return: The self_uri of this KnowledgeGuestDocument.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this KnowledgeGuestDocument.
        The URI for this object

        :param self_uri: The self_uri of this KnowledgeGuestDocument.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

