# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class EvaluationQuestionGroup(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        EvaluationQuestionGroup - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'type': 'str',
            'default_answers_to_highest': 'bool',
            'default_answers_to_na': 'bool',
            'na_enabled': 'bool',
            'weight': 'float',
            'manual_weight': 'bool',
            'questions': 'list[EvaluationQuestion]',
            'visibility_condition': 'VisibilityCondition'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'type': 'type',
            'default_answers_to_highest': 'defaultAnswersToHighest',
            'default_answers_to_na': 'defaultAnswersToNA',
            'na_enabled': 'naEnabled',
            'weight': 'weight',
            'manual_weight': 'manualWeight',
            'questions': 'questions',
            'visibility_condition': 'visibilityCondition'
        }

        self._id = None
        self._name = None
        self._type = None
        self._default_answers_to_highest = None
        self._default_answers_to_na = None
        self._na_enabled = None
        self._weight = None
        self._manual_weight = None
        self._questions = None
        self._visibility_condition = None

    @property
    def id(self):
        """
        Gets the id of this EvaluationQuestionGroup.


        :return: The id of this EvaluationQuestionGroup.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this EvaluationQuestionGroup.


        :param id: The id of this EvaluationQuestionGroup.
        :type: str
        """
        

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this EvaluationQuestionGroup.


        :return: The name of this EvaluationQuestionGroup.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this EvaluationQuestionGroup.


        :param name: The name of this EvaluationQuestionGroup.
        :type: str
        """
        

        self._name = name

    @property
    def type(self):
        """
        Gets the type of this EvaluationQuestionGroup.


        :return: The type of this EvaluationQuestionGroup.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this EvaluationQuestionGroup.


        :param type: The type of this EvaluationQuestionGroup.
        :type: str
        """
        

        self._type = type

    @property
    def default_answers_to_highest(self):
        """
        Gets the default_answers_to_highest of this EvaluationQuestionGroup.


        :return: The default_answers_to_highest of this EvaluationQuestionGroup.
        :rtype: bool
        """
        return self._default_answers_to_highest

    @default_answers_to_highest.setter
    def default_answers_to_highest(self, default_answers_to_highest):
        """
        Sets the default_answers_to_highest of this EvaluationQuestionGroup.


        :param default_answers_to_highest: The default_answers_to_highest of this EvaluationQuestionGroup.
        :type: bool
        """
        

        self._default_answers_to_highest = default_answers_to_highest

    @property
    def default_answers_to_na(self):
        """
        Gets the default_answers_to_na of this EvaluationQuestionGroup.


        :return: The default_answers_to_na of this EvaluationQuestionGroup.
        :rtype: bool
        """
        return self._default_answers_to_na

    @default_answers_to_na.setter
    def default_answers_to_na(self, default_answers_to_na):
        """
        Sets the default_answers_to_na of this EvaluationQuestionGroup.


        :param default_answers_to_na: The default_answers_to_na of this EvaluationQuestionGroup.
        :type: bool
        """
        

        self._default_answers_to_na = default_answers_to_na

    @property
    def na_enabled(self):
        """
        Gets the na_enabled of this EvaluationQuestionGroup.


        :return: The na_enabled of this EvaluationQuestionGroup.
        :rtype: bool
        """
        return self._na_enabled

    @na_enabled.setter
    def na_enabled(self, na_enabled):
        """
        Sets the na_enabled of this EvaluationQuestionGroup.


        :param na_enabled: The na_enabled of this EvaluationQuestionGroup.
        :type: bool
        """
        

        self._na_enabled = na_enabled

    @property
    def weight(self):
        """
        Gets the weight of this EvaluationQuestionGroup.


        :return: The weight of this EvaluationQuestionGroup.
        :rtype: float
        """
        return self._weight

    @weight.setter
    def weight(self, weight):
        """
        Sets the weight of this EvaluationQuestionGroup.


        :param weight: The weight of this EvaluationQuestionGroup.
        :type: float
        """
        

        self._weight = weight

    @property
    def manual_weight(self):
        """
        Gets the manual_weight of this EvaluationQuestionGroup.


        :return: The manual_weight of this EvaluationQuestionGroup.
        :rtype: bool
        """
        return self._manual_weight

    @manual_weight.setter
    def manual_weight(self, manual_weight):
        """
        Sets the manual_weight of this EvaluationQuestionGroup.


        :param manual_weight: The manual_weight of this EvaluationQuestionGroup.
        :type: bool
        """
        

        self._manual_weight = manual_weight

    @property
    def questions(self):
        """
        Gets the questions of this EvaluationQuestionGroup.


        :return: The questions of this EvaluationQuestionGroup.
        :rtype: list[EvaluationQuestion]
        """
        return self._questions

    @questions.setter
    def questions(self, questions):
        """
        Sets the questions of this EvaluationQuestionGroup.


        :param questions: The questions of this EvaluationQuestionGroup.
        :type: list[EvaluationQuestion]
        """
        

        self._questions = questions

    @property
    def visibility_condition(self):
        """
        Gets the visibility_condition of this EvaluationQuestionGroup.


        :return: The visibility_condition of this EvaluationQuestionGroup.
        :rtype: VisibilityCondition
        """
        return self._visibility_condition

    @visibility_condition.setter
    def visibility_condition(self, visibility_condition):
        """
        Sets the visibility_condition of this EvaluationQuestionGroup.


        :param visibility_condition: The visibility_condition of this EvaluationQuestionGroup.
        :type: VisibilityCondition
        """
        

        self._visibility_condition = visibility_condition

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

