# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ContactCallbackRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ContactCallbackRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'campaign_id': 'str',
            'contact_list_id': 'str',
            'contact_id': 'str',
            'phone_column': 'str',
            'schedule': 'str'
        }

        self.attribute_map = {
            'campaign_id': 'campaignId',
            'contact_list_id': 'contactListId',
            'contact_id': 'contactId',
            'phone_column': 'phoneColumn',
            'schedule': 'schedule'
        }

        self._campaign_id = None
        self._contact_list_id = None
        self._contact_id = None
        self._phone_column = None
        self._schedule = None

    @property
    def campaign_id(self):
        """
        Gets the campaign_id of this ContactCallbackRequest.
        Campaign identifier

        :return: The campaign_id of this ContactCallbackRequest.
        :rtype: str
        """
        return self._campaign_id

    @campaign_id.setter
    def campaign_id(self, campaign_id):
        """
        Sets the campaign_id of this ContactCallbackRequest.
        Campaign identifier

        :param campaign_id: The campaign_id of this ContactCallbackRequest.
        :type: str
        """
        

        self._campaign_id = campaign_id

    @property
    def contact_list_id(self):
        """
        Gets the contact_list_id of this ContactCallbackRequest.
        Contact list identifier

        :return: The contact_list_id of this ContactCallbackRequest.
        :rtype: str
        """
        return self._contact_list_id

    @contact_list_id.setter
    def contact_list_id(self, contact_list_id):
        """
        Sets the contact_list_id of this ContactCallbackRequest.
        Contact list identifier

        :param contact_list_id: The contact_list_id of this ContactCallbackRequest.
        :type: str
        """
        

        self._contact_list_id = contact_list_id

    @property
    def contact_id(self):
        """
        Gets the contact_id of this ContactCallbackRequest.
        Contact identifier

        :return: The contact_id of this ContactCallbackRequest.
        :rtype: str
        """
        return self._contact_id

    @contact_id.setter
    def contact_id(self, contact_id):
        """
        Sets the contact_id of this ContactCallbackRequest.
        Contact identifier

        :param contact_id: The contact_id of this ContactCallbackRequest.
        :type: str
        """
        

        self._contact_id = contact_id

    @property
    def phone_column(self):
        """
        Gets the phone_column of this ContactCallbackRequest.
        Name of the phone column containing the number to be called

        :return: The phone_column of this ContactCallbackRequest.
        :rtype: str
        """
        return self._phone_column

    @phone_column.setter
    def phone_column(self, phone_column):
        """
        Sets the phone_column of this ContactCallbackRequest.
        Name of the phone column containing the number to be called

        :param phone_column: The phone_column of this ContactCallbackRequest.
        :type: str
        """
        

        self._phone_column = phone_column

    @property
    def schedule(self):
        """
        Gets the schedule of this ContactCallbackRequest.
        The scheduled time for the callback as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ\", example = \"2016-01-02T16:59:59\"

        :return: The schedule of this ContactCallbackRequest.
        :rtype: str
        """
        return self._schedule

    @schedule.setter
    def schedule(self, schedule):
        """
        Sets the schedule of this ContactCallbackRequest.
        The scheduled time for the callback as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ\", example = \"2016-01-02T16:59:59\"

        :param schedule: The schedule of this ContactCallbackRequest.
        :type: str
        """
        

        self._schedule = schedule

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

