#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2019  David Arroyo Menéndez

# Author: David Arroyo Menéndez <davidam@gnu.org>
# Maintainer: David Arroyo Menéndez <davidam@gnu.org>

# This file is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3, or (at your option)
# any later version.

# This file is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with damepandas; see the file LICENSE.  If not, write to
# the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA 02110-1301 USA,

from unittest import TestCase

import numpy as np
import pandas as pd


class TestBasics(TestCase):

    def test_column_names(self):
        data = pd.read_csv('files/brain_size.csv', sep=';', na_values=".")
        self.assertEqual(['Row', 'Gender', 'FSIQ', 'VIQ', 'PIQ',
                          'Weight', 'Height', 'MRI_Count'], list(data.columns))

    def test_column_unique(self):
        data = pd.read_csv('files/brain_size.csv', sep=';', na_values=".")
        self.assertEqual(list(data['Gender'].unique()), ["Female", "Male"])

    def test_one_column(self):
        data = pd.read_csv('files/brain_size.csv', sep=';', na_values=".")
        self.assertEqual(list(data['Gender']),
                         ['Female', 'Male', 'Male', 'Male', 'Female',
                          'Female', 'Female', 'Female', 'Male', 'Male',
                          'Female', 'Male', 'Male', 'Female', 'Female',
                          'Female', 'Female', 'Male', 'Female', 'Male',
                          'Male', 'Male', 'Female', 'Male', 'Female',
                          'Male', 'Female', 'Male', 'Female', 'Female',
                          'Female', 'Male', 'Male', 'Male', 'Female',
                          'Female', 'Male', 'Female', 'Male', 'Male'])
