# coding: utf-8

"""
    Whisparr

    Whisparr API docs  # noqa: E501

    The version of the OpenAPI document: 3.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel
from whisparr.models.credit_type import CreditType
from whisparr.models.media_cover import MediaCover

class CreditResource(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    id: Optional[int]
    person_name: Optional[str]
    credit_tmdb_id: Optional[str]
    person_tmdb_id: Optional[int]
    movie_id: Optional[int]
    images: Optional[List]
    department: Optional[str]
    job: Optional[str]
    character: Optional[str]
    order: Optional[int]
    type: Optional[CreditType]
    __properties = ["id", "personName", "creditTmdbId", "personTmdbId", "movieId", "images", "department", "job", "character", "order", "type"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True
        alias_generator = lambda x: x.split("_")[0] + "".join(word.capitalize() for word in x.split("_")[1:])

    def __getitem__(self, item):
        return getattr(self, item)

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreditResource:
        """Create an instance of CreditResource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in images (list)
        _items = []
        if self.images:
            for _item in self.images:
                if _item:
                    _items.append(_item.to_dict())
            _dict['images'] = _items
        # set to None if person_name (nullable) is None
        if self.person_name is None:
            _dict['personName'] = None

        # set to None if credit_tmdb_id (nullable) is None
        if self.credit_tmdb_id is None:
            _dict['creditTmdbId'] = None

        # set to None if images (nullable) is None
        if self.images is None:
            _dict['images'] = None

        # set to None if department (nullable) is None
        if self.department is None:
            _dict['department'] = None

        # set to None if job (nullable) is None
        if self.job is None:
            _dict['job'] = None

        # set to None if character (nullable) is None
        if self.character is None:
            _dict['character'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreditResource:
        """Create an instance of CreditResource from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CreditResource.parse_obj(obj)

        _obj = CreditResource.parse_obj({
            "id": obj.get("id"),
            "person_name": obj.get("personName"),
            "credit_tmdb_id": obj.get("creditTmdbId"),
            "person_tmdb_id": obj.get("personTmdbId"),
            "movie_id": obj.get("movieId"),
            "images": [MediaCover.from_dict(_item) for _item in obj.get("images")] if obj.get("images") is not None else None,
            "department": obj.get("department"),
            "job": obj.get("job"),
            "character": obj.get("character"),
            "order": obj.get("order"),
            "type": obj.get("type")
        })
        return _obj

