# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['totemp']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'totemp',
    'version': '0.5.0',
    'description': 'Temperature Converter',
    'long_description': '![To Temp logo](https://raw.githubusercontent.com/eddyyxxyy/ToTemp/main/logo.png)\n\n# ToTemp\n<div style="display: inline-block">\n  <img src="https://shields.io/pypi/v/totemp"  alt="package version"/>\n  <img src="https://img.shields.io/pypi/l/totemp.svg"  alt="license"/>\n  <img src="https://results.pre-commit.ci/badge/github/eddyyxxyy/ToTemp/main.svg" alt="pre-commit.ci"/>\n</div>\n\n**ToTemp** is a temperature conversion package with Celsius, Delisle, Fahrenheit, Kelvin, Rankine, Réaumur, Newton and Rømer scales.\n\n> This package aims to bring the simple and straight to the point,\nbut precise, Object Oriented experience of working with temperature\nscale data types.\n\n---\n\n## Usage\n\nFirst of all, install the package:\n\n````shell\npip install totemp\n````\n\nor, to have an example in poetry environments:\n\n````shell\npoetry add totemp\n````\n\n> For more information, read the docs: [ToTemp Docs](\'insert link here\')\n\n### The instances:\n\n````python\nfrom totemp import Celsius, Fahrenheit\n\nif __name__ == \'__main__\':\n    temps: list = [Celsius(12), Celsius(25), Celsius(50)]\n    print(temps[0])  # \'12 ºC\'\n    print(temps)  # [Celsius(12), Celsius(25), Celsius(50)]\n\n    temps = list(map(Celsius.to_fahrenheit, temps))\n    print(temps[0])  # \'53.6 ºF\'\n    print(temps)  # [Fahrenheit(53.6), Fahrenheit(77.0), Fahrenheit(122.0)]\n````\n\n### It\'s representations and properties:\n\n> Property *`symbol`* is **read-only**.\n\n````python\nfrom totemp import Fahrenheit\n\nif __name__ == \'__main__\':\n    temp0 = Fahrenheit(53.6)\n    print(temp0.__repr__())  # \'Fahrenheit(53.6)\'\n    print(temp0.__str__())  # \'53.6 ºF\'\n    print(temp0.symbol)  # \'ºF\'\n    print(temp0.value)  # 53.6\n````\n\n### Comparision operations (\'==\', \'!=\', \'>\', \'>=\', \'<\',...):\n\n> The comparision/arithmetic implementation attempts to convert the value of `other` (if it is a temperature instance) and then evaluate the expression.\n\n````python\nimport totemp as tp\n\nif __name__ == \'__main__\':\n    temp0, temp1 = tp.Celsius(0), tp.Fahrenheit(32)\n\n    print(f\'temp0: {repr(temp0)}\')  # Celsius(0)\n    print(f\'temp1: {repr(temp1.to_celsius())}\')  # Celsius(0.0)\n\n    print(temp0 != temp1)  # False\n\n    print(temp0 > temp1)  # False\n\n    print(temp0 < temp1)  # False\n\n    print(temp0 >= temp1)  # True\n\n    print(temp0 <= temp1)  # True\n\n    print(temp0 == temp1)  # True\n````\n\n### Arithmetic operations (\'+\', \'-\', \'*\', \'**\', \'/\', \'//\', \'%\', ...):\n\n````python\nfrom totemp import Newton, Rankine\n\nif __name__ == \'__main__\':\n    temp0 = Newton(33)\n    temp1 = Rankine(671.67)\n\n    temp2 = temp0 + temp1\n\n    print(\'temp2:\', temp2)  # temp2: 65.99999999999999 ºN\n    print(\'temp2:\', repr(temp2))  # temp2: Newton(65.99999999999999)\n    print(\'temp2:\', temp2.value, temp2.symbol)  # temp2: 65.99999999999999 ºN\n\n    print((temp0 + temp1).rounded())  # 66 ºN\n    print(repr((temp0 + temp1).rounded()))  # Newton(66)\n\n    print(temp2 + 12.55)  # 78.54999999999998 ºN\n    print((12 + temp2.rounded()))  # 78 ºN\n````\n\n### ToTemp classes can work with many built-in Python functions:\n\n````python\nfrom math import floor, ceil, trunc\n\nfrom totemp import Reaumur\n\nif __name__ == \'__main__\':\n    temp = Reaumur(100.4)\n\n    float(temp)  # 100.4\n    int(temp)  # 100\n    round(temp)  # Reaumur(100)\n    abs(temp)  # Reaumur(100)\n    floor(temp)  # Reaumur(100)\n    ceil(temp)  # Reaumur(101)\n    trunc(temp)  # Reaumur(100)\n    divmod(temp, temp0 := Reaumur(25.1))  # (Reaumur(4.0), Reaumur(0.0))\n\n````\n\n\n\n### Temperature Instance Conversions:\n\n````python\nimport totemp\n\nif __name__ == \'__main__\':\n    temp = totemp.Fahrenheit(32)\n\n    print(temp.to_celsius())  # 0.0 ºC\n    print(temp.to_fahrenheit())  # 32 ºF\n    print(temp.to_delisle())  # 150.0 ºDe\n    print(temp.to_kelvin())  # 273.15 K\n    print(temp.to_newton())  # 0.0 ºN\n    print(temp.to_rankine())  # 491.67 ºR\n    print(temp.to_reaumur())  # 0.0 ºRé\n    print(temp.to_romer())  # 7.5 ºRø\n````\n\n## Changelog\n\n---\n\n- _0.1.0_:\n  - Yanked, not functional;\n- _0.2.0_:\n  - Functional;\n  - Can convert Celsius to Delisle, Fahrenheit, Kelvin, Newton, Rankine, Réaumur and Rømer.\n- _0.3.0_:\n  - Changed methods implementations and adds Fahrenheit conversions;\n      - <scale_value> parameter is now positional-only;\n      - Adds new parameter -> float_ret -> Float Return (True by default, keyword-only);\n      - Celsius class methods were updated and enhanced;\n      - Can now convert Fahrenheit to Celsius, Delisle, Kelvin, Newton, Rankine, Réaumur and Rømer.\n- _0.4.0_:\n  - There are two new Classes, Kelvin and Delisle, functional and ready-to-use.\n\n- **0.5.0**:\n  - The implementation has been **completely refactored**:\n\n    1 - ***All classes inhehits from `AbstractTemperature`** (our new abstract  Base Class)*;\n\n    2 - ***All classes now available***:\n      - *`Celsius`;*\n      - *`Fahrenheit`;*\n      - *`Delisle`;*\n      - *`Kelvin`;*\n      - ***(\\*New)** `Newton`;*\n      - ***(\\*New)** `Rankine`;*\n      - ***(\\*New)** `Réaumur`;*\n      - ***(\\*New)** `Rømer`.*\n\n    3 - ***New features***:\n      - *The majority of Python\'s built-in functions works with the instances*;\n      - *More pythonic properties and methods implementations*;\n      - *Arithmetic operations;*\n      - *Comparision operations;*\n      - *`convert_to()` method;*\n\n    4 - ***Removals***:\n      - *`precise()` method;*\n      - *`float_ret()` param;*\n      - *differentiating int/float;*\n\n    5 - ***Known problemns***:\n      - *`pow()` doesn\'t work as intended;*\n\n---\n\n## License\n\nFor more information, check LICENSE file.\n',
    'author': 'Edson Pimenta',
    'author_email': 'edson.tibo@gmail.com',
    'maintainer': 'Edson Pimenta',
    'maintainer_email': 'edson.tibo@gmail.com',
    'url': 'https://github.com/eddyyxxyy/ToTemp',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
